/*******************************************************************************
 * Copyright (c) 2018 SAP SE and others.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Andreas Sewe - initial API and implementation
 *******************************************************************************/
package org.eclipse.tycho.test.surefire;

import static org.eclipse.tycho.test.util.SurefireUtil.assertNumberOfErrorneousTests;
import static org.eclipse.tycho.test.util.SurefireUtil.assertNumberOfFailedTests;
import static org.eclipse.tycho.test.util.SurefireUtil.assertNumberOfSkippedTests;
import static org.eclipse.tycho.test.util.SurefireUtil.assertNumberOfSuccessfulTests;

import java.util.Properties;

import org.apache.maven.it.Verifier;
import org.eclipse.tycho.test.AbstractTychoIntegrationTest;
import org.eclipse.tycho.test.util.ResourceUtil.P2Repositories;
import org.junit.Test;

public class OpenTest4JTest extends AbstractTychoIntegrationTest {

    @Test
    public void testOpenTest4JUsage() throws Exception {
        Verifier verifier = getVerifier("/surefire.opentest4j/bundle.test", false);
        Properties props = verifier.getSystemProperties();
        props.setProperty("target-platform", P2Repositories.ECLIPSE_LATEST.toString());

        verifier.setSystemProperty("maven.test.error.ignore", Boolean.toString(true));
        verifier.setSystemProperty("maven.test.failure.ignore", Boolean.toString(true));
        verifier.executeGoal("verify");

        String projectBasedir = verifier.getBasedir();
        assertNumberOfSuccessfulTests(projectBasedir, "bundle.test.OpenTest4JTest", 5);
        assertNumberOfFailedTests(projectBasedir, "bundle.test.OpenTest4JTest", 2);
        assertNumberOfSkippedTests(projectBasedir, "bundle.test.OpenTest4JTest", 2);
        assertNumberOfErrorneousTests(projectBasedir, "bundle.test.OpenTest4JTest", 0);
    }
}
