#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 3206
#define LARGE_STATE_COUNT 714
#define SYMBOL_COUNT 299
#define ALIAS_COUNT 8
#define TOKEN_COUNT 141
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 9

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_EQ = 6,
  anon_sym_as = 7,
  anon_sym_namespace = 8,
  anon_sym_LBRACE = 9,
  anon_sym_COMMA = 10,
  anon_sym_RBRACE = 11,
  anon_sym_type = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_var = 16,
  anon_sym_let = 17,
  anon_sym_const = 18,
  anon_sym_if = 19,
  anon_sym_else = 20,
  anon_sym_switch = 21,
  anon_sym_for = 22,
  anon_sym_LPAREN = 23,
  anon_sym_RPAREN = 24,
  anon_sym_await = 25,
  anon_sym_in = 26,
  anon_sym_of = 27,
  anon_sym_while = 28,
  anon_sym_do = 29,
  anon_sym_try = 30,
  anon_sym_with = 31,
  anon_sym_break = 32,
  anon_sym_continue = 33,
  anon_sym_debugger = 34,
  anon_sym_return = 35,
  anon_sym_throw = 36,
  anon_sym_SEMI = 37,
  anon_sym_COLON = 38,
  anon_sym_case = 39,
  anon_sym_catch = 40,
  anon_sym_finally = 41,
  anon_sym_yield = 42,
  anon_sym_LBRACK = 43,
  anon_sym_RBRACK = 44,
  anon_sym_LT = 45,
  anon_sym_GT = 46,
  anon_sym_SLASH = 47,
  anon_sym_DOT = 48,
  anon_sym_class = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_new = 53,
  anon_sym_PLUS_EQ = 54,
  anon_sym_DASH_EQ = 55,
  anon_sym_STAR_EQ = 56,
  anon_sym_SLASH_EQ = 57,
  anon_sym_PERCENT_EQ = 58,
  anon_sym_CARET_EQ = 59,
  anon_sym_AMP_EQ = 60,
  anon_sym_PIPE_EQ = 61,
  anon_sym_GT_GT_EQ = 62,
  anon_sym_GT_GT_GT_EQ = 63,
  anon_sym_LT_LT_EQ = 64,
  anon_sym_STAR_STAR_EQ = 65,
  anon_sym_DOT_DOT_DOT = 66,
  anon_sym_QMARK = 67,
  anon_sym_AMP_AMP = 68,
  anon_sym_PIPE_PIPE = 69,
  anon_sym_GT_GT = 70,
  anon_sym_GT_GT_GT = 71,
  anon_sym_LT_LT = 72,
  anon_sym_AMP = 73,
  anon_sym_CARET = 74,
  anon_sym_PIPE = 75,
  anon_sym_PLUS = 76,
  anon_sym_DASH = 77,
  anon_sym_PERCENT = 78,
  anon_sym_STAR_STAR = 79,
  anon_sym_LT_EQ = 80,
  anon_sym_EQ_EQ = 81,
  anon_sym_EQ_EQ_EQ = 82,
  anon_sym_BANG_EQ = 83,
  anon_sym_BANG_EQ_EQ = 84,
  anon_sym_GT_EQ = 85,
  anon_sym_QMARK_QMARK = 86,
  anon_sym_instanceof = 87,
  anon_sym_BANG = 88,
  anon_sym_TILDE = 89,
  anon_sym_void = 90,
  anon_sym_delete = 91,
  anon_sym_PLUS_PLUS = 92,
  anon_sym_DASH_DASH = 93,
  anon_sym_DQUOTE = 94,
  aux_sym_string_token1 = 95,
  anon_sym_SQUOTE = 96,
  aux_sym_string_token2 = 97,
  sym_escape_sequence = 98,
  sym_comment = 99,
  anon_sym_BQUOTE = 100,
  anon_sym_DOLLAR_LBRACE = 101,
  anon_sym_SLASH2 = 102,
  sym_regex_pattern = 103,
  sym_regex_flags = 104,
  sym_number = 105,
  anon_sym_target = 106,
  sym_this = 107,
  sym_super = 108,
  sym_true = 109,
  sym_false = 110,
  sym_null = 111,
  sym_undefined = 112,
  anon_sym_AT = 113,
  anon_sym_static = 114,
  anon_sym_abstract = 115,
  anon_sym_get = 116,
  anon_sym_set = 117,
  anon_sym_declare = 118,
  anon_sym_public = 119,
  anon_sym_private = 120,
  anon_sym_protected = 121,
  anon_sym_module = 122,
  anon_sym_any = 123,
  anon_sym_number = 124,
  anon_sym_boolean = 125,
  anon_sym_string = 126,
  anon_sym_symbol = 127,
  anon_sym_require = 128,
  anon_sym_implements = 129,
  anon_sym_global = 130,
  anon_sym_interface = 131,
  anon_sym_extends = 132,
  anon_sym_enum = 133,
  sym_readonly = 134,
  anon_sym_is = 135,
  anon_sym_keyof = 136,
  anon_sym_LBRACE_PIPE = 137,
  anon_sym_PIPE_RBRACE = 138,
  sym__automatic_semicolon = 139,
  sym__template_chars = 140,
  sym_program = 141,
  sym_export_statement = 142,
  sym_export_clause = 143,
  sym__import_export_specifier = 144,
  sym__declaration = 145,
  sym_import = 146,
  sym_import_statement = 147,
  sym_import_clause = 148,
  sym__from_clause = 149,
  sym_namespace_import = 150,
  sym_named_imports = 151,
  sym_expression_statement = 152,
  sym_variable_declaration = 153,
  sym_lexical_declaration = 154,
  sym_variable_declarator = 155,
  sym_statement_block = 156,
  sym_if_statement = 157,
  sym_switch_statement = 158,
  sym_for_statement = 159,
  sym_for_in_statement = 160,
  sym__for_header = 161,
  sym_while_statement = 162,
  sym_do_statement = 163,
  sym_try_statement = 164,
  sym_with_statement = 165,
  sym_break_statement = 166,
  sym_continue_statement = 167,
  sym_debugger_statement = 168,
  sym_return_statement = 169,
  sym_throw_statement = 170,
  sym_empty_statement = 171,
  sym_labeled_statement = 172,
  sym_switch_body = 173,
  sym_switch_case = 174,
  sym_switch_default = 175,
  sym_catch_clause = 176,
  sym_finally_clause = 177,
  sym_parenthesized_expression = 178,
  sym__expression = 179,
  sym_yield_expression = 180,
  sym_object = 181,
  sym_assignment_pattern = 182,
  sym_array = 183,
  sym_nested_identifier = 184,
  sym_class = 185,
  sym_class_declaration = 186,
  sym_class_heritage = 187,
  sym_function = 188,
  sym_function_declaration = 189,
  sym_generator_function = 190,
  sym_generator_function_declaration = 191,
  sym_arrow_function = 192,
  sym__call_signature = 193,
  sym_call_expression = 194,
  sym_new_expression = 195,
  sym_await_expression = 196,
  sym_member_expression = 197,
  sym_subscript_expression = 198,
  sym_assignment_expression = 199,
  sym_augmented_assignment_expression = 200,
  sym__initializer = 201,
  sym_spread_element = 202,
  sym_ternary_expression = 203,
  sym_binary_expression = 204,
  sym_unary_expression = 205,
  sym_update_expression = 206,
  sym_sequence_expression = 207,
  sym_string = 208,
  sym_template_string = 209,
  sym_template_substitution = 210,
  sym_regex = 211,
  sym_meta_property = 212,
  sym_arguments = 213,
  sym_decorator = 214,
  sym_decorator_member_expression = 215,
  sym_decorator_call_expression = 216,
  sym_class_body = 217,
  sym_public_field_definition = 218,
  sym_formal_parameters = 219,
  sym_rest_parameter = 220,
  sym_method_definition = 221,
  sym_pair = 222,
  sym__property_name = 223,
  sym_computed_property_name = 224,
  sym_non_null_expression = 225,
  sym_method_signature = 226,
  sym_abstract_method_signature = 227,
  sym_function_signature = 228,
  sym_type_assertion = 229,
  sym_as_expression = 230,
  sym_import_require_clause = 231,
  sym_implements_clause = 232,
  sym_ambient_declaration = 233,
  sym_abstract_class_declaration = 234,
  sym_module = 235,
  sym_internal_module = 236,
  sym__module = 237,
  sym_import_alias = 238,
  sym_nested_type_identifier = 239,
  sym_interface_declaration = 240,
  sym_extends_clause = 241,
  sym_enum_declaration = 242,
  sym_enum_body = 243,
  sym_enum_assignment = 244,
  sym_type_alias_declaration = 245,
  sym_accessibility_modifier = 246,
  sym_required_parameter = 247,
  sym_optional_parameter = 248,
  sym__parameter_name = 249,
  sym_type_annotation = 250,
  sym__type = 251,
  sym_constructor_type = 252,
  sym__primary_type = 253,
  sym_generic_type = 254,
  sym_type_predicate = 255,
  sym_type_query = 256,
  sym_index_type_query = 257,
  sym_lookup_type = 258,
  sym_mapped_type_clause = 259,
  sym_literal_type = 260,
  sym__number = 261,
  sym_existential_type = 262,
  sym_flow_maybe_type = 263,
  sym_parenthesized_type = 264,
  sym_predefined_type = 265,
  sym_type_arguments = 266,
  sym_object_type = 267,
  sym_call_signature = 268,
  sym_property_signature = 269,
  sym_type_parameters = 270,
  sym_type_parameter = 271,
  sym_default_type = 272,
  sym_constraint = 273,
  sym_construct_signature = 274,
  sym_index_signature = 275,
  sym_array_type = 276,
  sym_tuple_type = 277,
  sym_union_type = 278,
  sym_intersection_type = 279,
  sym_function_type = 280,
  aux_sym_program_repeat1 = 281,
  aux_sym_export_statement_repeat1 = 282,
  aux_sym_export_clause_repeat1 = 283,
  aux_sym_named_imports_repeat1 = 284,
  aux_sym_variable_declaration_repeat1 = 285,
  aux_sym_switch_body_repeat1 = 286,
  aux_sym_object_repeat1 = 287,
  aux_sym_array_repeat1 = 288,
  aux_sym_string_repeat1 = 289,
  aux_sym_string_repeat2 = 290,
  aux_sym_template_string_repeat1 = 291,
  aux_sym_class_body_repeat1 = 292,
  aux_sym_formal_parameters_repeat1 = 293,
  aux_sym_implements_clause_repeat1 = 294,
  aux_sym_extends_clause_repeat1 = 295,
  aux_sym_enum_body_repeat1 = 296,
  aux_sym_object_type_repeat1 = 297,
  aux_sym_type_parameters_repeat1 = 298,
  alias_sym_array_pattern = 299,
  alias_sym_export_specifier = 300,
  alias_sym_import_specifier = 301,
  alias_sym_object_pattern = 302,
  alias_sym_property_identifier = 303,
  alias_sym_shorthand_property_identifier = 304,
  alias_sym_statement_identifier = 305,
  alias_sym_type_identifier = 306,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_type] = "type",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "??",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_abstract] = "abstract",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_require] = "require",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_extends] = "extends",
  [anon_sym_enum] = "enum",
  [sym_readonly] = "readonly",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "_import_export_specifier",
  [sym__declaration] = "_declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__expression] = "_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_array] = "array",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_rest_parameter] = "rest_parameter",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_clause] = "extends_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_type_annotation] = "type_annotation",
  [sym__type] = "_type",
  [sym_constructor_type] = "constructor_type",
  [sym__primary_type] = "_primary_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_array_pattern] = "array_pattern",
  [alias_sym_export_specifier] = "export_specifier",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_object_pattern] = "object_pattern",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_enum] = anon_sym_enum,
  [sym_readonly] = sym_readonly,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym__declaration] = sym__declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__expression] = sym__expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_array] = sym_array,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_rest_parameter] = sym_rest_parameter,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_clause] = sym_extends_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type] = sym__type,
  [sym_constructor_type] = sym_constructor_type,
  [sym__primary_type] = sym__primary_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_array_pattern] = alias_sym_array_pattern,
  [alias_sym_export_specifier] = alias_sym_export_specifier,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_object_pattern] = alias_sym_object_pattern,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [sym_readonly] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_type] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_constructor = 8,
  field_declaration = 9,
  field_decorator = 10,
  field_finalizer = 11,
  field_flags = 12,
  field_function = 13,
  field_handler = 14,
  field_increment = 15,
  field_index = 16,
  field_initializer = 17,
  field_key = 18,
  field_label = 19,
  field_left = 20,
  field_module = 21,
  field_name = 22,
  field_object = 23,
  field_operator = 24,
  field_parameter = 25,
  field_parameters = 26,
  field_pattern = 27,
  field_property = 28,
  field_return_type = 29,
  field_right = 30,
  field_source = 31,
  field_type = 32,
  field_type_arguments = 33,
  field_type_parameters = 34,
  field_value = 35,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[187] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 3, .length = 1},
  [10] = {.index = 3, .length = 1},
  [13] = {.index = 8, .length = 1},
  [15] = {.index = 9, .length = 1},
  [16] = {.index = 9, .length = 1},
  [17] = {.index = 10, .length = 2},
  [19] = {.index = 12, .length = 2},
  [20] = {.index = 14, .length = 2},
  [21] = {.index = 16, .length = 2},
  [22] = {.index = 18, .length = 2},
  [23] = {.index = 20, .length = 2},
  [24] = {.index = 22, .length = 1},
  [25] = {.index = 23, .length = 2},
  [26] = {.index = 25, .length = 2},
  [27] = {.index = 27, .length = 2},
  [29] = {.index = 29, .length = 2},
  [30] = {.index = 31, .length = 2},
  [31] = {.index = 29, .length = 2},
  [32] = {.index = 31, .length = 2},
  [33] = {.index = 29, .length = 2},
  [34] = {.index = 31, .length = 2},
  [35] = {.index = 33, .length = 2},
  [36] = {.index = 35, .length = 2},
  [37] = {.index = 37, .length = 3},
  [40] = {.index = 40, .length = 1},
  [41] = {.index = 41, .length = 2},
  [42] = {.index = 43, .length = 2},
  [43] = {.index = 45, .length = 2},
  [44] = {.index = 47, .length = 2},
  [45] = {.index = 49, .length = 1},
  [46] = {.index = 50, .length = 3},
  [48] = {.index = 53, .length = 1},
  [49] = {.index = 54, .length = 2},
  [50] = {.index = 56, .length = 1},
  [51] = {.index = 57, .length = 2},
  [52] = {.index = 59, .length = 4},
  [53] = {.index = 63, .length = 2},
  [54] = {.index = 65, .length = 2},
  [55] = {.index = 63, .length = 2},
  [56] = {.index = 65, .length = 2},
  [57] = {.index = 20, .length = 2},
  [58] = {.index = 23, .length = 2},
  [59] = {.index = 25, .length = 2},
  [60] = {.index = 67, .length = 3},
  [61] = {.index = 10, .length = 2},
  [62] = {.index = 54, .length = 2},
  [63] = {.index = 70, .length = 3},
  [64] = {.index = 20, .length = 2},
  [65] = {.index = 20, .length = 2},
  [66] = {.index = 73, .length = 4},
  [67] = {.index = 77, .length = 3},
  [68] = {.index = 80, .length = 2},
  [69] = {.index = 82, .length = 1},
  [70] = {.index = 83, .length = 1},
  [71] = {.index = 84, .length = 1},
  [72] = {.index = 85, .length = 1},
  [73] = {.index = 86, .length = 2},
  [74] = {.index = 20, .length = 2},
  [75] = {.index = 88, .length = 2},
  [76] = {.index = 90, .length = 5},
  [77] = {.index = 86, .length = 2},
  [78] = {.index = 95, .length = 1},
  [79] = {.index = 96, .length = 3},
  [80] = {.index = 96, .length = 3},
  [81] = {.index = 96, .length = 3},
  [82] = {.index = 99, .length = 2},
  [83] = {.index = 101, .length = 3},
  [87] = {.index = 104, .length = 1},
  [88] = {.index = 105, .length = 3},
  [89] = {.index = 108, .length = 4},
  [90] = {.index = 112, .length = 2},
  [91] = {.index = 114, .length = 2},
  [92] = {.index = 116, .length = 2},
  [93] = {.index = 118, .length = 3},
  [94] = {.index = 121, .length = 2},
  [95] = {.index = 123, .length = 2},
  [96] = {.index = 125, .length = 4},
  [97] = {.index = 123, .length = 2},
  [98] = {.index = 129, .length = 4},
  [99] = {.index = 133, .length = 4},
  [100] = {.index = 137, .length = 5},
  [101] = {.index = 142, .length = 3},
  [102] = {.index = 142, .length = 3},
  [103] = {.index = 145, .length = 2},
  [104] = {.index = 99, .length = 2},
  [105] = {.index = 147, .length = 3},
  [106] = {.index = 150, .length = 2},
  [107] = {.index = 152, .length = 3},
  [108] = {.index = 155, .length = 2},
  [109] = {.index = 157, .length = 5},
  [110] = {.index = 162, .length = 2},
  [111] = {.index = 164, .length = 1},
  [112] = {.index = 165, .length = 3},
  [113] = {.index = 168, .length = 1},
  [114] = {.index = 169, .length = 1},
  [115] = {.index = 170, .length = 1},
  [116] = {.index = 171, .length = 2},
  [117] = {.index = 173, .length = 1},
  [118] = {.index = 174, .length = 2},
  [119] = {.index = 176, .length = 4},
  [120] = {.index = 180, .length = 2},
  [121] = {.index = 182, .length = 2},
  [122] = {.index = 184, .length = 2},
  [123] = {.index = 186, .length = 3},
  [124] = {.index = 189, .length = 4},
  [125] = {.index = 193, .length = 4},
  [126] = {.index = 197, .length = 5},
  [127] = {.index = 202, .length = 2},
  [128] = {.index = 204, .length = 3},
  [129] = {.index = 207, .length = 3},
  [130] = {.index = 210, .length = 2},
  [131] = {.index = 212, .length = 3},
  [132] = {.index = 215, .length = 4},
  [133] = {.index = 219, .length = 3},
  [134] = {.index = 222, .length = 2},
  [135] = {.index = 224, .length = 5},
  [136] = {.index = 229, .length = 3},
  [137] = {.index = 232, .length = 2},
  [138] = {.index = 232, .length = 2},
  [139] = {.index = 234, .length = 3},
  [140] = {.index = 232, .length = 2},
  [141] = {.index = 232, .length = 2},
  [142] = {.index = 237, .length = 2},
  [143] = {.index = 239, .length = 4},
  [144] = {.index = 243, .length = 2},
  [145] = {.index = 245, .length = 2},
  [146] = {.index = 247, .length = 1},
  [147] = {.index = 248, .length = 2},
  [148] = {.index = 250, .length = 2},
  [149] = {.index = 252, .length = 3},
  [150] = {.index = 255, .length = 3},
  [151] = {.index = 258, .length = 5},
  [152] = {.index = 263, .length = 3},
  [154] = {.index = 266, .length = 4},
  [155] = {.index = 270, .length = 5},
  [156] = {.index = 275, .length = 2},
  [157] = {.index = 275, .length = 2},
  [158] = {.index = 275, .length = 2},
  [159] = {.index = 275, .length = 2},
  [160] = {.index = 277, .length = 4},
  [161] = {.index = 281, .length = 2},
  [162] = {.index = 281, .length = 2},
  [163] = {.index = 281, .length = 2},
  [164] = {.index = 283, .length = 4},
  [165] = {.index = 287, .length = 4},
  [166] = {.index = 291, .length = 2},
  [167] = {.index = 293, .length = 2},
  [168] = {.index = 295, .length = 2},
  [169] = {.index = 297, .length = 3},
  [170] = {.index = 300, .length = 3},
  [171] = {.index = 303, .length = 2},
  [172] = {.index = 305, .length = 5},
  [173] = {.index = 310, .length = 5},
  [174] = {.index = 315, .length = 4},
  [175] = {.index = 319, .length = 4},
  [176] = {.index = 323, .length = 2},
  [177] = {.index = 325, .length = 3},
  [178] = {.index = 328, .length = 2},
  [179] = {.index = 330, .length = 3},
  [180] = {.index = 333, .length = 5},
  [181] = {.index = 338, .length = 5},
  [182] = {.index = 343, .length = 4},
  [183] = {.index = 347, .length = 4},
  [184] = {.index = 351, .length = 3},
  [185] = {.index = 354, .length = 5},
  [186] = {.index = 359, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_body, 1},
  [9] =
    {field_constructor, 1},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_argument, 0},
    {field_operator, 1},
  [14] =
    {field_parameters, 0},
    {field_return_type, 1},
  [16] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [18] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [20] =
    {field_left, 0},
    {field_right, 2},
  [22] =
    {field_label, 0},
  [23] =
    {field_object, 0},
    {field_property, 2},
  [25] =
    {field_body, 2},
    {field_parameter, 0},
  [27] =
    {field_body, 1},
    {field_name, 0},
  [29] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [31] =
    {field_name, 0},
    {field_type, 1},
  [33] =
    {field_condition, 1},
    {field_consequence, 2},
  [35] =
    {field_body, 2},
    {field_value, 1},
  [37] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [40] =
    {field_value, 1, .inherited = true},
  [41] =
    {field_body, 2},
    {field_condition, 1},
  [43] =
    {field_body, 1},
    {field_handler, 2},
  [45] =
    {field_body, 1},
    {field_finalizer, 2},
  [47] =
    {field_body, 2},
    {field_object, 1},
  [49] =
    {field_label, 1},
  [50] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [53] =
    {field_pattern, 1},
  [54] =
    {field_body, 2},
    {field_name, 1},
  [56] =
    {field_body, 2},
  [57] =
    {field_body, 2},
    {field_type_parameters, 1},
  [59] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [63] =
    {field_arguments, 2},
    {field_constructor, 1},
  [65] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [67] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [70] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [73] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [77] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [80] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [82] =
    {field_source, 1},
  [83] =
    {field_source, 2, .inherited = true},
  [84] =
    {field_value, 2},
  [85] =
    {field_name, 1},
  [86] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [88] =
    {field_key, 0},
    {field_value, 2},
  [90] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [95] =
    {field_value, 1},
  [96] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [99] =
    {field_body, 3},
    {field_name, 2},
  [101] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [104] =
    {field_value, 2, .inherited = true},
  [105] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [108] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [112] =
    {field_module, 0},
    {field_name, 2},
  [114] =
    {field_flags, 3},
    {field_pattern, 1},
  [116] =
    {field_body, 3},
    {field_name, 1},
  [118] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [121] =
    {field_body, 3},
    {field_type_parameters, 1},
  [123] =
    {field_body, 3},
    {field_parameter, 1},
  [125] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [129] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [133] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [137] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [142] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [145] =
    {field_index, 2},
    {field_object, 0},
  [147] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [150] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [152] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [155] =
    {field_alias, 2},
    {field_name, 0},
  [157] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [162] =
    {field_name, 1},
    {field_value, 3},
  [164] =
    {field_source, 3, .inherited = true},
  [165] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [168] =
    {field_decorator, 1, .inherited = true},
  [169] =
    {field_decorator, 2, .inherited = true},
  [170] =
    {field_value, 3, .inherited = true},
  [171] =
    {field_body, 1},
    {field_condition, 3},
  [173] =
    {field_name, 2},
  [174] =
    {field_name, 1},
    {field_type, 2},
  [176] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [180] =
    {field_name, 0},
    {field_type, 2},
  [182] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [184] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [186] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [189] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [193] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [197] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [202] =
    {field_body, 4},
    {field_name, 2},
  [204] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [207] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [210] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [212] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [215] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [219] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [222] =
    {field_alias, 3},
    {field_name, 1},
  [224] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [229] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [232] =
    {field_left, 1},
    {field_right, 3},
  [234] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [237] =
    {field_decorator, 1, .inherited = true},
    {field_decorator, 3, .inherited = true},
  [239] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [243] =
    {field_name, 2},
    {field_type, 3},
  [245] =
    {field_name, 1},
    {field_type, 3},
  [247] =
    {field_name, 3},
  [248] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [250] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [252] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [255] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [258] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [263] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [266] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [270] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [275] =
    {field_left, 2},
    {field_right, 4},
  [277] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [281] =
    {field_body, 4},
    {field_parameter, 2},
  [283] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [287] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [291] =
    {field_name, 2},
    {field_type, 4},
  [293] =
    {field_name, 3},
    {field_type, 4},
  [295] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [297] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [300] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [303] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [305] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [310] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [315] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [319] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [323] =
    {field_name, 3},
    {field_type, 5},
  [325] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [328] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [330] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [333] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [338] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [343] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [347] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [351] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [354] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [359] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
};

static TSSymbol ts_alias_sequences[187][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [9] = {
    [0] = alias_sym_object_pattern,
  },
  [10] = {
    [0] = alias_sym_array_pattern,
  },
  [11] = {
    [0] = alias_sym_object_pattern,
  },
  [12] = {
    [0] = alias_sym_array_pattern,
  },
  [14] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = sym_identifier,
  },
  [18] = {
    [1] = sym_identifier,
  },
  [23] = {
    [0] = sym_identifier,
  },
  [24] = {
    [0] = alias_sym_statement_identifier,
  },
  [25] = {
    [0] = sym_identifier,
    [2] = alias_sym_property_identifier,
  },
  [26] = {
    [0] = sym_identifier,
  },
  [28] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [31] = {
    [0] = alias_sym_object_pattern,
  },
  [32] = {
    [0] = alias_sym_object_pattern,
  },
  [33] = {
    [0] = alias_sym_array_pattern,
  },
  [34] = {
    [0] = alias_sym_array_pattern,
  },
  [38] = {
    [1] = alias_sym_object_pattern,
  },
  [39] = {
    [1] = alias_sym_array_pattern,
  },
  [45] = {
    [1] = alias_sym_statement_identifier,
  },
  [47] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [53] = {
    [1] = sym_identifier,
  },
  [54] = {
    [1] = sym_identifier,
  },
  [58] = {
    [2] = alias_sym_property_identifier,
  },
  [61] = {
    [0] = sym_identifier,
  },
  [64] = {
    [0] = alias_sym_object_pattern,
  },
  [65] = {
    [0] = alias_sym_array_pattern,
  },
  [73] = {
    [1] = alias_sym_export_specifier,
  },
  [74] = {
    [0] = alias_sym_shorthand_property_identifier,
  },
  [77] = {
    [1] = alias_sym_import_specifier,
  },
  [80] = {
    [0] = alias_sym_object_pattern,
  },
  [81] = {
    [0] = alias_sym_array_pattern,
  },
  [84] = {
    [2] = sym_identifier,
  },
  [85] = {
    [2] = alias_sym_object_pattern,
  },
  [86] = {
    [2] = alias_sym_array_pattern,
  },
  [90] = {
    [2] = alias_sym_type_identifier,
  },
  [92] = {
    [1] = alias_sym_type_identifier,
  },
  [93] = {
    [1] = alias_sym_type_identifier,
  },
  [95] = {
    [1] = sym_identifier,
  },
  [101] = {
    [1] = sym_identifier,
  },
  [104] = {
    [2] = alias_sym_type_identifier,
  },
  [105] = {
    [2] = alias_sym_type_identifier,
  },
  [110] = {
    [1] = alias_sym_type_identifier,
  },
  [123] = {
    [1] = alias_sym_type_identifier,
  },
  [127] = {
    [2] = alias_sym_type_identifier,
  },
  [128] = {
    [2] = alias_sym_type_identifier,
  },
  [131] = {
    [2] = alias_sym_type_identifier,
  },
  [132] = {
    [2] = alias_sym_type_identifier,
  },
  [136] = {
    [1] = alias_sym_type_identifier,
  },
  [137] = {
    [1] = sym_identifier,
  },
  [140] = {
    [1] = alias_sym_object_pattern,
  },
  [141] = {
    [1] = alias_sym_array_pattern,
  },
  [152] = {
    [2] = alias_sym_type_identifier,
  },
  [153] = {
    [3] = alias_sym_property_identifier,
  },
  [154] = {
    [2] = alias_sym_type_identifier,
  },
  [156] = {
    [2] = sym_identifier,
  },
  [158] = {
    [2] = alias_sym_object_pattern,
  },
  [159] = {
    [2] = alias_sym_array_pattern,
  },
  [162] = {
    [2] = alias_sym_object_pattern,
  },
  [163] = {
    [2] = alias_sym_array_pattern,
  },
};

static inline bool sym_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    (0 <= lookahead && lookahead <= '#') ||
    ('%' <= lookahead && lookahead <= '/') ||
    (':' <= lookahead && lookahead <= '@') ||
    ('[' <= lookahead && lookahead <= '^') ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~') ||
    lookahead == 160 ||
    lookahead == 8203 ||
    lookahead == 8288 ||
    lookahead == 65279;
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(64);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(118);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(85);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(120);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(61)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(188);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(161);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(157);
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == 'u') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(168);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(154);
      if (lookahead != 0) ADVANCE(155);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(150);
      if (lookahead == '\r') ADVANCE(165);
      if (lookahead == 'u') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(168);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(26)
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(174);
      if (lookahead != 0) ADVANCE(175);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(118);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(85);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(120);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(71);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead)) ADVANCE(188);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(118);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(85);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(120);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(122);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < ')' || ';' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(188);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < ')' || ';' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(188);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(71);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(71);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(65);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(144);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '?') ADVANCE(106);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(121);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(188);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(127);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '?') ADVANCE(106);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(121);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '=' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(127);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '?') ADVANCE(106);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(121);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '=' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(17)
      END_STATE();
    case 18:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(19)
      END_STATE();
    case 19:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(19)
      END_STATE();
    case 20:
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(170);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(105);
      END_STATE();
    case 26:
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(26)
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 28:
      if (lookahead == '\\') ADVANCE(59);
      if (lookahead == ']') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(168);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(168);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(172);
      END_STATE();
    case 33:
      if (lookahead == '{') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 34:
      if (lookahead == '{') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '}') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == '}') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 39:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 40:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(180);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(181);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(188);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(163);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 59:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 60:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(175);
      END_STATE();
    case 61:
      if (eof) ADVANCE(64);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(118);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(85);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(120);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(61)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(188);
      END_STATE();
    case 62:
      if (eof) ADVANCE(64);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(71);
      if (lookahead == '|') ADVANCE(125);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead)) ADVANCE(188);
      END_STATE();
    case 63:
      if (eof) ADVANCE(64);
      if (lookahead == '!') ADVANCE(144);
      if (lookahead == '"') ADVANCE(149);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(156);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '?') ADVANCE(106);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '`') ADVANCE(171);
      if (lookahead == '{') ADVANCE(71);
      if (lookahead == '|') ADVANCE(126);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(63)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead) &&
          lookahead != '%' &&
          lookahead != '^') ADVANCE(188);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(135);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(92);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(92);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(190);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(114);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(110);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(111);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(170);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(143);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(113);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(108);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(108);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '|') ADVANCE(109);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(191);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(109);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(191);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(191);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(147);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(148);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(154);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(160);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(160);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(161);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(157);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(150);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(188);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(163);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(167);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(170);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(30);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '0') ADVANCE(183);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(40);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(41);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(48);
      if (lookahead == '_') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(177);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(177);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == '_') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '{') ADVANCE(172);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 't') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      if (lookahead == 'w') ADVANCE(60);
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'h') ADVANCE(63);
      if (lookahead == 'r') ADVANCE(64);
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(70);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 23:
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(74);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(82);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'f') ADVANCE(84);
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(88);
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(92);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(93);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 44:
      if (lookahead == 'p') ADVANCE(97);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(98);
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(100);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 49:
      if (lookahead == 'd') ADVANCE(102);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 51:
      if (lookahead == 'w') ADVANCE(104);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(105);
      if (lookahead == 'm') ADVANCE(106);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 55:
      if (lookahead == 'b') ADVANCE(109);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(110);
      if (lookahead == 'q') ADVANCE(111);
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(115);
      END_STATE();
    case 59:
      if (lookahead == 'p') ADVANCE(116);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(118);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(122);
      if (lookahead == 'y') ADVANCE(123);
      END_STATE();
    case 65:
      if (lookahead == 'p') ADVANCE(124);
      END_STATE();
    case 66:
      if (lookahead == 'd') ADVANCE(125);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(131);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(132);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 79:
      if (lookahead == 'c') ADVANCE(137);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 81:
      if (lookahead == 's') ADVANCE(139);
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 82:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(143);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 87:
      if (lookahead == 'm') ADVANCE(146);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(147);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 90:
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(150);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 93:
      if (lookahead == 'm') ADVANCE(151);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(152);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 96:
      if (lookahead == 'b') ADVANCE(153);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(154);
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(156);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(159);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 106:
      if (lookahead == 'b') ADVANCE(162);
      END_STATE();
    case 107:
      if (lookahead == 'v') ADVANCE(163);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 110:
      if (lookahead == 'd') ADVANCE(166);
      END_STATE();
    case 111:
      if (lookahead == 'u') ADVANCE(167);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(168);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 115:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 118:
      if (lookahead == 'b') ADVANCE(173);
      END_STATE();
    case 119:
      if (lookahead == 'g') ADVANCE(174);
      END_STATE();
    case 120:
      if (lookahead == 's') ADVANCE(175);
      END_STATE();
    case 121:
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 127:
      if (lookahead == 'd') ADVANCE(180);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 129:
      if (lookahead == 'h') ADVANCE(182);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 131:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 132:
      if (lookahead == 'c') ADVANCE(185);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 135:
      if (lookahead == 'k') ADVANCE(188);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 137:
      if (lookahead == 'h') ADVANCE(189);
      END_STATE();
    case 138:
      if (lookahead == 's') ADVANCE(190);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 141:
      if (lookahead == 'g') ADVANCE(193);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(194);
      END_STATE();
    case 143:
      if (lookahead == 'u') ADVANCE(195);
      END_STATE();
    case 144:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(198);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(200);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(202);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(204);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(205);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(206);
      END_STATE();
    case 158:
      if (lookahead == 'f') ADVANCE(207);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(208);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(209);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(211);
      END_STATE();
    case 164:
      if (lookahead == 'e') ADVANCE(212);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(213);
      END_STATE();
    case 166:
      if (lookahead == 'o') ADVANCE(214);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(215);
      END_STATE();
    case 168:
      if (lookahead == 'r') ADVANCE(216);
      END_STATE();
    case 169:
      if (lookahead == 'i') ADVANCE(217);
      END_STATE();
    case 170:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 171:
      if (lookahead == 'r') ADVANCE(219);
      END_STATE();
    case 172:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 173:
      if (lookahead == 'o') ADVANCE(221);
      END_STATE();
    case 174:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 176:
      if (lookahead == 'w') ADVANCE(223);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(224);
      END_STATE();
    case 179:
      if (lookahead == 'f') ADVANCE(225);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(226);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 183:
      if (lookahead == 'd') ADVANCE(227);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(228);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(229);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 192:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 193:
      if (lookahead == 'g') ADVANCE(231);
      END_STATE();
    case 194:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 195:
      if (lookahead == 'l') ADVANCE(233);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(234);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 198:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 200:
      if (lookahead == 'l') ADVANCE(237);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 202:
      if (lookahead == 'l') ADVANCE(239);
      END_STATE();
    case 203:
      if (lookahead == 'm') ADVANCE(240);
      END_STATE();
    case 204:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 205:
      if (lookahead == 'n') ADVANCE(242);
      END_STATE();
    case 206:
      if (lookahead == 'f') ADVANCE(243);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 209:
      if (lookahead == 'p') ADVANCE(245);
      END_STATE();
    case 210:
      if (lookahead == 'r') ADVANCE(246);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 212:
      if (lookahead == 'c') ADVANCE(248);
      END_STATE();
    case 213:
      if (lookahead == 'c') ADVANCE(249);
      END_STATE();
    case 214:
      if (lookahead == 'n') ADVANCE(250);
      END_STATE();
    case 215:
      if (lookahead == 'r') ADVANCE(251);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(252);
      END_STATE();
    case 217:
      if (lookahead == 'c') ADVANCE(253);
      END_STATE();
    case 218:
      if (lookahead == 'g') ADVANCE(254);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 220:
      if (lookahead == 'h') ADVANCE(255);
      END_STATE();
    case 221:
      if (lookahead == 'l') ADVANCE(256);
      END_STATE();
    case 222:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 224:
      if (lookahead == 'f') ADVANCE(258);
      END_STATE();
    case 225:
      if (lookahead == 'i') ADVANCE(259);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 228:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 229:
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 230:
      if (lookahead == 'u') ADVANCE(262);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 233:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 236:
      if (lookahead == 's') ADVANCE(266);
      END_STATE();
    case 237:
      if (lookahead == 'y') ADVANCE(267);
      END_STATE();
    case 238:
      if (lookahead == 'o') ADVANCE(268);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 242:
      if (lookahead == 'c') ADVANCE(270);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(271);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(272);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(274);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 250:
      if (lookahead == 'l') ADVANCE(275);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 259:
      if (lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(278);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(280);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 268:
      if (lookahead == 'n') ADVANCE(281);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 271:
      if (lookahead == 'c') ADVANCE(284);
      END_STATE();
    case 272:
      if (lookahead == 'c') ADVANCE(285);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(286);
      END_STATE();
    case 275:
      if (lookahead == 'y') ADVANCE(287);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 282:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 283:
      if (lookahead == 'o') ADVANCE(290);
      END_STATE();
    case 284:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 286:
      if (lookahead == 'd') ADVANCE(293);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_readonly);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(294);
      END_STATE();
    case 289:
      if (lookahead == 's') ADVANCE(295);
      END_STATE();
    case 290:
      if (lookahead == 'f') ADVANCE(296);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 63},
  [2] = {.lex_state = 63},
  [3] = {.lex_state = 63},
  [4] = {.lex_state = 63},
  [5] = {.lex_state = 63},
  [6] = {.lex_state = 63},
  [7] = {.lex_state = 63},
  [8] = {.lex_state = 63},
  [9] = {.lex_state = 63},
  [10] = {.lex_state = 63},
  [11] = {.lex_state = 63},
  [12] = {.lex_state = 63},
  [13] = {.lex_state = 63},
  [14] = {.lex_state = 63},
  [15] = {.lex_state = 63},
  [16] = {.lex_state = 63},
  [17] = {.lex_state = 63},
  [18] = {.lex_state = 63},
  [19] = {.lex_state = 63},
  [20] = {.lex_state = 63},
  [21] = {.lex_state = 63},
  [22] = {.lex_state = 63},
  [23] = {.lex_state = 63},
  [24] = {.lex_state = 63},
  [25] = {.lex_state = 63},
  [26] = {.lex_state = 63},
  [27] = {.lex_state = 63},
  [28] = {.lex_state = 63},
  [29] = {.lex_state = 63},
  [30] = {.lex_state = 63},
  [31] = {.lex_state = 63},
  [32] = {.lex_state = 63},
  [33] = {.lex_state = 63},
  [34] = {.lex_state = 63},
  [35] = {.lex_state = 63},
  [36] = {.lex_state = 63},
  [37] = {.lex_state = 63},
  [38] = {.lex_state = 63},
  [39] = {.lex_state = 63},
  [40] = {.lex_state = 63},
  [41] = {.lex_state = 63},
  [42] = {.lex_state = 63},
  [43] = {.lex_state = 63},
  [44] = {.lex_state = 63},
  [45] = {.lex_state = 63},
  [46] = {.lex_state = 63},
  [47] = {.lex_state = 63},
  [48] = {.lex_state = 6, .external_lex_state = 2},
  [49] = {.lex_state = 6, .external_lex_state = 2},
  [50] = {.lex_state = 6, .external_lex_state = 2},
  [51] = {.lex_state = 6, .external_lex_state = 3},
  [52] = {.lex_state = 6, .external_lex_state = 2},
  [53] = {.lex_state = 6, .external_lex_state = 2},
  [54] = {.lex_state = 6, .external_lex_state = 2},
  [55] = {.lex_state = 6, .external_lex_state = 3},
  [56] = {.lex_state = 6, .external_lex_state = 2},
  [57] = {.lex_state = 6, .external_lex_state = 2},
  [58] = {.lex_state = 6, .external_lex_state = 2},
  [59] = {.lex_state = 6, .external_lex_state = 3},
  [60] = {.lex_state = 6, .external_lex_state = 3},
  [61] = {.lex_state = 6, .external_lex_state = 2},
  [62] = {.lex_state = 6, .external_lex_state = 3},
  [63] = {.lex_state = 6, .external_lex_state = 3},
  [64] = {.lex_state = 6, .external_lex_state = 3},
  [65] = {.lex_state = 6, .external_lex_state = 2},
  [66] = {.lex_state = 6, .external_lex_state = 3},
  [67] = {.lex_state = 6, .external_lex_state = 3},
  [68] = {.lex_state = 6, .external_lex_state = 3},
  [69] = {.lex_state = 7, .external_lex_state = 3},
  [70] = {.lex_state = 6, .external_lex_state = 3},
  [71] = {.lex_state = 6, .external_lex_state = 2},
  [72] = {.lex_state = 6, .external_lex_state = 3},
  [73] = {.lex_state = 7, .external_lex_state = 3},
  [74] = {.lex_state = 6, .external_lex_state = 3},
  [75] = {.lex_state = 6, .external_lex_state = 3},
  [76] = {.lex_state = 7, .external_lex_state = 3},
  [77] = {.lex_state = 6, .external_lex_state = 3},
  [78] = {.lex_state = 6, .external_lex_state = 3},
  [79] = {.lex_state = 6, .external_lex_state = 3},
  [80] = {.lex_state = 6, .external_lex_state = 3},
  [81] = {.lex_state = 6, .external_lex_state = 2},
  [82] = {.lex_state = 6, .external_lex_state = 3},
  [83] = {.lex_state = 6, .external_lex_state = 3},
  [84] = {.lex_state = 6, .external_lex_state = 3},
  [85] = {.lex_state = 6, .external_lex_state = 3},
  [86] = {.lex_state = 6, .external_lex_state = 3},
  [87] = {.lex_state = 14},
  [88] = {.lex_state = 14},
  [89] = {.lex_state = 14},
  [90] = {.lex_state = 14},
  [91] = {.lex_state = 14},
  [92] = {.lex_state = 14},
  [93] = {.lex_state = 14},
  [94] = {.lex_state = 14},
  [95] = {.lex_state = 14},
  [96] = {.lex_state = 62, .external_lex_state = 3},
  [97] = {.lex_state = 62, .external_lex_state = 2},
  [98] = {.lex_state = 14},
  [99] = {.lex_state = 14},
  [100] = {.lex_state = 62, .external_lex_state = 3},
  [101] = {.lex_state = 14},
  [102] = {.lex_state = 14},
  [103] = {.lex_state = 62, .external_lex_state = 2},
  [104] = {.lex_state = 14},
  [105] = {.lex_state = 14},
  [106] = {.lex_state = 14},
  [107] = {.lex_state = 14},
  [108] = {.lex_state = 14},
  [109] = {.lex_state = 62, .external_lex_state = 3},
  [110] = {.lex_state = 8, .external_lex_state = 3},
  [111] = {.lex_state = 62, .external_lex_state = 3},
  [112] = {.lex_state = 62, .external_lex_state = 2},
  [113] = {.lex_state = 8, .external_lex_state = 3},
  [114] = {.lex_state = 62, .external_lex_state = 3},
  [115] = {.lex_state = 62, .external_lex_state = 3},
  [116] = {.lex_state = 62, .external_lex_state = 3},
  [117] = {.lex_state = 62, .external_lex_state = 2},
  [118] = {.lex_state = 62, .external_lex_state = 2},
  [119] = {.lex_state = 62, .external_lex_state = 2},
  [120] = {.lex_state = 62, .external_lex_state = 2},
  [121] = {.lex_state = 62, .external_lex_state = 2},
  [122] = {.lex_state = 62, .external_lex_state = 2},
  [123] = {.lex_state = 62, .external_lex_state = 2},
  [124] = {.lex_state = 62, .external_lex_state = 2},
  [125] = {.lex_state = 62, .external_lex_state = 2},
  [126] = {.lex_state = 62, .external_lex_state = 2},
  [127] = {.lex_state = 62, .external_lex_state = 2},
  [128] = {.lex_state = 62, .external_lex_state = 2},
  [129] = {.lex_state = 62, .external_lex_state = 2},
  [130] = {.lex_state = 62, .external_lex_state = 2},
  [131] = {.lex_state = 62, .external_lex_state = 2},
  [132] = {.lex_state = 62, .external_lex_state = 2},
  [133] = {.lex_state = 62, .external_lex_state = 2},
  [134] = {.lex_state = 62, .external_lex_state = 2},
  [135] = {.lex_state = 62, .external_lex_state = 2},
  [136] = {.lex_state = 62, .external_lex_state = 2},
  [137] = {.lex_state = 62, .external_lex_state = 2},
  [138] = {.lex_state = 62, .external_lex_state = 2},
  [139] = {.lex_state = 62, .external_lex_state = 2},
  [140] = {.lex_state = 62, .external_lex_state = 2},
  [141] = {.lex_state = 62, .external_lex_state = 2},
  [142] = {.lex_state = 62, .external_lex_state = 2},
  [143] = {.lex_state = 62, .external_lex_state = 2},
  [144] = {.lex_state = 63},
  [145] = {.lex_state = 63},
  [146] = {.lex_state = 63},
  [147] = {.lex_state = 63},
  [148] = {.lex_state = 63},
  [149] = {.lex_state = 63},
  [150] = {.lex_state = 63},
  [151] = {.lex_state = 63},
  [152] = {.lex_state = 63},
  [153] = {.lex_state = 63},
  [154] = {.lex_state = 63},
  [155] = {.lex_state = 63},
  [156] = {.lex_state = 63},
  [157] = {.lex_state = 63},
  [158] = {.lex_state = 63},
  [159] = {.lex_state = 63},
  [160] = {.lex_state = 63},
  [161] = {.lex_state = 63},
  [162] = {.lex_state = 63},
  [163] = {.lex_state = 63},
  [164] = {.lex_state = 63},
  [165] = {.lex_state = 63},
  [166] = {.lex_state = 63},
  [167] = {.lex_state = 6, .external_lex_state = 2},
  [168] = {.lex_state = 6, .external_lex_state = 2},
  [169] = {.lex_state = 6, .external_lex_state = 2},
  [170] = {.lex_state = 63},
  [171] = {.lex_state = 63},
  [172] = {.lex_state = 63},
  [173] = {.lex_state = 63},
  [174] = {.lex_state = 63},
  [175] = {.lex_state = 63},
  [176] = {.lex_state = 63, .external_lex_state = 4},
  [177] = {.lex_state = 63},
  [178] = {.lex_state = 6, .external_lex_state = 2},
  [179] = {.lex_state = 6, .external_lex_state = 2},
  [180] = {.lex_state = 6, .external_lex_state = 2},
  [181] = {.lex_state = 63},
  [182] = {.lex_state = 6, .external_lex_state = 2},
  [183] = {.lex_state = 63},
  [184] = {.lex_state = 6, .external_lex_state = 2},
  [185] = {.lex_state = 63},
  [186] = {.lex_state = 63},
  [187] = {.lex_state = 63},
  [188] = {.lex_state = 63},
  [189] = {.lex_state = 63},
  [190] = {.lex_state = 63},
  [191] = {.lex_state = 63},
  [192] = {.lex_state = 63},
  [193] = {.lex_state = 63},
  [194] = {.lex_state = 63},
  [195] = {.lex_state = 63},
  [196] = {.lex_state = 63},
  [197] = {.lex_state = 63},
  [198] = {.lex_state = 63},
  [199] = {.lex_state = 63},
  [200] = {.lex_state = 63},
  [201] = {.lex_state = 63},
  [202] = {.lex_state = 63},
  [203] = {.lex_state = 63},
  [204] = {.lex_state = 63},
  [205] = {.lex_state = 63},
  [206] = {.lex_state = 63},
  [207] = {.lex_state = 63},
  [208] = {.lex_state = 63},
  [209] = {.lex_state = 63},
  [210] = {.lex_state = 63},
  [211] = {.lex_state = 63},
  [212] = {.lex_state = 63},
  [213] = {.lex_state = 63},
  [214] = {.lex_state = 63},
  [215] = {.lex_state = 63},
  [216] = {.lex_state = 63},
  [217] = {.lex_state = 63},
  [218] = {.lex_state = 63},
  [219] = {.lex_state = 63},
  [220] = {.lex_state = 63},
  [221] = {.lex_state = 63},
  [222] = {.lex_state = 63},
  [223] = {.lex_state = 63},
  [224] = {.lex_state = 63},
  [225] = {.lex_state = 63},
  [226] = {.lex_state = 63},
  [227] = {.lex_state = 63},
  [228] = {.lex_state = 63},
  [229] = {.lex_state = 63},
  [230] = {.lex_state = 63},
  [231] = {.lex_state = 63},
  [232] = {.lex_state = 63},
  [233] = {.lex_state = 63},
  [234] = {.lex_state = 63},
  [235] = {.lex_state = 63},
  [236] = {.lex_state = 63},
  [237] = {.lex_state = 63},
  [238] = {.lex_state = 63},
  [239] = {.lex_state = 63},
  [240] = {.lex_state = 63},
  [241] = {.lex_state = 63},
  [242] = {.lex_state = 63},
  [243] = {.lex_state = 63},
  [244] = {.lex_state = 63},
  [245] = {.lex_state = 63},
  [246] = {.lex_state = 63},
  [247] = {.lex_state = 63},
  [248] = {.lex_state = 63},
  [249] = {.lex_state = 63},
  [250] = {.lex_state = 63},
  [251] = {.lex_state = 63},
  [252] = {.lex_state = 63},
  [253] = {.lex_state = 63},
  [254] = {.lex_state = 63},
  [255] = {.lex_state = 63},
  [256] = {.lex_state = 63},
  [257] = {.lex_state = 63},
  [258] = {.lex_state = 63},
  [259] = {.lex_state = 63},
  [260] = {.lex_state = 63},
  [261] = {.lex_state = 63},
  [262] = {.lex_state = 63},
  [263] = {.lex_state = 63},
  [264] = {.lex_state = 63},
  [265] = {.lex_state = 63},
  [266] = {.lex_state = 63},
  [267] = {.lex_state = 63},
  [268] = {.lex_state = 63},
  [269] = {.lex_state = 63},
  [270] = {.lex_state = 63},
  [271] = {.lex_state = 63},
  [272] = {.lex_state = 63},
  [273] = {.lex_state = 63},
  [274] = {.lex_state = 63},
  [275] = {.lex_state = 63},
  [276] = {.lex_state = 63},
  [277] = {.lex_state = 63},
  [278] = {.lex_state = 63},
  [279] = {.lex_state = 63},
  [280] = {.lex_state = 63},
  [281] = {.lex_state = 63},
  [282] = {.lex_state = 63},
  [283] = {.lex_state = 63},
  [284] = {.lex_state = 63},
  [285] = {.lex_state = 63},
  [286] = {.lex_state = 63},
  [287] = {.lex_state = 63},
  [288] = {.lex_state = 63},
  [289] = {.lex_state = 63},
  [290] = {.lex_state = 63},
  [291] = {.lex_state = 63},
  [292] = {.lex_state = 63},
  [293] = {.lex_state = 63},
  [294] = {.lex_state = 63},
  [295] = {.lex_state = 63},
  [296] = {.lex_state = 63},
  [297] = {.lex_state = 63},
  [298] = {.lex_state = 63},
  [299] = {.lex_state = 63},
  [300] = {.lex_state = 63},
  [301] = {.lex_state = 63},
  [302] = {.lex_state = 63},
  [303] = {.lex_state = 63},
  [304] = {.lex_state = 63},
  [305] = {.lex_state = 63},
  [306] = {.lex_state = 63},
  [307] = {.lex_state = 63},
  [308] = {.lex_state = 63},
  [309] = {.lex_state = 63},
  [310] = {.lex_state = 63},
  [311] = {.lex_state = 63},
  [312] = {.lex_state = 63},
  [313] = {.lex_state = 63},
  [314] = {.lex_state = 63},
  [315] = {.lex_state = 63},
  [316] = {.lex_state = 63},
  [317] = {.lex_state = 63},
  [318] = {.lex_state = 63},
  [319] = {.lex_state = 63},
  [320] = {.lex_state = 63},
  [321] = {.lex_state = 63},
  [322] = {.lex_state = 63},
  [323] = {.lex_state = 63},
  [324] = {.lex_state = 63},
  [325] = {.lex_state = 63},
  [326] = {.lex_state = 63},
  [327] = {.lex_state = 63},
  [328] = {.lex_state = 63},
  [329] = {.lex_state = 63},
  [330] = {.lex_state = 63},
  [331] = {.lex_state = 63},
  [332] = {.lex_state = 63},
  [333] = {.lex_state = 63},
  [334] = {.lex_state = 63},
  [335] = {.lex_state = 63},
  [336] = {.lex_state = 63},
  [337] = {.lex_state = 63},
  [338] = {.lex_state = 63},
  [339] = {.lex_state = 63},
  [340] = {.lex_state = 63},
  [341] = {.lex_state = 63},
  [342] = {.lex_state = 63},
  [343] = {.lex_state = 63},
  [344] = {.lex_state = 63},
  [345] = {.lex_state = 63},
  [346] = {.lex_state = 63},
  [347] = {.lex_state = 63},
  [348] = {.lex_state = 63},
  [349] = {.lex_state = 63},
  [350] = {.lex_state = 63},
  [351] = {.lex_state = 63},
  [352] = {.lex_state = 6, .external_lex_state = 2},
  [353] = {.lex_state = 63},
  [354] = {.lex_state = 63},
  [355] = {.lex_state = 63},
  [356] = {.lex_state = 63},
  [357] = {.lex_state = 63},
  [358] = {.lex_state = 63},
  [359] = {.lex_state = 63},
  [360] = {.lex_state = 63},
  [361] = {.lex_state = 6, .external_lex_state = 2},
  [362] = {.lex_state = 63},
  [363] = {.lex_state = 63},
  [364] = {.lex_state = 63},
  [365] = {.lex_state = 63},
  [366] = {.lex_state = 63},
  [367] = {.lex_state = 63},
  [368] = {.lex_state = 63},
  [369] = {.lex_state = 63},
  [370] = {.lex_state = 63},
  [371] = {.lex_state = 63},
  [372] = {.lex_state = 63},
  [373] = {.lex_state = 63},
  [374] = {.lex_state = 63},
  [375] = {.lex_state = 63},
  [376] = {.lex_state = 63},
  [377] = {.lex_state = 63},
  [378] = {.lex_state = 63},
  [379] = {.lex_state = 63},
  [380] = {.lex_state = 63},
  [381] = {.lex_state = 63},
  [382] = {.lex_state = 63},
  [383] = {.lex_state = 63},
  [384] = {.lex_state = 63},
  [385] = {.lex_state = 63},
  [386] = {.lex_state = 63},
  [387] = {.lex_state = 63},
  [388] = {.lex_state = 63},
  [389] = {.lex_state = 63},
  [390] = {.lex_state = 63},
  [391] = {.lex_state = 63},
  [392] = {.lex_state = 63},
  [393] = {.lex_state = 63},
  [394] = {.lex_state = 63},
  [395] = {.lex_state = 63},
  [396] = {.lex_state = 63},
  [397] = {.lex_state = 63},
  [398] = {.lex_state = 63},
  [399] = {.lex_state = 63},
  [400] = {.lex_state = 63},
  [401] = {.lex_state = 63},
  [402] = {.lex_state = 63},
  [403] = {.lex_state = 63},
  [404] = {.lex_state = 63},
  [405] = {.lex_state = 63},
  [406] = {.lex_state = 63},
  [407] = {.lex_state = 63},
  [408] = {.lex_state = 63},
  [409] = {.lex_state = 63},
  [410] = {.lex_state = 63},
  [411] = {.lex_state = 63},
  [412] = {.lex_state = 63},
  [413] = {.lex_state = 63},
  [414] = {.lex_state = 63},
  [415] = {.lex_state = 63},
  [416] = {.lex_state = 63},
  [417] = {.lex_state = 63},
  [418] = {.lex_state = 63},
  [419] = {.lex_state = 63},
  [420] = {.lex_state = 63},
  [421] = {.lex_state = 63},
  [422] = {.lex_state = 63},
  [423] = {.lex_state = 63},
  [424] = {.lex_state = 63},
  [425] = {.lex_state = 63},
  [426] = {.lex_state = 63},
  [427] = {.lex_state = 63},
  [428] = {.lex_state = 63},
  [429] = {.lex_state = 63},
  [430] = {.lex_state = 63},
  [431] = {.lex_state = 63},
  [432] = {.lex_state = 63},
  [433] = {.lex_state = 63},
  [434] = {.lex_state = 63},
  [435] = {.lex_state = 63},
  [436] = {.lex_state = 63},
  [437] = {.lex_state = 63},
  [438] = {.lex_state = 63},
  [439] = {.lex_state = 63},
  [440] = {.lex_state = 63},
  [441] = {.lex_state = 63},
  [442] = {.lex_state = 63},
  [443] = {.lex_state = 63},
  [444] = {.lex_state = 63},
  [445] = {.lex_state = 63},
  [446] = {.lex_state = 63},
  [447] = {.lex_state = 63},
  [448] = {.lex_state = 63},
  [449] = {.lex_state = 63},
  [450] = {.lex_state = 63},
  [451] = {.lex_state = 63},
  [452] = {.lex_state = 63},
  [453] = {.lex_state = 63},
  [454] = {.lex_state = 63},
  [455] = {.lex_state = 63},
  [456] = {.lex_state = 63},
  [457] = {.lex_state = 63},
  [458] = {.lex_state = 63},
  [459] = {.lex_state = 63},
  [460] = {.lex_state = 63},
  [461] = {.lex_state = 63},
  [462] = {.lex_state = 63},
  [463] = {.lex_state = 63},
  [464] = {.lex_state = 63},
  [465] = {.lex_state = 63},
  [466] = {.lex_state = 63},
  [467] = {.lex_state = 63},
  [468] = {.lex_state = 63},
  [469] = {.lex_state = 63},
  [470] = {.lex_state = 63},
  [471] = {.lex_state = 63},
  [472] = {.lex_state = 63},
  [473] = {.lex_state = 63},
  [474] = {.lex_state = 63},
  [475] = {.lex_state = 63},
  [476] = {.lex_state = 63},
  [477] = {.lex_state = 63},
  [478] = {.lex_state = 63},
  [479] = {.lex_state = 63},
  [480] = {.lex_state = 63},
  [481] = {.lex_state = 63},
  [482] = {.lex_state = 63},
  [483] = {.lex_state = 63},
  [484] = {.lex_state = 63},
  [485] = {.lex_state = 63},
  [486] = {.lex_state = 63},
  [487] = {.lex_state = 63},
  [488] = {.lex_state = 63},
  [489] = {.lex_state = 63},
  [490] = {.lex_state = 63},
  [491] = {.lex_state = 63},
  [492] = {.lex_state = 63},
  [493] = {.lex_state = 63},
  [494] = {.lex_state = 63},
  [495] = {.lex_state = 63},
  [496] = {.lex_state = 63},
  [497] = {.lex_state = 63},
  [498] = {.lex_state = 6, .external_lex_state = 2},
  [499] = {.lex_state = 6, .external_lex_state = 2},
  [500] = {.lex_state = 63},
  [501] = {.lex_state = 63},
  [502] = {.lex_state = 6, .external_lex_state = 2},
  [503] = {.lex_state = 63},
  [504] = {.lex_state = 63},
  [505] = {.lex_state = 63},
  [506] = {.lex_state = 63},
  [507] = {.lex_state = 63},
  [508] = {.lex_state = 63},
  [509] = {.lex_state = 63},
  [510] = {.lex_state = 63},
  [511] = {.lex_state = 63},
  [512] = {.lex_state = 63},
  [513] = {.lex_state = 63},
  [514] = {.lex_state = 63},
  [515] = {.lex_state = 63},
  [516] = {.lex_state = 63},
  [517] = {.lex_state = 63},
  [518] = {.lex_state = 63},
  [519] = {.lex_state = 63},
  [520] = {.lex_state = 63},
  [521] = {.lex_state = 63},
  [522] = {.lex_state = 63},
  [523] = {.lex_state = 63},
  [524] = {.lex_state = 63},
  [525] = {.lex_state = 63},
  [526] = {.lex_state = 63},
  [527] = {.lex_state = 63},
  [528] = {.lex_state = 63},
  [529] = {.lex_state = 63},
  [530] = {.lex_state = 63},
  [531] = {.lex_state = 6, .external_lex_state = 2},
  [532] = {.lex_state = 62, .external_lex_state = 3},
  [533] = {.lex_state = 6, .external_lex_state = 2},
  [534] = {.lex_state = 6, .external_lex_state = 2},
  [535] = {.lex_state = 6, .external_lex_state = 2},
  [536] = {.lex_state = 6, .external_lex_state = 2},
  [537] = {.lex_state = 62, .external_lex_state = 3},
  [538] = {.lex_state = 6, .external_lex_state = 2},
  [539] = {.lex_state = 62, .external_lex_state = 3},
  [540] = {.lex_state = 6, .external_lex_state = 2},
  [541] = {.lex_state = 6, .external_lex_state = 2},
  [542] = {.lex_state = 6, .external_lex_state = 2},
  [543] = {.lex_state = 63},
  [544] = {.lex_state = 62, .external_lex_state = 2},
  [545] = {.lex_state = 6, .external_lex_state = 2},
  [546] = {.lex_state = 63, .external_lex_state = 4},
  [547] = {.lex_state = 62, .external_lex_state = 2},
  [548] = {.lex_state = 63, .external_lex_state = 4},
  [549] = {.lex_state = 63},
  [550] = {.lex_state = 62, .external_lex_state = 2},
  [551] = {.lex_state = 6, .external_lex_state = 3},
  [552] = {.lex_state = 63},
  [553] = {.lex_state = 6, .external_lex_state = 3},
  [554] = {.lex_state = 63},
  [555] = {.lex_state = 63},
  [556] = {.lex_state = 63, .external_lex_state = 4},
  [557] = {.lex_state = 15},
  [558] = {.lex_state = 63, .external_lex_state = 4},
  [559] = {.lex_state = 63},
  [560] = {.lex_state = 15},
  [561] = {.lex_state = 63, .external_lex_state = 4},
  [562] = {.lex_state = 6, .external_lex_state = 3},
  [563] = {.lex_state = 6, .external_lex_state = 2},
  [564] = {.lex_state = 15},
  [565] = {.lex_state = 63},
  [566] = {.lex_state = 15},
  [567] = {.lex_state = 63, .external_lex_state = 4},
  [568] = {.lex_state = 7, .external_lex_state = 3},
  [569] = {.lex_state = 6, .external_lex_state = 2},
  [570] = {.lex_state = 63, .external_lex_state = 4},
  [571] = {.lex_state = 6, .external_lex_state = 2},
  [572] = {.lex_state = 15},
  [573] = {.lex_state = 63, .external_lex_state = 4},
  [574] = {.lex_state = 6, .external_lex_state = 2},
  [575] = {.lex_state = 8, .external_lex_state = 3},
  [576] = {.lex_state = 6, .external_lex_state = 2},
  [577] = {.lex_state = 63},
  [578] = {.lex_state = 63},
  [579] = {.lex_state = 63},
  [580] = {.lex_state = 8, .external_lex_state = 3},
  [581] = {.lex_state = 63},
  [582] = {.lex_state = 63},
  [583] = {.lex_state = 6, .external_lex_state = 2},
  [584] = {.lex_state = 63},
  [585] = {.lex_state = 6, .external_lex_state = 2},
  [586] = {.lex_state = 63},
  [587] = {.lex_state = 6, .external_lex_state = 3},
  [588] = {.lex_state = 8, .external_lex_state = 3},
  [589] = {.lex_state = 63},
  [590] = {.lex_state = 6, .external_lex_state = 2},
  [591] = {.lex_state = 63, .external_lex_state = 4},
  [592] = {.lex_state = 6, .external_lex_state = 3},
  [593] = {.lex_state = 6, .external_lex_state = 3},
  [594] = {.lex_state = 63},
  [595] = {.lex_state = 6, .external_lex_state = 3},
  [596] = {.lex_state = 63},
  [597] = {.lex_state = 63},
  [598] = {.lex_state = 63},
  [599] = {.lex_state = 63},
  [600] = {.lex_state = 6, .external_lex_state = 3},
  [601] = {.lex_state = 63, .external_lex_state = 4},
  [602] = {.lex_state = 7, .external_lex_state = 3},
  [603] = {.lex_state = 63, .external_lex_state = 4},
  [604] = {.lex_state = 6, .external_lex_state = 3},
  [605] = {.lex_state = 6, .external_lex_state = 3},
  [606] = {.lex_state = 63, .external_lex_state = 4},
  [607] = {.lex_state = 63, .external_lex_state = 4},
  [608] = {.lex_state = 63},
  [609] = {.lex_state = 63},
  [610] = {.lex_state = 63, .external_lex_state = 4},
  [611] = {.lex_state = 6, .external_lex_state = 3},
  [612] = {.lex_state = 63, .external_lex_state = 4},
  [613] = {.lex_state = 63, .external_lex_state = 4},
  [614] = {.lex_state = 63, .external_lex_state = 4},
  [615] = {.lex_state = 63, .external_lex_state = 4},
  [616] = {.lex_state = 63, .external_lex_state = 4},
  [617] = {.lex_state = 6, .external_lex_state = 3},
  [618] = {.lex_state = 6, .external_lex_state = 3},
  [619] = {.lex_state = 63, .external_lex_state = 4},
  [620] = {.lex_state = 63},
  [621] = {.lex_state = 63},
  [622] = {.lex_state = 63},
  [623] = {.lex_state = 63},
  [624] = {.lex_state = 63},
  [625] = {.lex_state = 63},
  [626] = {.lex_state = 63},
  [627] = {.lex_state = 63},
  [628] = {.lex_state = 63},
  [629] = {.lex_state = 63},
  [630] = {.lex_state = 63},
  [631] = {.lex_state = 63},
  [632] = {.lex_state = 63},
  [633] = {.lex_state = 63},
  [634] = {.lex_state = 63},
  [635] = {.lex_state = 63},
  [636] = {.lex_state = 63},
  [637] = {.lex_state = 63},
  [638] = {.lex_state = 63},
  [639] = {.lex_state = 63},
  [640] = {.lex_state = 63},
  [641] = {.lex_state = 63},
  [642] = {.lex_state = 63},
  [643] = {.lex_state = 63},
  [644] = {.lex_state = 63},
  [645] = {.lex_state = 63},
  [646] = {.lex_state = 63},
  [647] = {.lex_state = 6, .external_lex_state = 3},
  [648] = {.lex_state = 63},
  [649] = {.lex_state = 63},
  [650] = {.lex_state = 63},
  [651] = {.lex_state = 63},
  [652] = {.lex_state = 63},
  [653] = {.lex_state = 6, .external_lex_state = 2},
  [654] = {.lex_state = 63},
  [655] = {.lex_state = 63},
  [656] = {.lex_state = 63},
  [657] = {.lex_state = 63},
  [658] = {.lex_state = 63},
  [659] = {.lex_state = 63},
  [660] = {.lex_state = 63},
  [661] = {.lex_state = 63},
  [662] = {.lex_state = 63},
  [663] = {.lex_state = 63},
  [664] = {.lex_state = 63},
  [665] = {.lex_state = 63},
  [666] = {.lex_state = 63},
  [667] = {.lex_state = 63},
  [668] = {.lex_state = 63},
  [669] = {.lex_state = 63},
  [670] = {.lex_state = 63},
  [671] = {.lex_state = 63},
  [672] = {.lex_state = 63},
  [673] = {.lex_state = 63},
  [674] = {.lex_state = 63},
  [675] = {.lex_state = 63},
  [676] = {.lex_state = 63},
  [677] = {.lex_state = 63},
  [678] = {.lex_state = 63},
  [679] = {.lex_state = 63},
  [680] = {.lex_state = 63},
  [681] = {.lex_state = 63},
  [682] = {.lex_state = 63},
  [683] = {.lex_state = 63},
  [684] = {.lex_state = 63},
  [685] = {.lex_state = 63},
  [686] = {.lex_state = 63},
  [687] = {.lex_state = 63},
  [688] = {.lex_state = 63},
  [689] = {.lex_state = 63},
  [690] = {.lex_state = 63},
  [691] = {.lex_state = 63},
  [692] = {.lex_state = 63},
  [693] = {.lex_state = 63},
  [694] = {.lex_state = 63},
  [695] = {.lex_state = 63},
  [696] = {.lex_state = 63},
  [697] = {.lex_state = 63},
  [698] = {.lex_state = 6, .external_lex_state = 3},
  [699] = {.lex_state = 6, .external_lex_state = 3},
  [700] = {.lex_state = 6, .external_lex_state = 3},
  [701] = {.lex_state = 6, .external_lex_state = 3},
  [702] = {.lex_state = 6, .external_lex_state = 3},
  [703] = {.lex_state = 6, .external_lex_state = 3},
  [704] = {.lex_state = 63},
  [705] = {.lex_state = 63},
  [706] = {.lex_state = 63},
  [707] = {.lex_state = 63},
  [708] = {.lex_state = 63},
  [709] = {.lex_state = 63},
  [710] = {.lex_state = 63},
  [711] = {.lex_state = 63},
  [712] = {.lex_state = 63},
  [713] = {.lex_state = 63},
  [714] = {.lex_state = 6, .external_lex_state = 3},
  [715] = {.lex_state = 6, .external_lex_state = 2},
  [716] = {.lex_state = 6, .external_lex_state = 2},
  [717] = {.lex_state = 6, .external_lex_state = 2},
  [718] = {.lex_state = 6, .external_lex_state = 2},
  [719] = {.lex_state = 6, .external_lex_state = 2},
  [720] = {.lex_state = 6, .external_lex_state = 2},
  [721] = {.lex_state = 6, .external_lex_state = 2},
  [722] = {.lex_state = 6, .external_lex_state = 3},
  [723] = {.lex_state = 7, .external_lex_state = 3},
  [724] = {.lex_state = 6, .external_lex_state = 3},
  [725] = {.lex_state = 6, .external_lex_state = 2},
  [726] = {.lex_state = 6, .external_lex_state = 2},
  [727] = {.lex_state = 6, .external_lex_state = 2},
  [728] = {.lex_state = 6, .external_lex_state = 2},
  [729] = {.lex_state = 6, .external_lex_state = 2},
  [730] = {.lex_state = 6, .external_lex_state = 2},
  [731] = {.lex_state = 6, .external_lex_state = 2},
  [732] = {.lex_state = 6, .external_lex_state = 3},
  [733] = {.lex_state = 6, .external_lex_state = 3},
  [734] = {.lex_state = 63},
  [735] = {.lex_state = 6, .external_lex_state = 3},
  [736] = {.lex_state = 63},
  [737] = {.lex_state = 6, .external_lex_state = 3},
  [738] = {.lex_state = 63},
  [739] = {.lex_state = 63},
  [740] = {.lex_state = 6, .external_lex_state = 3},
  [741] = {.lex_state = 6, .external_lex_state = 3},
  [742] = {.lex_state = 63},
  [743] = {.lex_state = 63},
  [744] = {.lex_state = 63},
  [745] = {.lex_state = 6, .external_lex_state = 3},
  [746] = {.lex_state = 7, .external_lex_state = 3},
  [747] = {.lex_state = 6, .external_lex_state = 3},
  [748] = {.lex_state = 6, .external_lex_state = 3},
  [749] = {.lex_state = 6, .external_lex_state = 3},
  [750] = {.lex_state = 6, .external_lex_state = 2},
  [751] = {.lex_state = 6, .external_lex_state = 3},
  [752] = {.lex_state = 6, .external_lex_state = 3},
  [753] = {.lex_state = 6, .external_lex_state = 3},
  [754] = {.lex_state = 6, .external_lex_state = 2},
  [755] = {.lex_state = 6, .external_lex_state = 2},
  [756] = {.lex_state = 6, .external_lex_state = 3},
  [757] = {.lex_state = 6, .external_lex_state = 2},
  [758] = {.lex_state = 6, .external_lex_state = 3},
  [759] = {.lex_state = 6, .external_lex_state = 3},
  [760] = {.lex_state = 6, .external_lex_state = 2},
  [761] = {.lex_state = 6, .external_lex_state = 3},
  [762] = {.lex_state = 6, .external_lex_state = 3},
  [763] = {.lex_state = 6, .external_lex_state = 3},
  [764] = {.lex_state = 6, .external_lex_state = 2},
  [765] = {.lex_state = 6, .external_lex_state = 2},
  [766] = {.lex_state = 6, .external_lex_state = 3},
  [767] = {.lex_state = 6, .external_lex_state = 2},
  [768] = {.lex_state = 63},
  [769] = {.lex_state = 6, .external_lex_state = 2},
  [770] = {.lex_state = 6, .external_lex_state = 2},
  [771] = {.lex_state = 6, .external_lex_state = 2},
  [772] = {.lex_state = 15},
  [773] = {.lex_state = 6, .external_lex_state = 2},
  [774] = {.lex_state = 6, .external_lex_state = 3},
  [775] = {.lex_state = 6, .external_lex_state = 3},
  [776] = {.lex_state = 6, .external_lex_state = 3},
  [777] = {.lex_state = 6, .external_lex_state = 3},
  [778] = {.lex_state = 6, .external_lex_state = 2},
  [779] = {.lex_state = 15},
  [780] = {.lex_state = 6, .external_lex_state = 2},
  [781] = {.lex_state = 6, .external_lex_state = 2},
  [782] = {.lex_state = 63},
  [783] = {.lex_state = 15},
  [784] = {.lex_state = 6, .external_lex_state = 3},
  [785] = {.lex_state = 15},
  [786] = {.lex_state = 7, .external_lex_state = 3},
  [787] = {.lex_state = 15},
  [788] = {.lex_state = 6, .external_lex_state = 3},
  [789] = {.lex_state = 6, .external_lex_state = 2},
  [790] = {.lex_state = 6, .external_lex_state = 2},
  [791] = {.lex_state = 15},
  [792] = {.lex_state = 15},
  [793] = {.lex_state = 15},
  [794] = {.lex_state = 6, .external_lex_state = 3},
  [795] = {.lex_state = 6, .external_lex_state = 3},
  [796] = {.lex_state = 7, .external_lex_state = 3},
  [797] = {.lex_state = 15},
  [798] = {.lex_state = 15},
  [799] = {.lex_state = 7, .external_lex_state = 3},
  [800] = {.lex_state = 15},
  [801] = {.lex_state = 15},
  [802] = {.lex_state = 6, .external_lex_state = 3},
  [803] = {.lex_state = 7, .external_lex_state = 3},
  [804] = {.lex_state = 15},
  [805] = {.lex_state = 6, .external_lex_state = 3},
  [806] = {.lex_state = 15},
  [807] = {.lex_state = 15},
  [808] = {.lex_state = 15},
  [809] = {.lex_state = 6, .external_lex_state = 2},
  [810] = {.lex_state = 6, .external_lex_state = 3},
  [811] = {.lex_state = 15},
  [812] = {.lex_state = 15},
  [813] = {.lex_state = 15},
  [814] = {.lex_state = 15},
  [815] = {.lex_state = 15},
  [816] = {.lex_state = 15},
  [817] = {.lex_state = 6, .external_lex_state = 3},
  [818] = {.lex_state = 15},
  [819] = {.lex_state = 15},
  [820] = {.lex_state = 15},
  [821] = {.lex_state = 6, .external_lex_state = 2},
  [822] = {.lex_state = 15},
  [823] = {.lex_state = 15},
  [824] = {.lex_state = 6, .external_lex_state = 2},
  [825] = {.lex_state = 6, .external_lex_state = 3},
  [826] = {.lex_state = 6, .external_lex_state = 2},
  [827] = {.lex_state = 6, .external_lex_state = 3},
  [828] = {.lex_state = 15},
  [829] = {.lex_state = 15},
  [830] = {.lex_state = 15},
  [831] = {.lex_state = 15},
  [832] = {.lex_state = 15},
  [833] = {.lex_state = 6, .external_lex_state = 2},
  [834] = {.lex_state = 15},
  [835] = {.lex_state = 6, .external_lex_state = 2},
  [836] = {.lex_state = 15},
  [837] = {.lex_state = 6, .external_lex_state = 2},
  [838] = {.lex_state = 15},
  [839] = {.lex_state = 15},
  [840] = {.lex_state = 6, .external_lex_state = 2},
  [841] = {.lex_state = 15},
  [842] = {.lex_state = 15},
  [843] = {.lex_state = 15},
  [844] = {.lex_state = 6, .external_lex_state = 2},
  [845] = {.lex_state = 15},
  [846] = {.lex_state = 15},
  [847] = {.lex_state = 6, .external_lex_state = 2},
  [848] = {.lex_state = 6, .external_lex_state = 2},
  [849] = {.lex_state = 6, .external_lex_state = 2},
  [850] = {.lex_state = 15},
  [851] = {.lex_state = 15},
  [852] = {.lex_state = 15},
  [853] = {.lex_state = 6, .external_lex_state = 2},
  [854] = {.lex_state = 15},
  [855] = {.lex_state = 15},
  [856] = {.lex_state = 15},
  [857] = {.lex_state = 15},
  [858] = {.lex_state = 15},
  [859] = {.lex_state = 15},
  [860] = {.lex_state = 15},
  [861] = {.lex_state = 15},
  [862] = {.lex_state = 15},
  [863] = {.lex_state = 6, .external_lex_state = 2},
  [864] = {.lex_state = 15},
  [865] = {.lex_state = 15},
  [866] = {.lex_state = 15},
  [867] = {.lex_state = 15},
  [868] = {.lex_state = 6, .external_lex_state = 3},
  [869] = {.lex_state = 6, .external_lex_state = 3},
  [870] = {.lex_state = 6, .external_lex_state = 2},
  [871] = {.lex_state = 6, .external_lex_state = 3},
  [872] = {.lex_state = 7, .external_lex_state = 3},
  [873] = {.lex_state = 15},
  [874] = {.lex_state = 6, .external_lex_state = 2},
  [875] = {.lex_state = 6, .external_lex_state = 2},
  [876] = {.lex_state = 6, .external_lex_state = 2},
  [877] = {.lex_state = 15},
  [878] = {.lex_state = 6, .external_lex_state = 3},
  [879] = {.lex_state = 15},
  [880] = {.lex_state = 15},
  [881] = {.lex_state = 15},
  [882] = {.lex_state = 15},
  [883] = {.lex_state = 7, .external_lex_state = 3},
  [884] = {.lex_state = 15},
  [885] = {.lex_state = 15},
  [886] = {.lex_state = 15},
  [887] = {.lex_state = 15},
  [888] = {.lex_state = 15},
  [889] = {.lex_state = 6, .external_lex_state = 2},
  [890] = {.lex_state = 6, .external_lex_state = 2},
  [891] = {.lex_state = 15},
  [892] = {.lex_state = 15},
  [893] = {.lex_state = 15},
  [894] = {.lex_state = 15},
  [895] = {.lex_state = 6, .external_lex_state = 2},
  [896] = {.lex_state = 15},
  [897] = {.lex_state = 6, .external_lex_state = 2},
  [898] = {.lex_state = 15},
  [899] = {.lex_state = 6, .external_lex_state = 3},
  [900] = {.lex_state = 15},
  [901] = {.lex_state = 15},
  [902] = {.lex_state = 15},
  [903] = {.lex_state = 6, .external_lex_state = 3},
  [904] = {.lex_state = 15},
  [905] = {.lex_state = 15},
  [906] = {.lex_state = 15},
  [907] = {.lex_state = 6, .external_lex_state = 2},
  [908] = {.lex_state = 15},
  [909] = {.lex_state = 15},
  [910] = {.lex_state = 15},
  [911] = {.lex_state = 15},
  [912] = {.lex_state = 6, .external_lex_state = 2},
  [913] = {.lex_state = 15},
  [914] = {.lex_state = 15},
  [915] = {.lex_state = 15},
  [916] = {.lex_state = 15},
  [917] = {.lex_state = 15},
  [918] = {.lex_state = 15},
  [919] = {.lex_state = 15},
  [920] = {.lex_state = 15},
  [921] = {.lex_state = 15},
  [922] = {.lex_state = 15},
  [923] = {.lex_state = 15},
  [924] = {.lex_state = 15},
  [925] = {.lex_state = 6, .external_lex_state = 3},
  [926] = {.lex_state = 15},
  [927] = {.lex_state = 15},
  [928] = {.lex_state = 15},
  [929] = {.lex_state = 15},
  [930] = {.lex_state = 15},
  [931] = {.lex_state = 15},
  [932] = {.lex_state = 15},
  [933] = {.lex_state = 15},
  [934] = {.lex_state = 15},
  [935] = {.lex_state = 6, .external_lex_state = 2},
  [936] = {.lex_state = 15},
  [937] = {.lex_state = 15},
  [938] = {.lex_state = 6, .external_lex_state = 3},
  [939] = {.lex_state = 15},
  [940] = {.lex_state = 15},
  [941] = {.lex_state = 15},
  [942] = {.lex_state = 15},
  [943] = {.lex_state = 6, .external_lex_state = 3},
  [944] = {.lex_state = 6, .external_lex_state = 3},
  [945] = {.lex_state = 6, .external_lex_state = 2},
  [946] = {.lex_state = 6, .external_lex_state = 2},
  [947] = {.lex_state = 6, .external_lex_state = 2},
  [948] = {.lex_state = 6, .external_lex_state = 3},
  [949] = {.lex_state = 6, .external_lex_state = 3},
  [950] = {.lex_state = 6, .external_lex_state = 2},
  [951] = {.lex_state = 6, .external_lex_state = 3},
  [952] = {.lex_state = 6, .external_lex_state = 3},
  [953] = {.lex_state = 6, .external_lex_state = 3},
  [954] = {.lex_state = 7, .external_lex_state = 3},
  [955] = {.lex_state = 6, .external_lex_state = 3},
  [956] = {.lex_state = 6, .external_lex_state = 3},
  [957] = {.lex_state = 6, .external_lex_state = 3},
  [958] = {.lex_state = 6, .external_lex_state = 3},
  [959] = {.lex_state = 6, .external_lex_state = 3},
  [960] = {.lex_state = 6, .external_lex_state = 2},
  [961] = {.lex_state = 6, .external_lex_state = 3},
  [962] = {.lex_state = 6, .external_lex_state = 3},
  [963] = {.lex_state = 6, .external_lex_state = 3},
  [964] = {.lex_state = 7, .external_lex_state = 3},
  [965] = {.lex_state = 6, .external_lex_state = 2},
  [966] = {.lex_state = 7, .external_lex_state = 3},
  [967] = {.lex_state = 6, .external_lex_state = 3},
  [968] = {.lex_state = 6, .external_lex_state = 3},
  [969] = {.lex_state = 6, .external_lex_state = 3},
  [970] = {.lex_state = 7, .external_lex_state = 3},
  [971] = {.lex_state = 6, .external_lex_state = 3},
  [972] = {.lex_state = 6, .external_lex_state = 3},
  [973] = {.lex_state = 6, .external_lex_state = 3},
  [974] = {.lex_state = 6, .external_lex_state = 2},
  [975] = {.lex_state = 7, .external_lex_state = 3},
  [976] = {.lex_state = 6, .external_lex_state = 3},
  [977] = {.lex_state = 6, .external_lex_state = 2},
  [978] = {.lex_state = 6, .external_lex_state = 3},
  [979] = {.lex_state = 7, .external_lex_state = 3},
  [980] = {.lex_state = 7, .external_lex_state = 3},
  [981] = {.lex_state = 7, .external_lex_state = 3},
  [982] = {.lex_state = 6, .external_lex_state = 2},
  [983] = {.lex_state = 6, .external_lex_state = 3},
  [984] = {.lex_state = 6, .external_lex_state = 3},
  [985] = {.lex_state = 7, .external_lex_state = 3},
  [986] = {.lex_state = 6, .external_lex_state = 3},
  [987] = {.lex_state = 7, .external_lex_state = 3},
  [988] = {.lex_state = 6, .external_lex_state = 3},
  [989] = {.lex_state = 7, .external_lex_state = 3},
  [990] = {.lex_state = 7, .external_lex_state = 3},
  [991] = {.lex_state = 6, .external_lex_state = 3},
  [992] = {.lex_state = 6, .external_lex_state = 3},
  [993] = {.lex_state = 7, .external_lex_state = 3},
  [994] = {.lex_state = 6, .external_lex_state = 2},
  [995] = {.lex_state = 6, .external_lex_state = 3},
  [996] = {.lex_state = 6, .external_lex_state = 3},
  [997] = {.lex_state = 6, .external_lex_state = 3},
  [998] = {.lex_state = 6, .external_lex_state = 3},
  [999] = {.lex_state = 6, .external_lex_state = 3},
  [1000] = {.lex_state = 7, .external_lex_state = 3},
  [1001] = {.lex_state = 6, .external_lex_state = 2},
  [1002] = {.lex_state = 6, .external_lex_state = 3},
  [1003] = {.lex_state = 6, .external_lex_state = 3},
  [1004] = {.lex_state = 6, .external_lex_state = 3},
  [1005] = {.lex_state = 6, .external_lex_state = 3},
  [1006] = {.lex_state = 6, .external_lex_state = 3},
  [1007] = {.lex_state = 6, .external_lex_state = 3},
  [1008] = {.lex_state = 6, .external_lex_state = 2},
  [1009] = {.lex_state = 6, .external_lex_state = 3},
  [1010] = {.lex_state = 6, .external_lex_state = 3},
  [1011] = {.lex_state = 6, .external_lex_state = 3},
  [1012] = {.lex_state = 6, .external_lex_state = 3},
  [1013] = {.lex_state = 6, .external_lex_state = 3},
  [1014] = {.lex_state = 6, .external_lex_state = 3},
  [1015] = {.lex_state = 6, .external_lex_state = 3},
  [1016] = {.lex_state = 63},
  [1017] = {.lex_state = 63},
  [1018] = {.lex_state = 63, .external_lex_state = 4},
  [1019] = {.lex_state = 63, .external_lex_state = 4},
  [1020] = {.lex_state = 6, .external_lex_state = 3},
  [1021] = {.lex_state = 63, .external_lex_state = 4},
  [1022] = {.lex_state = 62, .external_lex_state = 2},
  [1023] = {.lex_state = 63},
  [1024] = {.lex_state = 63},
  [1025] = {.lex_state = 6, .external_lex_state = 3},
  [1026] = {.lex_state = 63, .external_lex_state = 4},
  [1027] = {.lex_state = 63},
  [1028] = {.lex_state = 6, .external_lex_state = 3},
  [1029] = {.lex_state = 63, .external_lex_state = 4},
  [1030] = {.lex_state = 63, .external_lex_state = 4},
  [1031] = {.lex_state = 63},
  [1032] = {.lex_state = 63},
  [1033] = {.lex_state = 63},
  [1034] = {.lex_state = 63},
  [1035] = {.lex_state = 63},
  [1036] = {.lex_state = 63},
  [1037] = {.lex_state = 63},
  [1038] = {.lex_state = 63},
  [1039] = {.lex_state = 63},
  [1040] = {.lex_state = 63},
  [1041] = {.lex_state = 63},
  [1042] = {.lex_state = 63},
  [1043] = {.lex_state = 63},
  [1044] = {.lex_state = 63},
  [1045] = {.lex_state = 63},
  [1046] = {.lex_state = 62, .external_lex_state = 3},
  [1047] = {.lex_state = 63},
  [1048] = {.lex_state = 62, .external_lex_state = 3},
  [1049] = {.lex_state = 63},
  [1050] = {.lex_state = 63},
  [1051] = {.lex_state = 62, .external_lex_state = 3},
  [1052] = {.lex_state = 63},
  [1053] = {.lex_state = 62, .external_lex_state = 3},
  [1054] = {.lex_state = 62, .external_lex_state = 3},
  [1055] = {.lex_state = 63},
  [1056] = {.lex_state = 62, .external_lex_state = 3},
  [1057] = {.lex_state = 63},
  [1058] = {.lex_state = 62, .external_lex_state = 3},
  [1059] = {.lex_state = 62, .external_lex_state = 3},
  [1060] = {.lex_state = 62, .external_lex_state = 3},
  [1061] = {.lex_state = 62, .external_lex_state = 3},
  [1062] = {.lex_state = 62, .external_lex_state = 3},
  [1063] = {.lex_state = 62, .external_lex_state = 3},
  [1064] = {.lex_state = 62, .external_lex_state = 3},
  [1065] = {.lex_state = 62, .external_lex_state = 3},
  [1066] = {.lex_state = 62, .external_lex_state = 3},
  [1067] = {.lex_state = 62, .external_lex_state = 3},
  [1068] = {.lex_state = 62, .external_lex_state = 2},
  [1069] = {.lex_state = 62, .external_lex_state = 2},
  [1070] = {.lex_state = 62, .external_lex_state = 2},
  [1071] = {.lex_state = 62, .external_lex_state = 3},
  [1072] = {.lex_state = 62, .external_lex_state = 3},
  [1073] = {.lex_state = 62, .external_lex_state = 3},
  [1074] = {.lex_state = 62, .external_lex_state = 2},
  [1075] = {.lex_state = 62, .external_lex_state = 3},
  [1076] = {.lex_state = 62, .external_lex_state = 3},
  [1077] = {.lex_state = 62, .external_lex_state = 2},
  [1078] = {.lex_state = 62, .external_lex_state = 3},
  [1079] = {.lex_state = 62, .external_lex_state = 3},
  [1080] = {.lex_state = 62, .external_lex_state = 2},
  [1081] = {.lex_state = 62, .external_lex_state = 2},
  [1082] = {.lex_state = 62, .external_lex_state = 2},
  [1083] = {.lex_state = 62, .external_lex_state = 2},
  [1084] = {.lex_state = 62, .external_lex_state = 3},
  [1085] = {.lex_state = 62, .external_lex_state = 3},
  [1086] = {.lex_state = 62, .external_lex_state = 3},
  [1087] = {.lex_state = 62, .external_lex_state = 3},
  [1088] = {.lex_state = 62, .external_lex_state = 3},
  [1089] = {.lex_state = 62, .external_lex_state = 3},
  [1090] = {.lex_state = 62, .external_lex_state = 3},
  [1091] = {.lex_state = 62, .external_lex_state = 3},
  [1092] = {.lex_state = 62, .external_lex_state = 2},
  [1093] = {.lex_state = 62, .external_lex_state = 3},
  [1094] = {.lex_state = 62, .external_lex_state = 3},
  [1095] = {.lex_state = 62, .external_lex_state = 3},
  [1096] = {.lex_state = 62, .external_lex_state = 3},
  [1097] = {.lex_state = 62, .external_lex_state = 3},
  [1098] = {.lex_state = 62, .external_lex_state = 3},
  [1099] = {.lex_state = 62, .external_lex_state = 3},
  [1100] = {.lex_state = 62, .external_lex_state = 3},
  [1101] = {.lex_state = 62, .external_lex_state = 3},
  [1102] = {.lex_state = 62, .external_lex_state = 3},
  [1103] = {.lex_state = 62, .external_lex_state = 3},
  [1104] = {.lex_state = 62, .external_lex_state = 3},
  [1105] = {.lex_state = 62, .external_lex_state = 3},
  [1106] = {.lex_state = 62, .external_lex_state = 3},
  [1107] = {.lex_state = 62, .external_lex_state = 3},
  [1108] = {.lex_state = 62, .external_lex_state = 3},
  [1109] = {.lex_state = 62, .external_lex_state = 3},
  [1110] = {.lex_state = 62, .external_lex_state = 2},
  [1111] = {.lex_state = 62, .external_lex_state = 2},
  [1112] = {.lex_state = 62, .external_lex_state = 3},
  [1113] = {.lex_state = 62, .external_lex_state = 3},
  [1114] = {.lex_state = 62, .external_lex_state = 2},
  [1115] = {.lex_state = 62, .external_lex_state = 2},
  [1116] = {.lex_state = 62, .external_lex_state = 3},
  [1117] = {.lex_state = 62, .external_lex_state = 3},
  [1118] = {.lex_state = 62, .external_lex_state = 3},
  [1119] = {.lex_state = 62, .external_lex_state = 2},
  [1120] = {.lex_state = 62, .external_lex_state = 2},
  [1121] = {.lex_state = 62, .external_lex_state = 2},
  [1122] = {.lex_state = 62, .external_lex_state = 3},
  [1123] = {.lex_state = 62, .external_lex_state = 2},
  [1124] = {.lex_state = 62, .external_lex_state = 3},
  [1125] = {.lex_state = 62, .external_lex_state = 2},
  [1126] = {.lex_state = 62, .external_lex_state = 3},
  [1127] = {.lex_state = 62, .external_lex_state = 2},
  [1128] = {.lex_state = 62, .external_lex_state = 3},
  [1129] = {.lex_state = 15},
  [1130] = {.lex_state = 62, .external_lex_state = 3},
  [1131] = {.lex_state = 62, .external_lex_state = 3},
  [1132] = {.lex_state = 62, .external_lex_state = 2},
  [1133] = {.lex_state = 62, .external_lex_state = 3},
  [1134] = {.lex_state = 62, .external_lex_state = 2},
  [1135] = {.lex_state = 62, .external_lex_state = 3},
  [1136] = {.lex_state = 62, .external_lex_state = 3},
  [1137] = {.lex_state = 62, .external_lex_state = 3},
  [1138] = {.lex_state = 62, .external_lex_state = 3},
  [1139] = {.lex_state = 62, .external_lex_state = 3},
  [1140] = {.lex_state = 62, .external_lex_state = 3},
  [1141] = {.lex_state = 15},
  [1142] = {.lex_state = 62, .external_lex_state = 2},
  [1143] = {.lex_state = 62, .external_lex_state = 3},
  [1144] = {.lex_state = 62, .external_lex_state = 2},
  [1145] = {.lex_state = 62, .external_lex_state = 3},
  [1146] = {.lex_state = 62, .external_lex_state = 2},
  [1147] = {.lex_state = 62, .external_lex_state = 3},
  [1148] = {.lex_state = 62, .external_lex_state = 3},
  [1149] = {.lex_state = 62, .external_lex_state = 3},
  [1150] = {.lex_state = 62, .external_lex_state = 3},
  [1151] = {.lex_state = 62, .external_lex_state = 3},
  [1152] = {.lex_state = 62, .external_lex_state = 3},
  [1153] = {.lex_state = 62, .external_lex_state = 3},
  [1154] = {.lex_state = 62, .external_lex_state = 3},
  [1155] = {.lex_state = 62, .external_lex_state = 2},
  [1156] = {.lex_state = 62, .external_lex_state = 3},
  [1157] = {.lex_state = 62, .external_lex_state = 3},
  [1158] = {.lex_state = 62, .external_lex_state = 3},
  [1159] = {.lex_state = 62, .external_lex_state = 2},
  [1160] = {.lex_state = 8, .external_lex_state = 3},
  [1161] = {.lex_state = 62, .external_lex_state = 3},
  [1162] = {.lex_state = 62, .external_lex_state = 2},
  [1163] = {.lex_state = 62, .external_lex_state = 3},
  [1164] = {.lex_state = 62, .external_lex_state = 3},
  [1165] = {.lex_state = 62, .external_lex_state = 2},
  [1166] = {.lex_state = 62, .external_lex_state = 3},
  [1167] = {.lex_state = 62, .external_lex_state = 2},
  [1168] = {.lex_state = 62, .external_lex_state = 3},
  [1169] = {.lex_state = 62, .external_lex_state = 2},
  [1170] = {.lex_state = 62, .external_lex_state = 2},
  [1171] = {.lex_state = 62, .external_lex_state = 2},
  [1172] = {.lex_state = 62, .external_lex_state = 3},
  [1173] = {.lex_state = 62, .external_lex_state = 3},
  [1174] = {.lex_state = 62, .external_lex_state = 2},
  [1175] = {.lex_state = 62, .external_lex_state = 3},
  [1176] = {.lex_state = 62, .external_lex_state = 3},
  [1177] = {.lex_state = 62, .external_lex_state = 3},
  [1178] = {.lex_state = 62, .external_lex_state = 2},
  [1179] = {.lex_state = 62, .external_lex_state = 3},
  [1180] = {.lex_state = 62, .external_lex_state = 3},
  [1181] = {.lex_state = 62, .external_lex_state = 3},
  [1182] = {.lex_state = 62, .external_lex_state = 3},
  [1183] = {.lex_state = 62, .external_lex_state = 3},
  [1184] = {.lex_state = 62, .external_lex_state = 3},
  [1185] = {.lex_state = 62, .external_lex_state = 2},
  [1186] = {.lex_state = 62, .external_lex_state = 3},
  [1187] = {.lex_state = 62, .external_lex_state = 3},
  [1188] = {.lex_state = 62, .external_lex_state = 3},
  [1189] = {.lex_state = 62, .external_lex_state = 3},
  [1190] = {.lex_state = 15},
  [1191] = {.lex_state = 62, .external_lex_state = 2},
  [1192] = {.lex_state = 62, .external_lex_state = 2},
  [1193] = {.lex_state = 62, .external_lex_state = 2},
  [1194] = {.lex_state = 15},
  [1195] = {.lex_state = 62, .external_lex_state = 3},
  [1196] = {.lex_state = 62, .external_lex_state = 2},
  [1197] = {.lex_state = 62, .external_lex_state = 2},
  [1198] = {.lex_state = 62, .external_lex_state = 2},
  [1199] = {.lex_state = 62, .external_lex_state = 2},
  [1200] = {.lex_state = 62, .external_lex_state = 3},
  [1201] = {.lex_state = 62, .external_lex_state = 3},
  [1202] = {.lex_state = 62, .external_lex_state = 3},
  [1203] = {.lex_state = 62, .external_lex_state = 3},
  [1204] = {.lex_state = 62, .external_lex_state = 3},
  [1205] = {.lex_state = 62, .external_lex_state = 3},
  [1206] = {.lex_state = 62, .external_lex_state = 3},
  [1207] = {.lex_state = 62, .external_lex_state = 3},
  [1208] = {.lex_state = 62, .external_lex_state = 2},
  [1209] = {.lex_state = 62, .external_lex_state = 3},
  [1210] = {.lex_state = 62, .external_lex_state = 3},
  [1211] = {.lex_state = 62, .external_lex_state = 3},
  [1212] = {.lex_state = 62, .external_lex_state = 3},
  [1213] = {.lex_state = 62, .external_lex_state = 2},
  [1214] = {.lex_state = 62, .external_lex_state = 3},
  [1215] = {.lex_state = 62, .external_lex_state = 3},
  [1216] = {.lex_state = 62, .external_lex_state = 3},
  [1217] = {.lex_state = 62, .external_lex_state = 2},
  [1218] = {.lex_state = 62, .external_lex_state = 2},
  [1219] = {.lex_state = 62, .external_lex_state = 3},
  [1220] = {.lex_state = 62, .external_lex_state = 3},
  [1221] = {.lex_state = 62, .external_lex_state = 3},
  [1222] = {.lex_state = 62, .external_lex_state = 3},
  [1223] = {.lex_state = 62, .external_lex_state = 3},
  [1224] = {.lex_state = 62, .external_lex_state = 3},
  [1225] = {.lex_state = 62, .external_lex_state = 3},
  [1226] = {.lex_state = 62, .external_lex_state = 3},
  [1227] = {.lex_state = 15},
  [1228] = {.lex_state = 62, .external_lex_state = 3},
  [1229] = {.lex_state = 62, .external_lex_state = 2},
  [1230] = {.lex_state = 62, .external_lex_state = 2},
  [1231] = {.lex_state = 62, .external_lex_state = 3},
  [1232] = {.lex_state = 62, .external_lex_state = 3},
  [1233] = {.lex_state = 62, .external_lex_state = 3},
  [1234] = {.lex_state = 62, .external_lex_state = 3},
  [1235] = {.lex_state = 62, .external_lex_state = 3},
  [1236] = {.lex_state = 62, .external_lex_state = 2},
  [1237] = {.lex_state = 62, .external_lex_state = 3},
  [1238] = {.lex_state = 62, .external_lex_state = 3},
  [1239] = {.lex_state = 62, .external_lex_state = 3},
  [1240] = {.lex_state = 62, .external_lex_state = 3},
  [1241] = {.lex_state = 62, .external_lex_state = 3},
  [1242] = {.lex_state = 15},
  [1243] = {.lex_state = 62, .external_lex_state = 2},
  [1244] = {.lex_state = 62, .external_lex_state = 2},
  [1245] = {.lex_state = 62, .external_lex_state = 3},
  [1246] = {.lex_state = 62, .external_lex_state = 3},
  [1247] = {.lex_state = 62, .external_lex_state = 3},
  [1248] = {.lex_state = 62, .external_lex_state = 2},
  [1249] = {.lex_state = 62, .external_lex_state = 3},
  [1250] = {.lex_state = 62, .external_lex_state = 3},
  [1251] = {.lex_state = 62, .external_lex_state = 3},
  [1252] = {.lex_state = 62, .external_lex_state = 3},
  [1253] = {.lex_state = 62, .external_lex_state = 3},
  [1254] = {.lex_state = 62, .external_lex_state = 3},
  [1255] = {.lex_state = 62, .external_lex_state = 2},
  [1256] = {.lex_state = 62, .external_lex_state = 3},
  [1257] = {.lex_state = 62, .external_lex_state = 3},
  [1258] = {.lex_state = 62, .external_lex_state = 3},
  [1259] = {.lex_state = 62, .external_lex_state = 3},
  [1260] = {.lex_state = 62, .external_lex_state = 3},
  [1261] = {.lex_state = 62, .external_lex_state = 3},
  [1262] = {.lex_state = 62, .external_lex_state = 3},
  [1263] = {.lex_state = 62, .external_lex_state = 3},
  [1264] = {.lex_state = 62, .external_lex_state = 3},
  [1265] = {.lex_state = 62, .external_lex_state = 3},
  [1266] = {.lex_state = 62, .external_lex_state = 3},
  [1267] = {.lex_state = 62, .external_lex_state = 3},
  [1268] = {.lex_state = 62, .external_lex_state = 3},
  [1269] = {.lex_state = 62, .external_lex_state = 3},
  [1270] = {.lex_state = 62, .external_lex_state = 2},
  [1271] = {.lex_state = 62, .external_lex_state = 3},
  [1272] = {.lex_state = 62, .external_lex_state = 3},
  [1273] = {.lex_state = 62, .external_lex_state = 3},
  [1274] = {.lex_state = 62, .external_lex_state = 2},
  [1275] = {.lex_state = 8, .external_lex_state = 3},
  [1276] = {.lex_state = 62, .external_lex_state = 2},
  [1277] = {.lex_state = 62, .external_lex_state = 2},
  [1278] = {.lex_state = 62, .external_lex_state = 3},
  [1279] = {.lex_state = 62, .external_lex_state = 3},
  [1280] = {.lex_state = 62, .external_lex_state = 3},
  [1281] = {.lex_state = 62, .external_lex_state = 2},
  [1282] = {.lex_state = 62, .external_lex_state = 3},
  [1283] = {.lex_state = 62, .external_lex_state = 3},
  [1284] = {.lex_state = 62, .external_lex_state = 3},
  [1285] = {.lex_state = 62, .external_lex_state = 3},
  [1286] = {.lex_state = 8, .external_lex_state = 3},
  [1287] = {.lex_state = 62, .external_lex_state = 3},
  [1288] = {.lex_state = 62, .external_lex_state = 3},
  [1289] = {.lex_state = 62, .external_lex_state = 3},
  [1290] = {.lex_state = 62, .external_lex_state = 3},
  [1291] = {.lex_state = 62, .external_lex_state = 3},
  [1292] = {.lex_state = 62, .external_lex_state = 2},
  [1293] = {.lex_state = 62, .external_lex_state = 3},
  [1294] = {.lex_state = 8, .external_lex_state = 3},
  [1295] = {.lex_state = 62, .external_lex_state = 2},
  [1296] = {.lex_state = 63},
  [1297] = {.lex_state = 8, .external_lex_state = 3},
  [1298] = {.lex_state = 62, .external_lex_state = 3},
  [1299] = {.lex_state = 62, .external_lex_state = 3},
  [1300] = {.lex_state = 62, .external_lex_state = 3},
  [1301] = {.lex_state = 62, .external_lex_state = 3},
  [1302] = {.lex_state = 62, .external_lex_state = 3},
  [1303] = {.lex_state = 62, .external_lex_state = 3},
  [1304] = {.lex_state = 62, .external_lex_state = 3},
  [1305] = {.lex_state = 62, .external_lex_state = 3},
  [1306] = {.lex_state = 62, .external_lex_state = 3},
  [1307] = {.lex_state = 62, .external_lex_state = 3},
  [1308] = {.lex_state = 62, .external_lex_state = 3},
  [1309] = {.lex_state = 62, .external_lex_state = 3},
  [1310] = {.lex_state = 62, .external_lex_state = 3},
  [1311] = {.lex_state = 62, .external_lex_state = 3},
  [1312] = {.lex_state = 62, .external_lex_state = 3},
  [1313] = {.lex_state = 62, .external_lex_state = 3},
  [1314] = {.lex_state = 62, .external_lex_state = 3},
  [1315] = {.lex_state = 62, .external_lex_state = 3},
  [1316] = {.lex_state = 62, .external_lex_state = 2},
  [1317] = {.lex_state = 62, .external_lex_state = 3},
  [1318] = {.lex_state = 62, .external_lex_state = 3},
  [1319] = {.lex_state = 62, .external_lex_state = 3},
  [1320] = {.lex_state = 8, .external_lex_state = 3},
  [1321] = {.lex_state = 62, .external_lex_state = 2},
  [1322] = {.lex_state = 8, .external_lex_state = 3},
  [1323] = {.lex_state = 62, .external_lex_state = 3},
  [1324] = {.lex_state = 62, .external_lex_state = 3},
  [1325] = {.lex_state = 62, .external_lex_state = 3},
  [1326] = {.lex_state = 8, .external_lex_state = 3},
  [1327] = {.lex_state = 62, .external_lex_state = 3},
  [1328] = {.lex_state = 62, .external_lex_state = 3},
  [1329] = {.lex_state = 62, .external_lex_state = 2},
  [1330] = {.lex_state = 8, .external_lex_state = 3},
  [1331] = {.lex_state = 8, .external_lex_state = 3},
  [1332] = {.lex_state = 62, .external_lex_state = 3},
  [1333] = {.lex_state = 8, .external_lex_state = 3},
  [1334] = {.lex_state = 62, .external_lex_state = 3},
  [1335] = {.lex_state = 8, .external_lex_state = 3},
  [1336] = {.lex_state = 62, .external_lex_state = 3},
  [1337] = {.lex_state = 8, .external_lex_state = 3},
  [1338] = {.lex_state = 8, .external_lex_state = 3},
  [1339] = {.lex_state = 63},
  [1340] = {.lex_state = 63},
  [1341] = {.lex_state = 8, .external_lex_state = 3},
  [1342] = {.lex_state = 8, .external_lex_state = 3},
  [1343] = {.lex_state = 8, .external_lex_state = 3},
  [1344] = {.lex_state = 62, .external_lex_state = 3},
  [1345] = {.lex_state = 62, .external_lex_state = 3},
  [1346] = {.lex_state = 8, .external_lex_state = 3},
  [1347] = {.lex_state = 62, .external_lex_state = 3},
  [1348] = {.lex_state = 62, .external_lex_state = 3},
  [1349] = {.lex_state = 8, .external_lex_state = 3},
  [1350] = {.lex_state = 62, .external_lex_state = 2},
  [1351] = {.lex_state = 8, .external_lex_state = 3},
  [1352] = {.lex_state = 8, .external_lex_state = 3},
  [1353] = {.lex_state = 62, .external_lex_state = 3},
  [1354] = {.lex_state = 62, .external_lex_state = 3},
  [1355] = {.lex_state = 8, .external_lex_state = 3},
  [1356] = {.lex_state = 8, .external_lex_state = 3},
  [1357] = {.lex_state = 62, .external_lex_state = 3},
  [1358] = {.lex_state = 62, .external_lex_state = 3},
  [1359] = {.lex_state = 63},
  [1360] = {.lex_state = 62, .external_lex_state = 2},
  [1361] = {.lex_state = 62, .external_lex_state = 3},
  [1362] = {.lex_state = 62, .external_lex_state = 2},
  [1363] = {.lex_state = 62, .external_lex_state = 3},
  [1364] = {.lex_state = 62, .external_lex_state = 3},
  [1365] = {.lex_state = 62, .external_lex_state = 2},
  [1366] = {.lex_state = 8, .external_lex_state = 3},
  [1367] = {.lex_state = 62, .external_lex_state = 2},
  [1368] = {.lex_state = 62, .external_lex_state = 3},
  [1369] = {.lex_state = 8, .external_lex_state = 3},
  [1370] = {.lex_state = 8, .external_lex_state = 3},
  [1371] = {.lex_state = 8, .external_lex_state = 3},
  [1372] = {.lex_state = 8, .external_lex_state = 3},
  [1373] = {.lex_state = 62, .external_lex_state = 3},
  [1374] = {.lex_state = 62, .external_lex_state = 3},
  [1375] = {.lex_state = 62, .external_lex_state = 2},
  [1376] = {.lex_state = 62, .external_lex_state = 2},
  [1377] = {.lex_state = 62, .external_lex_state = 3},
  [1378] = {.lex_state = 8, .external_lex_state = 3},
  [1379] = {.lex_state = 8, .external_lex_state = 3},
  [1380] = {.lex_state = 8, .external_lex_state = 3},
  [1381] = {.lex_state = 62, .external_lex_state = 3},
  [1382] = {.lex_state = 9, .external_lex_state = 3},
  [1383] = {.lex_state = 62, .external_lex_state = 3},
  [1384] = {.lex_state = 62, .external_lex_state = 2},
  [1385] = {.lex_state = 8, .external_lex_state = 3},
  [1386] = {.lex_state = 62, .external_lex_state = 2},
  [1387] = {.lex_state = 62, .external_lex_state = 2},
  [1388] = {.lex_state = 63},
  [1389] = {.lex_state = 62, .external_lex_state = 3},
  [1390] = {.lex_state = 62, .external_lex_state = 2},
  [1391] = {.lex_state = 62, .external_lex_state = 3},
  [1392] = {.lex_state = 62, .external_lex_state = 3},
  [1393] = {.lex_state = 8, .external_lex_state = 3},
  [1394] = {.lex_state = 62, .external_lex_state = 3},
  [1395] = {.lex_state = 62, .external_lex_state = 2},
  [1396] = {.lex_state = 62, .external_lex_state = 2},
  [1397] = {.lex_state = 8, .external_lex_state = 3},
  [1398] = {.lex_state = 62, .external_lex_state = 3},
  [1399] = {.lex_state = 8, .external_lex_state = 3},
  [1400] = {.lex_state = 62, .external_lex_state = 3},
  [1401] = {.lex_state = 62, .external_lex_state = 2},
  [1402] = {.lex_state = 62, .external_lex_state = 3},
  [1403] = {.lex_state = 62, .external_lex_state = 2},
  [1404] = {.lex_state = 62, .external_lex_state = 2},
  [1405] = {.lex_state = 8, .external_lex_state = 3},
  [1406] = {.lex_state = 63},
  [1407] = {.lex_state = 8, .external_lex_state = 2},
  [1408] = {.lex_state = 62, .external_lex_state = 2},
  [1409] = {.lex_state = 62, .external_lex_state = 2},
  [1410] = {.lex_state = 62, .external_lex_state = 2},
  [1411] = {.lex_state = 62, .external_lex_state = 2},
  [1412] = {.lex_state = 62, .external_lex_state = 2},
  [1413] = {.lex_state = 62, .external_lex_state = 2},
  [1414] = {.lex_state = 62, .external_lex_state = 3},
  [1415] = {.lex_state = 63, .external_lex_state = 4},
  [1416] = {.lex_state = 62, .external_lex_state = 3},
  [1417] = {.lex_state = 63, .external_lex_state = 4},
  [1418] = {.lex_state = 62, .external_lex_state = 2},
  [1419] = {.lex_state = 62, .external_lex_state = 2},
  [1420] = {.lex_state = 63},
  [1421] = {.lex_state = 9, .external_lex_state = 2},
  [1422] = {.lex_state = 63},
  [1423] = {.lex_state = 62, .external_lex_state = 2},
  [1424] = {.lex_state = 63},
  [1425] = {.lex_state = 63},
  [1426] = {.lex_state = 62, .external_lex_state = 3},
  [1427] = {.lex_state = 62, .external_lex_state = 3},
  [1428] = {.lex_state = 62, .external_lex_state = 2},
  [1429] = {.lex_state = 62, .external_lex_state = 3},
  [1430] = {.lex_state = 62, .external_lex_state = 2},
  [1431] = {.lex_state = 63},
  [1432] = {.lex_state = 62, .external_lex_state = 2},
  [1433] = {.lex_state = 62, .external_lex_state = 2},
  [1434] = {.lex_state = 62, .external_lex_state = 3},
  [1435] = {.lex_state = 63},
  [1436] = {.lex_state = 62, .external_lex_state = 3},
  [1437] = {.lex_state = 62, .external_lex_state = 2},
  [1438] = {.lex_state = 63},
  [1439] = {.lex_state = 62, .external_lex_state = 2},
  [1440] = {.lex_state = 62, .external_lex_state = 2},
  [1441] = {.lex_state = 63},
  [1442] = {.lex_state = 62, .external_lex_state = 3},
  [1443] = {.lex_state = 63},
  [1444] = {.lex_state = 63},
  [1445] = {.lex_state = 63, .external_lex_state = 4},
  [1446] = {.lex_state = 63, .external_lex_state = 4},
  [1447] = {.lex_state = 62, .external_lex_state = 2},
  [1448] = {.lex_state = 62, .external_lex_state = 2},
  [1449] = {.lex_state = 62, .external_lex_state = 2},
  [1450] = {.lex_state = 62, .external_lex_state = 3},
  [1451] = {.lex_state = 63, .external_lex_state = 4},
  [1452] = {.lex_state = 63, .external_lex_state = 4},
  [1453] = {.lex_state = 63, .external_lex_state = 4},
  [1454] = {.lex_state = 62, .external_lex_state = 2},
  [1455] = {.lex_state = 62, .external_lex_state = 2},
  [1456] = {.lex_state = 63, .external_lex_state = 4},
  [1457] = {.lex_state = 62, .external_lex_state = 2},
  [1458] = {.lex_state = 62, .external_lex_state = 2},
  [1459] = {.lex_state = 62, .external_lex_state = 3},
  [1460] = {.lex_state = 62, .external_lex_state = 2},
  [1461] = {.lex_state = 62, .external_lex_state = 2},
  [1462] = {.lex_state = 62, .external_lex_state = 2},
  [1463] = {.lex_state = 62, .external_lex_state = 2},
  [1464] = {.lex_state = 62, .external_lex_state = 3},
  [1465] = {.lex_state = 8, .external_lex_state = 3},
  [1466] = {.lex_state = 8, .external_lex_state = 3},
  [1467] = {.lex_state = 62, .external_lex_state = 3},
  [1468] = {.lex_state = 62, .external_lex_state = 2},
  [1469] = {.lex_state = 63, .external_lex_state = 4},
  [1470] = {.lex_state = 62, .external_lex_state = 3},
  [1471] = {.lex_state = 62, .external_lex_state = 2},
  [1472] = {.lex_state = 62, .external_lex_state = 3},
  [1473] = {.lex_state = 62, .external_lex_state = 2},
  [1474] = {.lex_state = 63, .external_lex_state = 4},
  [1475] = {.lex_state = 63, .external_lex_state = 4},
  [1476] = {.lex_state = 62, .external_lex_state = 3},
  [1477] = {.lex_state = 62, .external_lex_state = 2},
  [1478] = {.lex_state = 63},
  [1479] = {.lex_state = 62, .external_lex_state = 2},
  [1480] = {.lex_state = 63},
  [1481] = {.lex_state = 62, .external_lex_state = 2},
  [1482] = {.lex_state = 62, .external_lex_state = 2},
  [1483] = {.lex_state = 62, .external_lex_state = 2},
  [1484] = {.lex_state = 62, .external_lex_state = 2},
  [1485] = {.lex_state = 62, .external_lex_state = 2},
  [1486] = {.lex_state = 62, .external_lex_state = 2},
  [1487] = {.lex_state = 62, .external_lex_state = 2},
  [1488] = {.lex_state = 62, .external_lex_state = 2},
  [1489] = {.lex_state = 62, .external_lex_state = 3},
  [1490] = {.lex_state = 62, .external_lex_state = 2},
  [1491] = {.lex_state = 63},
  [1492] = {.lex_state = 62, .external_lex_state = 2},
  [1493] = {.lex_state = 62, .external_lex_state = 2},
  [1494] = {.lex_state = 62, .external_lex_state = 3},
  [1495] = {.lex_state = 63, .external_lex_state = 4},
  [1496] = {.lex_state = 62, .external_lex_state = 2},
  [1497] = {.lex_state = 62, .external_lex_state = 3},
  [1498] = {.lex_state = 62, .external_lex_state = 2},
  [1499] = {.lex_state = 62, .external_lex_state = 2},
  [1500] = {.lex_state = 62, .external_lex_state = 3},
  [1501] = {.lex_state = 62, .external_lex_state = 2},
  [1502] = {.lex_state = 62, .external_lex_state = 2},
  [1503] = {.lex_state = 62, .external_lex_state = 3},
  [1504] = {.lex_state = 62, .external_lex_state = 3},
  [1505] = {.lex_state = 62, .external_lex_state = 2},
  [1506] = {.lex_state = 62, .external_lex_state = 2},
  [1507] = {.lex_state = 8, .external_lex_state = 3},
  [1508] = {.lex_state = 62, .external_lex_state = 2},
  [1509] = {.lex_state = 62, .external_lex_state = 2},
  [1510] = {.lex_state = 62, .external_lex_state = 2},
  [1511] = {.lex_state = 62, .external_lex_state = 3},
  [1512] = {.lex_state = 62, .external_lex_state = 2},
  [1513] = {.lex_state = 62, .external_lex_state = 2},
  [1514] = {.lex_state = 63, .external_lex_state = 4},
  [1515] = {.lex_state = 8, .external_lex_state = 3},
  [1516] = {.lex_state = 62, .external_lex_state = 2},
  [1517] = {.lex_state = 62, .external_lex_state = 2},
  [1518] = {.lex_state = 62, .external_lex_state = 2},
  [1519] = {.lex_state = 62, .external_lex_state = 2},
  [1520] = {.lex_state = 62, .external_lex_state = 2},
  [1521] = {.lex_state = 62, .external_lex_state = 2},
  [1522] = {.lex_state = 62, .external_lex_state = 3},
  [1523] = {.lex_state = 63, .external_lex_state = 4},
  [1524] = {.lex_state = 62, .external_lex_state = 2},
  [1525] = {.lex_state = 62, .external_lex_state = 2},
  [1526] = {.lex_state = 62, .external_lex_state = 2},
  [1527] = {.lex_state = 62, .external_lex_state = 3},
  [1528] = {.lex_state = 8, .external_lex_state = 3},
  [1529] = {.lex_state = 8, .external_lex_state = 2},
  [1530] = {.lex_state = 8, .external_lex_state = 3},
  [1531] = {.lex_state = 63, .external_lex_state = 4},
  [1532] = {.lex_state = 62, .external_lex_state = 2},
  [1533] = {.lex_state = 62, .external_lex_state = 3},
  [1534] = {.lex_state = 8, .external_lex_state = 3},
  [1535] = {.lex_state = 62, .external_lex_state = 3},
  [1536] = {.lex_state = 8, .external_lex_state = 3},
  [1537] = {.lex_state = 62, .external_lex_state = 2},
  [1538] = {.lex_state = 62, .external_lex_state = 3},
  [1539] = {.lex_state = 62, .external_lex_state = 2},
  [1540] = {.lex_state = 62, .external_lex_state = 2},
  [1541] = {.lex_state = 62, .external_lex_state = 2},
  [1542] = {.lex_state = 62, .external_lex_state = 2},
  [1543] = {.lex_state = 63, .external_lex_state = 4},
  [1544] = {.lex_state = 62, .external_lex_state = 3},
  [1545] = {.lex_state = 62, .external_lex_state = 3},
  [1546] = {.lex_state = 62, .external_lex_state = 2},
  [1547] = {.lex_state = 62, .external_lex_state = 2},
  [1548] = {.lex_state = 8, .external_lex_state = 3},
  [1549] = {.lex_state = 8, .external_lex_state = 3},
  [1550] = {.lex_state = 62, .external_lex_state = 3},
  [1551] = {.lex_state = 62, .external_lex_state = 2},
  [1552] = {.lex_state = 8, .external_lex_state = 3},
  [1553] = {.lex_state = 62, .external_lex_state = 2},
  [1554] = {.lex_state = 8, .external_lex_state = 3},
  [1555] = {.lex_state = 62, .external_lex_state = 2},
  [1556] = {.lex_state = 62, .external_lex_state = 2},
  [1557] = {.lex_state = 62, .external_lex_state = 2},
  [1558] = {.lex_state = 62, .external_lex_state = 2},
  [1559] = {.lex_state = 62, .external_lex_state = 2},
  [1560] = {.lex_state = 62, .external_lex_state = 2},
  [1561] = {.lex_state = 62, .external_lex_state = 2},
  [1562] = {.lex_state = 62, .external_lex_state = 2},
  [1563] = {.lex_state = 62, .external_lex_state = 2},
  [1564] = {.lex_state = 62, .external_lex_state = 2},
  [1565] = {.lex_state = 62, .external_lex_state = 2},
  [1566] = {.lex_state = 62, .external_lex_state = 2},
  [1567] = {.lex_state = 62, .external_lex_state = 2},
  [1568] = {.lex_state = 62, .external_lex_state = 3},
  [1569] = {.lex_state = 62, .external_lex_state = 2},
  [1570] = {.lex_state = 62, .external_lex_state = 2},
  [1571] = {.lex_state = 62, .external_lex_state = 2},
  [1572] = {.lex_state = 62, .external_lex_state = 2},
  [1573] = {.lex_state = 62, .external_lex_state = 3},
  [1574] = {.lex_state = 62, .external_lex_state = 3},
  [1575] = {.lex_state = 62, .external_lex_state = 2},
  [1576] = {.lex_state = 62, .external_lex_state = 2},
  [1577] = {.lex_state = 62, .external_lex_state = 2},
  [1578] = {.lex_state = 62, .external_lex_state = 2},
  [1579] = {.lex_state = 62, .external_lex_state = 2},
  [1580] = {.lex_state = 62, .external_lex_state = 2},
  [1581] = {.lex_state = 62, .external_lex_state = 2},
  [1582] = {.lex_state = 62, .external_lex_state = 3},
  [1583] = {.lex_state = 62, .external_lex_state = 3},
  [1584] = {.lex_state = 62, .external_lex_state = 2},
  [1585] = {.lex_state = 8, .external_lex_state = 2},
  [1586] = {.lex_state = 62, .external_lex_state = 2},
  [1587] = {.lex_state = 62, .external_lex_state = 2},
  [1588] = {.lex_state = 62, .external_lex_state = 2},
  [1589] = {.lex_state = 62, .external_lex_state = 2},
  [1590] = {.lex_state = 62, .external_lex_state = 2},
  [1591] = {.lex_state = 62, .external_lex_state = 2},
  [1592] = {.lex_state = 62, .external_lex_state = 3},
  [1593] = {.lex_state = 62, .external_lex_state = 3},
  [1594] = {.lex_state = 62, .external_lex_state = 3},
  [1595] = {.lex_state = 62, .external_lex_state = 3},
  [1596] = {.lex_state = 62, .external_lex_state = 2},
  [1597] = {.lex_state = 62, .external_lex_state = 3},
  [1598] = {.lex_state = 62, .external_lex_state = 3},
  [1599] = {.lex_state = 62, .external_lex_state = 2},
  [1600] = {.lex_state = 62, .external_lex_state = 2},
  [1601] = {.lex_state = 62, .external_lex_state = 2},
  [1602] = {.lex_state = 62, .external_lex_state = 2},
  [1603] = {.lex_state = 62, .external_lex_state = 3},
  [1604] = {.lex_state = 8, .external_lex_state = 3},
  [1605] = {.lex_state = 62, .external_lex_state = 3},
  [1606] = {.lex_state = 62, .external_lex_state = 3},
  [1607] = {.lex_state = 62, .external_lex_state = 3},
  [1608] = {.lex_state = 62, .external_lex_state = 3},
  [1609] = {.lex_state = 8, .external_lex_state = 3},
  [1610] = {.lex_state = 62, .external_lex_state = 2},
  [1611] = {.lex_state = 62, .external_lex_state = 3},
  [1612] = {.lex_state = 62, .external_lex_state = 2},
  [1613] = {.lex_state = 62, .external_lex_state = 2},
  [1614] = {.lex_state = 62, .external_lex_state = 2},
  [1615] = {.lex_state = 8, .external_lex_state = 3},
  [1616] = {.lex_state = 8, .external_lex_state = 3},
  [1617] = {.lex_state = 62, .external_lex_state = 2},
  [1618] = {.lex_state = 62, .external_lex_state = 2},
  [1619] = {.lex_state = 62, .external_lex_state = 2},
  [1620] = {.lex_state = 62, .external_lex_state = 3},
  [1621] = {.lex_state = 62, .external_lex_state = 3},
  [1622] = {.lex_state = 62, .external_lex_state = 3},
  [1623] = {.lex_state = 62, .external_lex_state = 3},
  [1624] = {.lex_state = 62, .external_lex_state = 3},
  [1625] = {.lex_state = 62, .external_lex_state = 2},
  [1626] = {.lex_state = 62, .external_lex_state = 2},
  [1627] = {.lex_state = 62, .external_lex_state = 3},
  [1628] = {.lex_state = 62, .external_lex_state = 2},
  [1629] = {.lex_state = 62, .external_lex_state = 2},
  [1630] = {.lex_state = 62, .external_lex_state = 3},
  [1631] = {.lex_state = 8, .external_lex_state = 3},
  [1632] = {.lex_state = 8, .external_lex_state = 3},
  [1633] = {.lex_state = 62, .external_lex_state = 3},
  [1634] = {.lex_state = 62, .external_lex_state = 2},
  [1635] = {.lex_state = 62, .external_lex_state = 2},
  [1636] = {.lex_state = 62, .external_lex_state = 2},
  [1637] = {.lex_state = 62, .external_lex_state = 2},
  [1638] = {.lex_state = 62, .external_lex_state = 2},
  [1639] = {.lex_state = 62, .external_lex_state = 3},
  [1640] = {.lex_state = 62, .external_lex_state = 3},
  [1641] = {.lex_state = 62, .external_lex_state = 2},
  [1642] = {.lex_state = 8, .external_lex_state = 3},
  [1643] = {.lex_state = 62, .external_lex_state = 3},
  [1644] = {.lex_state = 62, .external_lex_state = 2},
  [1645] = {.lex_state = 62, .external_lex_state = 2},
  [1646] = {.lex_state = 62, .external_lex_state = 3},
  [1647] = {.lex_state = 62, .external_lex_state = 2},
  [1648] = {.lex_state = 8, .external_lex_state = 3},
  [1649] = {.lex_state = 62, .external_lex_state = 3},
  [1650] = {.lex_state = 62, .external_lex_state = 3},
  [1651] = {.lex_state = 62, .external_lex_state = 3},
  [1652] = {.lex_state = 62, .external_lex_state = 3},
  [1653] = {.lex_state = 8, .external_lex_state = 3},
  [1654] = {.lex_state = 62, .external_lex_state = 3},
  [1655] = {.lex_state = 62, .external_lex_state = 3},
  [1656] = {.lex_state = 62, .external_lex_state = 3},
  [1657] = {.lex_state = 62, .external_lex_state = 3},
  [1658] = {.lex_state = 62, .external_lex_state = 3},
  [1659] = {.lex_state = 62, .external_lex_state = 3},
  [1660] = {.lex_state = 62, .external_lex_state = 3},
  [1661] = {.lex_state = 62, .external_lex_state = 3},
  [1662] = {.lex_state = 62, .external_lex_state = 3},
  [1663] = {.lex_state = 62, .external_lex_state = 2},
  [1664] = {.lex_state = 62, .external_lex_state = 2},
  [1665] = {.lex_state = 62, .external_lex_state = 3},
  [1666] = {.lex_state = 62, .external_lex_state = 3},
  [1667] = {.lex_state = 62, .external_lex_state = 3},
  [1668] = {.lex_state = 62, .external_lex_state = 3},
  [1669] = {.lex_state = 62, .external_lex_state = 3},
  [1670] = {.lex_state = 62, .external_lex_state = 2},
  [1671] = {.lex_state = 62, .external_lex_state = 3},
  [1672] = {.lex_state = 62, .external_lex_state = 3},
  [1673] = {.lex_state = 63, .external_lex_state = 4},
  [1674] = {.lex_state = 9, .external_lex_state = 3},
  [1675] = {.lex_state = 62, .external_lex_state = 2},
  [1676] = {.lex_state = 62, .external_lex_state = 2},
  [1677] = {.lex_state = 63, .external_lex_state = 4},
  [1678] = {.lex_state = 62, .external_lex_state = 3},
  [1679] = {.lex_state = 63, .external_lex_state = 4},
  [1680] = {.lex_state = 63, .external_lex_state = 4},
  [1681] = {.lex_state = 62, .external_lex_state = 3},
  [1682] = {.lex_state = 62, .external_lex_state = 3},
  [1683] = {.lex_state = 62, .external_lex_state = 3},
  [1684] = {.lex_state = 62, .external_lex_state = 3},
  [1685] = {.lex_state = 62, .external_lex_state = 2},
  [1686] = {.lex_state = 62, .external_lex_state = 2},
  [1687] = {.lex_state = 62, .external_lex_state = 2},
  [1688] = {.lex_state = 62, .external_lex_state = 2},
  [1689] = {.lex_state = 62, .external_lex_state = 3},
  [1690] = {.lex_state = 62, .external_lex_state = 3},
  [1691] = {.lex_state = 62, .external_lex_state = 2},
  [1692] = {.lex_state = 62, .external_lex_state = 3},
  [1693] = {.lex_state = 62, .external_lex_state = 3},
  [1694] = {.lex_state = 63, .external_lex_state = 4},
  [1695] = {.lex_state = 62, .external_lex_state = 2},
  [1696] = {.lex_state = 62, .external_lex_state = 3},
  [1697] = {.lex_state = 62, .external_lex_state = 3},
  [1698] = {.lex_state = 62, .external_lex_state = 2},
  [1699] = {.lex_state = 62, .external_lex_state = 3},
  [1700] = {.lex_state = 62, .external_lex_state = 3},
  [1701] = {.lex_state = 62, .external_lex_state = 2},
  [1702] = {.lex_state = 11, .external_lex_state = 3},
  [1703] = {.lex_state = 62, .external_lex_state = 3},
  [1704] = {.lex_state = 62, .external_lex_state = 3},
  [1705] = {.lex_state = 62, .external_lex_state = 3},
  [1706] = {.lex_state = 62, .external_lex_state = 3},
  [1707] = {.lex_state = 62, .external_lex_state = 3},
  [1708] = {.lex_state = 8, .external_lex_state = 3},
  [1709] = {.lex_state = 63, .external_lex_state = 4},
  [1710] = {.lex_state = 62, .external_lex_state = 3},
  [1711] = {.lex_state = 63, .external_lex_state = 4},
  [1712] = {.lex_state = 63, .external_lex_state = 4},
  [1713] = {.lex_state = 63, .external_lex_state = 4},
  [1714] = {.lex_state = 62, .external_lex_state = 3},
  [1715] = {.lex_state = 63, .external_lex_state = 4},
  [1716] = {.lex_state = 63, .external_lex_state = 4},
  [1717] = {.lex_state = 63, .external_lex_state = 4},
  [1718] = {.lex_state = 8, .external_lex_state = 3},
  [1719] = {.lex_state = 8, .external_lex_state = 3},
  [1720] = {.lex_state = 8, .external_lex_state = 3},
  [1721] = {.lex_state = 62, .external_lex_state = 2},
  [1722] = {.lex_state = 62, .external_lex_state = 2},
  [1723] = {.lex_state = 63, .external_lex_state = 4},
  [1724] = {.lex_state = 63, .external_lex_state = 4},
  [1725] = {.lex_state = 63, .external_lex_state = 4},
  [1726] = {.lex_state = 63, .external_lex_state = 4},
  [1727] = {.lex_state = 8, .external_lex_state = 3},
  [1728] = {.lex_state = 63, .external_lex_state = 4},
  [1729] = {.lex_state = 63, .external_lex_state = 4},
  [1730] = {.lex_state = 63, .external_lex_state = 4},
  [1731] = {.lex_state = 63, .external_lex_state = 4},
  [1732] = {.lex_state = 63, .external_lex_state = 4},
  [1733] = {.lex_state = 63, .external_lex_state = 4},
  [1734] = {.lex_state = 62, .external_lex_state = 3},
  [1735] = {.lex_state = 8, .external_lex_state = 3},
  [1736] = {.lex_state = 8, .external_lex_state = 3},
  [1737] = {.lex_state = 63, .external_lex_state = 4},
  [1738] = {.lex_state = 63, .external_lex_state = 4},
  [1739] = {.lex_state = 8, .external_lex_state = 3},
  [1740] = {.lex_state = 8, .external_lex_state = 3},
  [1741] = {.lex_state = 8, .external_lex_state = 3},
  [1742] = {.lex_state = 8, .external_lex_state = 3},
  [1743] = {.lex_state = 8, .external_lex_state = 3},
  [1744] = {.lex_state = 8, .external_lex_state = 3},
  [1745] = {.lex_state = 8, .external_lex_state = 3},
  [1746] = {.lex_state = 8, .external_lex_state = 3},
  [1747] = {.lex_state = 8, .external_lex_state = 3},
  [1748] = {.lex_state = 8, .external_lex_state = 3},
  [1749] = {.lex_state = 8, .external_lex_state = 3},
  [1750] = {.lex_state = 8, .external_lex_state = 3},
  [1751] = {.lex_state = 8, .external_lex_state = 3},
  [1752] = {.lex_state = 8, .external_lex_state = 3},
  [1753] = {.lex_state = 8, .external_lex_state = 3},
  [1754] = {.lex_state = 8, .external_lex_state = 3},
  [1755] = {.lex_state = 8, .external_lex_state = 3},
  [1756] = {.lex_state = 8, .external_lex_state = 3},
  [1757] = {.lex_state = 8, .external_lex_state = 3},
  [1758] = {.lex_state = 8, .external_lex_state = 3},
  [1759] = {.lex_state = 8, .external_lex_state = 3},
  [1760] = {.lex_state = 8, .external_lex_state = 3},
  [1761] = {.lex_state = 8, .external_lex_state = 3},
  [1762] = {.lex_state = 8, .external_lex_state = 3},
  [1763] = {.lex_state = 8, .external_lex_state = 3},
  [1764] = {.lex_state = 8, .external_lex_state = 3},
  [1765] = {.lex_state = 8, .external_lex_state = 3},
  [1766] = {.lex_state = 8, .external_lex_state = 3},
  [1767] = {.lex_state = 8, .external_lex_state = 3},
  [1768] = {.lex_state = 8, .external_lex_state = 3},
  [1769] = {.lex_state = 62, .external_lex_state = 2},
  [1770] = {.lex_state = 62, .external_lex_state = 3},
  [1771] = {.lex_state = 8, .external_lex_state = 3},
  [1772] = {.lex_state = 8, .external_lex_state = 3},
  [1773] = {.lex_state = 8, .external_lex_state = 3},
  [1774] = {.lex_state = 62, .external_lex_state = 3},
  [1775] = {.lex_state = 8, .external_lex_state = 3},
  [1776] = {.lex_state = 8, .external_lex_state = 3},
  [1777] = {.lex_state = 8, .external_lex_state = 3},
  [1778] = {.lex_state = 8, .external_lex_state = 3},
  [1779] = {.lex_state = 8, .external_lex_state = 3},
  [1780] = {.lex_state = 62, .external_lex_state = 3},
  [1781] = {.lex_state = 8, .external_lex_state = 3},
  [1782] = {.lex_state = 8, .external_lex_state = 3},
  [1783] = {.lex_state = 62, .external_lex_state = 3},
  [1784] = {.lex_state = 8, .external_lex_state = 3},
  [1785] = {.lex_state = 8, .external_lex_state = 3},
  [1786] = {.lex_state = 62, .external_lex_state = 3},
  [1787] = {.lex_state = 8, .external_lex_state = 3},
  [1788] = {.lex_state = 8, .external_lex_state = 3},
  [1789] = {.lex_state = 8, .external_lex_state = 3},
  [1790] = {.lex_state = 8, .external_lex_state = 3},
  [1791] = {.lex_state = 8, .external_lex_state = 3},
  [1792] = {.lex_state = 8, .external_lex_state = 3},
  [1793] = {.lex_state = 8, .external_lex_state = 3},
  [1794] = {.lex_state = 8, .external_lex_state = 3},
  [1795] = {.lex_state = 8, .external_lex_state = 3},
  [1796] = {.lex_state = 8, .external_lex_state = 3},
  [1797] = {.lex_state = 62, .external_lex_state = 2},
  [1798] = {.lex_state = 8, .external_lex_state = 3},
  [1799] = {.lex_state = 8, .external_lex_state = 3},
  [1800] = {.lex_state = 8, .external_lex_state = 3},
  [1801] = {.lex_state = 8, .external_lex_state = 3},
  [1802] = {.lex_state = 8, .external_lex_state = 3},
  [1803] = {.lex_state = 63, .external_lex_state = 4},
  [1804] = {.lex_state = 8, .external_lex_state = 3},
  [1805] = {.lex_state = 8, .external_lex_state = 3},
  [1806] = {.lex_state = 63, .external_lex_state = 4},
  [1807] = {.lex_state = 8, .external_lex_state = 3},
  [1808] = {.lex_state = 63, .external_lex_state = 4},
  [1809] = {.lex_state = 8, .external_lex_state = 3},
  [1810] = {.lex_state = 8, .external_lex_state = 3},
  [1811] = {.lex_state = 8, .external_lex_state = 3},
  [1812] = {.lex_state = 8, .external_lex_state = 3},
  [1813] = {.lex_state = 8, .external_lex_state = 3},
  [1814] = {.lex_state = 8, .external_lex_state = 3},
  [1815] = {.lex_state = 8, .external_lex_state = 3},
  [1816] = {.lex_state = 62, .external_lex_state = 3},
  [1817] = {.lex_state = 8, .external_lex_state = 3},
  [1818] = {.lex_state = 8, .external_lex_state = 3},
  [1819] = {.lex_state = 8, .external_lex_state = 3},
  [1820] = {.lex_state = 8, .external_lex_state = 3},
  [1821] = {.lex_state = 8, .external_lex_state = 3},
  [1822] = {.lex_state = 8, .external_lex_state = 3},
  [1823] = {.lex_state = 8, .external_lex_state = 3},
  [1824] = {.lex_state = 62, .external_lex_state = 3},
  [1825] = {.lex_state = 8, .external_lex_state = 3},
  [1826] = {.lex_state = 8, .external_lex_state = 3},
  [1827] = {.lex_state = 63, .external_lex_state = 4},
  [1828] = {.lex_state = 8, .external_lex_state = 3},
  [1829] = {.lex_state = 63, .external_lex_state = 4},
  [1830] = {.lex_state = 8, .external_lex_state = 3},
  [1831] = {.lex_state = 8, .external_lex_state = 3},
  [1832] = {.lex_state = 8, .external_lex_state = 3},
  [1833] = {.lex_state = 8, .external_lex_state = 3},
  [1834] = {.lex_state = 8, .external_lex_state = 3},
  [1835] = {.lex_state = 8, .external_lex_state = 3},
  [1836] = {.lex_state = 63, .external_lex_state = 4},
  [1837] = {.lex_state = 8, .external_lex_state = 3},
  [1838] = {.lex_state = 8, .external_lex_state = 3},
  [1839] = {.lex_state = 8, .external_lex_state = 3},
  [1840] = {.lex_state = 8, .external_lex_state = 3},
  [1841] = {.lex_state = 63, .external_lex_state = 4},
  [1842] = {.lex_state = 63, .external_lex_state = 4},
  [1843] = {.lex_state = 63, .external_lex_state = 4},
  [1844] = {.lex_state = 63},
  [1845] = {.lex_state = 62, .external_lex_state = 3},
  [1846] = {.lex_state = 62, .external_lex_state = 3},
  [1847] = {.lex_state = 63, .external_lex_state = 4},
  [1848] = {.lex_state = 63},
  [1849] = {.lex_state = 63},
  [1850] = {.lex_state = 63, .external_lex_state = 4},
  [1851] = {.lex_state = 63},
  [1852] = {.lex_state = 62, .external_lex_state = 3},
  [1853] = {.lex_state = 63, .external_lex_state = 4},
  [1854] = {.lex_state = 63},
  [1855] = {.lex_state = 62, .external_lex_state = 3},
  [1856] = {.lex_state = 62, .external_lex_state = 3},
  [1857] = {.lex_state = 63},
  [1858] = {.lex_state = 63, .external_lex_state = 4},
  [1859] = {.lex_state = 63, .external_lex_state = 4},
  [1860] = {.lex_state = 63, .external_lex_state = 4},
  [1861] = {.lex_state = 63, .external_lex_state = 4},
  [1862] = {.lex_state = 63},
  [1863] = {.lex_state = 63, .external_lex_state = 4},
  [1864] = {.lex_state = 63},
  [1865] = {.lex_state = 63},
  [1866] = {.lex_state = 62, .external_lex_state = 3},
  [1867] = {.lex_state = 62, .external_lex_state = 3},
  [1868] = {.lex_state = 63, .external_lex_state = 4},
  [1869] = {.lex_state = 63, .external_lex_state = 4},
  [1870] = {.lex_state = 63, .external_lex_state = 4},
  [1871] = {.lex_state = 62, .external_lex_state = 3},
  [1872] = {.lex_state = 62, .external_lex_state = 3},
  [1873] = {.lex_state = 62, .external_lex_state = 3},
  [1874] = {.lex_state = 63},
  [1875] = {.lex_state = 63},
  [1876] = {.lex_state = 63, .external_lex_state = 4},
  [1877] = {.lex_state = 63, .external_lex_state = 4},
  [1878] = {.lex_state = 63},
  [1879] = {.lex_state = 63, .external_lex_state = 4},
  [1880] = {.lex_state = 62, .external_lex_state = 3},
  [1881] = {.lex_state = 63},
  [1882] = {.lex_state = 63, .external_lex_state = 4},
  [1883] = {.lex_state = 63, .external_lex_state = 4},
  [1884] = {.lex_state = 63},
  [1885] = {.lex_state = 63},
  [1886] = {.lex_state = 63},
  [1887] = {.lex_state = 63},
  [1888] = {.lex_state = 63},
  [1889] = {.lex_state = 63},
  [1890] = {.lex_state = 63},
  [1891] = {.lex_state = 63},
  [1892] = {.lex_state = 63},
  [1893] = {.lex_state = 63},
  [1894] = {.lex_state = 63},
  [1895] = {.lex_state = 63},
  [1896] = {.lex_state = 63, .external_lex_state = 4},
  [1897] = {.lex_state = 63},
  [1898] = {.lex_state = 63},
  [1899] = {.lex_state = 63},
  [1900] = {.lex_state = 63},
  [1901] = {.lex_state = 63},
  [1902] = {.lex_state = 63},
  [1903] = {.lex_state = 63},
  [1904] = {.lex_state = 63},
  [1905] = {.lex_state = 63},
  [1906] = {.lex_state = 63},
  [1907] = {.lex_state = 63},
  [1908] = {.lex_state = 63},
  [1909] = {.lex_state = 63},
  [1910] = {.lex_state = 63},
  [1911] = {.lex_state = 63},
  [1912] = {.lex_state = 63},
  [1913] = {.lex_state = 63},
  [1914] = {.lex_state = 63},
  [1915] = {.lex_state = 63},
  [1916] = {.lex_state = 63},
  [1917] = {.lex_state = 63},
  [1918] = {.lex_state = 63},
  [1919] = {.lex_state = 63},
  [1920] = {.lex_state = 63},
  [1921] = {.lex_state = 63},
  [1922] = {.lex_state = 63},
  [1923] = {.lex_state = 63},
  [1924] = {.lex_state = 63},
  [1925] = {.lex_state = 63},
  [1926] = {.lex_state = 63},
  [1927] = {.lex_state = 63},
  [1928] = {.lex_state = 63},
  [1929] = {.lex_state = 63},
  [1930] = {.lex_state = 63},
  [1931] = {.lex_state = 63},
  [1932] = {.lex_state = 63},
  [1933] = {.lex_state = 63},
  [1934] = {.lex_state = 63},
  [1935] = {.lex_state = 63},
  [1936] = {.lex_state = 63},
  [1937] = {.lex_state = 63},
  [1938] = {.lex_state = 63},
  [1939] = {.lex_state = 63, .external_lex_state = 4},
  [1940] = {.lex_state = 63, .external_lex_state = 4},
  [1941] = {.lex_state = 63},
  [1942] = {.lex_state = 63},
  [1943] = {.lex_state = 63},
  [1944] = {.lex_state = 63, .external_lex_state = 4},
  [1945] = {.lex_state = 63, .external_lex_state = 4},
  [1946] = {.lex_state = 63},
  [1947] = {.lex_state = 63},
  [1948] = {.lex_state = 63, .external_lex_state = 4},
  [1949] = {.lex_state = 63, .external_lex_state = 4},
  [1950] = {.lex_state = 63},
  [1951] = {.lex_state = 63},
  [1952] = {.lex_state = 63},
  [1953] = {.lex_state = 63, .external_lex_state = 4},
  [1954] = {.lex_state = 63, .external_lex_state = 4},
  [1955] = {.lex_state = 63, .external_lex_state = 4},
  [1956] = {.lex_state = 63},
  [1957] = {.lex_state = 63, .external_lex_state = 4},
  [1958] = {.lex_state = 63, .external_lex_state = 4},
  [1959] = {.lex_state = 63},
  [1960] = {.lex_state = 63},
  [1961] = {.lex_state = 63, .external_lex_state = 4},
  [1962] = {.lex_state = 63},
  [1963] = {.lex_state = 63, .external_lex_state = 4},
  [1964] = {.lex_state = 63},
  [1965] = {.lex_state = 63, .external_lex_state = 4},
  [1966] = {.lex_state = 63},
  [1967] = {.lex_state = 63, .external_lex_state = 4},
  [1968] = {.lex_state = 63, .external_lex_state = 4},
  [1969] = {.lex_state = 63},
  [1970] = {.lex_state = 63},
  [1971] = {.lex_state = 63},
  [1972] = {.lex_state = 63, .external_lex_state = 4},
  [1973] = {.lex_state = 63},
  [1974] = {.lex_state = 63},
  [1975] = {.lex_state = 63},
  [1976] = {.lex_state = 63},
  [1977] = {.lex_state = 63},
  [1978] = {.lex_state = 63},
  [1979] = {.lex_state = 63},
  [1980] = {.lex_state = 63},
  [1981] = {.lex_state = 63},
  [1982] = {.lex_state = 63},
  [1983] = {.lex_state = 63},
  [1984] = {.lex_state = 63},
  [1985] = {.lex_state = 63},
  [1986] = {.lex_state = 63},
  [1987] = {.lex_state = 63},
  [1988] = {.lex_state = 63},
  [1989] = {.lex_state = 63},
  [1990] = {.lex_state = 63},
  [1991] = {.lex_state = 63},
  [1992] = {.lex_state = 63},
  [1993] = {.lex_state = 63},
  [1994] = {.lex_state = 63},
  [1995] = {.lex_state = 63},
  [1996] = {.lex_state = 63},
  [1997] = {.lex_state = 63},
  [1998] = {.lex_state = 63},
  [1999] = {.lex_state = 63},
  [2000] = {.lex_state = 63},
  [2001] = {.lex_state = 63},
  [2002] = {.lex_state = 63},
  [2003] = {.lex_state = 63},
  [2004] = {.lex_state = 63},
  [2005] = {.lex_state = 63},
  [2006] = {.lex_state = 63},
  [2007] = {.lex_state = 63},
  [2008] = {.lex_state = 63},
  [2009] = {.lex_state = 63},
  [2010] = {.lex_state = 63},
  [2011] = {.lex_state = 63},
  [2012] = {.lex_state = 63},
  [2013] = {.lex_state = 63},
  [2014] = {.lex_state = 63},
  [2015] = {.lex_state = 63},
  [2016] = {.lex_state = 63},
  [2017] = {.lex_state = 63, .external_lex_state = 4},
  [2018] = {.lex_state = 63, .external_lex_state = 4},
  [2019] = {.lex_state = 63},
  [2020] = {.lex_state = 63, .external_lex_state = 4},
  [2021] = {.lex_state = 63},
  [2022] = {.lex_state = 63, .external_lex_state = 4},
  [2023] = {.lex_state = 63, .external_lex_state = 4},
  [2024] = {.lex_state = 63},
  [2025] = {.lex_state = 63, .external_lex_state = 4},
  [2026] = {.lex_state = 63, .external_lex_state = 4},
  [2027] = {.lex_state = 63, .external_lex_state = 4},
  [2028] = {.lex_state = 63},
  [2029] = {.lex_state = 63, .external_lex_state = 4},
  [2030] = {.lex_state = 63, .external_lex_state = 4},
  [2031] = {.lex_state = 63, .external_lex_state = 4},
  [2032] = {.lex_state = 63, .external_lex_state = 4},
  [2033] = {.lex_state = 63, .external_lex_state = 4},
  [2034] = {.lex_state = 63, .external_lex_state = 4},
  [2035] = {.lex_state = 63, .external_lex_state = 4},
  [2036] = {.lex_state = 63, .external_lex_state = 4},
  [2037] = {.lex_state = 63, .external_lex_state = 4},
  [2038] = {.lex_state = 63, .external_lex_state = 4},
  [2039] = {.lex_state = 63, .external_lex_state = 4},
  [2040] = {.lex_state = 63, .external_lex_state = 4},
  [2041] = {.lex_state = 63, .external_lex_state = 4},
  [2042] = {.lex_state = 63},
  [2043] = {.lex_state = 63, .external_lex_state = 4},
  [2044] = {.lex_state = 63, .external_lex_state = 4},
  [2045] = {.lex_state = 63, .external_lex_state = 4},
  [2046] = {.lex_state = 63, .external_lex_state = 4},
  [2047] = {.lex_state = 63, .external_lex_state = 4},
  [2048] = {.lex_state = 63},
  [2049] = {.lex_state = 63, .external_lex_state = 4},
  [2050] = {.lex_state = 63},
  [2051] = {.lex_state = 63, .external_lex_state = 4},
  [2052] = {.lex_state = 63, .external_lex_state = 4},
  [2053] = {.lex_state = 63},
  [2054] = {.lex_state = 63},
  [2055] = {.lex_state = 63, .external_lex_state = 4},
  [2056] = {.lex_state = 63, .external_lex_state = 4},
  [2057] = {.lex_state = 63},
  [2058] = {.lex_state = 63, .external_lex_state = 4},
  [2059] = {.lex_state = 63, .external_lex_state = 4},
  [2060] = {.lex_state = 63, .external_lex_state = 4},
  [2061] = {.lex_state = 63, .external_lex_state = 4},
  [2062] = {.lex_state = 63, .external_lex_state = 4},
  [2063] = {.lex_state = 63, .external_lex_state = 4},
  [2064] = {.lex_state = 63, .external_lex_state = 4},
  [2065] = {.lex_state = 63, .external_lex_state = 4},
  [2066] = {.lex_state = 63, .external_lex_state = 4},
  [2067] = {.lex_state = 63, .external_lex_state = 4},
  [2068] = {.lex_state = 63, .external_lex_state = 4},
  [2069] = {.lex_state = 63, .external_lex_state = 4},
  [2070] = {.lex_state = 63, .external_lex_state = 4},
  [2071] = {.lex_state = 63, .external_lex_state = 4},
  [2072] = {.lex_state = 63, .external_lex_state = 4},
  [2073] = {.lex_state = 63, .external_lex_state = 4},
  [2074] = {.lex_state = 63, .external_lex_state = 4},
  [2075] = {.lex_state = 63, .external_lex_state = 4},
  [2076] = {.lex_state = 63},
  [2077] = {.lex_state = 63, .external_lex_state = 4},
  [2078] = {.lex_state = 63, .external_lex_state = 4},
  [2079] = {.lex_state = 63, .external_lex_state = 4},
  [2080] = {.lex_state = 63, .external_lex_state = 4},
  [2081] = {.lex_state = 63, .external_lex_state = 4},
  [2082] = {.lex_state = 63, .external_lex_state = 4},
  [2083] = {.lex_state = 63, .external_lex_state = 4},
  [2084] = {.lex_state = 63, .external_lex_state = 4},
  [2085] = {.lex_state = 63, .external_lex_state = 4},
  [2086] = {.lex_state = 63, .external_lex_state = 4},
  [2087] = {.lex_state = 63},
  [2088] = {.lex_state = 63},
  [2089] = {.lex_state = 63, .external_lex_state = 4},
  [2090] = {.lex_state = 63, .external_lex_state = 4},
  [2091] = {.lex_state = 63, .external_lex_state = 4},
  [2092] = {.lex_state = 63, .external_lex_state = 4},
  [2093] = {.lex_state = 63},
  [2094] = {.lex_state = 63, .external_lex_state = 4},
  [2095] = {.lex_state = 63},
  [2096] = {.lex_state = 63, .external_lex_state = 4},
  [2097] = {.lex_state = 63, .external_lex_state = 4},
  [2098] = {.lex_state = 63},
  [2099] = {.lex_state = 63, .external_lex_state = 4},
  [2100] = {.lex_state = 63, .external_lex_state = 4},
  [2101] = {.lex_state = 63, .external_lex_state = 4},
  [2102] = {.lex_state = 63, .external_lex_state = 4},
  [2103] = {.lex_state = 63, .external_lex_state = 4},
  [2104] = {.lex_state = 63, .external_lex_state = 4},
  [2105] = {.lex_state = 63},
  [2106] = {.lex_state = 63, .external_lex_state = 4},
  [2107] = {.lex_state = 63},
  [2108] = {.lex_state = 63, .external_lex_state = 4},
  [2109] = {.lex_state = 63, .external_lex_state = 4},
  [2110] = {.lex_state = 63, .external_lex_state = 4},
  [2111] = {.lex_state = 63},
  [2112] = {.lex_state = 63},
  [2113] = {.lex_state = 63},
  [2114] = {.lex_state = 63},
  [2115] = {.lex_state = 63},
  [2116] = {.lex_state = 63},
  [2117] = {.lex_state = 63},
  [2118] = {.lex_state = 63, .external_lex_state = 4},
  [2119] = {.lex_state = 63},
  [2120] = {.lex_state = 63},
  [2121] = {.lex_state = 63},
  [2122] = {.lex_state = 63},
  [2123] = {.lex_state = 63},
  [2124] = {.lex_state = 63},
  [2125] = {.lex_state = 63},
  [2126] = {.lex_state = 63},
  [2127] = {.lex_state = 63},
  [2128] = {.lex_state = 63},
  [2129] = {.lex_state = 63},
  [2130] = {.lex_state = 63, .external_lex_state = 4},
  [2131] = {.lex_state = 63},
  [2132] = {.lex_state = 63, .external_lex_state = 4},
  [2133] = {.lex_state = 63, .external_lex_state = 4},
  [2134] = {.lex_state = 63},
  [2135] = {.lex_state = 63},
  [2136] = {.lex_state = 63, .external_lex_state = 4},
  [2137] = {.lex_state = 63, .external_lex_state = 4},
  [2138] = {.lex_state = 63},
  [2139] = {.lex_state = 63},
  [2140] = {.lex_state = 63},
  [2141] = {.lex_state = 63},
  [2142] = {.lex_state = 63},
  [2143] = {.lex_state = 63},
  [2144] = {.lex_state = 63},
  [2145] = {.lex_state = 63},
  [2146] = {.lex_state = 63, .external_lex_state = 4},
  [2147] = {.lex_state = 63},
  [2148] = {.lex_state = 63, .external_lex_state = 4},
  [2149] = {.lex_state = 63},
  [2150] = {.lex_state = 63},
  [2151] = {.lex_state = 63},
  [2152] = {.lex_state = 63},
  [2153] = {.lex_state = 63},
  [2154] = {.lex_state = 63, .external_lex_state = 4},
  [2155] = {.lex_state = 63, .external_lex_state = 4},
  [2156] = {.lex_state = 0, .external_lex_state = 4},
  [2157] = {.lex_state = 63},
  [2158] = {.lex_state = 63, .external_lex_state = 4},
  [2159] = {.lex_state = 63},
  [2160] = {.lex_state = 0, .external_lex_state = 4},
  [2161] = {.lex_state = 63},
  [2162] = {.lex_state = 63},
  [2163] = {.lex_state = 63},
  [2164] = {.lex_state = 63},
  [2165] = {.lex_state = 63},
  [2166] = {.lex_state = 63},
  [2167] = {.lex_state = 63},
  [2168] = {.lex_state = 14},
  [2169] = {.lex_state = 63},
  [2170] = {.lex_state = 63},
  [2171] = {.lex_state = 0, .external_lex_state = 4},
  [2172] = {.lex_state = 63},
  [2173] = {.lex_state = 63},
  [2174] = {.lex_state = 63, .external_lex_state = 4},
  [2175] = {.lex_state = 63},
  [2176] = {.lex_state = 0, .external_lex_state = 4},
  [2177] = {.lex_state = 0, .external_lex_state = 4},
  [2178] = {.lex_state = 63},
  [2179] = {.lex_state = 63},
  [2180] = {.lex_state = 63},
  [2181] = {.lex_state = 63},
  [2182] = {.lex_state = 63, .external_lex_state = 4},
  [2183] = {.lex_state = 14},
  [2184] = {.lex_state = 63},
  [2185] = {.lex_state = 0, .external_lex_state = 4},
  [2186] = {.lex_state = 63},
  [2187] = {.lex_state = 0, .external_lex_state = 4},
  [2188] = {.lex_state = 63},
  [2189] = {.lex_state = 63},
  [2190] = {.lex_state = 63, .external_lex_state = 4},
  [2191] = {.lex_state = 63},
  [2192] = {.lex_state = 0, .external_lex_state = 4},
  [2193] = {.lex_state = 63, .external_lex_state = 4},
  [2194] = {.lex_state = 63, .external_lex_state = 4},
  [2195] = {.lex_state = 63, .external_lex_state = 4},
  [2196] = {.lex_state = 63, .external_lex_state = 4},
  [2197] = {.lex_state = 63},
  [2198] = {.lex_state = 63, .external_lex_state = 4},
  [2199] = {.lex_state = 63, .external_lex_state = 4},
  [2200] = {.lex_state = 63, .external_lex_state = 4},
  [2201] = {.lex_state = 63},
  [2202] = {.lex_state = 63, .external_lex_state = 4},
  [2203] = {.lex_state = 63},
  [2204] = {.lex_state = 63},
  [2205] = {.lex_state = 63},
  [2206] = {.lex_state = 63, .external_lex_state = 4},
  [2207] = {.lex_state = 63, .external_lex_state = 4},
  [2208] = {.lex_state = 63},
  [2209] = {.lex_state = 63, .external_lex_state = 4},
  [2210] = {.lex_state = 63},
  [2211] = {.lex_state = 63},
  [2212] = {.lex_state = 63},
  [2213] = {.lex_state = 63},
  [2214] = {.lex_state = 63},
  [2215] = {.lex_state = 0, .external_lex_state = 4},
  [2216] = {.lex_state = 63},
  [2217] = {.lex_state = 63},
  [2218] = {.lex_state = 63},
  [2219] = {.lex_state = 0, .external_lex_state = 4},
  [2220] = {.lex_state = 0, .external_lex_state = 4},
  [2221] = {.lex_state = 63},
  [2222] = {.lex_state = 63},
  [2223] = {.lex_state = 63},
  [2224] = {.lex_state = 63},
  [2225] = {.lex_state = 63},
  [2226] = {.lex_state = 63},
  [2227] = {.lex_state = 63},
  [2228] = {.lex_state = 18, .external_lex_state = 5},
  [2229] = {.lex_state = 63},
  [2230] = {.lex_state = 0, .external_lex_state = 4},
  [2231] = {.lex_state = 0, .external_lex_state = 4},
  [2232] = {.lex_state = 63},
  [2233] = {.lex_state = 63},
  [2234] = {.lex_state = 63},
  [2235] = {.lex_state = 63},
  [2236] = {.lex_state = 63},
  [2237] = {.lex_state = 63},
  [2238] = {.lex_state = 63},
  [2239] = {.lex_state = 0, .external_lex_state = 4},
  [2240] = {.lex_state = 18, .external_lex_state = 5},
  [2241] = {.lex_state = 63},
  [2242] = {.lex_state = 63},
  [2243] = {.lex_state = 18, .external_lex_state = 5},
  [2244] = {.lex_state = 63},
  [2245] = {.lex_state = 0, .external_lex_state = 4},
  [2246] = {.lex_state = 63},
  [2247] = {.lex_state = 0, .external_lex_state = 4},
  [2248] = {.lex_state = 63},
  [2249] = {.lex_state = 0, .external_lex_state = 4},
  [2250] = {.lex_state = 0, .external_lex_state = 4},
  [2251] = {.lex_state = 0, .external_lex_state = 4},
  [2252] = {.lex_state = 63},
  [2253] = {.lex_state = 63},
  [2254] = {.lex_state = 63},
  [2255] = {.lex_state = 63},
  [2256] = {.lex_state = 18, .external_lex_state = 5},
  [2257] = {.lex_state = 63},
  [2258] = {.lex_state = 63},
  [2259] = {.lex_state = 63},
  [2260] = {.lex_state = 63},
  [2261] = {.lex_state = 63},
  [2262] = {.lex_state = 63},
  [2263] = {.lex_state = 63},
  [2264] = {.lex_state = 63},
  [2265] = {.lex_state = 63},
  [2266] = {.lex_state = 0, .external_lex_state = 4},
  [2267] = {.lex_state = 0, .external_lex_state = 4},
  [2268] = {.lex_state = 63, .external_lex_state = 4},
  [2269] = {.lex_state = 63},
  [2270] = {.lex_state = 18, .external_lex_state = 5},
  [2271] = {.lex_state = 63},
  [2272] = {.lex_state = 63},
  [2273] = {.lex_state = 63},
  [2274] = {.lex_state = 18, .external_lex_state = 5},
  [2275] = {.lex_state = 0, .external_lex_state = 4},
  [2276] = {.lex_state = 0, .external_lex_state = 4},
  [2277] = {.lex_state = 63},
  [2278] = {.lex_state = 0, .external_lex_state = 4},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 0, .external_lex_state = 4},
  [2281] = {.lex_state = 63},
  [2282] = {.lex_state = 63},
  [2283] = {.lex_state = 63},
  [2284] = {.lex_state = 14},
  [2285] = {.lex_state = 18, .external_lex_state = 5},
  [2286] = {.lex_state = 0, .external_lex_state = 4},
  [2287] = {.lex_state = 63},
  [2288] = {.lex_state = 0, .external_lex_state = 4},
  [2289] = {.lex_state = 63},
  [2290] = {.lex_state = 63},
  [2291] = {.lex_state = 0, .external_lex_state = 4},
  [2292] = {.lex_state = 63},
  [2293] = {.lex_state = 63},
  [2294] = {.lex_state = 63},
  [2295] = {.lex_state = 0, .external_lex_state = 4},
  [2296] = {.lex_state = 63, .external_lex_state = 4},
  [2297] = {.lex_state = 63},
  [2298] = {.lex_state = 0, .external_lex_state = 4},
  [2299] = {.lex_state = 63},
  [2300] = {.lex_state = 0, .external_lex_state = 4},
  [2301] = {.lex_state = 0, .external_lex_state = 4},
  [2302] = {.lex_state = 63},
  [2303] = {.lex_state = 63},
  [2304] = {.lex_state = 63},
  [2305] = {.lex_state = 63},
  [2306] = {.lex_state = 0},
  [2307] = {.lex_state = 63},
  [2308] = {.lex_state = 63},
  [2309] = {.lex_state = 63},
  [2310] = {.lex_state = 63},
  [2311] = {.lex_state = 63},
  [2312] = {.lex_state = 63},
  [2313] = {.lex_state = 63},
  [2314] = {.lex_state = 63},
  [2315] = {.lex_state = 0, .external_lex_state = 4},
  [2316] = {.lex_state = 63},
  [2317] = {.lex_state = 0, .external_lex_state = 4},
  [2318] = {.lex_state = 63},
  [2319] = {.lex_state = 63},
  [2320] = {.lex_state = 0, .external_lex_state = 4},
  [2321] = {.lex_state = 63},
  [2322] = {.lex_state = 0, .external_lex_state = 4},
  [2323] = {.lex_state = 0, .external_lex_state = 4},
  [2324] = {.lex_state = 63},
  [2325] = {.lex_state = 63},
  [2326] = {.lex_state = 63},
  [2327] = {.lex_state = 63},
  [2328] = {.lex_state = 63},
  [2329] = {.lex_state = 63},
  [2330] = {.lex_state = 0, .external_lex_state = 4},
  [2331] = {.lex_state = 63},
  [2332] = {.lex_state = 0, .external_lex_state = 4},
  [2333] = {.lex_state = 63},
  [2334] = {.lex_state = 63},
  [2335] = {.lex_state = 0, .external_lex_state = 4},
  [2336] = {.lex_state = 63},
  [2337] = {.lex_state = 0, .external_lex_state = 4},
  [2338] = {.lex_state = 0, .external_lex_state = 4},
  [2339] = {.lex_state = 0, .external_lex_state = 4},
  [2340] = {.lex_state = 0, .external_lex_state = 4},
  [2341] = {.lex_state = 63},
  [2342] = {.lex_state = 63},
  [2343] = {.lex_state = 63},
  [2344] = {.lex_state = 63},
  [2345] = {.lex_state = 0, .external_lex_state = 4},
  [2346] = {.lex_state = 7},
  [2347] = {.lex_state = 0, .external_lex_state = 4},
  [2348] = {.lex_state = 63},
  [2349] = {.lex_state = 0, .external_lex_state = 4},
  [2350] = {.lex_state = 63},
  [2351] = {.lex_state = 0, .external_lex_state = 4},
  [2352] = {.lex_state = 0, .external_lex_state = 4},
  [2353] = {.lex_state = 0, .external_lex_state = 4},
  [2354] = {.lex_state = 0, .external_lex_state = 4},
  [2355] = {.lex_state = 0, .external_lex_state = 4},
  [2356] = {.lex_state = 63},
  [2357] = {.lex_state = 63},
  [2358] = {.lex_state = 63},
  [2359] = {.lex_state = 0, .external_lex_state = 4},
  [2360] = {.lex_state = 63},
  [2361] = {.lex_state = 0, .external_lex_state = 4},
  [2362] = {.lex_state = 0, .external_lex_state = 4},
  [2363] = {.lex_state = 0, .external_lex_state = 4},
  [2364] = {.lex_state = 63},
  [2365] = {.lex_state = 63, .external_lex_state = 4},
  [2366] = {.lex_state = 63},
  [2367] = {.lex_state = 63},
  [2368] = {.lex_state = 7},
  [2369] = {.lex_state = 0, .external_lex_state = 4},
  [2370] = {.lex_state = 0, .external_lex_state = 4},
  [2371] = {.lex_state = 0, .external_lex_state = 4},
  [2372] = {.lex_state = 0, .external_lex_state = 4},
  [2373] = {.lex_state = 63},
  [2374] = {.lex_state = 63},
  [2375] = {.lex_state = 14},
  [2376] = {.lex_state = 0, .external_lex_state = 4},
  [2377] = {.lex_state = 0, .external_lex_state = 4},
  [2378] = {.lex_state = 63, .external_lex_state = 4},
  [2379] = {.lex_state = 63},
  [2380] = {.lex_state = 0, .external_lex_state = 4},
  [2381] = {.lex_state = 63},
  [2382] = {.lex_state = 0, .external_lex_state = 4},
  [2383] = {.lex_state = 63},
  [2384] = {.lex_state = 0, .external_lex_state = 4},
  [2385] = {.lex_state = 0, .external_lex_state = 4},
  [2386] = {.lex_state = 0, .external_lex_state = 4},
  [2387] = {.lex_state = 0, .external_lex_state = 4},
  [2388] = {.lex_state = 0, .external_lex_state = 4},
  [2389] = {.lex_state = 0, .external_lex_state = 4},
  [2390] = {.lex_state = 0, .external_lex_state = 4},
  [2391] = {.lex_state = 0, .external_lex_state = 4},
  [2392] = {.lex_state = 0, .external_lex_state = 4},
  [2393] = {.lex_state = 63},
  [2394] = {.lex_state = 63},
  [2395] = {.lex_state = 63, .external_lex_state = 4},
  [2396] = {.lex_state = 0, .external_lex_state = 4},
  [2397] = {.lex_state = 0, .external_lex_state = 4},
  [2398] = {.lex_state = 0, .external_lex_state = 4},
  [2399] = {.lex_state = 63, .external_lex_state = 4},
  [2400] = {.lex_state = 0, .external_lex_state = 4},
  [2401] = {.lex_state = 0, .external_lex_state = 4},
  [2402] = {.lex_state = 0, .external_lex_state = 4},
  [2403] = {.lex_state = 0, .external_lex_state = 4},
  [2404] = {.lex_state = 0, .external_lex_state = 4},
  [2405] = {.lex_state = 0, .external_lex_state = 4},
  [2406] = {.lex_state = 0, .external_lex_state = 4},
  [2407] = {.lex_state = 63},
  [2408] = {.lex_state = 63},
  [2409] = {.lex_state = 63},
  [2410] = {.lex_state = 63},
  [2411] = {.lex_state = 0, .external_lex_state = 4},
  [2412] = {.lex_state = 63},
  [2413] = {.lex_state = 63},
  [2414] = {.lex_state = 0, .external_lex_state = 4},
  [2415] = {.lex_state = 0, .external_lex_state = 4},
  [2416] = {.lex_state = 63},
  [2417] = {.lex_state = 63},
  [2418] = {.lex_state = 0, .external_lex_state = 4},
  [2419] = {.lex_state = 63},
  [2420] = {.lex_state = 63},
  [2421] = {.lex_state = 63},
  [2422] = {.lex_state = 0, .external_lex_state = 4},
  [2423] = {.lex_state = 63},
  [2424] = {.lex_state = 63},
  [2425] = {.lex_state = 0, .external_lex_state = 4},
  [2426] = {.lex_state = 0, .external_lex_state = 4},
  [2427] = {.lex_state = 0, .external_lex_state = 4},
  [2428] = {.lex_state = 63},
  [2429] = {.lex_state = 63},
  [2430] = {.lex_state = 0, .external_lex_state = 4},
  [2431] = {.lex_state = 0, .external_lex_state = 4},
  [2432] = {.lex_state = 0, .external_lex_state = 4},
  [2433] = {.lex_state = 63},
  [2434] = {.lex_state = 0, .external_lex_state = 4},
  [2435] = {.lex_state = 0, .external_lex_state = 4},
  [2436] = {.lex_state = 0, .external_lex_state = 4},
  [2437] = {.lex_state = 63},
  [2438] = {.lex_state = 63},
  [2439] = {.lex_state = 0, .external_lex_state = 4},
  [2440] = {.lex_state = 14},
  [2441] = {.lex_state = 0, .external_lex_state = 4},
  [2442] = {.lex_state = 0, .external_lex_state = 4},
  [2443] = {.lex_state = 0, .external_lex_state = 4},
  [2444] = {.lex_state = 63},
  [2445] = {.lex_state = 0, .external_lex_state = 4},
  [2446] = {.lex_state = 0, .external_lex_state = 4},
  [2447] = {.lex_state = 0, .external_lex_state = 4},
  [2448] = {.lex_state = 63},
  [2449] = {.lex_state = 0, .external_lex_state = 4},
  [2450] = {.lex_state = 63},
  [2451] = {.lex_state = 63},
  [2452] = {.lex_state = 63},
  [2453] = {.lex_state = 0, .external_lex_state = 4},
  [2454] = {.lex_state = 63},
  [2455] = {.lex_state = 0, .external_lex_state = 4},
  [2456] = {.lex_state = 63},
  [2457] = {.lex_state = 63},
  [2458] = {.lex_state = 63},
  [2459] = {.lex_state = 0, .external_lex_state = 4},
  [2460] = {.lex_state = 63},
  [2461] = {.lex_state = 63},
  [2462] = {.lex_state = 63},
  [2463] = {.lex_state = 0, .external_lex_state = 4},
  [2464] = {.lex_state = 0, .external_lex_state = 4},
  [2465] = {.lex_state = 63},
  [2466] = {.lex_state = 63, .external_lex_state = 4},
  [2467] = {.lex_state = 63},
  [2468] = {.lex_state = 63, .external_lex_state = 4},
  [2469] = {.lex_state = 0, .external_lex_state = 4},
  [2470] = {.lex_state = 0, .external_lex_state = 4},
  [2471] = {.lex_state = 63},
  [2472] = {.lex_state = 63},
  [2473] = {.lex_state = 63, .external_lex_state = 4},
  [2474] = {.lex_state = 63},
  [2475] = {.lex_state = 0, .external_lex_state = 4},
  [2476] = {.lex_state = 63, .external_lex_state = 4},
  [2477] = {.lex_state = 0, .external_lex_state = 4},
  [2478] = {.lex_state = 0, .external_lex_state = 4},
  [2479] = {.lex_state = 0, .external_lex_state = 4},
  [2480] = {.lex_state = 63, .external_lex_state = 4},
  [2481] = {.lex_state = 63},
  [2482] = {.lex_state = 63},
  [2483] = {.lex_state = 63},
  [2484] = {.lex_state = 0, .external_lex_state = 4},
  [2485] = {.lex_state = 63, .external_lex_state = 4},
  [2486] = {.lex_state = 0, .external_lex_state = 4},
  [2487] = {.lex_state = 63},
  [2488] = {.lex_state = 63, .external_lex_state = 4},
  [2489] = {.lex_state = 0, .external_lex_state = 4},
  [2490] = {.lex_state = 63},
  [2491] = {.lex_state = 0},
  [2492] = {.lex_state = 0, .external_lex_state = 4},
  [2493] = {.lex_state = 63, .external_lex_state = 4},
  [2494] = {.lex_state = 63},
  [2495] = {.lex_state = 0, .external_lex_state = 4},
  [2496] = {.lex_state = 0, .external_lex_state = 4},
  [2497] = {.lex_state = 0, .external_lex_state = 4},
  [2498] = {.lex_state = 63},
  [2499] = {.lex_state = 63},
  [2500] = {.lex_state = 63},
  [2501] = {.lex_state = 63},
  [2502] = {.lex_state = 63},
  [2503] = {.lex_state = 63},
  [2504] = {.lex_state = 63},
  [2505] = {.lex_state = 0, .external_lex_state = 4},
  [2506] = {.lex_state = 63},
  [2507] = {.lex_state = 0, .external_lex_state = 4},
  [2508] = {.lex_state = 63},
  [2509] = {.lex_state = 0, .external_lex_state = 4},
  [2510] = {.lex_state = 0, .external_lex_state = 4},
  [2511] = {.lex_state = 63},
  [2512] = {.lex_state = 63},
  [2513] = {.lex_state = 63},
  [2514] = {.lex_state = 1},
  [2515] = {.lex_state = 0, .external_lex_state = 4},
  [2516] = {.lex_state = 3},
  [2517] = {.lex_state = 0},
  [2518] = {.lex_state = 63},
  [2519] = {.lex_state = 63, .external_lex_state = 4},
  [2520] = {.lex_state = 63, .external_lex_state = 4},
  [2521] = {.lex_state = 63},
  [2522] = {.lex_state = 63, .external_lex_state = 4},
  [2523] = {.lex_state = 63, .external_lex_state = 4},
  [2524] = {.lex_state = 63, .external_lex_state = 4},
  [2525] = {.lex_state = 63, .external_lex_state = 4},
  [2526] = {.lex_state = 63},
  [2527] = {.lex_state = 63},
  [2528] = {.lex_state = 0},
  [2529] = {.lex_state = 63},
  [2530] = {.lex_state = 1},
  [2531] = {.lex_state = 3},
  [2532] = {.lex_state = 1},
  [2533] = {.lex_state = 63},
  [2534] = {.lex_state = 63, .external_lex_state = 4},
  [2535] = {.lex_state = 63, .external_lex_state = 4},
  [2536] = {.lex_state = 3},
  [2537] = {.lex_state = 63},
  [2538] = {.lex_state = 63, .external_lex_state = 4},
  [2539] = {.lex_state = 63},
  [2540] = {.lex_state = 0},
  [2541] = {.lex_state = 63},
  [2542] = {.lex_state = 0, .external_lex_state = 4},
  [2543] = {.lex_state = 63},
  [2544] = {.lex_state = 63, .external_lex_state = 4},
  [2545] = {.lex_state = 63},
  [2546] = {.lex_state = 63},
  [2547] = {.lex_state = 0},
  [2548] = {.lex_state = 63},
  [2549] = {.lex_state = 0, .external_lex_state = 4},
  [2550] = {.lex_state = 0},
  [2551] = {.lex_state = 3},
  [2552] = {.lex_state = 1},
  [2553] = {.lex_state = 0},
  [2554] = {.lex_state = 63},
  [2555] = {.lex_state = 0},
  [2556] = {.lex_state = 1},
  [2557] = {.lex_state = 3},
  [2558] = {.lex_state = 63, .external_lex_state = 4},
  [2559] = {.lex_state = 0, .external_lex_state = 4},
  [2560] = {.lex_state = 0, .external_lex_state = 4},
  [2561] = {.lex_state = 3},
  [2562] = {.lex_state = 1},
  [2563] = {.lex_state = 0, .external_lex_state = 4},
  [2564] = {.lex_state = 63},
  [2565] = {.lex_state = 0},
  [2566] = {.lex_state = 0, .external_lex_state = 4},
  [2567] = {.lex_state = 0},
  [2568] = {.lex_state = 1},
  [2569] = {.lex_state = 3},
  [2570] = {.lex_state = 63},
  [2571] = {.lex_state = 0},
  [2572] = {.lex_state = 0},
  [2573] = {.lex_state = 18, .external_lex_state = 5},
  [2574] = {.lex_state = 63},
  [2575] = {.lex_state = 63},
  [2576] = {.lex_state = 63},
  [2577] = {.lex_state = 63},
  [2578] = {.lex_state = 63},
  [2579] = {.lex_state = 63},
  [2580] = {.lex_state = 63},
  [2581] = {.lex_state = 63, .external_lex_state = 4},
  [2582] = {.lex_state = 1},
  [2583] = {.lex_state = 63},
  [2584] = {.lex_state = 1},
  [2585] = {.lex_state = 3},
  [2586] = {.lex_state = 63},
  [2587] = {.lex_state = 0},
  [2588] = {.lex_state = 1},
  [2589] = {.lex_state = 63},
  [2590] = {.lex_state = 63},
  [2591] = {.lex_state = 3},
  [2592] = {.lex_state = 63},
  [2593] = {.lex_state = 3},
  [2594] = {.lex_state = 1},
  [2595] = {.lex_state = 3},
  [2596] = {.lex_state = 63},
  [2597] = {.lex_state = 1},
  [2598] = {.lex_state = 1},
  [2599] = {.lex_state = 63},
  [2600] = {.lex_state = 3},
  [2601] = {.lex_state = 63},
  [2602] = {.lex_state = 63, .external_lex_state = 4},
  [2603] = {.lex_state = 0, .external_lex_state = 4},
  [2604] = {.lex_state = 63, .external_lex_state = 4},
  [2605] = {.lex_state = 0},
  [2606] = {.lex_state = 63},
  [2607] = {.lex_state = 3},
  [2608] = {.lex_state = 63},
  [2609] = {.lex_state = 0, .external_lex_state = 4},
  [2610] = {.lex_state = 63},
  [2611] = {.lex_state = 0, .external_lex_state = 4},
  [2612] = {.lex_state = 0},
  [2613] = {.lex_state = 0},
  [2614] = {.lex_state = 63},
  [2615] = {.lex_state = 0},
  [2616] = {.lex_state = 0, .external_lex_state = 4},
  [2617] = {.lex_state = 0},
  [2618] = {.lex_state = 0},
  [2619] = {.lex_state = 0},
  [2620] = {.lex_state = 0},
  [2621] = {.lex_state = 63},
  [2622] = {.lex_state = 63},
  [2623] = {.lex_state = 63},
  [2624] = {.lex_state = 0},
  [2625] = {.lex_state = 0},
  [2626] = {.lex_state = 0},
  [2627] = {.lex_state = 63},
  [2628] = {.lex_state = 63},
  [2629] = {.lex_state = 0},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 0},
  [2632] = {.lex_state = 0},
  [2633] = {.lex_state = 63},
  [2634] = {.lex_state = 0},
  [2635] = {.lex_state = 0},
  [2636] = {.lex_state = 63},
  [2637] = {.lex_state = 0},
  [2638] = {.lex_state = 63},
  [2639] = {.lex_state = 63},
  [2640] = {.lex_state = 63},
  [2641] = {.lex_state = 7},
  [2642] = {.lex_state = 0, .external_lex_state = 4},
  [2643] = {.lex_state = 63},
  [2644] = {.lex_state = 0, .external_lex_state = 4},
  [2645] = {.lex_state = 63},
  [2646] = {.lex_state = 63},
  [2647] = {.lex_state = 0},
  [2648] = {.lex_state = 0},
  [2649] = {.lex_state = 0, .external_lex_state = 4},
  [2650] = {.lex_state = 63},
  [2651] = {.lex_state = 0},
  [2652] = {.lex_state = 63},
  [2653] = {.lex_state = 0, .external_lex_state = 4},
  [2654] = {.lex_state = 0},
  [2655] = {.lex_state = 0},
  [2656] = {.lex_state = 0},
  [2657] = {.lex_state = 0, .external_lex_state = 4},
  [2658] = {.lex_state = 63},
  [2659] = {.lex_state = 0, .external_lex_state = 4},
  [2660] = {.lex_state = 0, .external_lex_state = 4},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 0},
  [2663] = {.lex_state = 0, .external_lex_state = 4},
  [2664] = {.lex_state = 0},
  [2665] = {.lex_state = 0},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 0},
  [2668] = {.lex_state = 63},
  [2669] = {.lex_state = 0},
  [2670] = {.lex_state = 0},
  [2671] = {.lex_state = 0},
  [2672] = {.lex_state = 0},
  [2673] = {.lex_state = 0, .external_lex_state = 4},
  [2674] = {.lex_state = 63},
  [2675] = {.lex_state = 0, .external_lex_state = 4},
  [2676] = {.lex_state = 0},
  [2677] = {.lex_state = 0},
  [2678] = {.lex_state = 0},
  [2679] = {.lex_state = 63},
  [2680] = {.lex_state = 63},
  [2681] = {.lex_state = 0},
  [2682] = {.lex_state = 63},
  [2683] = {.lex_state = 7},
  [2684] = {.lex_state = 0},
  [2685] = {.lex_state = 0},
  [2686] = {.lex_state = 0},
  [2687] = {.lex_state = 63},
  [2688] = {.lex_state = 63, .external_lex_state = 4},
  [2689] = {.lex_state = 63},
  [2690] = {.lex_state = 63},
  [2691] = {.lex_state = 63, .external_lex_state = 4},
  [2692] = {.lex_state = 0, .external_lex_state = 4},
  [2693] = {.lex_state = 0},
  [2694] = {.lex_state = 0},
  [2695] = {.lex_state = 63},
  [2696] = {.lex_state = 63},
  [2697] = {.lex_state = 0},
  [2698] = {.lex_state = 0, .external_lex_state = 4},
  [2699] = {.lex_state = 63},
  [2700] = {.lex_state = 0},
  [2701] = {.lex_state = 63},
  [2702] = {.lex_state = 0},
  [2703] = {.lex_state = 0, .external_lex_state = 4},
  [2704] = {.lex_state = 0},
  [2705] = {.lex_state = 0, .external_lex_state = 4},
  [2706] = {.lex_state = 63},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 0},
  [2709] = {.lex_state = 0},
  [2710] = {.lex_state = 0},
  [2711] = {.lex_state = 7},
  [2712] = {.lex_state = 0},
  [2713] = {.lex_state = 0},
  [2714] = {.lex_state = 0},
  [2715] = {.lex_state = 63},
  [2716] = {.lex_state = 0},
  [2717] = {.lex_state = 0},
  [2718] = {.lex_state = 0},
  [2719] = {.lex_state = 0},
  [2720] = {.lex_state = 0, .external_lex_state = 4},
  [2721] = {.lex_state = 0},
  [2722] = {.lex_state = 0, .external_lex_state = 4},
  [2723] = {.lex_state = 63},
  [2724] = {.lex_state = 0, .external_lex_state = 4},
  [2725] = {.lex_state = 0, .external_lex_state = 4},
  [2726] = {.lex_state = 0, .external_lex_state = 4},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 0},
  [2729] = {.lex_state = 63},
  [2730] = {.lex_state = 63},
  [2731] = {.lex_state = 0},
  [2732] = {.lex_state = 0},
  [2733] = {.lex_state = 0},
  [2734] = {.lex_state = 63},
  [2735] = {.lex_state = 0, .external_lex_state = 4},
  [2736] = {.lex_state = 63},
  [2737] = {.lex_state = 63},
  [2738] = {.lex_state = 0},
  [2739] = {.lex_state = 0, .external_lex_state = 4},
  [2740] = {.lex_state = 63, .external_lex_state = 4},
  [2741] = {.lex_state = 0, .external_lex_state = 4},
  [2742] = {.lex_state = 63},
  [2743] = {.lex_state = 0, .external_lex_state = 4},
  [2744] = {.lex_state = 0},
  [2745] = {.lex_state = 0, .external_lex_state = 4},
  [2746] = {.lex_state = 0, .external_lex_state = 4},
  [2747] = {.lex_state = 0},
  [2748] = {.lex_state = 63, .external_lex_state = 4},
  [2749] = {.lex_state = 0, .external_lex_state = 4},
  [2750] = {.lex_state = 0},
  [2751] = {.lex_state = 0},
  [2752] = {.lex_state = 0},
  [2753] = {.lex_state = 0},
  [2754] = {.lex_state = 63},
  [2755] = {.lex_state = 0},
  [2756] = {.lex_state = 0},
  [2757] = {.lex_state = 0},
  [2758] = {.lex_state = 63},
  [2759] = {.lex_state = 63},
  [2760] = {.lex_state = 0},
  [2761] = {.lex_state = 0},
  [2762] = {.lex_state = 0, .external_lex_state = 4},
  [2763] = {.lex_state = 0},
  [2764] = {.lex_state = 0},
  [2765] = {.lex_state = 63},
  [2766] = {.lex_state = 0},
  [2767] = {.lex_state = 0, .external_lex_state = 4},
  [2768] = {.lex_state = 0},
  [2769] = {.lex_state = 0},
  [2770] = {.lex_state = 0},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 63, .external_lex_state = 4},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 63},
  [2775] = {.lex_state = 0},
  [2776] = {.lex_state = 0},
  [2777] = {.lex_state = 63, .external_lex_state = 4},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 63},
  [2780] = {.lex_state = 0},
  [2781] = {.lex_state = 0},
  [2782] = {.lex_state = 0, .external_lex_state = 4},
  [2783] = {.lex_state = 0, .external_lex_state = 4},
  [2784] = {.lex_state = 63, .external_lex_state = 4},
  [2785] = {.lex_state = 0},
  [2786] = {.lex_state = 0},
  [2787] = {.lex_state = 0},
  [2788] = {.lex_state = 0},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 0},
  [2791] = {.lex_state = 63},
  [2792] = {.lex_state = 63},
  [2793] = {.lex_state = 63},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 0, .external_lex_state = 4},
  [2796] = {.lex_state = 63},
  [2797] = {.lex_state = 63},
  [2798] = {.lex_state = 63},
  [2799] = {.lex_state = 63},
  [2800] = {.lex_state = 63},
  [2801] = {.lex_state = 0, .external_lex_state = 4},
  [2802] = {.lex_state = 0},
  [2803] = {.lex_state = 63},
  [2804] = {.lex_state = 0},
  [2805] = {.lex_state = 0},
  [2806] = {.lex_state = 63},
  [2807] = {.lex_state = 0},
  [2808] = {.lex_state = 0},
  [2809] = {.lex_state = 63},
  [2810] = {.lex_state = 0},
  [2811] = {.lex_state = 63},
  [2812] = {.lex_state = 63},
  [2813] = {.lex_state = 63},
  [2814] = {.lex_state = 0},
  [2815] = {.lex_state = 0, .external_lex_state = 4},
  [2816] = {.lex_state = 0, .external_lex_state = 4},
  [2817] = {.lex_state = 63},
  [2818] = {.lex_state = 0},
  [2819] = {.lex_state = 63},
  [2820] = {.lex_state = 0, .external_lex_state = 4},
  [2821] = {.lex_state = 0, .external_lex_state = 4},
  [2822] = {.lex_state = 0},
  [2823] = {.lex_state = 63},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 63},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 0},
  [2828] = {.lex_state = 0},
  [2829] = {.lex_state = 0, .external_lex_state = 4},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 63},
  [2832] = {.lex_state = 0},
  [2833] = {.lex_state = 0, .external_lex_state = 4},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 63},
  [2840] = {.lex_state = 0, .external_lex_state = 4},
  [2841] = {.lex_state = 0, .external_lex_state = 4},
  [2842] = {.lex_state = 63},
  [2843] = {.lex_state = 63},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 0},
  [2846] = {.lex_state = 63},
  [2847] = {.lex_state = 63},
  [2848] = {.lex_state = 63},
  [2849] = {.lex_state = 63},
  [2850] = {.lex_state = 0},
  [2851] = {.lex_state = 63},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 63},
  [2854] = {.lex_state = 0},
  [2855] = {.lex_state = 0},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 0},
  [2858] = {.lex_state = 63},
  [2859] = {.lex_state = 63},
  [2860] = {.lex_state = 63},
  [2861] = {.lex_state = 63},
  [2862] = {.lex_state = 0, .external_lex_state = 4},
  [2863] = {.lex_state = 63},
  [2864] = {.lex_state = 0},
  [2865] = {.lex_state = 0, .external_lex_state = 4},
  [2866] = {.lex_state = 63},
  [2867] = {.lex_state = 63},
  [2868] = {.lex_state = 63},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 63},
  [2871] = {.lex_state = 63},
  [2872] = {.lex_state = 0, .external_lex_state = 4},
  [2873] = {.lex_state = 0, .external_lex_state = 4},
  [2874] = {.lex_state = 0, .external_lex_state = 4},
  [2875] = {.lex_state = 63},
  [2876] = {.lex_state = 0, .external_lex_state = 4},
  [2877] = {.lex_state = 0},
  [2878] = {.lex_state = 63},
  [2879] = {.lex_state = 63},
  [2880] = {.lex_state = 63},
  [2881] = {.lex_state = 63},
  [2882] = {.lex_state = 63},
  [2883] = {.lex_state = 63},
  [2884] = {.lex_state = 63},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 63},
  [2887] = {.lex_state = 63},
  [2888] = {.lex_state = 0},
  [2889] = {.lex_state = 0},
  [2890] = {.lex_state = 63},
  [2891] = {.lex_state = 63},
  [2892] = {.lex_state = 63},
  [2893] = {.lex_state = 63},
  [2894] = {.lex_state = 0, .external_lex_state = 4},
  [2895] = {.lex_state = 63},
  [2896] = {.lex_state = 63},
  [2897] = {.lex_state = 63},
  [2898] = {.lex_state = 63},
  [2899] = {.lex_state = 63},
  [2900] = {.lex_state = 0},
  [2901] = {.lex_state = 63},
  [2902] = {.lex_state = 63},
  [2903] = {.lex_state = 0},
  [2904] = {.lex_state = 63},
  [2905] = {.lex_state = 63},
  [2906] = {.lex_state = 0},
  [2907] = {.lex_state = 63},
  [2908] = {.lex_state = 63},
  [2909] = {.lex_state = 63},
  [2910] = {.lex_state = 63},
  [2911] = {.lex_state = 63},
  [2912] = {.lex_state = 63},
  [2913] = {.lex_state = 63},
  [2914] = {.lex_state = 0},
  [2915] = {.lex_state = 63},
  [2916] = {.lex_state = 63},
  [2917] = {.lex_state = 0, .external_lex_state = 4},
  [2918] = {.lex_state = 63},
  [2919] = {.lex_state = 0},
  [2920] = {.lex_state = 63},
  [2921] = {.lex_state = 63},
  [2922] = {.lex_state = 63},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 63},
  [2925] = {.lex_state = 63},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 0},
  [2928] = {.lex_state = 63},
  [2929] = {.lex_state = 63},
  [2930] = {.lex_state = 63},
  [2931] = {.lex_state = 0},
  [2932] = {.lex_state = 63},
  [2933] = {.lex_state = 0},
  [2934] = {.lex_state = 63},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 63},
  [2937] = {.lex_state = 63},
  [2938] = {.lex_state = 63},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 63},
  [2941] = {.lex_state = 63},
  [2942] = {.lex_state = 63},
  [2943] = {.lex_state = 63},
  [2944] = {.lex_state = 63},
  [2945] = {.lex_state = 63},
  [2946] = {.lex_state = 63},
  [2947] = {.lex_state = 63},
  [2948] = {.lex_state = 63},
  [2949] = {.lex_state = 63},
  [2950] = {.lex_state = 0},
  [2951] = {.lex_state = 63},
  [2952] = {.lex_state = 63},
  [2953] = {.lex_state = 0},
  [2954] = {.lex_state = 63},
  [2955] = {.lex_state = 63},
  [2956] = {.lex_state = 63},
  [2957] = {.lex_state = 63},
  [2958] = {.lex_state = 63},
  [2959] = {.lex_state = 63},
  [2960] = {.lex_state = 63},
  [2961] = {.lex_state = 63},
  [2962] = {.lex_state = 0},
  [2963] = {.lex_state = 0},
  [2964] = {.lex_state = 63},
  [2965] = {.lex_state = 63},
  [2966] = {.lex_state = 63},
  [2967] = {.lex_state = 63},
  [2968] = {.lex_state = 0},
  [2969] = {.lex_state = 63},
  [2970] = {.lex_state = 63},
  [2971] = {.lex_state = 0, .external_lex_state = 4},
  [2972] = {.lex_state = 63},
  [2973] = {.lex_state = 63},
  [2974] = {.lex_state = 63},
  [2975] = {.lex_state = 63},
  [2976] = {.lex_state = 0},
  [2977] = {.lex_state = 63},
  [2978] = {.lex_state = 63},
  [2979] = {.lex_state = 0},
  [2980] = {.lex_state = 63},
  [2981] = {.lex_state = 0},
  [2982] = {.lex_state = 0},
  [2983] = {.lex_state = 0},
  [2984] = {.lex_state = 63},
  [2985] = {.lex_state = 63},
  [2986] = {.lex_state = 63},
  [2987] = {.lex_state = 63},
  [2988] = {.lex_state = 63},
  [2989] = {.lex_state = 63},
  [2990] = {.lex_state = 63},
  [2991] = {.lex_state = 63},
  [2992] = {.lex_state = 0},
  [2993] = {.lex_state = 63},
  [2994] = {.lex_state = 63},
  [2995] = {.lex_state = 0},
  [2996] = {.lex_state = 0},
  [2997] = {.lex_state = 0},
  [2998] = {.lex_state = 0},
  [2999] = {.lex_state = 63},
  [3000] = {.lex_state = 0},
  [3001] = {.lex_state = 63},
  [3002] = {.lex_state = 63},
  [3003] = {.lex_state = 63},
  [3004] = {.lex_state = 0},
  [3005] = {.lex_state = 63},
  [3006] = {.lex_state = 0},
  [3007] = {.lex_state = 0},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 0},
  [3012] = {.lex_state = 0},
  [3013] = {.lex_state = 0},
  [3014] = {.lex_state = 0},
  [3015] = {.lex_state = 0},
  [3016] = {.lex_state = 0},
  [3017] = {.lex_state = 15},
  [3018] = {.lex_state = 0},
  [3019] = {.lex_state = 0},
  [3020] = {.lex_state = 63},
  [3021] = {.lex_state = 0},
  [3022] = {.lex_state = 0},
  [3023] = {.lex_state = 0},
  [3024] = {.lex_state = 0},
  [3025] = {.lex_state = 0},
  [3026] = {.lex_state = 0},
  [3027] = {.lex_state = 63},
  [3028] = {.lex_state = 0},
  [3029] = {.lex_state = 63},
  [3030] = {.lex_state = 0},
  [3031] = {.lex_state = 0},
  [3032] = {.lex_state = 0},
  [3033] = {.lex_state = 0},
  [3034] = {.lex_state = 0},
  [3035] = {.lex_state = 0},
  [3036] = {.lex_state = 63},
  [3037] = {.lex_state = 0},
  [3038] = {.lex_state = 0},
  [3039] = {.lex_state = 0},
  [3040] = {.lex_state = 63},
  [3041] = {.lex_state = 0},
  [3042] = {.lex_state = 63},
  [3043] = {.lex_state = 0},
  [3044] = {.lex_state = 0},
  [3045] = {.lex_state = 0},
  [3046] = {.lex_state = 5},
  [3047] = {.lex_state = 0},
  [3048] = {.lex_state = 0},
  [3049] = {.lex_state = 0},
  [3050] = {.lex_state = 0},
  [3051] = {.lex_state = 63},
  [3052] = {.lex_state = 63},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 63},
  [3055] = {.lex_state = 63},
  [3056] = {.lex_state = 0},
  [3057] = {.lex_state = 0},
  [3058] = {.lex_state = 63},
  [3059] = {.lex_state = 63},
  [3060] = {.lex_state = 63},
  [3061] = {.lex_state = 0},
  [3062] = {.lex_state = 0},
  [3063] = {.lex_state = 63},
  [3064] = {.lex_state = 0},
  [3065] = {.lex_state = 0},
  [3066] = {.lex_state = 15},
  [3067] = {.lex_state = 63},
  [3068] = {.lex_state = 63},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 0},
  [3071] = {.lex_state = 0},
  [3072] = {.lex_state = 0},
  [3073] = {.lex_state = 63},
  [3074] = {.lex_state = 0},
  [3075] = {.lex_state = 63},
  [3076] = {.lex_state = 0},
  [3077] = {.lex_state = 63},
  [3078] = {.lex_state = 63},
  [3079] = {.lex_state = 63},
  [3080] = {.lex_state = 63},
  [3081] = {.lex_state = 0},
  [3082] = {.lex_state = 63},
  [3083] = {.lex_state = 0},
  [3084] = {.lex_state = 63},
  [3085] = {.lex_state = 0},
  [3086] = {.lex_state = 0},
  [3087] = {.lex_state = 0},
  [3088] = {.lex_state = 0},
  [3089] = {.lex_state = 0},
  [3090] = {.lex_state = 63},
  [3091] = {.lex_state = 0},
  [3092] = {.lex_state = 0},
  [3093] = {.lex_state = 0},
  [3094] = {.lex_state = 63},
  [3095] = {.lex_state = 63},
  [3096] = {.lex_state = 0},
  [3097] = {.lex_state = 0},
  [3098] = {.lex_state = 15},
  [3099] = {.lex_state = 0},
  [3100] = {.lex_state = 63},
  [3101] = {.lex_state = 0},
  [3102] = {.lex_state = 0},
  [3103] = {.lex_state = 0},
  [3104] = {.lex_state = 0},
  [3105] = {.lex_state = 0},
  [3106] = {.lex_state = 0},
  [3107] = {.lex_state = 0},
  [3108] = {.lex_state = 0},
  [3109] = {.lex_state = 0},
  [3110] = {.lex_state = 63},
  [3111] = {.lex_state = 63},
  [3112] = {.lex_state = 63},
  [3113] = {.lex_state = 0},
  [3114] = {.lex_state = 63},
  [3115] = {.lex_state = 0},
  [3116] = {.lex_state = 63},
  [3117] = {.lex_state = 63},
  [3118] = {.lex_state = 63},
  [3119] = {.lex_state = 0},
  [3120] = {.lex_state = 63},
  [3121] = {.lex_state = 0},
  [3122] = {.lex_state = 0},
  [3123] = {.lex_state = 63},
  [3124] = {.lex_state = 63},
  [3125] = {.lex_state = 0},
  [3126] = {.lex_state = 63},
  [3127] = {.lex_state = 63},
  [3128] = {.lex_state = 63},
  [3129] = {.lex_state = 5},
  [3130] = {.lex_state = 0},
  [3131] = {.lex_state = 63},
  [3132] = {.lex_state = 0},
  [3133] = {.lex_state = 0},
  [3134] = {.lex_state = 63},
  [3135] = {.lex_state = 0},
  [3136] = {.lex_state = 63},
  [3137] = {.lex_state = 63},
  [3138] = {.lex_state = 63},
  [3139] = {.lex_state = 63},
  [3140] = {.lex_state = 63},
  [3141] = {.lex_state = 0},
  [3142] = {.lex_state = 0},
  [3143] = {.lex_state = 0},
  [3144] = {.lex_state = 0},
  [3145] = {.lex_state = 63},
  [3146] = {.lex_state = 63},
  [3147] = {.lex_state = 63},
  [3148] = {.lex_state = 63},
  [3149] = {.lex_state = 0},
  [3150] = {.lex_state = 63},
  [3151] = {.lex_state = 0},
  [3152] = {.lex_state = 0},
  [3153] = {.lex_state = 0},
  [3154] = {.lex_state = 63},
  [3155] = {.lex_state = 15},
  [3156] = {.lex_state = 0},
  [3157] = {.lex_state = 0},
  [3158] = {.lex_state = 63},
  [3159] = {.lex_state = 63},
  [3160] = {.lex_state = 5},
  [3161] = {.lex_state = 63},
  [3162] = {.lex_state = 63},
  [3163] = {.lex_state = 63},
  [3164] = {.lex_state = 0},
  [3165] = {.lex_state = 63},
  [3166] = {.lex_state = 63},
  [3167] = {.lex_state = 63},
  [3168] = {.lex_state = 63},
  [3169] = {.lex_state = 63},
  [3170] = {.lex_state = 0},
  [3171] = {.lex_state = 63},
  [3172] = {.lex_state = 63},
  [3173] = {.lex_state = 0},
  [3174] = {.lex_state = 63},
  [3175] = {.lex_state = 63},
  [3176] = {.lex_state = 63},
  [3177] = {.lex_state = 63},
  [3178] = {.lex_state = 63},
  [3179] = {.lex_state = 0},
  [3180] = {.lex_state = 0},
  [3181] = {.lex_state = 63},
  [3182] = {.lex_state = 63},
  [3183] = {.lex_state = 63},
  [3184] = {.lex_state = 0},
  [3185] = {.lex_state = 0},
  [3186] = {.lex_state = 0},
  [3187] = {.lex_state = 63},
  [3188] = {.lex_state = 63},
  [3189] = {.lex_state = 63},
  [3190] = {.lex_state = 0},
  [3191] = {.lex_state = 0},
  [3192] = {.lex_state = 0},
  [3193] = {.lex_state = 0},
  [3194] = {.lex_state = 5},
  [3195] = {.lex_state = 0},
  [3196] = {.lex_state = 63},
  [3197] = {.lex_state = 63},
  [3198] = {.lex_state = 63},
  [3199] = {.lex_state = 63},
  [3200] = {.lex_state = 63},
  [3201] = {.lex_state = 63},
  [3202] = {.lex_state = 63},
  [3203] = {.lex_state = 63},
  [3204] = {.lex_state = 0},
  [3205] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token_PIPE_PIPE = 2,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token_PIPE_PIPE] = anon_sym_PIPE_PIPE,
};

static bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [3] = {
    [ts_external_token_PIPE_PIPE] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [sym_readonly] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(3180),
    [sym_export_statement] = STATE(19),
    [sym__declaration] = STATE(19),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(19),
    [sym_lexical_declaration] = STATE(19),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(19),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(19),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(19),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(19),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(19),
    [sym_abstract_class_declaration] = STATE(19),
    [sym_module] = STATE(19),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(19),
    [sym_interface_declaration] = STATE(19),
    [sym_enum_declaration] = STATE(19),
    [sym_type_alias_declaration] = STATE(19),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [2] = {
    [sym_export_statement] = STATE(22),
    [sym__declaration] = STATE(22),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(22),
    [sym_lexical_declaration] = STATE(22),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1532),
    [sym_assignment_pattern] = STATE(2654),
    [sym_array] = STATE(1524),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(22),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(22),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(22),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_spread_element] = STATE(2654),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1546),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_method_definition] = STATE(2654),
    [sym_pair] = STATE(2654),
    [sym__property_name] = STATE(2159),
    [sym_computed_property_name] = STATE(2159),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(22),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(22),
    [sym_abstract_class_declaration] = STATE(22),
    [sym_module] = STATE(22),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(22),
    [sym_interface_declaration] = STATE(22),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias_declaration] = STATE(22),
    [sym_accessibility_modifier] = STATE(1985),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [aux_sym_object_repeat1] = STATE(2753),
    [sym_identifier] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_namespace] = ACTIONS(115),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_type] = ACTIONS(121),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(125),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(129),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(131),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(133),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [anon_sym_declare] = ACTIONS(137),
    [anon_sym_public] = ACTIONS(139),
    [anon_sym_private] = ACTIONS(139),
    [anon_sym_protected] = ACTIONS(139),
    [anon_sym_module] = ACTIONS(141),
    [anon_sym_any] = ACTIONS(143),
    [anon_sym_number] = ACTIONS(143),
    [anon_sym_boolean] = ACTIONS(143),
    [anon_sym_string] = ACTIONS(143),
    [anon_sym_symbol] = ACTIONS(143),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(145),
  },
  [3] = {
    [sym_export_statement] = STATE(13),
    [sym__declaration] = STATE(13),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_variable_declaration] = STATE(13),
    [sym_lexical_declaration] = STATE(13),
    [sym_statement_block] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_for_in_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_with_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_debugger_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_empty_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1532),
    [sym_assignment_pattern] = STATE(2654),
    [sym_array] = STATE(1524),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(13),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(13),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(13),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_spread_element] = STATE(2654),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1546),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_method_definition] = STATE(2654),
    [sym_pair] = STATE(2654),
    [sym__property_name] = STATE(2159),
    [sym_computed_property_name] = STATE(2159),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(13),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(13),
    [sym_abstract_class_declaration] = STATE(13),
    [sym_module] = STATE(13),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(13),
    [sym_interface_declaration] = STATE(13),
    [sym_enum_declaration] = STATE(13),
    [sym_type_alias_declaration] = STATE(13),
    [sym_accessibility_modifier] = STATE(1985),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [aux_sym_object_repeat1] = STATE(2753),
    [sym_identifier] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_namespace] = ACTIONS(115),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(147),
    [anon_sym_type] = ACTIONS(121),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(125),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(129),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(131),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(133),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [anon_sym_declare] = ACTIONS(137),
    [anon_sym_public] = ACTIONS(139),
    [anon_sym_private] = ACTIONS(139),
    [anon_sym_protected] = ACTIONS(139),
    [anon_sym_module] = ACTIONS(141),
    [anon_sym_any] = ACTIONS(143),
    [anon_sym_number] = ACTIONS(143),
    [anon_sym_boolean] = ACTIONS(143),
    [anon_sym_string] = ACTIONS(143),
    [anon_sym_symbol] = ACTIONS(143),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(145),
  },
  [4] = {
    [sym_export_statement] = STATE(13),
    [sym__declaration] = STATE(13),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_variable_declaration] = STATE(13),
    [sym_lexical_declaration] = STATE(13),
    [sym_statement_block] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_for_in_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_with_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_debugger_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_empty_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1532),
    [sym_assignment_pattern] = STATE(2654),
    [sym_array] = STATE(1524),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(13),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(13),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(13),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_spread_element] = STATE(2654),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1546),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_method_definition] = STATE(2654),
    [sym_pair] = STATE(2654),
    [sym__property_name] = STATE(2159),
    [sym_computed_property_name] = STATE(2159),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(13),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(13),
    [sym_abstract_class_declaration] = STATE(13),
    [sym_module] = STATE(13),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(13),
    [sym_interface_declaration] = STATE(13),
    [sym_enum_declaration] = STATE(13),
    [sym_type_alias_declaration] = STATE(13),
    [sym_accessibility_modifier] = STATE(1985),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [aux_sym_object_repeat1] = STATE(2753),
    [sym_identifier] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_namespace] = ACTIONS(115),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(149),
    [anon_sym_type] = ACTIONS(121),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(125),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(129),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(131),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(133),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [anon_sym_declare] = ACTIONS(137),
    [anon_sym_public] = ACTIONS(139),
    [anon_sym_private] = ACTIONS(139),
    [anon_sym_protected] = ACTIONS(139),
    [anon_sym_module] = ACTIONS(141),
    [anon_sym_any] = ACTIONS(143),
    [anon_sym_number] = ACTIONS(143),
    [anon_sym_boolean] = ACTIONS(143),
    [anon_sym_string] = ACTIONS(143),
    [anon_sym_symbol] = ACTIONS(143),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(145),
  },
  [5] = {
    [sym_export_statement] = STATE(23),
    [sym__declaration] = STATE(23),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(23),
    [sym_lexical_declaration] = STATE(23),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1532),
    [sym_assignment_pattern] = STATE(2612),
    [sym_array] = STATE(1524),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(23),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(23),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(23),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_spread_element] = STATE(2612),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1546),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_method_definition] = STATE(2612),
    [sym_pair] = STATE(2612),
    [sym__property_name] = STATE(2159),
    [sym_computed_property_name] = STATE(2159),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(23),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(23),
    [sym_abstract_class_declaration] = STATE(23),
    [sym_module] = STATE(23),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(23),
    [sym_interface_declaration] = STATE(23),
    [sym_enum_declaration] = STATE(23),
    [sym_type_alias_declaration] = STATE(23),
    [sym_accessibility_modifier] = STATE(1985),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [aux_sym_object_repeat1] = STATE(2613),
    [sym_identifier] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(153),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_namespace] = ACTIONS(155),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(157),
    [anon_sym_type] = ACTIONS(159),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(161),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(163),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(131),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(165),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(167),
    [anon_sym_set] = ACTIONS(167),
    [anon_sym_declare] = ACTIONS(169),
    [anon_sym_public] = ACTIONS(171),
    [anon_sym_private] = ACTIONS(171),
    [anon_sym_protected] = ACTIONS(171),
    [anon_sym_module] = ACTIONS(173),
    [anon_sym_any] = ACTIONS(175),
    [anon_sym_number] = ACTIONS(175),
    [anon_sym_boolean] = ACTIONS(175),
    [anon_sym_string] = ACTIONS(175),
    [anon_sym_symbol] = ACTIONS(175),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(177),
  },
  [6] = {
    [sym_export_statement] = STATE(15),
    [sym__declaration] = STATE(15),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(15),
    [sym_lexical_declaration] = STATE(15),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1532),
    [sym_assignment_pattern] = STATE(2678),
    [sym_array] = STATE(1524),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(15),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(15),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(15),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_spread_element] = STATE(2678),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1546),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_method_definition] = STATE(2678),
    [sym_pair] = STATE(2678),
    [sym__property_name] = STATE(2159),
    [sym_computed_property_name] = STATE(2159),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(15),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(15),
    [sym_abstract_class_declaration] = STATE(15),
    [sym_module] = STATE(15),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(15),
    [sym_interface_declaration] = STATE(15),
    [sym_enum_declaration] = STATE(15),
    [sym_type_alias_declaration] = STATE(15),
    [sym_accessibility_modifier] = STATE(1985),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [aux_sym_object_repeat1] = STATE(2676),
    [sym_identifier] = ACTIONS(179),
    [anon_sym_export] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_namespace] = ACTIONS(183),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(185),
    [anon_sym_type] = ACTIONS(187),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(191),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(131),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(195),
    [anon_sym_set] = ACTIONS(195),
    [anon_sym_declare] = ACTIONS(197),
    [anon_sym_public] = ACTIONS(199),
    [anon_sym_private] = ACTIONS(199),
    [anon_sym_protected] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_any] = ACTIONS(203),
    [anon_sym_number] = ACTIONS(203),
    [anon_sym_boolean] = ACTIONS(203),
    [anon_sym_string] = ACTIONS(203),
    [anon_sym_symbol] = ACTIONS(203),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(205),
  },
  [7] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [ts_builtin_sym_end] = ACTIONS(207),
    [sym_identifier] = ACTIONS(209),
    [anon_sym_export] = ACTIONS(212),
    [anon_sym_default] = ACTIONS(215),
    [anon_sym_namespace] = ACTIONS(217),
    [anon_sym_LBRACE] = ACTIONS(220),
    [anon_sym_RBRACE] = ACTIONS(207),
    [anon_sym_type] = ACTIONS(223),
    [anon_sym_typeof] = ACTIONS(226),
    [anon_sym_import] = ACTIONS(229),
    [anon_sym_var] = ACTIONS(232),
    [anon_sym_let] = ACTIONS(235),
    [anon_sym_const] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(241),
    [anon_sym_switch] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_await] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(256),
    [anon_sym_do] = ACTIONS(259),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_with] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(268),
    [anon_sym_continue] = ACTIONS(271),
    [anon_sym_debugger] = ACTIONS(274),
    [anon_sym_return] = ACTIONS(277),
    [anon_sym_throw] = ACTIONS(280),
    [anon_sym_SEMI] = ACTIONS(283),
    [anon_sym_case] = ACTIONS(215),
    [anon_sym_yield] = ACTIONS(286),
    [anon_sym_LBRACK] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(292),
    [anon_sym_SLASH] = ACTIONS(295),
    [anon_sym_class] = ACTIONS(298),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(304),
    [anon_sym_new] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_DASH] = ACTIONS(310),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_TILDE] = ACTIONS(313),
    [anon_sym_void] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(319),
    [anon_sym_DASH_DASH] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(322),
    [anon_sym_SQUOTE] = ACTIONS(325),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [sym_number] = ACTIONS(331),
    [sym_this] = ACTIONS(334),
    [sym_super] = ACTIONS(337),
    [sym_true] = ACTIONS(334),
    [sym_false] = ACTIONS(334),
    [sym_null] = ACTIONS(334),
    [sym_undefined] = ACTIONS(334),
    [anon_sym_AT] = ACTIONS(340),
    [anon_sym_static] = ACTIONS(343),
    [anon_sym_abstract] = ACTIONS(346),
    [anon_sym_get] = ACTIONS(343),
    [anon_sym_set] = ACTIONS(343),
    [anon_sym_declare] = ACTIONS(349),
    [anon_sym_public] = ACTIONS(343),
    [anon_sym_private] = ACTIONS(343),
    [anon_sym_protected] = ACTIONS(343),
    [anon_sym_module] = ACTIONS(352),
    [anon_sym_any] = ACTIONS(343),
    [anon_sym_number] = ACTIONS(343),
    [anon_sym_boolean] = ACTIONS(343),
    [anon_sym_string] = ACTIONS(343),
    [anon_sym_symbol] = ACTIONS(343),
    [anon_sym_interface] = ACTIONS(355),
    [anon_sym_enum] = ACTIONS(358),
    [sym_readonly] = ACTIONS(343),
  },
  [8] = {
    [sym_export_statement] = STATE(10),
    [sym__declaration] = STATE(10),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_variable_declaration] = STATE(10),
    [sym_lexical_declaration] = STATE(10),
    [sym_statement_block] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_for_in_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_with_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_debugger_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_throw_statement] = STATE(10),
    [sym_empty_statement] = STATE(10),
    [sym_labeled_statement] = STATE(10),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(10),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(10),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(10),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(10),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(10),
    [sym_abstract_class_declaration] = STATE(10),
    [sym_module] = STATE(10),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(10),
    [sym_interface_declaration] = STATE(10),
    [sym_enum_declaration] = STATE(10),
    [sym_type_alias_declaration] = STATE(10),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(361),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_case] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [9] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(365),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(367),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_case] = ACTIONS(365),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [10] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(369),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(371),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_case] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [11] = {
    [sym_export_statement] = STATE(9),
    [sym__declaration] = STATE(9),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(9),
    [sym_lexical_declaration] = STATE(9),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(9),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(9),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(9),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(9),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(9),
    [sym_abstract_class_declaration] = STATE(9),
    [sym_module] = STATE(9),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(9),
    [sym_interface_declaration] = STATE(9),
    [sym_enum_declaration] = STATE(9),
    [sym_type_alias_declaration] = STATE(9),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(373),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(375),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_case] = ACTIONS(373),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [12] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [ts_builtin_sym_end] = ACTIONS(377),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [13] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(379),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [14] = {
    [sym_export_statement] = STATE(27),
    [sym__declaration] = STATE(27),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_variable_declaration] = STATE(27),
    [sym_lexical_declaration] = STATE(27),
    [sym_statement_block] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_for_in_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_try_statement] = STATE(27),
    [sym_with_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_debugger_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_throw_statement] = STATE(27),
    [sym_empty_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(27),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(27),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(27),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(27),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(27),
    [sym_abstract_class_declaration] = STATE(27),
    [sym_module] = STATE(27),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(27),
    [sym_interface_declaration] = STATE(27),
    [sym_enum_declaration] = STATE(27),
    [sym_type_alias_declaration] = STATE(27),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(27),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(381),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [15] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(383),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [16] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(12),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(12),
    [sym_abstract_class_declaration] = STATE(12),
    [sym_module] = STATE(12),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(12),
    [sym_interface_declaration] = STATE(12),
    [sym_enum_declaration] = STATE(12),
    [sym_type_alias_declaration] = STATE(12),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [ts_builtin_sym_end] = ACTIONS(385),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [17] = {
    [sym_export_statement] = STATE(15),
    [sym__declaration] = STATE(15),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(15),
    [sym_lexical_declaration] = STATE(15),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(15),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(15),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(15),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(15),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(15),
    [sym_abstract_class_declaration] = STATE(15),
    [sym_module] = STATE(15),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(15),
    [sym_interface_declaration] = STATE(15),
    [sym_enum_declaration] = STATE(15),
    [sym_type_alias_declaration] = STATE(15),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(387),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [18] = {
    [sym_export_statement] = STATE(23),
    [sym__declaration] = STATE(23),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(23),
    [sym_lexical_declaration] = STATE(23),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(23),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(23),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(23),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(23),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(23),
    [sym_abstract_class_declaration] = STATE(23),
    [sym_module] = STATE(23),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(23),
    [sym_interface_declaration] = STATE(23),
    [sym_enum_declaration] = STATE(23),
    [sym_type_alias_declaration] = STATE(23),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(389),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [19] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [ts_builtin_sym_end] = ACTIONS(385),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [20] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(391),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [21] = {
    [sym_export_statement] = STATE(22),
    [sym__declaration] = STATE(22),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(22),
    [sym_lexical_declaration] = STATE(22),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(22),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(22),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(22),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(22),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(22),
    [sym_abstract_class_declaration] = STATE(22),
    [sym_module] = STATE(22),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(22),
    [sym_interface_declaration] = STATE(22),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias_declaration] = STATE(22),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(393),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [22] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [23] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(397),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [24] = {
    [sym_export_statement] = STATE(13),
    [sym__declaration] = STATE(13),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_variable_declaration] = STATE(13),
    [sym_lexical_declaration] = STATE(13),
    [sym_statement_block] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_for_in_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_with_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_debugger_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_empty_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(13),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(13),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(13),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(13),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(13),
    [sym_abstract_class_declaration] = STATE(13),
    [sym_module] = STATE(13),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(13),
    [sym_interface_declaration] = STATE(13),
    [sym_enum_declaration] = STATE(13),
    [sym_type_alias_declaration] = STATE(13),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [25] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(401),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [26] = {
    [sym_export_statement] = STATE(25),
    [sym__declaration] = STATE(25),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(25),
    [sym_lexical_declaration] = STATE(25),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(25),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(25),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(25),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(25),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(25),
    [sym_abstract_class_declaration] = STATE(25),
    [sym_module] = STATE(25),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(25),
    [sym_interface_declaration] = STATE(25),
    [sym_enum_declaration] = STATE(25),
    [sym_type_alias_declaration] = STATE(25),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [27] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(7),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(7),
    [sym_abstract_class_declaration] = STATE(7),
    [sym_module] = STATE(7),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_type_alias_declaration] = STATE(7),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(405),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [28] = {
    [sym_export_statement] = STATE(20),
    [sym__declaration] = STATE(20),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(20),
    [sym_lexical_declaration] = STATE(20),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(20),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(20),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(20),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(20),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(20),
    [sym_abstract_class_declaration] = STATE(20),
    [sym_module] = STATE(20),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(20),
    [sym_interface_declaration] = STATE(20),
    [sym_enum_declaration] = STATE(20),
    [sym_type_alias_declaration] = STATE(20),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(407),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [29] = {
    [sym_export_statement] = STATE(696),
    [sym__declaration] = STATE(696),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(696),
    [sym_expression_statement] = STATE(696),
    [sym_variable_declaration] = STATE(696),
    [sym_lexical_declaration] = STATE(696),
    [sym_statement_block] = STATE(696),
    [sym_if_statement] = STATE(696),
    [sym_switch_statement] = STATE(696),
    [sym_for_statement] = STATE(696),
    [sym_for_in_statement] = STATE(696),
    [sym_while_statement] = STATE(696),
    [sym_do_statement] = STATE(696),
    [sym_try_statement] = STATE(696),
    [sym_with_statement] = STATE(696),
    [sym_break_statement] = STATE(696),
    [sym_continue_statement] = STATE(696),
    [sym_debugger_statement] = STATE(696),
    [sym_return_statement] = STATE(696),
    [sym_throw_statement] = STATE(696),
    [sym_empty_statement] = STATE(696),
    [sym_labeled_statement] = STATE(696),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(696),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(696),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(696),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(696),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(696),
    [sym_abstract_class_declaration] = STATE(696),
    [sym_module] = STATE(696),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(696),
    [sym_interface_declaration] = STATE(696),
    [sym_enum_declaration] = STATE(696),
    [sym_type_alias_declaration] = STATE(696),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [30] = {
    [sym_export_statement] = STATE(623),
    [sym__declaration] = STATE(623),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(623),
    [sym_expression_statement] = STATE(623),
    [sym_variable_declaration] = STATE(623),
    [sym_lexical_declaration] = STATE(623),
    [sym_statement_block] = STATE(623),
    [sym_if_statement] = STATE(623),
    [sym_switch_statement] = STATE(623),
    [sym_for_statement] = STATE(623),
    [sym_for_in_statement] = STATE(623),
    [sym_while_statement] = STATE(623),
    [sym_do_statement] = STATE(623),
    [sym_try_statement] = STATE(623),
    [sym_with_statement] = STATE(623),
    [sym_break_statement] = STATE(623),
    [sym_continue_statement] = STATE(623),
    [sym_debugger_statement] = STATE(623),
    [sym_return_statement] = STATE(623),
    [sym_throw_statement] = STATE(623),
    [sym_empty_statement] = STATE(623),
    [sym_labeled_statement] = STATE(623),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(623),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(623),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(623),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(623),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(623),
    [sym_abstract_class_declaration] = STATE(623),
    [sym_module] = STATE(623),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(623),
    [sym_interface_declaration] = STATE(623),
    [sym_enum_declaration] = STATE(623),
    [sym_type_alias_declaration] = STATE(623),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [31] = {
    [sym_export_statement] = STATE(679),
    [sym__declaration] = STATE(679),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(679),
    [sym_expression_statement] = STATE(679),
    [sym_variable_declaration] = STATE(679),
    [sym_lexical_declaration] = STATE(679),
    [sym_statement_block] = STATE(679),
    [sym_if_statement] = STATE(679),
    [sym_switch_statement] = STATE(679),
    [sym_for_statement] = STATE(679),
    [sym_for_in_statement] = STATE(679),
    [sym_while_statement] = STATE(679),
    [sym_do_statement] = STATE(679),
    [sym_try_statement] = STATE(679),
    [sym_with_statement] = STATE(679),
    [sym_break_statement] = STATE(679),
    [sym_continue_statement] = STATE(679),
    [sym_debugger_statement] = STATE(679),
    [sym_return_statement] = STATE(679),
    [sym_throw_statement] = STATE(679),
    [sym_empty_statement] = STATE(679),
    [sym_labeled_statement] = STATE(679),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(679),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(679),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(679),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(679),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(679),
    [sym_abstract_class_declaration] = STATE(679),
    [sym_module] = STATE(679),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(679),
    [sym_interface_declaration] = STATE(679),
    [sym_enum_declaration] = STATE(679),
    [sym_type_alias_declaration] = STATE(679),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [32] = {
    [sym_export_statement] = STATE(677),
    [sym__declaration] = STATE(677),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(677),
    [sym_expression_statement] = STATE(677),
    [sym_variable_declaration] = STATE(677),
    [sym_lexical_declaration] = STATE(677),
    [sym_statement_block] = STATE(677),
    [sym_if_statement] = STATE(677),
    [sym_switch_statement] = STATE(677),
    [sym_for_statement] = STATE(677),
    [sym_for_in_statement] = STATE(677),
    [sym_while_statement] = STATE(677),
    [sym_do_statement] = STATE(677),
    [sym_try_statement] = STATE(677),
    [sym_with_statement] = STATE(677),
    [sym_break_statement] = STATE(677),
    [sym_continue_statement] = STATE(677),
    [sym_debugger_statement] = STATE(677),
    [sym_return_statement] = STATE(677),
    [sym_throw_statement] = STATE(677),
    [sym_empty_statement] = STATE(677),
    [sym_labeled_statement] = STATE(677),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(677),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(677),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(677),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(677),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(677),
    [sym_abstract_class_declaration] = STATE(677),
    [sym_module] = STATE(677),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(677),
    [sym_interface_declaration] = STATE(677),
    [sym_enum_declaration] = STATE(677),
    [sym_type_alias_declaration] = STATE(677),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [33] = {
    [sym_export_statement] = STATE(696),
    [sym__declaration] = STATE(696),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(696),
    [sym_expression_statement] = STATE(696),
    [sym_variable_declaration] = STATE(696),
    [sym_lexical_declaration] = STATE(696),
    [sym_statement_block] = STATE(696),
    [sym_if_statement] = STATE(696),
    [sym_switch_statement] = STATE(696),
    [sym_for_statement] = STATE(696),
    [sym_for_in_statement] = STATE(696),
    [sym_while_statement] = STATE(696),
    [sym_do_statement] = STATE(696),
    [sym_try_statement] = STATE(696),
    [sym_with_statement] = STATE(696),
    [sym_break_statement] = STATE(696),
    [sym_continue_statement] = STATE(696),
    [sym_debugger_statement] = STATE(696),
    [sym_return_statement] = STATE(696),
    [sym_throw_statement] = STATE(696),
    [sym_empty_statement] = STATE(696),
    [sym_labeled_statement] = STATE(696),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(696),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(696),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(696),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(696),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(696),
    [sym_abstract_class_declaration] = STATE(696),
    [sym_module] = STATE(696),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(696),
    [sym_interface_declaration] = STATE(696),
    [sym_enum_declaration] = STATE(696),
    [sym_type_alias_declaration] = STATE(696),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [34] = {
    [sym_export_statement] = STATE(684),
    [sym__declaration] = STATE(684),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(684),
    [sym_expression_statement] = STATE(684),
    [sym_variable_declaration] = STATE(684),
    [sym_lexical_declaration] = STATE(684),
    [sym_statement_block] = STATE(684),
    [sym_if_statement] = STATE(684),
    [sym_switch_statement] = STATE(684),
    [sym_for_statement] = STATE(684),
    [sym_for_in_statement] = STATE(684),
    [sym_while_statement] = STATE(684),
    [sym_do_statement] = STATE(684),
    [sym_try_statement] = STATE(684),
    [sym_with_statement] = STATE(684),
    [sym_break_statement] = STATE(684),
    [sym_continue_statement] = STATE(684),
    [sym_debugger_statement] = STATE(684),
    [sym_return_statement] = STATE(684),
    [sym_throw_statement] = STATE(684),
    [sym_empty_statement] = STATE(684),
    [sym_labeled_statement] = STATE(684),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(684),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(684),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(684),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(684),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(684),
    [sym_abstract_class_declaration] = STATE(684),
    [sym_module] = STATE(684),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(684),
    [sym_interface_declaration] = STATE(684),
    [sym_enum_declaration] = STATE(684),
    [sym_type_alias_declaration] = STATE(684),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [35] = {
    [sym_export_statement] = STATE(677),
    [sym__declaration] = STATE(677),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(677),
    [sym_expression_statement] = STATE(677),
    [sym_variable_declaration] = STATE(677),
    [sym_lexical_declaration] = STATE(677),
    [sym_statement_block] = STATE(677),
    [sym_if_statement] = STATE(677),
    [sym_switch_statement] = STATE(677),
    [sym_for_statement] = STATE(677),
    [sym_for_in_statement] = STATE(677),
    [sym_while_statement] = STATE(677),
    [sym_do_statement] = STATE(677),
    [sym_try_statement] = STATE(677),
    [sym_with_statement] = STATE(677),
    [sym_break_statement] = STATE(677),
    [sym_continue_statement] = STATE(677),
    [sym_debugger_statement] = STATE(677),
    [sym_return_statement] = STATE(677),
    [sym_throw_statement] = STATE(677),
    [sym_empty_statement] = STATE(677),
    [sym_labeled_statement] = STATE(677),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(677),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(677),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(677),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(677),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(677),
    [sym_abstract_class_declaration] = STATE(677),
    [sym_module] = STATE(677),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(677),
    [sym_interface_declaration] = STATE(677),
    [sym_enum_declaration] = STATE(677),
    [sym_type_alias_declaration] = STATE(677),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [36] = {
    [sym_export_statement] = STATE(681),
    [sym__declaration] = STATE(681),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(681),
    [sym_expression_statement] = STATE(681),
    [sym_variable_declaration] = STATE(681),
    [sym_lexical_declaration] = STATE(681),
    [sym_statement_block] = STATE(681),
    [sym_if_statement] = STATE(681),
    [sym_switch_statement] = STATE(681),
    [sym_for_statement] = STATE(681),
    [sym_for_in_statement] = STATE(681),
    [sym_while_statement] = STATE(681),
    [sym_do_statement] = STATE(681),
    [sym_try_statement] = STATE(681),
    [sym_with_statement] = STATE(681),
    [sym_break_statement] = STATE(681),
    [sym_continue_statement] = STATE(681),
    [sym_debugger_statement] = STATE(681),
    [sym_return_statement] = STATE(681),
    [sym_throw_statement] = STATE(681),
    [sym_empty_statement] = STATE(681),
    [sym_labeled_statement] = STATE(681),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(681),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(681),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(681),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(681),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(681),
    [sym_abstract_class_declaration] = STATE(681),
    [sym_module] = STATE(681),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(681),
    [sym_interface_declaration] = STATE(681),
    [sym_enum_declaration] = STATE(681),
    [sym_type_alias_declaration] = STATE(681),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [37] = {
    [sym_export_statement] = STATE(675),
    [sym__declaration] = STATE(675),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(675),
    [sym_expression_statement] = STATE(675),
    [sym_variable_declaration] = STATE(675),
    [sym_lexical_declaration] = STATE(675),
    [sym_statement_block] = STATE(675),
    [sym_if_statement] = STATE(675),
    [sym_switch_statement] = STATE(675),
    [sym_for_statement] = STATE(675),
    [sym_for_in_statement] = STATE(675),
    [sym_while_statement] = STATE(675),
    [sym_do_statement] = STATE(675),
    [sym_try_statement] = STATE(675),
    [sym_with_statement] = STATE(675),
    [sym_break_statement] = STATE(675),
    [sym_continue_statement] = STATE(675),
    [sym_debugger_statement] = STATE(675),
    [sym_return_statement] = STATE(675),
    [sym_throw_statement] = STATE(675),
    [sym_empty_statement] = STATE(675),
    [sym_labeled_statement] = STATE(675),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(675),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(675),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(675),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(675),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(675),
    [sym_abstract_class_declaration] = STATE(675),
    [sym_module] = STATE(675),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(675),
    [sym_interface_declaration] = STATE(675),
    [sym_enum_declaration] = STATE(675),
    [sym_type_alias_declaration] = STATE(675),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [38] = {
    [sym_export_statement] = STATE(3128),
    [sym__declaration] = STATE(3128),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(3128),
    [sym_expression_statement] = STATE(3128),
    [sym_variable_declaration] = STATE(3128),
    [sym_lexical_declaration] = STATE(3128),
    [sym_statement_block] = STATE(3128),
    [sym_if_statement] = STATE(3128),
    [sym_switch_statement] = STATE(3128),
    [sym_for_statement] = STATE(3128),
    [sym_for_in_statement] = STATE(3128),
    [sym_while_statement] = STATE(3128),
    [sym_do_statement] = STATE(3128),
    [sym_try_statement] = STATE(3128),
    [sym_with_statement] = STATE(3128),
    [sym_break_statement] = STATE(3128),
    [sym_continue_statement] = STATE(3128),
    [sym_debugger_statement] = STATE(3128),
    [sym_return_statement] = STATE(3128),
    [sym_throw_statement] = STATE(3128),
    [sym_empty_statement] = STATE(3128),
    [sym_labeled_statement] = STATE(3128),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(3128),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(3128),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(3128),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(3128),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(3128),
    [sym_abstract_class_declaration] = STATE(3128),
    [sym_module] = STATE(3128),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(3128),
    [sym_interface_declaration] = STATE(3128),
    [sym_enum_declaration] = STATE(3128),
    [sym_type_alias_declaration] = STATE(3128),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [39] = {
    [sym_export_statement] = STATE(684),
    [sym__declaration] = STATE(684),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(684),
    [sym_expression_statement] = STATE(684),
    [sym_variable_declaration] = STATE(684),
    [sym_lexical_declaration] = STATE(684),
    [sym_statement_block] = STATE(684),
    [sym_if_statement] = STATE(684),
    [sym_switch_statement] = STATE(684),
    [sym_for_statement] = STATE(684),
    [sym_for_in_statement] = STATE(684),
    [sym_while_statement] = STATE(684),
    [sym_do_statement] = STATE(684),
    [sym_try_statement] = STATE(684),
    [sym_with_statement] = STATE(684),
    [sym_break_statement] = STATE(684),
    [sym_continue_statement] = STATE(684),
    [sym_debugger_statement] = STATE(684),
    [sym_return_statement] = STATE(684),
    [sym_throw_statement] = STATE(684),
    [sym_empty_statement] = STATE(684),
    [sym_labeled_statement] = STATE(684),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(684),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(684),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(684),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(684),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(684),
    [sym_abstract_class_declaration] = STATE(684),
    [sym_module] = STATE(684),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(684),
    [sym_interface_declaration] = STATE(684),
    [sym_enum_declaration] = STATE(684),
    [sym_type_alias_declaration] = STATE(684),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [40] = {
    [sym_export_statement] = STATE(2806),
    [sym__declaration] = STATE(2806),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(2806),
    [sym_expression_statement] = STATE(2806),
    [sym_variable_declaration] = STATE(2806),
    [sym_lexical_declaration] = STATE(2806),
    [sym_statement_block] = STATE(2806),
    [sym_if_statement] = STATE(2806),
    [sym_switch_statement] = STATE(2806),
    [sym_for_statement] = STATE(2806),
    [sym_for_in_statement] = STATE(2806),
    [sym_while_statement] = STATE(2806),
    [sym_do_statement] = STATE(2806),
    [sym_try_statement] = STATE(2806),
    [sym_with_statement] = STATE(2806),
    [sym_break_statement] = STATE(2806),
    [sym_continue_statement] = STATE(2806),
    [sym_debugger_statement] = STATE(2806),
    [sym_return_statement] = STATE(2806),
    [sym_throw_statement] = STATE(2806),
    [sym_empty_statement] = STATE(2806),
    [sym_labeled_statement] = STATE(2806),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(2806),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(2806),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(2806),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(2806),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(2806),
    [sym_abstract_class_declaration] = STATE(2806),
    [sym_module] = STATE(2806),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(2806),
    [sym_interface_declaration] = STATE(2806),
    [sym_enum_declaration] = STATE(2806),
    [sym_type_alias_declaration] = STATE(2806),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [41] = {
    [sym_export_statement] = STATE(675),
    [sym__declaration] = STATE(675),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(675),
    [sym_expression_statement] = STATE(675),
    [sym_variable_declaration] = STATE(675),
    [sym_lexical_declaration] = STATE(675),
    [sym_statement_block] = STATE(675),
    [sym_if_statement] = STATE(675),
    [sym_switch_statement] = STATE(675),
    [sym_for_statement] = STATE(675),
    [sym_for_in_statement] = STATE(675),
    [sym_while_statement] = STATE(675),
    [sym_do_statement] = STATE(675),
    [sym_try_statement] = STATE(675),
    [sym_with_statement] = STATE(675),
    [sym_break_statement] = STATE(675),
    [sym_continue_statement] = STATE(675),
    [sym_debugger_statement] = STATE(675),
    [sym_return_statement] = STATE(675),
    [sym_throw_statement] = STATE(675),
    [sym_empty_statement] = STATE(675),
    [sym_labeled_statement] = STATE(675),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(675),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(675),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(675),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(675),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(675),
    [sym_abstract_class_declaration] = STATE(675),
    [sym_module] = STATE(675),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(675),
    [sym_interface_declaration] = STATE(675),
    [sym_enum_declaration] = STATE(675),
    [sym_type_alias_declaration] = STATE(675),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [42] = {
    [sym_export_statement] = STATE(637),
    [sym__declaration] = STATE(637),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(637),
    [sym_expression_statement] = STATE(637),
    [sym_variable_declaration] = STATE(637),
    [sym_lexical_declaration] = STATE(637),
    [sym_statement_block] = STATE(637),
    [sym_if_statement] = STATE(637),
    [sym_switch_statement] = STATE(637),
    [sym_for_statement] = STATE(637),
    [sym_for_in_statement] = STATE(637),
    [sym_while_statement] = STATE(637),
    [sym_do_statement] = STATE(637),
    [sym_try_statement] = STATE(637),
    [sym_with_statement] = STATE(637),
    [sym_break_statement] = STATE(637),
    [sym_continue_statement] = STATE(637),
    [sym_debugger_statement] = STATE(637),
    [sym_return_statement] = STATE(637),
    [sym_throw_statement] = STATE(637),
    [sym_empty_statement] = STATE(637),
    [sym_labeled_statement] = STATE(637),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(637),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(637),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(637),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(637),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(637),
    [sym_abstract_class_declaration] = STATE(637),
    [sym_module] = STATE(637),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(637),
    [sym_interface_declaration] = STATE(637),
    [sym_enum_declaration] = STATE(637),
    [sym_type_alias_declaration] = STATE(637),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [43] = {
    [sym_export_statement] = STATE(681),
    [sym__declaration] = STATE(681),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(681),
    [sym_expression_statement] = STATE(681),
    [sym_variable_declaration] = STATE(681),
    [sym_lexical_declaration] = STATE(681),
    [sym_statement_block] = STATE(681),
    [sym_if_statement] = STATE(681),
    [sym_switch_statement] = STATE(681),
    [sym_for_statement] = STATE(681),
    [sym_for_in_statement] = STATE(681),
    [sym_while_statement] = STATE(681),
    [sym_do_statement] = STATE(681),
    [sym_try_statement] = STATE(681),
    [sym_with_statement] = STATE(681),
    [sym_break_statement] = STATE(681),
    [sym_continue_statement] = STATE(681),
    [sym_debugger_statement] = STATE(681),
    [sym_return_statement] = STATE(681),
    [sym_throw_statement] = STATE(681),
    [sym_empty_statement] = STATE(681),
    [sym_labeled_statement] = STATE(681),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(681),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(681),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(681),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(681),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(681),
    [sym_abstract_class_declaration] = STATE(681),
    [sym_module] = STATE(681),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(681),
    [sym_interface_declaration] = STATE(681),
    [sym_enum_declaration] = STATE(681),
    [sym_type_alias_declaration] = STATE(681),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [44] = {
    [sym_export_statement] = STATE(627),
    [sym__declaration] = STATE(627),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(627),
    [sym_expression_statement] = STATE(627),
    [sym_variable_declaration] = STATE(627),
    [sym_lexical_declaration] = STATE(627),
    [sym_statement_block] = STATE(627),
    [sym_if_statement] = STATE(627),
    [sym_switch_statement] = STATE(627),
    [sym_for_statement] = STATE(627),
    [sym_for_in_statement] = STATE(627),
    [sym_while_statement] = STATE(627),
    [sym_do_statement] = STATE(627),
    [sym_try_statement] = STATE(627),
    [sym_with_statement] = STATE(627),
    [sym_break_statement] = STATE(627),
    [sym_continue_statement] = STATE(627),
    [sym_debugger_statement] = STATE(627),
    [sym_return_statement] = STATE(627),
    [sym_throw_statement] = STATE(627),
    [sym_empty_statement] = STATE(627),
    [sym_labeled_statement] = STATE(627),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(627),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(627),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(627),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(627),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(627),
    [sym_abstract_class_declaration] = STATE(627),
    [sym_module] = STATE(627),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(627),
    [sym_interface_declaration] = STATE(627),
    [sym_enum_declaration] = STATE(627),
    [sym_type_alias_declaration] = STATE(627),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [45] = {
    [sym_export_statement] = STATE(637),
    [sym__declaration] = STATE(637),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(637),
    [sym_expression_statement] = STATE(637),
    [sym_variable_declaration] = STATE(637),
    [sym_lexical_declaration] = STATE(637),
    [sym_statement_block] = STATE(637),
    [sym_if_statement] = STATE(637),
    [sym_switch_statement] = STATE(637),
    [sym_for_statement] = STATE(637),
    [sym_for_in_statement] = STATE(637),
    [sym_while_statement] = STATE(637),
    [sym_do_statement] = STATE(637),
    [sym_try_statement] = STATE(637),
    [sym_with_statement] = STATE(637),
    [sym_break_statement] = STATE(637),
    [sym_continue_statement] = STATE(637),
    [sym_debugger_statement] = STATE(637),
    [sym_return_statement] = STATE(637),
    [sym_throw_statement] = STATE(637),
    [sym_empty_statement] = STATE(637),
    [sym_labeled_statement] = STATE(637),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(637),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(637),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(637),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(637),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(637),
    [sym_abstract_class_declaration] = STATE(637),
    [sym_module] = STATE(637),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(637),
    [sym_interface_declaration] = STATE(637),
    [sym_enum_declaration] = STATE(637),
    [sym_type_alias_declaration] = STATE(637),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [46] = {
    [sym_export_statement] = STATE(679),
    [sym__declaration] = STATE(679),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(679),
    [sym_expression_statement] = STATE(679),
    [sym_variable_declaration] = STATE(679),
    [sym_lexical_declaration] = STATE(679),
    [sym_statement_block] = STATE(679),
    [sym_if_statement] = STATE(679),
    [sym_switch_statement] = STATE(679),
    [sym_for_statement] = STATE(679),
    [sym_for_in_statement] = STATE(679),
    [sym_while_statement] = STATE(679),
    [sym_do_statement] = STATE(679),
    [sym_try_statement] = STATE(679),
    [sym_with_statement] = STATE(679),
    [sym_break_statement] = STATE(679),
    [sym_continue_statement] = STATE(679),
    [sym_debugger_statement] = STATE(679),
    [sym_return_statement] = STATE(679),
    [sym_throw_statement] = STATE(679),
    [sym_empty_statement] = STATE(679),
    [sym_labeled_statement] = STATE(679),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(679),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(679),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(679),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(679),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(679),
    [sym_abstract_class_declaration] = STATE(679),
    [sym_module] = STATE(679),
    [sym_internal_module] = STATE(1481),
    [sym_import_alias] = STATE(679),
    [sym_interface_declaration] = STATE(679),
    [sym_enum_declaration] = STATE(679),
    [sym_type_alias_declaration] = STATE(679),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2444),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_export] = ACTIONS(411),
    [anon_sym_namespace] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_type] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [anon_sym_declare] = ACTIONS(437),
    [anon_sym_public] = ACTIONS(435),
    [anon_sym_private] = ACTIONS(435),
    [anon_sym_protected] = ACTIONS(435),
    [anon_sym_module] = ACTIONS(439),
    [anon_sym_any] = ACTIONS(435),
    [anon_sym_number] = ACTIONS(435),
    [anon_sym_boolean] = ACTIONS(435),
    [anon_sym_string] = ACTIONS(435),
    [anon_sym_symbol] = ACTIONS(435),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(435),
  },
  [47] = {
    [sym_export_statement] = STATE(623),
    [sym__declaration] = STATE(623),
    [sym_import] = STATE(1292),
    [sym_import_statement] = STATE(623),
    [sym_expression_statement] = STATE(623),
    [sym_variable_declaration] = STATE(623),
    [sym_lexical_declaration] = STATE(623),
    [sym_statement_block] = STATE(623),
    [sym_if_statement] = STATE(623),
    [sym_switch_statement] = STATE(623),
    [sym_for_statement] = STATE(623),
    [sym_for_in_statement] = STATE(623),
    [sym_while_statement] = STATE(623),
    [sym_do_statement] = STATE(623),
    [sym_try_statement] = STATE(623),
    [sym_with_statement] = STATE(623),
    [sym_break_statement] = STATE(623),
    [sym_continue_statement] = STATE(623),
    [sym_debugger_statement] = STATE(623),
    [sym_return_statement] = STATE(623),
    [sym_throw_statement] = STATE(623),
    [sym_empty_statement] = STATE(623),
    [sym_labeled_statement] = STATE(623),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1292),
    [sym_class_declaration] = STATE(623),
    [sym_function] = STATE(1132),
    [sym_function_declaration] = STATE(623),
    [sym_generator_function] = STATE(1292),
    [sym_generator_function_declaration] = STATE(623),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_function_signature] = STATE(623),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_ambient_declaration] = STATE(623),
    [sym_abstract_class_declaration] = STATE(623),
    [sym_module] = STATE(623),
    [sym_internal_module] = STATE(128),
    [sym_import_alias] = STATE(623),
    [sym_interface_declaration] = STATE(623),
    [sym_enum_declaration] = STATE(623),
    [sym_type_alias_declaration] = STATE(623),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2458),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_debugger] = ACTIONS(51),
    [anon_sym_return] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(97),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(97),
    [anon_sym_set] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(97),
    [anon_sym_private] = ACTIONS(97),
    [anon_sym_protected] = ACTIONS(97),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(97),
    [anon_sym_number] = ACTIONS(97),
    [anon_sym_boolean] = ACTIONS(97),
    [anon_sym_string] = ACTIONS(97),
    [anon_sym_symbol] = ACTIONS(97),
    [anon_sym_interface] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(107),
    [sym_readonly] = ACTIONS(97),
  },
  [48] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [aux_sym_object_repeat1] = STATE(2624),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(447),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(455),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(476),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [49] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [aux_sym_object_repeat1] = STATE(2788),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(447),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(476),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [50] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [aux_sym_object_repeat1] = STATE(2635),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(447),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(476),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [51] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1151),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(96),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_RBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [52] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1641),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(97),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
    [sym__automatic_semicolon] = ACTIONS(503),
  },
  [53] = {
    [sym_import] = STATE(1271),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1271),
    [sym_yield_expression] = STATE(1271),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1271),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1271),
    [sym_arrow_function] = STATE(1271),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1271),
    [sym_new_expression] = STATE(1271),
    [sym_await_expression] = STATE(1271),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1271),
    [sym_augmented_assignment_expression] = STATE(1271),
    [sym_ternary_expression] = STATE(1271),
    [sym_binary_expression] = STATE(1271),
    [sym_unary_expression] = STATE(1271),
    [sym_update_expression] = STATE(1271),
    [sym_string] = STATE(1271),
    [sym_template_string] = STATE(1271),
    [sym_regex] = STATE(1271),
    [sym_meta_property] = STATE(1271),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1271),
    [sym_type_assertion] = STATE(1271),
    [sym_as_expression] = STATE(1271),
    [sym_internal_module] = STATE(1271),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(558),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(570),
    [anon_sym_DASH_EQ] = ACTIONS(570),
    [anon_sym_STAR_EQ] = ACTIONS(570),
    [anon_sym_SLASH_EQ] = ACTIONS(570),
    [anon_sym_PERCENT_EQ] = ACTIONS(570),
    [anon_sym_CARET_EQ] = ACTIONS(570),
    [anon_sym_AMP_EQ] = ACTIONS(570),
    [anon_sym_PIPE_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_LT_EQ] = ACTIONS(570),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(570),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(587),
    [sym_this] = ACTIONS(589),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(589),
    [sym_false] = ACTIONS(589),
    [sym_null] = ACTIONS(589),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_PIPE_RBRACE] = ACTIONS(558),
    [sym__automatic_semicolon] = ACTIONS(558),
  },
  [54] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(591),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(593),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [55] = {
    [sym_import] = STATE(1271),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1271),
    [sym_yield_expression] = STATE(1271),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1271),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1271),
    [sym_arrow_function] = STATE(1271),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1271),
    [sym_new_expression] = STATE(1271),
    [sym_await_expression] = STATE(1271),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1271),
    [sym_augmented_assignment_expression] = STATE(1271),
    [sym_ternary_expression] = STATE(1271),
    [sym_binary_expression] = STATE(1271),
    [sym_unary_expression] = STATE(1271),
    [sym_update_expression] = STATE(1271),
    [sym_string] = STATE(1271),
    [sym_template_string] = STATE(1271),
    [sym_regex] = STATE(1271),
    [sym_meta_property] = STATE(1271),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1271),
    [sym_type_assertion] = STATE(1271),
    [sym_as_expression] = STATE(1271),
    [sym_internal_module] = STATE(1271),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(570),
    [anon_sym_DASH_EQ] = ACTIONS(570),
    [anon_sym_STAR_EQ] = ACTIONS(570),
    [anon_sym_SLASH_EQ] = ACTIONS(570),
    [anon_sym_PERCENT_EQ] = ACTIONS(570),
    [anon_sym_CARET_EQ] = ACTIONS(570),
    [anon_sym_AMP_EQ] = ACTIONS(570),
    [anon_sym_PIPE_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_LT_EQ] = ACTIONS(570),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(570),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(587),
    [sym_this] = ACTIONS(589),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(589),
    [sym_false] = ACTIONS(589),
    [sym_null] = ACTIONS(589),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
  },
  [56] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(591),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(595),
    [anon_sym_of] = ACTIONS(598),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [57] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(591),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [58] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(591),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [59] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1151),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(100),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_COLON] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [60] = {
    [sym_import] = STATE(1271),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1271),
    [sym_yield_expression] = STATE(1271),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1271),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1271),
    [sym_arrow_function] = STATE(1271),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1271),
    [sym_new_expression] = STATE(1271),
    [sym_await_expression] = STATE(1271),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1271),
    [sym_augmented_assignment_expression] = STATE(1271),
    [sym_ternary_expression] = STATE(1271),
    [sym_binary_expression] = STATE(1271),
    [sym_unary_expression] = STATE(1271),
    [sym_update_expression] = STATE(1271),
    [sym_string] = STATE(1271),
    [sym_template_string] = STATE(1271),
    [sym_regex] = STATE(1271),
    [sym_meta_property] = STATE(1271),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1271),
    [sym_type_assertion] = STATE(1271),
    [sym_as_expression] = STATE(1271),
    [sym_internal_module] = STATE(1271),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(570),
    [anon_sym_DASH_EQ] = ACTIONS(570),
    [anon_sym_STAR_EQ] = ACTIONS(570),
    [anon_sym_SLASH_EQ] = ACTIONS(570),
    [anon_sym_PERCENT_EQ] = ACTIONS(570),
    [anon_sym_CARET_EQ] = ACTIONS(570),
    [anon_sym_AMP_EQ] = ACTIONS(570),
    [anon_sym_PIPE_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_LT_EQ] = ACTIONS(570),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(570),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(587),
    [sym_this] = ACTIONS(589),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(589),
    [sym_false] = ACTIONS(589),
    [sym_null] = ACTIONS(589),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
  },
  [61] = {
    [sym_import] = STATE(1121),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1121),
    [sym_yield_expression] = STATE(1121),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1121),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1121),
    [sym_arrow_function] = STATE(1121),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1121),
    [sym_new_expression] = STATE(1121),
    [sym_await_expression] = STATE(1121),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1121),
    [sym_augmented_assignment_expression] = STATE(1121),
    [sym_ternary_expression] = STATE(1121),
    [sym_binary_expression] = STATE(1121),
    [sym_unary_expression] = STATE(1121),
    [sym_update_expression] = STATE(1121),
    [sym_string] = STATE(1121),
    [sym_template_string] = STATE(1121),
    [sym_regex] = STATE(1121),
    [sym_meta_property] = STATE(1121),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1121),
    [sym_type_assertion] = STATE(1121),
    [sym_as_expression] = STATE(1121),
    [sym_internal_module] = STATE(1121),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(591),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(602),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS_EQ] = ACTIONS(474),
    [anon_sym_DASH_EQ] = ACTIONS(474),
    [anon_sym_STAR_EQ] = ACTIONS(474),
    [anon_sym_SLASH_EQ] = ACTIONS(474),
    [anon_sym_PERCENT_EQ] = ACTIONS(474),
    [anon_sym_CARET_EQ] = ACTIONS(474),
    [anon_sym_AMP_EQ] = ACTIONS(474),
    [anon_sym_PIPE_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(474),
    [anon_sym_LT_LT_EQ] = ACTIONS(474),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(483),
    [sym_this] = ACTIONS(485),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(485),
    [sym_false] = ACTIONS(485),
    [sym_null] = ACTIONS(485),
    [sym_undefined] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [62] = {
    [sym_import] = STATE(1271),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1271),
    [sym_yield_expression] = STATE(1271),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1271),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1271),
    [sym_arrow_function] = STATE(1271),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1271),
    [sym_new_expression] = STATE(1271),
    [sym_await_expression] = STATE(1271),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1271),
    [sym_augmented_assignment_expression] = STATE(1271),
    [sym_ternary_expression] = STATE(1271),
    [sym_binary_expression] = STATE(1271),
    [sym_unary_expression] = STATE(1271),
    [sym_update_expression] = STATE(1271),
    [sym_string] = STATE(1271),
    [sym_template_string] = STATE(1271),
    [sym_regex] = STATE(1271),
    [sym_meta_property] = STATE(1271),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1271),
    [sym_type_assertion] = STATE(1271),
    [sym_as_expression] = STATE(1271),
    [sym_internal_module] = STATE(1271),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(604),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(570),
    [anon_sym_DASH_EQ] = ACTIONS(570),
    [anon_sym_STAR_EQ] = ACTIONS(570),
    [anon_sym_SLASH_EQ] = ACTIONS(570),
    [anon_sym_PERCENT_EQ] = ACTIONS(570),
    [anon_sym_CARET_EQ] = ACTIONS(570),
    [anon_sym_AMP_EQ] = ACTIONS(570),
    [anon_sym_PIPE_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_LT_EQ] = ACTIONS(570),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(570),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(587),
    [sym_this] = ACTIONS(589),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(589),
    [sym_false] = ACTIONS(589),
    [sym_null] = ACTIONS(589),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
  },
  [63] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1151),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(96),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(606),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [anon_sym_implements] = ACTIONS(495),
    [sym_readonly] = ACTIONS(493),
  },
  [64] = {
    [sym_import] = STATE(1288),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1288),
    [sym_yield_expression] = STATE(1288),
    [sym_object] = STATE(1649),
    [sym_array] = STATE(1630),
    [sym_class] = STATE(1288),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1288),
    [sym_arrow_function] = STATE(1288),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1288),
    [sym_new_expression] = STATE(1288),
    [sym_await_expression] = STATE(1288),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1288),
    [sym_augmented_assignment_expression] = STATE(1288),
    [sym_ternary_expression] = STATE(1288),
    [sym_binary_expression] = STATE(1288),
    [sym_unary_expression] = STATE(1288),
    [sym_update_expression] = STATE(1288),
    [sym_string] = STATE(1288),
    [sym_template_string] = STATE(1288),
    [sym_regex] = STATE(1288),
    [sym_meta_property] = STATE(1288),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1288),
    [sym_type_assertion] = STATE(1288),
    [sym_as_expression] = STATE(1288),
    [sym_internal_module] = STATE(1288),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(608),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_PLUS_EQ] = ACTIONS(626),
    [anon_sym_DASH_EQ] = ACTIONS(626),
    [anon_sym_STAR_EQ] = ACTIONS(626),
    [anon_sym_SLASH_EQ] = ACTIONS(626),
    [anon_sym_PERCENT_EQ] = ACTIONS(626),
    [anon_sym_CARET_EQ] = ACTIONS(626),
    [anon_sym_AMP_EQ] = ACTIONS(626),
    [anon_sym_PIPE_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_LT_LT_EQ] = ACTIONS(626),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(626),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(634),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(638),
    [sym_this] = ACTIONS(640),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(640),
    [sym_false] = ACTIONS(640),
    [sym_null] = ACTIONS(640),
    [sym_undefined] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(610),
    [anon_sym_number] = ACTIONS(610),
    [anon_sym_boolean] = ACTIONS(610),
    [anon_sym_string] = ACTIONS(610),
    [anon_sym_symbol] = ACTIONS(610),
    [sym_readonly] = ACTIONS(610),
  },
  [65] = {
    [sym_import] = STATE(1505),
    [sym_parenthesized_expression] = STATE(1008),
    [sym__expression] = STATE(1505),
    [sym_yield_expression] = STATE(1505),
    [sym_object] = STATE(1721),
    [sym_array] = STATE(1722),
    [sym_class] = STATE(1505),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1505),
    [sym_arrow_function] = STATE(1505),
    [sym__call_signature] = STATE(2996),
    [sym_call_expression] = STATE(1505),
    [sym_new_expression] = STATE(1505),
    [sym_await_expression] = STATE(1505),
    [sym_member_expression] = STATE(1008),
    [sym_subscript_expression] = STATE(1008),
    [sym_assignment_expression] = STATE(1505),
    [sym_augmented_assignment_expression] = STATE(1505),
    [sym_ternary_expression] = STATE(1505),
    [sym_binary_expression] = STATE(1505),
    [sym_unary_expression] = STATE(1505),
    [sym_update_expression] = STATE(1505),
    [sym_string] = STATE(1505),
    [sym_template_string] = STATE(1505),
    [sym_regex] = STATE(1505),
    [sym_meta_property] = STATE(1505),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1505),
    [sym_type_assertion] = STATE(1505),
    [sym_as_expression] = STATE(1505),
    [sym_internal_module] = STATE(1505),
    [sym_type_arguments] = STATE(360),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(642),
    [anon_sym_export] = ACTIONS(644),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(646),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(558),
    [anon_sym_type] = ACTIONS(644),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(652),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(654),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_new] = ACTIONS(660),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(666),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_void] = ACTIONS(670),
    [anon_sym_delete] = ACTIONS(650),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(674),
    [sym_this] = ACTIONS(676),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(676),
    [sym_false] = ACTIONS(676),
    [sym_null] = ACTIONS(676),
    [sym_undefined] = ACTIONS(676),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(644),
    [anon_sym_get] = ACTIONS(644),
    [anon_sym_set] = ACTIONS(644),
    [anon_sym_declare] = ACTIONS(644),
    [anon_sym_public] = ACTIONS(644),
    [anon_sym_private] = ACTIONS(644),
    [anon_sym_protected] = ACTIONS(644),
    [anon_sym_module] = ACTIONS(644),
    [anon_sym_any] = ACTIONS(644),
    [anon_sym_number] = ACTIONS(644),
    [anon_sym_boolean] = ACTIONS(644),
    [anon_sym_string] = ACTIONS(644),
    [anon_sym_symbol] = ACTIONS(644),
    [sym_readonly] = ACTIONS(644),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [66] = {
    [sym_import] = STATE(1288),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1288),
    [sym_yield_expression] = STATE(1288),
    [sym_object] = STATE(1649),
    [sym_array] = STATE(1630),
    [sym_class] = STATE(1288),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1288),
    [sym_arrow_function] = STATE(1288),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1288),
    [sym_new_expression] = STATE(1288),
    [sym_await_expression] = STATE(1288),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1288),
    [sym_augmented_assignment_expression] = STATE(1288),
    [sym_ternary_expression] = STATE(1288),
    [sym_binary_expression] = STATE(1288),
    [sym_unary_expression] = STATE(1288),
    [sym_update_expression] = STATE(1288),
    [sym_string] = STATE(1288),
    [sym_template_string] = STATE(1288),
    [sym_regex] = STATE(1288),
    [sym_meta_property] = STATE(1288),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1288),
    [sym_type_assertion] = STATE(1288),
    [sym_as_expression] = STATE(1288),
    [sym_internal_module] = STATE(1288),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(608),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(678),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(681),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(684),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(681),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_PLUS_EQ] = ACTIONS(626),
    [anon_sym_DASH_EQ] = ACTIONS(626),
    [anon_sym_STAR_EQ] = ACTIONS(626),
    [anon_sym_SLASH_EQ] = ACTIONS(626),
    [anon_sym_PERCENT_EQ] = ACTIONS(626),
    [anon_sym_CARET_EQ] = ACTIONS(626),
    [anon_sym_AMP_EQ] = ACTIONS(626),
    [anon_sym_PIPE_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_LT_LT_EQ] = ACTIONS(626),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(626),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(634),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(638),
    [sym_this] = ACTIONS(640),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(640),
    [sym_false] = ACTIONS(640),
    [sym_null] = ACTIONS(640),
    [sym_undefined] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(610),
    [anon_sym_number] = ACTIONS(610),
    [anon_sym_boolean] = ACTIONS(610),
    [anon_sym_string] = ACTIONS(610),
    [anon_sym_symbol] = ACTIONS(610),
    [sym_readonly] = ACTIONS(610),
  },
  [67] = {
    [sym_import] = STATE(1288),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1288),
    [sym_yield_expression] = STATE(1288),
    [sym_object] = STATE(1649),
    [sym_array] = STATE(1630),
    [sym_class] = STATE(1288),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1288),
    [sym_arrow_function] = STATE(1288),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1288),
    [sym_new_expression] = STATE(1288),
    [sym_await_expression] = STATE(1288),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1288),
    [sym_augmented_assignment_expression] = STATE(1288),
    [sym_ternary_expression] = STATE(1288),
    [sym_binary_expression] = STATE(1288),
    [sym_unary_expression] = STATE(1288),
    [sym_update_expression] = STATE(1288),
    [sym_string] = STATE(1288),
    [sym_template_string] = STATE(1288),
    [sym_regex] = STATE(1288),
    [sym_meta_property] = STATE(1288),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1288),
    [sym_type_assertion] = STATE(1288),
    [sym_as_expression] = STATE(1288),
    [sym_internal_module] = STATE(1288),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(608),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(678),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(681),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(681),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(681),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_PLUS_EQ] = ACTIONS(626),
    [anon_sym_DASH_EQ] = ACTIONS(626),
    [anon_sym_STAR_EQ] = ACTIONS(626),
    [anon_sym_SLASH_EQ] = ACTIONS(626),
    [anon_sym_PERCENT_EQ] = ACTIONS(626),
    [anon_sym_CARET_EQ] = ACTIONS(626),
    [anon_sym_AMP_EQ] = ACTIONS(626),
    [anon_sym_PIPE_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_LT_LT_EQ] = ACTIONS(626),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(626),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(634),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(638),
    [sym_this] = ACTIONS(640),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(640),
    [sym_false] = ACTIONS(640),
    [sym_null] = ACTIONS(640),
    [sym_undefined] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(610),
    [anon_sym_number] = ACTIONS(610),
    [anon_sym_boolean] = ACTIONS(610),
    [anon_sym_string] = ACTIONS(610),
    [anon_sym_symbol] = ACTIONS(610),
    [sym_readonly] = ACTIONS(610),
  },
  [68] = {
    [sym_import] = STATE(1288),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1288),
    [sym_yield_expression] = STATE(1288),
    [sym_object] = STATE(1649),
    [sym_array] = STATE(1630),
    [sym_class] = STATE(1288),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1288),
    [sym_arrow_function] = STATE(1288),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1288),
    [sym_new_expression] = STATE(1288),
    [sym_await_expression] = STATE(1288),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1288),
    [sym_augmented_assignment_expression] = STATE(1288),
    [sym_ternary_expression] = STATE(1288),
    [sym_binary_expression] = STATE(1288),
    [sym_unary_expression] = STATE(1288),
    [sym_update_expression] = STATE(1288),
    [sym_string] = STATE(1288),
    [sym_template_string] = STATE(1288),
    [sym_regex] = STATE(1288),
    [sym_meta_property] = STATE(1288),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1288),
    [sym_type_assertion] = STATE(1288),
    [sym_as_expression] = STATE(1288),
    [sym_internal_module] = STATE(1288),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(608),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_PLUS_EQ] = ACTIONS(626),
    [anon_sym_DASH_EQ] = ACTIONS(626),
    [anon_sym_STAR_EQ] = ACTIONS(626),
    [anon_sym_SLASH_EQ] = ACTIONS(626),
    [anon_sym_PERCENT_EQ] = ACTIONS(626),
    [anon_sym_CARET_EQ] = ACTIONS(626),
    [anon_sym_AMP_EQ] = ACTIONS(626),
    [anon_sym_PIPE_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(626),
    [anon_sym_LT_LT_EQ] = ACTIONS(626),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(626),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(634),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(638),
    [sym_this] = ACTIONS(640),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(640),
    [sym_false] = ACTIONS(640),
    [sym_null] = ACTIONS(640),
    [sym_undefined] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(610),
    [anon_sym_number] = ACTIONS(610),
    [anon_sym_boolean] = ACTIONS(610),
    [anon_sym_string] = ACTIONS(610),
    [anon_sym_symbol] = ACTIONS(610),
    [sym_readonly] = ACTIONS(610),
  },
  [69] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1741),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(110),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(495),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(691),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(693),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
    [anon_sym_LBRACE_PIPE] = ACTIONS(503),
  },
  [70] = {
    [sym_import] = STATE(1271),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1271),
    [sym_yield_expression] = STATE(1271),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1271),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1271),
    [sym_arrow_function] = STATE(1271),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1271),
    [sym_new_expression] = STATE(1271),
    [sym_await_expression] = STATE(1271),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1271),
    [sym_augmented_assignment_expression] = STATE(1271),
    [sym_ternary_expression] = STATE(1271),
    [sym_binary_expression] = STATE(1271),
    [sym_unary_expression] = STATE(1271),
    [sym_update_expression] = STATE(1271),
    [sym_string] = STATE(1271),
    [sym_template_string] = STATE(1271),
    [sym_regex] = STATE(1271),
    [sym_meta_property] = STATE(1271),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1271),
    [sym_type_assertion] = STATE(1271),
    [sym_as_expression] = STATE(1271),
    [sym_internal_module] = STATE(1271),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(681),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(681),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(698),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(570),
    [anon_sym_DASH_EQ] = ACTIONS(570),
    [anon_sym_STAR_EQ] = ACTIONS(570),
    [anon_sym_SLASH_EQ] = ACTIONS(570),
    [anon_sym_PERCENT_EQ] = ACTIONS(570),
    [anon_sym_CARET_EQ] = ACTIONS(570),
    [anon_sym_AMP_EQ] = ACTIONS(570),
    [anon_sym_PIPE_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_LT_EQ] = ACTIONS(570),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(570),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(587),
    [sym_this] = ACTIONS(589),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(589),
    [sym_false] = ACTIONS(589),
    [sym_null] = ACTIONS(589),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
  },
  [71] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1641),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(97),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
    [sym__automatic_semicolon] = ACTIONS(503),
  },
  [72] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1151),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(100),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_COLON] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(700),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [73] = {
    [sym_import] = STATE(1372),
    [sym_parenthesized_expression] = STATE(975),
    [sym__expression] = STATE(1372),
    [sym_yield_expression] = STATE(1372),
    [sym_object] = STATE(1631),
    [sym_array] = STATE(1632),
    [sym_class] = STATE(1372),
    [sym_function] = STATE(1342),
    [sym_generator_function] = STATE(1372),
    [sym_arrow_function] = STATE(1372),
    [sym__call_signature] = STATE(3044),
    [sym_call_expression] = STATE(1372),
    [sym_new_expression] = STATE(1372),
    [sym_await_expression] = STATE(1372),
    [sym_member_expression] = STATE(975),
    [sym_subscript_expression] = STATE(975),
    [sym_assignment_expression] = STATE(1372),
    [sym_augmented_assignment_expression] = STATE(1372),
    [sym_ternary_expression] = STATE(1372),
    [sym_binary_expression] = STATE(1372),
    [sym_unary_expression] = STATE(1372),
    [sym_update_expression] = STATE(1372),
    [sym_string] = STATE(1372),
    [sym_template_string] = STATE(1372),
    [sym_regex] = STATE(1372),
    [sym_meta_property] = STATE(1372),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1372),
    [sym_type_assertion] = STATE(1372),
    [sym_as_expression] = STATE(1372),
    [sym_internal_module] = STATE(1372),
    [sym_type_arguments] = STATE(412),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2579),
    [sym_identifier] = ACTIONS(702),
    [anon_sym_export] = ACTIONS(704),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(706),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(704),
    [anon_sym_typeof] = ACTIONS(712),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_await] = ACTIONS(718),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(722),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(724),
    [anon_sym_DOT] = ACTIONS(691),
    [anon_sym_class] = ACTIONS(726),
    [anon_sym_async] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_EQ_GT] = ACTIONS(693),
    [anon_sym_new] = ACTIONS(732),
    [anon_sym_PLUS_EQ] = ACTIONS(734),
    [anon_sym_DASH_EQ] = ACTIONS(734),
    [anon_sym_STAR_EQ] = ACTIONS(734),
    [anon_sym_SLASH_EQ] = ACTIONS(734),
    [anon_sym_PERCENT_EQ] = ACTIONS(734),
    [anon_sym_CARET_EQ] = ACTIONS(734),
    [anon_sym_AMP_EQ] = ACTIONS(734),
    [anon_sym_PIPE_EQ] = ACTIONS(734),
    [anon_sym_GT_GT_EQ] = ACTIONS(734),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_EQ] = ACTIONS(734),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(734),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_void] = ACTIONS(742),
    [anon_sym_delete] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(744),
    [anon_sym_DASH_DASH] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_number] = ACTIONS(752),
    [sym_this] = ACTIONS(754),
    [sym_super] = ACTIONS(756),
    [sym_true] = ACTIONS(754),
    [sym_false] = ACTIONS(754),
    [sym_null] = ACTIONS(754),
    [sym_undefined] = ACTIONS(754),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(704),
    [anon_sym_get] = ACTIONS(704),
    [anon_sym_set] = ACTIONS(704),
    [anon_sym_declare] = ACTIONS(704),
    [anon_sym_public] = ACTIONS(704),
    [anon_sym_private] = ACTIONS(704),
    [anon_sym_protected] = ACTIONS(704),
    [anon_sym_module] = ACTIONS(704),
    [anon_sym_any] = ACTIONS(704),
    [anon_sym_number] = ACTIONS(704),
    [anon_sym_boolean] = ACTIONS(704),
    [anon_sym_string] = ACTIONS(704),
    [anon_sym_symbol] = ACTIONS(704),
    [sym_readonly] = ACTIONS(704),
    [anon_sym_LBRACE_PIPE] = ACTIONS(453),
  },
  [74] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(558),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [75] = {
    [sym_import] = STATE(1373),
    [sym_parenthesized_expression] = STATE(983),
    [sym__expression] = STATE(1373),
    [sym_yield_expression] = STATE(1373),
    [sym_object] = STATE(1672),
    [sym_array] = STATE(1671),
    [sym_class] = STATE(1373),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1373),
    [sym_arrow_function] = STATE(1373),
    [sym__call_signature] = STATE(3144),
    [sym_call_expression] = STATE(1373),
    [sym_new_expression] = STATE(1373),
    [sym_await_expression] = STATE(1373),
    [sym_member_expression] = STATE(983),
    [sym_subscript_expression] = STATE(983),
    [sym_assignment_expression] = STATE(1373),
    [sym_augmented_assignment_expression] = STATE(1373),
    [sym_ternary_expression] = STATE(1373),
    [sym_binary_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_update_expression] = STATE(1373),
    [sym_string] = STATE(1373),
    [sym_template_string] = STATE(1373),
    [sym_regex] = STATE(1373),
    [sym_meta_property] = STATE(1373),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1373),
    [sym_type_assertion] = STATE(1373),
    [sym_as_expression] = STATE(1373),
    [sym_internal_module] = STATE(1373),
    [sym_type_arguments] = STATE(390),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(766),
    [anon_sym_export] = ACTIONS(768),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(770),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(772),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_type] = ACTIONS(768),
    [anon_sym_typeof] = ACTIONS(774),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(776),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(780),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(782),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(606),
    [anon_sym_new] = ACTIONS(784),
    [anon_sym_PLUS_EQ] = ACTIONS(786),
    [anon_sym_DASH_EQ] = ACTIONS(786),
    [anon_sym_STAR_EQ] = ACTIONS(786),
    [anon_sym_SLASH_EQ] = ACTIONS(786),
    [anon_sym_PERCENT_EQ] = ACTIONS(786),
    [anon_sym_CARET_EQ] = ACTIONS(786),
    [anon_sym_AMP_EQ] = ACTIONS(786),
    [anon_sym_PIPE_EQ] = ACTIONS(786),
    [anon_sym_GT_GT_EQ] = ACTIONS(786),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(786),
    [anon_sym_LT_LT_EQ] = ACTIONS(786),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(786),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(788),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(792),
    [anon_sym_void] = ACTIONS(794),
    [anon_sym_delete] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(796),
    [anon_sym_DASH_DASH] = ACTIONS(796),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(798),
    [sym_this] = ACTIONS(800),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(800),
    [sym_false] = ACTIONS(800),
    [sym_null] = ACTIONS(800),
    [sym_undefined] = ACTIONS(800),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_get] = ACTIONS(768),
    [anon_sym_set] = ACTIONS(768),
    [anon_sym_declare] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_any] = ACTIONS(768),
    [anon_sym_number] = ACTIONS(768),
    [anon_sym_boolean] = ACTIONS(768),
    [anon_sym_string] = ACTIONS(768),
    [anon_sym_symbol] = ACTIONS(768),
    [anon_sym_implements] = ACTIONS(445),
    [sym_readonly] = ACTIONS(768),
  },
  [76] = {
    [sym_import] = STATE(1372),
    [sym_parenthesized_expression] = STATE(975),
    [sym__expression] = STATE(1372),
    [sym_yield_expression] = STATE(1372),
    [sym_object] = STATE(1631),
    [sym_array] = STATE(1632),
    [sym_class] = STATE(1372),
    [sym_function] = STATE(1342),
    [sym_generator_function] = STATE(1372),
    [sym_arrow_function] = STATE(1372),
    [sym__call_signature] = STATE(3044),
    [sym_call_expression] = STATE(1372),
    [sym_new_expression] = STATE(1372),
    [sym_await_expression] = STATE(1372),
    [sym_member_expression] = STATE(975),
    [sym_subscript_expression] = STATE(975),
    [sym_assignment_expression] = STATE(1372),
    [sym_augmented_assignment_expression] = STATE(1372),
    [sym_ternary_expression] = STATE(1372),
    [sym_binary_expression] = STATE(1372),
    [sym_unary_expression] = STATE(1372),
    [sym_update_expression] = STATE(1372),
    [sym_string] = STATE(1372),
    [sym_template_string] = STATE(1372),
    [sym_regex] = STATE(1372),
    [sym_meta_property] = STATE(1372),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1372),
    [sym_type_assertion] = STATE(1372),
    [sym_as_expression] = STATE(1372),
    [sym_internal_module] = STATE(1372),
    [sym_type_arguments] = STATE(412),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2579),
    [sym_identifier] = ACTIONS(702),
    [anon_sym_export] = ACTIONS(704),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(706),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_type] = ACTIONS(704),
    [anon_sym_typeof] = ACTIONS(712),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_await] = ACTIONS(718),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(722),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(724),
    [anon_sym_DOT] = ACTIONS(691),
    [anon_sym_class] = ACTIONS(726),
    [anon_sym_async] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_EQ_GT] = ACTIONS(693),
    [anon_sym_new] = ACTIONS(732),
    [anon_sym_PLUS_EQ] = ACTIONS(734),
    [anon_sym_DASH_EQ] = ACTIONS(734),
    [anon_sym_STAR_EQ] = ACTIONS(734),
    [anon_sym_SLASH_EQ] = ACTIONS(734),
    [anon_sym_PERCENT_EQ] = ACTIONS(734),
    [anon_sym_CARET_EQ] = ACTIONS(734),
    [anon_sym_AMP_EQ] = ACTIONS(734),
    [anon_sym_PIPE_EQ] = ACTIONS(734),
    [anon_sym_GT_GT_EQ] = ACTIONS(734),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_EQ] = ACTIONS(734),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(734),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_void] = ACTIONS(742),
    [anon_sym_delete] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(744),
    [anon_sym_DASH_DASH] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_number] = ACTIONS(752),
    [sym_this] = ACTIONS(754),
    [sym_super] = ACTIONS(756),
    [sym_true] = ACTIONS(754),
    [sym_false] = ACTIONS(754),
    [sym_null] = ACTIONS(754),
    [sym_undefined] = ACTIONS(754),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(704),
    [anon_sym_get] = ACTIONS(704),
    [anon_sym_set] = ACTIONS(704),
    [anon_sym_declare] = ACTIONS(704),
    [anon_sym_public] = ACTIONS(704),
    [anon_sym_private] = ACTIONS(704),
    [anon_sym_protected] = ACTIONS(704),
    [anon_sym_module] = ACTIONS(704),
    [anon_sym_any] = ACTIONS(704),
    [anon_sym_number] = ACTIONS(704),
    [anon_sym_boolean] = ACTIONS(704),
    [anon_sym_string] = ACTIONS(704),
    [anon_sym_symbol] = ACTIONS(704),
    [sym_readonly] = ACTIONS(704),
    [anon_sym_LBRACE_PIPE] = ACTIONS(453),
  },
  [77] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_arguments] = STATE(1151),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(96),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(495),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_RBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(495),
    [anon_sym_LT_LT] = ACTIONS(495),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_STAR_STAR] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [78] = {
    [sym_import] = STATE(1658),
    [sym_parenthesized_expression] = STATE(1020),
    [sym__expression] = STATE(1658),
    [sym_yield_expression] = STATE(1658),
    [sym_object] = STATE(1871),
    [sym_array] = STATE(1873),
    [sym_class] = STATE(1658),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1658),
    [sym_arrow_function] = STATE(1658),
    [sym__call_signature] = STATE(3037),
    [sym_call_expression] = STATE(1658),
    [sym_new_expression] = STATE(1658),
    [sym_await_expression] = STATE(1658),
    [sym_member_expression] = STATE(1020),
    [sym_subscript_expression] = STATE(1020),
    [sym_assignment_expression] = STATE(1658),
    [sym_augmented_assignment_expression] = STATE(1658),
    [sym_ternary_expression] = STATE(1658),
    [sym_binary_expression] = STATE(1658),
    [sym_unary_expression] = STATE(1658),
    [sym_update_expression] = STATE(1658),
    [sym_string] = STATE(1658),
    [sym_template_string] = STATE(1658),
    [sym_regex] = STATE(1658),
    [sym_meta_property] = STATE(1658),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1658),
    [sym_type_assertion] = STATE(1658),
    [sym_as_expression] = STATE(1658),
    [sym_internal_module] = STATE(1658),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_export] = ACTIONS(804),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(806),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(558),
    [anon_sym_type] = ACTIONS(804),
    [anon_sym_typeof] = ACTIONS(810),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(812),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(814),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(816),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(700),
    [anon_sym_new] = ACTIONS(818),
    [anon_sym_PLUS_EQ] = ACTIONS(820),
    [anon_sym_DASH_EQ] = ACTIONS(820),
    [anon_sym_STAR_EQ] = ACTIONS(820),
    [anon_sym_SLASH_EQ] = ACTIONS(820),
    [anon_sym_PERCENT_EQ] = ACTIONS(820),
    [anon_sym_CARET_EQ] = ACTIONS(820),
    [anon_sym_AMP_EQ] = ACTIONS(820),
    [anon_sym_PIPE_EQ] = ACTIONS(820),
    [anon_sym_GT_GT_EQ] = ACTIONS(820),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(820),
    [anon_sym_LT_LT_EQ] = ACTIONS(820),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(820),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(822),
    [anon_sym_DASH] = ACTIONS(822),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(824),
    [anon_sym_TILDE] = ACTIONS(826),
    [anon_sym_void] = ACTIONS(828),
    [anon_sym_delete] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(830),
    [anon_sym_DASH_DASH] = ACTIONS(830),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(832),
    [sym_this] = ACTIONS(834),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(834),
    [sym_false] = ACTIONS(834),
    [sym_null] = ACTIONS(834),
    [sym_undefined] = ACTIONS(834),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_get] = ACTIONS(804),
    [anon_sym_set] = ACTIONS(804),
    [anon_sym_declare] = ACTIONS(804),
    [anon_sym_public] = ACTIONS(804),
    [anon_sym_private] = ACTIONS(804),
    [anon_sym_protected] = ACTIONS(804),
    [anon_sym_module] = ACTIONS(804),
    [anon_sym_any] = ACTIONS(804),
    [anon_sym_number] = ACTIONS(804),
    [anon_sym_boolean] = ACTIONS(804),
    [anon_sym_string] = ACTIONS(804),
    [anon_sym_symbol] = ACTIONS(804),
    [sym_readonly] = ACTIONS(804),
  },
  [79] = {
    [sym_import] = STATE(1373),
    [sym_parenthesized_expression] = STATE(983),
    [sym__expression] = STATE(1373),
    [sym_yield_expression] = STATE(1373),
    [sym_object] = STATE(1672),
    [sym_array] = STATE(1671),
    [sym_class] = STATE(1373),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1373),
    [sym_arrow_function] = STATE(1373),
    [sym__call_signature] = STATE(3144),
    [sym_call_expression] = STATE(1373),
    [sym_new_expression] = STATE(1373),
    [sym_await_expression] = STATE(1373),
    [sym_member_expression] = STATE(983),
    [sym_subscript_expression] = STATE(983),
    [sym_assignment_expression] = STATE(1373),
    [sym_augmented_assignment_expression] = STATE(1373),
    [sym_ternary_expression] = STATE(1373),
    [sym_binary_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_update_expression] = STATE(1373),
    [sym_string] = STATE(1373),
    [sym_template_string] = STATE(1373),
    [sym_regex] = STATE(1373),
    [sym_meta_property] = STATE(1373),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1373),
    [sym_type_assertion] = STATE(1373),
    [sym_as_expression] = STATE(1373),
    [sym_internal_module] = STATE(1373),
    [sym_type_arguments] = STATE(390),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(766),
    [anon_sym_export] = ACTIONS(768),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(770),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(772),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_type] = ACTIONS(768),
    [anon_sym_typeof] = ACTIONS(774),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(776),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(780),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(782),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(606),
    [anon_sym_new] = ACTIONS(784),
    [anon_sym_PLUS_EQ] = ACTIONS(786),
    [anon_sym_DASH_EQ] = ACTIONS(786),
    [anon_sym_STAR_EQ] = ACTIONS(786),
    [anon_sym_SLASH_EQ] = ACTIONS(786),
    [anon_sym_PERCENT_EQ] = ACTIONS(786),
    [anon_sym_CARET_EQ] = ACTIONS(786),
    [anon_sym_AMP_EQ] = ACTIONS(786),
    [anon_sym_PIPE_EQ] = ACTIONS(786),
    [anon_sym_GT_GT_EQ] = ACTIONS(786),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(786),
    [anon_sym_LT_LT_EQ] = ACTIONS(786),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(786),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(788),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(792),
    [anon_sym_void] = ACTIONS(794),
    [anon_sym_delete] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(796),
    [anon_sym_DASH_DASH] = ACTIONS(796),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(798),
    [sym_this] = ACTIONS(800),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(800),
    [sym_false] = ACTIONS(800),
    [sym_null] = ACTIONS(800),
    [sym_undefined] = ACTIONS(800),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_get] = ACTIONS(768),
    [anon_sym_set] = ACTIONS(768),
    [anon_sym_declare] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_any] = ACTIONS(768),
    [anon_sym_number] = ACTIONS(768),
    [anon_sym_boolean] = ACTIONS(768),
    [anon_sym_string] = ACTIONS(768),
    [anon_sym_symbol] = ACTIONS(768),
    [anon_sym_implements] = ACTIONS(445),
    [sym_readonly] = ACTIONS(768),
  },
  [80] = {
    [sym_import] = STATE(1271),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1271),
    [sym_yield_expression] = STATE(1271),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1271),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1271),
    [sym_arrow_function] = STATE(1271),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1271),
    [sym_new_expression] = STATE(1271),
    [sym_await_expression] = STATE(1271),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1271),
    [sym_augmented_assignment_expression] = STATE(1271),
    [sym_ternary_expression] = STATE(1271),
    [sym_binary_expression] = STATE(1271),
    [sym_unary_expression] = STATE(1271),
    [sym_update_expression] = STATE(1271),
    [sym_string] = STATE(1271),
    [sym_template_string] = STATE(1271),
    [sym_regex] = STATE(1271),
    [sym_meta_property] = STATE(1271),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1271),
    [sym_type_assertion] = STATE(1271),
    [sym_as_expression] = STATE(1271),
    [sym_internal_module] = STATE(1271),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(570),
    [anon_sym_DASH_EQ] = ACTIONS(570),
    [anon_sym_STAR_EQ] = ACTIONS(570),
    [anon_sym_SLASH_EQ] = ACTIONS(570),
    [anon_sym_PERCENT_EQ] = ACTIONS(570),
    [anon_sym_CARET_EQ] = ACTIONS(570),
    [anon_sym_AMP_EQ] = ACTIONS(570),
    [anon_sym_PIPE_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_LT_EQ] = ACTIONS(570),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(570),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(587),
    [sym_this] = ACTIONS(589),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(589),
    [sym_false] = ACTIONS(589),
    [sym_null] = ACTIONS(589),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
  },
  [81] = {
    [sym_import] = STATE(1505),
    [sym_parenthesized_expression] = STATE(1008),
    [sym__expression] = STATE(1505),
    [sym_yield_expression] = STATE(1505),
    [sym_object] = STATE(1721),
    [sym_array] = STATE(1722),
    [sym_class] = STATE(1505),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1505),
    [sym_arrow_function] = STATE(1505),
    [sym__call_signature] = STATE(2996),
    [sym_call_expression] = STATE(1505),
    [sym_new_expression] = STATE(1505),
    [sym_await_expression] = STATE(1505),
    [sym_member_expression] = STATE(1008),
    [sym_subscript_expression] = STATE(1008),
    [sym_assignment_expression] = STATE(1505),
    [sym_augmented_assignment_expression] = STATE(1505),
    [sym_ternary_expression] = STATE(1505),
    [sym_binary_expression] = STATE(1505),
    [sym_unary_expression] = STATE(1505),
    [sym_update_expression] = STATE(1505),
    [sym_string] = STATE(1505),
    [sym_template_string] = STATE(1505),
    [sym_regex] = STATE(1505),
    [sym_meta_property] = STATE(1505),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1505),
    [sym_type_assertion] = STATE(1505),
    [sym_as_expression] = STATE(1505),
    [sym_internal_module] = STATE(1505),
    [sym_type_arguments] = STATE(360),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(642),
    [anon_sym_export] = ACTIONS(644),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(646),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_type] = ACTIONS(644),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(652),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(654),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_new] = ACTIONS(660),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(666),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_void] = ACTIONS(670),
    [anon_sym_delete] = ACTIONS(650),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(674),
    [sym_this] = ACTIONS(676),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(676),
    [sym_false] = ACTIONS(676),
    [sym_null] = ACTIONS(676),
    [sym_undefined] = ACTIONS(676),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(644),
    [anon_sym_get] = ACTIONS(644),
    [anon_sym_set] = ACTIONS(644),
    [anon_sym_declare] = ACTIONS(644),
    [anon_sym_public] = ACTIONS(644),
    [anon_sym_private] = ACTIONS(644),
    [anon_sym_protected] = ACTIONS(644),
    [anon_sym_module] = ACTIONS(644),
    [anon_sym_any] = ACTIONS(644),
    [anon_sym_number] = ACTIONS(644),
    [anon_sym_boolean] = ACTIONS(644),
    [anon_sym_string] = ACTIONS(644),
    [anon_sym_symbol] = ACTIONS(644),
    [sym_readonly] = ACTIONS(644),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [82] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(604),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [83] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(595),
    [anon_sym_of] = ACTIONS(598),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [84] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [85] = {
    [sym_import] = STATE(1533),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1533),
    [sym_yield_expression] = STATE(1533),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1533),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1533),
    [sym_arrow_function] = STATE(1533),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1533),
    [sym_new_expression] = STATE(1533),
    [sym_await_expression] = STATE(1533),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1533),
    [sym_augmented_assignment_expression] = STATE(1533),
    [sym_ternary_expression] = STATE(1533),
    [sym_binary_expression] = STATE(1533),
    [sym_unary_expression] = STATE(1533),
    [sym_update_expression] = STATE(1533),
    [sym_string] = STATE(1533),
    [sym_template_string] = STATE(1533),
    [sym_regex] = STATE(1533),
    [sym_meta_property] = STATE(1533),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1533),
    [sym_type_assertion] = STATE(1533),
    [sym_as_expression] = STATE(1533),
    [sym_internal_module] = STATE(1533),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(836),
    [anon_sym_of] = ACTIONS(839),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_PLUS_EQ] = ACTIONS(525),
    [anon_sym_DASH_EQ] = ACTIONS(525),
    [anon_sym_STAR_EQ] = ACTIONS(525),
    [anon_sym_SLASH_EQ] = ACTIONS(525),
    [anon_sym_PERCENT_EQ] = ACTIONS(525),
    [anon_sym_CARET_EQ] = ACTIONS(525),
    [anon_sym_AMP_EQ] = ACTIONS(525),
    [anon_sym_PIPE_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(525),
    [anon_sym_LT_LT_EQ] = ACTIONS(525),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(535),
    [sym_this] = ACTIONS(537),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_undefined] = ACTIONS(537),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [86] = {
    [sym_import] = STATE(1658),
    [sym_parenthesized_expression] = STATE(1020),
    [sym__expression] = STATE(1658),
    [sym_yield_expression] = STATE(1658),
    [sym_object] = STATE(1871),
    [sym_array] = STATE(1873),
    [sym_class] = STATE(1658),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1658),
    [sym_arrow_function] = STATE(1658),
    [sym__call_signature] = STATE(3037),
    [sym_call_expression] = STATE(1658),
    [sym_new_expression] = STATE(1658),
    [sym_await_expression] = STATE(1658),
    [sym_member_expression] = STATE(1020),
    [sym_subscript_expression] = STATE(1020),
    [sym_assignment_expression] = STATE(1658),
    [sym_augmented_assignment_expression] = STATE(1658),
    [sym_ternary_expression] = STATE(1658),
    [sym_binary_expression] = STATE(1658),
    [sym_unary_expression] = STATE(1658),
    [sym_update_expression] = STATE(1658),
    [sym_string] = STATE(1658),
    [sym_template_string] = STATE(1658),
    [sym_regex] = STATE(1658),
    [sym_meta_property] = STATE(1658),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1658),
    [sym_type_assertion] = STATE(1658),
    [sym_as_expression] = STATE(1658),
    [sym_internal_module] = STATE(1658),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_export] = ACTIONS(804),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(806),
    [anon_sym_as] = ACTIONS(445),
    [anon_sym_namespace] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(804),
    [anon_sym_typeof] = ACTIONS(810),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(812),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(814),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(816),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(700),
    [anon_sym_new] = ACTIONS(818),
    [anon_sym_PLUS_EQ] = ACTIONS(820),
    [anon_sym_DASH_EQ] = ACTIONS(820),
    [anon_sym_STAR_EQ] = ACTIONS(820),
    [anon_sym_SLASH_EQ] = ACTIONS(820),
    [anon_sym_PERCENT_EQ] = ACTIONS(820),
    [anon_sym_CARET_EQ] = ACTIONS(820),
    [anon_sym_AMP_EQ] = ACTIONS(820),
    [anon_sym_PIPE_EQ] = ACTIONS(820),
    [anon_sym_GT_GT_EQ] = ACTIONS(820),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(820),
    [anon_sym_LT_LT_EQ] = ACTIONS(820),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(820),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(822),
    [anon_sym_DASH] = ACTIONS(822),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(824),
    [anon_sym_TILDE] = ACTIONS(826),
    [anon_sym_void] = ACTIONS(828),
    [anon_sym_delete] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(830),
    [anon_sym_DASH_DASH] = ACTIONS(830),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(832),
    [sym_this] = ACTIONS(834),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(834),
    [sym_false] = ACTIONS(834),
    [sym_null] = ACTIONS(834),
    [sym_undefined] = ACTIONS(834),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_get] = ACTIONS(804),
    [anon_sym_set] = ACTIONS(804),
    [anon_sym_declare] = ACTIONS(804),
    [anon_sym_public] = ACTIONS(804),
    [anon_sym_private] = ACTIONS(804),
    [anon_sym_protected] = ACTIONS(804),
    [anon_sym_module] = ACTIONS(804),
    [anon_sym_any] = ACTIONS(804),
    [anon_sym_number] = ACTIONS(804),
    [anon_sym_boolean] = ACTIONS(804),
    [anon_sym_string] = ACTIONS(804),
    [anon_sym_symbol] = ACTIONS(804),
    [sym_readonly] = ACTIONS(804),
  },
  [87] = {
    [sym_import] = STATE(1216),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1216),
    [sym_yield_expression] = STATE(1216),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1216),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1216),
    [sym_arrow_function] = STATE(1216),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1216),
    [sym_new_expression] = STATE(1216),
    [sym_await_expression] = STATE(1216),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1216),
    [sym_augmented_assignment_expression] = STATE(1216),
    [sym_ternary_expression] = STATE(1216),
    [sym_binary_expression] = STATE(1216),
    [sym_unary_expression] = STATE(1216),
    [sym_update_expression] = STATE(1216),
    [sym_sequence_expression] = STATE(3025),
    [sym_string] = STATE(1816),
    [sym_template_string] = STATE(1216),
    [sym_regex] = STATE(1216),
    [sym_meta_property] = STATE(1216),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1216),
    [sym_type_assertion] = STATE(1216),
    [sym_as_expression] = STATE(1216),
    [sym_internal_module] = STATE(1216),
    [sym_nested_type_identifier] = STATE(2028),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym__type] = STATE(2627),
    [sym_constructor_type] = STATE(2627),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(343),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2627),
    [sym_intersection_type] = STATE(2627),
    [sym_function_type] = STATE(2627),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [sym_identifier] = ACTIONS(841),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(851),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_RPAREN] = ACTIONS(855),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(861),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(863),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(871),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(873),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(875),
    [sym_this] = ACTIONS(877),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(879),
    [sym_false] = ACTIONS(879),
    [sym_null] = ACTIONS(881),
    [sym_undefined] = ACTIONS(881),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(885),
    [anon_sym_number] = ACTIONS(885),
    [anon_sym_boolean] = ACTIONS(885),
    [anon_sym_string] = ACTIONS(885),
    [anon_sym_symbol] = ACTIONS(885),
    [sym_readonly] = ACTIONS(887),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [88] = {
    [sym_import] = STATE(1158),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1158),
    [sym_yield_expression] = STATE(1158),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1158),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1158),
    [sym_arrow_function] = STATE(1158),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1158),
    [sym_new_expression] = STATE(1158),
    [sym_await_expression] = STATE(1158),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1158),
    [sym_augmented_assignment_expression] = STATE(1158),
    [sym_ternary_expression] = STATE(1158),
    [sym_binary_expression] = STATE(1158),
    [sym_unary_expression] = STATE(1158),
    [sym_update_expression] = STATE(1158),
    [sym_sequence_expression] = STATE(3133),
    [sym_string] = STATE(1816),
    [sym_template_string] = STATE(1158),
    [sym_regex] = STATE(1158),
    [sym_meta_property] = STATE(1158),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1158),
    [sym_type_assertion] = STATE(1158),
    [sym_as_expression] = STATE(1158),
    [sym_internal_module] = STATE(1158),
    [sym_nested_type_identifier] = STATE(2028),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym__type] = STATE(2643),
    [sym_constructor_type] = STATE(2643),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(343),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2643),
    [sym_intersection_type] = STATE(2643),
    [sym_function_type] = STATE(2643),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [sym_identifier] = ACTIONS(841),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(851),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_RPAREN] = ACTIONS(855),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(861),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(863),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(871),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(873),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(875),
    [sym_this] = ACTIONS(877),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(879),
    [sym_false] = ACTIONS(879),
    [sym_null] = ACTIONS(893),
    [sym_undefined] = ACTIONS(893),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(885),
    [anon_sym_number] = ACTIONS(885),
    [anon_sym_boolean] = ACTIONS(885),
    [anon_sym_string] = ACTIONS(885),
    [anon_sym_symbol] = ACTIONS(885),
    [sym_readonly] = ACTIONS(887),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [89] = {
    [sym_import] = STATE(1216),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1216),
    [sym_yield_expression] = STATE(1216),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1216),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1216),
    [sym_arrow_function] = STATE(1216),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1216),
    [sym_new_expression] = STATE(1216),
    [sym_await_expression] = STATE(1216),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1216),
    [sym_augmented_assignment_expression] = STATE(1216),
    [sym_ternary_expression] = STATE(1216),
    [sym_binary_expression] = STATE(1216),
    [sym_unary_expression] = STATE(1216),
    [sym_update_expression] = STATE(1216),
    [sym_sequence_expression] = STATE(3025),
    [sym_string] = STATE(1816),
    [sym_template_string] = STATE(1216),
    [sym_regex] = STATE(1216),
    [sym_meta_property] = STATE(1216),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1216),
    [sym_type_assertion] = STATE(1216),
    [sym_as_expression] = STATE(1216),
    [sym_internal_module] = STATE(1216),
    [sym_nested_type_identifier] = STATE(2028),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym__type] = STATE(2643),
    [sym_constructor_type] = STATE(2643),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(343),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2643),
    [sym_intersection_type] = STATE(2643),
    [sym_function_type] = STATE(2643),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [sym_identifier] = ACTIONS(841),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(851),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_RPAREN] = ACTIONS(855),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(861),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(863),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(871),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(873),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(875),
    [sym_this] = ACTIONS(877),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(879),
    [sym_false] = ACTIONS(879),
    [sym_null] = ACTIONS(881),
    [sym_undefined] = ACTIONS(881),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(885),
    [anon_sym_number] = ACTIONS(885),
    [anon_sym_boolean] = ACTIONS(885),
    [anon_sym_string] = ACTIONS(885),
    [anon_sym_symbol] = ACTIONS(885),
    [sym_readonly] = ACTIONS(887),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [90] = {
    [sym_import] = STATE(1161),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1161),
    [sym_yield_expression] = STATE(1161),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1161),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1161),
    [sym_arrow_function] = STATE(1161),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1161),
    [sym_new_expression] = STATE(1161),
    [sym_await_expression] = STATE(1161),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1161),
    [sym_augmented_assignment_expression] = STATE(1161),
    [sym_ternary_expression] = STATE(1161),
    [sym_binary_expression] = STATE(1161),
    [sym_unary_expression] = STATE(1161),
    [sym_update_expression] = STATE(1161),
    [sym_sequence_expression] = STATE(3085),
    [sym_string] = STATE(1816),
    [sym_template_string] = STATE(1161),
    [sym_regex] = STATE(1161),
    [sym_meta_property] = STATE(1161),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1161),
    [sym_type_assertion] = STATE(1161),
    [sym_as_expression] = STATE(1161),
    [sym_internal_module] = STATE(1161),
    [sym_nested_type_identifier] = STATE(2028),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym__type] = STATE(2643),
    [sym_constructor_type] = STATE(2643),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(343),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2643),
    [sym_intersection_type] = STATE(2643),
    [sym_function_type] = STATE(2643),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [sym_identifier] = ACTIONS(841),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(851),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_RPAREN] = ACTIONS(855),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(861),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(863),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(871),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(873),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(875),
    [sym_this] = ACTIONS(877),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(879),
    [sym_false] = ACTIONS(879),
    [sym_null] = ACTIONS(895),
    [sym_undefined] = ACTIONS(895),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(885),
    [anon_sym_number] = ACTIONS(885),
    [anon_sym_boolean] = ACTIONS(885),
    [anon_sym_string] = ACTIONS(885),
    [anon_sym_symbol] = ACTIONS(885),
    [sym_readonly] = ACTIONS(887),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [91] = {
    [sym_import] = STATE(1348),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1348),
    [sym_yield_expression] = STATE(1348),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1348),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1348),
    [sym_arrow_function] = STATE(1348),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1348),
    [sym_new_expression] = STATE(1348),
    [sym_await_expression] = STATE(1348),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1348),
    [sym_augmented_assignment_expression] = STATE(1348),
    [sym_spread_element] = STATE(2756),
    [sym_ternary_expression] = STATE(1348),
    [sym_binary_expression] = STATE(1348),
    [sym_unary_expression] = STATE(1348),
    [sym_update_expression] = STATE(1348),
    [sym_string] = STATE(1867),
    [sym_template_string] = STATE(1348),
    [sym_regex] = STATE(1348),
    [sym_meta_property] = STATE(1348),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1348),
    [sym_type_assertion] = STATE(1348),
    [sym_as_expression] = STATE(1348),
    [sym_internal_module] = STATE(1348),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2472),
    [sym_constructor_type] = STATE(2472),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2472),
    [sym_intersection_type] = STATE(2472),
    [sym_function_type] = STATE(2472),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [aux_sym_array_repeat1] = STATE(2755),
    [sym_identifier] = ACTIONS(897),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(899),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(903),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_RBRACK] = ACTIONS(905),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(907),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(909),
    [anon_sym_DASH] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(911),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(913),
    [sym_this] = ACTIONS(915),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(917),
    [sym_false] = ACTIONS(917),
    [sym_null] = ACTIONS(919),
    [sym_undefined] = ACTIONS(919),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(921),
    [anon_sym_number] = ACTIONS(921),
    [anon_sym_boolean] = ACTIONS(921),
    [anon_sym_string] = ACTIONS(921),
    [anon_sym_symbol] = ACTIONS(921),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [92] = {
    [sym_import] = STATE(1361),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1361),
    [sym_yield_expression] = STATE(1361),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1361),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1361),
    [sym_arrow_function] = STATE(1361),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1361),
    [sym_new_expression] = STATE(1361),
    [sym_await_expression] = STATE(1361),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1361),
    [sym_augmented_assignment_expression] = STATE(1361),
    [sym_spread_element] = STATE(2618),
    [sym_ternary_expression] = STATE(1361),
    [sym_binary_expression] = STATE(1361),
    [sym_unary_expression] = STATE(1361),
    [sym_update_expression] = STATE(1361),
    [sym_string] = STATE(1867),
    [sym_template_string] = STATE(1361),
    [sym_regex] = STATE(1361),
    [sym_meta_property] = STATE(1361),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1361),
    [sym_type_assertion] = STATE(1361),
    [sym_as_expression] = STATE(1361),
    [sym_internal_module] = STATE(1361),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2472),
    [sym_constructor_type] = STATE(2472),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2472),
    [sym_intersection_type] = STATE(2472),
    [sym_function_type] = STATE(2472),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [aux_sym_array_repeat1] = STATE(2619),
    [sym_identifier] = ACTIONS(897),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(899),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(903),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_RBRACK] = ACTIONS(923),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(907),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(909),
    [anon_sym_DASH] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(911),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(913),
    [sym_this] = ACTIONS(915),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(917),
    [sym_false] = ACTIONS(917),
    [sym_null] = ACTIONS(925),
    [sym_undefined] = ACTIONS(925),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(921),
    [anon_sym_number] = ACTIONS(921),
    [anon_sym_boolean] = ACTIONS(921),
    [anon_sym_string] = ACTIONS(921),
    [anon_sym_symbol] = ACTIONS(921),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [93] = {
    [sym_import] = STATE(1353),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1353),
    [sym_yield_expression] = STATE(1353),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1353),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1353),
    [sym_arrow_function] = STATE(1353),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1353),
    [sym_new_expression] = STATE(1353),
    [sym_await_expression] = STATE(1353),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1353),
    [sym_augmented_assignment_expression] = STATE(1353),
    [sym_spread_element] = STATE(2669),
    [sym_ternary_expression] = STATE(1353),
    [sym_binary_expression] = STATE(1353),
    [sym_unary_expression] = STATE(1353),
    [sym_update_expression] = STATE(1353),
    [sym_string] = STATE(1867),
    [sym_template_string] = STATE(1353),
    [sym_regex] = STATE(1353),
    [sym_meta_property] = STATE(1353),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1353),
    [sym_type_assertion] = STATE(1353),
    [sym_as_expression] = STATE(1353),
    [sym_internal_module] = STATE(1353),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2454),
    [sym_constructor_type] = STATE(2454),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2454),
    [sym_intersection_type] = STATE(2454),
    [sym_function_type] = STATE(2454),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [aux_sym_array_repeat1] = STATE(2667),
    [sym_identifier] = ACTIONS(897),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(899),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(903),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_RBRACK] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(907),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(909),
    [anon_sym_DASH] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(911),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(913),
    [sym_this] = ACTIONS(915),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(917),
    [sym_false] = ACTIONS(917),
    [sym_null] = ACTIONS(929),
    [sym_undefined] = ACTIONS(929),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(921),
    [anon_sym_number] = ACTIONS(921),
    [anon_sym_boolean] = ACTIONS(921),
    [anon_sym_string] = ACTIONS(921),
    [anon_sym_symbol] = ACTIONS(921),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [94] = {
    [sym_import] = STATE(1368),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1368),
    [sym_yield_expression] = STATE(1368),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1368),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1368),
    [sym_arrow_function] = STATE(1368),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1368),
    [sym_new_expression] = STATE(1368),
    [sym_await_expression] = STATE(1368),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1368),
    [sym_augmented_assignment_expression] = STATE(1368),
    [sym_spread_element] = STATE(2731),
    [sym_ternary_expression] = STATE(1368),
    [sym_binary_expression] = STATE(1368),
    [sym_unary_expression] = STATE(1368),
    [sym_update_expression] = STATE(1368),
    [sym_string] = STATE(1867),
    [sym_template_string] = STATE(1368),
    [sym_regex] = STATE(1368),
    [sym_meta_property] = STATE(1368),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1368),
    [sym_type_assertion] = STATE(1368),
    [sym_as_expression] = STATE(1368),
    [sym_internal_module] = STATE(1368),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2472),
    [sym_constructor_type] = STATE(2472),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2472),
    [sym_intersection_type] = STATE(2472),
    [sym_function_type] = STATE(2472),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [aux_sym_array_repeat1] = STATE(2732),
    [sym_identifier] = ACTIONS(897),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(899),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(903),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_RBRACK] = ACTIONS(931),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(907),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(909),
    [anon_sym_DASH] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(911),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(913),
    [sym_this] = ACTIONS(915),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(917),
    [sym_false] = ACTIONS(917),
    [sym_null] = ACTIONS(933),
    [sym_undefined] = ACTIONS(933),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(921),
    [anon_sym_number] = ACTIONS(921),
    [anon_sym_boolean] = ACTIONS(921),
    [anon_sym_string] = ACTIONS(921),
    [anon_sym_symbol] = ACTIONS(921),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [95] = {
    [sym_import] = STATE(1353),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1353),
    [sym_yield_expression] = STATE(1353),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1353),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1353),
    [sym_arrow_function] = STATE(1353),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1353),
    [sym_new_expression] = STATE(1353),
    [sym_await_expression] = STATE(1353),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1353),
    [sym_augmented_assignment_expression] = STATE(1353),
    [sym_spread_element] = STATE(2669),
    [sym_ternary_expression] = STATE(1353),
    [sym_binary_expression] = STATE(1353),
    [sym_unary_expression] = STATE(1353),
    [sym_update_expression] = STATE(1353),
    [sym_string] = STATE(1867),
    [sym_template_string] = STATE(1353),
    [sym_regex] = STATE(1353),
    [sym_meta_property] = STATE(1353),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1353),
    [sym_type_assertion] = STATE(1353),
    [sym_as_expression] = STATE(1353),
    [sym_internal_module] = STATE(1353),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2472),
    [sym_constructor_type] = STATE(2472),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2472),
    [sym_intersection_type] = STATE(2472),
    [sym_function_type] = STATE(2472),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [aux_sym_array_repeat1] = STATE(2667),
    [sym_identifier] = ACTIONS(897),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(899),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(903),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_RBRACK] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(907),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(127),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(909),
    [anon_sym_DASH] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(911),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(913),
    [sym_this] = ACTIONS(915),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(917),
    [sym_false] = ACTIONS(917),
    [sym_null] = ACTIONS(929),
    [sym_undefined] = ACTIONS(929),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(921),
    [anon_sym_number] = ACTIONS(921),
    [anon_sym_boolean] = ACTIONS(921),
    [anon_sym_string] = ACTIONS(921),
    [anon_sym_symbol] = ACTIONS(921),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [96] = {
    [sym_import] = STATE(1051),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1051),
    [sym_yield_expression] = STATE(1051),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1051),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1051),
    [sym_arrow_function] = STATE(1051),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1051),
    [sym_new_expression] = STATE(1051),
    [sym_await_expression] = STATE(1051),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1051),
    [sym_augmented_assignment_expression] = STATE(1051),
    [sym_ternary_expression] = STATE(1051),
    [sym_binary_expression] = STATE(1051),
    [sym_unary_expression] = STATE(1051),
    [sym_update_expression] = STATE(1051),
    [sym_string] = STATE(1051),
    [sym_template_string] = STATE(1051),
    [sym_regex] = STATE(1051),
    [sym_meta_property] = STATE(1051),
    [sym_arguments] = STATE(1099),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1051),
    [sym_type_assertion] = STATE(1051),
    [sym_as_expression] = STATE(1051),
    [sym_internal_module] = STATE(1051),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(935),
    [anon_sym_as] = ACTIONS(935),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(937),
    [anon_sym_RBRACE] = ACTIONS(937),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(939),
    [anon_sym_RPAREN] = ACTIONS(937),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(935),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(937),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(935),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(935),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(935),
    [anon_sym_AMP_AMP] = ACTIONS(937),
    [anon_sym_PIPE_PIPE] = ACTIONS(937),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_GT_GT_GT] = ACTIONS(937),
    [anon_sym_LT_LT] = ACTIONS(937),
    [anon_sym_AMP] = ACTIONS(935),
    [anon_sym_CARET] = ACTIONS(937),
    [anon_sym_PIPE] = ACTIONS(935),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(937),
    [anon_sym_STAR_STAR] = ACTIONS(937),
    [anon_sym_LT_EQ] = ACTIONS(937),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(935),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(937),
    [anon_sym_GT_EQ] = ACTIONS(937),
    [anon_sym_QMARK_QMARK] = ACTIONS(937),
    [anon_sym_instanceof] = ACTIONS(935),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(941),
    [sym_this] = ACTIONS(943),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_undefined] = ACTIONS(943),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [anon_sym_implements] = ACTIONS(935),
    [sym_readonly] = ACTIONS(493),
  },
  [97] = {
    [sym_import] = STATE(1051),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1051),
    [sym_yield_expression] = STATE(1051),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1051),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1051),
    [sym_arrow_function] = STATE(1051),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1051),
    [sym_new_expression] = STATE(1051),
    [sym_await_expression] = STATE(1051),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1051),
    [sym_augmented_assignment_expression] = STATE(1051),
    [sym_ternary_expression] = STATE(1051),
    [sym_binary_expression] = STATE(1051),
    [sym_unary_expression] = STATE(1051),
    [sym_update_expression] = STATE(1051),
    [sym_string] = STATE(1051),
    [sym_template_string] = STATE(1051),
    [sym_regex] = STATE(1051),
    [sym_meta_property] = STATE(1051),
    [sym_arguments] = STATE(1578),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1051),
    [sym_type_assertion] = STATE(1051),
    [sym_as_expression] = STATE(1051),
    [sym_internal_module] = STATE(1051),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(935),
    [anon_sym_as] = ACTIONS(935),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(937),
    [anon_sym_RBRACE] = ACTIONS(937),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(945),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(935),
    [anon_sym_SEMI] = ACTIONS(937),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(935),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(935),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(935),
    [anon_sym_AMP_AMP] = ACTIONS(937),
    [anon_sym_PIPE_PIPE] = ACTIONS(937),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_GT_GT_GT] = ACTIONS(937),
    [anon_sym_LT_LT] = ACTIONS(937),
    [anon_sym_AMP] = ACTIONS(935),
    [anon_sym_CARET] = ACTIONS(937),
    [anon_sym_PIPE] = ACTIONS(935),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(937),
    [anon_sym_STAR_STAR] = ACTIONS(937),
    [anon_sym_LT_EQ] = ACTIONS(937),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(935),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(937),
    [anon_sym_GT_EQ] = ACTIONS(937),
    [anon_sym_QMARK_QMARK] = ACTIONS(937),
    [anon_sym_instanceof] = ACTIONS(935),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(941),
    [sym_this] = ACTIONS(943),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_undefined] = ACTIONS(943),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
    [sym__automatic_semicolon] = ACTIONS(937),
  },
  [98] = {
    [sym_import] = STATE(1313),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1313),
    [sym_yield_expression] = STATE(1313),
    [sym_object] = STATE(1649),
    [sym_array] = STATE(1630),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1313),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1313),
    [sym_arrow_function] = STATE(1313),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1313),
    [sym_new_expression] = STATE(1313),
    [sym_await_expression] = STATE(1313),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1313),
    [sym_augmented_assignment_expression] = STATE(1313),
    [sym_ternary_expression] = STATE(1313),
    [sym_binary_expression] = STATE(1313),
    [sym_unary_expression] = STATE(1313),
    [sym_update_expression] = STATE(1313),
    [sym_string] = STATE(1128),
    [sym_template_string] = STATE(1313),
    [sym_regex] = STATE(1313),
    [sym_meta_property] = STATE(1313),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1313),
    [sym_type_assertion] = STATE(1313),
    [sym_as_expression] = STATE(1313),
    [sym_internal_module] = STATE(1313),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(343),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(949),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(951),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(861),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(953),
    [anon_sym_DASH] = ACTIONS(953),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(955),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(957),
    [sym_this] = ACTIONS(959),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(961),
    [sym_false] = ACTIONS(961),
    [sym_null] = ACTIONS(963),
    [sym_undefined] = ACTIONS(963),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(965),
    [anon_sym_number] = ACTIONS(965),
    [anon_sym_boolean] = ACTIONS(965),
    [anon_sym_string] = ACTIONS(965),
    [anon_sym_symbol] = ACTIONS(965),
    [sym_readonly] = ACTIONS(610),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [99] = {
    [sym_import] = STATE(1504),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1504),
    [sym_yield_expression] = STATE(1504),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3121),
    [sym_class] = STATE(1504),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1504),
    [sym_arrow_function] = STATE(1504),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1504),
    [sym_new_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1504),
    [sym_augmented_assignment_expression] = STATE(1504),
    [sym_ternary_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_update_expression] = STATE(1504),
    [sym_string] = STATE(1423),
    [sym_template_string] = STATE(1504),
    [sym_regex] = STATE(1504),
    [sym_meta_property] = STATE(1504),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2648),
    [sym_non_null_expression] = STATE(1504),
    [sym_type_assertion] = STATE(1504),
    [sym_as_expression] = STATE(1504),
    [sym_internal_module] = STATE(1504),
    [sym_nested_type_identifier] = STATE(2055),
    [sym__type] = STATE(2130),
    [sym_constructor_type] = STATE(2130),
    [sym__primary_type] = STATE(2106),
    [sym_generic_type] = STATE(2106),
    [sym_type_predicate] = STATE(2106),
    [sym_type_query] = STATE(2106),
    [sym_index_type_query] = STATE(2106),
    [sym_lookup_type] = STATE(2106),
    [sym_literal_type] = STATE(2106),
    [sym__number] = STATE(2108),
    [sym_existential_type] = STATE(2106),
    [sym_flow_maybe_type] = STATE(2106),
    [sym_parenthesized_type] = STATE(2106),
    [sym_predefined_type] = STATE(2106),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(2106),
    [sym_type_parameters] = STATE(2888),
    [sym_array_type] = STATE(2106),
    [sym_tuple_type] = STATE(2106),
    [sym_union_type] = STATE(2130),
    [sym_intersection_type] = STATE(2130),
    [sym_function_type] = STATE(2130),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(967),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(969),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(971),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(973),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(975),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(977),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(979),
    [anon_sym_QMARK] = ACTIONS(981),
    [anon_sym_AMP] = ACTIONS(983),
    [anon_sym_PIPE] = ACTIONS(985),
    [anon_sym_PLUS] = ACTIONS(987),
    [anon_sym_DASH] = ACTIONS(987),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(989),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(991),
    [sym_this] = ACTIONS(993),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(995),
    [sym_false] = ACTIONS(995),
    [sym_null] = ACTIONS(997),
    [sym_undefined] = ACTIONS(997),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(999),
    [anon_sym_number] = ACTIONS(999),
    [anon_sym_boolean] = ACTIONS(999),
    [anon_sym_string] = ACTIONS(999),
    [anon_sym_symbol] = ACTIONS(999),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(1001),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1003),
  },
  [100] = {
    [sym_import] = STATE(1051),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1051),
    [sym_yield_expression] = STATE(1051),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1051),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1051),
    [sym_arrow_function] = STATE(1051),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1051),
    [sym_new_expression] = STATE(1051),
    [sym_await_expression] = STATE(1051),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1051),
    [sym_augmented_assignment_expression] = STATE(1051),
    [sym_ternary_expression] = STATE(1051),
    [sym_binary_expression] = STATE(1051),
    [sym_unary_expression] = STATE(1051),
    [sym_update_expression] = STATE(1051),
    [sym_string] = STATE(1051),
    [sym_template_string] = STATE(1051),
    [sym_regex] = STATE(1051),
    [sym_meta_property] = STATE(1051),
    [sym_arguments] = STATE(1099),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1051),
    [sym_type_assertion] = STATE(1051),
    [sym_as_expression] = STATE(1051),
    [sym_internal_module] = STATE(1051),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(935),
    [anon_sym_as] = ACTIONS(935),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(937),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(1005),
    [anon_sym_RPAREN] = ACTIONS(937),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(935),
    [anon_sym_COLON] = ACTIONS(937),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(935),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(935),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(935),
    [anon_sym_AMP_AMP] = ACTIONS(937),
    [anon_sym_PIPE_PIPE] = ACTIONS(937),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_GT_GT_GT] = ACTIONS(937),
    [anon_sym_LT_LT] = ACTIONS(937),
    [anon_sym_AMP] = ACTIONS(935),
    [anon_sym_CARET] = ACTIONS(937),
    [anon_sym_PIPE] = ACTIONS(935),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(937),
    [anon_sym_STAR_STAR] = ACTIONS(937),
    [anon_sym_LT_EQ] = ACTIONS(937),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(935),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(937),
    [anon_sym_GT_EQ] = ACTIONS(937),
    [anon_sym_QMARK_QMARK] = ACTIONS(937),
    [anon_sym_instanceof] = ACTIONS(935),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(941),
    [sym_this] = ACTIONS(943),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_undefined] = ACTIONS(943),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [101] = {
    [sym_import] = STATE(1213),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1213),
    [sym_yield_expression] = STATE(1213),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1213),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1213),
    [sym_arrow_function] = STATE(1213),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1213),
    [sym_new_expression] = STATE(1213),
    [sym_await_expression] = STATE(1213),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1213),
    [sym_augmented_assignment_expression] = STATE(1213),
    [sym_ternary_expression] = STATE(1213),
    [sym_binary_expression] = STATE(1213),
    [sym_unary_expression] = STATE(1213),
    [sym_update_expression] = STATE(1213),
    [sym_string] = STATE(1579),
    [sym_template_string] = STATE(1213),
    [sym_regex] = STATE(1213),
    [sym_meta_property] = STATE(1213),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1213),
    [sym_type_assertion] = STATE(1213),
    [sym_as_expression] = STATE(1213),
    [sym_internal_module] = STATE(1213),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(391),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(1007),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(1009),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(1011),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(1013),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(1015),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(1017),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1019),
    [anon_sym_DASH] = ACTIONS(1019),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(1021),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(1023),
    [sym_this] = ACTIONS(1025),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(1027),
    [sym_false] = ACTIONS(1027),
    [sym_null] = ACTIONS(1029),
    [sym_undefined] = ACTIONS(1029),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(1031),
    [anon_sym_number] = ACTIONS(1031),
    [anon_sym_boolean] = ACTIONS(1031),
    [anon_sym_string] = ACTIONS(1031),
    [anon_sym_symbol] = ACTIONS(1031),
    [sym_readonly] = ACTIONS(443),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [102] = {
    [sym_import] = STATE(1498),
    [sym_parenthesized_expression] = STATE(1008),
    [sym__expression] = STATE(1498),
    [sym_yield_expression] = STATE(1498),
    [sym_object] = STATE(1721),
    [sym_array] = STATE(1722),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1498),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1498),
    [sym_arrow_function] = STATE(1498),
    [sym__call_signature] = STATE(2996),
    [sym_call_expression] = STATE(1498),
    [sym_new_expression] = STATE(1498),
    [sym_await_expression] = STATE(1498),
    [sym_member_expression] = STATE(1008),
    [sym_subscript_expression] = STATE(1008),
    [sym_assignment_expression] = STATE(1498),
    [sym_augmented_assignment_expression] = STATE(1498),
    [sym_ternary_expression] = STATE(1498),
    [sym_binary_expression] = STATE(1498),
    [sym_unary_expression] = STATE(1498),
    [sym_update_expression] = STATE(1498),
    [sym_string] = STATE(1769),
    [sym_template_string] = STATE(1498),
    [sym_regex] = STATE(1498),
    [sym_meta_property] = STATE(1498),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1498),
    [sym_type_assertion] = STATE(1498),
    [sym_as_expression] = STATE(1498),
    [sym_internal_module] = STATE(1498),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(360),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(1033),
    [anon_sym_export] = ACTIONS(644),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(1009),
    [anon_sym_type] = ACTIONS(644),
    [anon_sym_typeof] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(1013),
    [anon_sym_await] = ACTIONS(652),
    [anon_sym_yield] = ACTIONS(654),
    [anon_sym_LBRACK] = ACTIONS(1015),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(1037),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1039),
    [anon_sym_DASH] = ACTIONS(1039),
    [anon_sym_BANG] = ACTIONS(668),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_void] = ACTIONS(1041),
    [anon_sym_delete] = ACTIONS(650),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(1043),
    [sym_this] = ACTIONS(1045),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(1047),
    [sym_false] = ACTIONS(1047),
    [sym_null] = ACTIONS(1049),
    [sym_undefined] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(644),
    [anon_sym_get] = ACTIONS(644),
    [anon_sym_set] = ACTIONS(644),
    [anon_sym_declare] = ACTIONS(644),
    [anon_sym_public] = ACTIONS(644),
    [anon_sym_private] = ACTIONS(644),
    [anon_sym_protected] = ACTIONS(644),
    [anon_sym_module] = ACTIONS(644),
    [anon_sym_any] = ACTIONS(1051),
    [anon_sym_number] = ACTIONS(1051),
    [anon_sym_boolean] = ACTIONS(1051),
    [anon_sym_string] = ACTIONS(1051),
    [anon_sym_symbol] = ACTIONS(1051),
    [sym_readonly] = ACTIONS(644),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [103] = {
    [sym_import] = STATE(1198),
    [sym_parenthesized_expression] = STATE(946),
    [sym__expression] = STATE(1198),
    [sym_yield_expression] = STATE(1198),
    [sym_object] = STATE(1473),
    [sym_array] = STATE(1455),
    [sym_class] = STATE(1198),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1198),
    [sym_arrow_function] = STATE(1198),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1198),
    [sym_new_expression] = STATE(1198),
    [sym_await_expression] = STATE(1198),
    [sym_member_expression] = STATE(946),
    [sym_subscript_expression] = STATE(946),
    [sym_assignment_expression] = STATE(1198),
    [sym_augmented_assignment_expression] = STATE(1198),
    [sym_ternary_expression] = STATE(1198),
    [sym_binary_expression] = STATE(1198),
    [sym_unary_expression] = STATE(1198),
    [sym_update_expression] = STATE(1198),
    [sym_string] = STATE(1198),
    [sym_template_string] = STATE(1198),
    [sym_regex] = STATE(1198),
    [sym_meta_property] = STATE(1198),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1198),
    [sym_type_assertion] = STATE(1198),
    [sym_as_expression] = STATE(1198),
    [sym_internal_module] = STATE(1198),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(1053),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(1057),
    [anon_sym_RBRACE] = ACTIONS(1057),
    [anon_sym_type] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_SEMI] = ACTIONS(1057),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(1059),
    [sym_this] = ACTIONS(1061),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(1061),
    [sym_false] = ACTIONS(1061),
    [sym_null] = ACTIONS(1061),
    [sym_undefined] = ACTIONS(1061),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(443),
    [anon_sym_get] = ACTIONS(443),
    [anon_sym_set] = ACTIONS(443),
    [anon_sym_declare] = ACTIONS(443),
    [anon_sym_public] = ACTIONS(443),
    [anon_sym_private] = ACTIONS(443),
    [anon_sym_protected] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_any] = ACTIONS(443),
    [anon_sym_number] = ACTIONS(443),
    [anon_sym_boolean] = ACTIONS(443),
    [anon_sym_string] = ACTIONS(443),
    [anon_sym_symbol] = ACTIONS(443),
    [sym_readonly] = ACTIONS(443),
    [sym__automatic_semicolon] = ACTIONS(1057),
  },
  [104] = {
    [sym_import] = STATE(1275),
    [sym_parenthesized_expression] = STATE(975),
    [sym__expression] = STATE(1275),
    [sym_yield_expression] = STATE(1275),
    [sym_object] = STATE(1631),
    [sym_array] = STATE(1632),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1275),
    [sym_function] = STATE(1342),
    [sym_generator_function] = STATE(1275),
    [sym_arrow_function] = STATE(1275),
    [sym__call_signature] = STATE(3044),
    [sym_call_expression] = STATE(1275),
    [sym_new_expression] = STATE(1275),
    [sym_await_expression] = STATE(1275),
    [sym_member_expression] = STATE(975),
    [sym_subscript_expression] = STATE(975),
    [sym_assignment_expression] = STATE(1275),
    [sym_augmented_assignment_expression] = STATE(1275),
    [sym_ternary_expression] = STATE(1275),
    [sym_binary_expression] = STATE(1275),
    [sym_unary_expression] = STATE(1275),
    [sym_update_expression] = STATE(1275),
    [sym_string] = STATE(1751),
    [sym_template_string] = STATE(1275),
    [sym_regex] = STATE(1275),
    [sym_meta_property] = STATE(1275),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1275),
    [sym_type_assertion] = STATE(1275),
    [sym_as_expression] = STATE(1275),
    [sym_internal_module] = STATE(1275),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(412),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2579),
    [sym_identifier] = ACTIONS(1063),
    [anon_sym_export] = ACTIONS(704),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(1065),
    [anon_sym_type] = ACTIONS(704),
    [anon_sym_typeof] = ACTIONS(1067),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(1069),
    [anon_sym_await] = ACTIONS(718),
    [anon_sym_yield] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(1071),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(724),
    [anon_sym_class] = ACTIONS(726),
    [anon_sym_async] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_new] = ACTIONS(1073),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_void] = ACTIONS(1077),
    [anon_sym_delete] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(744),
    [anon_sym_DASH_DASH] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_number] = ACTIONS(1079),
    [sym_this] = ACTIONS(1081),
    [sym_super] = ACTIONS(756),
    [sym_true] = ACTIONS(1083),
    [sym_false] = ACTIONS(1083),
    [sym_null] = ACTIONS(1085),
    [sym_undefined] = ACTIONS(1085),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(704),
    [anon_sym_get] = ACTIONS(704),
    [anon_sym_set] = ACTIONS(704),
    [anon_sym_declare] = ACTIONS(704),
    [anon_sym_public] = ACTIONS(704),
    [anon_sym_private] = ACTIONS(704),
    [anon_sym_protected] = ACTIONS(704),
    [anon_sym_module] = ACTIONS(704),
    [anon_sym_any] = ACTIONS(1087),
    [anon_sym_number] = ACTIONS(1087),
    [anon_sym_boolean] = ACTIONS(1087),
    [anon_sym_string] = ACTIONS(1087),
    [anon_sym_symbol] = ACTIONS(1087),
    [sym_readonly] = ACTIONS(704),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [105] = {
    [sym_import] = STATE(1660),
    [sym_parenthesized_expression] = STATE(1020),
    [sym__expression] = STATE(1660),
    [sym_yield_expression] = STATE(1660),
    [sym_object] = STATE(1871),
    [sym_array] = STATE(1873),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1660),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1660),
    [sym_arrow_function] = STATE(1660),
    [sym__call_signature] = STATE(3037),
    [sym_call_expression] = STATE(1660),
    [sym_new_expression] = STATE(1660),
    [sym_await_expression] = STATE(1660),
    [sym_member_expression] = STATE(1020),
    [sym_subscript_expression] = STATE(1020),
    [sym_assignment_expression] = STATE(1660),
    [sym_augmented_assignment_expression] = STATE(1660),
    [sym_ternary_expression] = STATE(1660),
    [sym_binary_expression] = STATE(1660),
    [sym_unary_expression] = STATE(1660),
    [sym_update_expression] = STATE(1660),
    [sym_string] = STATE(1714),
    [sym_template_string] = STATE(1660),
    [sym_regex] = STATE(1660),
    [sym_meta_property] = STATE(1660),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1660),
    [sym_type_assertion] = STATE(1660),
    [sym_as_expression] = STATE(1660),
    [sym_internal_module] = STATE(1660),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(427),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(1089),
    [anon_sym_export] = ACTIONS(804),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(949),
    [anon_sym_type] = ACTIONS(804),
    [anon_sym_typeof] = ACTIONS(1091),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(812),
    [anon_sym_yield] = ACTIONS(814),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(816),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(1093),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1095),
    [anon_sym_DASH] = ACTIONS(1095),
    [anon_sym_BANG] = ACTIONS(826),
    [anon_sym_TILDE] = ACTIONS(826),
    [anon_sym_void] = ACTIONS(1097),
    [anon_sym_delete] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(830),
    [anon_sym_DASH_DASH] = ACTIONS(830),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1099),
    [sym_this] = ACTIONS(1101),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1103),
    [sym_false] = ACTIONS(1103),
    [sym_null] = ACTIONS(1105),
    [sym_undefined] = ACTIONS(1105),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_get] = ACTIONS(804),
    [anon_sym_set] = ACTIONS(804),
    [anon_sym_declare] = ACTIONS(804),
    [anon_sym_public] = ACTIONS(804),
    [anon_sym_private] = ACTIONS(804),
    [anon_sym_protected] = ACTIONS(804),
    [anon_sym_module] = ACTIONS(804),
    [anon_sym_any] = ACTIONS(1107),
    [anon_sym_number] = ACTIONS(1107),
    [anon_sym_boolean] = ACTIONS(1107),
    [anon_sym_string] = ACTIONS(1107),
    [anon_sym_symbol] = ACTIONS(1107),
    [sym_readonly] = ACTIONS(804),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [106] = {
    [sym_import] = STATE(1684),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1684),
    [sym_yield_expression] = STATE(1684),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1684),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1684),
    [sym_arrow_function] = STATE(1684),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1684),
    [sym_new_expression] = STATE(1684),
    [sym_await_expression] = STATE(1684),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1684),
    [sym_augmented_assignment_expression] = STATE(1684),
    [sym_ternary_expression] = STATE(1684),
    [sym_binary_expression] = STATE(1684),
    [sym_unary_expression] = STATE(1684),
    [sym_update_expression] = STATE(1684),
    [sym_string] = STATE(1714),
    [sym_template_string] = STATE(1684),
    [sym_regex] = STATE(1684),
    [sym_meta_property] = STATE(1684),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1684),
    [sym_type_assertion] = STATE(1684),
    [sym_as_expression] = STATE(1684),
    [sym_internal_module] = STATE(1684),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(329),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(1109),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(949),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(1111),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(1113),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1115),
    [anon_sym_DASH] = ACTIONS(1115),
    [anon_sym_BANG] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(1117),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1099),
    [sym_this] = ACTIONS(1101),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1103),
    [sym_false] = ACTIONS(1103),
    [sym_null] = ACTIONS(1119),
    [sym_undefined] = ACTIONS(1119),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(1121),
    [anon_sym_number] = ACTIONS(1121),
    [anon_sym_boolean] = ACTIONS(1121),
    [anon_sym_string] = ACTIONS(1121),
    [anon_sym_symbol] = ACTIONS(1121),
    [sym_readonly] = ACTIONS(493),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [107] = {
    [sym_import] = STATE(1204),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1204),
    [sym_yield_expression] = STATE(1204),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1204),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1204),
    [sym_arrow_function] = STATE(1204),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1204),
    [sym_new_expression] = STATE(1204),
    [sym_await_expression] = STATE(1204),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1204),
    [sym_augmented_assignment_expression] = STATE(1204),
    [sym_ternary_expression] = STATE(1204),
    [sym_binary_expression] = STATE(1204),
    [sym_unary_expression] = STATE(1204),
    [sym_update_expression] = STATE(1204),
    [sym_string] = STATE(1128),
    [sym_template_string] = STATE(1204),
    [sym_regex] = STATE(1204),
    [sym_meta_property] = STATE(1204),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1204),
    [sym_as_expression] = STATE(1204),
    [sym_internal_module] = STATE(1204),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(493),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(1123),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(949),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(1125),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(907),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1127),
    [anon_sym_DASH] = ACTIONS(1127),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(1129),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(957),
    [sym_this] = ACTIONS(959),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(961),
    [sym_false] = ACTIONS(961),
    [sym_null] = ACTIONS(1131),
    [sym_undefined] = ACTIONS(1131),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(1133),
    [anon_sym_number] = ACTIONS(1133),
    [anon_sym_boolean] = ACTIONS(1133),
    [anon_sym_string] = ACTIONS(1133),
    [anon_sym_symbol] = ACTIONS(1133),
    [sym_readonly] = ACTIONS(543),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [108] = {
    [sym_import] = STATE(1291),
    [sym_parenthesized_expression] = STATE(983),
    [sym__expression] = STATE(1291),
    [sym_yield_expression] = STATE(1291),
    [sym_object] = STATE(1672),
    [sym_array] = STATE(1671),
    [sym_nested_identifier] = STATE(3104),
    [sym_class] = STATE(1291),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1291),
    [sym_arrow_function] = STATE(1291),
    [sym__call_signature] = STATE(3144),
    [sym_call_expression] = STATE(1291),
    [sym_new_expression] = STATE(1291),
    [sym_await_expression] = STATE(1291),
    [sym_member_expression] = STATE(983),
    [sym_subscript_expression] = STATE(983),
    [sym_assignment_expression] = STATE(1291),
    [sym_augmented_assignment_expression] = STATE(1291),
    [sym_ternary_expression] = STATE(1291),
    [sym_binary_expression] = STATE(1291),
    [sym_unary_expression] = STATE(1291),
    [sym_update_expression] = STATE(1291),
    [sym_string] = STATE(1128),
    [sym_template_string] = STATE(1291),
    [sym_regex] = STATE(1291),
    [sym_meta_property] = STATE(1291),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2728),
    [sym_non_null_expression] = STATE(1291),
    [sym_type_assertion] = STATE(1291),
    [sym_as_expression] = STATE(1291),
    [sym_internal_module] = STATE(1291),
    [sym_nested_type_identifier] = STATE(2028),
    [sym__type] = STATE(2342),
    [sym_constructor_type] = STATE(2342),
    [sym__primary_type] = STATE(519),
    [sym_generic_type] = STATE(519),
    [sym_type_predicate] = STATE(519),
    [sym_type_query] = STATE(519),
    [sym_index_type_query] = STATE(519),
    [sym_lookup_type] = STATE(519),
    [sym_literal_type] = STATE(519),
    [sym__number] = STATE(525),
    [sym_existential_type] = STATE(519),
    [sym_flow_maybe_type] = STATE(519),
    [sym_parenthesized_type] = STATE(519),
    [sym_predefined_type] = STATE(519),
    [sym_type_arguments] = STATE(390),
    [sym_object_type] = STATE(519),
    [sym_type_parameters] = STATE(2827),
    [sym_array_type] = STATE(519),
    [sym_tuple_type] = STATE(519),
    [sym_union_type] = STATE(2342),
    [sym_intersection_type] = STATE(2342),
    [sym_function_type] = STATE(2342),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(1135),
    [anon_sym_export] = ACTIONS(768),
    [anon_sym_STAR] = ACTIONS(845),
    [anon_sym_namespace] = ACTIONS(772),
    [anon_sym_LBRACE] = ACTIONS(949),
    [anon_sym_type] = ACTIONS(768),
    [anon_sym_typeof] = ACTIONS(1137),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_await] = ACTIONS(776),
    [anon_sym_yield] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(780),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(782),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(1139),
    [anon_sym_QMARK] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_PLUS] = ACTIONS(1141),
    [anon_sym_DASH] = ACTIONS(1141),
    [anon_sym_BANG] = ACTIONS(792),
    [anon_sym_TILDE] = ACTIONS(792),
    [anon_sym_void] = ACTIONS(1143),
    [anon_sym_delete] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(796),
    [anon_sym_DASH_DASH] = ACTIONS(796),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(957),
    [sym_this] = ACTIONS(959),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(961),
    [sym_false] = ACTIONS(961),
    [sym_null] = ACTIONS(1145),
    [sym_undefined] = ACTIONS(1145),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_get] = ACTIONS(768),
    [anon_sym_set] = ACTIONS(768),
    [anon_sym_declare] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_any] = ACTIONS(1147),
    [anon_sym_number] = ACTIONS(1147),
    [anon_sym_boolean] = ACTIONS(1147),
    [anon_sym_string] = ACTIONS(1147),
    [anon_sym_symbol] = ACTIONS(1147),
    [sym_readonly] = ACTIONS(768),
    [anon_sym_keyof] = ACTIONS(889),
    [anon_sym_LBRACE_PIPE] = ACTIONS(891),
  },
  [109] = {
    [sym_import] = STATE(1237),
    [sym_parenthesized_expression] = STATE(972),
    [sym__expression] = STATE(1237),
    [sym_yield_expression] = STATE(1237),
    [sym_object] = STATE(1494),
    [sym_array] = STATE(1459),
    [sym_class] = STATE(1237),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1237),
    [sym_arrow_function] = STATE(1237),
    [sym__call_signature] = STATE(3190),
    [sym_call_expression] = STATE(1237),
    [sym_new_expression] = STATE(1237),
    [sym_await_expression] = STATE(1237),
    [sym_member_expression] = STATE(972),
    [sym_subscript_expression] = STATE(972),
    [sym_assignment_expression] = STATE(1237),
    [sym_augmented_assignment_expression] = STATE(1237),
    [sym_ternary_expression] = STATE(1237),
    [sym_binary_expression] = STATE(1237),
    [sym_unary_expression] = STATE(1237),
    [sym_update_expression] = STATE(1237),
    [sym_string] = STATE(1237),
    [sym_template_string] = STATE(1237),
    [sym_regex] = STATE(1237),
    [sym_meta_property] = STATE(1237),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1237),
    [sym_type_assertion] = STATE(1237),
    [sym_as_expression] = STATE(1237),
    [sym_internal_module] = STATE(1237),
    [sym_type_arguments] = STATE(493),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(1149),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(1057),
    [anon_sym_RBRACE] = ACTIONS(1057),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(1057),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1151),
    [sym_this] = ACTIONS(1153),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1153),
    [sym_false] = ACTIONS(1153),
    [sym_null] = ACTIONS(1153),
    [sym_undefined] = ACTIONS(1153),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [anon_sym_declare] = ACTIONS(543),
    [anon_sym_public] = ACTIONS(543),
    [anon_sym_private] = ACTIONS(543),
    [anon_sym_protected] = ACTIONS(543),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_any] = ACTIONS(543),
    [anon_sym_number] = ACTIONS(543),
    [anon_sym_boolean] = ACTIONS(543),
    [anon_sym_string] = ACTIONS(543),
    [anon_sym_symbol] = ACTIONS(543),
    [sym_readonly] = ACTIONS(543),
  },
  [110] = {
    [sym_import] = STATE(1051),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1051),
    [sym_yield_expression] = STATE(1051),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1051),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1051),
    [sym_arrow_function] = STATE(1051),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1051),
    [sym_new_expression] = STATE(1051),
    [sym_await_expression] = STATE(1051),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1051),
    [sym_augmented_assignment_expression] = STATE(1051),
    [sym_ternary_expression] = STATE(1051),
    [sym_binary_expression] = STATE(1051),
    [sym_unary_expression] = STATE(1051),
    [sym_update_expression] = STATE(1051),
    [sym_string] = STATE(1051),
    [sym_template_string] = STATE(1051),
    [sym_regex] = STATE(1051),
    [sym_meta_property] = STATE(1051),
    [sym_arguments] = STATE(1810),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1051),
    [sym_type_assertion] = STATE(1051),
    [sym_as_expression] = STATE(1051),
    [sym_internal_module] = STATE(1051),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(935),
    [anon_sym_as] = ACTIONS(935),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(1155),
    [anon_sym_COMMA] = ACTIONS(937),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(935),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(935),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(935),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(935),
    [anon_sym_AMP_AMP] = ACTIONS(937),
    [anon_sym_PIPE_PIPE] = ACTIONS(937),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_GT_GT_GT] = ACTIONS(937),
    [anon_sym_LT_LT] = ACTIONS(937),
    [anon_sym_AMP] = ACTIONS(935),
    [anon_sym_CARET] = ACTIONS(937),
    [anon_sym_PIPE] = ACTIONS(935),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(937),
    [anon_sym_STAR_STAR] = ACTIONS(937),
    [anon_sym_LT_EQ] = ACTIONS(937),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(935),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(937),
    [anon_sym_GT_EQ] = ACTIONS(937),
    [anon_sym_QMARK_QMARK] = ACTIONS(937),
    [anon_sym_instanceof] = ACTIONS(935),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(941),
    [sym_this] = ACTIONS(943),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_undefined] = ACTIONS(943),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
    [anon_sym_LBRACE_PIPE] = ACTIONS(937),
  },
  [111] = {
    [sym_import] = STATE(1302),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1302),
    [sym_yield_expression] = STATE(1302),
    [sym_object] = STATE(1649),
    [sym_array] = STATE(1630),
    [sym_class] = STATE(1302),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1302),
    [sym_arrow_function] = STATE(1302),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1302),
    [sym_new_expression] = STATE(1302),
    [sym_await_expression] = STATE(1302),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1302),
    [sym_augmented_assignment_expression] = STATE(1302),
    [sym_ternary_expression] = STATE(1302),
    [sym_binary_expression] = STATE(1302),
    [sym_unary_expression] = STATE(1302),
    [sym_update_expression] = STATE(1302),
    [sym_string] = STATE(1302),
    [sym_template_string] = STATE(1302),
    [sym_regex] = STATE(1302),
    [sym_meta_property] = STATE(1302),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1302),
    [sym_type_assertion] = STATE(1302),
    [sym_as_expression] = STATE(1302),
    [sym_internal_module] = STATE(1302),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(608),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(1159),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(1057),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(1057),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_COLON] = ACTIONS(1057),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(634),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1161),
    [sym_this] = ACTIONS(1163),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1163),
    [sym_false] = ACTIONS(1163),
    [sym_null] = ACTIONS(1163),
    [sym_undefined] = ACTIONS(1163),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(610),
    [anon_sym_number] = ACTIONS(610),
    [anon_sym_boolean] = ACTIONS(610),
    [anon_sym_string] = ACTIONS(610),
    [anon_sym_symbol] = ACTIONS(610),
    [sym_readonly] = ACTIONS(610),
  },
  [112] = {
    [sym_import] = STATE(1508),
    [sym_parenthesized_expression] = STATE(1008),
    [sym__expression] = STATE(1508),
    [sym_yield_expression] = STATE(1508),
    [sym_object] = STATE(1721),
    [sym_array] = STATE(1722),
    [sym_class] = STATE(1508),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1508),
    [sym_arrow_function] = STATE(1508),
    [sym__call_signature] = STATE(2996),
    [sym_call_expression] = STATE(1508),
    [sym_new_expression] = STATE(1508),
    [sym_await_expression] = STATE(1508),
    [sym_member_expression] = STATE(1008),
    [sym_subscript_expression] = STATE(1008),
    [sym_assignment_expression] = STATE(1508),
    [sym_augmented_assignment_expression] = STATE(1508),
    [sym_ternary_expression] = STATE(1508),
    [sym_binary_expression] = STATE(1508),
    [sym_unary_expression] = STATE(1508),
    [sym_update_expression] = STATE(1508),
    [sym_string] = STATE(1508),
    [sym_template_string] = STATE(1508),
    [sym_regex] = STATE(1508),
    [sym_meta_property] = STATE(1508),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1508),
    [sym_type_assertion] = STATE(1508),
    [sym_as_expression] = STATE(1508),
    [sym_internal_module] = STATE(1508),
    [sym_type_arguments] = STATE(360),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(642),
    [anon_sym_export] = ACTIONS(644),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_type] = ACTIONS(644),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(652),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_SEMI] = ACTIONS(1057),
    [anon_sym_yield] = ACTIONS(654),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(666),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_void] = ACTIONS(670),
    [anon_sym_delete] = ACTIONS(650),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(1167),
    [sym_this] = ACTIONS(1169),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(1169),
    [sym_false] = ACTIONS(1169),
    [sym_null] = ACTIONS(1169),
    [sym_undefined] = ACTIONS(1169),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(644),
    [anon_sym_get] = ACTIONS(644),
    [anon_sym_set] = ACTIONS(644),
    [anon_sym_declare] = ACTIONS(644),
    [anon_sym_public] = ACTIONS(644),
    [anon_sym_private] = ACTIONS(644),
    [anon_sym_protected] = ACTIONS(644),
    [anon_sym_module] = ACTIONS(644),
    [anon_sym_any] = ACTIONS(644),
    [anon_sym_number] = ACTIONS(644),
    [anon_sym_boolean] = ACTIONS(644),
    [anon_sym_string] = ACTIONS(644),
    [anon_sym_symbol] = ACTIONS(644),
    [sym_readonly] = ACTIONS(644),
    [sym__automatic_semicolon] = ACTIONS(1057),
  },
  [113] = {
    [sym_import] = STATE(1380),
    [sym_parenthesized_expression] = STATE(975),
    [sym__expression] = STATE(1380),
    [sym_yield_expression] = STATE(1380),
    [sym_object] = STATE(1631),
    [sym_array] = STATE(1632),
    [sym_class] = STATE(1380),
    [sym_function] = STATE(1342),
    [sym_generator_function] = STATE(1380),
    [sym_arrow_function] = STATE(1380),
    [sym__call_signature] = STATE(3044),
    [sym_call_expression] = STATE(1380),
    [sym_new_expression] = STATE(1380),
    [sym_await_expression] = STATE(1380),
    [sym_member_expression] = STATE(975),
    [sym_subscript_expression] = STATE(975),
    [sym_assignment_expression] = STATE(1380),
    [sym_augmented_assignment_expression] = STATE(1380),
    [sym_ternary_expression] = STATE(1380),
    [sym_binary_expression] = STATE(1380),
    [sym_unary_expression] = STATE(1380),
    [sym_update_expression] = STATE(1380),
    [sym_string] = STATE(1380),
    [sym_template_string] = STATE(1380),
    [sym_regex] = STATE(1380),
    [sym_meta_property] = STATE(1380),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1380),
    [sym_type_assertion] = STATE(1380),
    [sym_as_expression] = STATE(1380),
    [sym_internal_module] = STATE(1380),
    [sym_type_arguments] = STATE(412),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2579),
    [sym_identifier] = ACTIONS(702),
    [anon_sym_export] = ACTIONS(704),
    [anon_sym_STAR] = ACTIONS(1171),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_COMMA] = ACTIONS(1057),
    [anon_sym_type] = ACTIONS(704),
    [anon_sym_typeof] = ACTIONS(712),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_await] = ACTIONS(718),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_yield] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(722),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(724),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(726),
    [anon_sym_async] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_new] = ACTIONS(732),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_void] = ACTIONS(742),
    [anon_sym_delete] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(744),
    [anon_sym_DASH_DASH] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_super] = ACTIONS(756),
    [sym_true] = ACTIONS(1175),
    [sym_false] = ACTIONS(1175),
    [sym_null] = ACTIONS(1175),
    [sym_undefined] = ACTIONS(1175),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(704),
    [anon_sym_get] = ACTIONS(704),
    [anon_sym_set] = ACTIONS(704),
    [anon_sym_declare] = ACTIONS(704),
    [anon_sym_public] = ACTIONS(704),
    [anon_sym_private] = ACTIONS(704),
    [anon_sym_protected] = ACTIONS(704),
    [anon_sym_module] = ACTIONS(704),
    [anon_sym_any] = ACTIONS(704),
    [anon_sym_number] = ACTIONS(704),
    [anon_sym_boolean] = ACTIONS(704),
    [anon_sym_string] = ACTIONS(704),
    [anon_sym_symbol] = ACTIONS(704),
    [sym_readonly] = ACTIONS(704),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1057),
  },
  [114] = {
    [sym_import] = STATE(1391),
    [sym_parenthesized_expression] = STATE(983),
    [sym__expression] = STATE(1391),
    [sym_yield_expression] = STATE(1391),
    [sym_object] = STATE(1672),
    [sym_array] = STATE(1671),
    [sym_class] = STATE(1391),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1391),
    [sym_arrow_function] = STATE(1391),
    [sym__call_signature] = STATE(3144),
    [sym_call_expression] = STATE(1391),
    [sym_new_expression] = STATE(1391),
    [sym_await_expression] = STATE(1391),
    [sym_member_expression] = STATE(983),
    [sym_subscript_expression] = STATE(983),
    [sym_assignment_expression] = STATE(1391),
    [sym_augmented_assignment_expression] = STATE(1391),
    [sym_ternary_expression] = STATE(1391),
    [sym_binary_expression] = STATE(1391),
    [sym_unary_expression] = STATE(1391),
    [sym_update_expression] = STATE(1391),
    [sym_string] = STATE(1391),
    [sym_template_string] = STATE(1391),
    [sym_regex] = STATE(1391),
    [sym_meta_property] = STATE(1391),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1391),
    [sym_type_assertion] = STATE(1391),
    [sym_as_expression] = STATE(1391),
    [sym_internal_module] = STATE(1391),
    [sym_type_arguments] = STATE(390),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(766),
    [anon_sym_export] = ACTIONS(768),
    [anon_sym_STAR] = ACTIONS(1177),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(772),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(1057),
    [anon_sym_type] = ACTIONS(768),
    [anon_sym_typeof] = ACTIONS(774),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(776),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_yield] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(780),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(782),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(784),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(788),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(792),
    [anon_sym_void] = ACTIONS(794),
    [anon_sym_delete] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(796),
    [anon_sym_DASH_DASH] = ACTIONS(796),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1179),
    [sym_this] = ACTIONS(1181),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1181),
    [sym_false] = ACTIONS(1181),
    [sym_null] = ACTIONS(1181),
    [sym_undefined] = ACTIONS(1181),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_get] = ACTIONS(768),
    [anon_sym_set] = ACTIONS(768),
    [anon_sym_declare] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_any] = ACTIONS(768),
    [anon_sym_number] = ACTIONS(768),
    [anon_sym_boolean] = ACTIONS(768),
    [anon_sym_string] = ACTIONS(768),
    [anon_sym_symbol] = ACTIONS(768),
    [anon_sym_implements] = ACTIONS(1055),
    [sym_readonly] = ACTIONS(768),
  },
  [115] = {
    [sym_import] = STATE(1538),
    [sym_parenthesized_expression] = STATE(1015),
    [sym__expression] = STATE(1538),
    [sym_yield_expression] = STATE(1538),
    [sym_object] = STATE(1872),
    [sym_array] = STATE(1880),
    [sym_class] = STATE(1538),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1538),
    [sym_arrow_function] = STATE(1538),
    [sym__call_signature] = STATE(3053),
    [sym_call_expression] = STATE(1538),
    [sym_new_expression] = STATE(1538),
    [sym_await_expression] = STATE(1538),
    [sym_member_expression] = STATE(1015),
    [sym_subscript_expression] = STATE(1015),
    [sym_assignment_expression] = STATE(1538),
    [sym_augmented_assignment_expression] = STATE(1538),
    [sym_ternary_expression] = STATE(1538),
    [sym_binary_expression] = STATE(1538),
    [sym_unary_expression] = STATE(1538),
    [sym_update_expression] = STATE(1538),
    [sym_string] = STATE(1538),
    [sym_template_string] = STATE(1538),
    [sym_regex] = STATE(1538),
    [sym_meta_property] = STATE(1538),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1538),
    [sym_type_assertion] = STATE(1538),
    [sym_as_expression] = STATE(1538),
    [sym_internal_module] = STATE(1538),
    [sym_type_arguments] = STATE(329),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(1183),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_RBRACK] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1185),
    [sym_this] = ACTIONS(1187),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1187),
    [sym_false] = ACTIONS(1187),
    [sym_null] = ACTIONS(1187),
    [sym_undefined] = ACTIONS(1187),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [anon_sym_declare] = ACTIONS(493),
    [anon_sym_public] = ACTIONS(493),
    [anon_sym_private] = ACTIONS(493),
    [anon_sym_protected] = ACTIONS(493),
    [anon_sym_module] = ACTIONS(493),
    [anon_sym_any] = ACTIONS(493),
    [anon_sym_number] = ACTIONS(493),
    [anon_sym_boolean] = ACTIONS(493),
    [anon_sym_string] = ACTIONS(493),
    [anon_sym_symbol] = ACTIONS(493),
    [sym_readonly] = ACTIONS(493),
  },
  [116] = {
    [sym_import] = STATE(1598),
    [sym_parenthesized_expression] = STATE(1020),
    [sym__expression] = STATE(1598),
    [sym_yield_expression] = STATE(1598),
    [sym_object] = STATE(1871),
    [sym_array] = STATE(1873),
    [sym_class] = STATE(1598),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1598),
    [sym_arrow_function] = STATE(1598),
    [sym__call_signature] = STATE(3037),
    [sym_call_expression] = STATE(1598),
    [sym_new_expression] = STATE(1598),
    [sym_await_expression] = STATE(1598),
    [sym_member_expression] = STATE(1020),
    [sym_subscript_expression] = STATE(1020),
    [sym_assignment_expression] = STATE(1598),
    [sym_augmented_assignment_expression] = STATE(1598),
    [sym_ternary_expression] = STATE(1598),
    [sym_binary_expression] = STATE(1598),
    [sym_unary_expression] = STATE(1598),
    [sym_update_expression] = STATE(1598),
    [sym_string] = STATE(1598),
    [sym_template_string] = STATE(1598),
    [sym_regex] = STATE(1598),
    [sym_meta_property] = STATE(1598),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1598),
    [sym_type_assertion] = STATE(1598),
    [sym_as_expression] = STATE(1598),
    [sym_internal_module] = STATE(1598),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2554),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_export] = ACTIONS(804),
    [anon_sym_STAR] = ACTIONS(1189),
    [anon_sym_as] = ACTIONS(1055),
    [anon_sym_namespace] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(804),
    [anon_sym_typeof] = ACTIONS(810),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(812),
    [anon_sym_in] = ACTIONS(1055),
    [anon_sym_COLON] = ACTIONS(1057),
    [anon_sym_yield] = ACTIONS(814),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(1055),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(1055),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(816),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(818),
    [anon_sym_QMARK] = ACTIONS(1055),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_GT_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1057),
    [anon_sym_PIPE] = ACTIONS(1055),
    [anon_sym_PLUS] = ACTIONS(822),
    [anon_sym_DASH] = ACTIONS(822),
    [anon_sym_PERCENT] = ACTIONS(1057),
    [anon_sym_STAR_STAR] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1055),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1057),
    [anon_sym_BANG_EQ] = ACTIONS(1055),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_QMARK_QMARK] = ACTIONS(1057),
    [anon_sym_instanceof] = ACTIONS(1055),
    [anon_sym_BANG] = ACTIONS(824),
    [anon_sym_TILDE] = ACTIONS(826),
    [anon_sym_void] = ACTIONS(828),
    [anon_sym_delete] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(830),
    [anon_sym_DASH_DASH] = ACTIONS(830),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1191),
    [sym_this] = ACTIONS(1193),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1193),
    [sym_false] = ACTIONS(1193),
    [sym_null] = ACTIONS(1193),
    [sym_undefined] = ACTIONS(1193),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_get] = ACTIONS(804),
    [anon_sym_set] = ACTIONS(804),
    [anon_sym_declare] = ACTIONS(804),
    [anon_sym_public] = ACTIONS(804),
    [anon_sym_private] = ACTIONS(804),
    [anon_sym_protected] = ACTIONS(804),
    [anon_sym_module] = ACTIONS(804),
    [anon_sym_any] = ACTIONS(804),
    [anon_sym_number] = ACTIONS(804),
    [anon_sym_boolean] = ACTIONS(804),
    [anon_sym_string] = ACTIONS(804),
    [anon_sym_symbol] = ACTIONS(804),
    [sym_readonly] = ACTIONS(804),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(1195),
    [sym_identifier] = ACTIONS(1197),
    [anon_sym_export] = ACTIONS(1197),
    [anon_sym_STAR] = ACTIONS(1199),
    [anon_sym_default] = ACTIONS(1197),
    [anon_sym_EQ] = ACTIONS(1199),
    [anon_sym_as] = ACTIONS(1199),
    [anon_sym_namespace] = ACTIONS(1197),
    [anon_sym_LBRACE] = ACTIONS(1195),
    [anon_sym_COMMA] = ACTIONS(1201),
    [anon_sym_RBRACE] = ACTIONS(1195),
    [anon_sym_type] = ACTIONS(1197),
    [anon_sym_typeof] = ACTIONS(1197),
    [anon_sym_import] = ACTIONS(1197),
    [anon_sym_var] = ACTIONS(1197),
    [anon_sym_let] = ACTIONS(1197),
    [anon_sym_const] = ACTIONS(1197),
    [anon_sym_if] = ACTIONS(1197),
    [anon_sym_else] = ACTIONS(1197),
    [anon_sym_switch] = ACTIONS(1197),
    [anon_sym_for] = ACTIONS(1197),
    [anon_sym_LPAREN] = ACTIONS(1195),
    [anon_sym_await] = ACTIONS(1197),
    [anon_sym_in] = ACTIONS(1199),
    [anon_sym_while] = ACTIONS(1197),
    [anon_sym_do] = ACTIONS(1197),
    [anon_sym_try] = ACTIONS(1197),
    [anon_sym_with] = ACTIONS(1197),
    [anon_sym_break] = ACTIONS(1197),
    [anon_sym_continue] = ACTIONS(1197),
    [anon_sym_debugger] = ACTIONS(1197),
    [anon_sym_return] = ACTIONS(1197),
    [anon_sym_throw] = ACTIONS(1197),
    [anon_sym_SEMI] = ACTIONS(1195),
    [anon_sym_case] = ACTIONS(1197),
    [anon_sym_yield] = ACTIONS(1197),
    [anon_sym_LBRACK] = ACTIONS(1195),
    [anon_sym_LT] = ACTIONS(1197),
    [anon_sym_GT] = ACTIONS(1199),
    [anon_sym_SLASH] = ACTIONS(1197),
    [anon_sym_DOT] = ACTIONS(1199),
    [anon_sym_class] = ACTIONS(1197),
    [anon_sym_async] = ACTIONS(1197),
    [anon_sym_function] = ACTIONS(1197),
    [anon_sym_new] = ACTIONS(1197),
    [anon_sym_QMARK] = ACTIONS(1199),
    [anon_sym_AMP_AMP] = ACTIONS(1201),
    [anon_sym_PIPE_PIPE] = ACTIONS(1201),
    [anon_sym_GT_GT] = ACTIONS(1199),
    [anon_sym_GT_GT_GT] = ACTIONS(1201),
    [anon_sym_LT_LT] = ACTIONS(1201),
    [anon_sym_AMP] = ACTIONS(1199),
    [anon_sym_CARET] = ACTIONS(1201),
    [anon_sym_PIPE] = ACTIONS(1199),
    [anon_sym_PLUS] = ACTIONS(1197),
    [anon_sym_DASH] = ACTIONS(1197),
    [anon_sym_PERCENT] = ACTIONS(1201),
    [anon_sym_STAR_STAR] = ACTIONS(1201),
    [anon_sym_LT_EQ] = ACTIONS(1201),
    [anon_sym_EQ_EQ] = ACTIONS(1199),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1201),
    [anon_sym_BANG_EQ] = ACTIONS(1199),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1201),
    [anon_sym_GT_EQ] = ACTIONS(1201),
    [anon_sym_QMARK_QMARK] = ACTIONS(1201),
    [anon_sym_instanceof] = ACTIONS(1199),
    [anon_sym_BANG] = ACTIONS(1197),
    [anon_sym_TILDE] = ACTIONS(1195),
    [anon_sym_void] = ACTIONS(1197),
    [anon_sym_delete] = ACTIONS(1197),
    [anon_sym_PLUS_PLUS] = ACTIONS(1195),
    [anon_sym_DASH_DASH] = ACTIONS(1195),
    [anon_sym_DQUOTE] = ACTIONS(1195),
    [anon_sym_SQUOTE] = ACTIONS(1195),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1195),
    [sym_number] = ACTIONS(1195),
    [sym_this] = ACTIONS(1197),
    [sym_super] = ACTIONS(1197),
    [sym_true] = ACTIONS(1197),
    [sym_false] = ACTIONS(1197),
    [sym_null] = ACTIONS(1197),
    [sym_undefined] = ACTIONS(1197),
    [anon_sym_AT] = ACTIONS(1195),
    [anon_sym_static] = ACTIONS(1197),
    [anon_sym_abstract] = ACTIONS(1197),
    [anon_sym_get] = ACTIONS(1197),
    [anon_sym_set] = ACTIONS(1197),
    [anon_sym_declare] = ACTIONS(1197),
    [anon_sym_public] = ACTIONS(1197),
    [anon_sym_private] = ACTIONS(1197),
    [anon_sym_protected] = ACTIONS(1197),
    [anon_sym_module] = ACTIONS(1197),
    [anon_sym_any] = ACTIONS(1197),
    [anon_sym_number] = ACTIONS(1197),
    [anon_sym_boolean] = ACTIONS(1197),
    [anon_sym_string] = ACTIONS(1197),
    [anon_sym_symbol] = ACTIONS(1197),
    [anon_sym_interface] = ACTIONS(1197),
    [anon_sym_enum] = ACTIONS(1197),
    [sym_readonly] = ACTIONS(1197),
    [sym__automatic_semicolon] = ACTIONS(1203),
  },
  [118] = {
    [sym_statement_block] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(1205),
    [sym_identifier] = ACTIONS(1207),
    [anon_sym_export] = ACTIONS(1207),
    [anon_sym_STAR] = ACTIONS(1207),
    [anon_sym_default] = ACTIONS(1207),
    [anon_sym_as] = ACTIONS(1207),
    [anon_sym_namespace] = ACTIONS(1207),
    [anon_sym_LBRACE] = ACTIONS(1209),
    [anon_sym_COMMA] = ACTIONS(1205),
    [anon_sym_RBRACE] = ACTIONS(1205),
    [anon_sym_type] = ACTIONS(1207),
    [anon_sym_typeof] = ACTIONS(1207),
    [anon_sym_import] = ACTIONS(1207),
    [anon_sym_var] = ACTIONS(1207),
    [anon_sym_let] = ACTIONS(1207),
    [anon_sym_const] = ACTIONS(1207),
    [anon_sym_if] = ACTIONS(1207),
    [anon_sym_else] = ACTIONS(1207),
    [anon_sym_switch] = ACTIONS(1207),
    [anon_sym_for] = ACTIONS(1207),
    [anon_sym_LPAREN] = ACTIONS(1205),
    [anon_sym_await] = ACTIONS(1207),
    [anon_sym_in] = ACTIONS(1207),
    [anon_sym_while] = ACTIONS(1207),
    [anon_sym_do] = ACTIONS(1207),
    [anon_sym_try] = ACTIONS(1207),
    [anon_sym_with] = ACTIONS(1207),
    [anon_sym_break] = ACTIONS(1207),
    [anon_sym_continue] = ACTIONS(1207),
    [anon_sym_debugger] = ACTIONS(1207),
    [anon_sym_return] = ACTIONS(1207),
    [anon_sym_throw] = ACTIONS(1207),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym_case] = ACTIONS(1207),
    [anon_sym_yield] = ACTIONS(1207),
    [anon_sym_LBRACK] = ACTIONS(1205),
    [anon_sym_LT] = ACTIONS(1207),
    [anon_sym_GT] = ACTIONS(1207),
    [anon_sym_SLASH] = ACTIONS(1207),
    [anon_sym_DOT] = ACTIONS(1207),
    [anon_sym_class] = ACTIONS(1207),
    [anon_sym_async] = ACTIONS(1207),
    [anon_sym_function] = ACTIONS(1207),
    [anon_sym_new] = ACTIONS(1207),
    [anon_sym_QMARK] = ACTIONS(1207),
    [anon_sym_AMP_AMP] = ACTIONS(1205),
    [anon_sym_PIPE_PIPE] = ACTIONS(1205),
    [anon_sym_GT_GT] = ACTIONS(1207),
    [anon_sym_GT_GT_GT] = ACTIONS(1205),
    [anon_sym_LT_LT] = ACTIONS(1205),
    [anon_sym_AMP] = ACTIONS(1207),
    [anon_sym_CARET] = ACTIONS(1205),
    [anon_sym_PIPE] = ACTIONS(1207),
    [anon_sym_PLUS] = ACTIONS(1207),
    [anon_sym_DASH] = ACTIONS(1207),
    [anon_sym_PERCENT] = ACTIONS(1205),
    [anon_sym_STAR_STAR] = ACTIONS(1205),
    [anon_sym_LT_EQ] = ACTIONS(1205),
    [anon_sym_EQ_EQ] = ACTIONS(1207),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1205),
    [anon_sym_BANG_EQ] = ACTIONS(1207),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1205),
    [anon_sym_GT_EQ] = ACTIONS(1205),
    [anon_sym_QMARK_QMARK] = ACTIONS(1205),
    [anon_sym_instanceof] = ACTIONS(1207),
    [anon_sym_BANG] = ACTIONS(1207),
    [anon_sym_TILDE] = ACTIONS(1205),
    [anon_sym_void] = ACTIONS(1207),
    [anon_sym_delete] = ACTIONS(1207),
    [anon_sym_PLUS_PLUS] = ACTIONS(1205),
    [anon_sym_DASH_DASH] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(1205),
    [anon_sym_SQUOTE] = ACTIONS(1205),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1205),
    [sym_number] = ACTIONS(1205),
    [sym_this] = ACTIONS(1207),
    [sym_super] = ACTIONS(1207),
    [sym_true] = ACTIONS(1207),
    [sym_false] = ACTIONS(1207),
    [sym_null] = ACTIONS(1207),
    [sym_undefined] = ACTIONS(1207),
    [anon_sym_AT] = ACTIONS(1205),
    [anon_sym_static] = ACTIONS(1207),
    [anon_sym_abstract] = ACTIONS(1207),
    [anon_sym_get] = ACTIONS(1207),
    [anon_sym_set] = ACTIONS(1207),
    [anon_sym_declare] = ACTIONS(1207),
    [anon_sym_public] = ACTIONS(1207),
    [anon_sym_private] = ACTIONS(1207),
    [anon_sym_protected] = ACTIONS(1207),
    [anon_sym_module] = ACTIONS(1207),
    [anon_sym_any] = ACTIONS(1207),
    [anon_sym_number] = ACTIONS(1207),
    [anon_sym_boolean] = ACTIONS(1207),
    [anon_sym_string] = ACTIONS(1207),
    [anon_sym_symbol] = ACTIONS(1207),
    [anon_sym_interface] = ACTIONS(1207),
    [anon_sym_enum] = ACTIONS(1207),
    [sym_readonly] = ACTIONS(1207),
    [sym__automatic_semicolon] = ACTIONS(1205),
  },
  [119] = {
    [sym_statement_block] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(1205),
    [sym_identifier] = ACTIONS(1207),
    [anon_sym_export] = ACTIONS(1207),
    [anon_sym_STAR] = ACTIONS(1207),
    [anon_sym_default] = ACTIONS(1207),
    [anon_sym_as] = ACTIONS(1207),
    [anon_sym_namespace] = ACTIONS(1207),
    [anon_sym_LBRACE] = ACTIONS(1209),
    [anon_sym_COMMA] = ACTIONS(1205),
    [anon_sym_RBRACE] = ACTIONS(1205),
    [anon_sym_type] = ACTIONS(1207),
    [anon_sym_typeof] = ACTIONS(1207),
    [anon_sym_import] = ACTIONS(1207),
    [anon_sym_var] = ACTIONS(1207),
    [anon_sym_let] = ACTIONS(1207),
    [anon_sym_const] = ACTIONS(1207),
    [anon_sym_if] = ACTIONS(1207),
    [anon_sym_else] = ACTIONS(1207),
    [anon_sym_switch] = ACTIONS(1207),
    [anon_sym_for] = ACTIONS(1207),
    [anon_sym_LPAREN] = ACTIONS(1205),
    [anon_sym_await] = ACTIONS(1207),
    [anon_sym_in] = ACTIONS(1207),
    [anon_sym_while] = ACTIONS(1207),
    [anon_sym_do] = ACTIONS(1207),
    [anon_sym_try] = ACTIONS(1207),
    [anon_sym_with] = ACTIONS(1207),
    [anon_sym_break] = ACTIONS(1207),
    [anon_sym_continue] = ACTIONS(1207),
    [anon_sym_debugger] = ACTIONS(1207),
    [anon_sym_return] = ACTIONS(1207),
    [anon_sym_throw] = ACTIONS(1207),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym_case] = ACTIONS(1207),
    [anon_sym_yield] = ACTIONS(1207),
    [anon_sym_LBRACK] = ACTIONS(1205),
    [anon_sym_LT] = ACTIONS(1207),
    [anon_sym_GT] = ACTIONS(1207),
    [anon_sym_SLASH] = ACTIONS(1207),
    [anon_sym_DOT] = ACTIONS(1211),
    [anon_sym_class] = ACTIONS(1207),
    [anon_sym_async] = ACTIONS(1207),
    [anon_sym_function] = ACTIONS(1207),
    [anon_sym_new] = ACTIONS(1207),
    [anon_sym_QMARK] = ACTIONS(1207),
    [anon_sym_AMP_AMP] = ACTIONS(1205),
    [anon_sym_PIPE_PIPE] = ACTIONS(1205),
    [anon_sym_GT_GT] = ACTIONS(1207),
    [anon_sym_GT_GT_GT] = ACTIONS(1205),
    [anon_sym_LT_LT] = ACTIONS(1205),
    [anon_sym_AMP] = ACTIONS(1207),
    [anon_sym_CARET] = ACTIONS(1205),
    [anon_sym_PIPE] = ACTIONS(1207),
    [anon_sym_PLUS] = ACTIONS(1207),
    [anon_sym_DASH] = ACTIONS(1207),
    [anon_sym_PERCENT] = ACTIONS(1205),
    [anon_sym_STAR_STAR] = ACTIONS(1205),
    [anon_sym_LT_EQ] = ACTIONS(1205),
    [anon_sym_EQ_EQ] = ACTIONS(1207),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1205),
    [anon_sym_BANG_EQ] = ACTIONS(1207),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1205),
    [anon_sym_GT_EQ] = ACTIONS(1205),
    [anon_sym_QMARK_QMARK] = ACTIONS(1205),
    [anon_sym_instanceof] = ACTIONS(1207),
    [anon_sym_BANG] = ACTIONS(1207),
    [anon_sym_TILDE] = ACTIONS(1205),
    [anon_sym_void] = ACTIONS(1207),
    [anon_sym_delete] = ACTIONS(1207),
    [anon_sym_PLUS_PLUS] = ACTIONS(1205),
    [anon_sym_DASH_DASH] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(1205),
    [anon_sym_SQUOTE] = ACTIONS(1205),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1205),
    [sym_number] = ACTIONS(1205),
    [sym_this] = ACTIONS(1207),
    [sym_super] = ACTIONS(1207),
    [sym_true] = ACTIONS(1207),
    [sym_false] = ACTIONS(1207),
    [sym_null] = ACTIONS(1207),
    [sym_undefined] = ACTIONS(1207),
    [anon_sym_AT] = ACTIONS(1205),
    [anon_sym_static] = ACTIONS(1207),
    [anon_sym_abstract] = ACTIONS(1207),
    [anon_sym_get] = ACTIONS(1207),
    [anon_sym_set] = ACTIONS(1207),
    [anon_sym_declare] = ACTIONS(1207),
    [anon_sym_public] = ACTIONS(1207),
    [anon_sym_private] = ACTIONS(1207),
    [anon_sym_protected] = ACTIONS(1207),
    [anon_sym_module] = ACTIONS(1207),
    [anon_sym_any] = ACTIONS(1207),
    [anon_sym_number] = ACTIONS(1207),
    [anon_sym_boolean] = ACTIONS(1207),
    [anon_sym_string] = ACTIONS(1207),
    [anon_sym_symbol] = ACTIONS(1207),
    [anon_sym_interface] = ACTIONS(1207),
    [anon_sym_enum] = ACTIONS(1207),
    [sym_readonly] = ACTIONS(1207),
    [sym__automatic_semicolon] = ACTIONS(1205),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(1213),
    [sym_identifier] = ACTIONS(1215),
    [anon_sym_export] = ACTIONS(1215),
    [anon_sym_STAR] = ACTIONS(1217),
    [anon_sym_default] = ACTIONS(1215),
    [anon_sym_as] = ACTIONS(1217),
    [anon_sym_namespace] = ACTIONS(1215),
    [anon_sym_LBRACE] = ACTIONS(1213),
    [anon_sym_COMMA] = ACTIONS(1219),
    [anon_sym_RBRACE] = ACTIONS(1213),
    [anon_sym_type] = ACTIONS(1215),
    [anon_sym_typeof] = ACTIONS(1215),
    [anon_sym_import] = ACTIONS(1215),
    [anon_sym_var] = ACTIONS(1215),
    [anon_sym_let] = ACTIONS(1215),
    [anon_sym_const] = ACTIONS(1215),
    [anon_sym_if] = ACTIONS(1215),
    [anon_sym_else] = ACTIONS(1215),
    [anon_sym_switch] = ACTIONS(1215),
    [anon_sym_for] = ACTIONS(1215),
    [anon_sym_LPAREN] = ACTIONS(1213),
    [anon_sym_await] = ACTIONS(1215),
    [anon_sym_in] = ACTIONS(1217),
    [anon_sym_while] = ACTIONS(1215),
    [anon_sym_do] = ACTIONS(1215),
    [anon_sym_try] = ACTIONS(1215),
    [anon_sym_with] = ACTIONS(1215),
    [anon_sym_break] = ACTIONS(1215),
    [anon_sym_continue] = ACTIONS(1215),
    [anon_sym_debugger] = ACTIONS(1215),
    [anon_sym_return] = ACTIONS(1215),
    [anon_sym_throw] = ACTIONS(1215),
    [anon_sym_SEMI] = ACTIONS(1213),
    [anon_sym_case] = ACTIONS(1215),
    [anon_sym_yield] = ACTIONS(1215),
    [anon_sym_LBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1215),
    [anon_sym_GT] = ACTIONS(1217),
    [anon_sym_SLASH] = ACTIONS(1215),
    [anon_sym_DOT] = ACTIONS(1217),
    [anon_sym_class] = ACTIONS(1215),
    [anon_sym_async] = ACTIONS(1215),
    [anon_sym_function] = ACTIONS(1215),
    [anon_sym_new] = ACTIONS(1215),
    [anon_sym_QMARK] = ACTIONS(1217),
    [anon_sym_AMP_AMP] = ACTIONS(1219),
    [anon_sym_PIPE_PIPE] = ACTIONS(1219),
    [anon_sym_GT_GT] = ACTIONS(1217),
    [anon_sym_GT_GT_GT] = ACTIONS(1219),
    [anon_sym_LT_LT] = ACTIONS(1219),
    [anon_sym_AMP] = ACTIONS(1217),
    [anon_sym_CARET] = ACTIONS(1219),
    [anon_sym_PIPE] = ACTIONS(1217),
    [anon_sym_PLUS] = ACTIONS(1215),
    [anon_sym_DASH] = ACTIONS(1215),
    [anon_sym_PERCENT] = ACTIONS(1219),
    [anon_sym_STAR_STAR] = ACTIONS(1219),
    [anon_sym_LT_EQ] = ACTIONS(1219),
    [anon_sym_EQ_EQ] = ACTIONS(1217),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1219),
    [anon_sym_BANG_EQ] = ACTIONS(1217),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1219),
    [anon_sym_GT_EQ] = ACTIONS(1219),
    [anon_sym_QMARK_QMARK] = ACTIONS(1219),
    [anon_sym_instanceof] = ACTIONS(1217),
    [anon_sym_BANG] = ACTIONS(1215),
    [anon_sym_TILDE] = ACTIONS(1213),
    [anon_sym_void] = ACTIONS(1215),
    [anon_sym_delete] = ACTIONS(1215),
    [anon_sym_PLUS_PLUS] = ACTIONS(1213),
    [anon_sym_DASH_DASH] = ACTIONS(1213),
    [anon_sym_DQUOTE] = ACTIONS(1213),
    [anon_sym_SQUOTE] = ACTIONS(1213),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1213),
    [sym_number] = ACTIONS(1213),
    [sym_this] = ACTIONS(1215),
    [sym_super] = ACTIONS(1215),
    [sym_true] = ACTIONS(1215),
    [sym_false] = ACTIONS(1215),
    [sym_null] = ACTIONS(1215),
    [sym_undefined] = ACTIONS(1215),
    [anon_sym_AT] = ACTIONS(1213),
    [anon_sym_static] = ACTIONS(1215),
    [anon_sym_abstract] = ACTIONS(1215),
    [anon_sym_get] = ACTIONS(1215),
    [anon_sym_set] = ACTIONS(1215),
    [anon_sym_declare] = ACTIONS(1215),
    [anon_sym_public] = ACTIONS(1215),
    [anon_sym_private] = ACTIONS(1215),
    [anon_sym_protected] = ACTIONS(1215),
    [anon_sym_module] = ACTIONS(1215),
    [anon_sym_any] = ACTIONS(1215),
    [anon_sym_number] = ACTIONS(1215),
    [anon_sym_boolean] = ACTIONS(1215),
    [anon_sym_string] = ACTIONS(1215),
    [anon_sym_symbol] = ACTIONS(1215),
    [anon_sym_interface] = ACTIONS(1215),
    [anon_sym_enum] = ACTIONS(1215),
    [sym_readonly] = ACTIONS(1215),
    [sym__automatic_semicolon] = ACTIONS(1221),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(1223),
    [sym_identifier] = ACTIONS(1225),
    [anon_sym_export] = ACTIONS(1225),
    [anon_sym_STAR] = ACTIONS(1227),
    [anon_sym_default] = ACTIONS(1225),
    [anon_sym_as] = ACTIONS(1227),
    [anon_sym_namespace] = ACTIONS(1225),
    [anon_sym_LBRACE] = ACTIONS(1223),
    [anon_sym_COMMA] = ACTIONS(1229),
    [anon_sym_RBRACE] = ACTIONS(1223),
    [anon_sym_type] = ACTIONS(1225),
    [anon_sym_typeof] = ACTIONS(1225),
    [anon_sym_import] = ACTIONS(1225),
    [anon_sym_var] = ACTIONS(1225),
    [anon_sym_let] = ACTIONS(1225),
    [anon_sym_const] = ACTIONS(1225),
    [anon_sym_if] = ACTIONS(1225),
    [anon_sym_else] = ACTIONS(1225),
    [anon_sym_switch] = ACTIONS(1225),
    [anon_sym_for] = ACTIONS(1225),
    [anon_sym_LPAREN] = ACTIONS(1223),
    [anon_sym_await] = ACTIONS(1225),
    [anon_sym_in] = ACTIONS(1227),
    [anon_sym_while] = ACTIONS(1225),
    [anon_sym_do] = ACTIONS(1225),
    [anon_sym_try] = ACTIONS(1225),
    [anon_sym_with] = ACTIONS(1225),
    [anon_sym_break] = ACTIONS(1225),
    [anon_sym_continue] = ACTIONS(1225),
    [anon_sym_debugger] = ACTIONS(1225),
    [anon_sym_return] = ACTIONS(1225),
    [anon_sym_throw] = ACTIONS(1225),
    [anon_sym_SEMI] = ACTIONS(1223),
    [anon_sym_case] = ACTIONS(1225),
    [anon_sym_yield] = ACTIONS(1225),
    [anon_sym_LBRACK] = ACTIONS(1223),
    [anon_sym_LT] = ACTIONS(1225),
    [anon_sym_GT] = ACTIONS(1227),
    [anon_sym_SLASH] = ACTIONS(1225),
    [anon_sym_DOT] = ACTIONS(1227),
    [anon_sym_class] = ACTIONS(1225),
    [anon_sym_async] = ACTIONS(1225),
    [anon_sym_function] = ACTIONS(1225),
    [anon_sym_new] = ACTIONS(1225),
    [anon_sym_QMARK] = ACTIONS(1227),
    [anon_sym_AMP_AMP] = ACTIONS(1229),
    [anon_sym_PIPE_PIPE] = ACTIONS(1229),
    [anon_sym_GT_GT] = ACTIONS(1227),
    [anon_sym_GT_GT_GT] = ACTIONS(1229),
    [anon_sym_LT_LT] = ACTIONS(1229),
    [anon_sym_AMP] = ACTIONS(1227),
    [anon_sym_CARET] = ACTIONS(1229),
    [anon_sym_PIPE] = ACTIONS(1227),
    [anon_sym_PLUS] = ACTIONS(1225),
    [anon_sym_DASH] = ACTIONS(1225),
    [anon_sym_PERCENT] = ACTIONS(1229),
    [anon_sym_STAR_STAR] = ACTIONS(1229),
    [anon_sym_LT_EQ] = ACTIONS(1229),
    [anon_sym_EQ_EQ] = ACTIONS(1227),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1229),
    [anon_sym_BANG_EQ] = ACTIONS(1227),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1229),
    [anon_sym_GT_EQ] = ACTIONS(1229),
    [anon_sym_QMARK_QMARK] = ACTIONS(1229),
    [anon_sym_instanceof] = ACTIONS(1227),
    [anon_sym_BANG] = ACTIONS(1225),
    [anon_sym_TILDE] = ACTIONS(1223),
    [anon_sym_void] = ACTIONS(1225),
    [anon_sym_delete] = ACTIONS(1225),
    [anon_sym_PLUS_PLUS] = ACTIONS(1223),
    [anon_sym_DASH_DASH] = ACTIONS(1223),
    [anon_sym_DQUOTE] = ACTIONS(1223),
    [anon_sym_SQUOTE] = ACTIONS(1223),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1223),
    [sym_number] = ACTIONS(1223),
    [sym_this] = ACTIONS(1225),
    [sym_super] = ACTIONS(1225),
    [sym_true] = ACTIONS(1225),
    [sym_false] = ACTIONS(1225),
    [sym_null] = ACTIONS(1225),
    [sym_undefined] = ACTIONS(1225),
    [anon_sym_AT] = ACTIONS(1223),
    [anon_sym_static] = ACTIONS(1225),
    [anon_sym_abstract] = ACTIONS(1225),
    [anon_sym_get] = ACTIONS(1225),
    [anon_sym_set] = ACTIONS(1225),
    [anon_sym_declare] = ACTIONS(1225),
    [anon_sym_public] = ACTIONS(1225),
    [anon_sym_private] = ACTIONS(1225),
    [anon_sym_protected] = ACTIONS(1225),
    [anon_sym_module] = ACTIONS(1225),
    [anon_sym_any] = ACTIONS(1225),
    [anon_sym_number] = ACTIONS(1225),
    [anon_sym_boolean] = ACTIONS(1225),
    [anon_sym_string] = ACTIONS(1225),
    [anon_sym_symbol] = ACTIONS(1225),
    [anon_sym_interface] = ACTIONS(1225),
    [anon_sym_enum] = ACTIONS(1225),
    [sym_readonly] = ACTIONS(1225),
    [sym__automatic_semicolon] = ACTIONS(1231),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(1233),
    [sym_identifier] = ACTIONS(1235),
    [anon_sym_export] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1235),
    [anon_sym_default] = ACTIONS(1235),
    [anon_sym_as] = ACTIONS(1235),
    [anon_sym_namespace] = ACTIONS(1235),
    [anon_sym_LBRACE] = ACTIONS(1233),
    [anon_sym_COMMA] = ACTIONS(1233),
    [anon_sym_RBRACE] = ACTIONS(1233),
    [anon_sym_type] = ACTIONS(1235),
    [anon_sym_typeof] = ACTIONS(1235),
    [anon_sym_import] = ACTIONS(1235),
    [anon_sym_var] = ACTIONS(1235),
    [anon_sym_let] = ACTIONS(1235),
    [anon_sym_const] = ACTIONS(1235),
    [anon_sym_if] = ACTIONS(1235),
    [anon_sym_else] = ACTIONS(1235),
    [anon_sym_switch] = ACTIONS(1235),
    [anon_sym_for] = ACTIONS(1235),
    [anon_sym_LPAREN] = ACTIONS(1233),
    [anon_sym_await] = ACTIONS(1235),
    [anon_sym_in] = ACTIONS(1235),
    [anon_sym_while] = ACTIONS(1235),
    [anon_sym_do] = ACTIONS(1235),
    [anon_sym_try] = ACTIONS(1235),
    [anon_sym_with] = ACTIONS(1235),
    [anon_sym_break] = ACTIONS(1235),
    [anon_sym_continue] = ACTIONS(1235),
    [anon_sym_debugger] = ACTIONS(1235),
    [anon_sym_return] = ACTIONS(1235),
    [anon_sym_throw] = ACTIONS(1235),
    [anon_sym_SEMI] = ACTIONS(1233),
    [anon_sym_case] = ACTIONS(1235),
    [anon_sym_yield] = ACTIONS(1235),
    [anon_sym_LBRACK] = ACTIONS(1233),
    [anon_sym_LT] = ACTIONS(1235),
    [anon_sym_GT] = ACTIONS(1235),
    [anon_sym_SLASH] = ACTIONS(1235),
    [anon_sym_DOT] = ACTIONS(1235),
    [anon_sym_class] = ACTIONS(1235),
    [anon_sym_async] = ACTIONS(1235),
    [anon_sym_function] = ACTIONS(1235),
    [anon_sym_new] = ACTIONS(1235),
    [anon_sym_QMARK] = ACTIONS(1235),
    [anon_sym_AMP_AMP] = ACTIONS(1233),
    [anon_sym_PIPE_PIPE] = ACTIONS(1233),
    [anon_sym_GT_GT] = ACTIONS(1235),
    [anon_sym_GT_GT_GT] = ACTIONS(1233),
    [anon_sym_LT_LT] = ACTIONS(1233),
    [anon_sym_AMP] = ACTIONS(1235),
    [anon_sym_CARET] = ACTIONS(1233),
    [anon_sym_PIPE] = ACTIONS(1235),
    [anon_sym_PLUS] = ACTIONS(1235),
    [anon_sym_DASH] = ACTIONS(1235),
    [anon_sym_PERCENT] = ACTIONS(1233),
    [anon_sym_STAR_STAR] = ACTIONS(1233),
    [anon_sym_LT_EQ] = ACTIONS(1233),
    [anon_sym_EQ_EQ] = ACTIONS(1235),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1233),
    [anon_sym_BANG_EQ] = ACTIONS(1235),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1233),
    [anon_sym_GT_EQ] = ACTIONS(1233),
    [anon_sym_QMARK_QMARK] = ACTIONS(1233),
    [anon_sym_instanceof] = ACTIONS(1235),
    [anon_sym_BANG] = ACTIONS(1235),
    [anon_sym_TILDE] = ACTIONS(1233),
    [anon_sym_void] = ACTIONS(1235),
    [anon_sym_delete] = ACTIONS(1235),
    [anon_sym_PLUS_PLUS] = ACTIONS(1233),
    [anon_sym_DASH_DASH] = ACTIONS(1233),
    [anon_sym_DQUOTE] = ACTIONS(1233),
    [anon_sym_SQUOTE] = ACTIONS(1233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1233),
    [sym_number] = ACTIONS(1233),
    [sym_this] = ACTIONS(1235),
    [sym_super] = ACTIONS(1235),
    [sym_true] = ACTIONS(1235),
    [sym_false] = ACTIONS(1235),
    [sym_null] = ACTIONS(1235),
    [sym_undefined] = ACTIONS(1235),
    [anon_sym_AT] = ACTIONS(1233),
    [anon_sym_static] = ACTIONS(1235),
    [anon_sym_abstract] = ACTIONS(1235),
    [anon_sym_get] = ACTIONS(1235),
    [anon_sym_set] = ACTIONS(1235),
    [anon_sym_declare] = ACTIONS(1235),
    [anon_sym_public] = ACTIONS(1235),
    [anon_sym_private] = ACTIONS(1235),
    [anon_sym_protected] = ACTIONS(1235),
    [anon_sym_module] = ACTIONS(1235),
    [anon_sym_any] = ACTIONS(1235),
    [anon_sym_number] = ACTIONS(1235),
    [anon_sym_boolean] = ACTIONS(1235),
    [anon_sym_string] = ACTIONS(1235),
    [anon_sym_symbol] = ACTIONS(1235),
    [anon_sym_interface] = ACTIONS(1235),
    [anon_sym_enum] = ACTIONS(1235),
    [sym_readonly] = ACTIONS(1235),
    [sym__automatic_semicolon] = ACTIONS(1233),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(1237),
    [sym_identifier] = ACTIONS(1239),
    [anon_sym_export] = ACTIONS(1239),
    [anon_sym_STAR] = ACTIONS(1241),
    [anon_sym_default] = ACTIONS(1239),
    [anon_sym_as] = ACTIONS(1241),
    [anon_sym_namespace] = ACTIONS(1239),
    [anon_sym_LBRACE] = ACTIONS(1237),
    [anon_sym_COMMA] = ACTIONS(1243),
    [anon_sym_RBRACE] = ACTIONS(1237),
    [anon_sym_type] = ACTIONS(1239),
    [anon_sym_typeof] = ACTIONS(1239),
    [anon_sym_import] = ACTIONS(1239),
    [anon_sym_var] = ACTIONS(1239),
    [anon_sym_let] = ACTIONS(1239),
    [anon_sym_const] = ACTIONS(1239),
    [anon_sym_if] = ACTIONS(1239),
    [anon_sym_else] = ACTIONS(1239),
    [anon_sym_switch] = ACTIONS(1239),
    [anon_sym_for] = ACTIONS(1239),
    [anon_sym_LPAREN] = ACTIONS(1237),
    [anon_sym_await] = ACTIONS(1239),
    [anon_sym_in] = ACTIONS(1241),
    [anon_sym_while] = ACTIONS(1239),
    [anon_sym_do] = ACTIONS(1239),
    [anon_sym_try] = ACTIONS(1239),
    [anon_sym_with] = ACTIONS(1239),
    [anon_sym_break] = ACTIONS(1239),
    [anon_sym_continue] = ACTIONS(1239),
    [anon_sym_debugger] = ACTIONS(1239),
    [anon_sym_return] = ACTIONS(1239),
    [anon_sym_throw] = ACTIONS(1239),
    [anon_sym_SEMI] = ACTIONS(1237),
    [anon_sym_case] = ACTIONS(1239),
    [anon_sym_yield] = ACTIONS(1239),
    [anon_sym_LBRACK] = ACTIONS(1237),
    [anon_sym_LT] = ACTIONS(1239),
    [anon_sym_GT] = ACTIONS(1241),
    [anon_sym_SLASH] = ACTIONS(1239),
    [anon_sym_DOT] = ACTIONS(1241),
    [anon_sym_class] = ACTIONS(1239),
    [anon_sym_async] = ACTIONS(1239),
    [anon_sym_function] = ACTIONS(1239),
    [anon_sym_new] = ACTIONS(1239),
    [anon_sym_QMARK] = ACTIONS(1241),
    [anon_sym_AMP_AMP] = ACTIONS(1243),
    [anon_sym_PIPE_PIPE] = ACTIONS(1243),
    [anon_sym_GT_GT] = ACTIONS(1241),
    [anon_sym_GT_GT_GT] = ACTIONS(1243),
    [anon_sym_LT_LT] = ACTIONS(1243),
    [anon_sym_AMP] = ACTIONS(1241),
    [anon_sym_CARET] = ACTIONS(1243),
    [anon_sym_PIPE] = ACTIONS(1241),
    [anon_sym_PLUS] = ACTIONS(1239),
    [anon_sym_DASH] = ACTIONS(1239),
    [anon_sym_PERCENT] = ACTIONS(1243),
    [anon_sym_STAR_STAR] = ACTIONS(1243),
    [anon_sym_LT_EQ] = ACTIONS(1243),
    [anon_sym_EQ_EQ] = ACTIONS(1241),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1243),
    [anon_sym_BANG_EQ] = ACTIONS(1241),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1243),
    [anon_sym_GT_EQ] = ACTIONS(1243),
    [anon_sym_QMARK_QMARK] = ACTIONS(1243),
    [anon_sym_instanceof] = ACTIONS(1241),
    [anon_sym_BANG] = ACTIONS(1239),
    [anon_sym_TILDE] = ACTIONS(1237),
    [anon_sym_void] = ACTIONS(1239),
    [anon_sym_delete] = ACTIONS(1239),
    [anon_sym_PLUS_PLUS] = ACTIONS(1237),
    [anon_sym_DASH_DASH] = ACTIONS(1237),
    [anon_sym_DQUOTE] = ACTIONS(1237),
    [anon_sym_SQUOTE] = ACTIONS(1237),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1237),
    [sym_number] = ACTIONS(1237),
    [sym_this] = ACTIONS(1239),
    [sym_super] = ACTIONS(1239),
    [sym_true] = ACTIONS(1239),
    [sym_false] = ACTIONS(1239),
    [sym_null] = ACTIONS(1239),
    [sym_undefined] = ACTIONS(1239),
    [anon_sym_AT] = ACTIONS(1237),
    [anon_sym_static] = ACTIONS(1239),
    [anon_sym_abstract] = ACTIONS(1239),
    [anon_sym_get] = ACTIONS(1239),
    [anon_sym_set] = ACTIONS(1239),
    [anon_sym_declare] = ACTIONS(1239),
    [anon_sym_public] = ACTIONS(1239),
    [anon_sym_private] = ACTIONS(1239),
    [anon_sym_protected] = ACTIONS(1239),
    [anon_sym_module] = ACTIONS(1239),
    [anon_sym_any] = ACTIONS(1239),
    [anon_sym_number] = ACTIONS(1239),
    [anon_sym_boolean] = ACTIONS(1239),
    [anon_sym_string] = ACTIONS(1239),
    [anon_sym_symbol] = ACTIONS(1239),
    [anon_sym_interface] = ACTIONS(1239),
    [anon_sym_enum] = ACTIONS(1239),
    [sym_readonly] = ACTIONS(1239),
    [sym__automatic_semicolon] = ACTIONS(1245),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(1247),
    [sym_identifier] = ACTIONS(1249),
    [anon_sym_export] = ACTIONS(1249),
    [anon_sym_STAR] = ACTIONS(1249),
    [anon_sym_default] = ACTIONS(1249),
    [anon_sym_as] = ACTIONS(1249),
    [anon_sym_namespace] = ACTIONS(1249),
    [anon_sym_LBRACE] = ACTIONS(1247),
    [anon_sym_COMMA] = ACTIONS(1247),
    [anon_sym_RBRACE] = ACTIONS(1247),
    [anon_sym_type] = ACTIONS(1249),
    [anon_sym_typeof] = ACTIONS(1249),
    [anon_sym_import] = ACTIONS(1249),
    [anon_sym_var] = ACTIONS(1249),
    [anon_sym_let] = ACTIONS(1249),
    [anon_sym_const] = ACTIONS(1249),
    [anon_sym_if] = ACTIONS(1249),
    [anon_sym_else] = ACTIONS(1249),
    [anon_sym_switch] = ACTIONS(1249),
    [anon_sym_for] = ACTIONS(1249),
    [anon_sym_LPAREN] = ACTIONS(1247),
    [anon_sym_await] = ACTIONS(1249),
    [anon_sym_in] = ACTIONS(1249),
    [anon_sym_while] = ACTIONS(1249),
    [anon_sym_do] = ACTIONS(1249),
    [anon_sym_try] = ACTIONS(1249),
    [anon_sym_with] = ACTIONS(1249),
    [anon_sym_break] = ACTIONS(1249),
    [anon_sym_continue] = ACTIONS(1249),
    [anon_sym_debugger] = ACTIONS(1249),
    [anon_sym_return] = ACTIONS(1249),
    [anon_sym_throw] = ACTIONS(1249),
    [anon_sym_SEMI] = ACTIONS(1247),
    [anon_sym_case] = ACTIONS(1249),
    [anon_sym_yield] = ACTIONS(1249),
    [anon_sym_LBRACK] = ACTIONS(1247),
    [anon_sym_LT] = ACTIONS(1249),
    [anon_sym_GT] = ACTIONS(1249),
    [anon_sym_SLASH] = ACTIONS(1249),
    [anon_sym_DOT] = ACTIONS(1249),
    [anon_sym_class] = ACTIONS(1249),
    [anon_sym_async] = ACTIONS(1249),
    [anon_sym_function] = ACTIONS(1249),
    [anon_sym_new] = ACTIONS(1249),
    [anon_sym_QMARK] = ACTIONS(1249),
    [anon_sym_AMP_AMP] = ACTIONS(1247),
    [anon_sym_PIPE_PIPE] = ACTIONS(1247),
    [anon_sym_GT_GT] = ACTIONS(1249),
    [anon_sym_GT_GT_GT] = ACTIONS(1247),
    [anon_sym_LT_LT] = ACTIONS(1247),
    [anon_sym_AMP] = ACTIONS(1249),
    [anon_sym_CARET] = ACTIONS(1247),
    [anon_sym_PIPE] = ACTIONS(1249),
    [anon_sym_PLUS] = ACTIONS(1249),
    [anon_sym_DASH] = ACTIONS(1249),
    [anon_sym_PERCENT] = ACTIONS(1247),
    [anon_sym_STAR_STAR] = ACTIONS(1247),
    [anon_sym_LT_EQ] = ACTIONS(1247),
    [anon_sym_EQ_EQ] = ACTIONS(1249),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1247),
    [anon_sym_BANG_EQ] = ACTIONS(1249),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1247),
    [anon_sym_GT_EQ] = ACTIONS(1247),
    [anon_sym_QMARK_QMARK] = ACTIONS(1247),
    [anon_sym_instanceof] = ACTIONS(1249),
    [anon_sym_BANG] = ACTIONS(1249),
    [anon_sym_TILDE] = ACTIONS(1247),
    [anon_sym_void] = ACTIONS(1249),
    [anon_sym_delete] = ACTIONS(1249),
    [anon_sym_PLUS_PLUS] = ACTIONS(1247),
    [anon_sym_DASH_DASH] = ACTIONS(1247),
    [anon_sym_DQUOTE] = ACTIONS(1247),
    [anon_sym_SQUOTE] = ACTIONS(1247),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1247),
    [sym_number] = ACTIONS(1247),
    [sym_this] = ACTIONS(1249),
    [sym_super] = ACTIONS(1249),
    [sym_true] = ACTIONS(1249),
    [sym_false] = ACTIONS(1249),
    [sym_null] = ACTIONS(1249),
    [sym_undefined] = ACTIONS(1249),
    [anon_sym_AT] = ACTIONS(1247),
    [anon_sym_static] = ACTIONS(1249),
    [anon_sym_abstract] = ACTIONS(1249),
    [anon_sym_get] = ACTIONS(1249),
    [anon_sym_set] = ACTIONS(1249),
    [anon_sym_declare] = ACTIONS(1249),
    [anon_sym_public] = ACTIONS(1249),
    [anon_sym_private] = ACTIONS(1249),
    [anon_sym_protected] = ACTIONS(1249),
    [anon_sym_module] = ACTIONS(1249),
    [anon_sym_any] = ACTIONS(1249),
    [anon_sym_number] = ACTIONS(1249),
    [anon_sym_boolean] = ACTIONS(1249),
    [anon_sym_string] = ACTIONS(1249),
    [anon_sym_symbol] = ACTIONS(1249),
    [anon_sym_interface] = ACTIONS(1249),
    [anon_sym_enum] = ACTIONS(1249),
    [sym_readonly] = ACTIONS(1249),
    [sym__automatic_semicolon] = ACTIONS(1247),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(1251),
    [sym_identifier] = ACTIONS(1253),
    [anon_sym_export] = ACTIONS(1253),
    [anon_sym_STAR] = ACTIONS(1255),
    [anon_sym_default] = ACTIONS(1253),
    [anon_sym_as] = ACTIONS(1255),
    [anon_sym_namespace] = ACTIONS(1253),
    [anon_sym_LBRACE] = ACTIONS(1251),
    [anon_sym_COMMA] = ACTIONS(1257),
    [anon_sym_RBRACE] = ACTIONS(1251),
    [anon_sym_type] = ACTIONS(1253),
    [anon_sym_typeof] = ACTIONS(1253),
    [anon_sym_import] = ACTIONS(1253),
    [anon_sym_var] = ACTIONS(1253),
    [anon_sym_let] = ACTIONS(1253),
    [anon_sym_const] = ACTIONS(1253),
    [anon_sym_if] = ACTIONS(1253),
    [anon_sym_else] = ACTIONS(1253),
    [anon_sym_switch] = ACTIONS(1253),
    [anon_sym_for] = ACTIONS(1253),
    [anon_sym_LPAREN] = ACTIONS(1251),
    [anon_sym_await] = ACTIONS(1253),
    [anon_sym_in] = ACTIONS(1255),
    [anon_sym_while] = ACTIONS(1253),
    [anon_sym_do] = ACTIONS(1253),
    [anon_sym_try] = ACTIONS(1253),
    [anon_sym_with] = ACTIONS(1253),
    [anon_sym_break] = ACTIONS(1253),
    [anon_sym_continue] = ACTIONS(1253),
    [anon_sym_debugger] = ACTIONS(1253),
    [anon_sym_return] = ACTIONS(1253),
    [anon_sym_throw] = ACTIONS(1253),
    [anon_sym_SEMI] = ACTIONS(1251),
    [anon_sym_case] = ACTIONS(1253),
    [anon_sym_yield] = ACTIONS(1253),
    [anon_sym_LBRACK] = ACTIONS(1251),
    [anon_sym_LT] = ACTIONS(1253),
    [anon_sym_GT] = ACTIONS(1255),
    [anon_sym_SLASH] = ACTIONS(1253),
    [anon_sym_DOT] = ACTIONS(1255),
    [anon_sym_class] = ACTIONS(1253),
    [anon_sym_async] = ACTIONS(1253),
    [anon_sym_function] = ACTIONS(1253),
    [anon_sym_new] = ACTIONS(1253),
    [anon_sym_QMARK] = ACTIONS(1255),
    [anon_sym_AMP_AMP] = ACTIONS(1257),
    [anon_sym_PIPE_PIPE] = ACTIONS(1257),
    [anon_sym_GT_GT] = ACTIONS(1255),
    [anon_sym_GT_GT_GT] = ACTIONS(1257),
    [anon_sym_LT_LT] = ACTIONS(1257),
    [anon_sym_AMP] = ACTIONS(1255),
    [anon_sym_CARET] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1255),
    [anon_sym_PLUS] = ACTIONS(1253),
    [anon_sym_DASH] = ACTIONS(1253),
    [anon_sym_PERCENT] = ACTIONS(1257),
    [anon_sym_STAR_STAR] = ACTIONS(1257),
    [anon_sym_LT_EQ] = ACTIONS(1257),
    [anon_sym_EQ_EQ] = ACTIONS(1255),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1257),
    [anon_sym_BANG_EQ] = ACTIONS(1255),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1257),
    [anon_sym_GT_EQ] = ACTIONS(1257),
    [anon_sym_QMARK_QMARK] = ACTIONS(1257),
    [anon_sym_instanceof] = ACTIONS(1255),
    [anon_sym_BANG] = ACTIONS(1253),
    [anon_sym_TILDE] = ACTIONS(1251),
    [anon_sym_void] = ACTIONS(1253),
    [anon_sym_delete] = ACTIONS(1253),
    [anon_sym_PLUS_PLUS] = ACTIONS(1251),
    [anon_sym_DASH_DASH] = ACTIONS(1251),
    [anon_sym_DQUOTE] = ACTIONS(1251),
    [anon_sym_SQUOTE] = ACTIONS(1251),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1251),
    [sym_number] = ACTIONS(1251),
    [sym_this] = ACTIONS(1253),
    [sym_super] = ACTIONS(1253),
    [sym_true] = ACTIONS(1253),
    [sym_false] = ACTIONS(1253),
    [sym_null] = ACTIONS(1253),
    [sym_undefined] = ACTIONS(1253),
    [anon_sym_AT] = ACTIONS(1251),
    [anon_sym_static] = ACTIONS(1253),
    [anon_sym_abstract] = ACTIONS(1253),
    [anon_sym_get] = ACTIONS(1253),
    [anon_sym_set] = ACTIONS(1253),
    [anon_sym_declare] = ACTIONS(1253),
    [anon_sym_public] = ACTIONS(1253),
    [anon_sym_private] = ACTIONS(1253),
    [anon_sym_protected] = ACTIONS(1253),
    [anon_sym_module] = ACTIONS(1253),
    [anon_sym_any] = ACTIONS(1253),
    [anon_sym_number] = ACTIONS(1253),
    [anon_sym_boolean] = ACTIONS(1253),
    [anon_sym_string] = ACTIONS(1253),
    [anon_sym_symbol] = ACTIONS(1253),
    [anon_sym_interface] = ACTIONS(1253),
    [anon_sym_enum] = ACTIONS(1253),
    [sym_readonly] = ACTIONS(1253),
    [sym__automatic_semicolon] = ACTIONS(1259),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(1233),
    [sym_identifier] = ACTIONS(1235),
    [anon_sym_export] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1235),
    [anon_sym_default] = ACTIONS(1235),
    [anon_sym_as] = ACTIONS(1235),
    [anon_sym_namespace] = ACTIONS(1235),
    [anon_sym_LBRACE] = ACTIONS(1233),
    [anon_sym_COMMA] = ACTIONS(1233),
    [anon_sym_RBRACE] = ACTIONS(1233),
    [anon_sym_type] = ACTIONS(1235),
    [anon_sym_typeof] = ACTIONS(1235),
    [anon_sym_import] = ACTIONS(1235),
    [anon_sym_var] = ACTIONS(1235),
    [anon_sym_let] = ACTIONS(1235),
    [anon_sym_const] = ACTIONS(1235),
    [anon_sym_if] = ACTIONS(1235),
    [anon_sym_else] = ACTIONS(1235),
    [anon_sym_switch] = ACTIONS(1235),
    [anon_sym_for] = ACTIONS(1235),
    [anon_sym_LPAREN] = ACTIONS(1233),
    [anon_sym_await] = ACTIONS(1235),
    [anon_sym_in] = ACTIONS(1235),
    [anon_sym_while] = ACTIONS(1235),
    [anon_sym_do] = ACTIONS(1235),
    [anon_sym_try] = ACTIONS(1235),
    [anon_sym_with] = ACTIONS(1235),
    [anon_sym_break] = ACTIONS(1235),
    [anon_sym_continue] = ACTIONS(1235),
    [anon_sym_debugger] = ACTIONS(1235),
    [anon_sym_return] = ACTIONS(1235),
    [anon_sym_throw] = ACTIONS(1235),
    [anon_sym_SEMI] = ACTIONS(1233),
    [anon_sym_case] = ACTIONS(1235),
    [anon_sym_yield] = ACTIONS(1235),
    [anon_sym_LBRACK] = ACTIONS(1233),
    [anon_sym_LT] = ACTIONS(1235),
    [anon_sym_GT] = ACTIONS(1235),
    [anon_sym_SLASH] = ACTIONS(1235),
    [anon_sym_DOT] = ACTIONS(1235),
    [anon_sym_class] = ACTIONS(1235),
    [anon_sym_async] = ACTIONS(1235),
    [anon_sym_function] = ACTIONS(1235),
    [anon_sym_new] = ACTIONS(1235),
    [anon_sym_QMARK] = ACTIONS(1235),
    [anon_sym_AMP_AMP] = ACTIONS(1233),
    [anon_sym_PIPE_PIPE] = ACTIONS(1233),
    [anon_sym_GT_GT] = ACTIONS(1235),
    [anon_sym_GT_GT_GT] = ACTIONS(1233),
    [anon_sym_LT_LT] = ACTIONS(1233),
    [anon_sym_AMP] = ACTIONS(1235),
    [anon_sym_CARET] = ACTIONS(1233),
    [anon_sym_PIPE] = ACTIONS(1235),
    [anon_sym_PLUS] = ACTIONS(1235),
    [anon_sym_DASH] = ACTIONS(1235),
    [anon_sym_PERCENT] = ACTIONS(1233),
    [anon_sym_STAR_STAR] = ACTIONS(1233),
    [anon_sym_LT_EQ] = ACTIONS(1233),
    [anon_sym_EQ_EQ] = ACTIONS(1235),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1233),
    [anon_sym_BANG_EQ] = ACTIONS(1235),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1233),
    [anon_sym_GT_EQ] = ACTIONS(1233),
    [anon_sym_QMARK_QMARK] = ACTIONS(1233),
    [anon_sym_instanceof] = ACTIONS(1235),
    [anon_sym_BANG] = ACTIONS(1235),
    [anon_sym_TILDE] = ACTIONS(1233),
    [anon_sym_void] = ACTIONS(1235),
    [anon_sym_delete] = ACTIONS(1235),
    [anon_sym_PLUS_PLUS] = ACTIONS(1233),
    [anon_sym_DASH_DASH] = ACTIONS(1233),
    [anon_sym_DQUOTE] = ACTIONS(1233),
    [anon_sym_SQUOTE] = ACTIONS(1233),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1233),
    [sym_number] = ACTIONS(1233),
    [sym_this] = ACTIONS(1235),
    [sym_super] = ACTIONS(1235),
    [sym_true] = ACTIONS(1235),
    [sym_false] = ACTIONS(1235),
    [sym_null] = ACTIONS(1235),
    [sym_undefined] = ACTIONS(1235),
    [anon_sym_AT] = ACTIONS(1233),
    [anon_sym_static] = ACTIONS(1235),
    [anon_sym_abstract] = ACTIONS(1235),
    [anon_sym_get] = ACTIONS(1235),
    [anon_sym_set] = ACTIONS(1235),
    [anon_sym_declare] = ACTIONS(1235),
    [anon_sym_public] = ACTIONS(1235),
    [anon_sym_private] = ACTIONS(1235),
    [anon_sym_protected] = ACTIONS(1235),
    [anon_sym_module] = ACTIONS(1235),
    [anon_sym_any] = ACTIONS(1235),
    [anon_sym_number] = ACTIONS(1235),
    [anon_sym_boolean] = ACTIONS(1235),
    [anon_sym_string] = ACTIONS(1235),
    [anon_sym_symbol] = ACTIONS(1235),
    [anon_sym_interface] = ACTIONS(1235),
    [anon_sym_enum] = ACTIONS(1235),
    [sym_readonly] = ACTIONS(1235),
    [sym__automatic_semicolon] = ACTIONS(1261),
  },
  [127] = {
    [ts_builtin_sym_end] = ACTIONS(1263),
    [sym_identifier] = ACTIONS(1265),
    [anon_sym_export] = ACTIONS(1265),
    [anon_sym_STAR] = ACTIONS(1265),
    [anon_sym_default] = ACTIONS(1265),
    [anon_sym_as] = ACTIONS(1265),
    [anon_sym_namespace] = ACTIONS(1265),
    [anon_sym_LBRACE] = ACTIONS(1263),
    [anon_sym_COMMA] = ACTIONS(1263),
    [anon_sym_RBRACE] = ACTIONS(1263),
    [anon_sym_type] = ACTIONS(1265),
    [anon_sym_typeof] = ACTIONS(1265),
    [anon_sym_import] = ACTIONS(1265),
    [anon_sym_var] = ACTIONS(1265),
    [anon_sym_let] = ACTIONS(1265),
    [anon_sym_const] = ACTIONS(1265),
    [anon_sym_if] = ACTIONS(1265),
    [anon_sym_else] = ACTIONS(1265),
    [anon_sym_switch] = ACTIONS(1265),
    [anon_sym_for] = ACTIONS(1265),
    [anon_sym_LPAREN] = ACTIONS(1263),
    [anon_sym_await] = ACTIONS(1265),
    [anon_sym_in] = ACTIONS(1265),
    [anon_sym_while] = ACTIONS(1265),
    [anon_sym_do] = ACTIONS(1265),
    [anon_sym_try] = ACTIONS(1265),
    [anon_sym_with] = ACTIONS(1265),
    [anon_sym_break] = ACTIONS(1265),
    [anon_sym_continue] = ACTIONS(1265),
    [anon_sym_debugger] = ACTIONS(1265),
    [anon_sym_return] = ACTIONS(1265),
    [anon_sym_throw] = ACTIONS(1265),
    [anon_sym_SEMI] = ACTIONS(1263),
    [anon_sym_case] = ACTIONS(1265),
    [anon_sym_yield] = ACTIONS(1265),
    [anon_sym_LBRACK] = ACTIONS(1263),
    [anon_sym_LT] = ACTIONS(1265),
    [anon_sym_GT] = ACTIONS(1265),
    [anon_sym_SLASH] = ACTIONS(1265),
    [anon_sym_DOT] = ACTIONS(1265),
    [anon_sym_class] = ACTIONS(1265),
    [anon_sym_async] = ACTIONS(1265),
    [anon_sym_function] = ACTIONS(1265),
    [anon_sym_new] = ACTIONS(1265),
    [anon_sym_QMARK] = ACTIONS(1265),
    [anon_sym_AMP_AMP] = ACTIONS(1263),
    [anon_sym_PIPE_PIPE] = ACTIONS(1263),
    [anon_sym_GT_GT] = ACTIONS(1265),
    [anon_sym_GT_GT_GT] = ACTIONS(1263),
    [anon_sym_LT_LT] = ACTIONS(1263),
    [anon_sym_AMP] = ACTIONS(1265),
    [anon_sym_CARET] = ACTIONS(1263),
    [anon_sym_PIPE] = ACTIONS(1265),
    [anon_sym_PLUS] = ACTIONS(1265),
    [anon_sym_DASH] = ACTIONS(1265),
    [anon_sym_PERCENT] = ACTIONS(1263),
    [anon_sym_STAR_STAR] = ACTIONS(1263),
    [anon_sym_LT_EQ] = ACTIONS(1263),
    [anon_sym_EQ_EQ] = ACTIONS(1265),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1263),
    [anon_sym_BANG_EQ] = ACTIONS(1265),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1263),
    [anon_sym_GT_EQ] = ACTIONS(1263),
    [anon_sym_QMARK_QMARK] = ACTIONS(1263),
    [anon_sym_instanceof] = ACTIONS(1265),
    [anon_sym_BANG] = ACTIONS(1265),
    [anon_sym_TILDE] = ACTIONS(1263),
    [anon_sym_void] = ACTIONS(1265),
    [anon_sym_delete] = ACTIONS(1265),
    [anon_sym_PLUS_PLUS] = ACTIONS(1263),
    [anon_sym_DASH_DASH] = ACTIONS(1263),
    [anon_sym_DQUOTE] = ACTIONS(1263),
    [anon_sym_SQUOTE] = ACTIONS(1263),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1263),
    [sym_number] = ACTIONS(1263),
    [sym_this] = ACTIONS(1265),
    [sym_super] = ACTIONS(1265),
    [sym_true] = ACTIONS(1265),
    [sym_false] = ACTIONS(1265),
    [sym_null] = ACTIONS(1265),
    [sym_undefined] = ACTIONS(1265),
    [anon_sym_AT] = ACTIONS(1263),
    [anon_sym_static] = ACTIONS(1265),
    [anon_sym_abstract] = ACTIONS(1265),
    [anon_sym_get] = ACTIONS(1265),
    [anon_sym_set] = ACTIONS(1265),
    [anon_sym_declare] = ACTIONS(1265),
    [anon_sym_public] = ACTIONS(1265),
    [anon_sym_private] = ACTIONS(1265),
    [anon_sym_protected] = ACTIONS(1265),
    [anon_sym_module] = ACTIONS(1265),
    [anon_sym_any] = ACTIONS(1265),
    [anon_sym_number] = ACTIONS(1265),
    [anon_sym_boolean] = ACTIONS(1265),
    [anon_sym_string] = ACTIONS(1265),
    [anon_sym_symbol] = ACTIONS(1265),
    [anon_sym_interface] = ACTIONS(1265),
    [anon_sym_enum] = ACTIONS(1265),
    [sym_readonly] = ACTIONS(1265),
    [sym__automatic_semicolon] = ACTIONS(1263),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(1267),
    [sym_identifier] = ACTIONS(1269),
    [anon_sym_export] = ACTIONS(1269),
    [anon_sym_STAR] = ACTIONS(1271),
    [anon_sym_default] = ACTIONS(1269),
    [anon_sym_as] = ACTIONS(1271),
    [anon_sym_namespace] = ACTIONS(1269),
    [anon_sym_LBRACE] = ACTIONS(1267),
    [anon_sym_COMMA] = ACTIONS(1273),
    [anon_sym_RBRACE] = ACTIONS(1267),
    [anon_sym_type] = ACTIONS(1269),
    [anon_sym_typeof] = ACTIONS(1269),
    [anon_sym_import] = ACTIONS(1269),
    [anon_sym_var] = ACTIONS(1269),
    [anon_sym_let] = ACTIONS(1269),
    [anon_sym_const] = ACTIONS(1269),
    [anon_sym_if] = ACTIONS(1269),
    [anon_sym_else] = ACTIONS(1269),
    [anon_sym_switch] = ACTIONS(1269),
    [anon_sym_for] = ACTIONS(1269),
    [anon_sym_LPAREN] = ACTIONS(1267),
    [anon_sym_await] = ACTIONS(1269),
    [anon_sym_in] = ACTIONS(1271),
    [anon_sym_while] = ACTIONS(1269),
    [anon_sym_do] = ACTIONS(1269),
    [anon_sym_try] = ACTIONS(1269),
    [anon_sym_with] = ACTIONS(1269),
    [anon_sym_break] = ACTIONS(1269),
    [anon_sym_continue] = ACTIONS(1269),
    [anon_sym_debugger] = ACTIONS(1269),
    [anon_sym_return] = ACTIONS(1269),
    [anon_sym_throw] = ACTIONS(1269),
    [anon_sym_SEMI] = ACTIONS(1267),
    [anon_sym_case] = ACTIONS(1269),
    [anon_sym_yield] = ACTIONS(1269),
    [anon_sym_LBRACK] = ACTIONS(1267),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1271),
    [anon_sym_SLASH] = ACTIONS(1269),
    [anon_sym_DOT] = ACTIONS(1271),
    [anon_sym_class] = ACTIONS(1269),
    [anon_sym_async] = ACTIONS(1269),
    [anon_sym_function] = ACTIONS(1269),
    [anon_sym_new] = ACTIONS(1269),
    [anon_sym_QMARK] = ACTIONS(1271),
    [anon_sym_AMP_AMP] = ACTIONS(1273),
    [anon_sym_PIPE_PIPE] = ACTIONS(1273),
    [anon_sym_GT_GT] = ACTIONS(1271),
    [anon_sym_GT_GT_GT] = ACTIONS(1273),
    [anon_sym_LT_LT] = ACTIONS(1273),
    [anon_sym_AMP] = ACTIONS(1271),
    [anon_sym_CARET] = ACTIONS(1273),
    [anon_sym_PIPE] = ACTIONS(1271),
    [anon_sym_PLUS] = ACTIONS(1269),
    [anon_sym_DASH] = ACTIONS(1269),
    [anon_sym_PERCENT] = ACTIONS(1273),
    [anon_sym_STAR_STAR] = ACTIONS(1273),
    [anon_sym_LT_EQ] = ACTIONS(1273),
    [anon_sym_EQ_EQ] = ACTIONS(1271),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1273),
    [anon_sym_BANG_EQ] = ACTIONS(1271),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1273),
    [anon_sym_GT_EQ] = ACTIONS(1273),
    [anon_sym_QMARK_QMARK] = ACTIONS(1273),
    [anon_sym_instanceof] = ACTIONS(1271),
    [anon_sym_BANG] = ACTIONS(1269),
    [anon_sym_TILDE] = ACTIONS(1267),
    [anon_sym_void] = ACTIONS(1269),
    [anon_sym_delete] = ACTIONS(1269),
    [anon_sym_PLUS_PLUS] = ACTIONS(1267),
    [anon_sym_DASH_DASH] = ACTIONS(1267),
    [anon_sym_DQUOTE] = ACTIONS(1267),
    [anon_sym_SQUOTE] = ACTIONS(1267),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1267),
    [sym_number] = ACTIONS(1267),
    [sym_this] = ACTIONS(1269),
    [sym_super] = ACTIONS(1269),
    [sym_true] = ACTIONS(1269),
    [sym_false] = ACTIONS(1269),
    [sym_null] = ACTIONS(1269),
    [sym_undefined] = ACTIONS(1269),
    [anon_sym_AT] = ACTIONS(1267),
    [anon_sym_static] = ACTIONS(1269),
    [anon_sym_abstract] = ACTIONS(1269),
    [anon_sym_get] = ACTIONS(1269),
    [anon_sym_set] = ACTIONS(1269),
    [anon_sym_declare] = ACTIONS(1269),
    [anon_sym_public] = ACTIONS(1269),
    [anon_sym_private] = ACTIONS(1269),
    [anon_sym_protected] = ACTIONS(1269),
    [anon_sym_module] = ACTIONS(1269),
    [anon_sym_any] = ACTIONS(1269),
    [anon_sym_number] = ACTIONS(1269),
    [anon_sym_boolean] = ACTIONS(1269),
    [anon_sym_string] = ACTIONS(1269),
    [anon_sym_symbol] = ACTIONS(1269),
    [anon_sym_interface] = ACTIONS(1269),
    [anon_sym_enum] = ACTIONS(1269),
    [sym_readonly] = ACTIONS(1269),
    [sym__automatic_semicolon] = ACTIONS(1273),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(1275),
    [sym_identifier] = ACTIONS(1277),
    [anon_sym_export] = ACTIONS(1277),
    [anon_sym_STAR] = ACTIONS(1279),
    [anon_sym_default] = ACTIONS(1277),
    [anon_sym_as] = ACTIONS(1279),
    [anon_sym_namespace] = ACTIONS(1277),
    [anon_sym_LBRACE] = ACTIONS(1275),
    [anon_sym_COMMA] = ACTIONS(1281),
    [anon_sym_RBRACE] = ACTIONS(1275),
    [anon_sym_type] = ACTIONS(1277),
    [anon_sym_typeof] = ACTIONS(1277),
    [anon_sym_import] = ACTIONS(1277),
    [anon_sym_var] = ACTIONS(1277),
    [anon_sym_let] = ACTIONS(1277),
    [anon_sym_const] = ACTIONS(1277),
    [anon_sym_if] = ACTIONS(1277),
    [anon_sym_else] = ACTIONS(1277),
    [anon_sym_switch] = ACTIONS(1277),
    [anon_sym_for] = ACTIONS(1277),
    [anon_sym_LPAREN] = ACTIONS(1275),
    [anon_sym_await] = ACTIONS(1277),
    [anon_sym_in] = ACTIONS(1279),
    [anon_sym_while] = ACTIONS(1277),
    [anon_sym_do] = ACTIONS(1277),
    [anon_sym_try] = ACTIONS(1277),
    [anon_sym_with] = ACTIONS(1277),
    [anon_sym_break] = ACTIONS(1277),
    [anon_sym_continue] = ACTIONS(1277),
    [anon_sym_debugger] = ACTIONS(1277),
    [anon_sym_return] = ACTIONS(1277),
    [anon_sym_throw] = ACTIONS(1277),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_case] = ACTIONS(1277),
    [anon_sym_yield] = ACTIONS(1277),
    [anon_sym_LBRACK] = ACTIONS(1275),
    [anon_sym_LT] = ACTIONS(1277),
    [anon_sym_GT] = ACTIONS(1279),
    [anon_sym_SLASH] = ACTIONS(1277),
    [anon_sym_DOT] = ACTIONS(1279),
    [anon_sym_class] = ACTIONS(1277),
    [anon_sym_async] = ACTIONS(1277),
    [anon_sym_function] = ACTIONS(1277),
    [anon_sym_new] = ACTIONS(1277),
    [anon_sym_QMARK] = ACTIONS(1279),
    [anon_sym_AMP_AMP] = ACTIONS(1281),
    [anon_sym_PIPE_PIPE] = ACTIONS(1281),
    [anon_sym_GT_GT] = ACTIONS(1279),
    [anon_sym_GT_GT_GT] = ACTIONS(1281),
    [anon_sym_LT_LT] = ACTIONS(1281),
    [anon_sym_AMP] = ACTIONS(1279),
    [anon_sym_CARET] = ACTIONS(1281),
    [anon_sym_PIPE] = ACTIONS(1279),
    [anon_sym_PLUS] = ACTIONS(1277),
    [anon_sym_DASH] = ACTIONS(1277),
    [anon_sym_PERCENT] = ACTIONS(1281),
    [anon_sym_STAR_STAR] = ACTIONS(1281),
    [anon_sym_LT_EQ] = ACTIONS(1281),
    [anon_sym_EQ_EQ] = ACTIONS(1279),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1281),
    [anon_sym_BANG_EQ] = ACTIONS(1279),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1281),
    [anon_sym_GT_EQ] = ACTIONS(1281),
    [anon_sym_QMARK_QMARK] = ACTIONS(1281),
    [anon_sym_instanceof] = ACTIONS(1279),
    [anon_sym_BANG] = ACTIONS(1277),
    [anon_sym_TILDE] = ACTIONS(1275),
    [anon_sym_void] = ACTIONS(1277),
    [anon_sym_delete] = ACTIONS(1277),
    [anon_sym_PLUS_PLUS] = ACTIONS(1275),
    [anon_sym_DASH_DASH] = ACTIONS(1275),
    [anon_sym_DQUOTE] = ACTIONS(1275),
    [anon_sym_SQUOTE] = ACTIONS(1275),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1275),
    [sym_number] = ACTIONS(1275),
    [sym_this] = ACTIONS(1277),
    [sym_super] = ACTIONS(1277),
    [sym_true] = ACTIONS(1277),
    [sym_false] = ACTIONS(1277),
    [sym_null] = ACTIONS(1277),
    [sym_undefined] = ACTIONS(1277),
    [anon_sym_AT] = ACTIONS(1275),
    [anon_sym_static] = ACTIONS(1277),
    [anon_sym_abstract] = ACTIONS(1277),
    [anon_sym_get] = ACTIONS(1277),
    [anon_sym_set] = ACTIONS(1277),
    [anon_sym_declare] = ACTIONS(1277),
    [anon_sym_public] = ACTIONS(1277),
    [anon_sym_private] = ACTIONS(1277),
    [anon_sym_protected] = ACTIONS(1277),
    [anon_sym_module] = ACTIONS(1277),
    [anon_sym_any] = ACTIONS(1277),
    [anon_sym_number] = ACTIONS(1277),
    [anon_sym_boolean] = ACTIONS(1277),
    [anon_sym_string] = ACTIONS(1277),
    [anon_sym_symbol] = ACTIONS(1277),
    [anon_sym_interface] = ACTIONS(1277),
    [anon_sym_enum] = ACTIONS(1277),
    [sym_readonly] = ACTIONS(1277),
    [sym__automatic_semicolon] = ACTIONS(1283),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(1285),
    [sym_identifier] = ACTIONS(1287),
    [anon_sym_export] = ACTIONS(1287),
    [anon_sym_STAR] = ACTIONS(1287),
    [anon_sym_default] = ACTIONS(1287),
    [anon_sym_as] = ACTIONS(1287),
    [anon_sym_namespace] = ACTIONS(1287),
    [anon_sym_LBRACE] = ACTIONS(1285),
    [anon_sym_COMMA] = ACTIONS(1285),
    [anon_sym_RBRACE] = ACTIONS(1285),
    [anon_sym_type] = ACTIONS(1287),
    [anon_sym_typeof] = ACTIONS(1287),
    [anon_sym_import] = ACTIONS(1287),
    [anon_sym_var] = ACTIONS(1287),
    [anon_sym_let] = ACTIONS(1287),
    [anon_sym_const] = ACTIONS(1287),
    [anon_sym_if] = ACTIONS(1287),
    [anon_sym_else] = ACTIONS(1287),
    [anon_sym_switch] = ACTIONS(1287),
    [anon_sym_for] = ACTIONS(1287),
    [anon_sym_LPAREN] = ACTIONS(1285),
    [anon_sym_await] = ACTIONS(1287),
    [anon_sym_in] = ACTIONS(1287),
    [anon_sym_while] = ACTIONS(1287),
    [anon_sym_do] = ACTIONS(1287),
    [anon_sym_try] = ACTIONS(1287),
    [anon_sym_with] = ACTIONS(1287),
    [anon_sym_break] = ACTIONS(1287),
    [anon_sym_continue] = ACTIONS(1287),
    [anon_sym_debugger] = ACTIONS(1287),
    [anon_sym_return] = ACTIONS(1287),
    [anon_sym_throw] = ACTIONS(1287),
    [anon_sym_SEMI] = ACTIONS(1285),
    [anon_sym_case] = ACTIONS(1287),
    [anon_sym_yield] = ACTIONS(1287),
    [anon_sym_LBRACK] = ACTIONS(1285),
    [anon_sym_LT] = ACTIONS(1287),
    [anon_sym_GT] = ACTIONS(1287),
    [anon_sym_SLASH] = ACTIONS(1287),
    [anon_sym_DOT] = ACTIONS(1287),
    [anon_sym_class] = ACTIONS(1287),
    [anon_sym_async] = ACTIONS(1287),
    [anon_sym_function] = ACTIONS(1287),
    [anon_sym_new] = ACTIONS(1287),
    [anon_sym_QMARK] = ACTIONS(1287),
    [anon_sym_AMP_AMP] = ACTIONS(1285),
    [anon_sym_PIPE_PIPE] = ACTIONS(1285),
    [anon_sym_GT_GT] = ACTIONS(1287),
    [anon_sym_GT_GT_GT] = ACTIONS(1285),
    [anon_sym_LT_LT] = ACTIONS(1285),
    [anon_sym_AMP] = ACTIONS(1287),
    [anon_sym_CARET] = ACTIONS(1285),
    [anon_sym_PIPE] = ACTIONS(1287),
    [anon_sym_PLUS] = ACTIONS(1287),
    [anon_sym_DASH] = ACTIONS(1287),
    [anon_sym_PERCENT] = ACTIONS(1285),
    [anon_sym_STAR_STAR] = ACTIONS(1285),
    [anon_sym_LT_EQ] = ACTIONS(1285),
    [anon_sym_EQ_EQ] = ACTIONS(1287),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1285),
    [anon_sym_BANG_EQ] = ACTIONS(1287),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1285),
    [anon_sym_GT_EQ] = ACTIONS(1285),
    [anon_sym_QMARK_QMARK] = ACTIONS(1285),
    [anon_sym_instanceof] = ACTIONS(1287),
    [anon_sym_BANG] = ACTIONS(1287),
    [anon_sym_TILDE] = ACTIONS(1285),
    [anon_sym_void] = ACTIONS(1287),
    [anon_sym_delete] = ACTIONS(1287),
    [anon_sym_PLUS_PLUS] = ACTIONS(1285),
    [anon_sym_DASH_DASH] = ACTIONS(1285),
    [anon_sym_DQUOTE] = ACTIONS(1285),
    [anon_sym_SQUOTE] = ACTIONS(1285),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1285),
    [sym_number] = ACTIONS(1285),
    [sym_this] = ACTIONS(1287),
    [sym_super] = ACTIONS(1287),
    [sym_true] = ACTIONS(1287),
    [sym_false] = ACTIONS(1287),
    [sym_null] = ACTIONS(1287),
    [sym_undefined] = ACTIONS(1287),
    [anon_sym_AT] = ACTIONS(1285),
    [anon_sym_static] = ACTIONS(1287),
    [anon_sym_abstract] = ACTIONS(1287),
    [anon_sym_get] = ACTIONS(1287),
    [anon_sym_set] = ACTIONS(1287),
    [anon_sym_declare] = ACTIONS(1287),
    [anon_sym_public] = ACTIONS(1287),
    [anon_sym_private] = ACTIONS(1287),
    [anon_sym_protected] = ACTIONS(1287),
    [anon_sym_module] = ACTIONS(1287),
    [anon_sym_any] = ACTIONS(1287),
    [anon_sym_number] = ACTIONS(1287),
    [anon_sym_boolean] = ACTIONS(1287),
    [anon_sym_string] = ACTIONS(1287),
    [anon_sym_symbol] = ACTIONS(1287),
    [anon_sym_interface] = ACTIONS(1287),
    [anon_sym_enum] = ACTIONS(1287),
    [sym_readonly] = ACTIONS(1287),
    [sym__automatic_semicolon] = ACTIONS(1285),
  },
  [131] = {
    [ts_builtin_sym_end] = ACTIONS(1289),
    [sym_identifier] = ACTIONS(1291),
    [anon_sym_export] = ACTIONS(1291),
    [anon_sym_STAR] = ACTIONS(1293),
    [anon_sym_default] = ACTIONS(1291),
    [anon_sym_as] = ACTIONS(1293),
    [anon_sym_namespace] = ACTIONS(1291),
    [anon_sym_LBRACE] = ACTIONS(1289),
    [anon_sym_COMMA] = ACTIONS(1295),
    [anon_sym_RBRACE] = ACTIONS(1289),
    [anon_sym_type] = ACTIONS(1291),
    [anon_sym_typeof] = ACTIONS(1291),
    [anon_sym_import] = ACTIONS(1291),
    [anon_sym_var] = ACTIONS(1291),
    [anon_sym_let] = ACTIONS(1291),
    [anon_sym_const] = ACTIONS(1291),
    [anon_sym_if] = ACTIONS(1291),
    [anon_sym_else] = ACTIONS(1291),
    [anon_sym_switch] = ACTIONS(1291),
    [anon_sym_for] = ACTIONS(1291),
    [anon_sym_LPAREN] = ACTIONS(1289),
    [anon_sym_await] = ACTIONS(1291),
    [anon_sym_in] = ACTIONS(1293),
    [anon_sym_while] = ACTIONS(1291),
    [anon_sym_do] = ACTIONS(1291),
    [anon_sym_try] = ACTIONS(1291),
    [anon_sym_with] = ACTIONS(1291),
    [anon_sym_break] = ACTIONS(1291),
    [anon_sym_continue] = ACTIONS(1291),
    [anon_sym_debugger] = ACTIONS(1291),
    [anon_sym_return] = ACTIONS(1291),
    [anon_sym_throw] = ACTIONS(1291),
    [anon_sym_SEMI] = ACTIONS(1289),
    [anon_sym_case] = ACTIONS(1291),
    [anon_sym_yield] = ACTIONS(1291),
    [anon_sym_LBRACK] = ACTIONS(1289),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_GT] = ACTIONS(1293),
    [anon_sym_SLASH] = ACTIONS(1291),
    [anon_sym_DOT] = ACTIONS(1293),
    [anon_sym_class] = ACTIONS(1291),
    [anon_sym_async] = ACTIONS(1291),
    [anon_sym_function] = ACTIONS(1291),
    [anon_sym_new] = ACTIONS(1291),
    [anon_sym_QMARK] = ACTIONS(1293),
    [anon_sym_AMP_AMP] = ACTIONS(1295),
    [anon_sym_PIPE_PIPE] = ACTIONS(1295),
    [anon_sym_GT_GT] = ACTIONS(1293),
    [anon_sym_GT_GT_GT] = ACTIONS(1295),
    [anon_sym_LT_LT] = ACTIONS(1295),
    [anon_sym_AMP] = ACTIONS(1293),
    [anon_sym_CARET] = ACTIONS(1295),
    [anon_sym_PIPE] = ACTIONS(1293),
    [anon_sym_PLUS] = ACTIONS(1291),
    [anon_sym_DASH] = ACTIONS(1291),
    [anon_sym_PERCENT] = ACTIONS(1295),
    [anon_sym_STAR_STAR] = ACTIONS(1295),
    [anon_sym_LT_EQ] = ACTIONS(1295),
    [anon_sym_EQ_EQ] = ACTIONS(1293),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1295),
    [anon_sym_BANG_EQ] = ACTIONS(1293),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1295),
    [anon_sym_GT_EQ] = ACTIONS(1295),
    [anon_sym_QMARK_QMARK] = ACTIONS(1295),
    [anon_sym_instanceof] = ACTIONS(1293),
    [anon_sym_BANG] = ACTIONS(1291),
    [anon_sym_TILDE] = ACTIONS(1289),
    [anon_sym_void] = ACTIONS(1291),
    [anon_sym_delete] = ACTIONS(1291),
    [anon_sym_PLUS_PLUS] = ACTIONS(1289),
    [anon_sym_DASH_DASH] = ACTIONS(1289),
    [anon_sym_DQUOTE] = ACTIONS(1289),
    [anon_sym_SQUOTE] = ACTIONS(1289),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1289),
    [sym_number] = ACTIONS(1289),
    [sym_this] = ACTIONS(1291),
    [sym_super] = ACTIONS(1291),
    [sym_true] = ACTIONS(1291),
    [sym_false] = ACTIONS(1291),
    [sym_null] = ACTIONS(1291),
    [sym_undefined] = ACTIONS(1291),
    [anon_sym_AT] = ACTIONS(1289),
    [anon_sym_static] = ACTIONS(1291),
    [anon_sym_abstract] = ACTIONS(1291),
    [anon_sym_get] = ACTIONS(1291),
    [anon_sym_set] = ACTIONS(1291),
    [anon_sym_declare] = ACTIONS(1291),
    [anon_sym_public] = ACTIONS(1291),
    [anon_sym_private] = ACTIONS(1291),
    [anon_sym_protected] = ACTIONS(1291),
    [anon_sym_module] = ACTIONS(1291),
    [anon_sym_any] = ACTIONS(1291),
    [anon_sym_number] = ACTIONS(1291),
    [anon_sym_boolean] = ACTIONS(1291),
    [anon_sym_string] = ACTIONS(1291),
    [anon_sym_symbol] = ACTIONS(1291),
    [anon_sym_interface] = ACTIONS(1291),
    [anon_sym_enum] = ACTIONS(1291),
    [sym_readonly] = ACTIONS(1291),
    [sym__automatic_semicolon] = ACTIONS(1297),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(1299),
    [sym_identifier] = ACTIONS(1301),
    [anon_sym_export] = ACTIONS(1301),
    [anon_sym_STAR] = ACTIONS(1303),
    [anon_sym_default] = ACTIONS(1301),
    [anon_sym_as] = ACTIONS(1303),
    [anon_sym_namespace] = ACTIONS(1301),
    [anon_sym_LBRACE] = ACTIONS(1299),
    [anon_sym_COMMA] = ACTIONS(1305),
    [anon_sym_RBRACE] = ACTIONS(1299),
    [anon_sym_type] = ACTIONS(1301),
    [anon_sym_typeof] = ACTIONS(1301),
    [anon_sym_import] = ACTIONS(1301),
    [anon_sym_var] = ACTIONS(1301),
    [anon_sym_let] = ACTIONS(1301),
    [anon_sym_const] = ACTIONS(1301),
    [anon_sym_if] = ACTIONS(1301),
    [anon_sym_else] = ACTIONS(1301),
    [anon_sym_switch] = ACTIONS(1301),
    [anon_sym_for] = ACTIONS(1301),
    [anon_sym_LPAREN] = ACTIONS(1299),
    [anon_sym_await] = ACTIONS(1301),
    [anon_sym_in] = ACTIONS(1303),
    [anon_sym_while] = ACTIONS(1301),
    [anon_sym_do] = ACTIONS(1301),
    [anon_sym_try] = ACTIONS(1301),
    [anon_sym_with] = ACTIONS(1301),
    [anon_sym_break] = ACTIONS(1301),
    [anon_sym_continue] = ACTIONS(1301),
    [anon_sym_debugger] = ACTIONS(1301),
    [anon_sym_return] = ACTIONS(1301),
    [anon_sym_throw] = ACTIONS(1301),
    [anon_sym_SEMI] = ACTIONS(1299),
    [anon_sym_case] = ACTIONS(1301),
    [anon_sym_yield] = ACTIONS(1301),
    [anon_sym_LBRACK] = ACTIONS(1299),
    [anon_sym_LT] = ACTIONS(1301),
    [anon_sym_GT] = ACTIONS(1303),
    [anon_sym_SLASH] = ACTIONS(1301),
    [anon_sym_DOT] = ACTIONS(1303),
    [anon_sym_class] = ACTIONS(1301),
    [anon_sym_async] = ACTIONS(1301),
    [anon_sym_function] = ACTIONS(1301),
    [anon_sym_new] = ACTIONS(1301),
    [anon_sym_QMARK] = ACTIONS(1303),
    [anon_sym_AMP_AMP] = ACTIONS(1305),
    [anon_sym_PIPE_PIPE] = ACTIONS(1305),
    [anon_sym_GT_GT] = ACTIONS(1303),
    [anon_sym_GT_GT_GT] = ACTIONS(1305),
    [anon_sym_LT_LT] = ACTIONS(1305),
    [anon_sym_AMP] = ACTIONS(1303),
    [anon_sym_CARET] = ACTIONS(1305),
    [anon_sym_PIPE] = ACTIONS(1303),
    [anon_sym_PLUS] = ACTIONS(1301),
    [anon_sym_DASH] = ACTIONS(1301),
    [anon_sym_PERCENT] = ACTIONS(1305),
    [anon_sym_STAR_STAR] = ACTIONS(1305),
    [anon_sym_LT_EQ] = ACTIONS(1305),
    [anon_sym_EQ_EQ] = ACTIONS(1303),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1305),
    [anon_sym_BANG_EQ] = ACTIONS(1303),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1305),
    [anon_sym_GT_EQ] = ACTIONS(1305),
    [anon_sym_QMARK_QMARK] = ACTIONS(1305),
    [anon_sym_instanceof] = ACTIONS(1303),
    [anon_sym_BANG] = ACTIONS(1301),
    [anon_sym_TILDE] = ACTIONS(1299),
    [anon_sym_void] = ACTIONS(1301),
    [anon_sym_delete] = ACTIONS(1301),
    [anon_sym_PLUS_PLUS] = ACTIONS(1299),
    [anon_sym_DASH_DASH] = ACTIONS(1299),
    [anon_sym_DQUOTE] = ACTIONS(1299),
    [anon_sym_SQUOTE] = ACTIONS(1299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1299),
    [sym_number] = ACTIONS(1299),
    [sym_this] = ACTIONS(1301),
    [sym_super] = ACTIONS(1301),
    [sym_true] = ACTIONS(1301),
    [sym_false] = ACTIONS(1301),
    [sym_null] = ACTIONS(1301),
    [sym_undefined] = ACTIONS(1301),
    [anon_sym_AT] = ACTIONS(1299),
    [anon_sym_static] = ACTIONS(1301),
    [anon_sym_abstract] = ACTIONS(1301),
    [anon_sym_get] = ACTIONS(1301),
    [anon_sym_set] = ACTIONS(1301),
    [anon_sym_declare] = ACTIONS(1301),
    [anon_sym_public] = ACTIONS(1301),
    [anon_sym_private] = ACTIONS(1301),
    [anon_sym_protected] = ACTIONS(1301),
    [anon_sym_module] = ACTIONS(1301),
    [anon_sym_any] = ACTIONS(1301),
    [anon_sym_number] = ACTIONS(1301),
    [anon_sym_boolean] = ACTIONS(1301),
    [anon_sym_string] = ACTIONS(1301),
    [anon_sym_symbol] = ACTIONS(1301),
    [anon_sym_interface] = ACTIONS(1301),
    [anon_sym_enum] = ACTIONS(1301),
    [sym_readonly] = ACTIONS(1301),
    [sym__automatic_semicolon] = ACTIONS(1307),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(1309),
    [sym_identifier] = ACTIONS(1311),
    [anon_sym_export] = ACTIONS(1311),
    [anon_sym_STAR] = ACTIONS(1311),
    [anon_sym_default] = ACTIONS(1311),
    [anon_sym_as] = ACTIONS(1311),
    [anon_sym_namespace] = ACTIONS(1311),
    [anon_sym_LBRACE] = ACTIONS(1309),
    [anon_sym_COMMA] = ACTIONS(1309),
    [anon_sym_RBRACE] = ACTIONS(1309),
    [anon_sym_type] = ACTIONS(1311),
    [anon_sym_typeof] = ACTIONS(1311),
    [anon_sym_import] = ACTIONS(1311),
    [anon_sym_var] = ACTIONS(1311),
    [anon_sym_let] = ACTIONS(1311),
    [anon_sym_const] = ACTIONS(1311),
    [anon_sym_if] = ACTIONS(1311),
    [anon_sym_else] = ACTIONS(1311),
    [anon_sym_switch] = ACTIONS(1311),
    [anon_sym_for] = ACTIONS(1311),
    [anon_sym_LPAREN] = ACTIONS(1309),
    [anon_sym_await] = ACTIONS(1311),
    [anon_sym_in] = ACTIONS(1311),
    [anon_sym_while] = ACTIONS(1311),
    [anon_sym_do] = ACTIONS(1311),
    [anon_sym_try] = ACTIONS(1311),
    [anon_sym_with] = ACTIONS(1311),
    [anon_sym_break] = ACTIONS(1311),
    [anon_sym_continue] = ACTIONS(1311),
    [anon_sym_debugger] = ACTIONS(1311),
    [anon_sym_return] = ACTIONS(1311),
    [anon_sym_throw] = ACTIONS(1311),
    [anon_sym_SEMI] = ACTIONS(1309),
    [anon_sym_case] = ACTIONS(1311),
    [anon_sym_yield] = ACTIONS(1311),
    [anon_sym_LBRACK] = ACTIONS(1309),
    [anon_sym_LT] = ACTIONS(1311),
    [anon_sym_GT] = ACTIONS(1311),
    [anon_sym_SLASH] = ACTIONS(1311),
    [anon_sym_DOT] = ACTIONS(1311),
    [anon_sym_class] = ACTIONS(1311),
    [anon_sym_async] = ACTIONS(1311),
    [anon_sym_function] = ACTIONS(1311),
    [anon_sym_new] = ACTIONS(1311),
    [anon_sym_QMARK] = ACTIONS(1311),
    [anon_sym_AMP_AMP] = ACTIONS(1309),
    [anon_sym_PIPE_PIPE] = ACTIONS(1309),
    [anon_sym_GT_GT] = ACTIONS(1311),
    [anon_sym_GT_GT_GT] = ACTIONS(1309),
    [anon_sym_LT_LT] = ACTIONS(1309),
    [anon_sym_AMP] = ACTIONS(1311),
    [anon_sym_CARET] = ACTIONS(1309),
    [anon_sym_PIPE] = ACTIONS(1311),
    [anon_sym_PLUS] = ACTIONS(1311),
    [anon_sym_DASH] = ACTIONS(1311),
    [anon_sym_PERCENT] = ACTIONS(1309),
    [anon_sym_STAR_STAR] = ACTIONS(1309),
    [anon_sym_LT_EQ] = ACTIONS(1309),
    [anon_sym_EQ_EQ] = ACTIONS(1311),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1309),
    [anon_sym_BANG_EQ] = ACTIONS(1311),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1309),
    [anon_sym_GT_EQ] = ACTIONS(1309),
    [anon_sym_QMARK_QMARK] = ACTIONS(1309),
    [anon_sym_instanceof] = ACTIONS(1311),
    [anon_sym_BANG] = ACTIONS(1311),
    [anon_sym_TILDE] = ACTIONS(1309),
    [anon_sym_void] = ACTIONS(1311),
    [anon_sym_delete] = ACTIONS(1311),
    [anon_sym_PLUS_PLUS] = ACTIONS(1309),
    [anon_sym_DASH_DASH] = ACTIONS(1309),
    [anon_sym_DQUOTE] = ACTIONS(1309),
    [anon_sym_SQUOTE] = ACTIONS(1309),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1309),
    [sym_number] = ACTIONS(1309),
    [sym_this] = ACTIONS(1311),
    [sym_super] = ACTIONS(1311),
    [sym_true] = ACTIONS(1311),
    [sym_false] = ACTIONS(1311),
    [sym_null] = ACTIONS(1311),
    [sym_undefined] = ACTIONS(1311),
    [anon_sym_AT] = ACTIONS(1309),
    [anon_sym_static] = ACTIONS(1311),
    [anon_sym_abstract] = ACTIONS(1311),
    [anon_sym_get] = ACTIONS(1311),
    [anon_sym_set] = ACTIONS(1311),
    [anon_sym_declare] = ACTIONS(1311),
    [anon_sym_public] = ACTIONS(1311),
    [anon_sym_private] = ACTIONS(1311),
    [anon_sym_protected] = ACTIONS(1311),
    [anon_sym_module] = ACTIONS(1311),
    [anon_sym_any] = ACTIONS(1311),
    [anon_sym_number] = ACTIONS(1311),
    [anon_sym_boolean] = ACTIONS(1311),
    [anon_sym_string] = ACTIONS(1311),
    [anon_sym_symbol] = ACTIONS(1311),
    [anon_sym_interface] = ACTIONS(1311),
    [anon_sym_enum] = ACTIONS(1311),
    [sym_readonly] = ACTIONS(1311),
    [sym__automatic_semicolon] = ACTIONS(1309),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(1313),
    [sym_identifier] = ACTIONS(1315),
    [anon_sym_export] = ACTIONS(1315),
    [anon_sym_STAR] = ACTIONS(1317),
    [anon_sym_default] = ACTIONS(1315),
    [anon_sym_as] = ACTIONS(1317),
    [anon_sym_namespace] = ACTIONS(1315),
    [anon_sym_LBRACE] = ACTIONS(1313),
    [anon_sym_COMMA] = ACTIONS(1319),
    [anon_sym_RBRACE] = ACTIONS(1313),
    [anon_sym_type] = ACTIONS(1315),
    [anon_sym_typeof] = ACTIONS(1315),
    [anon_sym_import] = ACTIONS(1315),
    [anon_sym_var] = ACTIONS(1315),
    [anon_sym_let] = ACTIONS(1315),
    [anon_sym_const] = ACTIONS(1315),
    [anon_sym_if] = ACTIONS(1315),
    [anon_sym_else] = ACTIONS(1315),
    [anon_sym_switch] = ACTIONS(1315),
    [anon_sym_for] = ACTIONS(1315),
    [anon_sym_LPAREN] = ACTIONS(1313),
    [anon_sym_await] = ACTIONS(1315),
    [anon_sym_in] = ACTIONS(1317),
    [anon_sym_while] = ACTIONS(1315),
    [anon_sym_do] = ACTIONS(1315),
    [anon_sym_try] = ACTIONS(1315),
    [anon_sym_with] = ACTIONS(1315),
    [anon_sym_break] = ACTIONS(1315),
    [anon_sym_continue] = ACTIONS(1315),
    [anon_sym_debugger] = ACTIONS(1315),
    [anon_sym_return] = ACTIONS(1315),
    [anon_sym_throw] = ACTIONS(1315),
    [anon_sym_SEMI] = ACTIONS(1313),
    [anon_sym_case] = ACTIONS(1315),
    [anon_sym_yield] = ACTIONS(1315),
    [anon_sym_LBRACK] = ACTIONS(1313),
    [anon_sym_LT] = ACTIONS(1315),
    [anon_sym_GT] = ACTIONS(1317),
    [anon_sym_SLASH] = ACTIONS(1315),
    [anon_sym_DOT] = ACTIONS(1317),
    [anon_sym_class] = ACTIONS(1315),
    [anon_sym_async] = ACTIONS(1315),
    [anon_sym_function] = ACTIONS(1315),
    [anon_sym_new] = ACTIONS(1315),
    [anon_sym_QMARK] = ACTIONS(1317),
    [anon_sym_AMP_AMP] = ACTIONS(1319),
    [anon_sym_PIPE_PIPE] = ACTIONS(1319),
    [anon_sym_GT_GT] = ACTIONS(1317),
    [anon_sym_GT_GT_GT] = ACTIONS(1319),
    [anon_sym_LT_LT] = ACTIONS(1319),
    [anon_sym_AMP] = ACTIONS(1317),
    [anon_sym_CARET] = ACTIONS(1319),
    [anon_sym_PIPE] = ACTIONS(1317),
    [anon_sym_PLUS] = ACTIONS(1315),
    [anon_sym_DASH] = ACTIONS(1315),
    [anon_sym_PERCENT] = ACTIONS(1319),
    [anon_sym_STAR_STAR] = ACTIONS(1319),
    [anon_sym_LT_EQ] = ACTIONS(1319),
    [anon_sym_EQ_EQ] = ACTIONS(1317),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1319),
    [anon_sym_BANG_EQ] = ACTIONS(1317),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1319),
    [anon_sym_GT_EQ] = ACTIONS(1319),
    [anon_sym_QMARK_QMARK] = ACTIONS(1319),
    [anon_sym_instanceof] = ACTIONS(1317),
    [anon_sym_BANG] = ACTIONS(1315),
    [anon_sym_TILDE] = ACTIONS(1313),
    [anon_sym_void] = ACTIONS(1315),
    [anon_sym_delete] = ACTIONS(1315),
    [anon_sym_PLUS_PLUS] = ACTIONS(1313),
    [anon_sym_DASH_DASH] = ACTIONS(1313),
    [anon_sym_DQUOTE] = ACTIONS(1313),
    [anon_sym_SQUOTE] = ACTIONS(1313),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1313),
    [sym_number] = ACTIONS(1313),
    [sym_this] = ACTIONS(1315),
    [sym_super] = ACTIONS(1315),
    [sym_true] = ACTIONS(1315),
    [sym_false] = ACTIONS(1315),
    [sym_null] = ACTIONS(1315),
    [sym_undefined] = ACTIONS(1315),
    [anon_sym_AT] = ACTIONS(1313),
    [anon_sym_static] = ACTIONS(1315),
    [anon_sym_abstract] = ACTIONS(1315),
    [anon_sym_get] = ACTIONS(1315),
    [anon_sym_set] = ACTIONS(1315),
    [anon_sym_declare] = ACTIONS(1315),
    [anon_sym_public] = ACTIONS(1315),
    [anon_sym_private] = ACTIONS(1315),
    [anon_sym_protected] = ACTIONS(1315),
    [anon_sym_module] = ACTIONS(1315),
    [anon_sym_any] = ACTIONS(1315),
    [anon_sym_number] = ACTIONS(1315),
    [anon_sym_boolean] = ACTIONS(1315),
    [anon_sym_string] = ACTIONS(1315),
    [anon_sym_symbol] = ACTIONS(1315),
    [anon_sym_interface] = ACTIONS(1315),
    [anon_sym_enum] = ACTIONS(1315),
    [sym_readonly] = ACTIONS(1315),
    [sym__automatic_semicolon] = ACTIONS(1321),
  },
  [135] = {
    [ts_builtin_sym_end] = ACTIONS(1323),
    [sym_identifier] = ACTIONS(1325),
    [anon_sym_export] = ACTIONS(1325),
    [anon_sym_STAR] = ACTIONS(1325),
    [anon_sym_default] = ACTIONS(1325),
    [anon_sym_as] = ACTIONS(1325),
    [anon_sym_namespace] = ACTIONS(1325),
    [anon_sym_LBRACE] = ACTIONS(1323),
    [anon_sym_COMMA] = ACTIONS(1323),
    [anon_sym_RBRACE] = ACTIONS(1323),
    [anon_sym_type] = ACTIONS(1325),
    [anon_sym_typeof] = ACTIONS(1325),
    [anon_sym_import] = ACTIONS(1325),
    [anon_sym_var] = ACTIONS(1325),
    [anon_sym_let] = ACTIONS(1325),
    [anon_sym_const] = ACTIONS(1325),
    [anon_sym_if] = ACTIONS(1325),
    [anon_sym_else] = ACTIONS(1325),
    [anon_sym_switch] = ACTIONS(1325),
    [anon_sym_for] = ACTIONS(1325),
    [anon_sym_LPAREN] = ACTIONS(1323),
    [anon_sym_await] = ACTIONS(1325),
    [anon_sym_in] = ACTIONS(1325),
    [anon_sym_while] = ACTIONS(1325),
    [anon_sym_do] = ACTIONS(1325),
    [anon_sym_try] = ACTIONS(1325),
    [anon_sym_with] = ACTIONS(1325),
    [anon_sym_break] = ACTIONS(1325),
    [anon_sym_continue] = ACTIONS(1325),
    [anon_sym_debugger] = ACTIONS(1325),
    [anon_sym_return] = ACTIONS(1325),
    [anon_sym_throw] = ACTIONS(1325),
    [anon_sym_SEMI] = ACTIONS(1323),
    [anon_sym_case] = ACTIONS(1325),
    [anon_sym_yield] = ACTIONS(1325),
    [anon_sym_LBRACK] = ACTIONS(1323),
    [anon_sym_LT] = ACTIONS(1325),
    [anon_sym_GT] = ACTIONS(1325),
    [anon_sym_SLASH] = ACTIONS(1325),
    [anon_sym_DOT] = ACTIONS(1325),
    [anon_sym_class] = ACTIONS(1325),
    [anon_sym_async] = ACTIONS(1325),
    [anon_sym_function] = ACTIONS(1325),
    [anon_sym_new] = ACTIONS(1325),
    [anon_sym_QMARK] = ACTIONS(1325),
    [anon_sym_AMP_AMP] = ACTIONS(1323),
    [anon_sym_PIPE_PIPE] = ACTIONS(1323),
    [anon_sym_GT_GT] = ACTIONS(1325),
    [anon_sym_GT_GT_GT] = ACTIONS(1323),
    [anon_sym_LT_LT] = ACTIONS(1323),
    [anon_sym_AMP] = ACTIONS(1325),
    [anon_sym_CARET] = ACTIONS(1323),
    [anon_sym_PIPE] = ACTIONS(1325),
    [anon_sym_PLUS] = ACTIONS(1325),
    [anon_sym_DASH] = ACTIONS(1325),
    [anon_sym_PERCENT] = ACTIONS(1323),
    [anon_sym_STAR_STAR] = ACTIONS(1323),
    [anon_sym_LT_EQ] = ACTIONS(1323),
    [anon_sym_EQ_EQ] = ACTIONS(1325),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1323),
    [anon_sym_BANG_EQ] = ACTIONS(1325),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1323),
    [anon_sym_GT_EQ] = ACTIONS(1323),
    [anon_sym_QMARK_QMARK] = ACTIONS(1323),
    [anon_sym_instanceof] = ACTIONS(1325),
    [anon_sym_BANG] = ACTIONS(1325),
    [anon_sym_TILDE] = ACTIONS(1323),
    [anon_sym_void] = ACTIONS(1325),
    [anon_sym_delete] = ACTIONS(1325),
    [anon_sym_PLUS_PLUS] = ACTIONS(1323),
    [anon_sym_DASH_DASH] = ACTIONS(1323),
    [anon_sym_DQUOTE] = ACTIONS(1323),
    [anon_sym_SQUOTE] = ACTIONS(1323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1323),
    [sym_number] = ACTIONS(1323),
    [sym_this] = ACTIONS(1325),
    [sym_super] = ACTIONS(1325),
    [sym_true] = ACTIONS(1325),
    [sym_false] = ACTIONS(1325),
    [sym_null] = ACTIONS(1325),
    [sym_undefined] = ACTIONS(1325),
    [anon_sym_AT] = ACTIONS(1323),
    [anon_sym_static] = ACTIONS(1325),
    [anon_sym_abstract] = ACTIONS(1325),
    [anon_sym_get] = ACTIONS(1325),
    [anon_sym_set] = ACTIONS(1325),
    [anon_sym_declare] = ACTIONS(1325),
    [anon_sym_public] = ACTIONS(1325),
    [anon_sym_private] = ACTIONS(1325),
    [anon_sym_protected] = ACTIONS(1325),
    [anon_sym_module] = ACTIONS(1325),
    [anon_sym_any] = ACTIONS(1325),
    [anon_sym_number] = ACTIONS(1325),
    [anon_sym_boolean] = ACTIONS(1325),
    [anon_sym_string] = ACTIONS(1325),
    [anon_sym_symbol] = ACTIONS(1325),
    [anon_sym_interface] = ACTIONS(1325),
    [anon_sym_enum] = ACTIONS(1325),
    [sym_readonly] = ACTIONS(1325),
    [sym__automatic_semicolon] = ACTIONS(1323),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(1327),
    [sym_identifier] = ACTIONS(1329),
    [anon_sym_export] = ACTIONS(1329),
    [anon_sym_STAR] = ACTIONS(1331),
    [anon_sym_default] = ACTIONS(1329),
    [anon_sym_as] = ACTIONS(1331),
    [anon_sym_namespace] = ACTIONS(1329),
    [anon_sym_LBRACE] = ACTIONS(1327),
    [anon_sym_COMMA] = ACTIONS(1333),
    [anon_sym_RBRACE] = ACTIONS(1327),
    [anon_sym_type] = ACTIONS(1329),
    [anon_sym_typeof] = ACTIONS(1329),
    [anon_sym_import] = ACTIONS(1329),
    [anon_sym_var] = ACTIONS(1329),
    [anon_sym_let] = ACTIONS(1329),
    [anon_sym_const] = ACTIONS(1329),
    [anon_sym_if] = ACTIONS(1329),
    [anon_sym_else] = ACTIONS(1329),
    [anon_sym_switch] = ACTIONS(1329),
    [anon_sym_for] = ACTIONS(1329),
    [anon_sym_LPAREN] = ACTIONS(1327),
    [anon_sym_await] = ACTIONS(1329),
    [anon_sym_in] = ACTIONS(1331),
    [anon_sym_while] = ACTIONS(1329),
    [anon_sym_do] = ACTIONS(1329),
    [anon_sym_try] = ACTIONS(1329),
    [anon_sym_with] = ACTIONS(1329),
    [anon_sym_break] = ACTIONS(1329),
    [anon_sym_continue] = ACTIONS(1329),
    [anon_sym_debugger] = ACTIONS(1329),
    [anon_sym_return] = ACTIONS(1329),
    [anon_sym_throw] = ACTIONS(1329),
    [anon_sym_SEMI] = ACTIONS(1327),
    [anon_sym_case] = ACTIONS(1329),
    [anon_sym_yield] = ACTIONS(1329),
    [anon_sym_LBRACK] = ACTIONS(1327),
    [anon_sym_LT] = ACTIONS(1329),
    [anon_sym_GT] = ACTIONS(1331),
    [anon_sym_SLASH] = ACTIONS(1329),
    [anon_sym_DOT] = ACTIONS(1331),
    [anon_sym_class] = ACTIONS(1329),
    [anon_sym_async] = ACTIONS(1329),
    [anon_sym_function] = ACTIONS(1329),
    [anon_sym_new] = ACTIONS(1329),
    [anon_sym_QMARK] = ACTIONS(1331),
    [anon_sym_AMP_AMP] = ACTIONS(1333),
    [anon_sym_PIPE_PIPE] = ACTIONS(1333),
    [anon_sym_GT_GT] = ACTIONS(1331),
    [anon_sym_GT_GT_GT] = ACTIONS(1333),
    [anon_sym_LT_LT] = ACTIONS(1333),
    [anon_sym_AMP] = ACTIONS(1331),
    [anon_sym_CARET] = ACTIONS(1333),
    [anon_sym_PIPE] = ACTIONS(1331),
    [anon_sym_PLUS] = ACTIONS(1329),
    [anon_sym_DASH] = ACTIONS(1329),
    [anon_sym_PERCENT] = ACTIONS(1333),
    [anon_sym_STAR_STAR] = ACTIONS(1333),
    [anon_sym_LT_EQ] = ACTIONS(1333),
    [anon_sym_EQ_EQ] = ACTIONS(1331),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1333),
    [anon_sym_BANG_EQ] = ACTIONS(1331),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1333),
    [anon_sym_GT_EQ] = ACTIONS(1333),
    [anon_sym_QMARK_QMARK] = ACTIONS(1333),
    [anon_sym_instanceof] = ACTIONS(1331),
    [anon_sym_BANG] = ACTIONS(1329),
    [anon_sym_TILDE] = ACTIONS(1327),
    [anon_sym_void] = ACTIONS(1329),
    [anon_sym_delete] = ACTIONS(1329),
    [anon_sym_PLUS_PLUS] = ACTIONS(1327),
    [anon_sym_DASH_DASH] = ACTIONS(1327),
    [anon_sym_DQUOTE] = ACTIONS(1327),
    [anon_sym_SQUOTE] = ACTIONS(1327),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1327),
    [sym_number] = ACTIONS(1327),
    [sym_this] = ACTIONS(1329),
    [sym_super] = ACTIONS(1329),
    [sym_true] = ACTIONS(1329),
    [sym_false] = ACTIONS(1329),
    [sym_null] = ACTIONS(1329),
    [sym_undefined] = ACTIONS(1329),
    [anon_sym_AT] = ACTIONS(1327),
    [anon_sym_static] = ACTIONS(1329),
    [anon_sym_abstract] = ACTIONS(1329),
    [anon_sym_get] = ACTIONS(1329),
    [anon_sym_set] = ACTIONS(1329),
    [anon_sym_declare] = ACTIONS(1329),
    [anon_sym_public] = ACTIONS(1329),
    [anon_sym_private] = ACTIONS(1329),
    [anon_sym_protected] = ACTIONS(1329),
    [anon_sym_module] = ACTIONS(1329),
    [anon_sym_any] = ACTIONS(1329),
    [anon_sym_number] = ACTIONS(1329),
    [anon_sym_boolean] = ACTIONS(1329),
    [anon_sym_string] = ACTIONS(1329),
    [anon_sym_symbol] = ACTIONS(1329),
    [anon_sym_interface] = ACTIONS(1329),
    [anon_sym_enum] = ACTIONS(1329),
    [sym_readonly] = ACTIONS(1329),
    [sym__automatic_semicolon] = ACTIONS(1335),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(1337),
    [sym_identifier] = ACTIONS(1339),
    [anon_sym_export] = ACTIONS(1339),
    [anon_sym_STAR] = ACTIONS(1341),
    [anon_sym_default] = ACTIONS(1339),
    [anon_sym_as] = ACTIONS(1341),
    [anon_sym_namespace] = ACTIONS(1339),
    [anon_sym_LBRACE] = ACTIONS(1337),
    [anon_sym_COMMA] = ACTIONS(1343),
    [anon_sym_RBRACE] = ACTIONS(1337),
    [anon_sym_type] = ACTIONS(1339),
    [anon_sym_typeof] = ACTIONS(1339),
    [anon_sym_import] = ACTIONS(1339),
    [anon_sym_var] = ACTIONS(1339),
    [anon_sym_let] = ACTIONS(1339),
    [anon_sym_const] = ACTIONS(1339),
    [anon_sym_if] = ACTIONS(1339),
    [anon_sym_else] = ACTIONS(1339),
    [anon_sym_switch] = ACTIONS(1339),
    [anon_sym_for] = ACTIONS(1339),
    [anon_sym_LPAREN] = ACTIONS(1337),
    [anon_sym_await] = ACTIONS(1339),
    [anon_sym_in] = ACTIONS(1341),
    [anon_sym_while] = ACTIONS(1339),
    [anon_sym_do] = ACTIONS(1339),
    [anon_sym_try] = ACTIONS(1339),
    [anon_sym_with] = ACTIONS(1339),
    [anon_sym_break] = ACTIONS(1339),
    [anon_sym_continue] = ACTIONS(1339),
    [anon_sym_debugger] = ACTIONS(1339),
    [anon_sym_return] = ACTIONS(1339),
    [anon_sym_throw] = ACTIONS(1339),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_case] = ACTIONS(1339),
    [anon_sym_yield] = ACTIONS(1339),
    [anon_sym_LBRACK] = ACTIONS(1337),
    [anon_sym_LT] = ACTIONS(1339),
    [anon_sym_GT] = ACTIONS(1341),
    [anon_sym_SLASH] = ACTIONS(1339),
    [anon_sym_DOT] = ACTIONS(1341),
    [anon_sym_class] = ACTIONS(1339),
    [anon_sym_async] = ACTIONS(1339),
    [anon_sym_function] = ACTIONS(1339),
    [anon_sym_new] = ACTIONS(1339),
    [anon_sym_QMARK] = ACTIONS(1341),
    [anon_sym_AMP_AMP] = ACTIONS(1343),
    [anon_sym_PIPE_PIPE] = ACTIONS(1343),
    [anon_sym_GT_GT] = ACTIONS(1341),
    [anon_sym_GT_GT_GT] = ACTIONS(1343),
    [anon_sym_LT_LT] = ACTIONS(1343),
    [anon_sym_AMP] = ACTIONS(1341),
    [anon_sym_CARET] = ACTIONS(1343),
    [anon_sym_PIPE] = ACTIONS(1341),
    [anon_sym_PLUS] = ACTIONS(1339),
    [anon_sym_DASH] = ACTIONS(1339),
    [anon_sym_PERCENT] = ACTIONS(1343),
    [anon_sym_STAR_STAR] = ACTIONS(1343),
    [anon_sym_LT_EQ] = ACTIONS(1343),
    [anon_sym_EQ_EQ] = ACTIONS(1341),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1343),
    [anon_sym_BANG_EQ] = ACTIONS(1341),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1343),
    [anon_sym_GT_EQ] = ACTIONS(1343),
    [anon_sym_QMARK_QMARK] = ACTIONS(1343),
    [anon_sym_instanceof] = ACTIONS(1341),
    [anon_sym_BANG] = ACTIONS(1339),
    [anon_sym_TILDE] = ACTIONS(1337),
    [anon_sym_void] = ACTIONS(1339),
    [anon_sym_delete] = ACTIONS(1339),
    [anon_sym_PLUS_PLUS] = ACTIONS(1337),
    [anon_sym_DASH_DASH] = ACTIONS(1337),
    [anon_sym_DQUOTE] = ACTIONS(1337),
    [anon_sym_SQUOTE] = ACTIONS(1337),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1337),
    [sym_number] = ACTIONS(1337),
    [sym_this] = ACTIONS(1339),
    [sym_super] = ACTIONS(1339),
    [sym_true] = ACTIONS(1339),
    [sym_false] = ACTIONS(1339),
    [sym_null] = ACTIONS(1339),
    [sym_undefined] = ACTIONS(1339),
    [anon_sym_AT] = ACTIONS(1337),
    [anon_sym_static] = ACTIONS(1339),
    [anon_sym_abstract] = ACTIONS(1339),
    [anon_sym_get] = ACTIONS(1339),
    [anon_sym_set] = ACTIONS(1339),
    [anon_sym_declare] = ACTIONS(1339),
    [anon_sym_public] = ACTIONS(1339),
    [anon_sym_private] = ACTIONS(1339),
    [anon_sym_protected] = ACTIONS(1339),
    [anon_sym_module] = ACTIONS(1339),
    [anon_sym_any] = ACTIONS(1339),
    [anon_sym_number] = ACTIONS(1339),
    [anon_sym_boolean] = ACTIONS(1339),
    [anon_sym_string] = ACTIONS(1339),
    [anon_sym_symbol] = ACTIONS(1339),
    [anon_sym_interface] = ACTIONS(1339),
    [anon_sym_enum] = ACTIONS(1339),
    [sym_readonly] = ACTIONS(1339),
    [sym__automatic_semicolon] = ACTIONS(1345),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(1195),
    [sym_identifier] = ACTIONS(1197),
    [anon_sym_export] = ACTIONS(1197),
    [anon_sym_STAR] = ACTIONS(1197),
    [anon_sym_default] = ACTIONS(1197),
    [anon_sym_as] = ACTIONS(1197),
    [anon_sym_namespace] = ACTIONS(1197),
    [anon_sym_LBRACE] = ACTIONS(1195),
    [anon_sym_COMMA] = ACTIONS(1195),
    [anon_sym_RBRACE] = ACTIONS(1195),
    [anon_sym_type] = ACTIONS(1197),
    [anon_sym_typeof] = ACTIONS(1197),
    [anon_sym_import] = ACTIONS(1197),
    [anon_sym_var] = ACTIONS(1197),
    [anon_sym_let] = ACTIONS(1197),
    [anon_sym_const] = ACTIONS(1197),
    [anon_sym_if] = ACTIONS(1197),
    [anon_sym_else] = ACTIONS(1197),
    [anon_sym_switch] = ACTIONS(1197),
    [anon_sym_for] = ACTIONS(1197),
    [anon_sym_LPAREN] = ACTIONS(1195),
    [anon_sym_await] = ACTIONS(1197),
    [anon_sym_in] = ACTIONS(1197),
    [anon_sym_while] = ACTIONS(1197),
    [anon_sym_do] = ACTIONS(1197),
    [anon_sym_try] = ACTIONS(1197),
    [anon_sym_with] = ACTIONS(1197),
    [anon_sym_break] = ACTIONS(1197),
    [anon_sym_continue] = ACTIONS(1197),
    [anon_sym_debugger] = ACTIONS(1197),
    [anon_sym_return] = ACTIONS(1197),
    [anon_sym_throw] = ACTIONS(1197),
    [anon_sym_SEMI] = ACTIONS(1195),
    [anon_sym_case] = ACTIONS(1197),
    [anon_sym_yield] = ACTIONS(1197),
    [anon_sym_LBRACK] = ACTIONS(1195),
    [anon_sym_LT] = ACTIONS(1197),
    [anon_sym_GT] = ACTIONS(1197),
    [anon_sym_SLASH] = ACTIONS(1197),
    [anon_sym_DOT] = ACTIONS(1197),
    [anon_sym_class] = ACTIONS(1197),
    [anon_sym_async] = ACTIONS(1197),
    [anon_sym_function] = ACTIONS(1197),
    [anon_sym_new] = ACTIONS(1197),
    [anon_sym_QMARK] = ACTIONS(1197),
    [anon_sym_AMP_AMP] = ACTIONS(1195),
    [anon_sym_PIPE_PIPE] = ACTIONS(1195),
    [anon_sym_GT_GT] = ACTIONS(1197),
    [anon_sym_GT_GT_GT] = ACTIONS(1195),
    [anon_sym_LT_LT] = ACTIONS(1195),
    [anon_sym_AMP] = ACTIONS(1197),
    [anon_sym_CARET] = ACTIONS(1195),
    [anon_sym_PIPE] = ACTIONS(1197),
    [anon_sym_PLUS] = ACTIONS(1197),
    [anon_sym_DASH] = ACTIONS(1197),
    [anon_sym_PERCENT] = ACTIONS(1195),
    [anon_sym_STAR_STAR] = ACTIONS(1195),
    [anon_sym_LT_EQ] = ACTIONS(1195),
    [anon_sym_EQ_EQ] = ACTIONS(1197),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1195),
    [anon_sym_BANG_EQ] = ACTIONS(1197),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1195),
    [anon_sym_GT_EQ] = ACTIONS(1195),
    [anon_sym_QMARK_QMARK] = ACTIONS(1195),
    [anon_sym_instanceof] = ACTIONS(1197),
    [anon_sym_BANG] = ACTIONS(1197),
    [anon_sym_TILDE] = ACTIONS(1195),
    [anon_sym_void] = ACTIONS(1197),
    [anon_sym_delete] = ACTIONS(1197),
    [anon_sym_PLUS_PLUS] = ACTIONS(1195),
    [anon_sym_DASH_DASH] = ACTIONS(1195),
    [anon_sym_DQUOTE] = ACTIONS(1195),
    [anon_sym_SQUOTE] = ACTIONS(1195),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1195),
    [sym_number] = ACTIONS(1195),
    [sym_this] = ACTIONS(1197),
    [sym_super] = ACTIONS(1197),
    [sym_true] = ACTIONS(1197),
    [sym_false] = ACTIONS(1197),
    [sym_null] = ACTIONS(1197),
    [sym_undefined] = ACTIONS(1197),
    [anon_sym_AT] = ACTIONS(1195),
    [anon_sym_static] = ACTIONS(1197),
    [anon_sym_abstract] = ACTIONS(1197),
    [anon_sym_get] = ACTIONS(1197),
    [anon_sym_set] = ACTIONS(1197),
    [anon_sym_declare] = ACTIONS(1197),
    [anon_sym_public] = ACTIONS(1197),
    [anon_sym_private] = ACTIONS(1197),
    [anon_sym_protected] = ACTIONS(1197),
    [anon_sym_module] = ACTIONS(1197),
    [anon_sym_any] = ACTIONS(1197),
    [anon_sym_number] = ACTIONS(1197),
    [anon_sym_boolean] = ACTIONS(1197),
    [anon_sym_string] = ACTIONS(1197),
    [anon_sym_symbol] = ACTIONS(1197),
    [anon_sym_interface] = ACTIONS(1197),
    [anon_sym_enum] = ACTIONS(1197),
    [sym_readonly] = ACTIONS(1197),
    [sym__automatic_semicolon] = ACTIONS(1347),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(1349),
    [sym_identifier] = ACTIONS(1351),
    [anon_sym_export] = ACTIONS(1351),
    [anon_sym_STAR] = ACTIONS(1351),
    [anon_sym_default] = ACTIONS(1351),
    [anon_sym_as] = ACTIONS(1351),
    [anon_sym_namespace] = ACTIONS(1351),
    [anon_sym_LBRACE] = ACTIONS(1349),
    [anon_sym_COMMA] = ACTIONS(1349),
    [anon_sym_RBRACE] = ACTIONS(1349),
    [anon_sym_type] = ACTIONS(1351),
    [anon_sym_typeof] = ACTIONS(1351),
    [anon_sym_import] = ACTIONS(1351),
    [anon_sym_var] = ACTIONS(1351),
    [anon_sym_let] = ACTIONS(1351),
    [anon_sym_const] = ACTIONS(1351),
    [anon_sym_if] = ACTIONS(1351),
    [anon_sym_else] = ACTIONS(1351),
    [anon_sym_switch] = ACTIONS(1351),
    [anon_sym_for] = ACTIONS(1351),
    [anon_sym_LPAREN] = ACTIONS(1349),
    [anon_sym_await] = ACTIONS(1351),
    [anon_sym_in] = ACTIONS(1351),
    [anon_sym_while] = ACTIONS(1351),
    [anon_sym_do] = ACTIONS(1351),
    [anon_sym_try] = ACTIONS(1351),
    [anon_sym_with] = ACTIONS(1351),
    [anon_sym_break] = ACTIONS(1351),
    [anon_sym_continue] = ACTIONS(1351),
    [anon_sym_debugger] = ACTIONS(1351),
    [anon_sym_return] = ACTIONS(1351),
    [anon_sym_throw] = ACTIONS(1351),
    [anon_sym_SEMI] = ACTIONS(1349),
    [anon_sym_case] = ACTIONS(1351),
    [anon_sym_yield] = ACTIONS(1351),
    [anon_sym_LBRACK] = ACTIONS(1349),
    [anon_sym_LT] = ACTIONS(1351),
    [anon_sym_GT] = ACTIONS(1351),
    [anon_sym_SLASH] = ACTIONS(1351),
    [anon_sym_DOT] = ACTIONS(1351),
    [anon_sym_class] = ACTIONS(1351),
    [anon_sym_async] = ACTIONS(1351),
    [anon_sym_function] = ACTIONS(1351),
    [anon_sym_new] = ACTIONS(1351),
    [anon_sym_QMARK] = ACTIONS(1351),
    [anon_sym_AMP_AMP] = ACTIONS(1349),
    [anon_sym_PIPE_PIPE] = ACTIONS(1349),
    [anon_sym_GT_GT] = ACTIONS(1351),
    [anon_sym_GT_GT_GT] = ACTIONS(1349),
    [anon_sym_LT_LT] = ACTIONS(1349),
    [anon_sym_AMP] = ACTIONS(1351),
    [anon_sym_CARET] = ACTIONS(1349),
    [anon_sym_PIPE] = ACTIONS(1351),
    [anon_sym_PLUS] = ACTIONS(1351),
    [anon_sym_DASH] = ACTIONS(1351),
    [anon_sym_PERCENT] = ACTIONS(1349),
    [anon_sym_STAR_STAR] = ACTIONS(1349),
    [anon_sym_LT_EQ] = ACTIONS(1349),
    [anon_sym_EQ_EQ] = ACTIONS(1351),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1349),
    [anon_sym_BANG_EQ] = ACTIONS(1351),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1349),
    [anon_sym_GT_EQ] = ACTIONS(1349),
    [anon_sym_QMARK_QMARK] = ACTIONS(1349),
    [anon_sym_instanceof] = ACTIONS(1351),
    [anon_sym_BANG] = ACTIONS(1351),
    [anon_sym_TILDE] = ACTIONS(1349),
    [anon_sym_void] = ACTIONS(1351),
    [anon_sym_delete] = ACTIONS(1351),
    [anon_sym_PLUS_PLUS] = ACTIONS(1349),
    [anon_sym_DASH_DASH] = ACTIONS(1349),
    [anon_sym_DQUOTE] = ACTIONS(1349),
    [anon_sym_SQUOTE] = ACTIONS(1349),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1349),
    [sym_number] = ACTIONS(1349),
    [sym_this] = ACTIONS(1351),
    [sym_super] = ACTIONS(1351),
    [sym_true] = ACTIONS(1351),
    [sym_false] = ACTIONS(1351),
    [sym_null] = ACTIONS(1351),
    [sym_undefined] = ACTIONS(1351),
    [anon_sym_AT] = ACTIONS(1349),
    [anon_sym_static] = ACTIONS(1351),
    [anon_sym_abstract] = ACTIONS(1351),
    [anon_sym_get] = ACTIONS(1351),
    [anon_sym_set] = ACTIONS(1351),
    [anon_sym_declare] = ACTIONS(1351),
    [anon_sym_public] = ACTIONS(1351),
    [anon_sym_private] = ACTIONS(1351),
    [anon_sym_protected] = ACTIONS(1351),
    [anon_sym_module] = ACTIONS(1351),
    [anon_sym_any] = ACTIONS(1351),
    [anon_sym_number] = ACTIONS(1351),
    [anon_sym_boolean] = ACTIONS(1351),
    [anon_sym_string] = ACTIONS(1351),
    [anon_sym_symbol] = ACTIONS(1351),
    [anon_sym_interface] = ACTIONS(1351),
    [anon_sym_enum] = ACTIONS(1351),
    [sym_readonly] = ACTIONS(1351),
    [sym__automatic_semicolon] = ACTIONS(1349),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(1353),
    [sym_identifier] = ACTIONS(1355),
    [anon_sym_export] = ACTIONS(1355),
    [anon_sym_STAR] = ACTIONS(1355),
    [anon_sym_default] = ACTIONS(1355),
    [anon_sym_as] = ACTIONS(1355),
    [anon_sym_namespace] = ACTIONS(1355),
    [anon_sym_LBRACE] = ACTIONS(1353),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_RBRACE] = ACTIONS(1353),
    [anon_sym_type] = ACTIONS(1355),
    [anon_sym_typeof] = ACTIONS(1355),
    [anon_sym_import] = ACTIONS(1355),
    [anon_sym_var] = ACTIONS(1355),
    [anon_sym_let] = ACTIONS(1355),
    [anon_sym_const] = ACTIONS(1355),
    [anon_sym_if] = ACTIONS(1355),
    [anon_sym_else] = ACTIONS(1355),
    [anon_sym_switch] = ACTIONS(1355),
    [anon_sym_for] = ACTIONS(1355),
    [anon_sym_LPAREN] = ACTIONS(1353),
    [anon_sym_await] = ACTIONS(1355),
    [anon_sym_in] = ACTIONS(1355),
    [anon_sym_while] = ACTIONS(1355),
    [anon_sym_do] = ACTIONS(1355),
    [anon_sym_try] = ACTIONS(1355),
    [anon_sym_with] = ACTIONS(1355),
    [anon_sym_break] = ACTIONS(1355),
    [anon_sym_continue] = ACTIONS(1355),
    [anon_sym_debugger] = ACTIONS(1355),
    [anon_sym_return] = ACTIONS(1355),
    [anon_sym_throw] = ACTIONS(1355),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_case] = ACTIONS(1355),
    [anon_sym_yield] = ACTIONS(1355),
    [anon_sym_LBRACK] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1355),
    [anon_sym_GT] = ACTIONS(1355),
    [anon_sym_SLASH] = ACTIONS(1355),
    [anon_sym_DOT] = ACTIONS(1355),
    [anon_sym_class] = ACTIONS(1355),
    [anon_sym_async] = ACTIONS(1355),
    [anon_sym_function] = ACTIONS(1355),
    [anon_sym_new] = ACTIONS(1355),
    [anon_sym_QMARK] = ACTIONS(1355),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1355),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1355),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1355),
    [anon_sym_PLUS] = ACTIONS(1355),
    [anon_sym_DASH] = ACTIONS(1355),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1355),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1355),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1355),
    [anon_sym_BANG] = ACTIONS(1355),
    [anon_sym_TILDE] = ACTIONS(1353),
    [anon_sym_void] = ACTIONS(1355),
    [anon_sym_delete] = ACTIONS(1355),
    [anon_sym_PLUS_PLUS] = ACTIONS(1353),
    [anon_sym_DASH_DASH] = ACTIONS(1353),
    [anon_sym_DQUOTE] = ACTIONS(1353),
    [anon_sym_SQUOTE] = ACTIONS(1353),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1353),
    [sym_number] = ACTIONS(1353),
    [sym_this] = ACTIONS(1355),
    [sym_super] = ACTIONS(1355),
    [sym_true] = ACTIONS(1355),
    [sym_false] = ACTIONS(1355),
    [sym_null] = ACTIONS(1355),
    [sym_undefined] = ACTIONS(1355),
    [anon_sym_AT] = ACTIONS(1353),
    [anon_sym_static] = ACTIONS(1355),
    [anon_sym_abstract] = ACTIONS(1355),
    [anon_sym_get] = ACTIONS(1355),
    [anon_sym_set] = ACTIONS(1355),
    [anon_sym_declare] = ACTIONS(1355),
    [anon_sym_public] = ACTIONS(1355),
    [anon_sym_private] = ACTIONS(1355),
    [anon_sym_protected] = ACTIONS(1355),
    [anon_sym_module] = ACTIONS(1355),
    [anon_sym_any] = ACTIONS(1355),
    [anon_sym_number] = ACTIONS(1355),
    [anon_sym_boolean] = ACTIONS(1355),
    [anon_sym_string] = ACTIONS(1355),
    [anon_sym_symbol] = ACTIONS(1355),
    [anon_sym_interface] = ACTIONS(1355),
    [anon_sym_enum] = ACTIONS(1355),
    [sym_readonly] = ACTIONS(1355),
    [sym__automatic_semicolon] = ACTIONS(1353),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(1357),
    [sym_identifier] = ACTIONS(1359),
    [anon_sym_export] = ACTIONS(1359),
    [anon_sym_STAR] = ACTIONS(1361),
    [anon_sym_default] = ACTIONS(1359),
    [anon_sym_as] = ACTIONS(1361),
    [anon_sym_namespace] = ACTIONS(1359),
    [anon_sym_LBRACE] = ACTIONS(1357),
    [anon_sym_COMMA] = ACTIONS(1363),
    [anon_sym_RBRACE] = ACTIONS(1357),
    [anon_sym_type] = ACTIONS(1359),
    [anon_sym_typeof] = ACTIONS(1359),
    [anon_sym_import] = ACTIONS(1359),
    [anon_sym_var] = ACTIONS(1359),
    [anon_sym_let] = ACTIONS(1359),
    [anon_sym_const] = ACTIONS(1359),
    [anon_sym_if] = ACTIONS(1359),
    [anon_sym_else] = ACTIONS(1359),
    [anon_sym_switch] = ACTIONS(1359),
    [anon_sym_for] = ACTIONS(1359),
    [anon_sym_LPAREN] = ACTIONS(1357),
    [anon_sym_await] = ACTIONS(1359),
    [anon_sym_in] = ACTIONS(1361),
    [anon_sym_while] = ACTIONS(1359),
    [anon_sym_do] = ACTIONS(1359),
    [anon_sym_try] = ACTIONS(1359),
    [anon_sym_with] = ACTIONS(1359),
    [anon_sym_break] = ACTIONS(1359),
    [anon_sym_continue] = ACTIONS(1359),
    [anon_sym_debugger] = ACTIONS(1359),
    [anon_sym_return] = ACTIONS(1359),
    [anon_sym_throw] = ACTIONS(1359),
    [anon_sym_SEMI] = ACTIONS(1357),
    [anon_sym_case] = ACTIONS(1359),
    [anon_sym_yield] = ACTIONS(1359),
    [anon_sym_LBRACK] = ACTIONS(1357),
    [anon_sym_LT] = ACTIONS(1359),
    [anon_sym_GT] = ACTIONS(1361),
    [anon_sym_SLASH] = ACTIONS(1359),
    [anon_sym_DOT] = ACTIONS(1361),
    [anon_sym_class] = ACTIONS(1359),
    [anon_sym_async] = ACTIONS(1359),
    [anon_sym_function] = ACTIONS(1359),
    [anon_sym_new] = ACTIONS(1359),
    [anon_sym_QMARK] = ACTIONS(1361),
    [anon_sym_AMP_AMP] = ACTIONS(1363),
    [anon_sym_PIPE_PIPE] = ACTIONS(1363),
    [anon_sym_GT_GT] = ACTIONS(1361),
    [anon_sym_GT_GT_GT] = ACTIONS(1363),
    [anon_sym_LT_LT] = ACTIONS(1363),
    [anon_sym_AMP] = ACTIONS(1361),
    [anon_sym_CARET] = ACTIONS(1363),
    [anon_sym_PIPE] = ACTIONS(1361),
    [anon_sym_PLUS] = ACTIONS(1359),
    [anon_sym_DASH] = ACTIONS(1359),
    [anon_sym_PERCENT] = ACTIONS(1363),
    [anon_sym_STAR_STAR] = ACTIONS(1363),
    [anon_sym_LT_EQ] = ACTIONS(1363),
    [anon_sym_EQ_EQ] = ACTIONS(1361),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1363),
    [anon_sym_BANG_EQ] = ACTIONS(1361),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1363),
    [anon_sym_GT_EQ] = ACTIONS(1363),
    [anon_sym_QMARK_QMARK] = ACTIONS(1363),
    [anon_sym_instanceof] = ACTIONS(1361),
    [anon_sym_BANG] = ACTIONS(1359),
    [anon_sym_TILDE] = ACTIONS(1357),
    [anon_sym_void] = ACTIONS(1359),
    [anon_sym_delete] = ACTIONS(1359),
    [anon_sym_PLUS_PLUS] = ACTIONS(1357),
    [anon_sym_DASH_DASH] = ACTIONS(1357),
    [anon_sym_DQUOTE] = ACTIONS(1357),
    [anon_sym_SQUOTE] = ACTIONS(1357),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1357),
    [sym_number] = ACTIONS(1357),
    [sym_this] = ACTIONS(1359),
    [sym_super] = ACTIONS(1359),
    [sym_true] = ACTIONS(1359),
    [sym_false] = ACTIONS(1359),
    [sym_null] = ACTIONS(1359),
    [sym_undefined] = ACTIONS(1359),
    [anon_sym_AT] = ACTIONS(1357),
    [anon_sym_static] = ACTIONS(1359),
    [anon_sym_abstract] = ACTIONS(1359),
    [anon_sym_get] = ACTIONS(1359),
    [anon_sym_set] = ACTIONS(1359),
    [anon_sym_declare] = ACTIONS(1359),
    [anon_sym_public] = ACTIONS(1359),
    [anon_sym_private] = ACTIONS(1359),
    [anon_sym_protected] = ACTIONS(1359),
    [anon_sym_module] = ACTIONS(1359),
    [anon_sym_any] = ACTIONS(1359),
    [anon_sym_number] = ACTIONS(1359),
    [anon_sym_boolean] = ACTIONS(1359),
    [anon_sym_string] = ACTIONS(1359),
    [anon_sym_symbol] = ACTIONS(1359),
    [anon_sym_interface] = ACTIONS(1359),
    [anon_sym_enum] = ACTIONS(1359),
    [sym_readonly] = ACTIONS(1359),
    [sym__automatic_semicolon] = ACTIONS(1365),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(1367),
    [sym_identifier] = ACTIONS(1369),
    [anon_sym_export] = ACTIONS(1369),
    [anon_sym_STAR] = ACTIONS(1369),
    [anon_sym_default] = ACTIONS(1369),
    [anon_sym_as] = ACTIONS(1369),
    [anon_sym_namespace] = ACTIONS(1369),
    [anon_sym_LBRACE] = ACTIONS(1367),
    [anon_sym_COMMA] = ACTIONS(1367),
    [anon_sym_RBRACE] = ACTIONS(1367),
    [anon_sym_type] = ACTIONS(1369),
    [anon_sym_typeof] = ACTIONS(1369),
    [anon_sym_import] = ACTIONS(1369),
    [anon_sym_var] = ACTIONS(1369),
    [anon_sym_let] = ACTIONS(1369),
    [anon_sym_const] = ACTIONS(1369),
    [anon_sym_if] = ACTIONS(1369),
    [anon_sym_else] = ACTIONS(1369),
    [anon_sym_switch] = ACTIONS(1369),
    [anon_sym_for] = ACTIONS(1369),
    [anon_sym_LPAREN] = ACTIONS(1367),
    [anon_sym_await] = ACTIONS(1369),
    [anon_sym_in] = ACTIONS(1369),
    [anon_sym_while] = ACTIONS(1369),
    [anon_sym_do] = ACTIONS(1369),
    [anon_sym_try] = ACTIONS(1369),
    [anon_sym_with] = ACTIONS(1369),
    [anon_sym_break] = ACTIONS(1369),
    [anon_sym_continue] = ACTIONS(1369),
    [anon_sym_debugger] = ACTIONS(1369),
    [anon_sym_return] = ACTIONS(1369),
    [anon_sym_throw] = ACTIONS(1369),
    [anon_sym_SEMI] = ACTIONS(1367),
    [anon_sym_case] = ACTIONS(1369),
    [anon_sym_yield] = ACTIONS(1369),
    [anon_sym_LBRACK] = ACTIONS(1367),
    [anon_sym_LT] = ACTIONS(1369),
    [anon_sym_GT] = ACTIONS(1369),
    [anon_sym_SLASH] = ACTIONS(1369),
    [anon_sym_DOT] = ACTIONS(1369),
    [anon_sym_class] = ACTIONS(1369),
    [anon_sym_async] = ACTIONS(1369),
    [anon_sym_function] = ACTIONS(1369),
    [anon_sym_new] = ACTIONS(1369),
    [anon_sym_QMARK] = ACTIONS(1369),
    [anon_sym_AMP_AMP] = ACTIONS(1367),
    [anon_sym_PIPE_PIPE] = ACTIONS(1367),
    [anon_sym_GT_GT] = ACTIONS(1369),
    [anon_sym_GT_GT_GT] = ACTIONS(1367),
    [anon_sym_LT_LT] = ACTIONS(1367),
    [anon_sym_AMP] = ACTIONS(1369),
    [anon_sym_CARET] = ACTIONS(1367),
    [anon_sym_PIPE] = ACTIONS(1369),
    [anon_sym_PLUS] = ACTIONS(1369),
    [anon_sym_DASH] = ACTIONS(1369),
    [anon_sym_PERCENT] = ACTIONS(1367),
    [anon_sym_STAR_STAR] = ACTIONS(1367),
    [anon_sym_LT_EQ] = ACTIONS(1367),
    [anon_sym_EQ_EQ] = ACTIONS(1369),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1367),
    [anon_sym_BANG_EQ] = ACTIONS(1369),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1367),
    [anon_sym_GT_EQ] = ACTIONS(1367),
    [anon_sym_QMARK_QMARK] = ACTIONS(1367),
    [anon_sym_instanceof] = ACTIONS(1369),
    [anon_sym_BANG] = ACTIONS(1369),
    [anon_sym_TILDE] = ACTIONS(1367),
    [anon_sym_void] = ACTIONS(1369),
    [anon_sym_delete] = ACTIONS(1369),
    [anon_sym_PLUS_PLUS] = ACTIONS(1367),
    [anon_sym_DASH_DASH] = ACTIONS(1367),
    [anon_sym_DQUOTE] = ACTIONS(1367),
    [anon_sym_SQUOTE] = ACTIONS(1367),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1367),
    [sym_number] = ACTIONS(1367),
    [sym_this] = ACTIONS(1369),
    [sym_super] = ACTIONS(1369),
    [sym_true] = ACTIONS(1369),
    [sym_false] = ACTIONS(1369),
    [sym_null] = ACTIONS(1369),
    [sym_undefined] = ACTIONS(1369),
    [anon_sym_AT] = ACTIONS(1367),
    [anon_sym_static] = ACTIONS(1369),
    [anon_sym_abstract] = ACTIONS(1369),
    [anon_sym_get] = ACTIONS(1369),
    [anon_sym_set] = ACTIONS(1369),
    [anon_sym_declare] = ACTIONS(1369),
    [anon_sym_public] = ACTIONS(1369),
    [anon_sym_private] = ACTIONS(1369),
    [anon_sym_protected] = ACTIONS(1369),
    [anon_sym_module] = ACTIONS(1369),
    [anon_sym_any] = ACTIONS(1369),
    [anon_sym_number] = ACTIONS(1369),
    [anon_sym_boolean] = ACTIONS(1369),
    [anon_sym_string] = ACTIONS(1369),
    [anon_sym_symbol] = ACTIONS(1369),
    [anon_sym_interface] = ACTIONS(1369),
    [anon_sym_enum] = ACTIONS(1369),
    [sym_readonly] = ACTIONS(1369),
    [sym__automatic_semicolon] = ACTIONS(1367),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(1371),
    [sym_identifier] = ACTIONS(1373),
    [anon_sym_export] = ACTIONS(1373),
    [anon_sym_STAR] = ACTIONS(1375),
    [anon_sym_default] = ACTIONS(1373),
    [anon_sym_as] = ACTIONS(1375),
    [anon_sym_namespace] = ACTIONS(1373),
    [anon_sym_LBRACE] = ACTIONS(1371),
    [anon_sym_COMMA] = ACTIONS(1377),
    [anon_sym_RBRACE] = ACTIONS(1371),
    [anon_sym_type] = ACTIONS(1373),
    [anon_sym_typeof] = ACTIONS(1373),
    [anon_sym_import] = ACTIONS(1373),
    [anon_sym_var] = ACTIONS(1373),
    [anon_sym_let] = ACTIONS(1373),
    [anon_sym_const] = ACTIONS(1373),
    [anon_sym_if] = ACTIONS(1373),
    [anon_sym_else] = ACTIONS(1373),
    [anon_sym_switch] = ACTIONS(1373),
    [anon_sym_for] = ACTIONS(1373),
    [anon_sym_LPAREN] = ACTIONS(1371),
    [anon_sym_await] = ACTIONS(1373),
    [anon_sym_in] = ACTIONS(1375),
    [anon_sym_while] = ACTIONS(1373),
    [anon_sym_do] = ACTIONS(1373),
    [anon_sym_try] = ACTIONS(1373),
    [anon_sym_with] = ACTIONS(1373),
    [anon_sym_break] = ACTIONS(1373),
    [anon_sym_continue] = ACTIONS(1373),
    [anon_sym_debugger] = ACTIONS(1373),
    [anon_sym_return] = ACTIONS(1373),
    [anon_sym_throw] = ACTIONS(1373),
    [anon_sym_SEMI] = ACTIONS(1371),
    [anon_sym_case] = ACTIONS(1373),
    [anon_sym_yield] = ACTIONS(1373),
    [anon_sym_LBRACK] = ACTIONS(1371),
    [anon_sym_LT] = ACTIONS(1373),
    [anon_sym_GT] = ACTIONS(1375),
    [anon_sym_SLASH] = ACTIONS(1373),
    [anon_sym_DOT] = ACTIONS(1375),
    [anon_sym_class] = ACTIONS(1373),
    [anon_sym_async] = ACTIONS(1373),
    [anon_sym_function] = ACTIONS(1373),
    [anon_sym_new] = ACTIONS(1373),
    [anon_sym_QMARK] = ACTIONS(1375),
    [anon_sym_AMP_AMP] = ACTIONS(1377),
    [anon_sym_PIPE_PIPE] = ACTIONS(1377),
    [anon_sym_GT_GT] = ACTIONS(1375),
    [anon_sym_GT_GT_GT] = ACTIONS(1377),
    [anon_sym_LT_LT] = ACTIONS(1377),
    [anon_sym_AMP] = ACTIONS(1375),
    [anon_sym_CARET] = ACTIONS(1377),
    [anon_sym_PIPE] = ACTIONS(1375),
    [anon_sym_PLUS] = ACTIONS(1373),
    [anon_sym_DASH] = ACTIONS(1373),
    [anon_sym_PERCENT] = ACTIONS(1377),
    [anon_sym_STAR_STAR] = ACTIONS(1377),
    [anon_sym_LT_EQ] = ACTIONS(1377),
    [anon_sym_EQ_EQ] = ACTIONS(1375),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1377),
    [anon_sym_BANG_EQ] = ACTIONS(1375),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1377),
    [anon_sym_GT_EQ] = ACTIONS(1377),
    [anon_sym_QMARK_QMARK] = ACTIONS(1377),
    [anon_sym_instanceof] = ACTIONS(1375),
    [anon_sym_BANG] = ACTIONS(1373),
    [anon_sym_TILDE] = ACTIONS(1371),
    [anon_sym_void] = ACTIONS(1373),
    [anon_sym_delete] = ACTIONS(1373),
    [anon_sym_PLUS_PLUS] = ACTIONS(1371),
    [anon_sym_DASH_DASH] = ACTIONS(1371),
    [anon_sym_DQUOTE] = ACTIONS(1371),
    [anon_sym_SQUOTE] = ACTIONS(1371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1371),
    [sym_number] = ACTIONS(1371),
    [sym_this] = ACTIONS(1373),
    [sym_super] = ACTIONS(1373),
    [sym_true] = ACTIONS(1373),
    [sym_false] = ACTIONS(1373),
    [sym_null] = ACTIONS(1373),
    [sym_undefined] = ACTIONS(1373),
    [anon_sym_AT] = ACTIONS(1371),
    [anon_sym_static] = ACTIONS(1373),
    [anon_sym_abstract] = ACTIONS(1373),
    [anon_sym_get] = ACTIONS(1373),
    [anon_sym_set] = ACTIONS(1373),
    [anon_sym_declare] = ACTIONS(1373),
    [anon_sym_public] = ACTIONS(1373),
    [anon_sym_private] = ACTIONS(1373),
    [anon_sym_protected] = ACTIONS(1373),
    [anon_sym_module] = ACTIONS(1373),
    [anon_sym_any] = ACTIONS(1373),
    [anon_sym_number] = ACTIONS(1373),
    [anon_sym_boolean] = ACTIONS(1373),
    [anon_sym_string] = ACTIONS(1373),
    [anon_sym_symbol] = ACTIONS(1373),
    [anon_sym_interface] = ACTIONS(1373),
    [anon_sym_enum] = ACTIONS(1373),
    [sym_readonly] = ACTIONS(1373),
    [sym__automatic_semicolon] = ACTIONS(1379),
  },
  [144] = {
    [sym_import] = STATE(1085),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1085),
    [sym_yield_expression] = STATE(1085),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_class] = STATE(1085),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1085),
    [sym_arrow_function] = STATE(1085),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1085),
    [sym_new_expression] = STATE(1085),
    [sym_await_expression] = STATE(1085),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1085),
    [sym_augmented_assignment_expression] = STATE(1085),
    [sym_spread_element] = STATE(2747),
    [sym_ternary_expression] = STATE(1085),
    [sym_binary_expression] = STATE(1085),
    [sym_unary_expression] = STATE(1085),
    [sym_update_expression] = STATE(1085),
    [sym_sequence_expression] = STATE(3025),
    [sym_string] = STATE(1085),
    [sym_template_string] = STATE(1085),
    [sym_regex] = STATE(1085),
    [sym_meta_property] = STATE(1085),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1085),
    [sym_type_assertion] = STATE(1085),
    [sym_as_expression] = STATE(1085),
    [sym_internal_module] = STATE(1085),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [aux_sym_array_repeat1] = STATE(2751),
    [sym_identifier] = ACTIONS(1381),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(1383),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1385),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(1387),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1389),
    [sym_this] = ACTIONS(1391),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1393),
    [sym_false] = ACTIONS(1393),
    [sym_null] = ACTIONS(1393),
    [sym_undefined] = ACTIONS(1393),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(843),
    [anon_sym_number] = ACTIONS(843),
    [anon_sym_boolean] = ACTIONS(843),
    [anon_sym_string] = ACTIONS(843),
    [anon_sym_symbol] = ACTIONS(843),
    [sym_readonly] = ACTIONS(887),
  },
  [145] = {
    [sym_import] = STATE(1085),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1085),
    [sym_yield_expression] = STATE(1085),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_class] = STATE(1085),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1085),
    [sym_arrow_function] = STATE(1085),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1085),
    [sym_new_expression] = STATE(1085),
    [sym_await_expression] = STATE(1085),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1085),
    [sym_augmented_assignment_expression] = STATE(1085),
    [sym_spread_element] = STATE(2747),
    [sym_ternary_expression] = STATE(1085),
    [sym_binary_expression] = STATE(1085),
    [sym_unary_expression] = STATE(1085),
    [sym_update_expression] = STATE(1085),
    [sym_sequence_expression] = STATE(3025),
    [sym_string] = STATE(1085),
    [sym_template_string] = STATE(1085),
    [sym_regex] = STATE(1085),
    [sym_meta_property] = STATE(1085),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1085),
    [sym_type_assertion] = STATE(1085),
    [sym_as_expression] = STATE(1085),
    [sym_internal_module] = STATE(1085),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [aux_sym_array_repeat1] = STATE(2751),
    [sym_identifier] = ACTIONS(1381),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(1395),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1385),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(1387),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1389),
    [sym_this] = ACTIONS(1391),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1393),
    [sym_false] = ACTIONS(1393),
    [sym_null] = ACTIONS(1393),
    [sym_undefined] = ACTIONS(1393),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(843),
    [anon_sym_number] = ACTIONS(843),
    [anon_sym_boolean] = ACTIONS(843),
    [anon_sym_string] = ACTIONS(843),
    [anon_sym_symbol] = ACTIONS(843),
    [sym_readonly] = ACTIONS(887),
  },
  [146] = {
    [sym_import] = STATE(1075),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1075),
    [sym_yield_expression] = STATE(1075),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_class] = STATE(1075),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1075),
    [sym_arrow_function] = STATE(1075),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1075),
    [sym_new_expression] = STATE(1075),
    [sym_await_expression] = STATE(1075),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1075),
    [sym_augmented_assignment_expression] = STATE(1075),
    [sym_spread_element] = STATE(2685),
    [sym_ternary_expression] = STATE(1075),
    [sym_binary_expression] = STATE(1075),
    [sym_unary_expression] = STATE(1075),
    [sym_update_expression] = STATE(1075),
    [sym_sequence_expression] = STATE(3025),
    [sym_string] = STATE(1075),
    [sym_template_string] = STATE(1075),
    [sym_regex] = STATE(1075),
    [sym_meta_property] = STATE(1075),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1075),
    [sym_type_assertion] = STATE(1075),
    [sym_as_expression] = STATE(1075),
    [sym_internal_module] = STATE(1075),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [aux_sym_array_repeat1] = STATE(2681),
    [sym_identifier] = ACTIONS(1381),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(1397),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1385),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(1387),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1399),
    [sym_this] = ACTIONS(1391),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1401),
    [sym_false] = ACTIONS(1401),
    [sym_null] = ACTIONS(1401),
    [sym_undefined] = ACTIONS(1401),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(843),
    [anon_sym_number] = ACTIONS(843),
    [anon_sym_boolean] = ACTIONS(843),
    [anon_sym_string] = ACTIONS(843),
    [anon_sym_symbol] = ACTIONS(843),
    [sym_readonly] = ACTIONS(887),
  },
  [147] = {
    [sym_import] = STATE(1088),
    [sym_parenthesized_expression] = STATE(998),
    [sym__expression] = STATE(1088),
    [sym_yield_expression] = STATE(1088),
    [sym_object] = STATE(1568),
    [sym_array] = STATE(1573),
    [sym_class] = STATE(1088),
    [sym_function] = STATE(1053),
    [sym_generator_function] = STATE(1088),
    [sym_arrow_function] = STATE(1088),
    [sym__call_signature] = STATE(3185),
    [sym_call_expression] = STATE(1088),
    [sym_new_expression] = STATE(1088),
    [sym_await_expression] = STATE(1088),
    [sym_member_expression] = STATE(998),
    [sym_subscript_expression] = STATE(998),
    [sym_assignment_expression] = STATE(1088),
    [sym_augmented_assignment_expression] = STATE(1088),
    [sym_spread_element] = STATE(2710),
    [sym_ternary_expression] = STATE(1088),
    [sym_binary_expression] = STATE(1088),
    [sym_unary_expression] = STATE(1088),
    [sym_update_expression] = STATE(1088),
    [sym_sequence_expression] = STATE(3025),
    [sym_string] = STATE(1088),
    [sym_template_string] = STATE(1088),
    [sym_regex] = STATE(1088),
    [sym_meta_property] = STATE(1088),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_rest_parameter] = STATE(2708),
    [sym_non_null_expression] = STATE(1088),
    [sym_type_assertion] = STATE(1088),
    [sym_as_expression] = STATE(1088),
    [sym_internal_module] = STATE(1088),
    [sym_accessibility_modifier] = STATE(2014),
    [sym_required_parameter] = STATE(2708),
    [sym_optional_parameter] = STATE(2708),
    [sym__parameter_name] = STATE(2175),
    [sym_type_arguments] = STATE(343),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(1905),
    [aux_sym_array_repeat1] = STATE(2713),
    [sym_identifier] = ACTIONS(1381),
    [anon_sym_export] = ACTIONS(843),
    [anon_sym_namespace] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(901),
    [anon_sym_type] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_RPAREN] = ACTIONS(1403),
    [anon_sym_await] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1385),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_void] = ACTIONS(1387),
    [anon_sym_delete] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(533),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [sym_number] = ACTIONS(1405),
    [sym_this] = ACTIONS(1391),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(1407),
    [sym_false] = ACTIONS(1407),
    [sym_null] = ACTIONS(1407),
    [sym_undefined] = ACTIONS(1407),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_get] = ACTIONS(843),
    [anon_sym_set] = ACTIONS(843),
    [anon_sym_declare] = ACTIONS(843),
    [anon_sym_public] = ACTIONS(883),
    [anon_sym_private] = ACTIONS(883),
    [anon_sym_protected] = ACTIONS(883),
    [anon_sym_module] = ACTIONS(843),
    [anon_sym_any] = ACTIONS(843),
    [anon_sym_number] = ACTIONS(843),
    [anon_sym_boolean] = ACTIONS(843),
    [anon_sym_string] = ACTIONS(843),
    [anon_sym_symbol] = ACTIONS(843),
    [sym_readonly] = ACTIONS(887),
  },
  [148] = {
    [sym_import] = STATE(1292),
    [sym_expression_statement] = STATE(171),
    [sym_variable_declaration] = STATE(171),
    [sym_lexical_declaration] = STATE(171),
    [sym_empty_statement] = STATE(171),
    [sym_parenthesized_expression] = STATE(965),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1437),
    [sym_array] = STATE(1439),
    [sym_class] = STATE(1292),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1292),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(965),
    [sym_subscript_expression] = STATE(965),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_internal_module] = STATE(1292),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(1409),
    [anon_sym_export] = ACTIONS(1411),
    [anon_sym_namespace] = ACTIONS(1413),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_type] = ACTIONS(1411),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_var] = ACTIONS(1415),
    [anon_sym_let] = ACTIONS(1417),
    [anon_sym_const] = ACTIONS(1417),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_yield] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_async] = ACTIONS(1419),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_void] = ACTIONS(1421),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(91),
    [sym_false] = ACTIONS(91),
    [sym_null] = ACTIONS(91),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(95),
    [anon_sym_static] = ACTIONS(1411),
    [anon_sym_get] = ACTIONS(1411),
    [anon_sym_set] = ACTIONS(1411),
    [anon_sym_declare] = ACTIONS(1411),
    [anon_sym_public] = ACTIONS(1411),
    [anon_sym_private] = ACTIONS(1411),
    [anon_sym_protected] = ACTIONS(1411),
    [anon_sym_module] = ACTIONS(1411),
    [anon_sym_any] = ACTIONS(1411),
    [anon_sym_number] = ACTIONS(1411),
    [anon_sym_boolean] = ACTIONS(1411),
    [anon_sym_string] = ACTIONS(1411),
    [anon_sym_symbol] = ACTIONS(1411),
    [sym_readonly] = ACTIONS(1411),
  },
  [149] = {
    [sym_import] = STATE(1292),
    [sym_expression_statement] = STATE(170),
    [sym_variable_declaration] = STATE(170),
    [sym_lexical_declaration] = STATE(170),
    [sym_empty_statement] = STATE(170),
    [sym_parenthesized_expression] = STATE(965),
    [sym__expression] = STATE(1292),
    [sym_yield_expression] = STATE(1292),
    [sym_object] = STATE(1437),
    [sym_array] = STATE(1439),
    [sym_class] = STATE(1292),
    [sym_function] = STATE(1132),
    [sym_generator_function] = STATE(1292),
    [sym_arrow_function] = STATE(1292),
    [sym__call_signature] = STATE(3179),
    [sym_call_expression] = STATE(1292),
    [sym_new_expression] = STATE(1292),
    [sym_await_expression] = STATE(1292),
    [sym_member_expression] = STATE(965),
    [sym_subscript_expression] = STATE(965),
    [sym_assignment_expression] = STATE(1292),
    [sym_augmented_assignment_expression] = STATE(1292),
    [sym_ternary_expression] = STATE(1292),
    [sym_binary_expression] = STATE(1292),
    [sym_unary_expression] = STATE(1292),
    [sym_update_expression] = STATE(1292),
    [sym_sequence_expression] = STATE(2833),
    [sym_string] = STATE(1292),
    [sym_template_string] = STATE(1292),
    [sym_regex] = STATE(1292),
    [sym_meta_property] = STATE(1292),
    [sym_decorator] = STATE(2013),
    [sym_formal_parameters] = STATE(2576),
    [sym_non_null_expression] = STATE(1292),
    [sym_type_assertion] = STATE(1292),
    [sym_as_expression] = STATE(1292),
    [sym_internal_module] = STATE(1292),
    [sym_type_arguments] = STATE(391),
    [sym_type_parameters] = STATE(2837),
    [aux_sym_export_statement_repeat1] = STATE(2570),
    [sym_identifier] = ACTIONS(1409),
    [anon_sym_export] = ACTIONS(1411),
    [anon_sym_namespace] = ACTIONS(14