#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 1136
#define LARGE_STATE_COUNT 182
#define SYMBOL_COUNT 227
#define ALIAS_COUNT 7
#define TOKEN_COUNT 121
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_if = 15,
  anon_sym_else = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_new = 53,
  anon_sym_PLUS_EQ = 54,
  anon_sym_DASH_EQ = 55,
  anon_sym_STAR_EQ = 56,
  anon_sym_SLASH_EQ = 57,
  anon_sym_PERCENT_EQ = 58,
  anon_sym_CARET_EQ = 59,
  anon_sym_AMP_EQ = 60,
  anon_sym_PIPE_EQ = 61,
  anon_sym_GT_GT_EQ = 62,
  anon_sym_GT_GT_GT_EQ = 63,
  anon_sym_LT_LT_EQ = 64,
  anon_sym_STAR_STAR_EQ = 65,
  anon_sym_DOT_DOT_DOT = 66,
  anon_sym_QMARK = 67,
  anon_sym_AMP_AMP = 68,
  anon_sym_PIPE_PIPE = 69,
  anon_sym_GT_GT = 70,
  anon_sym_GT_GT_GT = 71,
  anon_sym_LT_LT = 72,
  anon_sym_AMP = 73,
  anon_sym_CARET = 74,
  anon_sym_PIPE = 75,
  anon_sym_PLUS = 76,
  anon_sym_DASH = 77,
  anon_sym_PERCENT = 78,
  anon_sym_STAR_STAR = 79,
  anon_sym_LT_EQ = 80,
  anon_sym_EQ_EQ = 81,
  anon_sym_EQ_EQ_EQ = 82,
  anon_sym_BANG_EQ = 83,
  anon_sym_BANG_EQ_EQ = 84,
  anon_sym_GT_EQ = 85,
  anon_sym_QMARK_QMARK = 86,
  anon_sym_instanceof = 87,
  anon_sym_BANG = 88,
  anon_sym_TILDE = 89,
  anon_sym_typeof = 90,
  anon_sym_void = 91,
  anon_sym_delete = 92,
  anon_sym_PLUS_PLUS = 93,
  anon_sym_DASH_DASH = 94,
  anon_sym_DQUOTE = 95,
  aux_sym_string_token1 = 96,
  anon_sym_SQUOTE = 97,
  aux_sym_string_token2 = 98,
  sym_escape_sequence = 99,
  sym_comment = 100,
  anon_sym_BQUOTE = 101,
  anon_sym_DOLLAR_LBRACE = 102,
  anon_sym_SLASH2 = 103,
  sym_regex_pattern = 104,
  sym_regex_flags = 105,
  sym_number = 106,
  anon_sym_target = 107,
  sym_this = 108,
  sym_super = 109,
  sym_true = 110,
  sym_false = 111,
  sym_null = 112,
  sym_undefined = 113,
  anon_sym_AT = 114,
  anon_sym_static = 115,
  anon_sym_get = 116,
  anon_sym_set = 117,
  sym_preproc = 118,
  sym__automatic_semicolon = 119,
  sym__template_chars = 120,
  sym_program = 121,
  sym_export_statement = 122,
  sym_export_clause = 123,
  sym__import_export_specifier = 124,
  sym__declaration = 125,
  sym_import = 126,
  sym_import_statement = 127,
  sym_import_clause = 128,
  sym__from_clause = 129,
  sym_namespace_import = 130,
  sym_named_imports = 131,
  sym_expression_statement = 132,
  sym_variable_declaration = 133,
  sym_lexical_declaration = 134,
  sym_variable_declarator = 135,
  sym_statement_block = 136,
  sym_if_statement = 137,
  sym_switch_statement = 138,
  sym_for_statement = 139,
  sym_for_in_statement = 140,
  sym__for_header = 141,
  sym_while_statement = 142,
  sym_do_statement = 143,
  sym_try_statement = 144,
  sym_with_statement = 145,
  sym_break_statement = 146,
  sym_continue_statement = 147,
  sym_debugger_statement = 148,
  sym_return_statement = 149,
  sym_throw_statement = 150,
  sym_empty_statement = 151,
  sym_labeled_statement = 152,
  sym_switch_body = 153,
  sym_switch_case = 154,
  sym_switch_default = 155,
  sym_catch_clause = 156,
  sym_finally_clause = 157,
  sym_parenthesized_expression = 158,
  sym__expression = 159,
  sym_yield_expression = 160,
  sym_object = 161,
  sym_assignment_pattern = 162,
  sym_array = 163,
  sym_jsx_element = 164,
  sym_jsx_fragment = 165,
  sym_jsx_expression = 166,
  sym_jsx_opening_element = 167,
  sym_nested_identifier = 168,
  sym_jsx_namespace_name = 169,
  sym_jsx_closing_element = 170,
  sym_jsx_self_closing_element = 171,
  sym_jsx_attribute = 172,
  sym_class = 173,
  sym_class_declaration = 174,
  sym_class_heritage = 175,
  sym_function = 176,
  sym_function_declaration = 177,
  sym_generator_function = 178,
  sym_generator_function_declaration = 179,
  sym_arrow_function = 180,
  sym_call_expression = 181,
  sym_new_expression = 182,
  sym_await_expression = 183,
  sym_member_expression = 184,
  sym_subscript_expression = 185,
  sym_assignment_expression = 186,
  sym_augmented_assignment_expression = 187,
  sym__initializer = 188,
  sym_spread_element = 189,
  sym_ternary_expression = 190,
  sym_binary_expression = 191,
  sym_unary_expression = 192,
  sym_update_expression = 193,
  sym_sequence_expression = 194,
  sym_string = 195,
  sym_template_string = 196,
  sym_template_substitution = 197,
  sym_regex = 198,
  sym_meta_property = 199,
  sym_arguments = 200,
  sym_decorator = 201,
  sym_decorator_member_expression = 202,
  sym_decorator_call_expression = 203,
  sym_class_body = 204,
  sym_public_field_definition = 205,
  sym_formal_parameters = 206,
  sym_rest_parameter = 207,
  sym_method_definition = 208,
  sym_pair = 209,
  sym__property_name = 210,
  sym_computed_property_name = 211,
  aux_sym_program_repeat1 = 212,
  aux_sym_export_statement_repeat1 = 213,
  aux_sym_export_clause_repeat1 = 214,
  aux_sym_named_imports_repeat1 = 215,
  aux_sym_variable_declaration_repeat1 = 216,
  aux_sym_switch_body_repeat1 = 217,
  aux_sym_object_repeat1 = 218,
  aux_sym_array_repeat1 = 219,
  aux_sym_jsx_element_repeat1 = 220,
  aux_sym_jsx_opening_element_repeat1 = 221,
  aux_sym_string_repeat1 = 222,
  aux_sym_string_repeat2 = 223,
  aux_sym_template_string_repeat1 = 224,
  aux_sym_class_body_repeat1 = 225,
  aux_sym_formal_parameters_repeat1 = 226,
  alias_sym_array_pattern = 227,
  alias_sym_export_specifier = 228,
  alias_sym_import_specifier = 229,
  alias_sym_object_pattern = 230,
  alias_sym_property_identifier = 231,
  alias_sym_shorthand_property_identifier = 232,
  alias_sym_statement_identifier = 233,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "??",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym_preproc] = "preproc",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "_import_export_specifier",
  [sym__declaration] = "_declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__expression] = "_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_array] = "array",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_rest_parameter] = "rest_parameter",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_array_pattern] = "array_pattern",
  [alias_sym_export_specifier] = "export_specifier",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_object_pattern] = "object_pattern",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym_preproc] = sym_preproc,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym__declaration] = sym__declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__expression] = sym__expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_array] = sym_array,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_rest_parameter] = sym_rest_parameter,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_array_pattern] = alias_sym_array_pattern,
  [alias_sym_export_specifier] = alias_sym_export_specifier,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_object_pattern] = alias_sym_object_pattern,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_right = 32,
  field_source = 33,
  field_value = 34,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[107] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 2, .length = 1},
  [8] = {.index = 3, .length = 1},
  [9] = {.index = 4, .length = 1},
  [10] = {.index = 4, .length = 1},
  [11] = {.index = 5, .length = 2},
  [12] = {.index = 7, .length = 2},
  [14] = {.index = 9, .length = 2},
  [15] = {.index = 11, .length = 2},
  [16] = {.index = 13, .length = 2},
  [18] = {.index = 15, .length = 1},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 16, .length = 2},
  [21] = {.index = 16, .length = 2},
  [22] = {.index = 18, .length = 2},
  [23] = {.index = 20, .length = 2},
  [24] = {.index = 22, .length = 3},
  [27] = {.index = 25, .length = 2},
  [28] = {.index = 27, .length = 2},
  [29] = {.index = 29, .length = 2},
  [30] = {.index = 31, .length = 2},
  [31] = {.index = 33, .length = 1},
  [32] = {.index = 34, .length = 1},
  [33] = {.index = 35, .length = 1},
  [34] = {.index = 36, .length = 1},
  [35] = {.index = 37, .length = 1},
  [36] = {.index = 38, .length = 1},
  [37] = {.index = 39, .length = 2},
  [38] = {.index = 41, .length = 1},
  [39] = {.index = 42, .length = 1},
  [40] = {.index = 43, .length = 2},
  [41] = {.index = 45, .length = 2},
  [42] = {.index = 47, .length = 2},
  [43] = {.index = 49, .length = 2},
  [44] = {.index = 51, .length = 2},
  [45] = {.index = 51, .length = 2},
  [46] = {.index = 43, .length = 2},
  [47] = {.index = 45, .length = 2},
  [48] = {.index = 47, .length = 2},
  [49] = {.index = 7, .length = 2},
  [50] = {.index = 53, .length = 3},
  [51] = {.index = 43, .length = 2},
  [52] = {.index = 43, .length = 2},
  [53] = {.index = 56, .length = 2},
  [54] = {.index = 58, .length = 2},
  [55] = {.index = 60, .length = 2},
  [56] = {.index = 62, .length = 1},
  [57] = {.index = 63, .length = 1},
  [58] = {.index = 64, .length = 2},
  [59] = {.index = 43, .length = 2},
  [60] = {.index = 66, .length = 2},
  [61] = {.index = 68, .length = 3},
  [62] = {.index = 64, .length = 2},
  [63] = {.index = 71, .length = 1},
  [64] = {.index = 72, .length = 3},
  [65] = {.index = 75, .length = 3},
  [66] = {.index = 78, .length = 2},
  [67] = {.index = 80, .length = 2},
  [68] = {.index = 82, .length = 2},
  [69] = {.index = 84, .length = 1},
  [70] = {.index = 85, .length = 2},
  [71] = {.index = 87, .length = 1},
  [72] = {.index = 88, .length = 2},
  [73] = {.index = 90, .length = 2},
  [74] = {.index = 92, .length = 2},
  [75] = {.index = 94, .length = 2},
  [76] = {.index = 92, .length = 2},
  [77] = {.index = 96, .length = 2},
  [78] = {.index = 98, .length = 3},
  [79] = {.index = 101, .length = 2},
  [80] = {.index = 103, .length = 3},
  [81] = {.index = 106, .length = 2},
  [82] = {.index = 108, .length = 2},
  [83] = {.index = 110, .length = 3},
  [84] = {.index = 113, .length = 2},
  [85] = {.index = 115, .length = 2},
  [86] = {.index = 117, .length = 2},
  [87] = {.index = 119, .length = 3},
  [88] = {.index = 122, .length = 3},
  [89] = {.index = 125, .length = 1},
  [90] = {.index = 126, .length = 2},
  [91] = {.index = 128, .length = 3},
  [92] = {.index = 131, .length = 2},
  [93] = {.index = 131, .length = 2},
  [94] = {.index = 133, .length = 3},
  [95] = {.index = 131, .length = 2},
  [96] = {.index = 131, .length = 2},
  [97] = {.index = 136, .length = 3},
  [98] = {.index = 139, .length = 2},
  [99] = {.index = 139, .length = 2},
  [100] = {.index = 139, .length = 2},
  [101] = {.index = 139, .length = 2},
  [102] = {.index = 141, .length = 4},
  [103] = {.index = 145, .length = 2},
  [104] = {.index = 145, .length = 2},
  [105] = {.index = 145, .length = 2},
  [106] = {.index = 147, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_argument, 0},
    {field_operator, 1},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_source, 1},
  [16] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [18] =
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_body, 2},
    {field_value, 1},
  [22] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [25] =
    {field_body, 2},
    {field_condition, 1},
  [27] =
    {field_body, 1},
    {field_handler, 2},
  [29] =
    {field_body, 1},
    {field_finalizer, 2},
  [31] =
    {field_body, 2},
    {field_object, 1},
  [33] =
    {field_label, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_attribute, 0},
  [36] =
    {field_pattern, 1},
  [37] =
    {field_member, 0},
  [38] =
    {field_property, 0},
  [39] =
    {field_body, 2},
    {field_name, 1},
  [41] =
    {field_body, 2},
  [42] =
    {field_label, 0},
  [43] =
    {field_left, 0},
    {field_right, 2},
  [45] =
    {field_object, 0},
    {field_property, 2},
  [47] =
    {field_body, 2},
    {field_parameter, 0},
  [49] =
    {field_body, 2},
    {field_parameters, 1},
  [51] =
    {field_arguments, 2},
    {field_constructor, 1},
  [53] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [56] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [58] =
    {field_body, 2},
    {field_parameters, 0},
  [60] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [62] =
    {field_source, 2, .inherited = true},
  [63] =
    {field_value, 2},
  [64] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [66] =
    {field_key, 0},
    {field_value, 2},
  [68] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [71] =
    {field_value, 1},
  [72] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [75] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [78] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [80] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [82] =
    {field_flags, 3},
    {field_pattern, 1},
  [84] =
    {field_property, 1},
  [85] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [87] =
    {field_member, 1, .inherited = true},
  [88] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [90] =
    {field_body, 3},
    {field_name, 1},
  [92] =
    {field_body, 3},
    {field_parameter, 1},
  [94] =
    {field_body, 3},
    {field_parameters, 2},
  [96] =
    {field_body, 3},
    {field_parameters, 1},
  [98] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [101] =
    {field_index, 2},
    {field_object, 0},
  [103] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [106] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [108] =
    {field_alias, 2},
    {field_name, 0},
  [110] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [113] =
    {field_body, 1},
    {field_condition, 3},
  [115] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [117] =
    {field_body, 4},
    {field_parameters, 3},
  [119] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [122] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [125] =
    {field_name, 2},
  [126] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [128] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [131] =
    {field_left, 1},
    {field_right, 3},
  [133] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [136] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [139] =
    {field_left, 2},
    {field_right, 4},
  [141] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [145] =
    {field_body, 4},
    {field_parameter, 2},
  [147] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
};

static TSSymbol ts_alias_sequences[107][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [6] = {
    [0] = alias_sym_object_pattern,
  },
  [7] = {
    [0] = alias_sym_array_pattern,
  },
  [9] = {
    [1] = sym_identifier,
  },
  [13] = {
    [1] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [20] = {
    [0] = alias_sym_object_pattern,
  },
  [21] = {
    [0] = alias_sym_array_pattern,
  },
  [25] = {
    [1] = alias_sym_object_pattern,
  },
  [26] = {
    [1] = alias_sym_array_pattern,
  },
  [31] = {
    [1] = alias_sym_statement_identifier,
  },
  [39] = {
    [0] = alias_sym_statement_identifier,
  },
  [40] = {
    [0] = sym_identifier,
  },
  [41] = {
    [0] = sym_identifier,
    [2] = alias_sym_property_identifier,
  },
  [42] = {
    [0] = sym_identifier,
  },
  [44] = {
    [1] = sym_identifier,
  },
  [47] = {
    [2] = alias_sym_property_identifier,
  },
  [49] = {
    [0] = sym_identifier,
  },
  [51] = {
    [0] = alias_sym_object_pattern,
  },
  [52] = {
    [0] = alias_sym_array_pattern,
  },
  [58] = {
    [1] = alias_sym_export_specifier,
  },
  [59] = {
    [0] = alias_sym_shorthand_property_identifier,
  },
  [62] = {
    [1] = alias_sym_import_specifier,
  },
  [74] = {
    [1] = sym_identifier,
  },
  [92] = {
    [1] = sym_identifier,
  },
  [95] = {
    [1] = alias_sym_object_pattern,
  },
  [96] = {
    [1] = alias_sym_array_pattern,
  },
  [98] = {
    [2] = sym_identifier,
  },
  [100] = {
    [2] = alias_sym_object_pattern,
  },
  [101] = {
    [2] = alias_sym_array_pattern,
  },
  [104] = {
    [2] = alias_sym_object_pattern,
  },
  [105] = {
    [2] = alias_sym_array_pattern,
  },
};

static inline bool sym_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    (0 <= lookahead && lookahead <= '#') ||
    ('%' <= lookahead && lookahead <= '/') ||
    (':' <= lookahead && lookahead <= '@') ||
    ('[' <= lookahead && lookahead <= '^') ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~') ||
    lookahead == 160 ||
    lookahead == 8203 ||
    lookahead == 8288 ||
    lookahead == 65279;
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(62);
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '$') ADVANCE(185);
      if (lookahead == '%') ADVANCE(130);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(128);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '0') ADVANCE(175);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '^') ADVANCE(122);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '~') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(186);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead == '!') ADVANCE(63);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(12)
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(150);
      if (lookahead != 0) ADVANCE(151);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '\r') ADVANCE(160);
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(164);
      if (lookahead != 0) ADVANCE(159);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(157);
      if (lookahead != 0) ADVANCE(158);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(153);
      if (lookahead == '\r') ADVANCE(161);
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(164);
      if (lookahead != 0) ADVANCE(159);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(23)
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '[') ADVANCE(26);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(171);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(140);
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == '0') ADVANCE(175);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '~') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(186);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '%') ADVANCE(130);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(128);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '0') ADVANCE(175);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '^') ADVANCE(122);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          lookahead != '@' &&
          lookahead != '~') ADVANCE(186);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '%') ADVANCE(129);
      if (lookahead == '&') ADVANCE(119);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '=') ADVANCE(25);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '^') ADVANCE(121);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(173);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(186);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '%') ADVANCE(129);
      if (lookahead == '&') ADVANCE(119);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '=') ADVANCE(25);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '^') ADVANCE(121);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(186);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      END_STATE();
    case 14:
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(167);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(109);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(21)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      if (lookahead != 0 &&
          (lookahead < 0 || '~' < lookahead)) ADVANCE(186);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(91);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(23)
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(136);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 26:
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == ']') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(26);
      END_STATE();
    case 27:
      if (lookahead == 'u') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(164);
      if (lookahead != 0) ADVANCE(159);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(164);
      if (lookahead != 0) ADVANCE(159);
      END_STATE();
    case 30:
      if (lookahead == '{') ADVANCE(169);
      END_STATE();
    case 31:
      if (lookahead == '{') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 33:
      if (lookahead == '{') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 38:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(177);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(176);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(180);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(159);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 57:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(26);
      END_STATE();
    case 58:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 59:
      if (eof) ADVANCE(62);
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '$') ADVANCE(185);
      if (lookahead == '%') ADVANCE(130);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(128);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == '0') ADVANCE(175);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '^') ADVANCE(122);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '~') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(186);
      END_STATE();
    case 60:
      if (eof) ADVANCE(62);
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '%') ADVANCE(129);
      if (lookahead == '&') ADVANCE(119);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == '0') ADVANCE(175);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '^') ADVANCE(121);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '~') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(60)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(186);
      END_STATE();
    case 61:
      if (eof) ADVANCE(62);
      if (lookahead == '!') ADVANCE(140);
      if (lookahead == '"') ADVANCE(145);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(71);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == '0') ADVANCE(175);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '`') ADVANCE(168);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '~') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(61)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead) &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(186);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(132);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(131);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(96);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(96);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(118);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(113);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(114);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(167);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(91);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(88);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(18);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(88);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(18);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(91);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(139);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(116);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(111);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(111);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '|') ADVANCE(112);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(112);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(143);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(144);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(144);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(136);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(149);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(148);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(149);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(146);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(153);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(28);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(186);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(159);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(163);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(167);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '[') ADVANCE(26);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(26);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(28);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(173);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(186);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(183);
      if (lookahead == '0') ADVANCE(180);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(38);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(39);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(46);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(176);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(183);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(174);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == '_') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      if (lookahead != 0 &&
          (lookahead < 0 || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(186);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '{') ADVANCE(169);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(28);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_preproc);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 61},
  [2] = {.lex_state = 61},
  [3] = {.lex_state = 61},
  [4] = {.lex_state = 61},
  [5] = {.lex_state = 61},
  [6] = {.lex_state = 61},
  [7] = {.lex_state = 61},
  [8] = {.lex_state = 61},
  [9] = {.lex_state = 61},
  [10] = {.lex_state = 61},
  [11] = {.lex_state = 61},
  [12] = {.lex_state = 61},
  [13] = {.lex_state = 61},
  [14] = {.lex_state = 61},
  [15] = {.lex_state = 61},
  [16] = {.lex_state = 61},
  [17] = {.lex_state = 61},
  [18] = {.lex_state = 61},
  [19] = {.lex_state = 61},
  [20] = {.lex_state = 61},
  [21] = {.lex_state = 61},
  [22] = {.lex_state = 61},
  [23] = {.lex_state = 61},
  [24] = {.lex_state = 61},
  [25] = {.lex_state = 61},
  [26] = {.lex_state = 61},
  [27] = {.lex_state = 61},
  [28] = {.lex_state = 61},
  [29] = {.lex_state = 61},
  [30] = {.lex_state = 61},
  [31] = {.lex_state = 61},
  [32] = {.lex_state = 61},
  [33] = {.lex_state = 61},
  [34] = {.lex_state = 61},
  [35] = {.lex_state = 61},
  [36] = {.lex_state = 61},
  [37] = {.lex_state = 61},
  [38] = {.lex_state = 61},
  [39] = {.lex_state = 61},
  [40] = {.lex_state = 61},
  [41] = {.lex_state = 61},
  [42] = {.lex_state = 61},
  [43] = {.lex_state = 60},
  [44] = {.lex_state = 60, .external_lex_state = 2},
  [45] = {.lex_state = 60, .external_lex_state = 2},
  [46] = {.lex_state = 60, .external_lex_state = 2},
  [47] = {.lex_state = 60, .external_lex_state = 2},
  [48] = {.lex_state = 60, .external_lex_state = 2},
  [49] = {.lex_state = 60, .external_lex_state = 2},
  [50] = {.lex_state = 60, .external_lex_state = 2},
  [51] = {.lex_state = 60, .external_lex_state = 2},
  [52] = {.lex_state = 60, .external_lex_state = 2},
  [53] = {.lex_state = 60, .external_lex_state = 2},
  [54] = {.lex_state = 60, .external_lex_state = 2},
  [55] = {.lex_state = 60, .external_lex_state = 2},
  [56] = {.lex_state = 60, .external_lex_state = 2},
  [57] = {.lex_state = 60, .external_lex_state = 2},
  [58] = {.lex_state = 60, .external_lex_state = 2},
  [59] = {.lex_state = 60, .external_lex_state = 2},
  [60] = {.lex_state = 61},
  [61] = {.lex_state = 61},
  [62] = {.lex_state = 61},
  [63] = {.lex_state = 61},
  [64] = {.lex_state = 61},
  [65] = {.lex_state = 61},
  [66] = {.lex_state = 61},
  [67] = {.lex_state = 61},
  [68] = {.lex_state = 61},
  [69] = {.lex_state = 61},
  [70] = {.lex_state = 61},
  [71] = {.lex_state = 61},
  [72] = {.lex_state = 61},
  [73] = {.lex_state = 61},
  [74] = {.lex_state = 61},
  [75] = {.lex_state = 61},
  [76] = {.lex_state = 61, .external_lex_state = 2},
  [77] = {.lex_state = 61},
  [78] = {.lex_state = 61},
  [79] = {.lex_state = 61},
  [80] = {.lex_state = 61},
  [81] = {.lex_state = 61},
  [82] = {.lex_state = 61},
  [83] = {.lex_state = 61},
  [84] = {.lex_state = 61},
  [85] = {.lex_state = 61},
  [86] = {.lex_state = 61},
  [87] = {.lex_state = 61},
  [88] = {.lex_state = 61},
  [89] = {.lex_state = 8},
  [90] = {.lex_state = 61},
  [91] = {.lex_state = 61},
  [92] = {.lex_state = 61},
  [93] = {.lex_state = 61},
  [94] = {.lex_state = 8},
  [95] = {.lex_state = 61},
  [96] = {.lex_state = 61},
  [97] = {.lex_state = 61},
  [98] = {.lex_state = 61},
  [99] = {.lex_state = 61},
  [100] = {.lex_state = 61},
  [101] = {.lex_state = 61},
  [102] = {.lex_state = 61},
  [103] = {.lex_state = 61},
  [104] = {.lex_state = 61},
  [105] = {.lex_state = 61},
  [106] = {.lex_state = 61},
  [107] = {.lex_state = 61},
  [108] = {.lex_state = 61},
  [109] = {.lex_state = 61},
  [110] = {.lex_state = 61},
  [111] = {.lex_state = 61},
  [112] = {.lex_state = 61},
  [113] = {.lex_state = 61},
  [114] = {.lex_state = 61},
  [115] = {.lex_state = 61},
  [116] = {.lex_state = 61},
  [117] = {.lex_state = 61},
  [118] = {.lex_state = 61},
  [119] = {.lex_state = 61},
  [120] = {.lex_state = 61},
  [121] = {.lex_state = 61},
  [122] = {.lex_state = 61},
  [123] = {.lex_state = 61},
  [124] = {.lex_state = 61},
  [125] = {.lex_state = 61},
  [126] = {.lex_state = 61},
  [127] = {.lex_state = 61},
  [128] = {.lex_state = 61},
  [129] = {.lex_state = 61},
  [130] = {.lex_state = 61},
  [131] = {.lex_state = 61},
  [132] = {.lex_state = 61},
  [133] = {.lex_state = 61},
  [134] = {.lex_state = 61},
  [135] = {.lex_state = 61},
  [136] = {.lex_state = 61},
  [137] = {.lex_state = 61},
  [138] = {.lex_state = 61},
  [139] = {.lex_state = 61},
  [140] = {.lex_state = 61},
  [141] = {.lex_state = 61},
  [142] = {.lex_state = 61},
  [143] = {.lex_state = 61},
  [144] = {.lex_state = 61},
  [145] = {.lex_state = 61},
  [146] = {.lex_state = 61},
  [147] = {.lex_state = 61},
  [148] = {.lex_state = 61},
  [149] = {.lex_state = 61},
  [150] = {.lex_state = 61},
  [151] = {.lex_state = 61},
  [152] = {.lex_state = 61},
  [153] = {.lex_state = 61},
  [154] = {.lex_state = 61},
  [155] = {.lex_state = 61},
  [156] = {.lex_state = 61},
  [157] = {.lex_state = 61},
  [158] = {.lex_state = 61},
  [159] = {.lex_state = 61},
  [160] = {.lex_state = 61},
  [161] = {.lex_state = 61},
  [162] = {.lex_state = 61},
  [163] = {.lex_state = 61},
  [164] = {.lex_state = 61},
  [165] = {.lex_state = 61},
  [166] = {.lex_state = 61},
  [167] = {.lex_state = 61},
  [168] = {.lex_state = 61},
  [169] = {.lex_state = 61},
  [170] = {.lex_state = 61},
  [171] = {.lex_state = 61},
  [172] = {.lex_state = 61},
  [173] = {.lex_state = 61},
  [174] = {.lex_state = 61},
  [175] = {.lex_state = 61},
  [176] = {.lex_state = 61},
  [177] = {.lex_state = 61},
  [178] = {.lex_state = 9, .external_lex_state = 2},
  [179] = {.lex_state = 9, .external_lex_state = 2},
  [180] = {.lex_state = 61, .external_lex_state = 2},
  [181] = {.lex_state = 61, .external_lex_state = 2},
  [182] = {.lex_state = 9, .external_lex_state = 2},
  [183] = {.lex_state = 9, .external_lex_state = 2},
  [184] = {.lex_state = 61},
  [185] = {.lex_state = 61},
  [186] = {.lex_state = 61},
  [187] = {.lex_state = 9, .external_lex_state = 2},
  [188] = {.lex_state = 9, .external_lex_state = 2},
  [189] = {.lex_state = 61},
  [190] = {.lex_state = 61, .external_lex_state = 2},
  [191] = {.lex_state = 61, .external_lex_state = 2},
  [192] = {.lex_state = 61, .external_lex_state = 2},
  [193] = {.lex_state = 61, .external_lex_state = 2},
  [194] = {.lex_state = 61, .external_lex_state = 2},
  [195] = {.lex_state = 61, .external_lex_state = 2},
  [196] = {.lex_state = 61},
  [197] = {.lex_state = 9},
  [198] = {.lex_state = 61, .external_lex_state = 2},
  [199] = {.lex_state = 61, .external_lex_state = 2},
  [200] = {.lex_state = 61},
  [201] = {.lex_state = 61, .external_lex_state = 2},
  [202] = {.lex_state = 61, .external_lex_state = 2},
  [203] = {.lex_state = 61, .external_lex_state = 2},
  [204] = {.lex_state = 61, .external_lex_state = 2},
  [205] = {.lex_state = 61},
  [206] = {.lex_state = 61},
  [207] = {.lex_state = 61},
  [208] = {.lex_state = 61},
  [209] = {.lex_state = 61, .external_lex_state = 2},
  [210] = {.lex_state = 61, .external_lex_state = 2},
  [211] = {.lex_state = 61},
  [212] = {.lex_state = 61},
  [213] = {.lex_state = 61},
  [214] = {.lex_state = 61},
  [215] = {.lex_state = 61},
  [216] = {.lex_state = 61},
  [217] = {.lex_state = 61},
  [218] = {.lex_state = 61},
  [219] = {.lex_state = 61},
  [220] = {.lex_state = 61},
  [221] = {.lex_state = 61},
  [222] = {.lex_state = 61},
  [223] = {.lex_state = 61},
  [224] = {.lex_state = 61},
  [225] = {.lex_state = 61},
  [226] = {.lex_state = 61},
  [227] = {.lex_state = 61},
  [228] = {.lex_state = 61},
  [229] = {.lex_state = 61},
  [230] = {.lex_state = 61},
  [231] = {.lex_state = 61},
  [232] = {.lex_state = 61},
  [233] = {.lex_state = 61},
  [234] = {.lex_state = 61},
  [235] = {.lex_state = 61},
  [236] = {.lex_state = 61},
  [237] = {.lex_state = 61},
  [238] = {.lex_state = 61},
  [239] = {.lex_state = 61},
  [240] = {.lex_state = 9},
  [241] = {.lex_state = 61},
  [242] = {.lex_state = 61},
  [243] = {.lex_state = 61},
  [244] = {.lex_state = 61},
  [245] = {.lex_state = 61},
  [246] = {.lex_state = 61},
  [247] = {.lex_state = 61},
  [248] = {.lex_state = 61},
  [249] = {.lex_state = 61},
  [250] = {.lex_state = 61},
  [251] = {.lex_state = 61},
  [252] = {.lex_state = 61},
  [253] = {.lex_state = 61},
  [254] = {.lex_state = 61},
  [255] = {.lex_state = 61},
  [256] = {.lex_state = 9, .external_lex_state = 2},
  [257] = {.lex_state = 9, .external_lex_state = 2},
  [258] = {.lex_state = 9, .external_lex_state = 2},
  [259] = {.lex_state = 9, .external_lex_state = 2},
  [260] = {.lex_state = 9, .external_lex_state = 2},
  [261] = {.lex_state = 9},
  [262] = {.lex_state = 61},
  [263] = {.lex_state = 61},
  [264] = {.lex_state = 9},
  [265] = {.lex_state = 9},
  [266] = {.lex_state = 61},
  [267] = {.lex_state = 61},
  [268] = {.lex_state = 61},
  [269] = {.lex_state = 61},
  [270] = {.lex_state = 61},
  [271] = {.lex_state = 61},
  [272] = {.lex_state = 61},
  [273] = {.lex_state = 9},
  [274] = {.lex_state = 9},
  [275] = {.lex_state = 9},
  [276] = {.lex_state = 9},
  [277] = {.lex_state = 9},
  [278] = {.lex_state = 9},
  [279] = {.lex_state = 9, .external_lex_state = 2},
  [280] = {.lex_state = 9},
  [281] = {.lex_state = 9},
  [282] = {.lex_state = 9, .external_lex_state = 2},
  [283] = {.lex_state = 9},
  [284] = {.lex_state = 9},
  [285] = {.lex_state = 9, .external_lex_state = 2},
  [286] = {.lex_state = 9, .external_lex_state = 2},
  [287] = {.lex_state = 9, .external_lex_state = 2},
  [288] = {.lex_state = 9, .external_lex_state = 2},
  [289] = {.lex_state = 9, .external_lex_state = 2},
  [290] = {.lex_state = 9, .external_lex_state = 2},
  [291] = {.lex_state = 9, .external_lex_state = 2},
  [292] = {.lex_state = 9, .external_lex_state = 2},
  [293] = {.lex_state = 9, .external_lex_state = 2},
  [294] = {.lex_state = 9, .external_lex_state = 2},
  [295] = {.lex_state = 9, .external_lex_state = 2},
  [296] = {.lex_state = 9, .external_lex_state = 2},
  [297] = {.lex_state = 9, .external_lex_state = 2},
  [298] = {.lex_state = 9, .external_lex_state = 2},
  [299] = {.lex_state = 9, .external_lex_state = 2},
  [300] = {.lex_state = 9, .external_lex_state = 2},
  [301] = {.lex_state = 60},
  [302] = {.lex_state = 9, .external_lex_state = 2},
  [303] = {.lex_state = 60},
  [304] = {.lex_state = 9},
  [305] = {.lex_state = 9, .external_lex_state = 2},
  [306] = {.lex_state = 9},
  [307] = {.lex_state = 60},
  [308] = {.lex_state = 9},
  [309] = {.lex_state = 9},
  [310] = {.lex_state = 9},
  [311] = {.lex_state = 9},
  [312] = {.lex_state = 9},
  [313] = {.lex_state = 9},
  [314] = {.lex_state = 9},
  [315] = {.lex_state = 60, .external_lex_state = 2},
  [316] = {.lex_state = 60},
  [317] = {.lex_state = 60},
  [318] = {.lex_state = 60},
  [319] = {.lex_state = 60},
  [320] = {.lex_state = 60},
  [321] = {.lex_state = 60},
  [322] = {.lex_state = 60},
  [323] = {.lex_state = 60},
  [324] = {.lex_state = 60},
  [325] = {.lex_state = 60},
  [326] = {.lex_state = 60},
  [327] = {.lex_state = 60},
  [328] = {.lex_state = 60},
  [329] = {.lex_state = 60},
  [330] = {.lex_state = 60},
  [331] = {.lex_state = 60},
  [332] = {.lex_state = 60},
  [333] = {.lex_state = 60},
  [334] = {.lex_state = 60},
  [335] = {.lex_state = 60},
  [336] = {.lex_state = 60},
  [337] = {.lex_state = 60},
  [338] = {.lex_state = 60},
  [339] = {.lex_state = 60},
  [340] = {.lex_state = 60},
  [341] = {.lex_state = 60},
  [342] = {.lex_state = 60},
  [343] = {.lex_state = 60},
  [344] = {.lex_state = 60},
  [345] = {.lex_state = 60},
  [346] = {.lex_state = 60},
  [347] = {.lex_state = 60, .external_lex_state = 2},
  [348] = {.lex_state = 60},
  [349] = {.lex_state = 60},
  [350] = {.lex_state = 60},
  [351] = {.lex_state = 60},
  [352] = {.lex_state = 60},
  [353] = {.lex_state = 60},
  [354] = {.lex_state = 60},
  [355] = {.lex_state = 60},
  [356] = {.lex_state = 60},
  [357] = {.lex_state = 60, .external_lex_state = 2},
  [358] = {.lex_state = 10},
  [359] = {.lex_state = 60},
  [360] = {.lex_state = 60},
  [361] = {.lex_state = 60},
  [362] = {.lex_state = 60},
  [363] = {.lex_state = 60, .external_lex_state = 2},
  [364] = {.lex_state = 60},
  [365] = {.lex_state = 60, .external_lex_state = 2},
  [366] = {.lex_state = 60, .external_lex_state = 2},
  [367] = {.lex_state = 60},
  [368] = {.lex_state = 60, .external_lex_state = 2},
  [369] = {.lex_state = 60},
  [370] = {.lex_state = 60},
  [371] = {.lex_state = 60, .external_lex_state = 2},
  [372] = {.lex_state = 60, .external_lex_state = 2},
  [373] = {.lex_state = 60, .external_lex_state = 2},
  [374] = {.lex_state = 60, .external_lex_state = 2},
  [375] = {.lex_state = 60},
  [376] = {.lex_state = 60, .external_lex_state = 2},
  [377] = {.lex_state = 60, .external_lex_state = 2},
  [378] = {.lex_state = 60, .external_lex_state = 2},
  [379] = {.lex_state = 60},
  [380] = {.lex_state = 60},
  [381] = {.lex_state = 60},
  [382] = {.lex_state = 60},
  [383] = {.lex_state = 60, .external_lex_state = 2},
  [384] = {.lex_state = 60, .external_lex_state = 2},
  [385] = {.lex_state = 60, .external_lex_state = 2},
  [386] = {.lex_state = 60},
  [387] = {.lex_state = 60, .external_lex_state = 2},
  [388] = {.lex_state = 60},
  [389] = {.lex_state = 60},
  [390] = {.lex_state = 60, .external_lex_state = 2},
  [391] = {.lex_state = 60, .external_lex_state = 2},
  [392] = {.lex_state = 60},
  [393] = {.lex_state = 60, .external_lex_state = 2},
  [394] = {.lex_state = 60, .external_lex_state = 2},
  [395] = {.lex_state = 60, .external_lex_state = 2},
  [396] = {.lex_state = 60},
  [397] = {.lex_state = 60},
  [398] = {.lex_state = 60},
  [399] = {.lex_state = 60},
  [400] = {.lex_state = 60},
  [401] = {.lex_state = 60},
  [402] = {.lex_state = 60},
  [403] = {.lex_state = 60, .external_lex_state = 2},
  [404] = {.lex_state = 60, .external_lex_state = 2},
  [405] = {.lex_state = 60, .external_lex_state = 2},
  [406] = {.lex_state = 60},
  [407] = {.lex_state = 60},
  [408] = {.lex_state = 60, .external_lex_state = 2},
  [409] = {.lex_state = 60, .external_lex_state = 2},
  [410] = {.lex_state = 60, .external_lex_state = 2},
  [411] = {.lex_state = 60, .external_lex_state = 2},
  [412] = {.lex_state = 60, .external_lex_state = 2},
  [413] = {.lex_state = 60, .external_lex_state = 2},
  [414] = {.lex_state = 60, .external_lex_state = 2},
  [415] = {.lex_state = 60, .external_lex_state = 2},
  [416] = {.lex_state = 60, .external_lex_state = 2},
  [417] = {.lex_state = 60},
  [418] = {.lex_state = 60},
  [419] = {.lex_state = 60, .external_lex_state = 2},
  [420] = {.lex_state = 60, .external_lex_state = 2},
  [421] = {.lex_state = 60, .external_lex_state = 2},
  [422] = {.lex_state = 60, .external_lex_state = 2},
  [423] = {.lex_state = 60, .external_lex_state = 2},
  [424] = {.lex_state = 60, .external_lex_state = 2},
  [425] = {.lex_state = 60, .external_lex_state = 2},
  [426] = {.lex_state = 60},
  [427] = {.lex_state = 60},
  [428] = {.lex_state = 60, .external_lex_state = 2},
  [429] = {.lex_state = 60},
  [430] = {.lex_state = 60},
  [431] = {.lex_state = 60},
  [432] = {.lex_state = 60},
  [433] = {.lex_state = 60, .external_lex_state = 2},
  [434] = {.lex_state = 60},
  [435] = {.lex_state = 60},
  [436] = {.lex_state = 60},
  [437] = {.lex_state = 60, .external_lex_state = 2},
  [438] = {.lex_state = 60, .external_lex_state = 2},
  [439] = {.lex_state = 60},
  [440] = {.lex_state = 60},
  [441] = {.lex_state = 60},
  [442] = {.lex_state = 60},
  [443] = {.lex_state = 60},
  [444] = {.lex_state = 60},
  [445] = {.lex_state = 60},
  [446] = {.lex_state = 60},
  [447] = {.lex_state = 60},
  [448] = {.lex_state = 60},
  [449] = {.lex_state = 60, .external_lex_state = 2},
  [450] = {.lex_state = 60},
  [451] = {.lex_state = 60, .external_lex_state = 2},
  [452] = {.lex_state = 60, .external_lex_state = 2},
  [453] = {.lex_state = 60, .external_lex_state = 2},
  [454] = {.lex_state = 60},
  [455] = {.lex_state = 60, .external_lex_state = 2},
  [456] = {.lex_state = 60, .external_lex_state = 2},
  [457] = {.lex_state = 60},
  [458] = {.lex_state = 60, .external_lex_state = 2},
  [459] = {.lex_state = 60, .external_lex_state = 2},
  [460] = {.lex_state = 60},
  [461] = {.lex_state = 60, .external_lex_state = 2},
  [462] = {.lex_state = 60, .external_lex_state = 2},
  [463] = {.lex_state = 60, .external_lex_state = 2},
  [464] = {.lex_state = 60, .external_lex_state = 2},
  [465] = {.lex_state = 60},
  [466] = {.lex_state = 60, .external_lex_state = 2},
  [467] = {.lex_state = 60, .external_lex_state = 2},
  [468] = {.lex_state = 60, .external_lex_state = 2},
  [469] = {.lex_state = 60},
  [470] = {.lex_state = 60, .external_lex_state = 2},
  [471] = {.lex_state = 60, .external_lex_state = 2},
  [472] = {.lex_state = 60, .external_lex_state = 2},
  [473] = {.lex_state = 60, .external_lex_state = 2},
  [474] = {.lex_state = 60, .external_lex_state = 2},
  [475] = {.lex_state = 10, .external_lex_state = 2},
  [476] = {.lex_state = 60, .external_lex_state = 2},
  [477] = {.lex_state = 60},
  [478] = {.lex_state = 60},
  [479] = {.lex_state = 60},
  [480] = {.lex_state = 60, .external_lex_state = 2},
  [481] = {.lex_state = 60, .external_lex_state = 2},
  [482] = {.lex_state = 60, .external_lex_state = 2},
  [483] = {.lex_state = 60, .external_lex_state = 2},
  [484] = {.lex_state = 60, .external_lex_state = 2},
  [485] = {.lex_state = 60},
  [486] = {.lex_state = 60},
  [487] = {.lex_state = 60},
  [488] = {.lex_state = 60, .external_lex_state = 2},
  [489] = {.lex_state = 60, .external_lex_state = 2},
  [490] = {.lex_state = 60, .external_lex_state = 2},
  [491] = {.lex_state = 60, .external_lex_state = 2},
  [492] = {.lex_state = 60, .external_lex_state = 2},
  [493] = {.lex_state = 60, .external_lex_state = 2},
  [494] = {.lex_state = 60},
  [495] = {.lex_state = 60},
  [496] = {.lex_state = 60},
  [497] = {.lex_state = 60},
  [498] = {.lex_state = 60},
  [499] = {.lex_state = 60},
  [500] = {.lex_state = 60},
  [501] = {.lex_state = 60, .external_lex_state = 2},
  [502] = {.lex_state = 60},
  [503] = {.lex_state = 60},
  [504] = {.lex_state = 60},
  [505] = {.lex_state = 60},
  [506] = {.lex_state = 60, .external_lex_state = 2},
  [507] = {.lex_state = 60, .external_lex_state = 2},
  [508] = {.lex_state = 60, .external_lex_state = 2},
  [509] = {.lex_state = 60},
  [510] = {.lex_state = 60},
  [511] = {.lex_state = 60, .external_lex_state = 2},
  [512] = {.lex_state = 60},
  [513] = {.lex_state = 60, .external_lex_state = 2},
  [514] = {.lex_state = 60, .external_lex_state = 2},
  [515] = {.lex_state = 60, .external_lex_state = 2},
  [516] = {.lex_state = 60, .external_lex_state = 2},
  [517] = {.lex_state = 60, .external_lex_state = 2},
  [518] = {.lex_state = 60, .external_lex_state = 2},
  [519] = {.lex_state = 60, .external_lex_state = 2},
  [520] = {.lex_state = 60},
  [521] = {.lex_state = 60, .external_lex_state = 2},
  [522] = {.lex_state = 60, .external_lex_state = 2},
  [523] = {.lex_state = 60, .external_lex_state = 2},
  [524] = {.lex_state = 60},
  [525] = {.lex_state = 60, .external_lex_state = 2},
  [526] = {.lex_state = 60, .external_lex_state = 2},
  [527] = {.lex_state = 60},
  [528] = {.lex_state = 60},
  [529] = {.lex_state = 60, .external_lex_state = 2},
  [530] = {.lex_state = 60, .external_lex_state = 2},
  [531] = {.lex_state = 60},
  [532] = {.lex_state = 60, .external_lex_state = 2},
  [533] = {.lex_state = 60, .external_lex_state = 2},
  [534] = {.lex_state = 60, .external_lex_state = 2},
  [535] = {.lex_state = 60, .external_lex_state = 2},
  [536] = {.lex_state = 60, .external_lex_state = 2},
  [537] = {.lex_state = 60, .external_lex_state = 2},
  [538] = {.lex_state = 60, .external_lex_state = 2},
  [539] = {.lex_state = 60},
  [540] = {.lex_state = 60, .external_lex_state = 2},
  [541] = {.lex_state = 60, .external_lex_state = 2},
  [542] = {.lex_state = 60},
  [543] = {.lex_state = 60, .external_lex_state = 2},
  [544] = {.lex_state = 60, .external_lex_state = 2},
  [545] = {.lex_state = 60},
  [546] = {.lex_state = 60, .external_lex_state = 2},
  [547] = {.lex_state = 60, .external_lex_state = 2},
  [548] = {.lex_state = 60},
  [549] = {.lex_state = 60, .external_lex_state = 2},
  [550] = {.lex_state = 60, .external_lex_state = 2},
  [551] = {.lex_state = 60, .external_lex_state = 2},
  [552] = {.lex_state = 60, .external_lex_state = 2},
  [553] = {.lex_state = 60, .external_lex_state = 2},
  [554] = {.lex_state = 60, .external_lex_state = 2},
  [555] = {.lex_state = 60, .external_lex_state = 2},
  [556] = {.lex_state = 60, .external_lex_state = 2},
  [557] = {.lex_state = 60},
  [558] = {.lex_state = 60, .external_lex_state = 2},
  [559] = {.lex_state = 60},
  [560] = {.lex_state = 60},
  [561] = {.lex_state = 60, .external_lex_state = 2},
  [562] = {.lex_state = 60, .external_lex_state = 2},
  [563] = {.lex_state = 60, .external_lex_state = 2},
  [564] = {.lex_state = 60},
  [565] = {.lex_state = 60},
  [566] = {.lex_state = 60},
  [567] = {.lex_state = 60},
  [568] = {.lex_state = 60},
  [569] = {.lex_state = 60},
  [570] = {.lex_state = 60},
  [571] = {.lex_state = 60},
  [572] = {.lex_state = 60},
  [573] = {.lex_state = 60},
  [574] = {.lex_state = 60},
  [575] = {.lex_state = 60},
  [576] = {.lex_state = 60},
  [577] = {.lex_state = 61},
  [578] = {.lex_state = 61},
  [579] = {.lex_state = 61},
  [580] = {.lex_state = 61},
  [581] = {.lex_state = 61},
  [582] = {.lex_state = 61},
  [583] = {.lex_state = 61},
  [584] = {.lex_state = 61},
  [585] = {.lex_state = 61},
  [586] = {.lex_state = 61},
  [587] = {.lex_state = 61},
  [588] = {.lex_state = 61},
  [589] = {.lex_state = 61},
  [590] = {.lex_state = 61},
  [591] = {.lex_state = 61},
  [592] = {.lex_state = 61},
  [593] = {.lex_state = 61},
  [594] = {.lex_state = 61},
  [595] = {.lex_state = 61},
  [596] = {.lex_state = 61},
  [597] = {.lex_state = 61},
  [598] = {.lex_state = 61},
  [599] = {.lex_state = 61, .external_lex_state = 2},
  [600] = {.lex_state = 61, .external_lex_state = 2},
  [601] = {.lex_state = 61, .external_lex_state = 2},
  [602] = {.lex_state = 61},
  [603] = {.lex_state = 61},
  [604] = {.lex_state = 60},
  [605] = {.lex_state = 61},
  [606] = {.lex_state = 61, .external_lex_state = 2},
  [607] = {.lex_state = 60},
  [608] = {.lex_state = 61, .external_lex_state = 2},
  [609] = {.lex_state = 60},
  [610] = {.lex_state = 60},
  [611] = {.lex_state = 61},
  [612] = {.lex_state = 61},
  [613] = {.lex_state = 61},
  [614] = {.lex_state = 61},
  [615] = {.lex_state = 61},
  [616] = {.lex_state = 61},
  [617] = {.lex_state = 61},
  [618] = {.lex_state = 61},
  [619] = {.lex_state = 61},
  [620] = {.lex_state = 61},
  [621] = {.lex_state = 61},
  [622] = {.lex_state = 61},
  [623] = {.lex_state = 61},
  [624] = {.lex_state = 61},
  [625] = {.lex_state = 61},
  [626] = {.lex_state = 61},
  [627] = {.lex_state = 61},
  [628] = {.lex_state = 61},
  [629] = {.lex_state = 61},
  [630] = {.lex_state = 61},
  [631] = {.lex_state = 61},
  [632] = {.lex_state = 61},
  [633] = {.lex_state = 61},
  [634] = {.lex_state = 61},
  [635] = {.lex_state = 61},
  [636] = {.lex_state = 61},
  [637] = {.lex_state = 61},
  [638] = {.lex_state = 61},
  [639] = {.lex_state = 61},
  [640] = {.lex_state = 61},
  [641] = {.lex_state = 61},
  [642] = {.lex_state = 61},
  [643] = {.lex_state = 61},
  [644] = {.lex_state = 21},
  [645] = {.lex_state = 21},
  [646] = {.lex_state = 21},
  [647] = {.lex_state = 21},
  [648] = {.lex_state = 21},
  [649] = {.lex_state = 21},
  [650] = {.lex_state = 21},
  [651] = {.lex_state = 61},
  [652] = {.lex_state = 61},
  [653] = {.lex_state = 21},
  [654] = {.lex_state = 21},
  [655] = {.lex_state = 21},
  [656] = {.lex_state = 21},
  [657] = {.lex_state = 21},
  [658] = {.lex_state = 21},
  [659] = {.lex_state = 22},
  [660] = {.lex_state = 21},
  [661] = {.lex_state = 22},
  [662] = {.lex_state = 22},
  [663] = {.lex_state = 21},
  [664] = {.lex_state = 21},
  [665] = {.lex_state = 21},
  [666] = {.lex_state = 21},
  [667] = {.lex_state = 22},
  [668] = {.lex_state = 22},
  [669] = {.lex_state = 22},
  [670] = {.lex_state = 21},
  [671] = {.lex_state = 22},
  [672] = {.lex_state = 21},
  [673] = {.lex_state = 21},
  [674] = {.lex_state = 22},
  [675] = {.lex_state = 22},
  [676] = {.lex_state = 22},
  [677] = {.lex_state = 22},
  [678] = {.lex_state = 22},
  [679] = {.lex_state = 22},
  [680] = {.lex_state = 22},
  [681] = {.lex_state = 22},
  [682] = {.lex_state = 21},
  [683] = {.lex_state = 61},
  [684] = {.lex_state = 0, .external_lex_state = 2},
  [685] = {.lex_state = 61},
  [686] = {.lex_state = 61},
  [687] = {.lex_state = 13, .external_lex_state = 3},
  [688] = {.lex_state = 61},
  [689] = {.lex_state = 60},
  [690] = {.lex_state = 13, .external_lex_state = 3},
  [691] = {.lex_state = 13, .external_lex_state = 3},
  [692] = {.lex_state = 61},
  [693] = {.lex_state = 0, .external_lex_state = 2},
  [694] = {.lex_state = 21},
  [695] = {.lex_state = 60},
  [696] = {.lex_state = 21},
  [697] = {.lex_state = 61},
  [698] = {.lex_state = 60},
  [699] = {.lex_state = 13, .external_lex_state = 3},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 21},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 13, .external_lex_state = 3},
  [704] = {.lex_state = 61},
  [705] = {.lex_state = 21},
  [706] = {.lex_state = 0, .external_lex_state = 2},
  [707] = {.lex_state = 21},
  [708] = {.lex_state = 21},
  [709] = {.lex_state = 61},
  [710] = {.lex_state = 0, .external_lex_state = 2},
  [711] = {.lex_state = 21},
  [712] = {.lex_state = 21},
  [713] = {.lex_state = 61},
  [714] = {.lex_state = 61},
  [715] = {.lex_state = 21},
  [716] = {.lex_state = 61},
  [717] = {.lex_state = 61},
  [718] = {.lex_state = 21},
  [719] = {.lex_state = 21},
  [720] = {.lex_state = 21},
  [721] = {.lex_state = 21},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 61},
  [724] = {.lex_state = 21},
  [725] = {.lex_state = 0, .external_lex_state = 2},
  [726] = {.lex_state = 61},
  [727] = {.lex_state = 21},
  [728] = {.lex_state = 21},
  [729] = {.lex_state = 21},
  [730] = {.lex_state = 21},
  [731] = {.lex_state = 21},
  [732] = {.lex_state = 21},
  [733] = {.lex_state = 21},
  [734] = {.lex_state = 61},
  [735] = {.lex_state = 21},
  [736] = {.lex_state = 61},
  [737] = {.lex_state = 21},
  [738] = {.lex_state = 21},
  [739] = {.lex_state = 61},
  [740] = {.lex_state = 21},
  [741] = {.lex_state = 61},
  [742] = {.lex_state = 21},
  [743] = {.lex_state = 21},
  [744] = {.lex_state = 21},
  [745] = {.lex_state = 21},
  [746] = {.lex_state = 21},
  [747] = {.lex_state = 61},
  [748] = {.lex_state = 21},
  [749] = {.lex_state = 61},
  [750] = {.lex_state = 61},
  [751] = {.lex_state = 21},
  [752] = {.lex_state = 61, .external_lex_state = 2},
  [753] = {.lex_state = 61},
  [754] = {.lex_state = 61},
  [755] = {.lex_state = 13, .external_lex_state = 3},
  [756] = {.lex_state = 3},
  [757] = {.lex_state = 5},
  [758] = {.lex_state = 3},
  [759] = {.lex_state = 5},
  [760] = {.lex_state = 61},
  [761] = {.lex_state = 5},
  [762] = {.lex_state = 3},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 61},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 61},
  [767] = {.lex_state = 61},
  [768] = {.lex_state = 61},
  [769] = {.lex_state = 0, .external_lex_state = 2},
  [770] = {.lex_state = 61},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 61},
  [773] = {.lex_state = 5},
  [774] = {.lex_state = 3},
  [775] = {.lex_state = 3},
  [776] = {.lex_state = 5},
  [777] = {.lex_state = 61},
  [778] = {.lex_state = 5},
  [779] = {.lex_state = 3},
  [780] = {.lex_state = 61},
  [781] = {.lex_state = 61},
  [782] = {.lex_state = 5},
  [783] = {.lex_state = 0, .external_lex_state = 2},
  [784] = {.lex_state = 3},
  [785] = {.lex_state = 0, .external_lex_state = 2},
  [786] = {.lex_state = 0, .external_lex_state = 2},
  [787] = {.lex_state = 61},
  [788] = {.lex_state = 61},
  [789] = {.lex_state = 61},
  [790] = {.lex_state = 0, .external_lex_state = 2},
  [791] = {.lex_state = 61},
  [792] = {.lex_state = 61},
  [793] = {.lex_state = 61},
  [794] = {.lex_state = 0, .external_lex_state = 2},
  [795] = {.lex_state = 21},
  [796] = {.lex_state = 0, .external_lex_state = 2},
  [797] = {.lex_state = 21},
  [798] = {.lex_state = 61},
  [799] = {.lex_state = 21},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 61},
  [802] = {.lex_state = 61},
  [803] = {.lex_state = 61},
  [804] = {.lex_state = 61},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 61},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 61},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 61},
  [820] = {.lex_state = 61},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 61},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 61},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 61},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 61, .external_lex_state = 2},
  [833] = {.lex_state = 61},
  [834] = {.lex_state = 22},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 61},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0, .external_lex_state = 2},
  [840] = {.lex_state = 61, .external_lex_state = 2},
  [841] = {.lex_state = 61, .external_lex_state = 2},
  [842] = {.lex_state = 61, .external_lex_state = 2},
  [843] = {.lex_state = 61},
  [844] = {.lex_state = 8},
  [845] = {.lex_state = 61},
  [846] = {.lex_state = 8},
  [847] = {.lex_state = 61, .external_lex_state = 2},
  [848] = {.lex_state = 8},
  [849] = {.lex_state = 0, .external_lex_state = 2},
  [850] = {.lex_state = 22},
  [851] = {.lex_state = 61},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 8},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 61},
  [857] = {.lex_state = 61},
  [858] = {.lex_state = 61, .external_lex_state = 2},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0, .external_lex_state = 2},
  [868] = {.lex_state = 0, .external_lex_state = 2},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 22},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 22},
  [875] = {.lex_state = 22},
  [876] = {.lex_state = 61},
  [877] = {.lex_state = 22},
  [878] = {.lex_state = 22},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 22},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 61, .external_lex_state = 2},
  [883] = {.lex_state = 61},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 22},
  [887] = {.lex_state = 61, .external_lex_state = 2},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0, .external_lex_state = 2},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 61},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 61},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 61},
  [905] = {.lex_state = 61},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0, .external_lex_state = 2},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0, .external_lex_state = 2},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 61},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0, .external_lex_state = 2},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0, .external_lex_state = 2},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 61},
  [930] = {.lex_state = 0, .external_lex_state = 2},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0, .external_lex_state = 2},
  [936] = {.lex_state = 61},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0, .external_lex_state = 2},
  [941] = {.lex_state = 0, .external_lex_state = 2},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0, .external_lex_state = 2},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0, .external_lex_state = 2},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0, .external_lex_state = 2},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0, .external_lex_state = 2},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0, .external_lex_state = 2},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 21},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 61},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 61},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 8},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 61},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 61},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 8},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 61},
  [1023] = {.lex_state = 8},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 61},
  [1026] = {.lex_state = 8},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0, .external_lex_state = 2},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 61},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 7},
  [1047] = {.lex_state = 61},
  [1048] = {.lex_state = 61},
  [1049] = {.lex_state = 7},
  [1050] = {.lex_state = 61},
  [1051] = {.lex_state = 61},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 61},
  [1055] = {.lex_state = 61},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 61},
  [1058] = {.lex_state = 61},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 61},
  [1062] = {.lex_state = 61},
  [1063] = {.lex_state = 61},
  [1064] = {.lex_state = 61},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 61},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 61},
  [1070] = {.lex_state = 61},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 61},
  [1073] = {.lex_state = 61},
  [1074] = {.lex_state = 61},
  [1075] = {.lex_state = 61},
  [1076] = {.lex_state = 61},
  [1077] = {.lex_state = 61},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 61},
  [1080] = {.lex_state = 13},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 61},
  [1084] = {.lex_state = 61},
  [1085] = {.lex_state = 61},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 61},
  [1088] = {.lex_state = 61},
  [1089] = {.lex_state = 61},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 61},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 61},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 61},
  [1098] = {.lex_state = 61},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 61},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 61},
  [1109] = {.lex_state = 13},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 61},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 61},
  [1116] = {.lex_state = 61},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 61},
  [1119] = {.lex_state = 61},
  [1120] = {.lex_state = 61},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 61},
  [1124] = {.lex_state = 61},
  [1125] = {.lex_state = 61},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 61},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 61},
  [1132] = {.lex_state = 61},
  [1133] = {.lex_state = 61},
  [1134] = {.lex_state = 61},
  [1135] = {.lex_state = 61},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
};

static bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym_preproc] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1130),
    [sym_export_statement] = STATE(22),
    [sym__declaration] = STATE(22),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(22),
    [sym_lexical_declaration] = STATE(22),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(22),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(22),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(22),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(91),
  },
  [2] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(809),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(809),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(809),
    [sym_pair] = STATE(809),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(885),
    [sym_identifier] = ACTIONS(93),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(103),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(109),
    [anon_sym_get] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(111),
    [sym_preproc] = ACTIONS(113),
  },
  [3] = {
    [sym_export_statement] = STATE(14),
    [sym__declaration] = STATE(14),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(14),
    [sym_lexical_declaration] = STATE(14),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(809),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(14),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(14),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(14),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(809),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(809),
    [sym_pair] = STATE(809),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(885),
    [sym_identifier] = ACTIONS(93),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(103),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(109),
    [anon_sym_get] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(111),
    [sym_preproc] = ACTIONS(117),
  },
  [4] = {
    [sym_export_statement] = STATE(19),
    [sym__declaration] = STATE(19),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(19),
    [sym_lexical_declaration] = STATE(19),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(884),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(19),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(19),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(19),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(884),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(884),
    [sym_pair] = STATE(884),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(889),
    [sym_identifier] = ACTIONS(119),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(121),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(123),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(125),
    [anon_sym_get] = ACTIONS(127),
    [anon_sym_set] = ACTIONS(127),
    [sym_preproc] = ACTIONS(129),
  },
  [5] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(809),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(809),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(809),
    [sym_pair] = STATE(809),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(885),
    [sym_identifier] = ACTIONS(93),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(103),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(109),
    [anon_sym_get] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(111),
    [sym_preproc] = ACTIONS(113),
  },
  [6] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_export] = ACTIONS(138),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_RBRACE] = ACTIONS(133),
    [anon_sym_import] = ACTIONS(146),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(152),
    [anon_sym_const] = ACTIONS(152),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_switch] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(164),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_while] = ACTIONS(170),
    [anon_sym_do] = ACTIONS(173),
    [anon_sym_try] = ACTIONS(176),
    [anon_sym_with] = ACTIONS(179),
    [anon_sym_break] = ACTIONS(182),
    [anon_sym_continue] = ACTIONS(185),
    [anon_sym_debugger] = ACTIONS(188),
    [anon_sym_return] = ACTIONS(191),
    [anon_sym_throw] = ACTIONS(194),
    [anon_sym_SEMI] = ACTIONS(197),
    [anon_sym_case] = ACTIONS(141),
    [anon_sym_yield] = ACTIONS(200),
    [anon_sym_LBRACK] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(206),
    [anon_sym_SLASH] = ACTIONS(209),
    [anon_sym_class] = ACTIONS(212),
    [anon_sym_async] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(218),
    [anon_sym_new] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(224),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_typeof] = ACTIONS(230),
    [anon_sym_void] = ACTIONS(230),
    [anon_sym_delete] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(233),
    [anon_sym_DASH_DASH] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [anon_sym_SQUOTE] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(242),
    [sym_number] = ACTIONS(245),
    [sym_this] = ACTIONS(248),
    [sym_super] = ACTIONS(251),
    [sym_true] = ACTIONS(248),
    [sym_false] = ACTIONS(248),
    [sym_null] = ACTIONS(248),
    [sym_undefined] = ACTIONS(248),
    [anon_sym_AT] = ACTIONS(254),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(257),
    [anon_sym_set] = ACTIONS(257),
    [sym_preproc] = ACTIONS(260),
  },
  [7] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [8] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(273),
  },
  [9] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(275),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [10] = {
    [sym_export_statement] = STATE(9),
    [sym__declaration] = STATE(9),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(9),
    [sym_lexical_declaration] = STATE(9),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(9),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(9),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(9),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(279),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(283),
  },
  [11] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [12] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [13] = {
    [sym_export_statement] = STATE(23),
    [sym__declaration] = STATE(23),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(23),
    [sym_lexical_declaration] = STATE(23),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(23),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(23),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(23),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(289),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(291),
  },
  [14] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(293),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [15] = {
    [sym_export_statement] = STATE(19),
    [sym__declaration] = STATE(19),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(19),
    [sym_lexical_declaration] = STATE(19),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(19),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(19),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(19),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(129),
  },
  [16] = {
    [sym_export_statement] = STATE(11),
    [sym__declaration] = STATE(11),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(11),
    [sym_lexical_declaration] = STATE(11),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(11),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(11),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(11),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(299),
  },
  [17] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [18] = {
    [sym_export_statement] = STATE(17),
    [sym__declaration] = STATE(17),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(17),
    [sym_lexical_declaration] = STATE(17),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(17),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(17),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(17),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(305),
  },
  [19] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [20] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(113),
  },
  [21] = {
    [sym_export_statement] = STATE(14),
    [sym__declaration] = STATE(14),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(14),
    [sym_lexical_declaration] = STATE(14),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(14),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(14),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(14),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(117),
  },
  [22] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(289),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [23] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(311),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(267),
  },
  [24] = {
    [sym_export_statement] = STATE(1001),
    [sym__declaration] = STATE(1001),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(1001),
    [sym_expression_statement] = STATE(1001),
    [sym_variable_declaration] = STATE(1001),
    [sym_lexical_declaration] = STATE(1001),
    [sym_statement_block] = STATE(1001),
    [sym_if_statement] = STATE(1001),
    [sym_switch_statement] = STATE(1001),
    [sym_for_statement] = STATE(1001),
    [sym_for_in_statement] = STATE(1001),
    [sym_while_statement] = STATE(1001),
    [sym_do_statement] = STATE(1001),
    [sym_try_statement] = STATE(1001),
    [sym_with_statement] = STATE(1001),
    [sym_break_statement] = STATE(1001),
    [sym_continue_statement] = STATE(1001),
    [sym_debugger_statement] = STATE(1001),
    [sym_return_statement] = STATE(1001),
    [sym_throw_statement] = STATE(1001),
    [sym_empty_statement] = STATE(1001),
    [sym_labeled_statement] = STATE(1001),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(1001),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(1001),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(1001),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(335),
  },
  [25] = {
    [sym_export_statement] = STATE(213),
    [sym__declaration] = STATE(213),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(213),
    [sym_expression_statement] = STATE(213),
    [sym_variable_declaration] = STATE(213),
    [sym_lexical_declaration] = STATE(213),
    [sym_statement_block] = STATE(213),
    [sym_if_statement] = STATE(213),
    [sym_switch_statement] = STATE(213),
    [sym_for_statement] = STATE(213),
    [sym_for_in_statement] = STATE(213),
    [sym_while_statement] = STATE(213),
    [sym_do_statement] = STATE(213),
    [sym_try_statement] = STATE(213),
    [sym_with_statement] = STATE(213),
    [sym_break_statement] = STATE(213),
    [sym_continue_statement] = STATE(213),
    [sym_debugger_statement] = STATE(213),
    [sym_return_statement] = STATE(213),
    [sym_throw_statement] = STATE(213),
    [sym_empty_statement] = STATE(213),
    [sym_labeled_statement] = STATE(213),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(213),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(213),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(213),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(337),
  },
  [26] = {
    [sym_export_statement] = STATE(212),
    [sym__declaration] = STATE(212),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(212),
    [sym_expression_statement] = STATE(212),
    [sym_variable_declaration] = STATE(212),
    [sym_lexical_declaration] = STATE(212),
    [sym_statement_block] = STATE(212),
    [sym_if_statement] = STATE(212),
    [sym_switch_statement] = STATE(212),
    [sym_for_statement] = STATE(212),
    [sym_for_in_statement] = STATE(212),
    [sym_while_statement] = STATE(212),
    [sym_do_statement] = STATE(212),
    [sym_try_statement] = STATE(212),
    [sym_with_statement] = STATE(212),
    [sym_break_statement] = STATE(212),
    [sym_continue_statement] = STATE(212),
    [sym_debugger_statement] = STATE(212),
    [sym_return_statement] = STATE(212),
    [sym_throw_statement] = STATE(212),
    [sym_empty_statement] = STATE(212),
    [sym_labeled_statement] = STATE(212),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(212),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(212),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(212),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(339),
  },
  [27] = {
    [sym_export_statement] = STATE(238),
    [sym__declaration] = STATE(238),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(238),
    [sym_expression_statement] = STATE(238),
    [sym_variable_declaration] = STATE(238),
    [sym_lexical_declaration] = STATE(238),
    [sym_statement_block] = STATE(238),
    [sym_if_statement] = STATE(238),
    [sym_switch_statement] = STATE(238),
    [sym_for_statement] = STATE(238),
    [sym_for_in_statement] = STATE(238),
    [sym_while_statement] = STATE(238),
    [sym_do_statement] = STATE(238),
    [sym_try_statement] = STATE(238),
    [sym_with_statement] = STATE(238),
    [sym_break_statement] = STATE(238),
    [sym_continue_statement] = STATE(238),
    [sym_debugger_statement] = STATE(238),
    [sym_return_statement] = STATE(238),
    [sym_throw_statement] = STATE(238),
    [sym_empty_statement] = STATE(238),
    [sym_labeled_statement] = STATE(238),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(238),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(238),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(238),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(341),
  },
  [28] = {
    [sym_export_statement] = STATE(226),
    [sym__declaration] = STATE(226),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(226),
    [sym_lexical_declaration] = STATE(226),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(226),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(226),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(226),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(343),
  },
  [29] = {
    [sym_export_statement] = STATE(213),
    [sym__declaration] = STATE(213),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(213),
    [sym_expression_statement] = STATE(213),
    [sym_variable_declaration] = STATE(213),
    [sym_lexical_declaration] = STATE(213),
    [sym_statement_block] = STATE(213),
    [sym_if_statement] = STATE(213),
    [sym_switch_statement] = STATE(213),
    [sym_for_statement] = STATE(213),
    [sym_for_in_statement] = STATE(213),
    [sym_while_statement] = STATE(213),
    [sym_do_statement] = STATE(213),
    [sym_try_statement] = STATE(213),
    [sym_with_statement] = STATE(213),
    [sym_break_statement] = STATE(213),
    [sym_continue_statement] = STATE(213),
    [sym_debugger_statement] = STATE(213),
    [sym_return_statement] = STATE(213),
    [sym_throw_statement] = STATE(213),
    [sym_empty_statement] = STATE(213),
    [sym_labeled_statement] = STATE(213),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(213),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(213),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(213),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(337),
  },
  [30] = {
    [sym_export_statement] = STATE(1102),
    [sym__declaration] = STATE(1102),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(1102),
    [sym_expression_statement] = STATE(1102),
    [sym_variable_declaration] = STATE(1102),
    [sym_lexical_declaration] = STATE(1102),
    [sym_statement_block] = STATE(1102),
    [sym_if_statement] = STATE(1102),
    [sym_switch_statement] = STATE(1102),
    [sym_for_statement] = STATE(1102),
    [sym_for_in_statement] = STATE(1102),
    [sym_while_statement] = STATE(1102),
    [sym_do_statement] = STATE(1102),
    [sym_try_statement] = STATE(1102),
    [sym_with_statement] = STATE(1102),
    [sym_break_statement] = STATE(1102),
    [sym_continue_statement] = STATE(1102),
    [sym_debugger_statement] = STATE(1102),
    [sym_return_statement] = STATE(1102),
    [sym_throw_statement] = STATE(1102),
    [sym_empty_statement] = STATE(1102),
    [sym_labeled_statement] = STATE(1102),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(1102),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(1102),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(1102),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(345),
  },
  [31] = {
    [sym_export_statement] = STATE(231),
    [sym__declaration] = STATE(231),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(231),
    [sym_expression_statement] = STATE(231),
    [sym_variable_declaration] = STATE(231),
    [sym_lexical_declaration] = STATE(231),
    [sym_statement_block] = STATE(231),
    [sym_if_statement] = STATE(231),
    [sym_switch_statement] = STATE(231),
    [sym_for_statement] = STATE(231),
    [sym_for_in_statement] = STATE(231),
    [sym_while_statement] = STATE(231),
    [sym_do_statement] = STATE(231),
    [sym_try_statement] = STATE(231),
    [sym_with_statement] = STATE(231),
    [sym_break_statement] = STATE(231),
    [sym_continue_statement] = STATE(231),
    [sym_debugger_statement] = STATE(231),
    [sym_return_statement] = STATE(231),
    [sym_throw_statement] = STATE(231),
    [sym_empty_statement] = STATE(231),
    [sym_labeled_statement] = STATE(231),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(231),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(231),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(231),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(347),
  },
  [32] = {
    [sym_export_statement] = STATE(242),
    [sym__declaration] = STATE(242),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(242),
    [sym_expression_statement] = STATE(242),
    [sym_variable_declaration] = STATE(242),
    [sym_lexical_declaration] = STATE(242),
    [sym_statement_block] = STATE(242),
    [sym_if_statement] = STATE(242),
    [sym_switch_statement] = STATE(242),
    [sym_for_statement] = STATE(242),
    [sym_for_in_statement] = STATE(242),
    [sym_while_statement] = STATE(242),
    [sym_do_statement] = STATE(242),
    [sym_try_statement] = STATE(242),
    [sym_with_statement] = STATE(242),
    [sym_break_statement] = STATE(242),
    [sym_continue_statement] = STATE(242),
    [sym_debugger_statement] = STATE(242),
    [sym_return_statement] = STATE(242),
    [sym_throw_statement] = STATE(242),
    [sym_empty_statement] = STATE(242),
    [sym_labeled_statement] = STATE(242),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(242),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(242),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(242),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(349),
  },
  [33] = {
    [sym_export_statement] = STATE(212),
    [sym__declaration] = STATE(212),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(212),
    [sym_expression_statement] = STATE(212),
    [sym_variable_declaration] = STATE(212),
    [sym_lexical_declaration] = STATE(212),
    [sym_statement_block] = STATE(212),
    [sym_if_statement] = STATE(212),
    [sym_switch_statement] = STATE(212),
    [sym_for_statement] = STATE(212),
    [sym_for_in_statement] = STATE(212),
    [sym_while_statement] = STATE(212),
    [sym_do_statement] = STATE(212),
    [sym_try_statement] = STATE(212),
    [sym_with_statement] = STATE(212),
    [sym_break_statement] = STATE(212),
    [sym_continue_statement] = STATE(212),
    [sym_debugger_statement] = STATE(212),
    [sym_return_statement] = STATE(212),
    [sym_throw_statement] = STATE(212),
    [sym_empty_statement] = STATE(212),
    [sym_labeled_statement] = STATE(212),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(212),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(212),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(212),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(339),
  },
  [34] = {
    [sym_export_statement] = STATE(242),
    [sym__declaration] = STATE(242),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(242),
    [sym_expression_statement] = STATE(242),
    [sym_variable_declaration] = STATE(242),
    [sym_lexical_declaration] = STATE(242),
    [sym_statement_block] = STATE(242),
    [sym_if_statement] = STATE(242),
    [sym_switch_statement] = STATE(242),
    [sym_for_statement] = STATE(242),
    [sym_for_in_statement] = STATE(242),
    [sym_while_statement] = STATE(242),
    [sym_do_statement] = STATE(242),
    [sym_try_statement] = STATE(242),
    [sym_with_statement] = STATE(242),
    [sym_break_statement] = STATE(242),
    [sym_continue_statement] = STATE(242),
    [sym_debugger_statement] = STATE(242),
    [sym_return_statement] = STATE(242),
    [sym_throw_statement] = STATE(242),
    [sym_empty_statement] = STATE(242),
    [sym_labeled_statement] = STATE(242),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(242),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(242),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(242),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(349),
  },
  [35] = {
    [sym_export_statement] = STATE(231),
    [sym__declaration] = STATE(231),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(231),
    [sym_expression_statement] = STATE(231),
    [sym_variable_declaration] = STATE(231),
    [sym_lexical_declaration] = STATE(231),
    [sym_statement_block] = STATE(231),
    [sym_if_statement] = STATE(231),
    [sym_switch_statement] = STATE(231),
    [sym_for_statement] = STATE(231),
    [sym_for_in_statement] = STATE(231),
    [sym_while_statement] = STATE(231),
    [sym_do_statement] = STATE(231),
    [sym_try_statement] = STATE(231),
    [sym_with_statement] = STATE(231),
    [sym_break_statement] = STATE(231),
    [sym_continue_statement] = STATE(231),
    [sym_debugger_statement] = STATE(231),
    [sym_return_statement] = STATE(231),
    [sym_throw_statement] = STATE(231),
    [sym_empty_statement] = STATE(231),
    [sym_labeled_statement] = STATE(231),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(231),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(231),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(231),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(347),
  },
  [36] = {
    [sym_export_statement] = STATE(253),
    [sym__declaration] = STATE(253),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(253),
    [sym_expression_statement] = STATE(253),
    [sym_variable_declaration] = STATE(253),
    [sym_lexical_declaration] = STATE(253),
    [sym_statement_block] = STATE(253),
    [sym_if_statement] = STATE(253),
    [sym_switch_statement] = STATE(253),
    [sym_for_statement] = STATE(253),
    [sym_for_in_statement] = STATE(253),
    [sym_while_statement] = STATE(253),
    [sym_do_statement] = STATE(253),
    [sym_try_statement] = STATE(253),
    [sym_with_statement] = STATE(253),
    [sym_break_statement] = STATE(253),
    [sym_continue_statement] = STATE(253),
    [sym_debugger_statement] = STATE(253),
    [sym_return_statement] = STATE(253),
    [sym_throw_statement] = STATE(253),
    [sym_empty_statement] = STATE(253),
    [sym_labeled_statement] = STATE(253),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(253),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(253),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(253),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(351),
  },
  [37] = {
    [sym_export_statement] = STATE(246),
    [sym__declaration] = STATE(246),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(246),
    [sym_expression_statement] = STATE(246),
    [sym_variable_declaration] = STATE(246),
    [sym_lexical_declaration] = STATE(246),
    [sym_statement_block] = STATE(246),
    [sym_if_statement] = STATE(246),
    [sym_switch_statement] = STATE(246),
    [sym_for_statement] = STATE(246),
    [sym_for_in_statement] = STATE(246),
    [sym_while_statement] = STATE(246),
    [sym_do_statement] = STATE(246),
    [sym_try_statement] = STATE(246),
    [sym_with_statement] = STATE(246),
    [sym_break_statement] = STATE(246),
    [sym_continue_statement] = STATE(246),
    [sym_debugger_statement] = STATE(246),
    [sym_return_statement] = STATE(246),
    [sym_throw_statement] = STATE(246),
    [sym_empty_statement] = STATE(246),
    [sym_labeled_statement] = STATE(246),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(246),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(246),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(246),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(353),
  },
  [38] = {
    [sym_export_statement] = STATE(226),
    [sym__declaration] = STATE(226),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(226),
    [sym_lexical_declaration] = STATE(226),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(226),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(226),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(226),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(343),
  },
  [39] = {
    [sym_export_statement] = STATE(248),
    [sym__declaration] = STATE(248),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(248),
    [sym_expression_statement] = STATE(248),
    [sym_variable_declaration] = STATE(248),
    [sym_lexical_declaration] = STATE(248),
    [sym_statement_block] = STATE(248),
    [sym_if_statement] = STATE(248),
    [sym_switch_statement] = STATE(248),
    [sym_for_statement] = STATE(248),
    [sym_for_in_statement] = STATE(248),
    [sym_while_statement] = STATE(248),
    [sym_do_statement] = STATE(248),
    [sym_try_statement] = STATE(248),
    [sym_with_statement] = STATE(248),
    [sym_break_statement] = STATE(248),
    [sym_continue_statement] = STATE(248),
    [sym_debugger_statement] = STATE(248),
    [sym_return_statement] = STATE(248),
    [sym_throw_statement] = STATE(248),
    [sym_empty_statement] = STATE(248),
    [sym_labeled_statement] = STATE(248),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(248),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(248),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(248),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
    [sym_preproc] = ACTIONS(355),
  },
  [40] = {
    [sym_export_statement] = STATE(238),
    [sym__declaration] = STATE(238),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(238),
    [sym_expression_statement] = STATE(238),
    [sym_variable_declaration] = STATE(238),
    [sym_lexical_declaration] = STATE(238),
    [sym_statement_block] = STATE(238),
    [sym_if_statement] = STATE(238),
    [sym_switch_statement] = STATE(238),
    [sym_for_statement] = STATE(238),
    [sym_for_in_statement] = STATE(238),
    [sym_while_statement] = STATE(238),
    [sym_do_statement] = STATE(238),
    [sym_try_statement] = STATE(238),
    [sym_with_statement] = STATE(238),
    [sym_break_statement] = STATE(238),
    [sym_continue_statement] = STATE(238),
    [sym_debugger_statement] = STATE(238),
    [sym_return_statement] = STATE(238),
    [sym_throw_statement] = STATE(238),
    [sym_empty_statement] = STATE(238),
    [sym_labeled_statement] = STATE(238),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(238),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(238),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(238),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(341),
  },
  [41] = {
    [sym_export_statement] = STATE(246),
    [sym__declaration] = STATE(246),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(246),
    [sym_expression_statement] = STATE(246),
    [sym_variable_declaration] = STATE(246),
    [sym_lexical_declaration] = STATE(246),
    [sym_statement_block] = STATE(246),
    [sym_if_statement] = STATE(246),
    [sym_switch_statement] = STATE(246),
    [sym_for_statement] = STATE(246),
    [sym_for_in_statement] = STATE(246),
    [sym_while_statement] = STATE(246),
    [sym_do_statement] = STATE(246),
    [sym_try_statement] = STATE(246),
    [sym_with_statement] = STATE(246),
    [sym_break_statement] = STATE(246),
    [sym_continue_statement] = STATE(246),
    [sym_debugger_statement] = STATE(246),
    [sym_return_statement] = STATE(246),
    [sym_throw_statement] = STATE(246),
    [sym_empty_statement] = STATE(246),
    [sym_labeled_statement] = STATE(246),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(246),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(246),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(246),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(353),
  },
  [42] = {
    [sym_export_statement] = STATE(248),
    [sym__declaration] = STATE(248),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(248),
    [sym_expression_statement] = STATE(248),
    [sym_variable_declaration] = STATE(248),
    [sym_lexical_declaration] = STATE(248),
    [sym_statement_block] = STATE(248),
    [sym_if_statement] = STATE(248),
    [sym_switch_statement] = STATE(248),
    [sym_for_statement] = STATE(248),
    [sym_for_in_statement] = STATE(248),
    [sym_while_statement] = STATE(248),
    [sym_do_statement] = STATE(248),
    [sym_try_statement] = STATE(248),
    [sym_with_statement] = STATE(248),
    [sym_break_statement] = STATE(248),
    [sym_continue_statement] = STATE(248),
    [sym_debugger_statement] = STATE(248),
    [sym_return_statement] = STATE(248),
    [sym_throw_statement] = STATE(248),
    [sym_empty_statement] = STATE(248),
    [sym_labeled_statement] = STATE(248),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(248),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(248),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(248),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(327),
    [anon_sym_async] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_get] = ACTIONS(333),
    [anon_sym_set] = ACTIONS(333),
    [sym_preproc] = ACTIONS(355),
  },
  [43] = {
    [sym_import] = STATE(322),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(322),
    [sym_yield_expression] = STATE(322),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(322),
    [sym_jsx_fragment] = STATE(322),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(322),
    [sym_class] = STATE(322),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(322),
    [sym_arrow_function] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_new_expression] = STATE(322),
    [sym_await_expression] = STATE(322),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(322),
    [sym_augmented_assignment_expression] = STATE(322),
    [sym_ternary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_update_expression] = STATE(322),
    [sym_string] = STATE(322),
    [sym_template_string] = STATE(322),
    [sym_regex] = STATE(322),
    [sym_meta_property] = STATE(322),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(363),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(363),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_in] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_RBRACK] = ACTIONS(363),
    [anon_sym_LT] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_DOT] = ACTIONS(371),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(363),
    [anon_sym_PIPE_PIPE] = ACTIONS(363),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_GT_GT_GT] = ACTIONS(363),
    [anon_sym_LT_LT] = ACTIONS(363),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_CARET] = ACTIONS(363),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_PERCENT] = ACTIONS(363),
    [anon_sym_STAR_STAR] = ACTIONS(363),
    [anon_sym_LT_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(363),
    [anon_sym_GT_EQ] = ACTIONS(363),
    [anon_sym_QMARK_QMARK] = ACTIONS(363),
    [anon_sym_instanceof] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(405),
    [sym_this] = ACTIONS(407),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(407),
    [sym_false] = ACTIONS(407),
    [sym_null] = ACTIONS(407),
    [sym_undefined] = ACTIONS(407),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [44] = {
    [sym_import] = STATE(384),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(384),
    [sym_yield_expression] = STATE(384),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(384),
    [sym_jsx_fragment] = STATE(384),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(384),
    [sym_class] = STATE(384),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(384),
    [sym_arrow_function] = STATE(384),
    [sym_call_expression] = STATE(384),
    [sym_new_expression] = STATE(384),
    [sym_await_expression] = STATE(384),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(384),
    [sym_augmented_assignment_expression] = STATE(384),
    [sym_ternary_expression] = STATE(384),
    [sym_binary_expression] = STATE(384),
    [sym_unary_expression] = STATE(384),
    [sym_update_expression] = STATE(384),
    [sym_string] = STATE(384),
    [sym_template_string] = STATE(384),
    [sym_regex] = STATE(384),
    [sym_meta_property] = STATE(384),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_STAR] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(363),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(421),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(371),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(363),
    [anon_sym_PIPE_PIPE] = ACTIONS(363),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_GT_GT_GT] = ACTIONS(363),
    [anon_sym_LT_LT] = ACTIONS(363),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_CARET] = ACTIONS(363),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(363),
    [anon_sym_STAR_STAR] = ACTIONS(363),
    [anon_sym_LT_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(363),
    [anon_sym_GT_EQ] = ACTIONS(363),
    [anon_sym_QMARK_QMARK] = ACTIONS(363),
    [anon_sym_instanceof] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(431),
    [sym_this] = ACTIONS(433),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(433),
    [sym_false] = ACTIONS(433),
    [sym_null] = ACTIONS(433),
    [sym_undefined] = ACTIONS(433),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [sym__automatic_semicolon] = ACTIONS(363),
  },
  [45] = {
    [ts_builtin_sym_end] = ACTIONS(437),
    [sym_identifier] = ACTIONS(439),
    [anon_sym_export] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(437),
    [anon_sym_COMMA] = ACTIONS(443),
    [anon_sym_RBRACE] = ACTIONS(437),
    [anon_sym_import] = ACTIONS(439),
    [anon_sym_var] = ACTIONS(439),
    [anon_sym_let] = ACTIONS(439),
    [anon_sym_const] = ACTIONS(439),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_else] = ACTIONS(439),
    [anon_sym_switch] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_await] = ACTIONS(439),
    [anon_sym_in] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(439),
    [anon_sym_do] = ACTIONS(439),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_with] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(439),
    [anon_sym_continue] = ACTIONS(439),
    [anon_sym_debugger] = ACTIONS(439),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_SEMI] = ACTIONS(437),
    [anon_sym_case] = ACTIONS(439),
    [anon_sym_yield] = ACTIONS(439),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(439),
    [anon_sym_DOT] = ACTIONS(441),
    [anon_sym_class] = ACTIONS(439),
    [anon_sym_async] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(439),
    [anon_sym_QMARK] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_GT_GT_GT] = ACTIONS(443),
    [anon_sym_LT_LT] = ACTIONS(443),
    [anon_sym_AMP] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(439),
    [anon_sym_PERCENT] = ACTIONS(443),
    [anon_sym_STAR_STAR] = ACTIONS(443),
    [anon_sym_LT_EQ] = ACTIONS(443),
    [anon_sym_EQ_EQ] = ACTIONS(441),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(443),
    [anon_sym_BANG_EQ] = ACTIONS(441),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(443),
    [anon_sym_GT_EQ] = ACTIONS(443),
    [anon_sym_QMARK_QMARK] = ACTIONS(443),
    [anon_sym_instanceof] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(439),
    [anon_sym_void] = ACTIONS(439),
    [anon_sym_delete] = ACTIONS(439),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [sym_number] = ACTIONS(437),
    [sym_this] = ACTIONS(439),
    [sym_super] = ACTIONS(439),
    [sym_true] = ACTIONS(439),
    [sym_false] = ACTIONS(439),
    [sym_null] = ACTIONS(439),
    [sym_undefined] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_get] = ACTIONS(439),
    [anon_sym_set] = ACTIONS(439),
    [sym_preproc] = ACTIONS(437),
    [sym__automatic_semicolon] = ACTIONS(445),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(447),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_export] = ACTIONS(449),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_default] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(447),
    [anon_sym_import] = ACTIONS(449),
    [anon_sym_var] = ACTIONS(449),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(449),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_else] = ACTIONS(449),
    [anon_sym_switch] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_in] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_do] = ACTIONS(449),
    [anon_sym_try] = ACTIONS(449),
    [anon_sym_with] = ACTIONS(449),
    [anon_sym_break] = ACTIONS(449),
    [anon_sym_continue] = ACTIONS(449),
    [anon_sym_debugger] = ACTIONS(449),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_throw] = ACTIONS(449),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_case] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(449),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(449),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_SLASH] = ACTIONS(449),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_class] = ACTIONS(449),
    [anon_sym_async] = ACTIONS(449),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_new] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(451),
    [anon_sym_GT_GT_GT] = ACTIONS(453),
    [anon_sym_LT_LT] = ACTIONS(453),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(449),
    [anon_sym_DASH] = ACTIONS(449),
    [anon_sym_PERCENT] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(451),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(447),
    [anon_sym_typeof] = ACTIONS(449),
    [anon_sym_void] = ACTIONS(449),
    [anon_sym_delete] = ACTIONS(449),
    [anon_sym_PLUS_PLUS] = ACTIONS(447),
    [anon_sym_DASH_DASH] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(447),
    [sym_number] = ACTIONS(447),
    [sym_this] = ACTIONS(449),
    [sym_super] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_undefined] = ACTIONS(449),
    [anon_sym_AT] = ACTIONS(447),
    [anon_sym_static] = ACTIONS(449),
    [anon_sym_get] = ACTIONS(449),
    [anon_sym_set] = ACTIONS(449),
    [sym_preproc] = ACTIONS(447),
    [sym__automatic_semicolon] = ACTIONS(455),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(457),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_export] = ACTIONS(459),
    [anon_sym_STAR] = ACTIONS(461),
    [anon_sym_default] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(457),
    [anon_sym_COMMA] = ACTIONS(463),
    [anon_sym_RBRACE] = ACTIONS(457),
    [anon_sym_import] = ACTIONS(459),
    [anon_sym_var] = ACTIONS(459),
    [anon_sym_let] = ACTIONS(459),
    [anon_sym_const] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_else] = ACTIONS(459),
    [anon_sym_switch] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_LPAREN] = ACTIONS(457),
    [anon_sym_await] = ACTIONS(459),
    [anon_sym_in] = ACTIONS(461),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_do] = ACTIONS(459),
    [anon_sym_try] = ACTIONS(459),
    [anon_sym_with] = ACTIONS(459),
    [anon_sym_break] = ACTIONS(459),
    [anon_sym_continue] = ACTIONS(459),
    [anon_sym_debugger] = ACTIONS(459),
    [anon_sym_return] = ACTIONS(459),
    [anon_sym_throw] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(457),
    [anon_sym_case] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(459),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(459),
    [anon_sym_GT] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(459),
    [anon_sym_DOT] = ACTIONS(461),
    [anon_sym_class] = ACTIONS(459),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(463),
    [anon_sym_GT_GT] = ACTIONS(461),
    [anon_sym_GT_GT_GT] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(463),
    [anon_sym_PIPE] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(459),
    [anon_sym_DASH] = ACTIONS(459),
    [anon_sym_PERCENT] = ACTIONS(463),
    [anon_sym_STAR_STAR] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(463),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(463),
    [anon_sym_QMARK_QMARK] = ACTIONS(463),
    [anon_sym_instanceof] = ACTIONS(461),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_typeof] = ACTIONS(459),
    [anon_sym_void] = ACTIONS(459),
    [anon_sym_delete] = ACTIONS(459),
    [anon_sym_PLUS_PLUS] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(457),
    [sym_number] = ACTIONS(457),
    [sym_this] = ACTIONS(459),
    [sym_super] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_undefined] = ACTIONS(459),
    [anon_sym_AT] = ACTIONS(457),
    [anon_sym_static] = ACTIONS(459),
    [anon_sym_get] = ACTIONS(459),
    [anon_sym_set] = ACTIONS(459),
    [sym_preproc] = ACTIONS(457),
    [sym__automatic_semicolon] = ACTIONS(465),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(467),
    [sym_identifier] = ACTIONS(469),
    [anon_sym_export] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(471),
    [anon_sym_default] = ACTIONS(469),
    [anon_sym_LBRACE] = ACTIONS(467),
    [anon_sym_COMMA] = ACTIONS(473),
    [anon_sym_RBRACE] = ACTIONS(467),
    [anon_sym_import] = ACTIONS(469),
    [anon_sym_var] = ACTIONS(469),
    [anon_sym_let] = ACTIONS(469),
    [anon_sym_const] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_else] = ACTIONS(469),
    [anon_sym_switch] = ACTIONS(469),
    [anon_sym_for] = ACTIONS(469),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_await] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(471),
    [anon_sym_while] = ACTIONS(469),
    [anon_sym_do] = ACTIONS(469),
    [anon_sym_try] = ACTIONS(469),
    [anon_sym_with] = ACTIONS(469),
    [anon_sym_break] = ACTIONS(469),
    [anon_sym_continue] = ACTIONS(469),
    [anon_sym_debugger] = ACTIONS(469),
    [anon_sym_return] = ACTIONS(469),
    [anon_sym_throw] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(467),
    [anon_sym_case] = ACTIONS(469),
    [anon_sym_yield] = ACTIONS(469),
    [anon_sym_LBRACK] = ACTIONS(467),
    [anon_sym_LT] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(471),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_DOT] = ACTIONS(471),
    [anon_sym_class] = ACTIONS(469),
    [anon_sym_async] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_new] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_GT_GT] = ACTIONS(471),
    [anon_sym_GT_GT_GT] = ACTIONS(473),
    [anon_sym_LT_LT] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(471),
    [anon_sym_CARET] = ACTIONS(473),
    [anon_sym_PIPE] = ACTIONS(471),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_PERCENT] = ACTIONS(473),
    [anon_sym_STAR_STAR] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(473),
    [anon_sym_QMARK_QMARK] = ACTIONS(473),
    [anon_sym_instanceof] = ACTIONS(471),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(467),
    [anon_sym_typeof] = ACTIONS(469),
    [anon_sym_void] = ACTIONS(469),
    [anon_sym_delete] = ACTIONS(469),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(467),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(467),
    [sym_number] = ACTIONS(467),
    [sym_this] = ACTIONS(469),
    [sym_super] = ACTIONS(469),
    [sym_true] = ACTIONS(469),
    [sym_false] = ACTIONS(469),
    [sym_null] = ACTIONS(469),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(469),
    [anon_sym_get] = ACTIONS(469),
    [anon_sym_set] = ACTIONS(469),
    [sym_preproc] = ACTIONS(467),
    [sym__automatic_semicolon] = ACTIONS(475),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(477),
    [sym_identifier] = ACTIONS(479),
    [anon_sym_export] = ACTIONS(479),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_default] = ACTIONS(479),
    [anon_sym_LBRACE] = ACTIONS(477),
    [anon_sym_COMMA] = ACTIONS(483),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_import] = ACTIONS(479),
    [anon_sym_var] = ACTIONS(479),
    [anon_sym_let] = ACTIONS(479),
    [anon_sym_const] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(479),
    [anon_sym_else] = ACTIONS(479),
    [anon_sym_switch] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(479),
    [anon_sym_LPAREN] = ACTIONS(477),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_in] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(479),
    [anon_sym_do] = ACTIONS(479),
    [anon_sym_try] = ACTIONS(479),
    [anon_sym_with] = ACTIONS(479),
    [anon_sym_break] = ACTIONS(479),
    [anon_sym_continue] = ACTIONS(479),
    [anon_sym_debugger] = ACTIONS(479),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_throw] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_case] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(481),
    [anon_sym_SLASH] = ACTIONS(479),
    [anon_sym_DOT] = ACTIONS(481),
    [anon_sym_class] = ACTIONS(479),
    [anon_sym_async] = ACTIONS(479),
    [anon_sym_function] = ACTIONS(479),
    [anon_sym_new] = ACTIONS(479),
    [anon_sym_QMARK] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_GT_GT_GT] = ACTIONS(483),
    [anon_sym_LT_LT] = ACTIONS(483),
    [anon_sym_AMP] = ACTIONS(481),
    [anon_sym_CARET] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_PERCENT] = ACTIONS(483),
    [anon_sym_STAR_STAR] = ACTIONS(483),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(483),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(483),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_QMARK_QMARK] = ACTIONS(483),
    [anon_sym_instanceof] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(477),
    [anon_sym_typeof] = ACTIONS(479),
    [anon_sym_void] = ACTIONS(479),
    [anon_sym_delete] = ACTIONS(479),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [anon_sym_SQUOTE] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(477),
    [sym_number] = ACTIONS(477),
    [sym_this] = ACTIONS(479),
    [sym_super] = ACTIONS(479),
    [sym_true] = ACTIONS(479),
    [sym_false] = ACTIONS(479),
    [sym_null] = ACTIONS(479),
    [sym_undefined] = ACTIONS(479),
    [anon_sym_AT] = ACTIONS(477),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_get] = ACTIONS(479),
    [anon_sym_set] = ACTIONS(479),
    [sym_preproc] = ACTIONS(477),
    [sym__automatic_semicolon] = ACTIONS(485),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(487),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_export] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(489),
    [anon_sym_default] = ACTIONS(489),
    [anon_sym_LBRACE] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(487),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_import] = ACTIONS(489),
    [anon_sym_var] = ACTIONS(489),
    [anon_sym_let] = ACTIONS(489),
    [anon_sym_const] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_else] = ACTIONS(489),
    [anon_sym_switch] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_LPAREN] = ACTIONS(487),
    [anon_sym_await] = ACTIONS(489),
    [anon_sym_in] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(489),
    [anon_sym_try] = ACTIONS(489),
    [anon_sym_with] = ACTIONS(489),
    [anon_sym_break] = ACTIONS(489),
    [anon_sym_continue] = ACTIONS(489),
    [anon_sym_debugger] = ACTIONS(489),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_throw] = ACTIONS(489),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_case] = ACTIONS(489),
    [anon_sym_yield] = ACTIONS(489),
    [anon_sym_LBRACK] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(489),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_DOT] = ACTIONS(489),
    [anon_sym_class] = ACTIONS(489),
    [anon_sym_async] = ACTIONS(489),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_new] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(487),
    [anon_sym_PIPE_PIPE] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(489),
    [anon_sym_GT_GT_GT] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(487),
    [anon_sym_AMP] = ACTIONS(489),
    [anon_sym_CARET] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(489),
    [anon_sym_PERCENT] = ACTIONS(487),
    [anon_sym_STAR_STAR] = ACTIONS(487),
    [anon_sym_LT_EQ] = ACTIONS(487),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(487),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(487),
    [anon_sym_GT_EQ] = ACTIONS(487),
    [anon_sym_QMARK_QMARK] = ACTIONS(487),
    [anon_sym_instanceof] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(487),
    [anon_sym_typeof] = ACTIONS(489),
    [anon_sym_void] = ACTIONS(489),
    [anon_sym_delete] = ACTIONS(489),
    [anon_sym_PLUS_PLUS] = ACTIONS(487),
    [anon_sym_DASH_DASH] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(487),
    [sym_number] = ACTIONS(487),
    [sym_this] = ACTIONS(489),
    [sym_super] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_undefined] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(487),
    [anon_sym_static] = ACTIONS(489),
    [anon_sym_get] = ACTIONS(489),
    [anon_sym_set] = ACTIONS(489),
    [sym_preproc] = ACTIONS(487),
    [sym__automatic_semicolon] = ACTIONS(487),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_export] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_default] = ACTIONS(493),
    [anon_sym_LBRACE] = ACTIONS(491),
    [anon_sym_COMMA] = ACTIONS(497),
    [anon_sym_RBRACE] = ACTIONS(491),
    [anon_sym_import] = ACTIONS(493),
    [anon_sym_var] = ACTIONS(493),
    [anon_sym_let] = ACTIONS(493),
    [anon_sym_const] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_else] = ACTIONS(493),
    [anon_sym_switch] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_LPAREN] = ACTIONS(491),
    [anon_sym_await] = ACTIONS(493),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_do] = ACTIONS(493),
    [anon_sym_try] = ACTIONS(493),
    [anon_sym_with] = ACTIONS(493),
    [anon_sym_break] = ACTIONS(493),
    [anon_sym_continue] = ACTIONS(493),
    [anon_sym_debugger] = ACTIONS(493),
    [anon_sym_return] = ACTIONS(493),
    [anon_sym_throw] = ACTIONS(493),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym_case] = ACTIONS(493),
    [anon_sym_yield] = ACTIONS(493),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(493),
    [anon_sym_DOT] = ACTIONS(495),
    [anon_sym_class] = ACTIONS(493),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_new] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(497),
    [anon_sym_PIPE_PIPE] = ACTIONS(497),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(497),
    [anon_sym_LT_LT] = ACTIONS(497),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(497),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PERCENT] = ACTIONS(497),
    [anon_sym_STAR_STAR] = ACTIONS(497),
    [anon_sym_LT_EQ] = ACTIONS(497),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(497),
    [anon_sym_GT_EQ] = ACTIONS(497),
    [anon_sym_QMARK_QMARK] = ACTIONS(497),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(493),
    [anon_sym_void] = ACTIONS(493),
    [anon_sym_delete] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(491),
    [sym_number] = ACTIONS(491),
    [sym_this] = ACTIONS(493),
    [sym_super] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_undefined] = ACTIONS(493),
    [anon_sym_AT] = ACTIONS(491),
    [anon_sym_static] = ACTIONS(493),
    [anon_sym_get] = ACTIONS(493),
    [anon_sym_set] = ACTIONS(493),
    [sym_preproc] = ACTIONS(491),
    [sym__automatic_semicolon] = ACTIONS(499),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(501),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(503),
    [anon_sym_STAR] = ACTIONS(503),
    [anon_sym_default] = ACTIONS(503),
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(501),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_import] = ACTIONS(503),
    [anon_sym_var] = ACTIONS(503),
    [anon_sym_let] = ACTIONS(503),
    [anon_sym_const] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(503),
    [anon_sym_for] = ACTIONS(503),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_await] = ACTIONS(503),
    [anon_sym_in] = ACTIONS(503),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_do] = ACTIONS(503),
    [anon_sym_try] = ACTIONS(503),
    [anon_sym_with] = ACTIONS(503),
    [anon_sym_break] = ACTIONS(503),
    [anon_sym_continue] = ACTIONS(503),
    [anon_sym_debugger] = ACTIONS(503),
    [anon_sym_return] = ACTIONS(503),
    [anon_sym_throw] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(501),
    [anon_sym_case] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(503),
    [anon_sym_LBRACK] = ACTIONS(501),
    [anon_sym_LT] = ACTIONS(503),
    [anon_sym_GT] = ACTIONS(503),
    [anon_sym_SLASH] = ACTIONS(503),
    [anon_sym_DOT] = ACTIONS(503),
    [anon_sym_class] = ACTIONS(503),
    [anon_sym_async] = ACTIONS(503),
    [anon_sym_function] = ACTIONS(503),
    [anon_sym_new] = ACTIONS(503),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_AMP_AMP] = ACTIONS(501),
    [anon_sym_PIPE_PIPE] = ACTIONS(501),
    [anon_sym_GT_GT] = ACTIONS(503),
    [anon_sym_GT_GT_GT] = ACTIONS(501),
    [anon_sym_LT_LT] = ACTIONS(501),
    [anon_sym_AMP] = ACTIONS(503),
    [anon_sym_CARET] = ACTIONS(501),
    [anon_sym_PIPE] = ACTIONS(503),
    [anon_sym_PLUS] = ACTIONS(503),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_PERCENT] = ACTIONS(501),
    [anon_sym_STAR_STAR] = ACTIONS(501),
    [anon_sym_LT_EQ] = ACTIONS(501),
    [anon_sym_EQ_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(501),
    [anon_sym_BANG_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(501),
    [anon_sym_GT_EQ] = ACTIONS(501),
    [anon_sym_QMARK_QMARK] = ACTIONS(501),
    [anon_sym_instanceof] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(501),
    [anon_sym_typeof] = ACTIONS(503),
    [anon_sym_void] = ACTIONS(503),
    [anon_sym_delete] = ACTIONS(503),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(501),
    [anon_sym_SQUOTE] = ACTIONS(501),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(501),
    [sym_number] = ACTIONS(501),
    [sym_this] = ACTIONS(503),
    [sym_super] = ACTIONS(503),
    [sym_true] = ACTIONS(503),
    [sym_false] = ACTIONS(503),
    [sym_null] = ACTIONS(503),
    [sym_undefined] = ACTIONS(503),
    [anon_sym_AT] = ACTIONS(501),
    [anon_sym_static] = ACTIONS(503),
    [anon_sym_get] = ACTIONS(503),
    [anon_sym_set] = ACTIONS(503),
    [sym_preproc] = ACTIONS(501),
    [sym__automatic_semicolon] = ACTIONS(501),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(505),
    [sym_identifier] = ACTIONS(507),
    [anon_sym_export] = ACTIONS(507),
    [anon_sym_STAR] = ACTIONS(509),
    [anon_sym_default] = ACTIONS(507),
    [anon_sym_LBRACE] = ACTIONS(505),
    [anon_sym_COMMA] = ACTIONS(511),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_var] = ACTIONS(507),
    [anon_sym_let] = ACTIONS(507),
    [anon_sym_const] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(507),
    [anon_sym_else] = ACTIONS(507),
    [anon_sym_switch] = ACTIONS(507),
    [anon_sym_for] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(505),
    [anon_sym_await] = ACTIONS(507),
    [anon_sym_in] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(507),
    [anon_sym_do] = ACTIONS(507),
    [anon_sym_try] = ACTIONS(507),
    [anon_sym_with] = ACTIONS(507),
    [anon_sym_break] = ACTIONS(507),
    [anon_sym_continue] = ACTIONS(507),
    [anon_sym_debugger] = ACTIONS(507),
    [anon_sym_return] = ACTIONS(507),
    [anon_sym_throw] = ACTIONS(507),
    [anon_sym_SEMI] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_yield] = ACTIONS(507),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_LT] = ACTIONS(507),
    [anon_sym_GT] = ACTIONS(509),
    [anon_sym_SLASH] = ACTIONS(507),
    [anon_sym_DOT] = ACTIONS(509),
    [anon_sym_class] = ACTIONS(507),
    [anon_sym_async] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(507),
    [anon_sym_new] = ACTIONS(507),
    [anon_sym_QMARK] = ACTIONS(509),
    [anon_sym_AMP_AMP] = ACTIONS(511),
    [anon_sym_PIPE_PIPE] = ACTIONS(511),
    [anon_sym_GT_GT] = ACTIONS(509),
    [anon_sym_GT_GT_GT] = ACTIONS(511),
    [anon_sym_LT_LT] = ACTIONS(511),
    [anon_sym_AMP] = ACTIONS(509),
    [anon_sym_CARET] = ACTIONS(511),
    [anon_sym_PIPE] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(507),
    [anon_sym_DASH] = ACTIONS(507),
    [anon_sym_PERCENT] = ACTIONS(511),
    [anon_sym_STAR_STAR] = ACTIONS(511),
    [anon_sym_LT_EQ] = ACTIONS(511),
    [anon_sym_EQ_EQ] = ACTIONS(509),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(511),
    [anon_sym_BANG_EQ] = ACTIONS(509),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(511),
    [anon_sym_QMARK_QMARK] = ACTIONS(511),
    [anon_sym_instanceof] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(505),
    [anon_sym_typeof] = ACTIONS(507),
    [anon_sym_void] = ACTIONS(507),
    [anon_sym_delete] = ACTIONS(507),
    [anon_sym_PLUS_PLUS] = ACTIONS(505),
    [anon_sym_DASH_DASH] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(505),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(505),
    [sym_number] = ACTIONS(505),
    [sym_this] = ACTIONS(507),
    [sym_super] = ACTIONS(507),
    [sym_true] = ACTIONS(507),
    [sym_false] = ACTIONS(507),
    [sym_null] = ACTIONS(507),
    [sym_undefined] = ACTIONS(507),
    [anon_sym_AT] = ACTIONS(505),
    [anon_sym_static] = ACTIONS(507),
    [anon_sym_get] = ACTIONS(507),
    [anon_sym_set] = ACTIONS(507),
    [sym_preproc] = ACTIONS(505),
    [sym__automatic_semicolon] = ACTIONS(513),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(515),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_export] = ACTIONS(517),
    [anon_sym_STAR] = ACTIONS(519),
    [anon_sym_default] = ACTIONS(517),
    [anon_sym_LBRACE] = ACTIONS(515),
    [anon_sym_COMMA] = ACTIONS(521),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(517),
    [anon_sym_var] = ACTIONS(517),
    [anon_sym_let] = ACTIONS(517),
    [anon_sym_const] = ACTIONS(517),
    [anon_sym_if] = ACTIONS(517),
    [anon_sym_else] = ACTIONS(517),
    [anon_sym_switch] = ACTIONS(517),
    [anon_sym_for] = ACTIONS(517),
    [anon_sym_LPAREN] = ACTIONS(515),
    [anon_sym_await] = ACTIONS(517),
    [anon_sym_in] = ACTIONS(519),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(517),
    [anon_sym_try] = ACTIONS(517),
    [anon_sym_with] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(517),
    [anon_sym_continue] = ACTIONS(517),
    [anon_sym_debugger] = ACTIONS(517),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_throw] = ACTIONS(517),
    [anon_sym_SEMI] = ACTIONS(515),
    [anon_sym_case] = ACTIONS(517),
    [anon_sym_yield] = ACTIONS(517),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LT] = ACTIONS(517),
    [anon_sym_GT] = ACTIONS(519),
    [anon_sym_SLASH] = ACTIONS(517),
    [anon_sym_DOT] = ACTIONS(519),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(517),
    [anon_sym_new] = ACTIONS(517),
    [anon_sym_QMARK] = ACTIONS(519),
    [anon_sym_AMP_AMP] = ACTIONS(521),
    [anon_sym_PIPE_PIPE] = ACTIONS(521),
    [anon_sym_GT_GT] = ACTIONS(519),
    [anon_sym_GT_GT_GT] = ACTIONS(521),
    [anon_sym_LT_LT] = ACTIONS(521),
    [anon_sym_AMP] = ACTIONS(519),
    [anon_sym_CARET] = ACTIONS(521),
    [anon_sym_PIPE] = ACTIONS(519),
    [anon_sym_PLUS] = ACTIONS(517),
    [anon_sym_DASH] = ACTIONS(517),
    [anon_sym_PERCENT] = ACTIONS(521),
    [anon_sym_STAR_STAR] = ACTIONS(521),
    [anon_sym_LT_EQ] = ACTIONS(521),
    [anon_sym_EQ_EQ] = ACTIONS(519),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(521),
    [anon_sym_BANG_EQ] = ACTIONS(519),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(521),
    [anon_sym_GT_EQ] = ACTIONS(521),
    [anon_sym_QMARK_QMARK] = ACTIONS(521),
    [anon_sym_instanceof] = ACTIONS(519),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_TILDE] = ACTIONS(515),
    [anon_sym_typeof] = ACTIONS(517),
    [anon_sym_void] = ACTIONS(517),
    [anon_sym_delete] = ACTIONS(517),
    [anon_sym_PLUS_PLUS] = ACTIONS(515),
    [anon_sym_DASH_DASH] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [anon_sym_SQUOTE] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [sym_number] = ACTIONS(515),
    [sym_this] = ACTIONS(517),
    [sym_super] = ACTIONS(517),
    [sym_true] = ACTIONS(517),
    [sym_false] = ACTIONS(517),
    [sym_null] = ACTIONS(517),
    [sym_undefined] = ACTIONS(517),
    [anon_sym_AT] = ACTIONS(515),
    [anon_sym_static] = ACTIONS(517),
    [anon_sym_get] = ACTIONS(517),
    [anon_sym_set] = ACTIONS(517),
    [sym_preproc] = ACTIONS(515),
    [sym__automatic_semicolon] = ACTIONS(523),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(525),
    [sym_identifier] = ACTIONS(527),
    [anon_sym_export] = ACTIONS(527),
    [anon_sym_STAR] = ACTIONS(527),
    [anon_sym_default] = ACTIONS(527),
    [anon_sym_LBRACE] = ACTIONS(525),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_import] = ACTIONS(527),
    [anon_sym_var] = ACTIONS(527),
    [anon_sym_let] = ACTIONS(527),
    [anon_sym_const] = ACTIONS(527),
    [anon_sym_if] = ACTIONS(527),
    [anon_sym_else] = ACTIONS(527),
    [anon_sym_switch] = ACTIONS(527),
    [anon_sym_for] = ACTIONS(527),
    [anon_sym_LPAREN] = ACTIONS(525),
    [anon_sym_await] = ACTIONS(527),
    [anon_sym_in] = ACTIONS(527),
    [anon_sym_while] = ACTIONS(527),
    [anon_sym_do] = ACTIONS(527),
    [anon_sym_try] = ACTIONS(527),
    [anon_sym_with] = ACTIONS(527),
    [anon_sym_break] = ACTIONS(527),
    [anon_sym_continue] = ACTIONS(527),
    [anon_sym_debugger] = ACTIONS(527),
    [anon_sym_return] = ACTIONS(527),
    [anon_sym_throw] = ACTIONS(527),
    [anon_sym_SEMI] = ACTIONS(525),
    [anon_sym_case] = ACTIONS(527),
    [anon_sym_yield] = ACTIONS(527),
    [anon_sym_LBRACK] = ACTIONS(525),
    [anon_sym_LT] = ACTIONS(527),
    [anon_sym_GT] = ACTIONS(527),
    [anon_sym_SLASH] = ACTIONS(527),
    [anon_sym_DOT] = ACTIONS(527),
    [anon_sym_class] = ACTIONS(527),
    [anon_sym_async] = ACTIONS(527),
    [anon_sym_function] = ACTIONS(527),
    [anon_sym_new] = ACTIONS(527),
    [anon_sym_QMARK] = ACTIONS(527),
    [anon_sym_AMP_AMP] = ACTIONS(525),
    [anon_sym_PIPE_PIPE] = ACTIONS(525),
    [anon_sym_GT_GT] = ACTIONS(527),
    [anon_sym_GT_GT_GT] = ACTIONS(525),
    [anon_sym_LT_LT] = ACTIONS(525),
    [anon_sym_AMP] = ACTIONS(527),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(527),
    [anon_sym_PLUS] = ACTIONS(527),
    [anon_sym_DASH] = ACTIONS(527),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_STAR_STAR] = ACTIONS(525),
    [anon_sym_LT_EQ] = ACTIONS(525),
    [anon_sym_EQ_EQ] = ACTIONS(527),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(525),
    [anon_sym_BANG_EQ] = ACTIONS(527),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(525),
    [anon_sym_GT_EQ] = ACTIONS(525),
    [anon_sym_QMARK_QMARK] = ACTIONS(525),
    [anon_sym_instanceof] = ACTIONS(527),
    [anon_sym_BANG] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(525),
    [anon_sym_typeof] = ACTIONS(527),
    [anon_sym_void] = ACTIONS(527),
    [anon_sym_delete] = ACTIONS(527),
    [anon_sym_PLUS_PLUS] = ACTIONS(525),
    [anon_sym_DASH_DASH] = ACTIONS(525),
    [anon_sym_DQUOTE] = ACTIONS(525),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(525),
    [sym_number] = ACTIONS(525),
    [sym_this] = ACTIONS(527),
    [sym_super] = ACTIONS(527),
    [sym_true] = ACTIONS(527),
    [sym_false] = ACTIONS(527),
    [sym_null] = ACTIONS(527),
    [sym_undefined] = ACTIONS(527),
    [anon_sym_AT] = ACTIONS(525),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [sym_preproc] = ACTIONS(525),
    [sym__automatic_semicolon] = ACTIONS(525),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(529),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_default] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(529),
    [anon_sym_COMMA] = ACTIONS(535),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_import] = ACTIONS(531),
    [anon_sym_var] = ACTIONS(531),
    [anon_sym_let] = ACTIONS(531),
    [anon_sym_const] = ACTIONS(531),
    [anon_sym_if] = ACTIONS(531),
    [anon_sym_else] = ACTIONS(531),
    [anon_sym_switch] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(531),
    [anon_sym_LPAREN] = ACTIONS(529),
    [anon_sym_await] = ACTIONS(531),
    [anon_sym_in] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(531),
    [anon_sym_do] = ACTIONS(531),
    [anon_sym_try] = ACTIONS(531),
    [anon_sym_with] = ACTIONS(531),
    [anon_sym_break] = ACTIONS(531),
    [anon_sym_continue] = ACTIONS(531),
    [anon_sym_debugger] = ACTIONS(531),
    [anon_sym_return] = ACTIONS(531),
    [anon_sym_throw] = ACTIONS(531),
    [anon_sym_SEMI] = ACTIONS(529),
    [anon_sym_case] = ACTIONS(531),
    [anon_sym_yield] = ACTIONS(531),
    [anon_sym_LBRACK] = ACTIONS(529),
    [anon_sym_LT] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_DOT] = ACTIONS(533),
    [anon_sym_class] = ACTIONS(531),
    [anon_sym_async] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(531),
    [anon_sym_new] = ACTIONS(531),
    [anon_sym_QMARK] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [anon_sym_GT_GT] = ACTIONS(533),
    [anon_sym_GT_GT_GT] = ACTIONS(535),
    [anon_sym_LT_LT] = ACTIONS(535),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_CARET] = ACTIONS(535),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(531),
    [anon_sym_DASH] = ACTIONS(531),
    [anon_sym_PERCENT] = ACTIONS(535),
    [anon_sym_STAR_STAR] = ACTIONS(535),
    [anon_sym_LT_EQ] = ACTIONS(535),
    [anon_sym_EQ_EQ] = ACTIONS(533),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(535),
    [anon_sym_BANG_EQ] = ACTIONS(533),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(535),
    [anon_sym_GT_EQ] = ACTIONS(535),
    [anon_sym_QMARK_QMARK] = ACTIONS(535),
    [anon_sym_instanceof] = ACTIONS(533),
    [anon_sym_BANG] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(529),
    [anon_sym_typeof] = ACTIONS(531),
    [anon_sym_void] = ACTIONS(531),
    [anon_sym_delete] = ACTIONS(531),
    [anon_sym_PLUS_PLUS] = ACTIONS(529),
    [anon_sym_DASH_DASH] = ACTIONS(529),
    [anon_sym_DQUOTE] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(529),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(529),
    [sym_number] = ACTIONS(529),
    [sym_this] = ACTIONS(531),
    [sym_super] = ACTIONS(531),
    [sym_true] = ACTIONS(531),
    [sym_false] = ACTIONS(531),
    [sym_null] = ACTIONS(531),
    [sym_undefined] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(529),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [sym_preproc] = ACTIONS(529),
    [sym__automatic_semicolon] = ACTIONS(537),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(541),
    [anon_sym_default] = ACTIONS(541),
    [anon_sym_LBRACE] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_import] = ACTIONS(541),
    [anon_sym_var] = ACTIONS(541),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(541),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_else] = ACTIONS(541),
    [anon_sym_switch] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_LPAREN] = ACTIONS(539),
    [anon_sym_await] = ACTIONS(541),
    [anon_sym_in] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_do] = ACTIONS(541),
    [anon_sym_try] = ACTIONS(541),
    [anon_sym_with] = ACTIONS(541),
    [anon_sym_break] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(541),
    [anon_sym_debugger] = ACTIONS(541),
    [anon_sym_return] = ACTIONS(541),
    [anon_sym_throw] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_case] = ACTIONS(541),
    [anon_sym_yield] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_SLASH] = ACTIONS(541),
    [anon_sym_DOT] = ACTIONS(541),
    [anon_sym_class] = ACTIONS(541),
    [anon_sym_async] = ACTIONS(541),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_new] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(541),
    [anon_sym_AMP_AMP] = ACTIONS(539),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [anon_sym_GT_GT] = ACTIONS(541),
    [anon_sym_GT_GT_GT] = ACTIONS(539),
    [anon_sym_LT_LT] = ACTIONS(539),
    [anon_sym_AMP] = ACTIONS(541),
    [anon_sym_CARET] = ACTIONS(539),
    [anon_sym_PIPE] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(541),
    [anon_sym_DASH] = ACTIONS(541),
    [anon_sym_PERCENT] = ACTIONS(539),
    [anon_sym_STAR_STAR] = ACTIONS(539),
    [anon_sym_LT_EQ] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(539),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(539),
    [anon_sym_GT_EQ] = ACTIONS(539),
    [anon_sym_QMARK_QMARK] = ACTIONS(539),
    [anon_sym_instanceof] = ACTIONS(541),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_TILDE] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_void] = ACTIONS(541),
    [anon_sym_delete] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(539),
    [sym_number] = ACTIONS(539),
    [sym_this] = ACTIONS(541),
    [sym_super] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_undefined] = ACTIONS(541),
    [anon_sym_AT] = ACTIONS(539),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [sym_preproc] = ACTIONS(539),
    [sym__automatic_semicolon] = ACTIONS(539),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(541),
    [anon_sym_default] = ACTIONS(541),
    [anon_sym_LBRACE] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_import] = ACTIONS(541),
    [anon_sym_var] = ACTIONS(541),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(541),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_else] = ACTIONS(541),
    [anon_sym_switch] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_LPAREN] = ACTIONS(539),
    [anon_sym_await] = ACTIONS(541),
    [anon_sym_in] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_do] = ACTIONS(541),
    [anon_sym_try] = ACTIONS(541),
    [anon_sym_with] = ACTIONS(541),
    [anon_sym_break] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(541),
    [anon_sym_debugger] = ACTIONS(541),
    [anon_sym_return] = ACTIONS(541),
    [anon_sym_throw] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_case] = ACTIONS(541),
    [anon_sym_yield] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_SLASH] = ACTIONS(541),
    [anon_sym_DOT] = ACTIONS(541),
    [anon_sym_class] = ACTIONS(541),
    [anon_sym_async] = ACTIONS(541),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_new] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(541),
    [anon_sym_AMP_AMP] = ACTIONS(539),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [anon_sym_GT_GT] = ACTIONS(541),
    [anon_sym_GT_GT_GT] = ACTIONS(539),
    [anon_sym_LT_LT] = ACTIONS(539),
    [anon_sym_AMP] = ACTIONS(541),
    [anon_sym_CARET] = ACTIONS(539),
    [anon_sym_PIPE] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(541),
    [anon_sym_DASH] = ACTIONS(541),
    [anon_sym_PERCENT] = ACTIONS(539),
    [anon_sym_STAR_STAR] = ACTIONS(539),
    [anon_sym_LT_EQ] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(539),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(539),
    [anon_sym_GT_EQ] = ACTIONS(539),
    [anon_sym_QMARK_QMARK] = ACTIONS(539),
    [anon_sym_instanceof] = ACTIONS(541),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_TILDE] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_void] = ACTIONS(541),
    [anon_sym_delete] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(539),
    [sym_number] = ACTIONS(539),
    [sym_this] = ACTIONS(541),
    [sym_super] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_undefined] = ACTIONS(541),
    [anon_sym_AT] = ACTIONS(539),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [sym_preproc] = ACTIONS(539),
    [sym__automatic_semicolon] = ACTIONS(543),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(437),
    [sym_identifier] = ACTIONS(439),
    [anon_sym_export] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(439),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(437),
    [anon_sym_COMMA] = ACTIONS(437),
    [anon_sym_RBRACE] = ACTIONS(437),
    [anon_sym_import] = ACTIONS(439),
    [anon_sym_var] = ACTIONS(439),
    [anon_sym_let] = ACTIONS(439),
    [anon_sym_const] = ACTIONS(439),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_else] = ACTIONS(439),
    [anon_sym_switch] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_await] = ACTIONS(439),
    [anon_sym_in] = ACTIONS(439),
    [anon_sym_while] = ACTIONS(439),
    [anon_sym_do] = ACTIONS(439),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_with] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(439),
    [anon_sym_continue] = ACTIONS(439),
    [anon_sym_debugger] = ACTIONS(439),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_SEMI] = ACTIONS(437),
    [anon_sym_case] = ACTIONS(439),
    [anon_sym_yield] = ACTIONS(439),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(439),
    [anon_sym_SLASH] = ACTIONS(439),
    [anon_sym_DOT] = ACTIONS(439),
    [anon_sym_class] = ACTIONS(439),
    [anon_sym_async] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(439),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_AMP_AMP] = ACTIONS(437),
    [anon_sym_PIPE_PIPE] = ACTIONS(437),
    [anon_sym_GT_GT] = ACTIONS(439),
    [anon_sym_GT_GT_GT] = ACTIONS(437),
    [anon_sym_LT_LT] = ACTIONS(437),
    [anon_sym_AMP] = ACTIONS(439),
    [anon_sym_CARET] = ACTIONS(437),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(439),
    [anon_sym_PERCENT] = ACTIONS(437),
    [anon_sym_STAR_STAR] = ACTIONS(437),
    [anon_sym_LT_EQ] = ACTIONS(437),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(437),
    [anon_sym_BANG_EQ] = ACTIONS(439),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(437),
    [anon_sym_GT_EQ] = ACTIONS(437),
    [anon_sym_QMARK_QMARK] = ACTIONS(437),
    [anon_sym_instanceof] = ACTIONS(439),
    [anon_sym_BANG] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(439),
    [anon_sym_void] = ACTIONS(439),
    [anon_sym_delete] = ACTIONS(439),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [sym_number] = ACTIONS(437),
    [sym_this] = ACTIONS(439),
    [sym_super] = ACTIONS(439),
    [sym_true] = ACTIONS(439),
    [sym_false] = ACTIONS(439),
    [sym_null] = ACTIONS(439),
    [sym_undefined] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_get] = ACTIONS(439),
    [anon_sym_set] = ACTIONS(439),
    [sym_preproc] = ACTIONS(437),
    [sym__automatic_semicolon] = ACTIONS(545),
  },
  [60] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(72),
    [sym_variable_declaration] = STATE(72),
    [sym_lexical_declaration] = STATE(72),
    [sym_empty_statement] = STATE(72),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(490),
    [sym_array] = STATE(489),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_var] = ACTIONS(549),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(551),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(553),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
  },
  [61] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(73),
    [sym_variable_declaration] = STATE(73),
    [sym_lexical_declaration] = STATE(73),
    [sym_empty_statement] = STATE(73),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(490),
    [sym_array] = STATE(489),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_var] = ACTIONS(549),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(551),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(553),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
  },
  [62] = {
    [sym_import] = STATE(479),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(479),
    [sym_yield_expression] = STATE(479),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(479),
    [sym_jsx_fragment] = STATE(479),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(479),
    [sym_class] = STATE(479),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(479),
    [sym_arrow_function] = STATE(479),
    [sym_call_expression] = STATE(479),
    [sym_new_expression] = STATE(479),
    [sym_await_expression] = STATE(479),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(479),
    [sym_augmented_assignment_expression] = STATE(479),
    [sym_spread_element] = STATE(831),
    [sym_ternary_expression] = STATE(479),
    [sym_binary_expression] = STATE(479),
    [sym_unary_expression] = STATE(479),
    [sym_update_expression] = STATE(479),
    [sym_string] = STATE(479),
    [sym_template_string] = STATE(479),
    [sym_regex] = STATE(479),
    [sym_meta_property] = STATE(479),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(837),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_RBRACK] = ACTIONS(559),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(563),
    [sym_this] = ACTIONS(565),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(565),
    [sym_false] = ACTIONS(565),
    [sym_null] = ACTIONS(565),
    [sym_undefined] = ACTIONS(565),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [63] = {
    [sym_import] = STATE(457),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(457),
    [sym_yield_expression] = STATE(457),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(457),
    [sym_jsx_fragment] = STATE(457),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(457),
    [sym_class] = STATE(457),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(457),
    [sym_arrow_function] = STATE(457),
    [sym_call_expression] = STATE(457),
    [sym_new_expression] = STATE(457),
    [sym_await_expression] = STATE(457),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(457),
    [sym_augmented_assignment_expression] = STATE(457),
    [sym_spread_element] = STATE(810),
    [sym_ternary_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym_string] = STATE(457),
    [sym_template_string] = STATE(457),
    [sym_regex] = STATE(457),
    [sym_meta_property] = STATE(457),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(879),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_RBRACK] = ACTIONS(567),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(569),
    [sym_this] = ACTIONS(571),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(571),
    [sym_false] = ACTIONS(571),
    [sym_null] = ACTIONS(571),
    [sym_undefined] = ACTIONS(571),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [64] = {
    [sym_import] = STATE(465),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(465),
    [sym_yield_expression] = STATE(465),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(465),
    [sym_jsx_fragment] = STATE(465),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(465),
    [sym_class] = STATE(465),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(465),
    [sym_arrow_function] = STATE(465),
    [sym_call_expression] = STATE(465),
    [sym_new_expression] = STATE(465),
    [sym_await_expression] = STATE(465),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(465),
    [sym_augmented_assignment_expression] = STATE(465),
    [sym_spread_element] = STATE(859),
    [sym_ternary_expression] = STATE(465),
    [sym_binary_expression] = STATE(465),
    [sym_unary_expression] = STATE(465),
    [sym_update_expression] = STATE(465),
    [sym_string] = STATE(465),
    [sym_template_string] = STATE(465),
    [sym_regex] = STATE(465),
    [sym_meta_property] = STATE(465),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(573),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_RBRACK] = ACTIONS(573),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(575),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(577),
    [sym_false] = ACTIONS(577),
    [sym_null] = ACTIONS(577),
    [sym_undefined] = ACTIONS(577),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [65] = {
    [sym_import] = STATE(460),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(460),
    [sym_yield_expression] = STATE(460),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(460),
    [sym_jsx_fragment] = STATE(460),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(460),
    [sym_class] = STATE(460),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(460),
    [sym_arrow_function] = STATE(460),
    [sym_call_expression] = STATE(460),
    [sym_new_expression] = STATE(460),
    [sym_await_expression] = STATE(460),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(460),
    [sym_augmented_assignment_expression] = STATE(460),
    [sym_spread_element] = STATE(831),
    [sym_ternary_expression] = STATE(460),
    [sym_binary_expression] = STATE(460),
    [sym_unary_expression] = STATE(460),
    [sym_update_expression] = STATE(460),
    [sym_string] = STATE(460),
    [sym_template_string] = STATE(460),
    [sym_regex] = STATE(460),
    [sym_meta_property] = STATE(460),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(837),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_RBRACK] = ACTIONS(559),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(579),
    [sym_this] = ACTIONS(581),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(581),
    [sym_false] = ACTIONS(581),
    [sym_null] = ACTIONS(581),
    [sym_undefined] = ACTIONS(581),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [66] = {
    [sym_import] = STATE(469),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(469),
    [sym_yield_expression] = STATE(469),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(469),
    [sym_jsx_fragment] = STATE(469),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(469),
    [sym_class] = STATE(469),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(469),
    [sym_arrow_function] = STATE(469),
    [sym_call_expression] = STATE(469),
    [sym_new_expression] = STATE(469),
    [sym_await_expression] = STATE(469),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(469),
    [sym_augmented_assignment_expression] = STATE(469),
    [sym_spread_element] = STATE(810),
    [sym_ternary_expression] = STATE(469),
    [sym_binary_expression] = STATE(469),
    [sym_unary_expression] = STATE(469),
    [sym_update_expression] = STATE(469),
    [sym_string] = STATE(469),
    [sym_template_string] = STATE(469),
    [sym_regex] = STATE(469),
    [sym_meta_property] = STATE(469),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(879),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_RBRACK] = ACTIONS(567),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(583),
    [sym_this] = ACTIONS(585),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(585),
    [sym_false] = ACTIONS(585),
    [sym_null] = ACTIONS(585),
    [sym_undefined] = ACTIONS(585),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [67] = {
    [sym_import] = STATE(520),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(520),
    [sym_yield_expression] = STATE(520),
    [sym_object] = STATE(528),
    [sym_assignment_pattern] = STATE(829),
    [sym_array] = STATE(494),
    [sym_jsx_element] = STATE(520),
    [sym_jsx_fragment] = STATE(520),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(520),
    [sym_class] = STATE(520),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(520),
    [sym_arrow_function] = STATE(520),
    [sym_call_expression] = STATE(520),
    [sym_new_expression] = STATE(520),
    [sym_await_expression] = STATE(520),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(520),
    [sym_augmented_assignment_expression] = STATE(520),
    [sym_ternary_expression] = STATE(520),
    [sym_binary_expression] = STATE(520),
    [sym_unary_expression] = STATE(520),
    [sym_update_expression] = STATE(520),
    [sym_sequence_expression] = STATE(1059),
    [sym_string] = STATE(520),
    [sym_template_string] = STATE(520),
    [sym_regex] = STATE(520),
    [sym_meta_property] = STATE(520),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [sym_rest_parameter] = STATE(829),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(587),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(595),
    [sym_this] = ACTIONS(597),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(597),
    [sym_false] = ACTIONS(597),
    [sym_null] = ACTIONS(597),
    [sym_undefined] = ACTIONS(597),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(599),
    [anon_sym_get] = ACTIONS(599),
    [anon_sym_set] = ACTIONS(599),
  },
  [68] = {
    [sym_import] = STATE(477),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(477),
    [sym_yield_expression] = STATE(477),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(477),
    [sym_jsx_fragment] = STATE(477),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(477),
    [sym_class] = STATE(477),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(477),
    [sym_arrow_function] = STATE(477),
    [sym_call_expression] = STATE(477),
    [sym_new_expression] = STATE(477),
    [sym_await_expression] = STATE(477),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(477),
    [sym_augmented_assignment_expression] = STATE(477),
    [sym_spread_element] = STATE(863),
    [sym_ternary_expression] = STATE(477),
    [sym_binary_expression] = STATE(477),
    [sym_unary_expression] = STATE(477),
    [sym_update_expression] = STATE(477),
    [sym_string] = STATE(477),
    [sym_template_string] = STATE(477),
    [sym_regex] = STATE(477),
    [sym_meta_property] = STATE(477),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(862),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(601),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(603),
    [sym_this] = ACTIONS(605),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(605),
    [sym_false] = ACTIONS(605),
    [sym_null] = ACTIONS(605),
    [sym_undefined] = ACTIONS(605),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [69] = {
    [sym_import] = STATE(478),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(478),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(478),
    [sym_arrow_function] = STATE(478),
    [sym_call_expression] = STATE(478),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_spread_element] = STATE(860),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_string] = STATE(478),
    [sym_template_string] = STATE(478),
    [sym_regex] = STATE(478),
    [sym_meta_property] = STATE(478),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(861),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(609),
    [sym_this] = ACTIONS(611),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(611),
    [sym_false] = ACTIONS(611),
    [sym_null] = ACTIONS(611),
    [sym_undefined] = ACTIONS(611),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [70] = {
    [sym_import] = STATE(496),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(496),
    [sym_yield_expression] = STATE(496),
    [sym_object] = STATE(528),
    [sym_assignment_pattern] = STATE(829),
    [sym_array] = STATE(494),
    [sym_jsx_element] = STATE(496),
    [sym_jsx_fragment] = STATE(496),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(496),
    [sym_class] = STATE(496),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(496),
    [sym_arrow_function] = STATE(496),
    [sym_call_expression] = STATE(496),
    [sym_new_expression] = STATE(496),
    [sym_await_expression] = STATE(496),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(496),
    [sym_augmented_assignment_expression] = STATE(496),
    [sym_ternary_expression] = STATE(496),
    [sym_binary_expression] = STATE(496),
    [sym_unary_expression] = STATE(496),
    [sym_update_expression] = STATE(496),
    [sym_sequence_expression] = STATE(1100),
    [sym_string] = STATE(496),
    [sym_template_string] = STATE(496),
    [sym_regex] = STATE(496),
    [sym_meta_property] = STATE(496),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [sym_rest_parameter] = STATE(829),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(587),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(613),
    [sym_this] = ACTIONS(615),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(615),
    [sym_false] = ACTIONS(615),
    [sym_null] = ACTIONS(615),
    [sym_undefined] = ACTIONS(615),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(599),
    [anon_sym_get] = ACTIONS(599),
    [anon_sym_set] = ACTIONS(599),
  },
  [71] = {
    [sym_import] = STATE(542),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(542),
    [sym_yield_expression] = STATE(542),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(542),
    [sym_jsx_fragment] = STATE(542),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(542),
    [sym_class] = STATE(542),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(542),
    [sym_arrow_function] = STATE(542),
    [sym_call_expression] = STATE(542),
    [sym_new_expression] = STATE(542),
    [sym_await_expression] = STATE(542),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(542),
    [sym_augmented_assignment_expression] = STATE(542),
    [sym_spread_element] = STATE(1112),
    [sym_ternary_expression] = STATE(542),
    [sym_binary_expression] = STATE(542),
    [sym_unary_expression] = STATE(542),
    [sym_update_expression] = STATE(542),
    [sym_sequence_expression] = STATE(1112),
    [sym_string] = STATE(542),
    [sym_template_string] = STATE(542),
    [sym_regex] = STATE(542),
    [sym_meta_property] = STATE(542),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_RBRACE] = ACTIONS(617),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(619),
    [sym_this] = ACTIONS(621),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(621),
    [sym_false] = ACTIONS(621),
    [sym_null] = ACTIONS(621),
    [sym_undefined] = ACTIONS(621),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [72] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(77),
    [sym_empty_statement] = STATE(77),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [73] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(78),
    [sym_empty_statement] = STATE(78),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [74] = {
    [sym_import] = STATE(560),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(560),
    [sym_yield_expression] = STATE(560),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(560),
    [sym_jsx_fragment] = STATE(560),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(560),
    [sym_class] = STATE(560),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(560),
    [sym_arrow_function] = STATE(560),
    [sym_call_expression] = STATE(560),
    [sym_new_expression] = STATE(560),
    [sym_await_expression] = STATE(560),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(560),
    [sym_augmented_assignment_expression] = STATE(560),
    [sym_spread_element] = STATE(1081),
    [sym_ternary_expression] = STATE(560),
    [sym_binary_expression] = STATE(560),
    [sym_unary_expression] = STATE(560),
    [sym_update_expression] = STATE(560),
    [sym_sequence_expression] = STATE(1081),
    [sym_string] = STATE(560),
    [sym_template_string] = STATE(560),
    [sym_regex] = STATE(560),
    [sym_meta_property] = STATE(560),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_RBRACE] = ACTIONS(623),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(627),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(627),
    [sym_false] = ACTIONS(627),
    [sym_null] = ACTIONS(627),
    [sym_undefined] = ACTIONS(627),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [75] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(313),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(571),
    [sym_array] = STATE(575),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(629),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_var] = ACTIONS(631),
    [anon_sym_let] = ACTIONS(631),
    [anon_sym_const] = ACTIONS(631),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(635),
    [sym_this] = ACTIONS(637),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_undefined] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(639),
    [anon_sym_get] = ACTIONS(639),
    [anon_sym_set] = ACTIONS(639),
  },
  [76] = {
    [sym_import] = STATE(488),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(488),
    [sym_yield_expression] = STATE(488),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(488),
    [sym_jsx_fragment] = STATE(488),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(488),
    [sym_class] = STATE(488),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(488),
    [sym_arrow_function] = STATE(488),
    [sym_call_expression] = STATE(488),
    [sym_new_expression] = STATE(488),
    [sym_await_expression] = STATE(488),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(488),
    [sym_augmented_assignment_expression] = STATE(488),
    [sym_ternary_expression] = STATE(488),
    [sym_binary_expression] = STATE(488),
    [sym_unary_expression] = STATE(488),
    [sym_update_expression] = STATE(488),
    [sym_sequence_expression] = STATE(908),
    [sym_string] = STATE(488),
    [sym_template_string] = STATE(488),
    [sym_regex] = STATE(488),
    [sym_meta_property] = STATE(488),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(643),
    [sym_this] = ACTIONS(645),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(645),
    [sym_false] = ACTIONS(645),
    [sym_null] = ACTIONS(645),
    [sym_undefined] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [77] = {
    [sym_import] = STATE(504),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(504),
    [sym_yield_expression] = STATE(504),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(504),
    [sym_jsx_fragment] = STATE(504),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(504),
    [sym_class] = STATE(504),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(504),
    [sym_arrow_function] = STATE(504),
    [sym_call_expression] = STATE(504),
    [sym_new_expression] = STATE(504),
    [sym_await_expression] = STATE(504),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(504),
    [sym_augmented_assignment_expression] = STATE(504),
    [sym_ternary_expression] = STATE(504),
    [sym_binary_expression] = STATE(504),
    [sym_unary_expression] = STATE(504),
    [sym_update_expression] = STATE(504),
    [sym_sequence_expression] = STATE(1105),
    [sym_string] = STATE(504),
    [sym_template_string] = STATE(504),
    [sym_regex] = STATE(504),
    [sym_meta_property] = STATE(504),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(647),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(649),
    [sym_this] = ACTIONS(651),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(651),
    [sym_false] = ACTIONS(651),
    [sym_null] = ACTIONS(651),
    [sym_undefined] = ACTIONS(651),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [78] = {
    [sym_import] = STATE(503),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(503),
    [sym_yield_expression] = STATE(503),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(503),
    [sym_jsx_fragment] = STATE(503),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(503),
    [sym_class] = STATE(503),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(503),
    [sym_arrow_function] = STATE(503),
    [sym_call_expression] = STATE(503),
    [sym_new_expression] = STATE(503),
    [sym_await_expression] = STATE(503),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(503),
    [sym_augmented_assignment_expression] = STATE(503),
    [sym_ternary_expression] = STATE(503),
    [sym_binary_expression] = STATE(503),
    [sym_unary_expression] = STATE(503),
    [sym_update_expression] = STATE(503),
    [sym_sequence_expression] = STATE(1091),
    [sym_string] = STATE(503),
    [sym_template_string] = STATE(503),
    [sym_regex] = STATE(503),
    [sym_meta_property] = STATE(503),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(655),
    [sym_this] = ACTIONS(657),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(657),
    [sym_false] = ACTIONS(657),
    [sym_null] = ACTIONS(657),
    [sym_undefined] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [79] = {
    [sym_import] = STATE(472),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(472),
    [sym_yield_expression] = STATE(472),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(472),
    [sym_jsx_fragment] = STATE(472),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(472),
    [sym_class] = STATE(472),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(472),
    [sym_arrow_function] = STATE(472),
    [sym_call_expression] = STATE(472),
    [sym_new_expression] = STATE(472),
    [sym_await_expression] = STATE(472),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(472),
    [sym_augmented_assignment_expression] = STATE(472),
    [sym_ternary_expression] = STATE(472),
    [sym_binary_expression] = STATE(472),
    [sym_unary_expression] = STATE(472),
    [sym_update_expression] = STATE(472),
    [sym_sequence_expression] = STATE(940),
    [sym_string] = STATE(472),
    [sym_template_string] = STATE(472),
    [sym_regex] = STATE(472),
    [sym_meta_property] = STATE(472),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(659),
    [sym_this] = ACTIONS(661),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(661),
    [sym_false] = ACTIONS(661),
    [sym_null] = ACTIONS(661),
    [sym_undefined] = ACTIONS(661),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [80] = {
    [sym_import] = STATE(404),
    [sym_statement_block] = STATE(546),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(404),
    [sym_yield_expression] = STATE(404),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(404),
    [sym_jsx_fragment] = STATE(404),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(404),
    [sym_class] = STATE(404),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(404),
    [sym_arrow_function] = STATE(404),
    [sym_call_expression] = STATE(404),
    [sym_new_expression] = STATE(404),
    [sym_await_expression] = STATE(404),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(404),
    [sym_augmented_assignment_expression] = STATE(404),
    [sym_ternary_expression] = STATE(404),
    [sym_binary_expression] = STATE(404),
    [sym_unary_expression] = STATE(404),
    [sym_update_expression] = STATE(404),
    [sym_string] = STATE(404),
    [sym_template_string] = STATE(404),
    [sym_regex] = STATE(404),
    [sym_meta_property] = STATE(404),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(665),
    [sym_this] = ACTIONS(667),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(667),
    [sym_false] = ACTIONS(667),
    [sym_null] = ACTIONS(667),
    [sym_undefined] = ACTIONS(667),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [81] = {
    [sym_import] = STATE(524),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(524),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_fragment] = STATE(524),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(524),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(524),
    [sym_arrow_function] = STATE(524),
    [sym_call_expression] = STATE(524),
    [sym_new_expression] = STATE(524),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(524),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1122),
    [sym_string] = STATE(524),
    [sym_template_string] = STATE(524),
    [sym_regex] = STATE(524),
    [sym_meta_property] = STATE(524),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(669),
    [sym_this] = ACTIONS(671),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(671),
    [sym_false] = ACTIONS(671),
    [sym_null] = ACTIONS(671),
    [sym_undefined] = ACTIONS(671),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [82] = {
    [sym_import] = STATE(509),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(509),
    [sym_yield_expression] = STATE(509),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(509),
    [sym_jsx_fragment] = STATE(509),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(509),
    [sym_class] = STATE(509),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(509),
    [sym_arrow_function] = STATE(509),
    [sym_call_expression] = STATE(509),
    [sym_new_expression] = STATE(509),
    [sym_await_expression] = STATE(509),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(509),
    [sym_augmented_assignment_expression] = STATE(509),
    [sym_ternary_expression] = STATE(509),
    [sym_binary_expression] = STATE(509),
    [sym_unary_expression] = STATE(509),
    [sym_update_expression] = STATE(509),
    [sym_sequence_expression] = STATE(1103),
    [sym_string] = STATE(509),
    [sym_template_string] = STATE(509),
    [sym_regex] = STATE(509),
    [sym_meta_property] = STATE(509),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(673),
    [sym_this] = ACTIONS(675),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(675),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [83] = {
    [sym_import] = STATE(419),
    [sym_statement_block] = STATE(538),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(419),
    [sym_yield_expression] = STATE(419),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(419),
    [sym_jsx_fragment] = STATE(419),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(419),
    [sym_class] = STATE(419),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(419),
    [sym_arrow_function] = STATE(419),
    [sym_call_expression] = STATE(419),
    [sym_new_expression] = STATE(419),
    [sym_await_expression] = STATE(419),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(419),
    [sym_augmented_assignment_expression] = STATE(419),
    [sym_ternary_expression] = STATE(419),
    [sym_binary_expression] = STATE(419),
    [sym_unary_expression] = STATE(419),
    [sym_update_expression] = STATE(419),
    [sym_string] = STATE(419),
    [sym_template_string] = STATE(419),
    [sym_regex] = STATE(419),
    [sym_meta_property] = STATE(419),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(677),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(679),
    [sym_false] = ACTIONS(679),
    [sym_null] = ACTIONS(679),
    [sym_undefined] = ACTIONS(679),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [84] = {
    [sym_import] = STATE(502),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(502),
    [sym_yield_expression] = STATE(502),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(502),
    [sym_jsx_fragment] = STATE(502),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(502),
    [sym_class] = STATE(502),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(502),
    [sym_arrow_function] = STATE(502),
    [sym_call_expression] = STATE(502),
    [sym_new_expression] = STATE(502),
    [sym_await_expression] = STATE(502),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(502),
    [sym_augmented_assignment_expression] = STATE(502),
    [sym_ternary_expression] = STATE(502),
    [sym_binary_expression] = STATE(502),
    [sym_unary_expression] = STATE(502),
    [sym_update_expression] = STATE(502),
    [sym_sequence_expression] = STATE(1104),
    [sym_string] = STATE(502),
    [sym_template_string] = STATE(502),
    [sym_regex] = STATE(502),
    [sym_meta_property] = STATE(502),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(681),
    [sym_this] = ACTIONS(683),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(683),
    [sym_false] = ACTIONS(683),
    [sym_null] = ACTIONS(683),
    [sym_undefined] = ACTIONS(683),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [85] = {
    [sym_import] = STATE(341),
    [sym_statement_block] = STATE(454),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(341),
    [sym_yield_expression] = STATE(341),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(341),
    [sym_jsx_fragment] = STATE(341),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(341),
    [sym_class] = STATE(341),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(341),
    [sym_arrow_function] = STATE(341),
    [sym_call_expression] = STATE(341),
    [sym_new_expression] = STATE(341),
    [sym_await_expression] = STATE(341),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(341),
    [sym_augmented_assignment_expression] = STATE(341),
    [sym_ternary_expression] = STATE(341),
    [sym_binary_expression] = STATE(341),
    [sym_unary_expression] = STATE(341),
    [sym_update_expression] = STATE(341),
    [sym_string] = STATE(341),
    [sym_template_string] = STATE(341),
    [sym_regex] = STATE(341),
    [sym_meta_property] = STATE(341),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(687),
    [sym_this] = ACTIONS(689),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(689),
    [sym_false] = ACTIONS(689),
    [sym_null] = ACTIONS(689),
    [sym_undefined] = ACTIONS(689),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [86] = {
    [sym_import] = STATE(424),
    [sym_statement_block] = STATE(533),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(424),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(424),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(424),
    [sym_arrow_function] = STATE(424),
    [sym_call_expression] = STATE(424),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(424),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(424),
    [sym_template_string] = STATE(424),
    [sym_regex] = STATE(424),
    [sym_meta_property] = STATE(424),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(691),
    [sym_this] = ACTIONS(693),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(693),
    [sym_false] = ACTIONS(693),
    [sym_null] = ACTIONS(693),
    [sym_undefined] = ACTIONS(693),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [87] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(539),
    [sym_yield_expression] = STATE(539),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(539),
    [sym_jsx_fragment] = STATE(539),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(539),
    [sym_class] = STATE(539),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(539),
    [sym_await_expression] = STATE(539),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(539),
    [sym_augmented_assignment_expression] = STATE(539),
    [sym_ternary_expression] = STATE(539),
    [sym_binary_expression] = STATE(539),
    [sym_unary_expression] = STATE(539),
    [sym_update_expression] = STATE(539),
    [sym_sequence_expression] = STATE(1127),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(695),
    [sym_this] = ACTIONS(697),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(697),
    [sym_false] = ACTIONS(697),
    [sym_null] = ACTIONS(697),
    [sym_undefined] = ACTIONS(697),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [88] = {
    [sym_import] = STATE(557),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(557),
    [sym_yield_expression] = STATE(557),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(557),
    [sym_jsx_fragment] = STATE(557),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(557),
    [sym_class] = STATE(557),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(557),
    [sym_arrow_function] = STATE(557),
    [sym_call_expression] = STATE(557),
    [sym_new_expression] = STATE(557),
    [sym_await_expression] = STATE(557),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(557),
    [sym_augmented_assignment_expression] = STATE(557),
    [sym_ternary_expression] = STATE(557),
    [sym_binary_expression] = STATE(557),
    [sym_unary_expression] = STATE(557),
    [sym_update_expression] = STATE(557),
    [sym_sequence_expression] = STATE(1086),
    [sym_string] = STATE(557),
    [sym_template_string] = STATE(557),
    [sym_regex] = STATE(557),
    [sym_meta_property] = STATE(557),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(699),
    [sym_this] = ACTIONS(701),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(701),
    [sym_false] = ACTIONS(701),
    [sym_null] = ACTIONS(701),
    [sym_undefined] = ACTIONS(701),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [89] = {
    [sym_import] = STATE(361),
    [sym_parenthesized_expression] = STATE(283),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(331),
    [sym_array] = STATE(333),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(361),
    [sym_function] = STATE(335),
    [sym_generator_function] = STATE(361),
    [sym_arrow_function] = STATE(361),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(361),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(283),
    [sym_subscript_expression] = STATE(283),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(361),
    [sym_template_string] = STATE(361),
    [sym_regex] = STATE(361),
    [sym_meta_property] = STATE(361),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(703),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_DOT] = ACTIONS(705),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(707),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(709),
    [sym_this] = ACTIONS(711),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(711),
    [sym_false] = ACTIONS(711),
    [sym_null] = ACTIONS(711),
    [sym_undefined] = ACTIONS(711),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(713),
    [anon_sym_get] = ACTIONS(713),
    [anon_sym_set] = ACTIONS(713),
  },
  [90] = {
    [sym_import] = STATE(393),
    [sym_statement_block] = STATE(562),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(393),
    [sym_yield_expression] = STATE(393),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(393),
    [sym_jsx_fragment] = STATE(393),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(393),
    [sym_class] = STATE(393),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(393),
    [sym_arrow_function] = STATE(393),
    [sym_call_expression] = STATE(393),
    [sym_new_expression] = STATE(393),
    [sym_await_expression] = STATE(393),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(393),
    [sym_augmented_assignment_expression] = STATE(393),
    [sym_ternary_expression] = STATE(393),
    [sym_binary_expression] = STATE(393),
    [sym_unary_expression] = STATE(393),
    [sym_update_expression] = STATE(393),
    [sym_string] = STATE(393),
    [sym_template_string] = STATE(393),
    [sym_regex] = STATE(393),
    [sym_meta_property] = STATE(393),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(715),
    [sym_this] = ACTIONS(717),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(717),
    [sym_false] = ACTIONS(717),
    [sym_null] = ACTIONS(717),
    [sym_undefined] = ACTIONS(717),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [91] = {
    [sym_import] = STATE(349),
    [sym_statement_block] = STATE(380),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(349),
    [sym_yield_expression] = STATE(349),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(349),
    [sym_jsx_fragment] = STATE(349),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(349),
    [sym_class] = STATE(349),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(349),
    [sym_arrow_function] = STATE(349),
    [sym_call_expression] = STATE(349),
    [sym_new_expression] = STATE(349),
    [sym_await_expression] = STATE(349),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(349),
    [sym_augmented_assignment_expression] = STATE(349),
    [sym_ternary_expression] = STATE(349),
    [sym_binary_expression] = STATE(349),
    [sym_unary_expression] = STATE(349),
    [sym_update_expression] = STATE(349),
    [sym_string] = STATE(349),
    [sym_template_string] = STATE(349),
    [sym_regex] = STATE(349),
    [sym_meta_property] = STATE(349),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(719),
    [sym_this] = ACTIONS(721),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(721),
    [sym_false] = ACTIONS(721),
    [sym_null] = ACTIONS(721),
    [sym_undefined] = ACTIONS(721),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [92] = {
    [sym_import] = STATE(548),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(548),
    [sym_yield_expression] = STATE(548),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(548),
    [sym_jsx_fragment] = STATE(548),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(548),
    [sym_class] = STATE(548),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(548),
    [sym_arrow_function] = STATE(548),
    [sym_call_expression] = STATE(548),
    [sym_new_expression] = STATE(548),
    [sym_await_expression] = STATE(548),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(548),
    [sym_augmented_assignment_expression] = STATE(548),
    [sym_ternary_expression] = STATE(548),
    [sym_binary_expression] = STATE(548),
    [sym_unary_expression] = STATE(548),
    [sym_update_expression] = STATE(548),
    [sym_sequence_expression] = STATE(1078),
    [sym_string] = STATE(548),
    [sym_template_string] = STATE(548),
    [sym_regex] = STATE(548),
    [sym_meta_property] = STATE(548),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(723),
    [sym_this] = ACTIONS(725),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(725),
    [sym_false] = ACTIONS(725),
    [sym_null] = ACTIONS(725),
    [sym_undefined] = ACTIONS(725),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [93] = {
    [sym_import] = STATE(545),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(545),
    [sym_yield_expression] = STATE(545),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(545),
    [sym_jsx_fragment] = STATE(545),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(545),
    [sym_class] = STATE(545),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(545),
    [sym_arrow_function] = STATE(545),
    [sym_call_expression] = STATE(545),
    [sym_new_expression] = STATE(545),
    [sym_await_expression] = STATE(545),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(545),
    [sym_augmented_assignment_expression] = STATE(545),
    [sym_ternary_expression] = STATE(545),
    [sym_binary_expression] = STATE(545),
    [sym_unary_expression] = STATE(545),
    [sym_update_expression] = STATE(545),
    [sym_sequence_expression] = STATE(1111),
    [sym_string] = STATE(545),
    [sym_template_string] = STATE(545),
    [sym_regex] = STATE(545),
    [sym_meta_property] = STATE(545),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(729),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(729),
    [sym_false] = ACTIONS(729),
    [sym_null] = ACTIONS(729),
    [sym_undefined] = ACTIONS(729),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [94] = {
    [sym_import] = STATE(466),
    [sym_parenthesized_expression] = STATE(288),
    [sym__expression] = STATE(576),
    [sym_yield_expression] = STATE(576),
    [sym_object] = STATE(433),
    [sym_array] = STATE(428),
    [sym_jsx_element] = STATE(576),
    [sym_jsx_fragment] = STATE(576),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(576),
    [sym_class] = STATE(466),
    [sym_function] = STATE(365),
    [sym_generator_function] = STATE(466),
    [sym_arrow_function] = STATE(466),
    [sym_call_expression] = STATE(576),
    [sym_new_expression] = STATE(466),
    [sym_await_expression] = STATE(576),
    [sym_member_expression] = STATE(288),
    [sym_subscript_expression] = STATE(288),
    [sym_assignment_expression] = STATE(576),
    [sym_augmented_assignment_expression] = STATE(576),
    [sym_ternary_expression] = STATE(576),
    [sym_binary_expression] = STATE(576),
    [sym_unary_expression] = STATE(576),
    [sym_update_expression] = STATE(576),
    [sym_string] = STATE(466),
    [sym_template_string] = STATE(466),
    [sym_regex] = STATE(466),
    [sym_meta_property] = STATE(466),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(731),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(733),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(735),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(737),
    [sym_this] = ACTIONS(739),
    [sym_super] = ACTIONS(741),
    [sym_true] = ACTIONS(739),
    [sym_false] = ACTIONS(739),
    [sym_null] = ACTIONS(739),
    [sym_undefined] = ACTIONS(739),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(743),
    [anon_sym_get] = ACTIONS(743),
    [anon_sym_set] = ACTIONS(743),
  },
  [95] = {
    [sym_import] = STATE(559),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(559),
    [sym_yield_expression] = STATE(559),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(559),
    [sym_jsx_fragment] = STATE(559),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(559),
    [sym_class] = STATE(559),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(559),
    [sym_arrow_function] = STATE(559),
    [sym_call_expression] = STATE(559),
    [sym_new_expression] = STATE(559),
    [sym_await_expression] = STATE(559),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(559),
    [sym_augmented_assignment_expression] = STATE(559),
    [sym_ternary_expression] = STATE(559),
    [sym_binary_expression] = STATE(559),
    [sym_unary_expression] = STATE(559),
    [sym_update_expression] = STATE(559),
    [sym_sequence_expression] = STATE(1082),
    [sym_string] = STATE(559),
    [sym_template_string] = STATE(559),
    [sym_regex] = STATE(559),
    [sym_meta_property] = STATE(559),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(745),
    [sym_this] = ACTIONS(747),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(747),
    [sym_false] = ACTIONS(747),
    [sym_null] = ACTIONS(747),
    [sym_undefined] = ACTIONS(747),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [96] = {
    [sym_import] = STATE(527),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(527),
    [sym_yield_expression] = STATE(527),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(527),
    [sym_jsx_fragment] = STATE(527),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(527),
    [sym_class] = STATE(527),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(527),
    [sym_arrow_function] = STATE(527),
    [sym_call_expression] = STATE(527),
    [sym_new_expression] = STATE(527),
    [sym_await_expression] = STATE(527),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(527),
    [sym_augmented_assignment_expression] = STATE(527),
    [sym_ternary_expression] = STATE(527),
    [sym_binary_expression] = STATE(527),
    [sym_unary_expression] = STATE(527),
    [sym_update_expression] = STATE(527),
    [sym_sequence_expression] = STATE(1045),
    [sym_string] = STATE(527),
    [sym_template_string] = STATE(527),
    [sym_regex] = STATE(527),
    [sym_meta_property] = STATE(527),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(749),
    [sym_this] = ACTIONS(751),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(751),
    [sym_false] = ACTIONS(751),
    [sym_null] = ACTIONS(751),
    [sym_undefined] = ACTIONS(751),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [97] = {
    [sym_import] = STATE(359),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(359),
    [sym_yield_expression] = STATE(359),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(359),
    [sym_jsx_fragment] = STATE(359),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(359),
    [sym_class] = STATE(359),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(359),
    [sym_arrow_function] = STATE(359),
    [sym_call_expression] = STATE(359),
    [sym_new_expression] = STATE(359),
    [sym_await_expression] = STATE(359),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(359),
    [sym_augmented_assignment_expression] = STATE(359),
    [sym_ternary_expression] = STATE(359),
    [sym_binary_expression] = STATE(359),
    [sym_unary_expression] = STATE(359),
    [sym_update_expression] = STATE(359),
    [sym_sequence_expression] = STATE(808),
    [sym_string] = STATE(359),
    [sym_template_string] = STATE(359),
    [sym_regex] = STATE(359),
    [sym_meta_property] = STATE(359),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(753),
    [sym_this] = ACTIONS(755),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(755),
    [sym_false] = ACTIONS(755),
    [sym_null] = ACTIONS(755),
    [sym_undefined] = ACTIONS(755),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [98] = {
    [sym_import] = STATE(531),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(531),
    [sym_yield_expression] = STATE(531),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(531),
    [sym_jsx_fragment] = STATE(531),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(531),
    [sym_class] = STATE(531),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(531),
    [sym_await_expression] = STATE(531),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(531),
    [sym_augmented_assignment_expression] = STATE(531),
    [sym_ternary_expression] = STATE(531),
    [sym_binary_expression] = STATE(531),
    [sym_unary_expression] = STATE(531),
    [sym_update_expression] = STATE(531),
    [sym_sequence_expression] = STATE(1071),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(757),
    [sym_this] = ACTIONS(759),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(759),
    [sym_false] = ACTIONS(759),
    [sym_null] = ACTIONS(759),
    [sym_undefined] = ACTIONS(759),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [99] = {
    [sym_import] = STATE(317),
    [sym_statement_block] = STATE(379),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(317),
    [sym_yield_expression] = STATE(317),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(317),
    [sym_jsx_fragment] = STATE(317),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(317),
    [sym_class] = STATE(317),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(317),
    [sym_arrow_function] = STATE(317),
    [sym_call_expression] = STATE(317),
    [sym_new_expression] = STATE(317),
    [sym_await_expression] = STATE(317),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(317),
    [sym_augmented_assignment_expression] = STATE(317),
    [sym_ternary_expression] = STATE(317),
    [sym_binary_expression] = STATE(317),
    [sym_unary_expression] = STATE(317),
    [sym_update_expression] = STATE(317),
    [sym_string] = STATE(317),
    [sym_template_string] = STATE(317),
    [sym_regex] = STATE(317),
    [sym_meta_property] = STATE(317),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(761),
    [sym_this] = ACTIONS(763),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(763),
    [sym_false] = ACTIONS(763),
    [sym_null] = ACTIONS(763),
    [sym_undefined] = ACTIONS(763),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [100] = {
    [sym_import] = STATE(496),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(496),
    [sym_yield_expression] = STATE(496),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(496),
    [sym_jsx_fragment] = STATE(496),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(496),
    [sym_class] = STATE(496),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(496),
    [sym_arrow_function] = STATE(496),
    [sym_call_expression] = STATE(496),
    [sym_new_expression] = STATE(496),
    [sym_await_expression] = STATE(496),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(496),
    [sym_augmented_assignment_expression] = STATE(496),
    [sym_ternary_expression] = STATE(496),
    [sym_binary_expression] = STATE(496),
    [sym_unary_expression] = STATE(496),
    [sym_update_expression] = STATE(496),
    [sym_sequence_expression] = STATE(1100),
    [sym_string] = STATE(496),
    [sym_template_string] = STATE(496),
    [sym_regex] = STATE(496),
    [sym_meta_property] = STATE(496),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(613),
    [sym_this] = ACTIONS(615),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(615),
    [sym_false] = ACTIONS(615),
    [sym_null] = ACTIONS(615),
    [sym_undefined] = ACTIONS(615),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [101] = {
    [sym_import] = STATE(510),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(510),
    [sym_yield_expression] = STATE(510),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(510),
    [sym_jsx_fragment] = STATE(510),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(510),
    [sym_class] = STATE(510),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(510),
    [sym_arrow_function] = STATE(510),
    [sym_call_expression] = STATE(510),
    [sym_new_expression] = STATE(510),
    [sym_await_expression] = STATE(510),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(510),
    [sym_augmented_assignment_expression] = STATE(510),
    [sym_ternary_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_sequence_expression] = STATE(1107),
    [sym_string] = STATE(510),
    [sym_template_string] = STATE(510),
    [sym_regex] = STATE(510),
    [sym_meta_property] = STATE(510),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(765),
    [sym_this] = ACTIONS(767),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(767),
    [sym_false] = ACTIONS(767),
    [sym_null] = ACTIONS(767),
    [sym_undefined] = ACTIONS(767),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [102] = {
    [sym_import] = STATE(373),
    [sym_statement_block] = STATE(518),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(373),
    [sym_yield_expression] = STATE(373),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(373),
    [sym_jsx_fragment] = STATE(373),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(373),
    [sym_class] = STATE(373),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(373),
    [sym_arrow_function] = STATE(373),
    [sym_call_expression] = STATE(373),
    [sym_new_expression] = STATE(373),
    [sym_await_expression] = STATE(373),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(373),
    [sym_augmented_assignment_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_string] = STATE(373),
    [sym_template_string] = STATE(373),
    [sym_regex] = STATE(373),
    [sym_meta_property] = STATE(373),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(769),
    [sym_this] = ACTIONS(771),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(771),
    [sym_false] = ACTIONS(771),
    [sym_null] = ACTIONS(771),
    [sym_undefined] = ACTIONS(771),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [103] = {
    [sym_import] = STATE(491),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(491),
    [sym_yield_expression] = STATE(491),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(491),
    [sym_jsx_fragment] = STATE(491),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(491),
    [sym_class] = STATE(491),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(491),
    [sym_arrow_function] = STATE(491),
    [sym_call_expression] = STATE(491),
    [sym_new_expression] = STATE(491),
    [sym_await_expression] = STATE(491),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(491),
    [sym_augmented_assignment_expression] = STATE(491),
    [sym_ternary_expression] = STATE(491),
    [sym_binary_expression] = STATE(491),
    [sym_unary_expression] = STATE(491),
    [sym_update_expression] = STATE(491),
    [sym_sequence_expression] = STATE(941),
    [sym_string] = STATE(491),
    [sym_template_string] = STATE(491),
    [sym_regex] = STATE(491),
    [sym_meta_property] = STATE(491),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(773),
    [sym_this] = ACTIONS(775),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(775),
    [sym_false] = ACTIONS(775),
    [sym_null] = ACTIONS(775),
    [sym_undefined] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [104] = {
    [sym_import] = STATE(574),
    [sym_variable_declarator] = STATE(790),
    [sym_parenthesized_expression] = STATE(314),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(378),
    [sym_array] = STATE(376),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(314),
    [sym_subscript_expression] = STATE(314),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(777),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(779),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(635),
    [sym_this] = ACTIONS(637),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_undefined] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(781),
    [anon_sym_get] = ACTIONS(781),
    [anon_sym_set] = ACTIONS(781),
  },
  [105] = {
    [sym_import] = STATE(495),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(495),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(495),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(495),
    [sym_arrow_function] = STATE(495),
    [sym_call_expression] = STATE(495),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(495),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1114),
    [sym_string] = STATE(495),
    [sym_template_string] = STATE(495),
    [sym_regex] = STATE(495),
    [sym_meta_property] = STATE(495),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(783),
    [sym_this] = ACTIONS(785),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(785),
    [sym_false] = ACTIONS(785),
    [sym_null] = ACTIONS(785),
    [sym_undefined] = ACTIONS(785),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [106] = {
    [sym_import] = STATE(326),
    [sym_statement_block] = STATE(432),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(326),
    [sym_yield_expression] = STATE(326),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(326),
    [sym_jsx_fragment] = STATE(326),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(326),
    [sym_class] = STATE(326),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(326),
    [sym_arrow_function] = STATE(326),
    [sym_call_expression] = STATE(326),
    [sym_new_expression] = STATE(326),
    [sym_await_expression] = STATE(326),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(326),
    [sym_augmented_assignment_expression] = STATE(326),
    [sym_ternary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_update_expression] = STATE(326),
    [sym_string] = STATE(326),
    [sym_template_string] = STATE(326),
    [sym_regex] = STATE(326),
    [sym_meta_property] = STATE(326),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(787),
    [sym_this] = ACTIONS(789),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(789),
    [sym_false] = ACTIONS(789),
    [sym_null] = ACTIONS(789),
    [sym_undefined] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [107] = {
    [sym_import] = STATE(354),
    [sym_statement_block] = STATE(436),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(354),
    [sym_yield_expression] = STATE(354),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(354),
    [sym_jsx_fragment] = STATE(354),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(354),
    [sym_class] = STATE(354),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(354),
    [sym_arrow_function] = STATE(354),
    [sym_call_expression] = STATE(354),
    [sym_new_expression] = STATE(354),
    [sym_await_expression] = STATE(354),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(354),
    [sym_augmented_assignment_expression] = STATE(354),
    [sym_ternary_expression] = STATE(354),
    [sym_binary_expression] = STATE(354),
    [sym_unary_expression] = STATE(354),
    [sym_update_expression] = STATE(354),
    [sym_string] = STATE(354),
    [sym_template_string] = STATE(354),
    [sym_regex] = STATE(354),
    [sym_meta_property] = STATE(354),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(791),
    [sym_this] = ACTIONS(793),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(793),
    [sym_false] = ACTIONS(793),
    [sym_null] = ACTIONS(793),
    [sym_undefined] = ACTIONS(793),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [108] = {
    [sym_import] = STATE(355),
    [sym_statement_block] = STATE(439),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(355),
    [sym_yield_expression] = STATE(355),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(355),
    [sym_jsx_fragment] = STATE(355),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(355),
    [sym_class] = STATE(355),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(355),
    [sym_arrow_function] = STATE(355),
    [sym_call_expression] = STATE(355),
    [sym_new_expression] = STATE(355),
    [sym_await_expression] = STATE(355),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(355),
    [sym_augmented_assignment_expression] = STATE(355),
    [sym_ternary_expression] = STATE(355),
    [sym_binary_expression] = STATE(355),
    [sym_unary_expression] = STATE(355),
    [sym_update_expression] = STATE(355),
    [sym_string] = STATE(355),
    [sym_template_string] = STATE(355),
    [sym_regex] = STATE(355),
    [sym_meta_property] = STATE(355),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(795),
    [sym_this] = ACTIONS(797),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(797),
    [sym_false] = ACTIONS(797),
    [sym_null] = ACTIONS(797),
    [sym_undefined] = ACTIONS(797),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [109] = {
    [sym_import] = STATE(574),
    [sym_variable_declarator] = STATE(794),
    [sym_parenthesized_expression] = STATE(314),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(378),
    [sym_array] = STATE(376),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(314),
    [sym_subscript_expression] = STATE(314),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(777),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(779),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(635),
    [sym_this] = ACTIONS(637),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_undefined] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(781),
    [anon_sym_get] = ACTIONS(781),
    [anon_sym_set] = ACTIONS(781),
  },
  [110] = {
    [sym_import] = STATE(409),
    [sym_statement_block] = STATE(544),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(409),
    [sym_yield_expression] = STATE(409),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(409),
    [sym_jsx_fragment] = STATE(409),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(409),
    [sym_class] = STATE(409),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(409),
    [sym_arrow_function] = STATE(409),
    [sym_call_expression] = STATE(409),
    [sym_new_expression] = STATE(409),
    [sym_await_expression] = STATE(409),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(409),
    [sym_augmented_assignment_expression] = STATE(409),
    [sym_ternary_expression] = STATE(409),
    [sym_binary_expression] = STATE(409),
    [sym_unary_expression] = STATE(409),
    [sym_update_expression] = STATE(409),
    [sym_string] = STATE(409),
    [sym_template_string] = STATE(409),
    [sym_regex] = STATE(409),
    [sym_meta_property] = STATE(409),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(799),
    [sym_this] = ACTIONS(801),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(801),
    [sym_false] = ACTIONS(801),
    [sym_null] = ACTIONS(801),
    [sym_undefined] = ACTIONS(801),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [111] = {
    [sym_import] = STATE(512),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(512),
    [sym_yield_expression] = STATE(512),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(512),
    [sym_jsx_fragment] = STATE(512),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(512),
    [sym_class] = STATE(512),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(512),
    [sym_arrow_function] = STATE(512),
    [sym_call_expression] = STATE(512),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(512),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(512),
    [sym_augmented_assignment_expression] = STATE(512),
    [sym_ternary_expression] = STATE(512),
    [sym_binary_expression] = STATE(512),
    [sym_unary_expression] = STATE(512),
    [sym_update_expression] = STATE(512),
    [sym_sequence_expression] = STATE(1096),
    [sym_string] = STATE(512),
    [sym_template_string] = STATE(512),
    [sym_regex] = STATE(512),
    [sym_meta_property] = STATE(512),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(803),
    [sym_this] = ACTIONS(805),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(805),
    [sym_false] = ACTIONS(805),
    [sym_null] = ACTIONS(805),
    [sym_undefined] = ACTIONS(805),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [112] = {
    [sym_import] = STATE(470),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(470),
    [sym_yield_expression] = STATE(470),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(470),
    [sym_jsx_fragment] = STATE(470),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(470),
    [sym_class] = STATE(470),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(470),
    [sym_arrow_function] = STATE(470),
    [sym_call_expression] = STATE(470),
    [sym_new_expression] = STATE(470),
    [sym_await_expression] = STATE(470),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(470),
    [sym_augmented_assignment_expression] = STATE(470),
    [sym_ternary_expression] = STATE(470),
    [sym_binary_expression] = STATE(470),
    [sym_unary_expression] = STATE(470),
    [sym_update_expression] = STATE(470),
    [sym_string] = STATE(470),
    [sym_template_string] = STATE(470),
    [sym_regex] = STATE(470),
    [sym_meta_property] = STATE(470),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(807),
    [sym_this] = ACTIONS(809),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(809),
    [sym_false] = ACTIONS(809),
    [sym_null] = ACTIONS(809),
    [sym_undefined] = ACTIONS(809),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [113] = {
    [sym_import] = STATE(327),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(327),
    [sym_yield_expression] = STATE(327),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(327),
    [sym_jsx_fragment] = STATE(327),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(327),
    [sym_class] = STATE(327),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(327),
    [sym_arrow_function] = STATE(327),
    [sym_call_expression] = STATE(327),
    [sym_new_expression] = STATE(327),
    [sym_await_expression] = STATE(327),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(327),
    [sym_augmented_assignment_expression] = STATE(327),
    [sym_ternary_expression] = STATE(327),
    [sym_binary_expression] = STATE(327),
    [sym_unary_expression] = STATE(327),
    [sym_update_expression] = STATE(327),
    [sym_string] = STATE(327),
    [sym_template_string] = STATE(327),
    [sym_regex] = STATE(327),
    [sym_meta_property] = STATE(327),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(811),
    [sym_this] = ACTIONS(813),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(813),
    [sym_false] = ACTIONS(813),
    [sym_null] = ACTIONS(813),
    [sym_undefined] = ACTIONS(813),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [114] = {
    [sym_import] = STATE(570),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(570),
    [sym_yield_expression] = STATE(570),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(570),
    [sym_jsx_fragment] = STATE(570),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(570),
    [sym_class] = STATE(570),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(570),
    [sym_arrow_function] = STATE(570),
    [sym_call_expression] = STATE(570),
    [sym_new_expression] = STATE(570),
    [sym_await_expression] = STATE(570),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(570),
    [sym_augmented_assignment_expression] = STATE(570),
    [sym_ternary_expression] = STATE(570),
    [sym_binary_expression] = STATE(570),
    [sym_unary_expression] = STATE(570),
    [sym_update_expression] = STATE(570),
    [sym_string] = STATE(570),
    [sym_template_string] = STATE(570),
    [sym_regex] = STATE(570),
    [sym_meta_property] = STATE(570),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(815),
    [sym_this] = ACTIONS(817),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(817),
    [sym_false] = ACTIONS(817),
    [sym_null] = ACTIONS(817),
    [sym_undefined] = ACTIONS(817),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [115] = {
    [sym_import] = STATE(567),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(567),
    [sym_yield_expression] = STATE(567),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(567),
    [sym_jsx_fragment] = STATE(567),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(567),
    [sym_class] = STATE(567),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(567),
    [sym_arrow_function] = STATE(567),
    [sym_call_expression] = STATE(567),
    [sym_new_expression] = STATE(567),
    [sym_await_expression] = STATE(567),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(567),
    [sym_augmented_assignment_expression] = STATE(567),
    [sym_ternary_expression] = STATE(567),
    [sym_binary_expression] = STATE(567),
    [sym_unary_expression] = STATE(567),
    [sym_update_expression] = STATE(567),
    [sym_string] = STATE(567),
    [sym_template_string] = STATE(567),
    [sym_regex] = STATE(567),
    [sym_meta_property] = STATE(567),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(819),
    [sym_this] = ACTIONS(821),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(821),
    [sym_false] = ACTIONS(821),
    [sym_null] = ACTIONS(821),
    [sym_undefined] = ACTIONS(821),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [116] = {
    [sym_import] = STATE(561),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(561),
    [sym_yield_expression] = STATE(561),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(561),
    [sym_jsx_fragment] = STATE(561),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(561),
    [sym_class] = STATE(561),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(561),
    [sym_arrow_function] = STATE(561),
    [sym_call_expression] = STATE(561),
    [sym_new_expression] = STATE(561),
    [sym_await_expression] = STATE(561),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(561),
    [sym_augmented_assignment_expression] = STATE(561),
    [sym_ternary_expression] = STATE(561),
    [sym_binary_expression] = STATE(561),
    [sym_unary_expression] = STATE(561),
    [sym_update_expression] = STATE(561),
    [sym_string] = STATE(561),
    [sym_template_string] = STATE(561),
    [sym_regex] = STATE(561),
    [sym_meta_property] = STATE(561),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(823),
    [sym_this] = ACTIONS(825),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(825),
    [sym_false] = ACTIONS(825),
    [sym_null] = ACTIONS(825),
    [sym_undefined] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [117] = {
    [sym_import] = STATE(372),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(372),
    [sym_yield_expression] = STATE(372),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(372),
    [sym_jsx_fragment] = STATE(372),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(372),
    [sym_class] = STATE(372),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(372),
    [sym_arrow_function] = STATE(372),
    [sym_call_expression] = STATE(372),
    [sym_new_expression] = STATE(372),
    [sym_await_expression] = STATE(372),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(372),
    [sym_augmented_assignment_expression] = STATE(372),
    [sym_ternary_expression] = STATE(372),
    [sym_binary_expression] = STATE(372),
    [sym_unary_expression] = STATE(372),
    [sym_update_expression] = STATE(372),
    [sym_string] = STATE(372),
    [sym_template_string] = STATE(372),
    [sym_regex] = STATE(372),
    [sym_meta_property] = STATE(372),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(827),
    [sym_this] = ACTIONS(829),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(829),
    [sym_false] = ACTIONS(829),
    [sym_null] = ACTIONS(829),
    [sym_undefined] = ACTIONS(829),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [118] = {
    [sym_import] = STATE(485),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(485),
    [sym_yield_expression] = STATE(485),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(485),
    [sym_jsx_fragment] = STATE(485),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(485),
    [sym_class] = STATE(485),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(485),
    [sym_arrow_function] = STATE(485),
    [sym_call_expression] = STATE(485),
    [sym_new_expression] = STATE(485),
    [sym_await_expression] = STATE(485),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(485),
    [sym_augmented_assignment_expression] = STATE(485),
    [sym_ternary_expression] = STATE(485),
    [sym_binary_expression] = STATE(485),
    [sym_unary_expression] = STATE(485),
    [sym_update_expression] = STATE(485),
    [sym_string] = STATE(485),
    [sym_template_string] = STATE(485),
    [sym_regex] = STATE(485),
    [sym_meta_property] = STATE(485),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(831),
    [sym_this] = ACTIONS(833),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(833),
    [sym_false] = ACTIONS(833),
    [sym_null] = ACTIONS(833),
    [sym_undefined] = ACTIONS(833),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [119] = {
    [sym_import] = STATE(486),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(486),
    [sym_yield_expression] = STATE(486),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(486),
    [sym_jsx_fragment] = STATE(486),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(486),
    [sym_class] = STATE(486),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(486),
    [sym_arrow_function] = STATE(486),
    [sym_call_expression] = STATE(486),
    [sym_new_expression] = STATE(486),
    [sym_await_expression] = STATE(486),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(486),
    [sym_augmented_assignment_expression] = STATE(486),
    [sym_ternary_expression] = STATE(486),
    [sym_binary_expression] = STATE(486),
    [sym_unary_expression] = STATE(486),
    [sym_update_expression] = STATE(486),
    [sym_string] = STATE(486),
    [sym_template_string] = STATE(486),
    [sym_regex] = STATE(486),
    [sym_meta_property] = STATE(486),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(835),
    [sym_this] = ACTIONS(837),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(837),
    [sym_false] = ACTIONS(837),
    [sym_null] = ACTIONS(837),
    [sym_undefined] = ACTIONS(837),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [120] = {
    [sym_import] = STATE(487),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(487),
    [sym_yield_expression] = STATE(487),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(487),
    [sym_jsx_fragment] = STATE(487),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(487),
    [sym_class] = STATE(487),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(487),
    [sym_arrow_function] = STATE(487),
    [sym_call_expression] = STATE(487),
    [sym_new_expression] = STATE(487),
    [sym_await_expression] = STATE(487),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(487),
    [sym_augmented_assignment_expression] = STATE(487),
    [sym_ternary_expression] = STATE(487),
    [sym_binary_expression] = STATE(487),
    [sym_unary_expression] = STATE(487),
    [sym_update_expression] = STATE(487),
    [sym_string] = STATE(487),
    [sym_template_string] = STATE(487),
    [sym_regex] = STATE(487),
    [sym_meta_property] = STATE(487),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(839),
    [sym_this] = ACTIONS(841),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(841),
    [sym_false] = ACTIONS(841),
    [sym_null] = ACTIONS(841),
    [sym_undefined] = ACTIONS(841),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [121] = {
    [sym_import] = STATE(425),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(425),
    [sym_yield_expression] = STATE(425),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(425),
    [sym_jsx_fragment] = STATE(425),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(425),
    [sym_class] = STATE(425),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(425),
    [sym_arrow_function] = STATE(425),
    [sym_call_expression] = STATE(425),
    [sym_new_expression] = STATE(425),
    [sym_await_expression] = STATE(425),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(425),
    [sym_augmented_assignment_expression] = STATE(425),
    [sym_ternary_expression] = STATE(425),
    [sym_binary_expression] = STATE(425),
    [sym_unary_expression] = STATE(425),
    [sym_update_expression] = STATE(425),
    [sym_string] = STATE(425),
    [sym_template_string] = STATE(425),
    [sym_regex] = STATE(425),
    [sym_meta_property] = STATE(425),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(843),
    [sym_this] = ACTIONS(845),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(845),
    [sym_false] = ACTIONS(845),
    [sym_null] = ACTIONS(845),
    [sym_undefined] = ACTIONS(845),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [122] = {
    [sym_import] = STATE(423),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(423),
    [sym_yield_expression] = STATE(423),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(423),
    [sym_jsx_fragment] = STATE(423),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(423),
    [sym_class] = STATE(423),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(423),
    [sym_arrow_function] = STATE(423),
    [sym_call_expression] = STATE(423),
    [sym_new_expression] = STATE(423),
    [sym_await_expression] = STATE(423),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(423),
    [sym_augmented_assignment_expression] = STATE(423),
    [sym_ternary_expression] = STATE(423),
    [sym_binary_expression] = STATE(423),
    [sym_unary_expression] = STATE(423),
    [sym_update_expression] = STATE(423),
    [sym_string] = STATE(423),
    [sym_template_string] = STATE(423),
    [sym_regex] = STATE(423),
    [sym_meta_property] = STATE(423),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(847),
    [sym_this] = ACTIONS(849),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(849),
    [sym_false] = ACTIONS(849),
    [sym_null] = ACTIONS(849),
    [sym_undefined] = ACTIONS(849),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [123] = {
    [sym_import] = STATE(422),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(422),
    [sym_yield_expression] = STATE(422),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(422),
    [sym_jsx_fragment] = STATE(422),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(422),
    [sym_class] = STATE(422),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(422),
    [sym_arrow_function] = STATE(422),
    [sym_call_expression] = STATE(422),
    [sym_new_expression] = STATE(422),
    [sym_await_expression] = STATE(422),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(422),
    [sym_augmented_assignment_expression] = STATE(422),
    [sym_ternary_expression] = STATE(422),
    [sym_binary_expression] = STATE(422),
    [sym_unary_expression] = STATE(422),
    [sym_update_expression] = STATE(422),
    [sym_string] = STATE(422),
    [sym_template_string] = STATE(422),
    [sym_regex] = STATE(422),
    [sym_meta_property] = STATE(422),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(851),
    [sym_this] = ACTIONS(853),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(853),
    [sym_false] = ACTIONS(853),
    [sym_null] = ACTIONS(853),
    [sym_undefined] = ACTIONS(853),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [124] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(314),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(572),
    [sym_array] = STATE(573),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(314),
    [sym_subscript_expression] = STATE(314),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(855),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(779),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(635),
    [sym_this] = ACTIONS(637),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_undefined] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(781),
    [anon_sym_get] = ACTIONS(781),
    [anon_sym_set] = ACTIONS(781),
  },
  [125] = {
    [sym_import] = STATE(421),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(421),
    [sym_yield_expression] = STATE(421),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(421),
    [sym_jsx_fragment] = STATE(421),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(421),
    [sym_class] = STATE(421),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(421),
    [sym_arrow_function] = STATE(421),
    [sym_call_expression] = STATE(421),
    [sym_new_expression] = STATE(421),
    [sym_await_expression] = STATE(421),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(421),
    [sym_augmented_assignment_expression] = STATE(421),
    [sym_ternary_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_string] = STATE(421),
    [sym_template_string] = STATE(421),
    [sym_regex] = STATE(421),
    [sym_meta_property] = STATE(421),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(857),
    [sym_this] = ACTIONS(859),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(859),
    [sym_false] = ACTIONS(859),
    [sym_null] = ACTIONS(859),
    [sym_undefined] = ACTIONS(859),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [126] = {
    [sym_import] = STATE(388),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(388),
    [sym_yield_expression] = STATE(388),
    [sym_object] = STATE(566),
    [sym_array] = STATE(568),
    [sym_jsx_element] = STATE(388),
    [sym_jsx_fragment] = STATE(388),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(388),
    [sym_class] = STATE(388),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(388),
    [sym_arrow_function] = STATE(388),
    [sym_call_expression] = STATE(388),
    [sym_new_expression] = STATE(388),
    [sym_await_expression] = STATE(388),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(388),
    [sym_augmented_assignment_expression] = STATE(388),
    [sym_ternary_expression] = STATE(388),
    [sym_binary_expression] = STATE(388),
    [sym_unary_expression] = STATE(388),
    [sym_update_expression] = STATE(388),
    [sym_string] = STATE(388),
    [sym_template_string] = STATE(388),
    [sym_regex] = STATE(388),
    [sym_meta_property] = STATE(388),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(861),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(863),
    [sym_this] = ACTIONS(865),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(865),
    [sym_false] = ACTIONS(865),
    [sym_null] = ACTIONS(865),
    [sym_undefined] = ACTIONS(865),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [127] = {
    [sym_import] = STATE(371),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(371),
    [sym_yield_expression] = STATE(371),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(371),
    [sym_jsx_fragment] = STATE(371),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(371),
    [sym_class] = STATE(371),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(371),
    [sym_arrow_function] = STATE(371),
    [sym_call_expression] = STATE(371),
    [sym_new_expression] = STATE(371),
    [sym_await_expression] = STATE(371),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(371),
    [sym_augmented_assignment_expression] = STATE(371),
    [sym_ternary_expression] = STATE(371),
    [sym_binary_expression] = STATE(371),
    [sym_unary_expression] = STATE(371),
    [sym_update_expression] = STATE(371),
    [sym_string] = STATE(371),
    [sym_template_string] = STATE(371),
    [sym_regex] = STATE(371),
    [sym_meta_property] = STATE(371),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(867),
    [sym_this] = ACTIONS(869),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(869),
    [sym_false] = ACTIONS(869),
    [sym_null] = ACTIONS(869),
    [sym_undefined] = ACTIONS(869),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [128] = {
    [sym_import] = STATE(556),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(556),
    [sym_yield_expression] = STATE(556),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(556),
    [sym_jsx_fragment] = STATE(556),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(556),
    [sym_class] = STATE(556),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(556),
    [sym_arrow_function] = STATE(556),
    [sym_call_expression] = STATE(556),
    [sym_new_expression] = STATE(556),
    [sym_await_expression] = STATE(556),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(556),
    [sym_augmented_assignment_expression] = STATE(556),
    [sym_ternary_expression] = STATE(556),
    [sym_binary_expression] = STATE(556),
    [sym_unary_expression] = STATE(556),
    [sym_update_expression] = STATE(556),
    [sym_string] = STATE(556),
    [sym_template_string] = STATE(556),
    [sym_regex] = STATE(556),
    [sym_meta_property] = STATE(556),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(871),
    [sym_this] = ACTIONS(873),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(873),
    [sym_false] = ACTIONS(873),
    [sym_null] = ACTIONS(873),
    [sym_undefined] = ACTIONS(873),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [129] = {
    [sym_import] = STATE(484),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(484),
    [sym_yield_expression] = STATE(484),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(484),
    [sym_jsx_fragment] = STATE(484),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(484),
    [sym_class] = STATE(484),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(484),
    [sym_arrow_function] = STATE(484),
    [sym_call_expression] = STATE(484),
    [sym_new_expression] = STATE(484),
    [sym_await_expression] = STATE(484),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(484),
    [sym_augmented_assignment_expression] = STATE(484),
    [sym_ternary_expression] = STATE(484),
    [sym_binary_expression] = STATE(484),
    [sym_unary_expression] = STATE(484),
    [sym_update_expression] = STATE(484),
    [sym_string] = STATE(484),
    [sym_template_string] = STATE(484),
    [sym_regex] = STATE(484),
    [sym_meta_property] = STATE(484),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(875),
    [sym_this] = ACTIONS(877),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(877),
    [sym_false] = ACTIONS(877),
    [sym_null] = ACTIONS(877),
    [sym_undefined] = ACTIONS(877),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [130] = {
    [sym_import] = STATE(483),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(483),
    [sym_yield_expression] = STATE(483),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(483),
    [sym_jsx_fragment] = STATE(483),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(483),
    [sym_class] = STATE(483),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(483),
    [sym_arrow_function] = STATE(483),
    [sym_call_expression] = STATE(483),
    [sym_new_expression] = STATE(483),
    [sym_await_expression] = STATE(483),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(483),
    [sym_augmented_assignment_expression] = STATE(483),
    [sym_ternary_expression] = STATE(483),
    [sym_binary_expression] = STATE(483),
    [sym_unary_expression] = STATE(483),
    [sym_update_expression] = STATE(483),
    [sym_string] = STATE(483),
    [sym_template_string] = STATE(483),
    [sym_regex] = STATE(483),
    [sym_meta_property] = STATE(483),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(879),
    [sym_this] = ACTIONS(881),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(881),
    [sym_false] = ACTIONS(881),
    [sym_null] = ACTIONS(881),
    [sym_undefined] = ACTIONS(881),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [131] = {
    [sym_import] = STATE(438),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(438),
    [sym_yield_expression] = STATE(438),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(438),
    [sym_jsx_fragment] = STATE(438),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(438),
    [sym_class] = STATE(438),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(438),
    [sym_arrow_function] = STATE(438),
    [sym_call_expression] = STATE(438),
    [sym_new_expression] = STATE(438),
    [sym_await_expression] = STATE(438),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(438),
    [sym_augmented_assignment_expression] = STATE(438),
    [sym_ternary_expression] = STATE(438),
    [sym_binary_expression] = STATE(438),
    [sym_unary_expression] = STATE(438),
    [sym_update_expression] = STATE(438),
    [sym_string] = STATE(438),
    [sym_template_string] = STATE(438),
    [sym_regex] = STATE(438),
    [sym_meta_property] = STATE(438),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(883),
    [sym_this] = ACTIONS(885),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(885),
    [sym_false] = ACTIONS(885),
    [sym_null] = ACTIONS(885),
    [sym_undefined] = ACTIONS(885),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [132] = {
    [sym_import] = STATE(458),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(458),
    [sym_yield_expression] = STATE(458),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(458),
    [sym_jsx_fragment] = STATE(458),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(458),
    [sym_class] = STATE(458),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(458),
    [sym_arrow_function] = STATE(458),
    [sym_call_expression] = STATE(458),
    [sym_new_expression] = STATE(458),
    [sym_await_expression] = STATE(458),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(458),
    [sym_augmented_assignment_expression] = STATE(458),
    [sym_ternary_expression] = STATE(458),
    [sym_binary_expression] = STATE(458),
    [sym_unary_expression] = STATE(458),
    [sym_update_expression] = STATE(458),
    [sym_string] = STATE(458),
    [sym_template_string] = STATE(458),
    [sym_regex] = STATE(458),
    [sym_meta_property] = STATE(458),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(887),
    [sym_this] = ACTIONS(889),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(889),
    [sym_false] = ACTIONS(889),
    [sym_null] = ACTIONS(889),
    [sym_undefined] = ACTIONS(889),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [133] = {
    [sym_import] = STATE(388),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(388),
    [sym_yield_expression] = STATE(388),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(388),
    [sym_jsx_fragment] = STATE(388),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(388),
    [sym_class] = STATE(388),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(388),
    [sym_arrow_function] = STATE(388),
    [sym_call_expression] = STATE(388),
    [sym_new_expression] = STATE(388),
    [sym_await_expression] = STATE(388),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(388),
    [sym_augmented_assignment_expression] = STATE(388),
    [sym_ternary_expression] = STATE(388),
    [sym_binary_expression] = STATE(388),
    [sym_unary_expression] = STATE(388),
    [sym_update_expression] = STATE(388),
    [sym_string] = STATE(388),
    [sym_template_string] = STATE(388),
    [sym_regex] = STATE(388),
    [sym_meta_property] = STATE(388),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(863),
    [sym_this] = ACTIONS(865),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(865),
    [sym_false] = ACTIONS(865),
    [sym_null] = ACTIONS(865),
    [sym_undefined] = ACTIONS(865),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [134] = {
    [sym_import] = STATE(320),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(320),
    [sym_yield_expression] = STATE(320),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(320),
    [sym_jsx_fragment] = STATE(320),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(320),
    [sym_class] = STATE(320),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(320),
    [sym_arrow_function] = STATE(320),
    [sym_call_expression] = STATE(320),
    [sym_new_expression] = STATE(320),
    [sym_await_expression] = STATE(320),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(320),
    [sym_augmented_assignment_expression] = STATE(320),
    [sym_ternary_expression] = STATE(320),
    [sym_binary_expression] = STATE(320),
    [sym_unary_expression] = STATE(320),
    [sym_update_expression] = STATE(320),
    [sym_string] = STATE(320),
    [sym_template_string] = STATE(320),
    [sym_regex] = STATE(320),
    [sym_meta_property] = STATE(320),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(891),
    [sym_this] = ACTIONS(893),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(893),
    [sym_false] = ACTIONS(893),
    [sym_null] = ACTIONS(893),
    [sym_undefined] = ACTIONS(893),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [135] = {
    [sym_import] = STATE(505),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(505),
    [sym_yield_expression] = STATE(505),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(505),
    [sym_jsx_fragment] = STATE(505),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(505),
    [sym_class] = STATE(505),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(505),
    [sym_arrow_function] = STATE(505),
    [sym_call_expression] = STATE(505),
    [sym_new_expression] = STATE(505),
    [sym_await_expression] = STATE(505),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(505),
    [sym_augmented_assignment_expression] = STATE(505),
    [sym_ternary_expression] = STATE(505),
    [sym_binary_expression] = STATE(505),
    [sym_unary_expression] = STATE(505),
    [sym_update_expression] = STATE(505),
    [sym_string] = STATE(505),
    [sym_template_string] = STATE(505),
    [sym_regex] = STATE(505),
    [sym_meta_property] = STATE(505),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(895),
    [sym_this] = ACTIONS(897),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(897),
    [sym_false] = ACTIONS(897),
    [sym_null] = ACTIONS(897),
    [sym_undefined] = ACTIONS(897),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [136] = {
    [sym_import] = STATE(449),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(449),
    [sym_yield_expression] = STATE(449),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(449),
    [sym_jsx_fragment] = STATE(449),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(449),
    [sym_class] = STATE(449),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(449),
    [sym_arrow_function] = STATE(449),
    [sym_call_expression] = STATE(449),
    [sym_new_expression] = STATE(449),
    [sym_await_expression] = STATE(449),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(449),
    [sym_augmented_assignment_expression] = STATE(449),
    [sym_ternary_expression] = STATE(449),
    [sym_binary_expression] = STATE(449),
    [sym_unary_expression] = STATE(449),
    [sym_update_expression] = STATE(449),
    [sym_string] = STATE(449),
    [sym_template_string] = STATE(449),
    [sym_regex] = STATE(449),
    [sym_meta_property] = STATE(449),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(899),
    [sym_this] = ACTIONS(901),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(901),
    [sym_false] = ACTIONS(901),
    [sym_null] = ACTIONS(901),
    [sym_undefined] = ACTIONS(901),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [137] = {
    [sym_import] = STATE(316),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(316),
    [sym_yield_expression] = STATE(316),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(316),
    [sym_jsx_fragment] = STATE(316),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(316),
    [sym_class] = STATE(316),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(316),
    [sym_arrow_function] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_new_expression] = STATE(316),
    [sym_await_expression] = STATE(316),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(316),
    [sym_augmented_assignment_expression] = STATE(316),
    [sym_ternary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_update_expression] = STATE(316),
    [sym_string] = STATE(316),
    [sym_template_string] = STATE(316),
    [sym_regex] = STATE(316),
    [sym_meta_property] = STATE(316),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(903),
    [sym_this] = ACTIONS(905),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(905),
    [sym_false] = ACTIONS(905),
    [sym_null] = ACTIONS(905),
    [sym_undefined] = ACTIONS(905),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [138] = {
    [sym_import] = STATE(337),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(337),
    [sym_yield_expression] = STATE(337),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(337),
    [sym_jsx_fragment] = STATE(337),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(337),
    [sym_class] = STATE(337),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(337),
    [sym_arrow_function] = STATE(337),
    [sym_call_expression] = STATE(337),
    [sym_new_expression] = STATE(337),
    [sym_await_expression] = STATE(337),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(337),
    [sym_augmented_assignment_expression] = STATE(337),
    [sym_ternary_expression] = STATE(337),
    [sym_binary_expression] = STATE(337),
    [sym_unary_expression] = STATE(337),
    [sym_update_expression] = STATE(337),
    [sym_string] = STATE(337),
    [sym_template_string] = STATE(337),
    [sym_regex] = STATE(337),
    [sym_meta_property] = STATE(337),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(907),
    [sym_this] = ACTIONS(909),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(909),
    [sym_false] = ACTIONS(909),
    [sym_null] = ACTIONS(909),
    [sym_undefined] = ACTIONS(909),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [139] = {
    [sym_import] = STATE(456),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(456),
    [sym_yield_expression] = STATE(456),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(456),
    [sym_jsx_fragment] = STATE(456),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(456),
    [sym_class] = STATE(456),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(456),
    [sym_arrow_function] = STATE(456),
    [sym_call_expression] = STATE(456),
    [sym_new_expression] = STATE(456),
    [sym_await_expression] = STATE(456),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(456),
    [sym_augmented_assignment_expression] = STATE(456),
    [sym_ternary_expression] = STATE(456),
    [sym_binary_expression] = STATE(456),
    [sym_unary_expression] = STATE(456),
    [sym_update_expression] = STATE(456),
    [sym_string] = STATE(456),
    [sym_template_string] = STATE(456),
    [sym_regex] = STATE(456),
    [sym_meta_property] = STATE(456),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(911),
    [sym_this] = ACTIONS(913),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(913),
    [sym_false] = ACTIONS(913),
    [sym_null] = ACTIONS(913),
    [sym_undefined] = ACTIONS(913),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [140] = {
    [sym_import] = STATE(453),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(453),
    [sym_yield_expression] = STATE(453),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(453),
    [sym_jsx_fragment] = STATE(453),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(453),
    [sym_class] = STATE(453),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(453),
    [sym_arrow_function] = STATE(453),
    [sym_call_expression] = STATE(453),
    [sym_new_expression] = STATE(453),
    [sym_await_expression] = STATE(453),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(453),
    [sym_augmented_assignment_expression] = STATE(453),
    [sym_ternary_expression] = STATE(453),
    [sym_binary_expression] = STATE(453),
    [sym_unary_expression] = STATE(453),
    [sym_update_expression] = STATE(453),
    [sym_string] = STATE(453),
    [sym_template_string] = STATE(453),
    [sym_regex] = STATE(453),
    [sym_meta_property] = STATE(453),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(915),
    [sym_this] = ACTIONS(917),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(917),
    [sym_false] = ACTIONS(917),
    [sym_null] = ACTIONS(917),
    [sym_undefined] = ACTIONS(917),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [141] = {
    [sym_import] = STATE(451),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(451),
    [sym_yield_expression] = STATE(451),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(451),
    [sym_jsx_fragment] = STATE(451),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(451),
    [sym_class] = STATE(451),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(451),
    [sym_arrow_function] = STATE(451),
    [sym_call_expression] = STATE(451),
    [sym_new_expression] = STATE(451),
    [sym_await_expression] = STATE(451),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(451),
    [sym_augmented_assignment_expression] = STATE(451),
    [sym_ternary_expression] = STATE(451),
    [sym_binary_expression] = STATE(451),
    [sym_unary_expression] = STATE(451),
    [sym_update_expression] = STATE(451),
    [sym_string] = STATE(451),
    [sym_template_string] = STATE(451),
    [sym_regex] = STATE(451),
    [sym_meta_property] = STATE(451),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(919),
    [sym_this] = ACTIONS(921),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(921),
    [sym_false] = ACTIONS(921),
    [sym_null] = ACTIONS(921),
    [sym_undefined] = ACTIONS(921),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [142] = {
    [sym_import] = STATE(390),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(390),
    [sym_yield_expression] = STATE(390),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(390),
    [sym_jsx_fragment] = STATE(390),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(390),
    [sym_class] = STATE(390),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(390),
    [sym_arrow_function] = STATE(390),
    [sym_call_expression] = STATE(390),
    [sym_new_expression] = STATE(390),
    [sym_await_expression] = STATE(390),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(390),
    [sym_augmented_assignment_expression] = STATE(390),
    [sym_ternary_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_string] = STATE(390),
    [sym_template_string] = STATE(390),
    [sym_regex] = STATE(390),
    [sym_meta_property] = STATE(390),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(923),
    [sym_this] = ACTIONS(925),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(925),
    [sym_false] = ACTIONS(925),
    [sym_null] = ACTIONS(925),
    [sym_undefined] = ACTIONS(925),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [143] = {
    [sym_import] = STATE(328),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(328),
    [sym_yield_expression] = STATE(328),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(328),
    [sym_jsx_fragment] = STATE(328),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(328),
    [sym_class] = STATE(328),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(328),
    [sym_arrow_function] = STATE(328),
    [sym_call_expression] = STATE(328),
    [sym_new_expression] = STATE(328),
    [sym_await_expression] = STATE(328),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(328),
    [sym_augmented_assignment_expression] = STATE(328),
    [sym_ternary_expression] = STATE(328),
    [sym_binary_expression] = STATE(328),
    [sym_unary_expression] = STATE(328),
    [sym_update_expression] = STATE(328),
    [sym_string] = STATE(328),
    [sym_template_string] = STATE(328),
    [sym_regex] = STATE(328),
    [sym_meta_property] = STATE(328),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(927),
    [sym_this] = ACTIONS(929),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(929),
    [sym_false] = ACTIONS(929),
    [sym_null] = ACTIONS(929),
    [sym_undefined] = ACTIONS(929),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [144] = {
    [sym_import] = STATE(564),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(564),
    [sym_yield_expression] = STATE(564),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(564),
    [sym_jsx_fragment] = STATE(564),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(564),
    [sym_class] = STATE(564),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(564),
    [sym_arrow_function] = STATE(564),
    [sym_call_expression] = STATE(564),
    [sym_new_expression] = STATE(564),
    [sym_await_expression] = STATE(564),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(564),
    [sym_augmented_assignment_expression] = STATE(564),
    [sym_ternary_expression] = STATE(564),
    [sym_binary_expression] = STATE(564),
    [sym_unary_expression] = STATE(564),
    [sym_update_expression] = STATE(564),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(564),
    [sym_regex] = STATE(564),
    [sym_meta_property] = STATE(564),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(931),
    [sym_this] = ACTIONS(933),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(933),
    [sym_false] = ACTIONS(933),
    [sym_null] = ACTIONS(933),
    [sym_undefined] = ACTIONS(933),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [145] = {
    [sym_import] = STATE(416),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(416),
    [sym_yield_expression] = STATE(416),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(416),
    [sym_jsx_fragment] = STATE(416),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(416),
    [sym_class] = STATE(416),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(416),
    [sym_arrow_function] = STATE(416),
    [sym_call_expression] = STATE(416),
    [sym_new_expression] = STATE(416),
    [sym_await_expression] = STATE(416),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(416),
    [sym_augmented_assignment_expression] = STATE(416),
    [sym_ternary_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_update_expression] = STATE(416),
    [sym_string] = STATE(416),
    [sym_template_string] = STATE(416),
    [sym_regex] = STATE(416),
    [sym_meta_property] = STATE(416),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(935),
    [sym_this] = ACTIONS(937),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(937),
    [sym_false] = ACTIONS(937),
    [sym_null] = ACTIONS(937),
    [sym_undefined] = ACTIONS(937),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [146] = {
    [sym_import] = STATE(394),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(394),
    [sym_yield_expression] = STATE(394),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(394),
    [sym_jsx_fragment] = STATE(394),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(394),
    [sym_class] = STATE(394),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(394),
    [sym_arrow_function] = STATE(394),
    [sym_call_expression] = STATE(394),
    [sym_new_expression] = STATE(394),
    [sym_await_expression] = STATE(394),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(394),
    [sym_augmented_assignment_expression] = STATE(394),
    [sym_ternary_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym_string] = STATE(394),
    [sym_template_string] = STATE(394),
    [sym_regex] = STATE(394),
    [sym_meta_property] = STATE(394),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(939),
    [sym_this] = ACTIONS(941),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(941),
    [sym_false] = ACTIONS(941),
    [sym_null] = ACTIONS(941),
    [sym_undefined] = ACTIONS(941),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [147] = {
    [sym_import] = STATE(415),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(415),
    [sym_yield_expression] = STATE(415),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(415),
    [sym_jsx_fragment] = STATE(415),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(415),
    [sym_class] = STATE(415),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(415),
    [sym_arrow_function] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_await_expression] = STATE(415),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_string] = STATE(415),
    [sym_template_string] = STATE(415),
    [sym_regex] = STATE(415),
    [sym_meta_property] = STATE(415),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(943),
    [sym_this] = ACTIONS(945),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(945),
    [sym_false] = ACTIONS(945),
    [sym_null] = ACTIONS(945),
    [sym_undefined] = ACTIONS(945),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [148] = {
    [sym_import] = STATE(565),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(565),
    [sym_yield_expression] = STATE(565),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(565),
    [sym_jsx_fragment] = STATE(565),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(565),
    [sym_class] = STATE(565),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(565),
    [sym_arrow_function] = STATE(565),
    [sym_call_expression] = STATE(565),
    [sym_new_expression] = STATE(565),
    [sym_await_expression] = STATE(565),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(565),
    [sym_augmented_assignment_expression] = STATE(565),
    [sym_ternary_expression] = STATE(565),
    [sym_binary_expression] = STATE(565),
    [sym_unary_expression] = STATE(565),
    [sym_update_expression] = STATE(565),
    [sym_string] = STATE(565),
    [sym_template_string] = STATE(565),
    [sym_regex] = STATE(565),
    [sym_meta_property] = STATE(565),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(947),
    [sym_this] = ACTIONS(949),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(949),
    [sym_false] = ACTIONS(949),
    [sym_null] = ACTIONS(949),
    [sym_undefined] = ACTIONS(949),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [149] = {
    [sym_import] = STATE(336),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(336),
    [sym_yield_expression] = STATE(336),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(336),
    [sym_jsx_fragment] = STATE(336),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(336),
    [sym_class] = STATE(336),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(336),
    [sym_arrow_function] = STATE(336),
    [sym_call_expression] = STATE(336),
    [sym_new_expression] = STATE(336),
    [sym_await_expression] = STATE(336),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(336),
    [sym_augmented_assignment_expression] = STATE(336),
    [sym_ternary_expression] = STATE(336),
    [sym_binary_expression] = STATE(336),
    [sym_unary_expression] = STATE(336),
    [sym_update_expression] = STATE(336),
    [sym_string] = STATE(336),
    [sym_template_string] = STATE(336),
    [sym_regex] = STATE(336),
    [sym_meta_property] = STATE(336),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(951),
    [sym_this] = ACTIONS(953),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(953),
    [sym_false] = ACTIONS(953),
    [sym_null] = ACTIONS(953),
    [sym_undefined] = ACTIONS(953),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [150] = {
    [sym_import] = STATE(368),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(368),
    [sym_yield_expression] = STATE(368),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(368),
    [sym_jsx_fragment] = STATE(368),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(368),
    [sym_class] = STATE(368),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(368),
    [sym_arrow_function] = STATE(368),
    [sym_call_expression] = STATE(368),
    [sym_new_expression] = STATE(368),
    [sym_await_expression] = STATE(368),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(368),
    [sym_augmented_assignment_expression] = STATE(368),
    [sym_ternary_expression] = STATE(368),
    [sym_binary_expression] = STATE(368),
    [sym_unary_expression] = STATE(368),
    [sym_update_expression] = STATE(368),
    [sym_string] = STATE(368),
    [sym_template_string] = STATE(368),
    [sym_regex] = STATE(368),
    [sym_meta_property] = STATE(368),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(955),
    [sym_this] = ACTIONS(957),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(957),
    [sym_false] = ACTIONS(957),
    [sym_null] = ACTIONS(957),
    [sym_undefined] = ACTIONS(957),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [151] = {
    [sym_import] = STATE(345),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(345),
    [sym_yield_expression] = STATE(345),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(345),
    [sym_jsx_fragment] = STATE(345),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(345),
    [sym_class] = STATE(345),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(345),
    [sym_arrow_function] = STATE(345),
    [sym_call_expression] = STATE(345),
    [sym_new_expression] = STATE(345),
    [sym_await_expression] = STATE(345),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(345),
    [sym_augmented_assignment_expression] = STATE(345),
    [sym_ternary_expression] = STATE(345),
    [sym_binary_expression] = STATE(345),
    [sym_unary_expression] = STATE(345),
    [sym_update_expression] = STATE(345),
    [sym_string] = STATE(345),
    [sym_template_string] = STATE(345),
    [sym_regex] = STATE(345),
    [sym_meta_property] = STATE(345),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(959),
    [sym_this] = ACTIONS(961),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(961),
    [sym_false] = ACTIONS(961),
    [sym_null] = ACTIONS(961),
    [sym_undefined] = ACTIONS(961),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [152] = {
    [sym_import] = STATE(339),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(339),
    [sym_yield_expression] = STATE(339),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(339),
    [sym_jsx_fragment] = STATE(339),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(339),
    [sym_class] = STATE(339),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(339),
    [sym_arrow_function] = STATE(339),
    [sym_call_expression] = STATE(339),
    [sym_new_expression] = STATE(339),
    [sym_await_expression] = STATE(339),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(339),
    [sym_augmented_assignment_expression] = STATE(339),
    [sym_ternary_expression] = STATE(339),
    [sym_binary_expression] = STATE(339),
    [sym_unary_expression] = STATE(339),
    [sym_update_expression] = STATE(339),
    [sym_string] = STATE(339),
    [sym_template_string] = STATE(339),
    [sym_regex] = STATE(339),
    [sym_meta_property] = STATE(339),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(963),
    [sym_this] = ACTIONS(965),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(965),
    [sym_false] = ACTIONS(965),
    [sym_null] = ACTIONS(965),
    [sym_undefined] = ACTIONS(965),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [153] = {
    [sym_import] = STATE(343),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(343),
    [sym_yield_expression] = STATE(343),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(343),
    [sym_jsx_fragment] = STATE(343),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(343),
    [sym_class] = STATE(343),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(343),
    [sym_arrow_function] = STATE(343),
    [sym_call_expression] = STATE(343),
    [sym_new_expression] = STATE(343),
    [sym_await_expression] = STATE(343),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(343),
    [sym_augmented_assignment_expression] = STATE(343),
    [sym_ternary_expression] = STATE(343),
    [sym_binary_expression] = STATE(343),
    [sym_unary_expression] = STATE(343),
    [sym_update_expression] = STATE(343),
    [sym_string] = STATE(343),
    [sym_template_string] = STATE(343),
    [sym_regex] = STATE(343),
    [sym_meta_property] = STATE(343),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(967),
    [sym_this] = ACTIONS(969),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(969),
    [sym_false] = ACTIONS(969),
    [sym_null] = ACTIONS(969),
    [sym_undefined] = ACTIONS(969),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [154] = {
    [sym_import] = STATE(342),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(342),
    [sym_yield_expression] = STATE(342),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(342),
    [sym_jsx_fragment] = STATE(342),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(342),
    [sym_class] = STATE(342),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(342),
    [sym_arrow_function] = STATE(342),
    [sym_call_expression] = STATE(342),
    [sym_new_expression] = STATE(342),
    [sym_await_expression] = STATE(342),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(342),
    [sym_augmented_assignment_expression] = STATE(342),
    [sym_ternary_expression] = STATE(342),
    [sym_binary_expression] = STATE(342),
    [sym_unary_expression] = STATE(342),
    [sym_update_expression] = STATE(342),
    [sym_string] = STATE(342),
    [sym_template_string] = STATE(342),
    [sym_regex] = STATE(342),
    [sym_meta_property] = STATE(342),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(971),
    [sym_this] = ACTIONS(973),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(973),
    [sym_false] = ACTIONS(973),
    [sym_null] = ACTIONS(973),
    [sym_undefined] = ACTIONS(973),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [155] = {
    [sym_import] = STATE(374),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(374),
    [sym_yield_expression] = STATE(374),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(374),
    [sym_jsx_fragment] = STATE(374),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(374),
    [sym_class] = STATE(374),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(374),
    [sym_arrow_function] = STATE(374),
    [sym_call_expression] = STATE(374),
    [sym_new_expression] = STATE(374),
    [sym_await_expression] = STATE(374),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(374),
    [sym_augmented_assignment_expression] = STATE(374),
    [sym_ternary_expression] = STATE(374),
    [sym_binary_expression] = STATE(374),
    [sym_unary_expression] = STATE(374),
    [sym_update_expression] = STATE(374),
    [sym_string] = STATE(374),
    [sym_template_string] = STATE(374),
    [sym_regex] = STATE(374),
    [sym_meta_property] = STATE(374),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(975),
    [sym_this] = ACTIONS(977),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(977),
    [sym_false] = ACTIONS(977),
    [sym_null] = ACTIONS(977),
    [sym_undefined] = ACTIONS(977),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [156] = {
    [sym_import] = STATE(500),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(500),
    [sym_yield_expression] = STATE(500),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(500),
    [sym_jsx_fragment] = STATE(500),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(500),
    [sym_class] = STATE(500),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(500),
    [sym_arrow_function] = STATE(500),
    [sym_call_expression] = STATE(500),
    [sym_new_expression] = STATE(500),
    [sym_await_expression] = STATE(500),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(500),
    [sym_augmented_assignment_expression] = STATE(500),
    [sym_ternary_expression] = STATE(500),
    [sym_binary_expression] = STATE(500),
    [sym_unary_expression] = STATE(500),
    [sym_update_expression] = STATE(500),
    [sym_string] = STATE(500),
    [sym_template_string] = STATE(500),
    [sym_regex] = STATE(500),
    [sym_meta_property] = STATE(500),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(979),
    [sym_this] = ACTIONS(981),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(981),
    [sym_false] = ACTIONS(981),
    [sym_null] = ACTIONS(981),
    [sym_undefined] = ACTIONS(981),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [157] = {
    [sym_import] = STATE(405),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(405),
    [sym_yield_expression] = STATE(405),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(405),
    [sym_jsx_fragment] = STATE(405),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(405),
    [sym_class] = STATE(405),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(405),
    [sym_arrow_function] = STATE(405),
    [sym_call_expression] = STATE(405),
    [sym_new_expression] = STATE(405),
    [sym_await_expression] = STATE(405),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(405),
    [sym_augmented_assignment_expression] = STATE(405),
    [sym_ternary_expression] = STATE(405),
    [sym_binary_expression] = STATE(405),
    [sym_unary_expression] = STATE(405),
    [sym_update_expression] = STATE(405),
    [sym_string] = STATE(405),
    [sym_template_string] = STATE(405),
    [sym_regex] = STATE(405),
    [sym_meta_property] = STATE(405),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(983),
    [sym_this] = ACTIONS(985),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(985),
    [sym_false] = ACTIONS(985),
    [sym_null] = ACTIONS(985),
    [sym_undefined] = ACTIONS(985),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [158] = {
    [sym_import] = STATE(499),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(499),
    [sym_yield_expression] = STATE(499),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(499),
    [sym_jsx_fragment] = STATE(499),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(499),
    [sym_class] = STATE(499),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(499),
    [sym_arrow_function] = STATE(499),
    [sym_call_expression] = STATE(499),
    [sym_new_expression] = STATE(499),
    [sym_await_expression] = STATE(499),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(499),
    [sym_augmented_assignment_expression] = STATE(499),
    [sym_ternary_expression] = STATE(499),
    [sym_binary_expression] = STATE(499),
    [sym_unary_expression] = STATE(499),
    [sym_update_expression] = STATE(499),
    [sym_string] = STATE(499),
    [sym_template_string] = STATE(499),
    [sym_regex] = STATE(499),
    [sym_meta_property] = STATE(499),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(987),
    [sym_this] = ACTIONS(989),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(989),
    [sym_false] = ACTIONS(989),
    [sym_null] = ACTIONS(989),
    [sym_undefined] = ACTIONS(989),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [159] = {
    [sym_import] = STATE(498),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(498),
    [sym_yield_expression] = STATE(498),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(498),
    [sym_jsx_fragment] = STATE(498),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(498),
    [sym_class] = STATE(498),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(498),
    [sym_arrow_function] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_new_expression] = STATE(498),
    [sym_await_expression] = STATE(498),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(498),
    [sym_augmented_assignment_expression] = STATE(498),
    [sym_ternary_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_update_expression] = STATE(498),
    [sym_string] = STATE(498),
    [sym_template_string] = STATE(498),
    [sym_regex] = STATE(498),
    [sym_meta_property] = STATE(498),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(991),
    [sym_this] = ACTIONS(993),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(993),
    [sym_false] = ACTIONS(993),
    [sym_null] = ACTIONS(993),
    [sym_undefined] = ACTIONS(993),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [160] = {
    [sym_import] = STATE(497),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(497),
    [sym_yield_expression] = STATE(497),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(497),
    [sym_jsx_fragment] = STATE(497),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(497),
    [sym_class] = STATE(497),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(497),
    [sym_arrow_function] = STATE(497),
    [sym_call_expression] = STATE(497),
    [sym_new_expression] = STATE(497),
    [sym_await_expression] = STATE(497),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(497),
    [sym_augmented_assignment_expression] = STATE(497),
    [sym_ternary_expression] = STATE(497),
    [sym_binary_expression] = STATE(497),
    [sym_unary_expression] = STATE(497),
    [sym_update_expression] = STATE(497),
    [sym_string] = STATE(497),
    [sym_template_string] = STATE(497),
    [sym_regex] = STATE(497),
    [sym_meta_property] = STATE(497),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(995),
    [sym_this] = ACTIONS(997),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(997),
    [sym_false] = ACTIONS(997),
    [sym_null] = ACTIONS(997),
    [sym_undefined] = ACTIONS(997),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [161] = {
    [sym_import] = STATE(321),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(321),
    [sym_yield_expression] = STATE(321),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(321),
    [sym_jsx_fragment] = STATE(321),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(321),
    [sym_class] = STATE(321),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(321),
    [sym_arrow_function] = STATE(321),
    [sym_call_expression] = STATE(321),
    [sym_new_expression] = STATE(321),
    [sym_await_expression] = STATE(321),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(321),
    [sym_augmented_assignment_expression] = STATE(321),
    [sym_ternary_expression] = STATE(321),
    [sym_binary_expression] = STATE(321),
    [sym_unary_expression] = STATE(321),
    [sym_update_expression] = STATE(321),
    [sym_string] = STATE(321),
    [sym_template_string] = STATE(321),
    [sym_regex] = STATE(321),
    [sym_meta_property] = STATE(321),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(999),
    [sym_this] = ACTIONS(1001),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1001),
    [sym_false] = ACTIONS(1001),
    [sym_null] = ACTIONS(1001),
    [sym_undefined] = ACTIONS(1001),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [162] = {
    [sym_import] = STATE(408),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(408),
    [sym_yield_expression] = STATE(408),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(408),
    [sym_jsx_fragment] = STATE(408),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(408),
    [sym_class] = STATE(408),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(408),
    [sym_arrow_function] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_new_expression] = STATE(408),
    [sym_await_expression] = STATE(408),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(408),
    [sym_augmented_assignment_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_update_expression] = STATE(408),
    [sym_string] = STATE(408),
    [sym_template_string] = STATE(408),
    [sym_regex] = STATE(408),
    [sym_meta_property] = STATE(408),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1003),
    [sym_this] = ACTIONS(1005),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1005),
    [sym_false] = ACTIONS(1005),
    [sym_null] = ACTIONS(1005),
    [sym_undefined] = ACTIONS(1005),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [163] = {
    [sym_import] = STATE(569),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(569),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(569),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(569),
    [sym_arrow_function] = STATE(569),
    [sym_call_expression] = STATE(569),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(569),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(569),
    [sym_template_string] = STATE(569),
    [sym_regex] = STATE(569),
    [sym_meta_property] = STATE(569),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1007),
    [sym_this] = ACTIONS(1009),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1009),
    [sym_false] = ACTIONS(1009),
    [sym_null] = ACTIONS(1009),
    [sym_undefined] = ACTIONS(1009),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [164] = {
    [sym_import] = STATE(410),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(410),
    [sym_yield_expression] = STATE(410),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(410),
    [sym_jsx_fragment] = STATE(410),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(410),
    [sym_class] = STATE(410),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(410),
    [sym_arrow_function] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_new_expression] = STATE(410),
    [sym_await_expression] = STATE(410),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(410),
    [sym_augmented_assignment_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_string] = STATE(410),
    [sym_template_string] = STATE(410),
    [sym_regex] = STATE(410),
    [sym_meta_property] = STATE(410),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1011),
    [sym_this] = ACTIONS(1013),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1013),
    [sym_false] = ACTIONS(1013),
    [sym_null] = ACTIONS(1013),
    [sym_undefined] = ACTIONS(1013),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [165] = {
    [sym_import] = STATE(411),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(411),
    [sym_yield_expression] = STATE(411),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(411),
    [sym_jsx_fragment] = STATE(411),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(411),
    [sym_class] = STATE(411),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(411),
    [sym_arrow_function] = STATE(411),
    [sym_call_expression] = STATE(411),
    [sym_new_expression] = STATE(411),
    [sym_await_expression] = STATE(411),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(411),
    [sym_augmented_assignment_expression] = STATE(411),
    [sym_ternary_expression] = STATE(411),
    [sym_binary_expression] = STATE(411),
    [sym_unary_expression] = STATE(411),
    [sym_update_expression] = STATE(411),
    [sym_string] = STATE(411),
    [sym_template_string] = STATE(411),
    [sym_regex] = STATE(411),
    [sym_meta_property] = STATE(411),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1015),
    [sym_this] = ACTIONS(1017),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1017),
    [sym_false] = ACTIONS(1017),
    [sym_null] = ACTIONS(1017),
    [sym_undefined] = ACTIONS(1017),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [166] = {
    [sym_import] = STATE(412),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(412),
    [sym_yield_expression] = STATE(412),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(412),
    [sym_jsx_fragment] = STATE(412),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(412),
    [sym_class] = STATE(412),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(412),
    [sym_arrow_function] = STATE(412),
    [sym_call_expression] = STATE(412),
    [sym_new_expression] = STATE(412),
    [sym_await_expression] = STATE(412),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(412),
    [sym_augmented_assignment_expression] = STATE(412),
    [sym_ternary_expression] = STATE(412),
    [sym_binary_expression] = STATE(412),
    [sym_unary_expression] = STATE(412),
    [sym_update_expression] = STATE(412),
    [sym_string] = STATE(412),
    [sym_template_string] = STATE(412),
    [sym_regex] = STATE(412),
    [sym_meta_property] = STATE(412),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1019),
    [sym_this] = ACTIONS(1021),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1021),
    [sym_false] = ACTIONS(1021),
    [sym_null] = ACTIONS(1021),
    [sym_undefined] = ACTIONS(1021),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [167] = {
    [sym_import] = STATE(413),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(413),
    [sym_yield_expression] = STATE(413),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(413),
    [sym_jsx_fragment] = STATE(413),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(413),
    [sym_class] = STATE(413),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(413),
    [sym_arrow_function] = STATE(413),
    [sym_call_expression] = STATE(413),
    [sym_new_expression] = STATE(413),
    [sym_await_expression] = STATE(413),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(413),
    [sym_augmented_assignment_expression] = STATE(413),
    [sym_ternary_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym_string] = STATE(413),
    [sym_template_string] = STATE(413),
    [sym_regex] = STATE(413),
    [sym_meta_property] = STATE(413),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1023),
    [sym_this] = ACTIONS(1025),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1025),
    [sym_false] = ACTIONS(1025),
    [sym_null] = ACTIONS(1025),
    [sym_undefined] = ACTIONS(1025),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [168] = {
    [sym_import] = STATE(353),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(353),
    [sym_yield_expression] = STATE(353),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(353),
    [sym_jsx_fragment] = STATE(353),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(353),
    [sym_class] = STATE(353),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(353),
    [sym_arrow_function] = STATE(353),
    [sym_call_expression] = STATE(353),
    [sym_new_expression] = STATE(353),
    [sym_await_expression] = STATE(353),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(353),
    [sym_augmented_assignment_expression] = STATE(353),
    [sym_ternary_expression] = STATE(353),
    [sym_binary_expression] = STATE(353),
    [sym_unary_expression] = STATE(353),
    [sym_update_expression] = STATE(353),
    [sym_string] = STATE(353),
    [sym_template_string] = STATE(353),
    [sym_regex] = STATE(353),
    [sym_meta_property] = STATE(353),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1027),
    [sym_this] = ACTIONS(1029),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [sym_null] = ACTIONS(1029),
    [sym_undefined] = ACTIONS(1029),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [169] = {
    [sym_import] = STATE(329),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(329),
    [sym_yield_expression] = STATE(329),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(329),
    [sym_jsx_fragment] = STATE(329),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(329),
    [sym_class] = STATE(329),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(329),
    [sym_arrow_function] = STATE(329),
    [sym_call_expression] = STATE(329),
    [sym_new_expression] = STATE(329),
    [sym_await_expression] = STATE(329),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(329),
    [sym_augmented_assignment_expression] = STATE(329),
    [sym_ternary_expression] = STATE(329),
    [sym_binary_expression] = STATE(329),
    [sym_unary_expression] = STATE(329),
    [sym_update_expression] = STATE(329),
    [sym_string] = STATE(329),
    [sym_template_string] = STATE(329),
    [sym_regex] = STATE(329),
    [sym_meta_property] = STATE(329),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1031),
    [sym_this] = ACTIONS(1033),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1033),
    [sym_false] = ACTIONS(1033),
    [sym_null] = ACTIONS(1033),
    [sym_undefined] = ACTIONS(1033),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [170] = {
    [sym_import] = STATE(325),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(325),
    [sym_yield_expression] = STATE(325),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(325),
    [sym_jsx_fragment] = STATE(325),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(325),
    [sym_class] = STATE(325),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(325),
    [sym_arrow_function] = STATE(325),
    [sym_call_expression] = STATE(325),
    [sym_new_expression] = STATE(325),
    [sym_await_expression] = STATE(325),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(325),
    [sym_augmented_assignment_expression] = STATE(325),
    [sym_ternary_expression] = STATE(325),
    [sym_binary_expression] = STATE(325),
    [sym_unary_expression] = STATE(325),
    [sym_update_expression] = STATE(325),
    [sym_string] = STATE(325),
    [sym_template_string] = STATE(325),
    [sym_regex] = STATE(325),
    [sym_meta_property] = STATE(325),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1035),
    [sym_this] = ACTIONS(1037),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1037),
    [sym_false] = ACTIONS(1037),
    [sym_null] = ACTIONS(1037),
    [sym_undefined] = ACTIONS(1037),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [171] = {
    [sym_import] = STATE(346),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(346),
    [sym_yield_expression] = STATE(346),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(346),
    [sym_jsx_fragment] = STATE(346),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(346),
    [sym_class] = STATE(346),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(346),
    [sym_arrow_function] = STATE(346),
    [sym_call_expression] = STATE(346),
    [sym_new_expression] = STATE(346),
    [sym_await_expression] = STATE(346),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(346),
    [sym_augmented_assignment_expression] = STATE(346),
    [sym_ternary_expression] = STATE(346),
    [sym_binary_expression] = STATE(346),
    [sym_unary_expression] = STATE(346),
    [sym_update_expression] = STATE(346),
    [sym_string] = STATE(346),
    [sym_template_string] = STATE(346),
    [sym_regex] = STATE(346),
    [sym_meta_property] = STATE(346),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1039),
    [sym_this] = ACTIONS(1041),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1041),
    [sym_false] = ACTIONS(1041),
    [sym_null] = ACTIONS(1041),
    [sym_undefined] = ACTIONS(1041),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [172] = {
    [sym_import] = STATE(330),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(330),
    [sym_yield_expression] = STATE(330),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(330),
    [sym_jsx_fragment] = STATE(330),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(330),
    [sym_class] = STATE(330),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(330),
    [sym_arrow_function] = STATE(330),
    [sym_call_expression] = STATE(330),
    [sym_new_expression] = STATE(330),
    [sym_await_expression] = STATE(330),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(330),
    [sym_augmented_assignment_expression] = STATE(330),
    [sym_ternary_expression] = STATE(330),
    [sym_binary_expression] = STATE(330),
    [sym_unary_expression] = STATE(330),
    [sym_update_expression] = STATE(330),
    [sym_string] = STATE(330),
    [sym_template_string] = STATE(330),
    [sym_regex] = STATE(330),
    [sym_meta_property] = STATE(330),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1043),
    [sym_this] = ACTIONS(1045),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1045),
    [sym_false] = ACTIONS(1045),
    [sym_null] = ACTIONS(1045),
    [sym_undefined] = ACTIONS(1045),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [173] = {
    [sym_import] = STATE(319),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(319),
    [sym_yield_expression] = STATE(319),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(319),
    [sym_jsx_fragment] = STATE(319),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(319),
    [sym_class] = STATE(319),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(319),
    [sym_arrow_function] = STATE(319),
    [sym_call_expression] = STATE(319),
    [sym_new_expression] = STATE(319),
    [sym_await_expression] = STATE(319),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(319),
    [sym_augmented_assignment_expression] = STATE(319),
    [sym_ternary_expression] = STATE(319),
    [sym_binary_expression] = STATE(319),
    [sym_unary_expression] = STATE(319),
    [sym_update_expression] = STATE(319),
    [sym_string] = STATE(319),
    [sym_template_string] = STATE(319),
    [sym_regex] = STATE(319),
    [sym_meta_property] = STATE(319),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1047),
    [sym_this] = ACTIONS(1049),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1049),
    [sym_false] = ACTIONS(1049),
    [sym_null] = ACTIONS(1049),
    [sym_undefined] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [174] = {
    [sym_import] = STATE(352),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(352),
    [sym_yield_expression] = STATE(352),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(352),
    [sym_jsx_fragment] = STATE(352),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(352),
    [sym_class] = STATE(352),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(352),
    [sym_arrow_function] = STATE(352),
    [sym_call_expression] = STATE(352),
    [sym_new_expression] = STATE(352),
    [sym_await_expression] = STATE(352),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(352),
    [sym_augmented_assignment_expression] = STATE(352),
    [sym_ternary_expression] = STATE(352),
    [sym_binary_expression] = STATE(352),
    [sym_unary_expression] = STATE(352),
    [sym_update_expression] = STATE(352),
    [sym_string] = STATE(352),
    [sym_template_string] = STATE(352),
    [sym_regex] = STATE(352),
    [sym_meta_property] = STATE(352),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1051),
    [sym_this] = ACTIONS(1053),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1053),
    [sym_false] = ACTIONS(1053),
    [sym_null] = ACTIONS(1053),
    [sym_undefined] = ACTIONS(1053),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [175] = {
    [sym_import] = STATE(351),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(351),
    [sym_yield_expression] = STATE(351),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(351),
    [sym_jsx_fragment] = STATE(351),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(351),
    [sym_class] = STATE(351),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(351),
    [sym_arrow_function] = STATE(351),
    [sym_call_expression] = STATE(351),
    [sym_new_expression] = STATE(351),
    [sym_await_expression] = STATE(351),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(351),
    [sym_augmented_assignment_expression] = STATE(351),
    [sym_ternary_expression] = STATE(351),
    [sym_binary_expression] = STATE(351),
    [sym_unary_expression] = STATE(351),
    [sym_update_expression] = STATE(351),
    [sym_string] = STATE(351),
    [sym_template_string] = STATE(351),
    [sym_regex] = STATE(351),
    [sym_meta_property] = STATE(351),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1055),
    [sym_this] = ACTIONS(1057),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1057),
    [sym_false] = ACTIONS(1057),
    [sym_null] = ACTIONS(1057),
    [sym_undefined] = ACTIONS(1057),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [176] = {
    [sym_import] = STATE(414),
    [sym_parenthesized_expression] = STATE(305),
    [sym__expression] = STATE(414),
    [sym_yield_expression] = STATE(414),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(414),
    [sym_jsx_fragment] = STATE(414),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(414),
    [sym_class] = STATE(414),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(414),
    [sym_arrow_function] = STATE(414),
    [sym_call_expression] = STATE(414),
    [sym_new_expression] = STATE(414),
    [sym_await_expression] = STATE(414),
    [sym_member_expression] = STATE(305),
    [sym_subscript_expression] = STATE(305),
    [sym_assignment_expression] = STATE(414),
    [sym_augmented_assignment_expression] = STATE(414),
    [sym_ternary_expression] = STATE(414),
    [sym_binary_expression] = STATE(414),
    [sym_unary_expression] = STATE(414),
    [sym_update_expression] = STATE(414),
    [sym_string] = STATE(414),
    [sym_template_string] = STATE(414),
    [sym_regex] = STATE(414),
    [sym_meta_property] = STATE(414),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(423),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1059),
    [sym_this] = ACTIONS(1061),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1061),
    [sym_false] = ACTIONS(1061),
    [sym_null] = ACTIONS(1061),
    [sym_undefined] = ACTIONS(1061),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
  },
  [177] = {
    [sym_import] = STATE(332),
    [sym_parenthesized_expression] = STATE(284),
    [sym__expression] = STATE(332),
    [sym_yield_expression] = STATE(332),
    [sym_object] = STATE(360),
    [sym_array] = STATE(362),
    [sym_jsx_element] = STATE(332),
    [sym_jsx_fragment] = STATE(332),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(332),
    [sym_class] = STATE(332),
    [sym_function] = STATE(344),
    [sym_generator_function] = STATE(332),
    [sym_arrow_function] = STATE(332),
    [sym_call_expression] = STATE(332),
    [sym_new_expression] = STATE(332),
    [sym_await_expression] = STATE(332),
    [sym_member_expression] = STATE(284),
    [sym_subscript_expression] = STATE(284),
    [sym_assignment_expression] = STATE(332),
    [sym_augmented_assignment_expression] = STATE(332),
    [sym_ternary_expression] = STATE(332),
    [sym_binary_expression] = STATE(332),
    [sym_unary_expression] = STATE(332),
    [sym_update_expression] = STATE(332),
    [sym_string] = STATE(332),
    [sym_template_string] = STATE(332),
    [sym_regex] = STATE(332),
    [sym_meta_property] = STATE(332),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_import] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_await] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(373),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(381),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(1063),
    [sym_this] = ACTIONS(1065),
    [sym_super] = ACTIONS(409),
    [sym_true] = ACTIONS(1065),
    [sym_false] = ACTIONS(1065),
    [sym_null] = ACTIONS(1065),
    [sym_undefined] = ACTIONS(1065),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(411),
    [anon_sym_get] = ACTIONS(411),
    [anon_sym_set] = ACTIONS(411),
  },
  [178] = {
    [sym_string] = STATE(1015),
    [sym_formal_parameters] = STATE(1126),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(838),
    [sym_identifier] = ACTIONS(1067),
    [anon_sym_STAR] = ACTIONS(1069),
    [anon_sym_COMMA] = ACTIONS(1072),
    [anon_sym_RBRACE] = ACTIONS(1074),
    [anon_sym_LPAREN] = ACTIONS(1076),
    [anon_sym_in] = ACTIONS(1080),
    [anon_sym_SEMI] = ACTIONS(1072),
    [anon_sym_COLON] = ACTIONS(1082),
    [anon_sym_EQ] = ACTIONS(1085),
    [anon_sym_LBRACK] = ACTIONS(1087),
    [anon_sym_LT] = ACTIONS(1080),
    [anon_sym_GT] = ACTIONS(1080),
    [anon_sym_SLASH] = ACTIONS(1080),
    [anon_sym_DOT] = ACTIONS(1090),
    [anon_sym_async] = ACTIONS(1092),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_EQ_GT] = ACTIONS(1096),
    [anon_sym_PLUS_EQ] = ACTIONS(1098),
    [anon_sym_DASH_EQ] = ACTIONS(1098),
    [anon_sym_STAR_EQ] = ACTIONS(1098),
    [anon_sym_SLASH_EQ] = ACTIONS(1098),
    [anon_sym_PERCENT_EQ] = ACTIONS(1098),
    [anon_sym_CARET_EQ] = ACTIONS(1098),
    [anon_sym_AMP_EQ] = ACTIONS(1098),
    [anon_sym_PIPE_EQ] = ACTIONS(1098),
    [anon_sym_GT_GT_EQ] = ACTIONS(1098),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1098),
    [anon_sym_LT_LT_EQ] = ACTIONS(1098),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1098),
    [anon_sym_QMARK] = ACTIONS(1080),
    [anon_sym_AMP_AMP] = ACTIONS(1072),
    [anon_sym_PIPE_PIPE] = ACTIONS(1072),
    [anon_sym_GT_GT] = ACTIONS(1080),
    [anon_sym_GT_GT_GT] = ACTIONS(1080),
    [anon_sym_LT_LT] = ACTIONS(1080),
    [anon_sym_AMP] = ACTIONS(1080),
    [anon_sym_CARET] = ACTIONS(1080),
    [anon_sym_PIPE] = ACTIONS(1080),
    [anon_sym_PLUS] = ACTIONS(1080),
    [anon_sym_DASH] = ACTIONS(1080),
    [anon_sym_PERCENT] = ACTIONS(1080),
    [anon_sym_STAR_STAR] = ACTIONS(1080),
    [anon_sym_LT_EQ] = ACTIONS(1072),
    [anon_sym_EQ_EQ] = ACTIONS(1080),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1072),
    [anon_sym_BANG_EQ] = ACTIONS(1080),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1072),
    [anon_sym_GT_EQ] = ACTIONS(1072),
    [anon_sym_QMARK_QMARK] = ACTIONS(1072),
    [anon_sym_instanceof] = ACTIONS(1080),
    [anon_sym_PLUS_PLUS] = ACTIONS(1072),
    [anon_sym_DASH_DASH] = ACTIONS(1072),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1072),
    [sym_number] = ACTIONS(1100),
    [anon_sym_static] = ACTIONS(1092),
    [anon_sym_get] = ACTIONS(1102),
    [anon_sym_set] = ACTIONS(1102),
    [sym__automatic_semicolon] = ACTIONS(1072),
  },
  [179] = {
    [sym_string] = STATE(1015),
    [sym_formal_parameters] = STATE(1126),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(1067),
    [anon_sym_STAR] = ACTIONS(1069),
    [anon_sym_COMMA] = ACTIONS(1072),
    [anon_sym_RBRACE] = ACTIONS(1104),
    [anon_sym_LPAREN] = ACTIONS(1076),
    [anon_sym_in] = ACTIONS(1080),
    [anon_sym_SEMI] = ACTIONS(1072),
    [anon_sym_COLON] = ACTIONS(1082),
    [anon_sym_EQ] = ACTIONS(1085),
    [anon_sym_LBRACK] = ACTIONS(1087),
    [anon_sym_LT] = ACTIONS(1080),
    [anon_sym_GT] = ACTIONS(1080),
    [anon_sym_SLASH] = ACTIONS(1080),
    [anon_sym_DOT] = ACTIONS(1090),
    [anon_sym_async] = ACTIONS(1092),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_EQ_GT] = ACTIONS(1096),
    [anon_sym_PLUS_EQ] = ACTIONS(1098),
    [anon_sym_DASH_EQ] = ACTIONS(1098),
    [anon_sym_STAR_EQ] = ACTIONS(1098),
    [anon_sym_SLASH_EQ] = ACTIONS(1098),
    [anon_sym_PERCENT_EQ] = ACTIONS(1098),
    [anon_sym_CARET_EQ] = ACTIONS(1098),
    [anon_sym_AMP_EQ] = ACTIONS(1098),
    [anon_sym_PIPE_EQ] = ACTIONS(1098),
    [anon_sym_GT_GT_EQ] = ACTIONS(1098),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1098),
    [anon_sym_LT_LT_EQ] = ACTIONS(1098),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1098),
    [anon_sym_QMARK] = ACTIONS(1080),
    [anon_sym_AMP_AMP] = ACTIONS(1072),
    [anon_sym_PIPE_PIPE] = ACTIONS(1072),
    [anon_sym_GT_GT] = ACTIONS(1080),
    [anon_sym_GT_GT_GT] = ACTIONS(1080),
    [anon_sym_LT_LT] = ACTIONS(1080),
    [anon_sym_AMP] = ACTIONS(1080),
    [anon_sym_CARET] = ACTIONS(1080),
    [anon_sym_PIPE] = ACTIONS(1080),
    [anon_sym_PLUS] = ACTIONS(1080),
    [anon_sym_DASH] = ACTIONS(1080),
    [anon_sym_PERCENT] = ACTIONS(1080),
    [anon_sym_STAR_STAR] = ACTIONS(1080),
    [anon_sym_LT_EQ] = ACTIONS(1072),
    [anon_sym_EQ_EQ] = ACTIONS(1080),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1072),
    [anon_sym_BANG_EQ] = ACTIONS(1080),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1072),
    [anon_sym_GT_EQ] = ACTIONS(1072),
    [anon_sym_QMARK_QMARK] = ACTIONS(1072),
    [anon_sym_instanceof] = ACTIONS(1080),
    [anon_sym_PLUS_PLUS] = ACTIONS(1072),
    [anon_sym_DASH_DASH] = ACTIONS(1072),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1072),
    [sym_number] = ACTIONS(1100),
    [anon_sym_static] = ACTIONS(1092),
    [anon_sym_get] = ACTIONS(1102),
    [anon_sym_set] = ACTIONS(1102),
    [sym__automatic_semicolon] = ACTIONS(1072),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(437),
    [sym_identifier] = ACTIONS(439),
    [anon_sym_export] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(437),
    [anon_sym_COMMA] = ACTIONS(437),
    [anon_sym_RBRACE] = ACTIONS(437),
    [anon_sym_import] = ACTIONS(439),
    [anon_sym_var] = ACTIONS(439),
    [anon_sym_let] = ACTIONS(439),
    [anon_sym_const] = ACTIONS(439),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_else] = ACTIONS(439),
    [anon_sym_switch] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_await] = ACTIONS(439),
    [anon_sym_while] = ACTIONS(439),
    [anon_sym_do] = ACTIONS(439),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_with] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(439),
    [anon_sym_continue] = ACTIONS(439),
    [anon_sym_debugger] = ACTIONS(439),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_SEMI] = ACTIONS(437),
    [anon_sym_case] = ACTIONS(439),
    [anon_sym_catch] = ACTIONS(439),
    [anon_sym_finally] = ACTIONS(439),
    [anon_sym_yield] = ACTIONS(439),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_SLASH] = ACTIONS(439),
    [anon_sym_class] = ACTIONS(439),
    [anon_sym_async] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(439),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(439),
    [anon_sym_void] = ACTIONS(439),
    [anon_sym_delete] = ACTIONS(439),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [sym_number] = ACTIONS(437),
    [sym_this] = ACTIONS(439),
    [sym_super] = ACTIONS(439),
    [sym_true] = ACTIONS(439),
    [sym_false] = ACTIONS(439),
    [sym_null] = ACTIONS(439),
    [sym_undefined] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_get] = ACTIONS(439),
    [anon_sym_set] = ACTIONS(439),
    [sym_preproc] = ACTIONS(437),
    [sym__automatic_semicolon] = ACTIONS(445),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(539),
    [anon_sym_default] = ACTIONS(541),
    [anon_sym_LBRACE] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_import] = ACTIONS(541),
    [anon_sym_var] = ACTIONS(541),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(541),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_else] = ACTIONS(541),
    [anon_sym_switch] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_LPAREN] = ACTIONS(539),
    [anon_sym_await] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_do] = ACTIONS(541),
    [anon_sym_try] = ACTIONS(541),
    [anon_sym_with] = ACTIONS(541),
    [anon_sym_break] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(541),
    [anon_sym_debugger] = ACTIONS(541),
    [anon_sym_return] = ACTIONS(541),
    [anon_sym_throw] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_case] = ACTIONS(541),
    [anon_sym_catch] = ACTIONS(541),
    [anon_sym_finally] = ACTIONS(541),
    [anon_sym_yield] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(539),
    [anon_sym_SLASH] = ACTIONS(541),
    [anon_sym_class] = ACTIONS(541),
    [anon_sym_async] = ACTIONS(541),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_new] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(541),
    [anon_sym_DASH] = ACTIONS(541),
    [anon_sym_BANG] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_void] = ACTIONS(541),
    [anon_sym_delete] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(539),
    [sym_number] = ACTIONS(539),
    [sym_this] = ACTIONS(541),
    [sym_super] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_undefined] = ACTIONS(541),
    [anon_sym_AT] = ACTIONS(539),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [sym_preproc] = ACTIONS(539),
    [sym__automatic_semicolon] = ACTIONS(1106),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DQUOTE,
    ACTIONS(401), 1,
      anon_sym_SQUOTE,
    ACTIONS(1069), 1,
      anon_sym_STAR,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1085), 1,
      anon_sym_EQ,
    ACTIONS(1087), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1100), 1,
      sym_number,
    ACTIONS(1104), 1,
      anon_sym_RBRACE,
    ACTIONS(1110), 1,
      anon_sym_LPAREN,
    ACTIONS(1113), 1,
      anon_sym_async,
    STATE(870), 1,
      aux_sym_object_repeat1,
    ACTIONS(1108), 2,
      sym_identifier,
      anon_sym_static,
    ACTIONS(1115), 2,
      anon_sym_get,
      anon_sym_set,
    STATE(1015), 3,
      sym_string,
      sym__property_name,
      sym_computed_property_name,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [105] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DQUOTE,
    ACTIONS(401), 1,
      anon_sym_SQUOTE,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1085), 1,
      anon_sym_EQ,
    ACTIONS(1087), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1100), 1,
      sym_number,
    ACTIONS(1104), 1,
      anon_sym_RBRACE,
    ACTIONS(1110), 1,
      anon_sym_LPAREN,
    STATE(870), 1,
      aux_sym_object_repeat1,
    STATE(1015), 3,
      sym_string,
      sym__property_name,
      sym_computed_property_name,
    ACTIONS(1108), 5,
      anon_sym_async,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 19,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(541), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [275] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_catch,
    ACTIONS(1123), 1,
      anon_sym_finally,
    STATE(189), 1,
      sym_catch_clause,
    STATE(232), 1,
      sym_finally_clause,
    ACTIONS(1117), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1119), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 19,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(527), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [425] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DQUOTE,
    ACTIONS(401), 1,
      anon_sym_SQUOTE,
    ACTIONS(1074), 1,
      anon_sym_RBRACE,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1085), 1,
      anon_sym_EQ,
    ACTIONS(1087), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1100), 1,
      sym_number,
    ACTIONS(1110), 1,
      anon_sym_LPAREN,
    STATE(838), 1,
      aux_sym_object_repeat1,
    STATE(1015), 3,
      sym_string,
      sym__property_name,
      sym_computed_property_name,
    ACTIONS(1108), 5,
      anon_sym_async,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [524] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DQUOTE,
    ACTIONS(401), 1,
      anon_sym_SQUOTE,
    ACTIONS(1069), 1,
      anon_sym_STAR,
    ACTIONS(1074), 1,
      anon_sym_RBRACE,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1085), 1,
      anon_sym_EQ,
    ACTIONS(1087), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1100), 1,
      sym_number,
    ACTIONS(1110), 1,
      anon_sym_LPAREN,
    ACTIONS(1113), 1,
      anon_sym_async,
    STATE(838), 1,
      aux_sym_object_repeat1,
    ACTIONS(1108), 2,
      sym_identifier,
      anon_sym_static,
    ACTIONS(1115), 2,
      anon_sym_get,
      anon_sym_set,
    STATE(1015), 3,
      sym_string,
      sym__property_name,
      sym_computed_property_name,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [629] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      anon_sym_finally,
    STATE(234), 1,
      sym_finally_clause,
    ACTIONS(1125), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1127), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 18,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(527), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [770] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      sym__automatic_semicolon,
    ACTIONS(467), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(469), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [840] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      sym__automatic_semicolon,
    ACTIONS(457), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(459), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [910] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__automatic_semicolon,
    ACTIONS(447), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(449), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [980] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1129), 1,
      sym__automatic_semicolon,
    ACTIONS(539), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(541), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1050] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      sym__automatic_semicolon,
    ACTIONS(477), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(479), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1133), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1188] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      sym_identifier,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_function,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    STATE(407), 1,
      sym_arguments,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1145), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1139), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1137), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [1274] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym__automatic_semicolon,
    ACTIONS(529), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(531), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1344] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym__automatic_semicolon,
    ACTIONS(515), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(517), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1153), 18,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1155), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1482] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym__automatic_semicolon,
    ACTIONS(491), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(493), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 18,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(541), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1620] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1157), 1,
      sym__automatic_semicolon,
    ACTIONS(437), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(439), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 18,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(489), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1159), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1161), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1826] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 18,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1165), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1169), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1962] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1173), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 18,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(503), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2098] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__automatic_semicolon,
    ACTIONS(505), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(507), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1177), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1179), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1181), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1183), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1185), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1189), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1193), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1197), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1201), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2637] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1203), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1205), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1209), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1213), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1217), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1219), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1221), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1223), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1225), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1227), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1229), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1231), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1233), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1235), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1237), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1241), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1243), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1245), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1247), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1249), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1251), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1253), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1257), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3575] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1259), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1261), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1263), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1265), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1267), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1269), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3776] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1273), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1275), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1277), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1279), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1281), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1285), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1289), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4111] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      sym_identifier,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_function,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1145), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 17,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [4196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1296), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4263] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1298), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1300), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4330] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1304), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1306), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1308), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1312), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1316), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4598] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1318), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1320), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1324), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1328), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1330), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1332), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1334), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1336), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1340), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5000] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1346), 1,
      anon_sym_else,
    ACTIONS(1342), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1344), 41,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1348), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1350), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5136] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1352), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1354), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5203] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1356), 1,
      sym_identifier,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1362), 1,
      anon_sym_function,
    STATE(535), 1,
      sym_arguments,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1360), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1139), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1137), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5287] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1356), 1,
      sym_identifier,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1362), 1,
      anon_sym_function,
    ACTIONS(1364), 1,
      anon_sym_in,
    ACTIONS(1367), 1,
      anon_sym_of,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1360), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5374] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 1,
      anon_sym_function,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1356), 1,
      sym_identifier,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    ACTIONS(1371), 1,
      anon_sym_COLON,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1360), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5459] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1356), 1,
      sym_identifier,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    ACTIONS(1373), 1,
      anon_sym_COLON,
    ACTIONS(1375), 1,
      anon_sym_function,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1360), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5544] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1356), 1,
      sym_identifier,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1362), 1,
      anon_sym_function,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1360), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5627] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      sym_identifier,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_function,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1377), 1,
      anon_sym_COMMA,
    ACTIONS(1380), 1,
      anon_sym_RPAREN,
    ACTIONS(1383), 1,
      anon_sym_EQ,
    STATE(817), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1145), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1072), 11,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1080), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1385), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1389), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5839] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      sym_identifier,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_function,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1364), 1,
      anon_sym_in,
    ACTIONS(1367), 1,
      anon_sym_of,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1145), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1072), 11,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [5923] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      sym_identifier,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_function,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1393), 1,
      anon_sym_in,
    ACTIONS(1396), 1,
      anon_sym_of,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1145), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1072), 11,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
  [6007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1398), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1404), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1402), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1408), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1406), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1410), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1414), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1420), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1418), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1424), 15,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
      sym_preproc,
    ACTIONS(1422), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6441] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    STATE(407), 1,
      sym_arguments,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1137), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1139), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6514] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1428), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1440), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1442), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6647] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1448), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1450), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6775] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1072), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6843] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1104), 1,
      anon_sym_RBRACE,
    ACTIONS(1452), 1,
      anon_sym_LPAREN,
    ACTIONS(1455), 1,
      anon_sym_EQ,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    STATE(870), 1,
      aux_sym_object_repeat1,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [6919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1391), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1465), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7039] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_RBRACE,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1452), 1,
      anon_sym_LPAREN,
    ACTIONS(1455), 1,
      anon_sym_EQ,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    STATE(838), 1,
      aux_sym_object_repeat1,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7115] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1428), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7183] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 20,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7246] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    STATE(535), 1,
      sym_arguments,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1139), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1137), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7317] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    STATE(540), 1,
      sym_arguments,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1430), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1428), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7388] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    ACTIONS(1471), 1,
      anon_sym_in,
    ACTIONS(1474), 1,
      anon_sym_of,
    ACTIONS(1476), 1,
      anon_sym_EQ,
    STATE(839), 1,
      sym__initializer,
    ACTIONS(1469), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7463] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    STATE(540), 1,
      sym_arguments,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1430), 17,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1428), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7529] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1364), 1,
      anon_sym_in,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    ACTIONS(1478), 1,
      anon_sym_of,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7599] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    ACTIONS(1480), 1,
      anon_sym_in,
    ACTIONS(1483), 1,
      anon_sym_of,
    ACTIONS(1485), 1,
      anon_sym_EQ,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7669] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 17,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1448), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1450), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1440), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1442), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7851] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_COLON,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    ACTIONS(1485), 1,
      anon_sym_EQ,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7919] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    ACTIONS(1485), 1,
      anon_sym_EQ,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 17,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [7985] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 1,
      anon_sym_COLON,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1459), 1,
      anon_sym_EQ_GT,
    ACTIONS(1485), 1,
      anon_sym_EQ,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1465), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [8111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 19,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1391), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [8169] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    ACTIONS(1373), 1,
      anon_sym_COLON,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8237] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_EQ_GT,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1369), 1,
      anon_sym_EQ,
    ACTIONS(1371), 1,
      anon_sym_COLON,
    ACTIONS(1098), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1489), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [8362] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1480), 1,
      anon_sym_in,
    ACTIONS(1483), 1,
      anon_sym_of,
    ACTIONS(1485), 1,
      anon_sym_EQ,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 17,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [8427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1491), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1493), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [8484] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1377), 1,
      anon_sym_COMMA,
    ACTIONS(1380), 1,
      anon_sym_RPAREN,
    ACTIONS(1383), 1,
      anon_sym_EQ,
    STATE(817), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8555] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      anon_sym_EQ,
    ACTIONS(1461), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 18,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [8616] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    ACTIONS(1495), 1,
      anon_sym_COMMA,
    ACTIONS(1498), 1,
      anon_sym_RPAREN,
    ACTIONS(1501), 1,
      anon_sym_EQ,
    STATE(813), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1505), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [8744] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    ACTIONS(1507), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 18,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8810] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1364), 1,
      anon_sym_in,
    ACTIONS(1478), 1,
      anon_sym_of,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8877] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1149), 1,
      anon_sym_EQ_GT,
    ACTIONS(1393), 1,
      anon_sym_in,
    ACTIONS(1510), 1,
      anon_sym_of,
    ACTIONS(1151), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1072), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1080), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8944] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    ACTIONS(1480), 1,
      anon_sym_in,
    ACTIONS(1483), 1,
      anon_sym_of,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [9011] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1436), 1,
      anon_sym_EQ_GT,
    ACTIONS(1471), 1,
      anon_sym_in,
    ACTIONS(1474), 1,
      anon_sym_of,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [9078] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1480), 1,
      anon_sym_in,
    ACTIONS(1483), 1,
      anon_sym_of,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [9140] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_EQ,
    ACTIONS(1471), 1,
      anon_sym_in,
    ACTIONS(1474), 1,
      anon_sym_of,
    ACTIONS(1438), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
    ACTIONS(1446), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1444), 17,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [9202] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(1512), 1,
      sym_identifier,
    ACTIONS(1514), 1,
      anon_sym_STAR,
    ACTIONS(1516), 1,
      anon_sym_LBRACE,
    STATE(895), 1,
      sym_string,
    STATE(904), 1,
      sym_import_clause,
    STATE(1131), 2,
      sym_namespace_import,
      sym_named_imports,
    ACTIONS(1520), 13,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
    ACTIONS(1518), 21,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9269] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1522), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1524), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [9327] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1530), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1556), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1558), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9457] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1562), 2,
      anon_sym_QMARK,
      anon_sym_PIPE,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1560), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_QMARK_QMARK,
  [9533] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1564), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9615] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1566), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9697] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1568), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1570), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1572), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1574), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1576), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9875] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1562), 1,
      anon_sym_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1560), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_QMARK_QMARK,
  [9955] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1578), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10037] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1580), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10119] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1582), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10201] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1584), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10283] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1562), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1560), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10349] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1586), 1,
      anon_sym_EQ,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1428), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10403] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1562), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1560), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10465] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1588), 1,
      anon_sym_EQ,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1428), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1590), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1592), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10567] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(398), 1,
      sym_arguments,
    STATE(418), 1,
      sym_template_string,
    ACTIONS(1428), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10619] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1594), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10701] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1596), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10831] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1598), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1600), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1602), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10961] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1604), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11043] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1606), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1608), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11103] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1606), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1608), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11163] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1444), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 23,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [11217] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1606), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1608), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11277] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1562), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1560), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11337] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_EQ,
    ACTIONS(1610), 1,
      sym__automatic_semicolon,
    ACTIONS(439), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(437), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1614), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11437] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1616), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1618), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1620), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11567] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1562), 8,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1560), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11635] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1562), 3,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1560), 10,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_QMARK_QMARK,
  [11707] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1622), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11789] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1624), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11871] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1626), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11953] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 1,
      anon_sym_EQ_GT,
    ACTIONS(1487), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1489), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12002] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1630), 1,
      sym__automatic_semicolon,
    ACTIONS(541), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12051] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1636), 1,
      sym_regex_flags,
    ACTIONS(1632), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
    ACTIONS(1634), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12100] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1638), 1,
      anon_sym_COMMA,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1640), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12183] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1586), 1,
      anon_sym_EQ,
    ACTIONS(1444), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12232] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1428), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12283] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1588), 1,
      anon_sym_EQ,
    ACTIONS(1444), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12332] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1610), 1,
      sym__automatic_semicolon,
    ACTIONS(439), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(437), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12381] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1642), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1644), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12427] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(418), 1,
      sym_template_string,
    STATE(547), 1,
      sym_arguments,
    ACTIONS(1428), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1430), 23,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1590), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1592), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12523] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12569] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1598), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12649] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(463), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12695] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(453), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12741] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1580), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12821] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1564), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12901] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1604), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12981] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1594), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [13061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1674), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1676), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13107] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1680), 1,
      anon_sym_in,
    ACTIONS(1683), 1,
      anon_sym_of,
    ACTIONS(1685), 1,
      anon_sym_EQ,
    STATE(868), 1,
      sym__initializer,
    ACTIONS(1678), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1444), 12,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13209] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1689), 1,
      anon_sym_in,
    ACTIONS(1692), 1,
      anon_sym_of,
    ACTIONS(1694), 1,
      anon_sym_EQ,
    STATE(867), 1,
      sym__initializer,
    ACTIONS(1687), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1444), 12,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1446), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13265] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1696), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1530), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13311] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1698), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1616), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(535), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(521), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1700), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1702), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13495] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1568), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [13575] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1570), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1572), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13621] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(511), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1614), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13713] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_BQUOTE,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      anon_sym_DOT,
    ACTIONS(1526), 1,
      anon_sym_LBRACK,
    ACTIONS(1534), 1,
      anon_sym_QMARK,
    ACTIONS(1536), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1542), 1,
      anon_sym_AMP,
    ACTIONS(1544), 1,
      anon_sym_PIPE,
    ACTIONS(1548), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1552), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1538), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1546), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1554), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1528), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1540), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1704), 4,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(1532), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1550), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [13793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(497), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13839] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      anon_sym_PIPE,
    ACTIONS(1666), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1670), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1656), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1664), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1672), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1646), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1658), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1582), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1648), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1668), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [13919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1618), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1620), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1706), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1708), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [14011] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1457), 1,
      anon_sym_DOT,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1650), 1,
      anon_sym_LBRACK,
    ACTIONS(1652), 1,
      anon_sym_QMARK,
    ACTIONS(1654), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1660), 1,
      anon_sym_AMP,
    ACTIONS(1662), 1,
      a