// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Buildable, CellArea, CellLayout, CellRenderer, SortType, TreeIter, TreeModel,
    TreeViewColumnSizing, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkTreeViewColumn")]
    pub struct TreeViewColumn(Object<ffi::GtkTreeViewColumn, ffi::GtkTreeViewColumnClass>) @implements Buildable, CellLayout;

    match fn {
        type_ => || ffi::gtk_tree_view_column_get_type(),
    }
}

impl TreeViewColumn {
    pub const NONE: Option<&'static TreeViewColumn> = None;

    #[doc(alias = "gtk_tree_view_column_new")]
    pub fn new() -> TreeViewColumn {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_tree_view_column_new()) }
    }

    #[doc(alias = "gtk_tree_view_column_new_with_area")]
    #[doc(alias = "new_with_area")]
    pub fn with_area(area: &impl IsA<CellArea>) -> TreeViewColumn {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gtk_tree_view_column_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TreeViewColumn`] objects.
    ///
    /// This method returns an instance of [`TreeViewColumnBuilder`](crate::builders::TreeViewColumnBuilder) which can be used to create [`TreeViewColumn`] objects.
    pub fn builder() -> TreeViewColumnBuilder {
        TreeViewColumnBuilder::new()
    }
}

impl Default for TreeViewColumn {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TreeViewColumn`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TreeViewColumnBuilder {
    builder: glib::object::ObjectBuilder<'static, TreeViewColumn>,
}

impl TreeViewColumnBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn alignment(self, alignment: f32) -> Self {
        Self {
            builder: self.builder.property("alignment", alignment),
        }
    }

    pub fn cell_area(self, cell_area: &impl IsA<CellArea>) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-area", cell_area.clone().upcast()),
        }
    }

    pub fn clickable(self, clickable: bool) -> Self {
        Self {
            builder: self.builder.property("clickable", clickable),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn fixed_width(self, fixed_width: i32) -> Self {
        Self {
            builder: self.builder.property("fixed-width", fixed_width),
        }
    }

    pub fn max_width(self, max_width: i32) -> Self {
        Self {
            builder: self.builder.property("max-width", max_width),
        }
    }

    pub fn min_width(self, min_width: i32) -> Self {
        Self {
            builder: self.builder.property("min-width", min_width),
        }
    }

    pub fn reorderable(self, reorderable: bool) -> Self {
        Self {
            builder: self.builder.property("reorderable", reorderable),
        }
    }

    pub fn resizable(self, resizable: bool) -> Self {
        Self {
            builder: self.builder.property("resizable", resizable),
        }
    }

    pub fn sizing(self, sizing: TreeViewColumnSizing) -> Self {
        Self {
            builder: self.builder.property("sizing", sizing),
        }
    }

    pub fn sort_column_id(self, sort_column_id: i32) -> Self {
        Self {
            builder: self.builder.property("sort-column-id", sort_column_id),
        }
    }

    pub fn sort_indicator(self, sort_indicator: bool) -> Self {
        Self {
            builder: self.builder.property("sort-indicator", sort_indicator),
        }
    }

    pub fn sort_order(self, sort_order: SortType) -> Self {
        Self {
            builder: self.builder.property("sort-order", sort_order),
        }
    }

    pub fn spacing(self, spacing: i32) -> Self {
        Self {
            builder: self.builder.property("spacing", spacing),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn widget(self, widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("widget", widget.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TreeViewColumn`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TreeViewColumn {
        self.builder.build()
    }
}

pub trait TreeViewColumnExt: 'static {
    #[doc(alias = "gtk_tree_view_column_add_attribute")]
    fn add_attribute(&self, cell_renderer: &impl IsA<CellRenderer>, attribute: &str, column: i32);

    #[doc(alias = "gtk_tree_view_column_cell_get_position")]
    fn cell_get_position(&self, cell_renderer: &impl IsA<CellRenderer>) -> Option<(i32, i32)>;

    #[doc(alias = "gtk_tree_view_column_cell_get_size")]
    fn cell_get_size(&self, cell_area: Option<&gdk::Rectangle>) -> (i32, i32, i32, i32);

    #[doc(alias = "gtk_tree_view_column_cell_is_visible")]
    fn cell_is_visible(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_cell_set_cell_data")]
    fn cell_set_cell_data(
        &self,
        tree_model: &impl IsA<TreeModel>,
        iter: &TreeIter,
        is_expander: bool,
        is_expanded: bool,
    );

    #[doc(alias = "gtk_tree_view_column_clear")]
    fn clear(&self);

    #[doc(alias = "gtk_tree_view_column_clear_attributes")]
    fn clear_attributes(&self, cell_renderer: &impl IsA<CellRenderer>);

    #[doc(alias = "gtk_tree_view_column_clicked")]
    fn clicked(&self);

    #[doc(alias = "gtk_tree_view_column_focus_cell")]
    fn focus_cell(&self, cell: &impl IsA<CellRenderer>);

    #[doc(alias = "gtk_tree_view_column_get_alignment")]
    #[doc(alias = "get_alignment")]
    fn alignment(&self) -> f32;

    #[doc(alias = "gtk_tree_view_column_get_button")]
    #[doc(alias = "get_button")]
    fn button(&self) -> Option<Widget>;

    #[doc(alias = "gtk_tree_view_column_get_clickable")]
    #[doc(alias = "get_clickable")]
    fn is_clickable(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_get_expand")]
    #[doc(alias = "get_expand")]
    fn expands(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_get_fixed_width")]
    #[doc(alias = "get_fixed_width")]
    fn fixed_width(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_get_max_width")]
    #[doc(alias = "get_max_width")]
    fn max_width(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_get_min_width")]
    #[doc(alias = "get_min_width")]
    fn min_width(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    fn is_reorderable(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_get_resizable")]
    #[doc(alias = "get_resizable")]
    fn is_resizable(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_get_sizing")]
    #[doc(alias = "get_sizing")]
    fn sizing(&self) -> TreeViewColumnSizing;

    #[doc(alias = "gtk_tree_view_column_get_sort_column_id")]
    #[doc(alias = "get_sort_column_id")]
    fn sort_column_id(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_get_sort_indicator")]
    #[doc(alias = "get_sort_indicator")]
    fn is_sort_indicator(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_get_sort_order")]
    #[doc(alias = "get_sort_order")]
    fn sort_order(&self) -> SortType;

    #[doc(alias = "gtk_tree_view_column_get_spacing")]
    #[doc(alias = "get_spacing")]
    fn spacing(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_tree_view_column_get_tree_view")]
    #[doc(alias = "get_tree_view")]
    fn tree_view(&self) -> Option<Widget>;

    #[doc(alias = "gtk_tree_view_column_get_visible")]
    #[doc(alias = "get_visible")]
    fn is_visible(&self) -> bool;

    #[doc(alias = "gtk_tree_view_column_get_widget")]
    #[doc(alias = "get_widget")]
    fn widget(&self) -> Option<Widget>;

    #[doc(alias = "gtk_tree_view_column_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_get_x_offset")]
    #[doc(alias = "get_x_offset")]
    fn x_offset(&self) -> i32;

    #[doc(alias = "gtk_tree_view_column_pack_end")]
    fn pack_end(&self, cell: &impl IsA<CellRenderer>, expand: bool);

    #[doc(alias = "gtk_tree_view_column_pack_start")]
    fn pack_start(&self, cell: &impl IsA<CellRenderer>, expand: bool);

    #[doc(alias = "gtk_tree_view_column_queue_resize")]
    fn queue_resize(&self);

    #[doc(alias = "gtk_tree_view_column_set_alignment")]
    fn set_alignment(&self, xalign: f32);

    //#[doc(alias = "gtk_tree_view_column_set_attributes")]
    //fn set_attributes(&self, cell_renderer: &impl IsA<CellRenderer>, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs);

    #[doc(alias = "gtk_tree_view_column_set_cell_data_func")]
    fn set_cell_data_func(
        &self,
        cell_renderer: &impl IsA<CellRenderer>,
        func: Option<Box_<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
    );

    #[doc(alias = "gtk_tree_view_column_set_clickable")]
    fn set_clickable(&self, clickable: bool);

    #[doc(alias = "gtk_tree_view_column_set_expand")]
    fn set_expand(&self, expand: bool);

    #[doc(alias = "gtk_tree_view_column_set_fixed_width")]
    fn set_fixed_width(&self, fixed_width: i32);

    #[doc(alias = "gtk_tree_view_column_set_max_width")]
    fn set_max_width(&self, max_width: i32);

    #[doc(alias = "gtk_tree_view_column_set_min_width")]
    fn set_min_width(&self, min_width: i32);

    #[doc(alias = "gtk_tree_view_column_set_reorderable")]
    fn set_reorderable(&self, reorderable: bool);

    #[doc(alias = "gtk_tree_view_column_set_resizable")]
    fn set_resizable(&self, resizable: bool);

    #[doc(alias = "gtk_tree_view_column_set_sizing")]
    fn set_sizing(&self, type_: TreeViewColumnSizing);

    #[doc(alias = "gtk_tree_view_column_set_sort_column_id")]
    fn set_sort_column_id(&self, sort_column_id: i32);

    #[doc(alias = "gtk_tree_view_column_set_sort_indicator")]
    fn set_sort_indicator(&self, setting: bool);

    #[doc(alias = "gtk_tree_view_column_set_sort_order")]
    fn set_sort_order(&self, order: SortType);

    #[doc(alias = "gtk_tree_view_column_set_spacing")]
    fn set_spacing(&self, spacing: i32);

    #[doc(alias = "gtk_tree_view_column_set_title")]
    fn set_title(&self, title: &str);

    #[doc(alias = "gtk_tree_view_column_set_visible")]
    fn set_visible(&self, visible: bool);

    #[doc(alias = "gtk_tree_view_column_set_widget")]
    fn set_widget(&self, widget: Option<&impl IsA<Widget>>);

    #[doc(alias = "cell-area")]
    fn cell_area(&self) -> Option<CellArea>;

    #[doc(alias = "clicked")]
    fn connect_clicked<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "alignment")]
    fn connect_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "clickable")]
    fn connect_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "expand")]
    fn connect_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fixed-width")]
    fn connect_fixed_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-width")]
    fn connect_max_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "min-width")]
    fn connect_min_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "reorderable")]
    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "resizable")]
    fn connect_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "sizing")]
    fn connect_sizing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "sort-column-id")]
    fn connect_sort_column_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "sort-indicator")]
    fn connect_sort_indicator_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "sort-order")]
    fn connect_sort_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "spacing")]
    fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "visible")]
    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "widget")]
    fn connect_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "width")]
    fn connect_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "x-offset")]
    fn connect_x_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TreeViewColumn>> TreeViewColumnExt for O {
    fn add_attribute(&self, cell_renderer: &impl IsA<CellRenderer>, attribute: &str, column: i32) {
        unsafe {
            ffi::gtk_tree_view_column_add_attribute(
                self.as_ref().to_glib_none().0,
                cell_renderer.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                column,
            );
        }
    }

    fn cell_get_position(&self, cell_renderer: &impl IsA<CellRenderer>) -> Option<(i32, i32)> {
        unsafe {
            let mut x_offset = mem::MaybeUninit::uninit();
            let mut width = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_column_cell_get_position(
                self.as_ref().to_glib_none().0,
                cell_renderer.as_ref().to_glib_none().0,
                x_offset.as_mut_ptr(),
                width.as_mut_ptr(),
            ));
            if ret {
                Some((x_offset.assume_init(), width.assume_init()))
            } else {
                None
            }
        }
    }

    fn cell_get_size(&self, cell_area: Option<&gdk::Rectangle>) -> (i32, i32, i32, i32) {
        unsafe {
            let mut x_offset = mem::MaybeUninit::uninit();
            let mut y_offset = mem::MaybeUninit::uninit();
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_column_cell_get_size(
                self.as_ref().to_glib_none().0,
                cell_area.to_glib_none().0,
                x_offset.as_mut_ptr(),
                y_offset.as_mut_ptr(),
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (
                x_offset.assume_init(),
                y_offset.assume_init(),
                width.assume_init(),
                height.assume_init(),
            )
        }
    }

    fn cell_is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_cell_is_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cell_set_cell_data(
        &self,
        tree_model: &impl IsA<TreeModel>,
        iter: &TreeIter,
        is_expander: bool,
        is_expanded: bool,
    ) {
        unsafe {
            ffi::gtk_tree_view_column_cell_set_cell_data(
                self.as_ref().to_glib_none().0,
                tree_model.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
                is_expander.into_glib(),
                is_expanded.into_glib(),
            );
        }
    }

    fn clear(&self) {
        unsafe {
            ffi::gtk_tree_view_column_clear(self.as_ref().to_glib_none().0);
        }
    }

    fn clear_attributes(&self, cell_renderer: &impl IsA<CellRenderer>) {
        unsafe {
            ffi::gtk_tree_view_column_clear_attributes(
                self.as_ref().to_glib_none().0,
                cell_renderer.as_ref().to_glib_none().0,
            );
        }
    }

    fn clicked(&self) {
        unsafe {
            ffi::gtk_tree_view_column_clicked(self.as_ref().to_glib_none().0);
        }
    }

    fn focus_cell(&self, cell: &impl IsA<CellRenderer>) {
        unsafe {
            ffi::gtk_tree_view_column_focus_cell(
                self.as_ref().to_glib_none().0,
                cell.as_ref().to_glib_none().0,
            );
        }
    }

    fn alignment(&self) -> f32 {
        unsafe { ffi::gtk_tree_view_column_get_alignment(self.as_ref().to_glib_none().0) }
    }

    fn button(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_column_get_button(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_clickable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_clickable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn expands(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_expand(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn fixed_width(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_fixed_width(self.as_ref().to_glib_none().0) }
    }

    fn max_width(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_max_width(self.as_ref().to_glib_none().0) }
    }

    fn min_width(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_min_width(self.as_ref().to_glib_none().0) }
    }

    fn is_reorderable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_reorderable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_resizable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_resizable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn sizing(&self) -> TreeViewColumnSizing {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_sizing(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn sort_column_id(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_sort_column_id(self.as_ref().to_glib_none().0) }
    }

    fn is_sort_indicator(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_sort_indicator(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn sort_order(&self) -> SortType {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_sort_order(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn spacing(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_spacing(self.as_ref().to_glib_none().0) }
    }

    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_column_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tree_view(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_column_get_tree_view(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_column_get_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_column_get_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn width(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_width(self.as_ref().to_glib_none().0) }
    }

    fn x_offset(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_column_get_x_offset(self.as_ref().to_glib_none().0) }
    }

    fn pack_end(&self, cell: &impl IsA<CellRenderer>, expand: bool) {
        unsafe {
            ffi::gtk_tree_view_column_pack_end(
                self.as_ref().to_glib_none().0,
                cell.as_ref().to_glib_none().0,
                expand.into_glib(),
            );
        }
    }

    fn pack_start(&self, cell: &impl IsA<CellRenderer>, expand: bool) {
        unsafe {
            ffi::gtk_tree_view_column_pack_start(
                self.as_ref().to_glib_none().0,
                cell.as_ref().to_glib_none().0,
                expand.into_glib(),
            );
        }
    }

    fn queue_resize(&self) {
        unsafe {
            ffi::gtk_tree_view_column_queue_resize(self.as_ref().to_glib_none().0);
        }
    }

    fn set_alignment(&self, xalign: f32) {
        unsafe {
            ffi::gtk_tree_view_column_set_alignment(self.as_ref().to_glib_none().0, xalign);
        }
    }

    //fn set_attributes(&self, cell_renderer: &impl IsA<CellRenderer>, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) {
    //    unsafe { TODO: call ffi:gtk_tree_view_column_set_attributes() }
    //}

    fn set_cell_data_func(
        &self,
        cell_renderer: &impl IsA<CellRenderer>,
        func: Option<Box_<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
    ) {
        let func_data: Box_<
            Option<Box_<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
        > = Box_::new(func);
        unsafe extern "C" fn func_func(
            tree_column: *mut ffi::GtkTreeViewColumn,
            cell: *mut ffi::GtkCellRenderer,
            tree_model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            data: glib::ffi::gpointer,
        ) {
            let tree_column = from_glib_borrow(tree_column);
            let cell = from_glib_borrow(cell);
            let tree_model = from_glib_borrow(tree_model);
            let iter = from_glib_borrow(iter);
            let callback: &Option<
                Box_<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>,
            > = &*(data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&tree_column, &cell, &tree_model, &iter)
            } else {
                panic!("cannot get closure...")
            }
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<
                Option<
                    Box_<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>,
                >,
            > = Box_::from_raw(data as *mut _);
        }
        let destroy_call4 = Some(destroy_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
        > = func_data;
        unsafe {
            ffi::gtk_tree_view_column_set_cell_data_func(
                self.as_ref().to_glib_none().0,
                cell_renderer.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    fn set_clickable(&self, clickable: bool) {
        unsafe {
            ffi::gtk_tree_view_column_set_clickable(
                self.as_ref().to_glib_none().0,
                clickable.into_glib(),
            );
        }
    }

    fn set_expand(&self, expand: bool) {
        unsafe {
            ffi::gtk_tree_view_column_set_expand(
                self.as_ref().to_glib_none().0,
                expand.into_glib(),
            );
        }
    }

    fn set_fixed_width(&self, fixed_width: i32) {
        unsafe {
            ffi::gtk_tree_view_column_set_fixed_width(self.as_ref().to_glib_none().0, fixed_width);
        }
    }

    fn set_max_width(&self, max_width: i32) {
        unsafe {
            ffi::gtk_tree_view_column_set_max_width(self.as_ref().to_glib_none().0, max_width);
        }
    }

    fn set_min_width(&self, min_width: i32) {
        unsafe {
            ffi::gtk_tree_view_column_set_min_width(self.as_ref().to_glib_none().0, min_width);
        }
    }

    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_tree_view_column_set_reorderable(
                self.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    fn set_resizable(&self, resizable: bool) {
        unsafe {
            ffi::gtk_tree_view_column_set_resizable(
                self.as_ref().to_glib_none().0,
                resizable.into_glib(),
            );
        }
    }

    fn set_sizing(&self, type_: TreeViewColumnSizing) {
        unsafe {
            ffi::gtk_tree_view_column_set_sizing(self.as_ref().to_glib_none().0, type_.into_glib());
        }
    }

    fn set_sort_column_id(&self, sort_column_id: i32) {
        unsafe {
            ffi::gtk_tree_view_column_set_sort_column_id(
                self.as_ref().to_glib_none().0,
                sort_column_id,
            );
        }
    }

    fn set_sort_indicator(&self, setting: bool) {
        unsafe {
            ffi::gtk_tree_view_column_set_sort_indicator(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_sort_order(&self, order: SortType) {
        unsafe {
            ffi::gtk_tree_view_column_set_sort_order(
                self.as_ref().to_glib_none().0,
                order.into_glib(),
            );
        }
    }

    fn set_spacing(&self, spacing: i32) {
        unsafe {
            ffi::gtk_tree_view_column_set_spacing(self.as_ref().to_glib_none().0, spacing);
        }
    }

    fn set_title(&self, title: &str) {
        unsafe {
            ffi::gtk_tree_view_column_set_title(
                self.as_ref().to_glib_none().0,
                title.to_glib_none().0,
            );
        }
    }

    fn set_visible(&self, visible: bool) {
        unsafe {
            ffi::gtk_tree_view_column_set_visible(
                self.as_ref().to_glib_none().0,
                visible.into_glib(),
            );
        }
    }

    fn set_widget(&self, widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_tree_view_column_set_widget(
                self.as_ref().to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn cell_area(&self) -> Option<CellArea> {
        glib::ObjectExt::property(self.as_ref(), "cell-area")
    }

    fn connect_clicked<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn clicked_trampoline<P: IsA<TreeViewColumn>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeViewColumn,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"clicked\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    clicked_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_alignment_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::alignment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_alignment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_clickable_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::clickable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_clickable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expand_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_expand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fixed_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fixed_width_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fixed-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fixed_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_min_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_width_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resizable_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resizable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_resizable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_sizing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sizing_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sizing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sizing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_sort_column_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_column_id_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-column-id\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sort_column_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_sort_indicator_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_indicator_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-indicator\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sort_indicator_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_sort_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_order_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-order\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sort_order_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_widget_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_x_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_x_offset_trampoline<
            P: IsA<TreeViewColumn>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeViewColumn,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeViewColumn::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::x-offset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_x_offset_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TreeViewColumn {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TreeViewColumn")
    }
}
