#Ruby Fog Bindings Examples for use with HP Cloud Services

This section includes code examples for working with Ruby Fog bindings and HP Cloud. HP Cloud recently updated their service to version 13.5, so make sure you use the HP Cloud Compute 13.5 examples, HP Cloud Block Storage 13.5, and the HP Cloud Networking examples only with the the latest version. The CDN and object storage examples work in both 12.12 and 13.5.

Choose what you want to work with:

##Version 12.12 Extensions to Ruby Fog Bindings

These examples currently supports HP Cloud Compute, HP Cloud Object Storage, HP Cloud CDN, and HP Cloud Block Storage. Support for other services will be added as they become available.

* [Installation Instructions](https://github.com/fog/fog/blob/master/lib/fog/hp/docs/install.md)
* [Connecting to the Service](https://github.com/fog/fog/blob/master/lib/fog/hp/docs/connect.md)
* [Compute Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/compute.md)
* [Object Storage Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/object_storage.md)
* [CDN Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/cdn.md)
* [Block Storage Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/block_storage.md)

##Version 13.5 Extensions to Ruby Fog Bindings

For the release of HP Cloud v13.5, the HP Cloud extensions added support for
HP Cloud Networking and HP Cloud Compute V2 and HP Cloud Block Storage V2 examples. All other examples above are compatible with v13.5.

* [Compute v2 Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/compute_v2.md)
* [Block Storage v2 Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/block_storage_v2.md)
* [Networking Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/networking.md)
* Load Balancer Examples (coming soon)
* DNS Examples (coming soon)

---------
[Documentation Home](https://github.com/fog/fog/blob/master/lib/fog/hp/README.md) | [Examples](https://github.com/fog/fog/blob/master/lib/fog/hp/examples/getting_started_examples.md)
