# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::MediaServices
  #
  # Media Services resource management APIs.
  #
  class MediaServiceOperations
    include Azure::ARM::MediaServices::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the MediaServiceOperations class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [MediaServicesManagementClient] reference to the MediaServicesManagementClient
    attr_reader :client

    #
    # Check whether the Media Service resource name is available. The name must be
    # globally unique.
    #
    # @param check_name_availability_input [CheckNameAvailabilityInput] Properties
    # needed to check the availability of a name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CheckNameAvailabilityOutput] operation results.
    #
    def check_name_availability(check_name_availability_input, custom_headers = nil)
      response = check_name_availability_async(check_name_availability_input, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Check whether the Media Service resource name is available. The name must be
    # globally unique.
    #
    # @param check_name_availability_input [CheckNameAvailabilityInput] Properties
    # needed to check the availability of a name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_name_availability_with_http_info(check_name_availability_input, custom_headers = nil)
      check_name_availability_async(check_name_availability_input, custom_headers).value!
    end

    #
    # Check whether the Media Service resource name is available. The name must be
    # globally unique.
    #
    # @param check_name_availability_input [CheckNameAvailabilityInput] Properties
    # needed to check the availability of a name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_name_availability_async(check_name_availability_input, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'check_name_availability_input is nil' if check_name_availability_input.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CheckNameAvailabilityInput.mapper()
      request_content = @client.serialize(request_mapper,  check_name_availability_input, 'check_name_availability_input')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.Media/CheckNameAvailability'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CheckNameAvailabilityOutput.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all of the Media Services in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MediaServiceCollection] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all of the Media Services in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # List all of the Media Services in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MediaServiceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MediaService] operation results.
    #
    def get(resource_group_name, media_service_name, custom_headers = nil)
      response = get_async(resource_group_name, media_service_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, media_service_name, custom_headers = nil)
      get_async(resource_group_name, media_service_name, custom_headers).value!
    end

    #
    # Get a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, media_service_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MediaService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param media_service [MediaService] Media Service properties needed for
    # creation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MediaService] operation results.
    #
    def create(resource_group_name, media_service_name, media_service, custom_headers = nil)
      response = create_async(resource_group_name, media_service_name, media_service, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param media_service [MediaService] Media Service properties needed for
    # creation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_with_http_info(resource_group_name, media_service_name, media_service, custom_headers = nil)
      create_async(resource_group_name, media_service_name, media_service, custom_headers).value!
    end

    #
    # Create a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param media_service [MediaService] Media Service properties needed for
    # creation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_async(resource_group_name, media_service_name, media_service, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?
      fail ArgumentError, 'media_service is nil' if media_service.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = MediaService.mapper()
      request_content = @client.serialize(request_mapper,  media_service, 'media_service')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MediaService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MediaService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, media_service_name, custom_headers = nil)
      response = delete_async(resource_group_name, media_service_name, custom_headers).value!
      nil
    end

    #
    # Delete a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, media_service_name, custom_headers = nil)
      delete_async(resource_group_name, media_service_name, custom_headers).value!
    end

    #
    # Delete a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, media_service_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Update a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param media_service [MediaService] Media Service properties needed for
    # update.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MediaService] operation results.
    #
    def update(resource_group_name, media_service_name, media_service, custom_headers = nil)
      response = update_async(resource_group_name, media_service_name, media_service, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param media_service [MediaService] Media Service properties needed for
    # update.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, media_service_name, media_service, custom_headers = nil)
      update_async(resource_group_name, media_service_name, media_service, custom_headers).value!
    end

    #
    # Update a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param media_service [MediaService] Media Service properties needed for
    # update.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, media_service_name, media_service, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?
      fail ArgumentError, 'media_service is nil' if media_service.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = MediaService.mapper()
      request_content = @client.serialize(request_mapper,  media_service, 'media_service')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MediaService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Regenerate the key for a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param regenerate_key_input [RegenerateKeyInput] Properties needed to
    # regenerate the Media Service key.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RegenerateKeyOutput] operation results.
    #
    def regenerate_key(resource_group_name, media_service_name, regenerate_key_input, custom_headers = nil)
      response = regenerate_key_async(resource_group_name, media_service_name, regenerate_key_input, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Regenerate the key for a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param regenerate_key_input [RegenerateKeyInput] Properties needed to
    # regenerate the Media Service key.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def regenerate_key_with_http_info(resource_group_name, media_service_name, regenerate_key_input, custom_headers = nil)
      regenerate_key_async(resource_group_name, media_service_name, regenerate_key_input, custom_headers).value!
    end

    #
    # Regenerate the key for a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param regenerate_key_input [RegenerateKeyInput] Properties needed to
    # regenerate the Media Service key.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def regenerate_key_async(resource_group_name, media_service_name, regenerate_key_input, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?
      fail ArgumentError, 'regenerate_key_input is nil' if regenerate_key_input.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RegenerateKeyInput.mapper()
      request_content = @client.serialize(request_mapper,  regenerate_key_input, 'regenerate_key_input')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/regenerateKey'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RegenerateKeyOutput.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List the keys for a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServiceKeys] operation results.
    #
    def list_keys(resource_group_name, media_service_name, custom_headers = nil)
      response = list_keys_async(resource_group_name, media_service_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List the keys for a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_with_http_info(resource_group_name, media_service_name, custom_headers = nil)
      list_keys_async(resource_group_name, media_service_name, custom_headers).value!
    end

    #
    # List the keys for a Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_async(resource_group_name, media_service_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServiceKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Synchronize the keys for a storage account to the Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param sync_storage_keys_input [SyncStorageKeysInput] Properties needed to
    # sycnronize the keys for a storage account to the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MediaService] operation results.
    #
    def sync_storage_keys(resource_group_name, media_service_name, sync_storage_keys_input, custom_headers = nil)
      response = sync_storage_keys_async(resource_group_name, media_service_name, sync_storage_keys_input, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Synchronize the keys for a storage account to the Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param sync_storage_keys_input [SyncStorageKeysInput] Properties needed to
    # sycnronize the keys for a storage account to the Media Service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_storage_keys_with_http_info(resource_group_name, media_service_name, sync_storage_keys_input, custom_headers = nil)
      sync_storage_keys_async(resource_group_name, media_service_name, sync_storage_keys_input, custom_headers).value!
    end

    #
    # Synchronize the keys for a storage account to the Media Service.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param media_service_name [String] Name of the Media Service.
    # @param sync_storage_keys_input [SyncStorageKeysInput] Properties needed to
    # sycnronize the keys for a storage account to the Media Service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_storage_keys_async(resource_group_name, media_service_name, sync_storage_keys_input, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'media_service_name is nil' if media_service_name.nil?
      fail ArgumentError, 'sync_storage_keys_input is nil' if sync_storage_keys_input.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SyncStorageKeysInput.mapper()
      request_content = @client.serialize(request_mapper,  sync_storage_keys_input, 'sync_storage_keys_input')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/syncStorageKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'mediaServiceName' => media_service_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MediaService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
