% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na}
\alias{replace_na}
\title{Replace NA with specific values}
\usage{
replace_na(x, ..., value, na.label = NULL, tagged.na = NULL)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{value}{Value that will replace the \code{\link{NA}}'s.}

\item{na.label}{Optional character vector, used to label the the former NA-value
(i.e. adding a \code{labels} attribute for \code{value} to \code{x}).}

\item{tagged.na}{Optional single character, specifies a \code{\link[haven]{tagged_na}} value
that will be replaced by \code{value}. Herewith it is possible
to replace only specific \code{NA} values of \code{x}.}
}
\value{
\code{x}, where \code{NA}'s are replaced with \code{value}. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          with replaced NA's for variables specified in \code{...};
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
This function replaces (tagged) NA's of a variable, data frame
               or list of variables with \code{value}.
}
\details{
While regular \code{NA} values can only be \emph{completely} replaced with
           a single value, \code{\link[haven]{tagged_na}} allows to differentiate
           between different qualitative values of \code{NA}s.
           Tagged \code{NA}s work exactly like regular R missing values
           except that they store one additional byte of information: a tag,
           which is usually a letter ("a" to "z") or character number ("0" to "9").
           Therewith it is possible to replace only specific NA values, while
           other NA values are preserved.
}
\note{
Value and variable label attributes are preserved.
}
\examples{
library(sjlabelled)
data(efc)
table(efc$e42dep, useNA = "always")
table(replace_na(efc$e42dep, value = 99), useNA = "always")

# the original labels
get_labels(replace_na(efc$e42dep, value = 99))
# NA becomes "99", and is labelled as "former NA"
get_labels(
  replace_na(efc$e42dep, value = 99, na.label = "former NA"),
  values = "p"
)

dummy <- data.frame(
  v1 = efc$c82cop1,
  v2 = efc$c83cop2,
  v3 = efc$c84cop3
)
# show original distribution
lapply(dummy, table, useNA = "always")
# show variables, NA's replaced with 99
lapply(replace_na(dummy, v2, v3, value = 99), table, useNA = "always")

library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current NA values
x
get_na(x)

# replace only the NA, which is tagged as NA(c)
replace_na(x, value = 2, tagged.na = "c")
get_na(replace_na(x, value = 2, tagged.na = "c"))

table(x)
table(replace_na(x, value = 2, tagged.na = "c"))

# tagged NA also works for non-labelled class
# init vector
x <- c(1, 2, 3, 4)
# set values 2 and 3 as tagged NA
x <- set_na(x, na = c(2, 3), as.tag = TRUE)
# see result
x
# now replace only NA tagged with 2 with value 5
replace_na(x, value = 5, tagged.na = "2")

}
\seealso{
\code{\link{set_na}} for setting \code{NA} values, \code{\link{rec}}
           for general recoding of variables and \code{\link{recode_to}}
           for re-shifting value ranges.
}
