% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber.R
\name{Plumber}
\alias{Plumber}
\title{Package Plumber Router}
\description{
Package Plumber Router

Package Plumber Router
}
\details{
Routers are the core request handler in \pkg{plumber}. A router is responsible for
taking an incoming request, submitting it through the appropriate filters and
eventually to a corresponding endpoint, if one is found.

See the \href{https://www.rplumber.io/articles/programmatic-usage.html}{Programmatic Usage} article for additional
details on the methods available on this object.
}
\examples{

## ------------------------------------------------
## Method `Plumber$mount`
## ------------------------------------------------

\dontrun{
root <- pr()

users <- Plumber$new("users.R")
root$mount("/users", users)

products <- Plumber$new("products.R")
root$mount("/products", products)
}

## ------------------------------------------------
## Method `Plumber$registerHook`
## ------------------------------------------------

\dontrun{
pr <- pr()
pr$registerHook("preroute", function(req){
  cat("Routing a request for", req$PATH_INFO, "...\n")
})
pr$registerHooks(list(
  preserialize=function(req, value){
    print("About to serialize this value:")
    print(value)

    # Must return the value since we took one in. Here we're not choosing
    # to mutate it, but we could.
    value
  },
  postserialize=function(res){
    print("We serialized the value as:")
    print(res$body)
  }
))

pr$handle("GET", "/", function(){ 123 })
}

## ------------------------------------------------
## Method `Plumber$handle`
## ------------------------------------------------

\dontrun{
pr <- pr()
pr$handle("GET", "/", function(){
  "<html><h1>Programmatic Plumber!</h1></html>"
}, serializer=plumber::serializer_html())
}

## ------------------------------------------------
## Method `Plumber$setSerializer`
## ------------------------------------------------

\dontrun{
pr <- pr()
pr$setSerializer(serializer_unboxed_json())
}

## ------------------------------------------------
## Method `Plumber$set404Handler`
## ------------------------------------------------

\dontrun{
pr <- pr()
pr$set404Handler(function(req, res) {cat(req$PATH_INFO)})
}

## ------------------------------------------------
## Method `Plumber$setErrorHandler`
## ------------------------------------------------

\dontrun{
pr <- pr()
pr$setErrorHandler(function(req, res, err) {
  message("Found error: ")
  str(err)
})
}
}
\seealso{
\code{\link[=pr]{pr()}},
\code{\link[=pr_run]{pr_run()}},
\code{\link[=pr_get]{pr_get()}}, \code{\link[=pr_post]{pr_post()}},
\code{\link[=pr_mount]{pr_mount()}},
\code{\link[=pr_hook]{pr_hook()}}, \code{\link[=pr_hooks]{pr_hooks()}}, \code{\link[=pr_cookie]{pr_cookie()}},
\code{\link[=pr_filter]{pr_filter()}},
\code{\link[=pr_set_api_spec]{pr_set_api_spec()}}, \code{\link[=pr_set_docs]{pr_set_docs()}},
\code{\link[=pr_set_serializer]{pr_set_serializer()}}, \code{\link[=pr_set_parsers]{pr_set_parsers()}},
\code{\link[=pr_set_404]{pr_set_404()}}, \code{\link[=pr_set_error]{pr_set_error()}},
\code{\link[=pr_set_debug]{pr_set_debug()}},
\code{\link[=pr_set_docs_callback]{pr_set_docs_callback()}}
}
\section{Super class}{
\code{plumber::Hookable} -> \code{Plumber}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{flags}}{For internal use only}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{endpoints}}{Plumber router endpoints read-only}

\item{\code{filters}}{Plumber router filters read-only}

\item{\code{mounts}}{Plumber router mounts read-only}

\item{\code{environment}}{Plumber router environment read-only}

\item{\code{routes}}{Plumber router routes read-only}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Plumber-new}{\code{Plumber$new()}}
\item \href{#method-Plumber-run}{\code{Plumber$run()}}
\item \href{#method-Plumber-mount}{\code{Plumber$mount()}}
\item \href{#method-Plumber-unmount}{\code{Plumber$unmount()}}
\item \href{#method-Plumber-registerHook}{\code{Plumber$registerHook()}}
\item \href{#method-Plumber-handle}{\code{Plumber$handle()}}
\item \href{#method-Plumber-removeHandle}{\code{Plumber$removeHandle()}}
\item \href{#method-Plumber-print}{\code{Plumber$print()}}
\item \href{#method-Plumber-serve}{\code{Plumber$serve()}}
\item \href{#method-Plumber-route}{\code{Plumber$route()}}
\item \href{#method-Plumber-call}{\code{Plumber$call()}}
\item \href{#method-Plumber-onHeaders}{\code{Plumber$onHeaders()}}
\item \href{#method-Plumber-onWSOpen}{\code{Plumber$onWSOpen()}}
\item \href{#method-Plumber-setSerializer}{\code{Plumber$setSerializer()}}
\item \href{#method-Plumber-setParsers}{\code{Plumber$setParsers()}}
\item \href{#method-Plumber-set404Handler}{\code{Plumber$set404Handler()}}
\item \href{#method-Plumber-setErrorHandler}{\code{Plumber$setErrorHandler()}}
\item \href{#method-Plumber-setDocs}{\code{Plumber$setDocs()}}
\item \href{#method-Plumber-setDocsCallback}{\code{Plumber$setDocsCallback()}}
\item \href{#method-Plumber-setDebug}{\code{Plumber$setDebug()}}
\item \href{#method-Plumber-getDebug}{\code{Plumber$getDebug()}}
\item \href{#method-Plumber-filter}{\code{Plumber$filter()}}
\item \href{#method-Plumber-setApiSpec}{\code{Plumber$setApiSpec()}}
\item \href{#method-Plumber-getApiSpec}{\code{Plumber$getApiSpec()}}
\item \href{#method-Plumber-addEndpoint}{\code{Plumber$addEndpoint()}}
\item \href{#method-Plumber-addAssets}{\code{Plumber$addAssets()}}
\item \href{#method-Plumber-addFilter}{\code{Plumber$addFilter()}}
\item \href{#method-Plumber-addGlobalProcessor}{\code{Plumber$addGlobalProcessor()}}
\item \href{#method-Plumber-openAPIFile}{\code{Plumber$openAPIFile()}}
\item \href{#method-Plumber-swaggerFile}{\code{Plumber$swaggerFile()}}
\item \href{#method-Plumber-clone}{\code{Plumber$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Hookable" data-id="registerHooks"><a href='../../plumber/html/Hookable.html#method-Hookable-registerHooks'><code>plumber::Hookable$registerHooks()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-new"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Plumber} router

See also \code{\link[=plumb]{plumb()}}, \code{\link[=pr]{pr()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$new(file = NULL, filters = defaultPlumberFilters, envir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{path to file to plumb}

\item{\code{filters}}{a list of Plumber filters}

\item{\code{envir}}{an environment to be used as the enclosure for the routers execution}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Plumber} router
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-run"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-run}{}}}
\subsection{Method \code{run()}}{
Start a server using \code{Plumber} object.

See also: \code{\link[=pr_run]{pr_run()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$run(
  host = "127.0.0.1",
  port = getOption("plumber.port", NULL),
  swagger = deprecated(),
  debug = missing_arg(),
  swaggerCallback = missing_arg(),
  ...,
  docs = missing_arg(),
  quiet = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{a string that is a valid IPv4 or IPv6 address that is owned by
this server, which the application will listen on. "0.0.0.0" represents
all IPv4 addresses and "::/0" represents all IPv6 addresses.}

\item{\code{port}}{a number or integer that indicates the server port that should
be listened on. Note that on most Unix-like systems including Linux and
Mac OS X, port numbers smaller than 1025 require root privileges.

This value does not need to be explicitly assigned. To explicitly set it, see \code{\link[=options_plumber]{options_plumber()}}.}

\item{\code{swagger}}{Deprecated. Please use \code{docs} instead. See \verb{$setDocs(docs)} or \verb{$setApiSpec()} for more customization.}

\item{\code{debug}}{If \code{TRUE}, it will provide more insight into your API errors. Using this value will only last for the duration of the run. If a \verb{$setDebug()} has not been called, \code{debug} will default to \code{interactive()} at \verb{$run()} time. See \verb{$setDebug()} for more details.}

\item{\code{swaggerCallback}}{An optional single-argument function that is
called back with the URL to an OpenAPI user interface when one becomes
ready. If missing, defaults to information previously set with \verb{$setDocsCallback()}.
This value will only be used while running the router.}

\item{\code{...}}{Should be empty.}

\item{\code{docs}}{Visual documentation value to use while running the API.
This value will only be used while running the router.
If missing, defaults to information previously set with \code{setDocs()}.
For more customization, see \verb{$setDocs()} or \code{\link[=pr_set_docs]{pr_set_docs()}} for examples.}

\item{\code{quiet}}{If \code{TRUE}, don't print routine startup messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-mount"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-mount}{}}}
\subsection{Method \code{mount()}}{
Mount a Plumber router

Plumber routers can be “nested” by mounting one into another
using the \code{mount()} method. This allows you to compartmentalize your API
by paths which is a great technique for decomposing large APIs into smaller files.

See also: \code{\link[=pr_mount]{pr_mount()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$mount(path, router)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{a character string. Where to mount router.}

\item{\code{router}}{a Plumber router. Router to be mounted.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
root <- pr()

users <- Plumber$new("users.R")
root$mount("/users", users)

products <- Plumber$new("products.R")
root$mount("/products", products)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-unmount"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-unmount}{}}}
\subsection{Method \code{unmount()}}{
Unmount a Plumber router
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$unmount(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{a character string. Where to unmount router.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-registerHook"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-registerHook}{}}}
\subsection{Method \code{registerHook()}}{
Register a hook

Plumber routers support the notion of "hooks" that can be registered
to execute some code at a particular point in the lifecycle of a request.
Plumber routers currently support four hooks:
\enumerate{
\item \code{preroute(data, req, res)}
\item \code{postroute(data, req, res, value)}
\item \code{preserialize(data, req, res, value)}
\item \code{postserialize(data, req, res, value)}
}
In all of the above you have access to a disposable environment in the \code{data}
parameter that is created as a temporary data store for each request. Hooks
can store temporary data in these hooks that can be reused by other hooks
processing this same request.

One feature when defining hooks in Plumber routers is the ability to modify
the returned value. The convention for such hooks is: any function that accepts
a parameter named \code{value} is expected to return the new value. This could
be an unmodified version of the value that was passed in, or it could be a
mutated value. But in either case, if your hook accepts a parameter
named \code{value}, whatever your hook returns will be used as the new value
for the response.

You can add hooks using the \code{registerHook} method, or you can add multiple
hooks at once using the \code{registerHooks} method which takes a name list in
which the names are the names of the hooks, and the values are the
handlers themselves.

See also: \code{\link[=pr_hook]{pr_hook()}}, \code{\link[=pr_hooks]{pr_hooks()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$registerHook(
  stage = c("preroute", "postroute", "preserialize", "postserialize", "exit"),
  handler
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stage}}{a character string. Point in the lifecycle of a request.}

\item{\code{handler}}{a hook function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pr <- pr()
pr$registerHook("preroute", function(req){
  cat("Routing a request for", req$PATH_INFO, "...\n")
})
pr$registerHooks(list(
  preserialize=function(req, value){
    print("About to serialize this value:")
    print(value)

    # Must return the value since we took one in. Here we're not choosing
    # to mutate it, but we could.
    value
  },
  postserialize=function(res){
    print("We serialized the value as:")
    print(res$body)
  }
))

pr$handle("GET", "/", function(){ 123 })
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-handle"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-handle}{}}}
\subsection{Method \code{handle()}}{
Define endpoints

The “handler” functions that you define in these handle calls
are identical to the code you would have defined in your plumber.R file
if you were using annotations to define your API. The handle() method
takes additional arguments that allow you to control nuanced behavior
of the endpoint like which filter it might preempt or which serializer
it should use.

See also: \code{\link[=pr_handle]{pr_handle()}}, \code{\link[=pr_get]{pr_get()}}, \code{\link[=pr_post]{pr_post()}}, \code{\link[=pr_put]{pr_put()}}, \code{\link[=pr_delete]{pr_delete()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$handle(
  methods,
  path,
  handler,
  preempt,
  serializer,
  parsers,
  endpoint,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{methods}}{a character string. http method.}

\item{\code{path}}{a character string. Api endpoints}

\item{\code{handler}}{a handler function.}

\item{\code{preempt}}{a preempt function.}

\item{\code{serializer}}{a serializer function.}

\item{\code{parsers}}{a named list of parsers.}

\item{\code{endpoint}}{a \code{PlumberEndpoint} object.}

\item{\code{...}}{additional arguments for \link{PlumberEndpoint} \code{new} method (namely \code{lines}, \code{params}, \code{comments}, \code{responses} and \code{tags}. Excludes \code{envir}).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pr <- pr()
pr$handle("GET", "/", function(){
  "<html><h1>Programmatic Plumber!</h1></html>"
}, serializer=plumber::serializer_html())
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-removeHandle"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-removeHandle}{}}}
\subsection{Method \code{removeHandle()}}{
Remove endpoints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$removeHandle(methods, path, preempt = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{methods}}{a character string. http method.}

\item{\code{path}}{a character string. Api endpoints}

\item{\code{preempt}}{a preempt function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-print"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-print}{}}}
\subsection{Method \code{print()}}{
Print representation of plumber router.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$print(prefix = "", topLevel = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{a character string. Prefix to append to representation.}

\item{\code{topLevel}}{a logical value. When method executed on top level
router, set to \code{TRUE}.}

\item{\code{...}}{additional arguments for recursive calls}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A terminal friendly representation of a plumber router.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-serve"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-serve}{}}}
\subsection{Method \code{serve()}}{
Serve a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$serve(req, res)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{request object}

\item{\code{res}}{response object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-route"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-route}{}}}
\subsection{Method \code{route()}}{
Route a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$route(req, res)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{request object}

\item{\code{res}}{response object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-call"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-call}{}}}
\subsection{Method \code{call()}}{
\pkg{httpuv} interface call function. (Required for \pkg{httpuv})
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$call(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{request object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-onHeaders"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-onHeaders}{}}}
\subsection{Method \code{onHeaders()}}{
httpuv interface onHeaders function. (Required for \pkg{httpuv})
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$onHeaders(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{request object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-onWSOpen"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-onWSOpen}{}}}
\subsection{Method \code{onWSOpen()}}{
httpuv interface onWSOpen function. (Required for \pkg{httpuv})
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$onWSOpen(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{WebSocket object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setSerializer"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setSerializer}{}}}
\subsection{Method \code{setSerializer()}}{
Sets the default serializer of the router.

See also: \code{\link[=pr_set_serializer]{pr_set_serializer()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setSerializer(serializer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serializer}}{a serializer function}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pr <- pr()
pr$setSerializer(serializer_unboxed_json())
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setParsers"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setParsers}{}}}
\subsection{Method \code{setParsers()}}{
Sets the default parsers of the router. Initialized to \code{c("json", "form", "text", "octet", "multi")}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setParsers(parsers)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parsers}}{Can be one of:
\itemize{
\item A \code{NULL} value
\item A character vector of parser names
\item A named \code{list()} whose keys are parser names names and values are arguments to be applied with \code{\link[=do.call]{do.call()}}
\item A \code{TRUE} value, which will default to combining all parsers. This is great for seeing what is possible, but not great for security purposes
}

If the parser name \code{"all"} is found in any character value or list name, all remaining parsers will be added.
When using a list, parser information already defined will maintain their existing argument values.  All remaining parsers will use their default arguments.

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# provide a character string
parsers = "json"

# provide a named list with no arguments
parsers = list(json = list())

# provide a named list with arguments; include `rds`
parsers = list(json = list(simplifyVector = FALSE), rds = list())

# default plumber parsers
parsers = c("json", "form", "text", "octet", "multi")
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-set404Handler"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-set404Handler}{}}}
\subsection{Method \code{set404Handler()}}{
Sets the handler that gets called if an
incoming request can’t be served by any filter, endpoint, or sub-router.

See also: \code{\link[=pr_set_404]{pr_set_404()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$set404Handler(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{a handler function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pr <- pr()
pr$set404Handler(function(req, res) {cat(req$PATH_INFO)})
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setErrorHandler"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setErrorHandler}{}}}
\subsection{Method \code{setErrorHandler()}}{
Sets the error handler which gets invoked if any filter or
endpoint generates an error.

See also: \code{\link[=pr_set_404]{pr_set_404()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setErrorHandler(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{a handler function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pr <- pr()
pr$setErrorHandler(function(req, res, err) {
  message("Found error: ")
  str(err)
})
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setDocs"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setDocs}{}}}
\subsection{Method \code{setDocs()}}{
Set visual documentation to use for API

See also: \code{\link[=pr_set_docs]{pr_set_docs()}}, \code{\link[=register_docs]{register_docs()}}, \code{\link[=registered_docs]{registered_docs()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setDocs(docs = getOption("plumber.docs", TRUE), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{docs}}{a character value or a logical value. See \code{\link[=pr_set_docs]{pr_set_docs()}} for examples.
If using \code{\link[=options_plumber]{options_plumber()}}, the value must be set before initializing your Plumber router.}

\item{\code{...}}{Arguments for the visual documentation. See each visual documentation package for further details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setDocsCallback"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setDocsCallback}{}}}
\subsection{Method \code{setDocsCallback()}}{
Set a callback to notify where the API's visual documentation is located.

When set, it will be called with a character string corresponding
to the API docs url. This allows RStudio to locate visual documentation.

If using \code{\link[=options_plumber]{options_plumber()}}, the value must be set before initializing your Plumber router.

See also: \code{\link[=pr_set_docs_callback]{pr_set_docs_callback()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setDocsCallback(callback = getOption("plumber.docs.callback", NULL))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback}}{a callback function for taking action on the docs url. (Also accepts \code{NULL} values to disable the \code{callback}.)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setDebug"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setDebug}{}}}
\subsection{Method \code{setDebug()}}{
Set debug value to include error messages.

See also: \verb{$getDebug()} and \code{\link[=pr_set_debug]{pr_set_debug()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setDebug(debug = interactive())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{debug}}{\code{TRUE} provides more insight into your API errors.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-getDebug"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-getDebug}{}}}
\subsection{Method \code{getDebug()}}{
Retrieve the \code{debug} value. If it has never been set, the result of \code{interactive()} will be used.

See also: \verb{$getDebug()} and \code{\link[=pr_set_debug]{pr_set_debug()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$getDebug()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-filter"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-filter}{}}}
\subsection{Method \code{filter()}}{
Add a filter to plumber router

See also: \code{\link[=pr_filter]{pr_filter()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$filter(name, expr, serializer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{a character string. Name of filter}

\item{\code{expr}}{an expr that resolve to a filter function or a filter function}

\item{\code{serializer}}{a serializer function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-setApiSpec"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-setApiSpec}{}}}
\subsection{Method \code{setApiSpec()}}{
Allows to modify router autogenerated OpenAPI Specification

Note, the returned value will be sent through \code{\link[=serializer_unboxed_json]{serializer_unboxed_json()}} which will turn all length 1 vectors into atomic values.
To force a vector to serialize to an array of size 1, be sure to call \code{\link[=as.list]{as.list()}} on your value. \code{list()} objects are always serialized to an array value.

See also: \code{\link[=pr_set_api_spec]{pr_set_api_spec()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$setApiSpec(api = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api}}{This can be
\itemize{
\item an OpenAPI Specification formatted list object
\item a function that accepts the OpenAPI Specification autogenerated by \code{plumber} and returns a OpenAPI Specification formatted list object.
\item a path to an OpenAPI Specification
}

The value returned will not be validated for OAS compatibility.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-getApiSpec"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-getApiSpec}{}}}
\subsection{Method \code{getApiSpec()}}{
Retrieve OpenAPI file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$getApiSpec()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-addEndpoint"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-addEndpoint}{}}}
\subsection{Method \code{addEndpoint()}}{
addEndpoint has been deprecated in v0.4.0 and will be removed in a coming release. Please use \code{handle()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$addEndpoint(
  verbs,
  path,
  expr,
  serializer,
  processors,
  preempt = NULL,
  params = NULL,
  comments
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbs}}{verbs}

\item{\code{path}}{path}

\item{\code{expr}}{expr}

\item{\code{serializer}}{serializer}

\item{\code{processors}}{processors}

\item{\code{preempt}}{preempt}

\item{\code{params}}{params}

\item{\code{comments}}{comments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-addAssets"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-addAssets}{}}}
\subsection{Method \code{addAssets()}}{
addAssets has been deprecated in v0.4.0 and will be removed in a coming release. Please use \code{mount} and \code{PlumberStatic$new()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$addAssets(dir, path = "/public", options = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{dir}

\item{\code{path}}{path}

\item{\code{options}}{options}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-addFilter"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-addFilter}{}}}
\subsection{Method \code{addFilter()}}{
\verb{$addFilter()} has been deprecated in v0.4.0 and will be removed in a coming release. Please use \verb{$filter()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$addFilter(name, expr, serializer, processors)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{expr}}{expr}

\item{\code{serializer}}{serializer}

\item{\code{processors}}{processors}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-addGlobalProcessor"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-addGlobalProcessor}{}}}
\subsection{Method \code{addGlobalProcessor()}}{
\verb{$addGlobalProcessor()} has been deprecated in v0.4.0 and will be removed in a coming release. Please use \verb{$registerHook}(s) instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$addGlobalProcessor(proc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{proc}}{proc}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-openAPIFile"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-openAPIFile}{}}}
\subsection{Method \code{openAPIFile()}}{
Deprecated. Retrieve OpenAPI file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$openAPIFile()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-swaggerFile"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-swaggerFile}{}}}
\subsection{Method \code{swaggerFile()}}{
Deprecated. Retrieve OpenAPI file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$swaggerFile()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
