% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level_UI.R
\name{h5attributes}
\alias{h5attributes}
\alias{h5attr_names}
\alias{h5attr}
\alias{h5attr<-}
\title{Interface for HDF5 attributes}
\usage{
h5attributes(x)

h5attr_names(x)

h5attr(x, which)

h5attr(x, which) <- value
}
\arguments{
\item{x}{The object to which to attach the attribute to or retrieve it from. Can be one of \code{\link{H5Group}},  \code{\link{H5D}},
\code{\link{H5T}} or  \code{\link{H5File}}}

\item{which}{The name of the attribute to assign it to}

\item{value}{The value to assign to the attribute.}
}
\value{
For \code{h5attributes}, a named list with the content of the attributes read out. For \code{h5attr_names},
a vector of names of the attributes attached to the object \code{x}. For \code{h5attr}, the content of the attribute and
for \code{h5attr<-}, the assignment, the original object to which the attributes are attached (so that chaining is possible).
}
\description{
Interface for HDF5 attributes
}
\details{
Implements high-level functions that allows interactions with HDF5-attributes in a way very similar to regular R-object attributes
in R are handled.
}
\author{
Holger Hoefling
}
