% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableCores.R
\name{availableCores}
\alias{availableCores}
\title{Get number of available cores on current machine}
\usage{
availableCores(constraints = NULL,
  methods = getOption("future.availableCores.methods", c("system",
  "mc.cores", "_R_CHECK_LIMIT_CORES_", "PBS", "SGE", "Slurm", "fallback")),
  na.rm = TRUE, default = c(current = 1L), which = c("min", "max",
  "all"))
}
\arguments{
\item{constraints}{An optional character specifying under what
constraints ("purposes") we are requesting the values.
For instance, on systems where multicore processing is not supported
(i.e. Windows), using \code{constrains = "multicore"} will force a
single core to be reported.}

\item{methods}{A character vector specifying how to infer the number
of available cores.}

\item{na.rm}{If TRUE, only non-missing settings are considered/returned.}

\item{default}{The default number of cores to return if no non-missing
settings are available.}

\item{which}{A character specifying which settings to return.
If \code{"min"}, the minimum value is returned.
If \code{"max"}, the maximum value is returned (be careful!)
If \code{"all"}, all values are returned.}
}
\value{
Return a positive (>= 1) integer.
If \code{which = "all"}, then more than one value may be returned.
Together with \code{na.rm = FALSE} missing values may also be returned.
}
\description{
The current/main \R session counts as one, meaning the minimum
number of cores available is always at least one.
}
\details{
The following settings ("methods") for inferring the number of cores
are supported:
\itemize{
 \item \code{"system"} -
   Query \code{\link[parallel]{detectCores}()}.
 \item \code{"mc.cores"} -
   If available, returns the value of option
   \code{\link[base:options]{mc.cores}}.
   Note that \option{mc.cores} is defined as the number of
   \emph{additional} \R processes that can be used in addition to the
   main \R process.  This means that with \code{mc.cores = 0} all
   calculations should be done in the main \R process, i.e. we have
   exactly one core available for our calculations.
   The \option{mc.cores} option defaults to environment variable
   \env{MC_CORES} (and is set accordingly when the \pkg{parallel}
   package is loaded).  The \option{mc.cores} option is used by for
   instance \code{\link[parallel]{mclapply}()}.
 \item \code{"PBS"} -
   Query TORQUE/PBS environment variable \env{PBS_NUM_PPN}.
   Depending on PBS system configuration, this \emph{resource}
   parameter may or may not default to one.
   An example of a job submission that results in this is
   \code{qsub -l nodes=1:ppn=2}, which requests one node with two cores.
 \item \code{"SGE"} -
   Query Sun/Oracle Grid Engine (SGE) environment variable
   \env{NSLOTS}.
   An example of a job submission that results in this is
   \code{qsub -pe smp 2} (or \code{qsub -pe by_node 2}), which
   requests two cores on a single machine.
 \item \code{"Slurm"} -
   Query Simple Linux Utility for Resource Management (Slurm)
   environment variable \env{SLURM_CPUS_PER_TASK}.
   This may or may not be set.  It can be set when submitting a job,
   e.g. \code{sbatch --cpus-per-task=2 hello.sh} or by adding
   \code{#SBATCH --cpus-per-task=2} to the \file{hello.sh} script.
}
For any other value of a \code{methods} element, the \R option with the
same name is queried.  If that is not set, the system environment
variable is queried.  If neither is set, a missing value is returned.
}
\section{Advanced usage}{

It is possible to override the maximum number of cores on the machine
as reported by \code{availableCores(methods = "system")}.  This can be
done by first specifying
\code{options(future.availableCores.methods = "mc.cores")} and
then the number of cores to use, e.g. \code{options(mc.cores = 8)}.
Having said this, it is almost always better to do this by explicitly
setting the number of workers when specifying the future strategy,
e.g. \code{plan(multiprocess, workers = 8)}.
}

\seealso{
To get the number of available workers regardless of machine,
see \code{\link{availableWorkers}()}.
}
\keyword{internal}
