% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colTabulates.R, R/rowTabulates.R
\name{colTabulates,DelayedMatrix-method}
\alias{colTabulates,DelayedMatrix-method}
\alias{rowTabulates,DelayedMatrix-method}
\title{Tabulates the values in a matrix-like object by row (column)}
\usage{
\S4method{colTabulates}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  values = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowTabulates}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  values = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{values}{the values to search for.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
a \code{\link{numeric}} \code{NxJ} (\code{KxJ})
\code{\link{matrix}}, where N (K) is the number of rows (columns) for
which the J values are calculated.
}
\description{
Tabulates the values in a matrix-like object by row (column).
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowTabulates}} /
\code{matrixStats::\link[matrixStats]{colTabulates}}.
}
\examples{
# A DelayedMatrix with a 'DataFrame' seed
dm_DF <- DelayedArray(S4Vectors::DataFrame(C1 = rep(1L, 5),
                                           C2 = as.integer((0:4) ^ 2),
                                           C3 = seq(-5L, -1L, 1L)))

colTabulates(dm_DF)

rowTabulates(dm_DF)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowTabulates}()} and
\code{matrixStats::\link[matrixStats:rowTabulates]{colTabulates}()} which
are used when the input is a \code{matrix} or \code{numeric} vector.
\item \code{base::\link{table}()}
}
}
\author{
Peter Hickey
}
