#include <torch/csrc/lazy/core/ops/utils.h>
#include <torch/csrc/lazy/ts_backend/view_ops/permute.h>

#include <torch/csrc/lazy/core/helpers.h>

namespace torch {
namespace lazy {

Permute::Permute(const Value& input, std::vector<int64_t> dims)
    : TsNode(
          ClassOpKind(),
          {input},
          /*num_outputs=*/1,
          MHash(dims)),
      dims_(std::move(dims)) {
  addComputedShape([&]() {
    return MakePermuteShape(operand(0).shape(), dims_);
  });
}

std::string Permute::ToString() const {
  std::stringstream ss;
  ss << TsNode::ToString() << ", dims=(" << c10::Join(", ", dims_) << ")";
  return ss.str();
}

} // namespace lazy
} // namespace torch
