# mypy: allow-untyped-defs

from ._abstract import AbstractScraper
from ._utils import normalize_string


class PickUpLimes(AbstractScraper):
    @classmethod
    def host(cls):
        return "pickuplimes.com"

    def author(self):
        return self.schema.author()

    def title(self):
        return self.schema.title()

    def category(self):
        return self.schema.category()

    def total_time(self):
        return self.schema.total_time()

    def yields(self):
        return self.schema.yields()

    def image(self):
        return self.schema.image()

    def ingredients(self):
        return self.schema.ingredients()

    def instructions(self):
        instructions = [
            normalize_string(e.get_text())
            for e in self.soup.find_all(class_="direction")
        ]
        return "\n".join(instructions) if instructions else None

    def ratings(self):
        return self.schema.ratings()

    def cuisine(self):
        return self.schema.cuisine()

    def description(self):
        return self.schema.description()

    def prep_time(self):
        return self.schema.prep_time()

    def cook_time(self):
        return self.schema.cook_time()
