# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SettingsSectionDescription(Model):
    """Describes a section in the fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The section name of the fabric settings.
    :type name: str
    :param parameters: Required. The collection of parameters in the section.
    :type parameters:
     list[~azure.mgmt.servicefabric.models.SettingsParameterDescription]
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[SettingsParameterDescription]'},
    }

    def __init__(self, **kwargs):
        super(SettingsSectionDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.parameters = kwargs.get('parameters', None)
