# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JitNetworkAccessRequestPort(Model):
    """JitNetworkAccessRequestPort.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param allowed_source_address_prefix: Mutually exclusive with the
     "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR,
     for example "192.168.0.3" or "192.168.0.0/16".
    :type allowed_source_address_prefix: str
    :param allowed_source_address_prefixes: Mutually exclusive with the
     "allowedSourceAddressPrefix" parameter.
    :type allowed_source_address_prefixes: list[str]
    :param end_time_utc: Required. The date & time at which the request ends
     in UTC
    :type end_time_utc: datetime
    :param status: Required. The status of the port. Possible values include:
     'Revoked', 'Initiated'
    :type status: str or ~azure.mgmt.security.models.Status
    :param status_reason: Required. A description of why the `status` has its
     value. Possible values include: 'Expired', 'UserRequested',
     'NewerRequestInitiated'
    :type status_reason: str or ~azure.mgmt.security.models.StatusReason
    """

    _validation = {
        'number': {'required': True},
        'end_time_utc': {'required': True},
        'status': {'required': True},
        'status_reason': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'allowed_source_address_prefixes': {'key': 'allowedSourceAddressPrefixes', 'type': '[str]'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'status_reason': {'key': 'statusReason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessRequestPort, self).__init__(**kwargs)
        self.number = kwargs.get('number', None)
        self.allowed_source_address_prefix = kwargs.get('allowed_source_address_prefix', None)
        self.allowed_source_address_prefixes = kwargs.get('allowed_source_address_prefixes', None)
        self.end_time_utc = kwargs.get('end_time_utc', None)
        self.status = kwargs.get('status', None)
        self.status_reason = kwargs.get('status_reason', None)
