# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class InquiryInfo(Model):
    """Details about inquired protectable items under a given container.

    :param status: Inquiry Status for this container such as
     InProgress | Failed | Succeeded
    :type status: str
    :param error_detail: Error Details if the Status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param inquiry_details: Inquiry Details which will have workload specific
     details.
     For e.g. - For SQL and oracle this will contain different details.
    :type inquiry_details:
     list[~azure.mgmt.recoveryservicesbackup.models.WorkloadInquiryDetails]
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
        'inquiry_details': {'key': 'inquiryDetails', 'type': '[WorkloadInquiryDetails]'},
    }

    def __init__(self, *, status: str=None, error_detail=None, inquiry_details=None, **kwargs) -> None:
        super(InquiryInfo, self).__init__(**kwargs)
        self.status = status
        self.error_detail = error_detail
        self.inquiry_details = inquiry_details
