# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PolicyStatesQueryResults(Model):
    """Query results.

    :param odatacontext: OData context string; used by OData clients to
     resolve type information based on metadata.
    :type odatacontext: str
    :param odatacount: OData entity count; represents the number of policy
     state records returned.
    :type odatacount: int
    :param value: Query results.
    :type value: list[~azure.mgmt.policyinsights.models.PolicyState]
    """

    _validation = {
        'odatacount': {'minimum': 0},
    }

    _attribute_map = {
        'odatacontext': {'key': '@odata\\.context', 'type': 'str'},
        'odatacount': {'key': '@odata\\.count', 'type': 'int'},
        'value': {'key': 'value', 'type': '[PolicyState]'},
    }

    def __init__(self, *, odatacontext: str=None, odatacount: int=None, value=None, **kwargs) -> None:
        super(PolicyStatesQueryResults, self).__init__(**kwargs)
        self.odatacontext = odatacontext
        self.odatacount = odatacount
        self.value = value
