# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TargetRegion(Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the region.
    :type name: str
    :param regional_replica_count: The number of replicas of the Image Version
     to be created per region. This property is updateable.
    :type regional_replica_count: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'regional_replica_count': {'key': 'regionalReplicaCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TargetRegion, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.regional_replica_count = kwargs.get('regional_replica_count', None)
