from typing import ClassVar, Iterator, Tuple, Optional, Any

from typing import overload
import datetime

import osmium.osm.mutable

ALL: osm_entity_bits
AREA: osm_entity_bits
CHANGESET: osm_entity_bits
NODE: osm_entity_bits
NOTHING: osm_entity_bits
OBJECT: osm_entity_bits
RELATION: osm_entity_bits
WAY: osm_entity_bits


class Location:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, lon: float, lat: float) -> None: ...
    def lat_without_check(self) -> float: ...
    def lon_without_check(self) -> float: ...
    def valid(self) -> bool: ...
    @property
    def lat(self) -> float: ...
    @property
    def lon(self) -> float: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class Box:
    @overload
    def __init__(self, minx: float, miny: float, maxx: float, maxy: float) -> None: ...
    @overload
    def __init__(self, bottom_left: Location, top_right: Location) -> None: ...
    def contains(self, location: Location) -> bool: ...
    @overload
    def extend(self, location: Location) -> Box: ...
    @overload
    def extend(self, box: Box) -> Box: ...
    def size(self) -> float: ...
    def valid(self) -> bool: ...
    @property
    def bottom_left(self) -> Location: ...
    @property
    def top_right(self) -> Location: ...

class TagIterator:
    def __iter__(self) -> TagIterator: ...
    def __len__(self) -> int: ...
    def __next__(self) -> str: ...

class Tag:
    def __iter__(self) -> TagIterator: ...
    @property
    def k(self) -> str: ...
    @property
    def v(self) -> str: ...

class TagList:
    @overload
    def get(self, key: str, default: str) -> str: ...
    @overload
    def get(self, key: str) -> Optional[str]: ...
    def __contains__(self, key: str) -> bool: ...
    def __getitem__(self, key: str) -> str: ...
    def __iter__(self) -> Iterator[Tag]: ...
    def __len__(self) -> int: ...

class NodeRef:
    @property
    def lat(self) -> float: ...
    @property
    def location(self) -> Location: ...
    @property
    def lon(self) -> float: ...
    @property
    def ref(self) -> int: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class RelationMember:
    @property
    def ref(self) -> int: ...
    @property
    def role(self) -> str: ...
    @property
    def type(self) -> str: ...

class RelationMemberList:
    def __iter__(self) -> Iterator[RelationMember]: ...
    def __len__(self) -> int: ...

class NodeRefList:
    def ends_have_same_id(self) -> bool: ...
    def ends_have_same_location(self) -> bool: ...
    def is_closed(self) -> bool: ...
    def __getitem__(self, idx: int) -> NodeRef: ...
    def __iter__(self) -> Iterator[NodeRef]: ...
    def __len__(self) -> int: ...

class WayNodeList(NodeRefList):
    pass

class OuterRing(NodeRefList):
    pass

class InnerRing(NodeRefList):
    pass

class InnerRingIterator:
    def __iter__(self) -> Iterator[InnerRing]: ...

class OSMObject:
    def positive_id(self) -> int: ...
    def user_is_anonymous(self) -> bool: ...
    @property
    def changeset(self) -> int: ...
    @property
    def deleted(self) -> bool: ...
    @property
    def id(self) -> int: ...
    @property
    def tags(self) -> TagList: ...
    @property
    def timestamp(self) -> datetime.datetime: ...
    @property
    def uid(self) -> int: ...
    @property
    def user(self) -> str: ...
    @property
    def version(self) -> int: ...
    @property
    def visible(self) -> bool: ...

class Node(OSMObject):
    @property
    def location(self) -> Location: ...
    def replace(**args: Any) -> osmium.osm.mutable.Node: ...

class Way(OSMObject):
    def ends_have_same_id(self) -> bool: ...
    def ends_have_same_location(self) -> bool: ...
    def is_closed(self) -> bool: ...
    @property
    def nodes(self) -> WayNodeList: ...
    def replace(**args: Any) -> osmium.osm.mutable.Way: ...

class Relation(OSMObject):
    @property
    def members(self) -> RelationMemberList: ...
    def replace(**args: Any) -> osmium.osm.mutable.Relation: ...

class Area(OSMObject):
    def from_way(self) -> bool: ...
    def inner_rings(self, outer_ring: OuterRing) -> InnerRingIterator: ...
    def is_multipolygon(self) -> bool: ...
    def num_rings(self) -> Tuple[int,int]: ...
    def orig_id(self) -> int: ...
    def outer_rings(self) -> Iterator[OuterRing]: ...

class Changeset:
    def user_is_anonymous(self) -> bool: ...
    @property
    def bounds(self) -> Box: ...
    @property
    def closed_at(self) -> datetime.datetime: ...
    @property
    def created_at(self) -> datetime.datetime: ...
    @property
    def id(self) -> int: ...
    @property
    def num_changes(self) -> int: ...
    @property
    def open(self) -> bool: ...
    @property
    def tags(self) -> TagList: ...
    @property
    def uid(self) -> int: ...
    @property
    def user(self) -> str: ...

class osm_entity_bits:
    ALL: ClassVar[osm_entity_bits] = ...
    AREA: ClassVar[osm_entity_bits] = ...
    CHANGESET: ClassVar[osm_entity_bits] = ...
    NODE: ClassVar[osm_entity_bits] = ...
    NOTHING: ClassVar[osm_entity_bits] = ...
    OBJECT: ClassVar[osm_entity_bits] = ...
    RELATION: ClassVar[osm_entity_bits] = ...
    WAY: ClassVar[osm_entity_bits] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...
