from typing import ClassVar

from typing import overload
import osmium.osm
ALL: use_nodes
BACKWARD: direction
FORWARD: direction
UNIQUE: use_nodes


class use_nodes:
    ALL: ClassVar[use_nodes] = ...
    UNIQUE: ClassVar[use_nodes] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class direction:
    BACKWARD: ClassVar[direction] = ...
    FORWARD: ClassVar[direction] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Coordinates:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float) -> None: ...
    @overload
    def __init__(self, location: osmium.osm.Location) -> None: ...
    def valid(self) -> bool: ...
    @property
    def x(self) -> float: ...
    @property
    def y(self) -> float: ...


class GeoJSONFactory:
    def __init__(self) -> None: ...
    @overload
    def create_linestring(self, list: osmium.osm.WayNodeList, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    @overload
    def create_linestring(self, way: osmium.osm.Way, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    def create_multipolygon(self, area: osmium.osm.Area) -> str: ...
    @overload
    def create_point(self, location: osmium.osm.Location) -> str: ...
    @overload
    def create_point(self, node: osmium.osm.Node) -> str: ...
    @overload
    def create_point(self, ref: osmium.osm.NodeRef) -> str: ...
    @property
    def epsg(self) -> int: ...
    @property
    def proj_string(self) -> str: ...

class WKBFactory:
    def __init__(self) -> None: ...
    @overload
    def create_linestring(self, list: osmium.osm.WayNodeList, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    @overload
    def create_linestring(self, way: osmium.osm.Way, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    def create_multipolygon(self, area: osmium.osm.Area) -> str: ...
    @overload
    def create_point(self, location: osmium.osm.Location) -> str: ...
    @overload
    def create_point(self, node: osmium.osm.Node) -> str: ...
    @overload
    def create_point(self, ref: osmium.osm.NodeRef) -> str: ...
    @property
    def epsg(self) -> int: ...
    @property
    def proj_string(self) -> str: ...

class WKTFactory:
    def __init__(self) -> None: ...
    @overload
    def create_linestring(self, list: osmium.osm._osm.WayNodeList, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    @overload
    def create_linestring(self, way: osmium.osm._osm.Way, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    def create_multipolygon(self, area: osmium.osm._osm.Area) -> str: ...
    @overload
    def create_point(self, location: osmium.osm._osm.Location) -> str: ...
    @overload
    def create_point(self, node: osmium.osm._osm.Node) -> str: ...
    @overload
    def create_point(self, ref: osmium.osm._osm.NodeRef) -> str: ...
    @property
    def epsg(self) -> int: ...
    @property
    def proj_string(self) -> str: ...

def haversine_distance(list: osmium.osm.WayNodeList) -> float: ...
def lonlat_to_mercator(coordinate: Coordinates) -> Coordinates: ...
def mercator_to_lonlat(coordinate: Coordinates) -> Coordinates: ...
