test_name "(#19531) report save access control"

tag 'audit:high',        # low risk, high (security) impact
    'audit:refactor',    # Use block style `test_name`
    'audit:integration', # issue completely on the server side
    'server'

step "Verify puppet only allows saving reports from the node matching the certificate"

fake_report = <<-EOYAML
--- !ruby/object:Puppet::Transaction::Report
  host: mccune
  metrics: {}
  logs: []
  puppet_version: "2.7.20"
  status: failed
  report_format: 3
EOYAML

with_puppet_running_on(master, {}) do
  submit_fake_report_cmd = [
    "curl --tlsv1 -k -X PUT",
    "--cacert \"$(puppet config print --section master cacert)\"",
    "--cert \"$(puppet config print --section master hostcert)\"",
    "--key \"$(puppet config print --section master hostprivkey)\"",
    "-H 'Content-Type: text/yaml'",
    "-d '#{fake_report}'",
    "\"https://#{master}:8140/puppet/v3/report/mccune?environment=production\"",
  ].join(" ")

  on master, submit_fake_report_cmd, :acceptable_exit_codes => [0] do
    msg = "(#19531) (CVE-2013-2275) Puppet master accepted a report for a node that does not match the certname"
    assert_match(/Forbidden request/, stdout, msg)
  end
end
