# Setting a custom fact to "string" will overwrite a local variable during
# template compilation on the master allowing remote code execution by
# any authenticated client.
test_name "CVE 2013-1640 Remote Code Execution" do

  tag 'audit:high',       # low risk, high (security) impact
      'audit:integration'

  confine :except, :platform => 'windows'
  confine :except, :platform => 'cisco_nexus' # See BKR-749

  on agents, %q[ FACTER_string="<%= %x{ /bin/echo hax0rd }  %>" ] +
             %q[ puppet apply -e ] +
             %q[ 'notice(inline_template("<%= \"I am Safe\" %>"))' ] do |test|

    assert_match(/I am Safe/, test.stdout)
    assert_no_match(/hax0rd/, test.stdout)
  end
end
