# PhotoQt

PhotoQt is a simple yet powerful and good looking **image viewer**, based on Qt/QML, published as **open-source**, and **completely free**. It is fast and highly configurable with a wide range of features and a large number of supported image formats.

Visit its official website at https://photoqt.org

## Features

PhotoQt is an image viewer that provides a simple and uncluttered interface. Yet, hidden beneath the surface awaits a large array of features. Here are some of its main features (not an exhaustive list). Suggestions for new features are always welcome!

- Support of up to more than **140 image formats**. A list of all possibly supported image formats [can be found on the website](https://photoqt.org/formats).
- **Touchscreen** support, including pinch-to-zoom.
- Showing GPS locations of images with an **embedded map** or explore all images with location data in current folder with an **interactive map**
- **Chromecast** support (tested with third generation devices)
- Basic **image manipulation**: zooming, rotating, mirroring (all of which per-session only)
- **Convert images** between supported formats
- Keyboard and mouse **shortcuts** for maximum flexibility and control
- Upload images directly to the image sharing website **imgur.com**
- Set images as **wallpaper** directly from inside PhotoQt
- **Slideshow** feature including support for background music, random ordering of images, and including images in subfolders
- Display extensive **meta information (Exif/IPTC/XMP)** including showing/tagging of faces
- **Advanced sorting** capabilities by various image/file properties
- [Standard compliant](https://specifications.freedesktop.org/thumbnail-spec/thumbnail-spec-latest.html) **thumbnail cache** for maximum performance
- Support for **system tray icon**, including starting PhotoQt hidden to its tray icon, and optional feature to reset PhotoQt when hiding (freeing most memory allocated during use)
- Wide selection of **command line options** for maximum flexibility and remote controlling of PhotoQt
- **Translated** into a range of different languages ([help wanted](https://translate.photoqt.org/))
- and many more...

The list above is not an exhaustive list. There are many more features and capabilities in PhotoQt. In addition, most of the behavior of PhotoQt can be tweaked extensively to make it an exact fit for your needs.


## Download and Install

PhotoQt is available in the repositories of an increasing number of Linux distributions. In addition, various means of installing PhotoQt (Windows installer, Flatpak, etc.) are listed on the website at [PhotoQt.org/down](https://photoqt.org/down).

Instructions of how to build PhotoQt from source can be found in the [INSTALL.md](INSTALL.md) file in the root of the source directory.


## Contributing to PhotoQt

There are **two easy ways** you can contribute directly to PhotoQt:

1. **Join the translation team** over on [Crowdin](https://translate.photoqt.org/). If your language is missing you can simply request it directly on Crowdin or send me an email and I can add it to the project.
2. **Give feedback** of what you like/don't like, or what you think is missing from PhotoQt. To give feedback, simply [open an issue on GitLab](https://gitlab.com/luspi/photoqt/-/issues/new).

If you want to support PhotoQt financially, please **consider donating to the humanitarian relief in Ukraine** instead, for example to the [Ukrainian Red Cross](https://go.luspi.de/ukraine).


## Screenshots

![Main Interface](https://photoqt.org/img/screenshots/01maininterface.jpg "Main Interface"){width=400px}
![Main Interface (popout)](https://photoqt.org/img/screenshots/02maininterface.jpg "Main Interface (popout)"){width=400px}
![File Manager](https://photoqt.org/img/screenshots/04filedialog.jpg "File Manager"){width=400px}
![Settings Manager (interface)](https://photoqt.org/img/screenshots/05settingsmanager.jpg "Settings Manager"){width=400px}


## License

PhotoQt is released under the [GPLv2](http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt) (or later) license. 
