# Iotas note taking

Iotas is a simple note taking app with mobile-first design and a focus on sync with a Nextcloud Notes.

<img src="https://gitlab.gnome.org/World/iotas/-/raw/main/data/screenshots/mobile_index.png" width="350px" />

## Features

Although simple by design there are a few features

- Sync. with Nextcloud Notes
- Offline note editing, syncing when back online
- Basic search
- Favorites
- Spell checking
- Category editing and filtering
- Note backup and restoration from CLI for using without sync.
- The ability to change font size and toggle monospace style

Writing in markdown is supported but optional, featuring

- Syntax highlighting with themes
- Formatted render view
- The ability to check off task lists from the rendered markdown

Slightly more technical details, for those into that type of thing

- Nextcloud Notes sync. is via the REST API, not WebDAV, which makes it snappy
- There's basic sync. conflict detection
- Notes are constantly saved
- Large note collections are partially loaded to quicken startup 

## Install

<a href="https://flathub.org/apps/details/org.gnome.gitlab.cheywood.Iotas"><img src="https://flathub.org/assets/badges/flathub-badge-i-en.png" width="190px" /></a>

## Issues & contact

Please report any bugs you come across in [the usual place](https://gitlab.gnome.org/World/iotas/-/issues).

## FAQ / tips

**I don't want to use markdown, can I still use Iotas as a simple unformatted note editor?**

Yes, just disable markdown syntax highlighting and the markdown render view.

**What options should I use to make Iotas run fast on my low power device?**

Disable spelling, markdown syntax highlighting and markdown render view.

**Can I use my own markdown syntax theme?**

Yes, place it in `~/.var/app/org.gnome.gitlab.cheywood.Iotas/data/gtksourceview-5/styles/`. Copy one of the [existing themes](https://gitlab.gnome.org/World/iotas/-/tree/main/data/gtksourceview-5/styles) as a base. You should end up with a `<theme_name>.xml` and a `<theme_name>-dark.xml` in that directory.

**Can I disable the editor headerbar being hidden when fullscreen?**

Yes.

1. Run a shell within the Flatpak sandbox: `flatpak run --command=sh org.gnome.gitlab.cheywood.Iotas`
2. Toggle the setting in that shell: `gsettings set org.gnome.gitlab.cheywood.Iotas hide-editor-headerbar-when-fullscreen false`

**How do I change the font used in the editor?**

Iotas uses GNOME's font settings to determine which font to use. Changing the monospace or document font in GNOME Tweaks will update the editor font used, depending on whether using a monospace font is selected in the preferences.

**Why does my category disappear when I remove all its notes?**

Categories in Iotas only exist when attached to one or more notes. This mirrors the behaviour in Nextcloud Notes and for the moment is unlikely to change unless the server-side behaviour does.

**Why have the ability to backup and restore notes when sync with Nextcloud Notes is supported?**

The backups are for people who don't have access to a Nextcloud instance or would rather manage their data another way. More broadly this ties into local-first computing.

**How do I use the backups?**

Create a backup with `flatpak run org.gnome.gitlab.cheywood.Iotas --create-backup`.

To find out where that backup use `flatpak run org.gnome.gitlab.cheywood.Iotas --display-backup-path`.

Whatever mechanism can then be used to transfer that path (eg. rsync, Syncthing).

A backup can be restored via `flatpak run --command=sh org.gnome.gitlab.cheywood.Iotas --restore-backup`.

Notes:
- Backups are restored from the path displayed with `--display-backup-path`
- Backups can only be restored when there are no existing notes
- Backups can't be restored when synced to Nextcloud Notes. In that case your backups should be via the server instead.
- Backups can't be created or restored when Iotas is already running. If you want to automate this you can call `flatpak run org.gnome.gitlab.cheywood.Iotas --quit-running` beforehand.

**Why isn't the backup placed somewhere more conventional?**

With Flatpak accessing more of the filesystem would require an extra permission, which we don't want to use.

**Can I change the file extension used for backups?**

Yes. For example to change to `.md`:

1. Run a shell within the Flatpak sandbox: `flatpak run --command=sh org.gnome.gitlab.cheywood.Iotas`
2. Toggle the setting in that shell: `gsettings set org.gnome.gitlab.cheywood.Iotas backup-note-extension md`

**Why don't my backup files have the same file extension as they do on my Nextcloud instance?**

The Nextcloud Notes API doesn't provide access to the file extension for each file. 

There's a server side preference for file extensions that Iotas will look to follow in the future. However on the server that preference doesn't impact the file extension for notes created before the preference existed.

**How do I sign out from sync with Nextcloud Notes without losing all my notes?**

1. Perform a backup (from the command line, see above)
2. Sign out from sync
3. Restore the backup

Note that if you then re-establish sync with the same Nextcloud instance you will likely end up with a mess.

**How do I use Iotas with a Nextcloud host using a self-signed SSL certificate?**

1. Log in to your Nextcloud instance in Firefox
2. Click on the padlock next to the URL
3. Drill down through _Connection not secure_ > _More information_ > _View certificate_
6. Download the _PEM (chain)_ in the _Miscellaneous_ section (not the _PEM (cert)_)
7. Place (and rename) the file to the location provided by `flatpak run org.gnome.gitlab.cheywood.Iotas --display-ca-file-path`
8. Restart Iotas and log in to your server

**How do I enable the experimental TeX math equation support?**

1. Run a shell within the Flatpak sandbox: `flatpak run --command=sh org.gnome.gitlab.cheywood.Iotas`
2. Toggle the setting in that shell: `gsettings set org.gnome.gitlab.cheywood.Iotas markdown-tex-support true`

The TeX support is new and the heavy lifting is done by [KaTeX](https://katex.org/). If you find this useful please leave [a note in an issue](https://gitlab.gnome.org/World/iotas/-/issues) to let us know it's working as expected. This will also help to ensure TeX has a life ongoing in Iotas.

Notes: 
- Use dollar sign delimiters
- While `/tag` should work as expected labels do not

## Development

Iotas was conceived in response to the question: what can be used to write simple notes on mobile Linux with fast sync to a self-hosted FLOSS server?

It's fairly minimal by design, so changes to integrate complex functionality may not be merged. Probably best to drop a note to say hi (in an issue) if you're interested in working on something sizeable and don't want to risk wasted effort. The focus is on Nextcloud Notes sync, and a good experience for the current generation of Linux mobile devices is higher priority than a feature-rich desktop app.

### Authentication storage

Iotas uses the Secret Service to store authentication details for Nextcloud. This is typically handled smoothly by GNOME Keyring but that may not be the case on mobile or other environments. KWallet is [reported](https://gitlab.gnome.org/World/iotas/-/issues/71) to not be working.

## Thanks

Much was learnt and borrowed from projects Secrets, Feeds, Lollypop, Apostrophe, Fractal, Text Editor, Paper and Nextcloud Notes for Android. Many thanks!

## Why "Iotas"?

An iota is a little bit and this app is designed for jotting down little things on little devices. Iota stems from the same Greek word as jot and is commonly used in negative statements eg. "not one iota of …", but we think the word has more to give. Maybe somebody will take note?
