// Code generated by gen.go using fiat-crypto.
//
// Autogenerated: './word_by_word_montgomery' --output fpMont381.go --lang Go --package-name ff --doc-prepend-header 'Code generated by gen.go using fiat-crypto.' --package-case lowerCamelCase --public-function-case lowerCamelCase --public-type-case lowerCamelCase --doc-newline-before-package-declaration --no-primitives --widen-carry --no-field-element-typedefs --relax-primitive-carry-to-bitwidth 64 FpMont 64 0x1a0111ea397fe69a4b1ba7b6434bacd764774b84f38512bf6730d2a0f6b0f6241eabfffeb153ffffb9feffffffffaaab add sub mul square
//
// curve description: FpMont
//
// machine_wordsize = 64 (from "64")
//
// requested operations: add, sub, mul, square
//
// m = 0x1a0111ea397fe69a4b1ba7b6434bacd764774b84f38512bf6730d2a0f6b0f6241eabfffeb153ffffb9feffffffffaaab (from "0x1a0111ea397fe69a4b1ba7b6434bacd764774b84f38512bf6730d2a0f6b0f6241eabfffeb153ffffb9feffffffffaaab")
//
//
//
// NOTE: In addition to the bounds specified above each function, all
//
//   functions synthesized for this Montgomery arithmetic require the
//
//   input to be strictly less than the prime modulus (m), and also
//
//   require the input to be in the unique saturated representation.
//
//   All functions also ensure that these two properties are true of
//
//   return values.
//
//
//
// Computed values:
//
//   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140)
//
//   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)
//
//   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) in
//
//                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384

package ff

import "math/bits"

// The function fiatFpMontAdd adds two field elements in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
//   0 ≤ eval arg2 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
//   0 ≤ eval out1 < m
//
// Input Bounds:
//   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func fiatFpMontAdd(out1 *[6]uint64, arg1 *[6]uint64, arg2 *[6]uint64) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Add64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Add64(arg1[1], arg2[1], uint64(x2))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Add64(arg1[2], arg2[2], uint64(x4))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Add64(arg1[3], arg2[3], uint64(x6))
	var x9 uint64
	var x10 uint64
	x9, x10 = bits.Add64(arg1[4], arg2[4], uint64(x8))
	var x11 uint64
	var x12 uint64
	x11, x12 = bits.Add64(arg1[5], arg2[5], uint64(x10))
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Sub64(x1, 0xb9feffffffffaaab, uint64(uint64(0x0)))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Sub64(x3, 0x1eabfffeb153ffff, uint64(x14))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Sub64(x5, 0x6730d2a0f6b0f624, uint64(x16))
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Sub64(x7, 0x64774b84f38512bf, uint64(x18))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Sub64(x9, 0x4b1ba7b6434bacd7, uint64(x20))
	var x23 uint64
	var x24 uint64
	x23, x24 = bits.Sub64(x11, 0x1a0111ea397fe69a, uint64(x22))
	var x26 uint64
	_, x26 = bits.Sub64(x12, uint64(0x0), uint64(x24))
	var x27 uint64
	fiatFpMontCmovznzU64(&x27, x26, x13, x1)
	var x28 uint64
	fiatFpMontCmovznzU64(&x28, x26, x15, x3)
	var x29 uint64
	fiatFpMontCmovznzU64(&x29, x26, x17, x5)
	var x30 uint64
	fiatFpMontCmovznzU64(&x30, x26, x19, x7)
	var x31 uint64
	fiatFpMontCmovznzU64(&x31, x26, x21, x9)
	var x32 uint64
	fiatFpMontCmovznzU64(&x32, x26, x23, x11)
	out1[0] = x27
	out1[1] = x28
	out1[2] = x29
	out1[3] = x30
	out1[4] = x31
	out1[5] = x32
}

// The function fiatFpMontSub subtracts two field elements in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
//   0 ≤ eval arg2 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
//   0 ≤ eval out1 < m
//
// Input Bounds:
//   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func fiatFpMontSub(out1 *[6]uint64, arg1 *[6]uint64, arg2 *[6]uint64) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Sub64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Sub64(arg1[1], arg2[1], uint64(x2))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Sub64(arg1[2], arg2[2], uint64(x4))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Sub64(arg1[3], arg2[3], uint64(x6))
	var x9 uint64
	var x10 uint64
	x9, x10 = bits.Sub64(arg1[4], arg2[4], uint64(x8))
	var x11 uint64
	var x12 uint64
	x11, x12 = bits.Sub64(arg1[5], arg2[5], uint64(x10))
	var x13 uint64
	fiatFpMontCmovznzU64(&x13, x12, uint64(0x0), 0xffffffffffffffff)
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(x1, (x13 & 0xb9feffffffffaaab), uint64(0x0))
	var x16 uint64
	var x17 uint64
	x16, x17 = bits.Add64(x3, (x13 & 0x1eabfffeb153ffff), uint64(x15))
	var x18 uint64
	var x19 uint64
	x18, x19 = bits.Add64(x5, (x13 & 0x6730d2a0f6b0f624), uint64(x17))
	var x20 uint64
	var x21 uint64
	x20, x21 = bits.Add64(x7, (x13 & 0x64774b84f38512bf), uint64(x19))
	var x22 uint64
	var x23 uint64
	x22, x23 = bits.Add64(x9, (x13 & 0x4b1ba7b6434bacd7), uint64(x21))
	var x24 uint64
	x24, _ = bits.Add64(x11, (x13 & 0x1a0111ea397fe69a), uint64(x23))
	out1[0] = x14
	out1[1] = x16
	out1[2] = x18
	out1[3] = x20
	out1[4] = x22
	out1[5] = x24
}

// The function fiatFpMontMul multiplies two field elements in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
//   0 ≤ eval arg2 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
//   0 ≤ eval out1 < m
//
// Input Bounds:
//   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func fiatFpMontMul(out1 *[6]uint64, arg1 *[6]uint64, arg2 *[6]uint64) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x6, arg2[5])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x6, arg2[4])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x6, arg2[3])
	var x13 uint64
	var x14 uint64
	x14, x13 = bits.Mul64(x6, arg2[2])
	var x15 uint64
	var x16 uint64
	x16, x15 = bits.Mul64(x6, arg2[1])
	var x17 uint64
	var x18 uint64
	x18, x17 = bits.Mul64(x6, arg2[0])
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Add64(x18, x15, uint64(0x0))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Add64(x16, x13, uint64(x20))
	var x23 uint64
	var x24 uint64
	x23, x24 = bits.Add64(x14, x11, uint64(x22))
	var x25 uint64
	var x26 uint64
	x25, x26 = bits.Add64(x12, x9, uint64(x24))
	var x27 uint64
	var x28 uint64
	x27, x28 = bits.Add64(x10, x7, uint64(x26))
	x29 := (x28 + x8)
	var x30 uint64
	_, x30 = bits.Mul64(x17, 0x89f3fffcfffcfffd)
	var x32 uint64
	var x33 uint64
	x33, x32 = bits.Mul64(x30, 0x1a0111ea397fe69a)
	var x34 uint64
	var x35 uint64
	x35, x34 = bits.Mul64(x30, 0x4b1ba7b6434bacd7)
	var x36 uint64
	var x37 uint64
	x37, x36 = bits.Mul64(x30, 0x64774b84f38512bf)
	var x38 uint64
	var x39 uint64
	x39, x38 = bits.Mul64(x30, 0x6730d2a0f6b0f624)
	var x40 uint64
	var x41 uint64
	x41, x40 = bits.Mul64(x30, 0x1eabfffeb153ffff)
	var x42 uint64
	var x43 uint64
	x43, x42 = bits.Mul64(x30, 0xb9feffffffffaaab)
	var x44 uint64
	var x45 uint64
	x44, x45 = bits.Add64(x43, x40, uint64(0x0))
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64(x41, x38, uint64(x45))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x39, x36, uint64(x47))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x37, x34, uint64(x49))
	var x52 uint64
	var x53 uint64
	x52, x53 = bits.Add64(x35, x32, uint64(x51))
	x54 := (x53 + x33)
	var x56 uint64
	_, x56 = bits.Add64(x17, x42, uint64(0x0))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x19, x44, uint64(x56))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x21, x46, uint64(x58))
	var x61 uint64
	var x62 uint64
	x61, x62 = bits.Add64(x23, x48, uint64(x60))
	var x63 uint64
	var x64 uint64
	x63, x64 = bits.Add64(x25, x50, uint64(x62))
	var x65 uint64
	var x66 uint64
	x65, x66 = bits.Add64(x27, x52, uint64(x64))
	var x67 uint64
	var x68 uint64
	x67, x68 = bits.Add64(x29, x54, uint64(x66))
	var x69 uint64
	var x70 uint64
	x70, x69 = bits.Mul64(x1, arg2[5])
	var x71 uint64
	var x72 uint64
	x72, x71 = bits.Mul64(x1, arg2[4])
	var x73 uint64
	var x74 uint64
	x74, x73 = bits.Mul64(x1, arg2[3])
	var x75 uint64
	var x76 uint64
	x76, x75 = bits.Mul64(x1, arg2[2])
	var x77 uint64
	var x78 uint64
	x78, x77 = bits.Mul64(x1, arg2[1])
	var x79 uint64
	var x80 uint64
	x80, x79 = bits.Mul64(x1, arg2[0])
	var x81 uint64
	var x82 uint64
	x81, x82 = bits.Add64(x80, x77, uint64(0x0))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x78, x75, uint64(x82))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x76, x73, uint64(x84))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x74, x71, uint64(x86))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x72, x69, uint64(x88))
	x91 := (x90 + x70)
	var x92 uint64
	var x93 uint64
	x92, x93 = bits.Add64(x57, x79, uint64(0x0))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x59, x81, uint64(x93))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x61, x83, uint64(x95))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x63, x85, uint64(x97))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x65, x87, uint64(x99))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x67, x89, uint64(x101))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Add64(x68, x91, uint64(x103))
	var x106 uint64
	_, x106 = bits.Mul64(x92, 0x89f3fffcfffcfffd)
	var x108 uint64
	var x109 uint64
	x109, x108 = bits.Mul64(x106, 0x1a0111ea397fe69a)
	var x110 uint64
	var x111 uint64
	x111, x110 = bits.Mul64(x106, 0x4b1ba7b6434bacd7)
	var x112 uint64
	var x113 uint64
	x113, x112 = bits.Mul64(x106, 0x64774b84f38512bf)
	var x114 uint64
	var x115 uint64
	x115, x114 = bits.Mul64(x106, 0x6730d2a0f6b0f624)
	var x116 uint64
	var x117 uint64
	x117, x116 = bits.Mul64(x106, 0x1eabfffeb153ffff)
	var x118 uint64
	var x119 uint64
	x119, x118 = bits.Mul64(x106, 0xb9feffffffffaaab)
	var x120 uint64
	var x121 uint64
	x120, x121 = bits.Add64(x119, x116, uint64(0x0))
	var x122 uint64
	var x123 uint64
	x122, x123 = bits.Add64(x117, x114, uint64(x121))
	var x124 uint64
	var x125 uint64
	x124, x125 = bits.Add64(x115, x112, uint64(x123))
	var x126 uint64
	var x127 uint64
	x126, x127 = bits.Add64(x113, x110, uint64(x125))
	var x128 uint64
	var x129 uint64
	x128, x129 = bits.Add64(x111, x108, uint64(x127))
	x130 := (x129 + x109)
	var x132 uint64
	_, x132 = bits.Add64(x92, x118, uint64(0x0))
	var x133 uint64
	var x134 uint64
	x133, x134 = bits.Add64(x94, x120, uint64(x132))
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x96, x122, uint64(x134))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x98, x124, uint64(x136))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x100, x126, uint64(x138))
	var x141 uint64
	var x142 uint64
	x141, x142 = bits.Add64(x102, x128, uint64(x140))
	var x143 uint64
	var x144 uint64
	x143, x144 = bits.Add64(x104, x130, uint64(x142))
	x145 := (x144 + x105)
	var x146 uint64
	var x147 uint64
	x147, x146 = bits.Mul64(x2, arg2[5])
	var x148 uint64
	var x149 uint64
	x149, x148 = bits.Mul64(x2, arg2[4])
	var x150 uint64
	var x151 uint64
	x151, x150 = bits.Mul64(x2, arg2[3])
	var x152 uint64
	var x153 uint64
	x153, x152 = bits.Mul64(x2, arg2[2])
	var x154 uint64
	var x155 uint64
	x155, x154 = bits.Mul64(x2, arg2[1])
	var x156 uint64
	var x157 uint64
	x157, x156 = bits.Mul64(x2, arg2[0])
	var x158 uint64
	var x159 uint64
	x158, x159 = bits.Add64(x157, x154, uint64(0x0))
	var x160 uint64
	var x161 uint64
	x160, x161 = bits.Add64(x155, x152, uint64(x159))
	var x162 uint64
	var x163 uint64
	x162, x163 = bits.Add64(x153, x150, uint64(x161))
	var x164 uint64
	var x165 uint64
	x164, x165 = bits.Add64(x151, x148, uint64(x163))
	var x166 uint64
	var x167 uint64
	x166, x167 = bits.Add64(x149, x146, uint64(x165))
	x168 := (x167 + x147)
	var x169 uint64
	var x170 uint64
	x169, x170 = bits.Add64(x133, x156, uint64(0x0))
	var x171 uint64
	var x172 uint64
	x171, x172 = bits.Add64(x135, x158, uint64(x170))
	var x173 uint64
	var x174 uint64
	x173, x174 = bits.Add64(x137, x160, uint64(x172))
	var x175 uint64
	var x176 uint64
	x175, x176 = bits.Add64(x139, x162, uint64(x174))
	var x177 uint64
	var x178 uint64
	x177, x178 = bits.Add64(x141, x164, uint64(x176))
	var x179 uint64
	var x180 uint64
	x179, x180 = bits.Add64(x143, x166, uint64(x178))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x145, x168, uint64(x180))
	var x183 uint64
	_, x183 = bits.Mul64(x169, 0x89f3fffcfffcfffd)
	var x185 uint64
	var x186 uint64
	x186, x185 = bits.Mul64(x183, 0x1a0111ea397fe69a)
	var x187 uint64
	var x188 uint64
	x188, x187 = bits.Mul64(x183, 0x4b1ba7b6434bacd7)
	var x189 uint64
	var x190 uint64
	x190, x189 = bits.Mul64(x183, 0x64774b84f38512bf)
	var x191 uint64
	var x192 uint64
	x192, x191 = bits.Mul64(x183, 0x6730d2a0f6b0f624)
	var x193 uint64
	var x194 uint64
	x194, x193 = bits.Mul64(x183, 0x1eabfffeb153ffff)
	var x195 uint64
	var x196 uint64
	x196, x195 = bits.Mul64(x183, 0xb9feffffffffaaab)
	var x197 uint64
	var x198 uint64
	x197, x198 = bits.Add64(x196, x193, uint64(0x0))
	var x199 uint64
	var x200 uint64
	x199, x200 = bits.Add64(x194, x191, uint64(x198))
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x192, x189, uint64(x200))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x190, x187, uint64(x202))
	var x205 uint64
	var x206 uint64
	x205, x206 = bits.Add64(x188, x185, uint64(x204))
	x207 := (x206 + x186)
	var x209 uint64
	_, x209 = bits.Add64(x169, x195, uint64(0x0))
	var x210 uint64
	var x211 uint64
	x210, x211 = bits.Add64(x171, x197, uint64(x209))
	var x212 uint64
	var x213 uint64
	x212, x213 = bits.Add64(x173, x199, uint64(x211))
	var x214 uint64
	var x215 uint64
	x214, x215 = bits.Add64(x175, x201, uint64(x213))
	var x216 uint64
	var x217 uint64
	x216, x217 = bits.Add64(x177, x203, uint64(x215))
	var x218 uint64
	var x219 uint64
	x218, x219 = bits.Add64(x179, x205, uint64(x217))
	var x220 uint64
	var x221 uint64
	x220, x221 = bits.Add64(x181, x207, uint64(x219))
	x222 := (x221 + x182)
	var x223 uint64
	var x224 uint64
	x224, x223 = bits.Mul64(x3, arg2[5])
	var x225 uint64
	var x226 uint64
	x226, x225 = bits.Mul64(x3, arg2[4])
	var x227 uint64
	var x228 uint64
	x228, x227 = bits.Mul64(x3, arg2[3])
	var x229 uint64
	var x230 uint64
	x230, x229 = bits.Mul64(x3, arg2[2])
	var x231 uint64
	var x232 uint64
	x232, x231 = bits.Mul64(x3, arg2[1])
	var x233 uint64
	var x234 uint64
	x234, x233 = bits.Mul64(x3, arg2[0])
	var x235 uint64
	var x236 uint64
	x235, x236 = bits.Add64(x234, x231, uint64(0x0))
	var x237 uint64
	var x238 uint64
	x237, x238 = bits.Add64(x232, x229, uint64(x236))
	var x239 uint64
	var x240 uint64
	x239, x240 = bits.Add64(x230, x227, uint64(x238))
	var x241 uint64
	var x242 uint64
	x241, x242 = bits.Add64(x228, x225, uint64(x240))
	var x243 uint64
	var x244 uint64
	x243, x244 = bits.Add64(x226, x223, uint64(x242))
	x245 := (x244 + x224)
	var x246 uint64
	var x247 uint64
	x246, x247 = bits.Add64(x210, x233, uint64(0x0))
	var x248 uint64
	var x249 uint64
	x248, x249 = bits.Add64(x212, x235, uint64(x247))
	var x250 uint64
	var x251 uint64
	x250, x251 = bits.Add64(x214, x237, uint64(x249))
	var x252 uint64
	var x253 uint64
	x252, x253 = bits.Add64(x216, x239, uint64(x251))
	var x254 uint64
	var x255 uint64
	x254, x255 = bits.Add64(x218, x241, uint64(x253))
	var x256 uint64
	var x257 uint64
	x256, x257 = bits.Add64(x220, x243, uint64(x255))
	var x258 uint64
	var x259 uint64
	x258, x259 = bits.Add64(x222, x245, uint64(x257))
	var x260 uint64
	_, x260 = bits.Mul64(x246, 0x89f3fffcfffcfffd)
	var x262 uint64
	var x263 uint64
	x263, x262 = bits.Mul64(x260, 0x1a0111ea397fe69a)
	var x264 uint64
	var x265 uint64
	x265, x264 = bits.Mul64(x260, 0x4b1ba7b6434bacd7)
	var x266 uint64
	var x267 uint64
	x267, x266 = bits.Mul64(x260, 0x64774b84f38512bf)
	var x268 uint64
	var x269 uint64
	x269, x268 = bits.Mul64(x260, 0x6730d2a0f6b0f624)
	var x270 uint64
	var x271 uint64
	x271, x270 = bits.Mul64(x260, 0x1eabfffeb153ffff)
	var x272 uint64
	var x273 uint64
	x273, x272 = bits.Mul64(x260, 0xb9feffffffffaaab)
	var x274 uint64
	var x275 uint64
	x274, x275 = bits.Add64(x273, x270, uint64(0x0))
	var x276 uint64
	var x277 uint64
	x276, x277 = bits.Add64(x271, x268, uint64(x275))
	var x278 uint64
	var x279 uint64
	x278, x279 = bits.Add64(x269, x266, uint64(x277))
	var x280 uint64
	var x281 uint64
	x280, x281 = bits.Add64(x267, x264, uint64(x279))
	var x282 uint64
	var x283 uint64
	x282, x283 = bits.Add64(x265, x262, uint64(x281))
	x284 := (x283 + x263)
	var x286 uint64
	_, x286 = bits.Add64(x246, x272, uint64(0x0))
	var x287 uint64
	var x288 uint64
	x287, x288 = bits.Add64(x248, x274, uint64(x286))
	var x289 uint64
	var x290 uint64
	x289, x290 = bits.Add64(x250, x276, uint64(x288))
	var x291 uint64
	var x292 uint64
	x291, x292 = bits.Add64(x252, x278, uint64(x290))
	var x293 uint64
	var x294 uint64
	x293, x294 = bits.Add64(x254, x280, uint64(x292))
	var x295 uint64
	var x296 uint64
	x295, x296 = bits.Add64(x256, x282, uint64(x294))
	var x297 uint64
	var x298 uint64
	x297, x298 = bits.Add64(x258, x284, uint64(x296))
	x299 := (x298 + x259)
	var x300 uint64
	var x301 uint64
	x301, x300 = bits.Mul64(x4, arg2[5])
	var x302 uint64
	var x303 uint64
	x303, x302 = bits.Mul64(x4, arg2[4])
	var x304 uint64
	var x305 uint64
	x305, x304 = bits.Mul64(x4, arg2[3])
	var x306 uint64
	var x307 uint64
	x307, x306 = bits.Mul64(x4, arg2[2])
	var x308 uint64
	var x309 uint64
	x309, x308 = bits.Mul64(x4, arg2[1])
	var x310 uint64
	var x311 uint64
	x311, x310 = bits.Mul64(x4, arg2[0])
	var x312 uint64
	var x313 uint64
	x312, x313 = bits.Add64(x311, x308, uint64(0x0))
	var x314 uint64
	var x315 uint64
	x314, x315 = bits.Add64(x309, x306, uint64(x313))
	var x316 uint64
	var x317 uint64
	x316, x317 = bits.Add64(x307, x304, uint64(x315))
	var x318 uint64
	var x319 uint64
	x318, x319 = bits.Add64(x305, x302, uint64(x317))
	var x320 uint64
	var x321 uint64
	x320, x321 = bits.Add64(x303, x300, uint64(x319))
	x322 := (x321 + x301)
	var x323 uint64
	var x324 uint64
	x323, x324 = bits.Add64(x287, x310, uint64(0x0))
	var x325 uint64
	var x326 uint64
	x325, x326 = bits.Add64(x289, x312, uint64(x324))
	var x327 uint64
	var x328 uint64
	x327, x328 = bits.Add64(x291, x314, uint64(x326))
	var x329 uint64
	var x330 uint64
	x329, x330 = bits.Add64(x293, x316, uint64(x328))
	var x331 uint64
	var x332 uint64
	x331, x332 = bits.Add64(x295, x318, uint64(x330))
	var x333 uint64
	var x334 uint64
	x333, x334 = bits.Add64(x297, x320, uint64(x332))
	var x335 uint64
	var x336 uint64
	x335, x336 = bits.Add64(x299, x322, uint64(x334))
	var x337 uint64
	_, x337 = bits.Mul64(x323, 0x89f3fffcfffcfffd)
	var x339 uint64
	var x340 uint64
	x340, x339 = bits.Mul64(x337, 0x1a0111ea397fe69a)
	var x341 uint64
	var x342 uint64
	x342, x341 = bits.Mul64(x337, 0x4b1ba7b6434bacd7)
	var x343 uint64
	var x344 uint64
	x344, x343 = bits.Mul64(x337, 0x64774b84f38512bf)
	var x345 uint64
	var x346 uint64
	x346, x345 = bits.Mul64(x337, 0x6730d2a0f6b0f624)
	var x347 uint64
	var x348 uint64
	x348, x347 = bits.Mul64(x337, 0x1eabfffeb153ffff)
	var x349 uint64
	var x350 uint64
	x350, x349 = bits.Mul64(x337, 0xb9feffffffffaaab)
	var x351 uint64
	var x352 uint64
	x351, x352 = bits.Add64(x350, x347, uint64(0x0))
	var x353 uint64
	var x354 uint64
	x353, x354 = bits.Add64(x348, x345, uint64(x352))
	var x355 uint64
	var x356 uint64
	x355, x356 = bits.Add64(x346, x343, uint64(x354))
	var x357 uint64
	var x358 uint64
	x357, x358 = bits.Add64(x344, x341, uint64(x356))
	var x359 uint64
	var x360 uint64
	x359, x360 = bits.Add64(x342, x339, uint64(x358))
	x361 := (x360 + x340)
	var x363 uint64
	_, x363 = bits.Add64(x323, x349, uint64(0x0))
	var x364 uint64
	var x365 uint64
	x364, x365 = bits.Add64(x325, x351, uint64(x363))
	var x366 uint64
	var x367 uint64
	x366, x367 = bits.Add64(x327, x353, uint64(x365))
	var x368 uint64
	var x369 uint64
	x368, x369 = bits.Add64(x329, x355, uint64(x367))
	var x370 uint64
	var x371 uint64
	x370, x371 = bits.Add64(x331, x357, uint64(x369))
	var x372 uint64
	var x373 uint64
	x372, x373 = bits.Add64(x333, x359, uint64(x371))
	var x374 uint64
	var x375 uint64
	x374, x375 = bits.Add64(x335, x361, uint64(x373))
	x376 := (x375 + x336)
	var x377 uint64
	var x378 uint64
	x378, x377 = bits.Mul64(x5, arg2[5])
	var x379 uint64
	var x380 uint64
	x380, x379 = bits.Mul64(x5, arg2[4])
	var x381 uint64
	var x382 uint64
	x382, x381 = bits.Mul64(x5, arg2[3])
	var x383 uint64
	var x384 uint64
	x384, x383 = bits.Mul64(x5, arg2[2])
	var x385 uint64
	var x386 uint64
	x386, x385 = bits.Mul64(x5, arg2[1])
	var x387 uint64
	var x388 uint64
	x388, x387 = bits.Mul64(x5, arg2[0])
	var x389 uint64
	var x390 uint64
	x389, x390 = bits.Add64(x388, x385, uint64(0x0))
	var x391 uint64
	var x392 uint64
	x391, x392 = bits.Add64(x386, x383, uint64(x390))
	var x393 uint64
	var x394 uint64
	x393, x394 = bits.Add64(x384, x381, uint64(x392))
	var x395 uint64
	var x396 uint64
	x395, x396 = bits.Add64(x382, x379, uint64(x394))
	var x397 uint64
	var x398 uint64
	x397, x398 = bits.Add64(x380, x377, uint64(x396))
	x399 := (x398 + x378)
	var x400 uint64
	var x401 uint64
	x400, x401 = bits.Add64(x364, x387, uint64(0x0))
	var x402 uint64
	var x403 uint64
	x402, x403 = bits.Add64(x366, x389, uint64(x401))
	var x404 uint64
	var x405 uint64
	x404, x405 = bits.Add64(x368, x391, uint64(x403))
	var x406 uint64
	var x407 uint64
	x406, x407 = bits.Add64(x370, x393, uint64(x405))
	var x408 uint64
	var x409 uint64
	x408, x409 = bits.Add64(x372, x395, uint64(x407))
	var x410 uint64
	var x411 uint64
	x410, x411 = bits.Add64(x374, x397, uint64(x409))
	var x412 uint64
	var x413 uint64
	x412, x413 = bits.Add64(x376, x399, uint64(x411))
	var x414 uint64
	_, x414 = bits.Mul64(x400, 0x89f3fffcfffcfffd)
	var x416 uint64
	var x417 uint64
	x417, x416 = bits.Mul64(x414, 0x1a0111ea397fe69a)
	var x418 uint64
	var x419 uint64
	x419, x418 = bits.Mul64(x414, 0x4b1ba7b6434bacd7)
	var x420 uint64
	var x421 uint64
	x421, x420 = bits.Mul64(x414, 0x64774b84f38512bf)
	var x422 uint64
	var x423 uint64
	x423, x422 = bits.Mul64(x414, 0x6730d2a0f6b0f624)
	var x424 uint64
	var x425 uint64
	x425, x424 = bits.Mul64(x414, 0x1eabfffeb153ffff)
	var x426 uint64
	var x427 uint64
	x427, x426 = bits.Mul64(x414, 0xb9feffffffffaaab)
	var x428 uint64
	var x429 uint64
	x428, x429 = bits.Add64(x427, x424, uint64(0x0))
	var x430 uint64
	var x431 uint64
	x430, x431 = bits.Add64(x425, x422, uint64(x429))
	var x432 uint64
	var x433 uint64
	x432, x433 = bits.Add64(x423, x420, uint64(x431))
	var x434 uint64
	var x435 uint64
	x434, x435 = bits.Add64(x421, x418, uint64(x433))
	var x436 uint64
	var x437 uint64
	x436, x437 = bits.Add64(x419, x416, uint64(x435))
	x438 := (x437 + x417)
	var x440 uint64
	_, x440 = bits.Add64(x400, x426, uint64(0x0))
	var x441 uint64
	var x442 uint64
	x441, x442 = bits.Add64(x402, x428, uint64(x440))
	var x443 uint64
	var x444 uint64
	x443, x444 = bits.Add64(x404, x430, uint64(x442))
	var x445 uint64
	var x446 uint64
	x445, x446 = bits.Add64(x406, x432, uint64(x444))
	var x447 uint64
	var x448 uint64
	x447, x448 = bits.Add64(x408, x434, uint64(x446))
	var x449 uint64
	var x450 uint64
	x449, x450 = bits.Add64(x410, x436, uint64(x448))
	var x451 uint64
	var x452 uint64
	x451, x452 = bits.Add64(x412, x438, uint64(x450))
	x453 := (x452 + x413)
	var x454 uint64
	var x455 uint64
	x454, x455 = bits.Sub64(x441, 0xb9feffffffffaaab, uint64(uint64(0x0)))
	var x456 uint64
	var x457 uint64
	x456, x457 = bits.Sub64(x443, 0x1eabfffeb153ffff, uint64(x455))
	var x458 uint64
	var x459 uint64
	x458, x459 = bits.Sub64(x445, 0x6730d2a0f6b0f624, uint64(x457))
	var x460 uint64
	var x461 uint64
	x460, x461 = bits.Sub64(x447, 0x64774b84f38512bf, uint64(x459))
	var x462 uint64
	var x463 uint64
	x462, x463 = bits.Sub64(x449, 0x4b1ba7b6434bacd7, uint64(x461))
	var x464 uint64
	var x465 uint64
	x464, x465 = bits.Sub64(x451, 0x1a0111ea397fe69a, uint64(x463))
	var x467 uint64
	_, x467 = bits.Sub64(x453, uint64(0x0), uint64(x465))
	var x468 uint64
	fiatFpMontCmovznzU64(&x468, x467, x454, x441)
	var x469 uint64
	fiatFpMontCmovznzU64(&x469, x467, x456, x443)
	var x470 uint64
	fiatFpMontCmovznzU64(&x470, x467, x458, x445)
	var x471 uint64
	fiatFpMontCmovznzU64(&x471, x467, x460, x447)
	var x472 uint64
	fiatFpMontCmovznzU64(&x472, x467, x462, x449)
	var x473 uint64
	fiatFpMontCmovznzU64(&x473, x467, x464, x451)
	out1[0] = x468
	out1[1] = x469
	out1[2] = x470
	out1[3] = x471
	out1[4] = x472
	out1[5] = x473
}

// The function fiatFpMontSquare squares a field element in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
//   0 ≤ eval out1 < m
//
// Input Bounds:
//   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func fiatFpMontSquare(out1 *[6]uint64, arg1 *[6]uint64) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x6, arg1[5])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x6, arg1[4])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x6, arg1[3])
	var x13 uint64
	var x14 uint64
	x14, x13 = bits.Mul64(x6, arg1[2])
	var x15 uint64
	var x16 uint64
	x16, x15 = bits.Mul64(x6, arg1[1])
	var x17 uint64
	var x18 uint64
	x18, x17 = bits.Mul64(x6, arg1[0])
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Add64(x18, x15, uint64(0x0))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Add64(x16, x13, uint64(x20))
	var x23 uint64
	var x24 uint64
	x23, x24 = bits.Add64(x14, x11, uint64(x22))
	var x25 uint64
	var x26 uint64
	x25, x26 = bits.Add64(x12, x9, uint64(x24))
	var x27 uint64
	var x28 uint64
	x27, x28 = bits.Add64(x10, x7, uint64(x26))
	x29 := (x28 + x8)
	var x30 uint64
	_, x30 = bits.Mul64(x17, 0x89f3fffcfffcfffd)
	var x32 uint64
	var x33 uint64
	x33, x32 = bits.Mul64(x30, 0x1a0111ea397fe69a)
	var x34 uint64
	var x35 uint64
	x35, x34 = bits.Mul64(x30, 0x4b1ba7b6434bacd7)
	var x36 uint64
	var x37 uint64
	x37, x36 = bits.Mul64(x30, 0x64774b84f38512bf)
	var x38 uint64
	var x39 uint64
	x39, x38 = bits.Mul64(x30, 0x6730d2a0f6b0f624)
	var x40 uint64
	var x41 uint64
	x41, x40 = bits.Mul64(x30, 0x1eabfffeb153ffff)
	var x42 uint64
	var x43 uint64
	x43, x42 = bits.Mul64(x30, 0xb9feffffffffaaab)
	var x44 uint64
	var x45 uint64
	x44, x45 = bits.Add64(x43, x40, uint64(0x0))
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64(x41, x38, uint64(x45))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x39, x36, uint64(x47))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x37, x34, uint64(x49))
	var x52 uint64
	var x53 uint64
	x52, x53 = bits.Add64(x35, x32, uint64(x51))
	x54 := (x53 + x33)
	var x56 uint64
	_, x56 = bits.Add64(x17, x42, uint64(0x0))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x19, x44, uint64(x56))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x21, x46, uint64(x58))
	var x61 uint64
	var x62 uint64
	x61, x62 = bits.Add64(x23, x48, uint64(x60))
	var x63 uint64
	var x64 uint64
	x63, x64 = bits.Add64(x25, x50, uint64(x62))
	var x65 uint64
	var x66 uint64
	x65, x66 = bits.Add64(x27, x52, uint64(x64))
	var x67 uint64
	var x68 uint64
	x67, x68 = bits.Add64(x29, x54, uint64(x66))
	var x69 uint64
	var x70 uint64
	x70, x69 = bits.Mul64(x1, arg1[5])
	var x71 uint64
	var x72 uint64
	x72, x71 = bits.Mul64(x1, arg1[4])
	var x73 uint64
	var x74 uint64
	x74, x73 = bits.Mul64(x1, arg1[3])
	var x75 uint64
	var x76 uint64
	x76, x75 = bits.Mul64(x1, arg1[2])
	var x77 uint64
	var x78 uint64
	x78, x77 = bits.Mul64(x1, arg1[1])
	var x79 uint64
	var x80 uint64
	x80, x79 = bits.Mul64(x1, arg1[0])
	var x81 uint64
	var x82 uint64
	x81, x82 = bits.Add64(x80, x77, uint64(0x0))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x78, x75, uint64(x82))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x76, x73, uint64(x84))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x74, x71, uint64(x86))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x72, x69, uint64(x88))
	x91 := (x90 + x70)
	var x92 uint64
	var x93 uint64
	x92, x93 = bits.Add64(x57, x79, uint64(0x0))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x59, x81, uint64(x93))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x61, x83, uint64(x95))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x63, x85, uint64(x97))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x65, x87, uint64(x99))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x67, x89, uint64(x101))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Add64(x68, x91, uint64(x103))
	var x106 uint64
	_, x106 = bits.Mul64(x92, 0x89f3fffcfffcfffd)
	var x108 uint64
	var x109 uint64
	x109, x108 = bits.Mul64(x106, 0x1a0111ea397fe69a)
	var x110 uint64
	var x111 uint64
	x111, x110 = bits.Mul64(x106, 0x4b1ba7b6434bacd7)
	var x112 uint64
	var x113 uint64
	x113, x112 = bits.Mul64(x106, 0x64774b84f38512bf)
	var x114 uint64
	var x115 uint64
	x115, x114 = bits.Mul64(x106, 0x6730d2a0f6b0f624)
	var x116 uint64
	var x117 uint64
	x117, x116 = bits.Mul64(x106, 0x1eabfffeb153ffff)
	var x118 uint64
	var x119 uint64
	x119, x118 = bits.Mul64(x106, 0xb9feffffffffaaab)
	var x120 uint64
	var x121 uint64
	x120, x121 = bits.Add64(x119, x116, uint64(0x0))
	var x122 uint64
	var x123 uint64
	x122, x123 = bits.Add64(x117, x114, uint64(x121))
	var x124 uint64
	var x125 uint64
	x124, x125 = bits.Add64(x115, x112, uint64(x123))
	var x126 uint64
	var x127 uint64
	x126, x127 = bits.Add64(x113, x110, uint64(x125))
	var x128 uint64
	var x129 uint64
	x128, x129 = bits.Add64(x111, x108, uint64(x127))
	x130 := (x129 + x109)
	var x132 uint64
	_, x132 = bits.Add64(x92, x118, uint64(0x0))
	var x133 uint64
	var x134 uint64
	x133, x134 = bits.Add64(x94, x120, uint64(x132))
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x96, x122, uint64(x134))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x98, x124, uint64(x136))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x100, x126, uint64(x138))
	var x141 uint64
	var x142 uint64
	x141, x142 = bits.Add64(x102, x128, uint64(x140))
	var x143 uint64
	var x144 uint64
	x143, x144 = bits.Add64(x104, x130, uint64(x142))
	x145 := (x144 + x105)
	var x146 uint64
	var x147 uint64
	x147, x146 = bits.Mul64(x2, arg1[5])
	var x148 uint64
	var x149 uint64
	x149, x148 = bits.Mul64(x2, arg1[4])
	var x150 uint64
	var x151 uint64
	x151, x150 = bits.Mul64(x2, arg1[3])
	var x152 uint64
	var x153 uint64
	x153, x152 = bits.Mul64(x2, arg1[2])
	var x154 uint64
	var x155 uint64
	x155, x154 = bits.Mul64(x2, arg1[1])
	var x156 uint64
	var x157 uint64
	x157, x156 = bits.Mul64(x2, arg1[0])
	var x158 uint64
	var x159 uint64
	x158, x159 = bits.Add64(x157, x154, uint64(0x0))
	var x160 uint64
	var x161 uint64
	x160, x161 = bits.Add64(x155, x152, uint64(x159))
	var x162 uint64
	var x163 uint64
	x162, x163 = bits.Add64(x153, x150, uint64(x161))
	var x164 uint64
	var x165 uint64
	x164, x165 = bits.Add64(x151, x148, uint64(x163))
	var x166 uint64
	var x167 uint64
	x166, x167 = bits.Add64(x149, x146, uint64(x165))
	x168 := (x167 + x147)
	var x169 uint64
	var x170 uint64
	x169, x170 = bits.Add64(x133, x156, uint64(0x0))
	var x171 uint64
	var x172 uint64
	x171, x172 = bits.Add64(x135, x158, uint64(x170))
	var x173 uint64
	var x174 uint64
	x173, x174 = bits.Add64(x137, x160, uint64(x172))
	var x175 uint64
	var x176 uint64
	x175, x176 = bits.Add64(x139, x162, uint64(x174))
	var x177 uint64
	var x178 uint64
	x177, x178 = bits.Add64(x141, x164, uint64(x176))
	var x179 uint64
	var x180 uint64
	x179, x180 = bits.Add64(x143, x166, uint64(x178))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x145, x168, uint64(x180))
	var x183 uint64
	_, x183 = bits.Mul64(x169, 0x89f3fffcfffcfffd)
	var x185 uint64
	var x186 uint64
	x186, x185 = bits.Mul64(x183, 0x1a0111ea397fe69a)
	var x187 uint64
	var x188 uint64
	x188, x187 = bits.Mul64(x183, 0x4b1ba7b6434bacd7)
	var x189 uint64
	var x190 uint64
	x190, x189 = bits.Mul64(x183, 0x64774b84f38512bf)
	var x191 uint64
	var x192 uint64
	x192, x191 = bits.Mul64(x183, 0x6730d2a0f6b0f624)
	var x193 uint64
	var x194 uint64
	x194, x193 = bits.Mul64(x183, 0x1eabfffeb153ffff)
	var x195 uint64
	var x196 uint64
	x196, x195 = bits.Mul64(x183, 0xb9feffffffffaaab)
	var x197 uint64
	var x198 uint64
	x197, x198 = bits.Add64(x196, x193, uint64(0x0))
	var x199 uint64
	var x200 uint64
	x199, x200 = bits.Add64(x194, x191, uint64(x198))
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x192, x189, uint64(x200))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x190, x187, uint64(x202))
	var x205 uint64
	var x206 uint64
	x205, x206 = bits.Add64(x188, x185, uint64(x204))
	x207 := (x206 + x186)
	var x209 uint64
	_, x209 = bits.Add64(x169, x195, uint64(0x0))
	var x210 uint64
	var x211 uint64
	x210, x211 = bits.Add64(x171, x197, uint64(x209))
	var x212 uint64
	var x213 uint64
	x212, x213 = bits.Add64(x173, x199, uint64(x211))
	var x214 uint64
	var x215 uint64
	x214, x215 = bits.Add64(x175, x201, uint64(x213))
	var x216 uint64
	var x217 uint64
	x216, x217 = bits.Add64(x177, x203, uint64(x215))
	var x218 uint64
	var x219 uint64
	x218, x219 = bits.Add64(x179, x205, uint64(x217))
	var x220 uint64
	var x221 uint64
	x220, x221 = bits.Add64(x181, x207, uint64(x219))
	x222 := (x221 + x182)
	var x223 uint64
	var x224 uint64
	x224, x223 = bits.Mul64(x3, arg1[5])
	var x225 uint64
	var x226 uint64
	x226, x225 = bits.Mul64(x3, arg1[4])
	var x227 uint64
	var x228 uint64
	x228, x227 = bits.Mul64(x3, arg1[3])
	var x229 uint64
	var x230 uint64
	x230, x229 = bits.Mul64(x3, arg1[2])
	var x231 uint64
	var x232 uint64
	x232, x231 = bits.Mul64(x3, arg1[1])
	var x233 uint64
	var x234 uint64
	x234, x233 = bits.Mul64(x3, arg1[0])
	var x235 uint64
	var x236 uint64
	x235, x236 = bits.Add64(x234, x231, uint64(0x0))
	var x237 uint64
	var x238 uint64
	x237, x238 = bits.Add64(x232, x229, uint64(x236))
	var x239 uint64
	var x240 uint64
	x239, x240 = bits.Add64(x230, x227, uint64(x238))
	var x241 uint64
	var x242 uint64
	x241, x242 = bits.Add64(x228, x225, uint64(x240))
	var x243 uint64
	var x244 uint64
	x243, x244 = bits.Add64(x226, x223, uint64(x242))
	x245 := (x244 + x224)
	var x246 uint64
	var x247 uint64
	x246, x247 = bits.Add64(x210, x233, uint64(0x0))
	var x248 uint64
	var x249 uint64
	x248, x249 = bits.Add64(x212, x235, uint64(x247))
	var x250 uint64
	var x251 uint64
	x250, x251 = bits.Add64(x214, x237, uint64(x249))
	var x252 uint64
	var x253 uint64
	x252, x253 = bits.Add64(x216, x239, uint64(x251))
	var x254 uint64
	var x255 uint64
	x254, x255 = bits.Add64(x218, x241, uint64(x253))
	var x256 uint64
	var x257 uint64
	x256, x257 = bits.Add64(x220, x243, uint64(x255))
	var x258 uint64
	var x259 uint64
	x258, x259 = bits.Add64(x222, x245, uint64(x257))
	var x260 uint64
	_, x260 = bits.Mul64(x246, 0x89f3fffcfffcfffd)
	var x262 uint64
	var x263 uint64
	x263, x262 = bits.Mul64(x260, 0x1a0111ea397fe69a)
	var x264 uint64
	var x265 uint64
	x265, x264 = bits.Mul64(x260, 0x4b1ba7b6434bacd7)
	var x266 uint64
	var x267 uint64
	x267, x266 = bits.Mul64(x260, 0x64774b84f38512bf)
	var x268 uint64
	var x269 uint64
	x269, x268 = bits.Mul64(x260, 0x6730d2a0f6b0f624)
	var x270 uint64
	var x271 uint64
	x271, x270 = bits.Mul64(x260, 0x1eabfffeb153ffff)
	var x272 uint64
	var x273 uint64
	x273, x272 = bits.Mul64(x260, 0xb9feffffffffaaab)
	var x274 uint64
	var x275 uint64
	x274, x275 = bits.Add64(x273, x270, uint64(0x0))
	var x276 uint64
	var x277 uint64
	x276, x277 = bits.Add64(x271, x268, uint64(x275))
	var x278 uint64
	var x279 uint64
	x278, x279 = bits.Add64(x269, x266, uint64(x277))
	var x280 uint64
	var x281 uint64
	x280, x281 = bits.Add64(x267, x264, uint64(x279))
	var x282 uint64
	var x283 uint64
	x282, x283 = bits.Add64(x265, x262, uint64(x281))
	x284 := (x283 + x263)
	var x286 uint64
	_, x286 = bits.Add64(x246, x272, uint64(0x0))
	var x287 uint64
	var x288 uint64
	x287, x288 = bits.Add64(x248, x274, uint64(x286))
	var x289 uint64
	var x290 uint64
	x289, x290 = bits.Add64(x250, x276, uint64(x288))
	var x291 uint64
	var x292 uint64
	x291, x292 = bits.Add64(x252, x278, uint64(x290))
	var x293 uint64
	var x294 uint64
	x293, x294 = bits.Add64(x254, x280, uint64(x292))
	var x295 uint64
	var x296 uint64
	x295, x296 = bits.Add64(x256, x282, uint64(x294))
	var x297 uint64
	var x298 uint64
	x297, x298 = bits.Add64(x258, x284, uint64(x296))
	x299 := (x298 + x259)
	var x300 uint64
	var x301 uint64
	x301, x300 = bits.Mul64(x4, arg1[5])
	var x302 uint64
	var x303 uint64
	x303, x302 = bits.Mul64(x4, arg1[4])
	var x304 uint64
	var x305 uint64
	x305, x304 = bits.Mul64(x4, arg1[3])
	var x306 uint64
	var x307 uint64
	x307, x306 = bits.Mul64(x4, arg1[2])
	var x308 uint64
	var x309 uint64
	x309, x308 = bits.Mul64(x4, arg1[1])
	var x310 uint64
	var x311 uint64
	x311, x310 = bits.Mul64(x4, arg1[0])
	var x312 uint64
	var x313 uint64
	x312, x313 = bits.Add64(x311, x308, uint64(0x0))
	var x314 uint64
	var x315 uint64
	x314, x315 = bits.Add64(x309, x306, uint64(x313))
	var x316 uint64
	var x317 uint64
	x316, x317 = bits.Add64(x307, x304, uint64(x315))
	var x318 uint64
	var x319 uint64
	x318, x319 = bits.Add64(x305, x302, uint64(x317))
	var x320 uint64
	var x321 uint64
	x320, x321 = bits.Add64(x303, x300, uint64(x319))
	x322 := (x321 + x301)
	var x323 uint64
	var x324 uint64
	x323, x324 = bits.Add64(x287, x310, uint64(0x0))
	var x325 uint64
	var x326 uint64
	x325, x326 = bits.Add64(x289, x312, uint64(x324))
	var x327 uint64
	var x328 uint64
	x327, x328 = bits.Add64(x291, x314, uint64(x326))
	var x329 uint64
	var x330 uint64
	x329, x330 = bits.Add64(x293, x316, uint64(x328))
	var x331 uint64
	var x332 uint64
	x331, x332 = bits.Add64(x295, x318, uint64(x330))
	var x333 uint64
	var x334 uint64
	x333, x334 = bits.Add64(x297, x320, uint64(x332))
	var x335 uint64
	var x336 uint64
	x335, x336 = bits.Add64(x299, x322, uint64(x334))
	var x337 uint64
	_, x337 = bits.Mul64(x323, 0x89f3fffcfffcfffd)
	var x339 uint64
	var x340 uint64
	x340, x339 = bits.Mul64(x337, 0x1a0111ea397fe69a)
	var x341 uint64
	var x342 uint64
	x342, x341 = bits.Mul64(x337, 0x4b1ba7b6434bacd7)
	var x343 uint64
	var x344 uint64
	x344, x343 = bits.Mul64(x337, 0x64774b84f38512bf)
	var x345 uint64
	var x346 uint64
	x346, x345 = bits.Mul64(x337, 0x6730d2a0f6b0f624)
	var x347 uint64
	var x348 uint64
	x348, x347 = bits.Mul64(x337, 0x1eabfffeb153ffff)
	var x349 uint64
	var x350 uint64
	x350, x349 = bits.Mul64(x337, 0xb9feffffffffaaab)
	var x351 uint64
	var x352 uint64
	x351, x352 = bits.Add64(x350, x347, uint64(0x0))
	var x353 uint64
	var x354 uint64
	x353, x354 = bits.Add64(x348, x345, uint64(x352))
	var x355 uint64
	var x356 uint64
	x355, x356 = bits.Add64(x346, x343, uint64(x354))
	var x357 uint64
	var x358 uint64
	x357, x358 = bits.Add64(x344, x341, uint64(x356))
	var x359 uint64
	var x360 uint64
	x359, x360 = bits.Add64(x342, x339, uint64(x358))
	x361 := (x360 + x340)
	var x363 uint64
	_, x363 = bits.Add64(x323, x349, uint64(0x0))
	var x364 uint64
	var x365 uint64
	x364, x365 = bits.Add64(x325, x351, uint64(x363))
	var x366 uint64
	var x367 uint64
	x366, x367 = bits.Add64(x327, x353, uint64(x365))
	var x368 uint64
	var x369 uint64
	x368, x369 = bits.Add64(x329, x355, uint64(x367))
	var x370 uint64
	var x371 uint64
	x370, x371 = bits.Add64(x331, x357, uint64(x369))
	var x372 uint64
	var x373 uint64
	x372, x373 = bits.Add64(x333, x359, uint64(x371))
	var x374 uint64
	var x375 uint64
	x374, x375 = bits.Add64(x335, x361, uint64(x373))
	x376 := (x375 + x336)
	var x377 uint64
	var x378 uint64
	x378, x377 = bits.Mul64(x5, arg1[5])
	var x379 uint64
	var x380 uint64
	x380, x379 = bits.Mul64(x5, arg1[4])
	var x381 uint64
	var x382 uint64
	x382, x381 = bits.Mul64(x5, arg1[3])
	var x383 uint64
	var x384 uint64
	x384, x383 = bits.Mul64(x5, arg1[2])
	var x385 uint64
	var x386 uint64
	x386, x385 = bits.Mul64(x5, arg1[1])
	var x387 uint64
	var x388 uint64
	x388, x387 = bits.Mul64(x5, arg1[0])
	var x389 uint64
	var x390 uint64
	x389, x390 = bits.Add64(x388, x385, uint64(0x0))
	var x391 uint64
	var x392 uint64
	x391, x392 = bits.Add64(x386, x383, uint64(x390))
	var x393 uint64
	var x394 uint64
	x393, x394 = bits.Add64(x384, x381, uint64(x392))
	var x395 uint64
	var x396 uint64
	x395, x396 = bits.Add64(x382, x379, uint64(x394))
	var x397 uint64
	var x398 uint64
	x397, x398 = bits.Add64(x380, x377, uint64(x396))
	x399 := (x398 + x378)
	var x400 uint64
	var x401 uint64
	x400, x401 = bits.Add64(x364, x387, uint64(0x0))
	var x402 uint64
	var x403 uint64
	x402, x403 = bits.Add64(x366, x389, uint64(x401))
	var x404 uint64
	var x405 uint64
	x404, x405 = bits.Add64(x368, x391, uint64(x403))
	var x406 uint64
	var x407 uint64
	x406, x407 = bits.Add64(x370, x393, uint64(x405))
	var x408 uint64
	var x409 uint64
	x408, x409 = bits.Add64(x372, x395, uint64(x407))
	var x410 uint64
	var x411 uint64
	x410, x411 = bits.Add64(x374, x397, uint64(x409))
	var x412 uint64
	var x413 uint64
	x412, x413 = bits.Add64(x376, x399, uint64(x411))
	var x414 uint64
	_, x414 = bits.Mul64(x400, 0x89f3fffcfffcfffd)
	var x416 uint64
	var x417 uint64
	x417, x416 = bits.Mul64(x414, 0x1a0111ea397fe69a)
	var x418 uint64
	var x419 uint64
	x419, x418 = bits.Mul64(x414, 0x4b1ba7b6434bacd7)
	var x420 uint64
	var x421 uint64
	x421, x420 = bits.Mul64(x414, 0x64774b84f38512bf)
	var x422 uint64
	var x423 uint64
	x423, x422 = bits.Mul64(x414, 0x6730d2a0f6b0f624)
	var x424 uint64
	var x425 uint64
	x425, x424 = bits.Mul64(x414, 0x1eabfffeb153ffff)
	var x426 uint64
	var x427 uint64
	x427, x426 = bits.Mul64(x414, 0xb9feffffffffaaab)
	var x428 uint64
	var x429 uint64
	x428, x429 = bits.Add64(x427, x424, uint64(0x0))
	var x430 uint64
	var x431 uint64
	x430, x431 = bits.Add64(x425, x422, uint64(x429))
	var x432 uint64
	var x433 uint64
	x432, x433 = bits.Add64(x423, x420, uint64(x431))
	var x434 uint64
	var x435 uint64
	x434, x435 = bits.Add64(x421, x418, uint64(x433))
	var x436 uint64
	var x437 uint64
	x436, x437 = bits.Add64(x419, x416, uint64(x435))
	x438 := (x437 + x417)
	var x440 uint64
	_, x440 = bits.Add64(x400, x426, uint64(0x0))
	var x441 uint64
	var x442 uint64
	x441, x442 = bits.Add64(x402, x428, uint64(x440))
	var x443 uint64
	var x444 uint64
	x443, x444 = bits.Add64(x404, x430, uint64(x442))
	var x445 uint64
	var x446 uint64
	x445, x446 = bits.Add64(x406, x432, uint64(x444))
	var x447 uint64
	var x448 uint64
	x447, x448 = bits.Add64(x408, x434, uint64(x446))
	var x449 uint64
	var x450 uint64
	x449, x450 = bits.Add64(x410, x436, uint64(x448))
	var x451 uint64
	var x452 uint64
	x451, x452 = bits.Add64(x412, x438, uint64(x450))
	x453 := (x452 + x413)
	var x454 uint64
	var x455 uint64
	x454, x455 = bits.Sub64(x441, 0xb9feffffffffaaab, uint64(uint64(0x0)))
	var x456 uint64
	var x457 uint64
	x456, x457 = bits.Sub64(x443, 0x1eabfffeb153ffff, uint64(x455))
	var x458 uint64
	var x459 uint64
	x458, x459 = bits.Sub64(x445, 0x6730d2a0f6b0f624, uint64(x457))
	var x460 uint64
	var x461 uint64
	x460, x461 = bits.Sub64(x447, 0x64774b84f38512bf, uint64(x459))
	var x462 uint64
	var x463 uint64
	x462, x463 = bits.Sub64(x449, 0x4b1ba7b6434bacd7, uint64(x461))
	var x464 uint64
	var x465 uint64
	x464, x465 = bits.Sub64(x451, 0x1a0111ea397fe69a, uint64(x463))
	var x467 uint64
	_, x467 = bits.Sub64(x453, uint64(0x0), uint64(x465))
	var x468 uint64
	fiatFpMontCmovznzU64(&x468, x467, x454, x441)
	var x469 uint64
	fiatFpMontCmovznzU64(&x469, x467, x456, x443)
	var x470 uint64
	fiatFpMontCmovznzU64(&x470, x467, x458, x445)
	var x471 uint64
	fiatFpMontCmovznzU64(&x471, x467, x460, x447)
	var x472 uint64
	fiatFpMontCmovznzU64(&x472, x467, x462, x449)
	var x473 uint64
	fiatFpMontCmovznzU64(&x473, x467, x464, x451)
	out1[0] = x468
	out1[1] = x469
	out1[2] = x470
	out1[3] = x471
	out1[4] = x472
	out1[5] = x473
}
