/* $Id: af88a08a48d082ea06d5236769d8df8add5cb91f $ */
#ifndef TRPATH_INCLUDED
#define TRPATH_INCLUDED

typedef struct Trpath_T *Trpath_T;

#include "bool.h"
#include "types.h"
#include "transcript.h"
#include "list.h"
#include "chrnum.h"
#include "univcoord.h"
#include "intlist.h"
#include "uintlist.h"

#include "intlistpool.h"
#include "uintlistpool.h"
#include "listpool.h"
#include "trpathpool.h"
#include "pathpool.h"

#include "path.h"
#include "method.h"


#define T Trpath_T
struct T {
  bool tplusp;

  Trnum_T trnum;
  Trcoord_T troffset;
  Trcoord_T trhigh;

  /* Note: We cannot have ref_nmismatches, because we don't have an
     alt version of transcriptome */
  Uintlist_T trdiagonals;
  Intlist_T endpoints;
  Intlist_T nmismatches;
  List_T junctions;
};


extern void
Trpath_free (T *old, Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
	     Listpool_T listpool, Trpathpool_T trpathpool, Pathpool_T pathpool);

extern T
Trpath_create (Intlist_T endpoints, Uintlist_T trdiagonals, Intlist_T nmismatches,
	       List_T junctions, bool tplusp,
	       Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
	       Trpathpool_T trpathpool);

extern T
Trpath_new_for_tstart_extension (Trcoord_T univdiagonal, int tstart, int tend, int nmismatches,
				 bool tplusp, Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
				 Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
				 Trpathpool_T trpathpool);

extern T
Trpath_new_for_tend_extension (Trcoord_T univdiagonal, int tstart, int tend, int nmismatches,
			       bool tplusp, Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
			       Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			       Trpathpool_T trpathpool);

extern T
Trpath_new_from_ends (Trcoord_T trdiagonal5, int tstart5, int tend5,
		      Trcoord_T trdiagonal3, int tstart3, int tend3,
		      bool tplusp, Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
		      Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		      Listpool_T listpool, Trpathpool_T trpathpool);

extern T
Trpath_new_exact (Trcoord_T trdiagonal, int tstart, int tend, int nmismatches,
		  bool tplusp, Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
		  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		  Trpathpool_T trpathpool);

extern void
Trpath_print (T this);

extern T
Trpath_reverse (T this, bool expect_fwd_p);


extern bool
Trpath_endpoints_acceptable_p (Intlist_T endpoints, List_T junctions);

extern Path_T
Trpath_convert_to_path_geneplus (T trpath, int *exonbounds, Chrpos_T *exonstarts, int nexons,
				 Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
				 bool tplusp, int sensedir, int querylength,
				 Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
				 Listpool_T listpool, Pathpool_T pathpool, Method_T method);

extern Path_T
Trpath_convert_to_path_geneminus (T trpath, int *exonbounds, Chrpos_T *exonstarts, int nexons,
				  Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
				  bool tplusp, int sensedir, int querylength,
				  Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
				  Listpool_T listpool, Pathpool_T pathpool, Method_T method);


#undef T
#endif
