/* $Id: 255de793235266d734fc9af1b61ce124c30a746b $ */
#ifndef TRPATH_SOLVE_INCLUDED
#define TRPATH_SOLVE_INCLUDED

#include "bool.h"
#include "types.h"
#include "trpath.h"
#include "path.h"
#include "method.h"

#include "trdiagdef.h"
#include "trdiag.h"

#include "indel.h"
#include "compress.h"
#include "genomebits.h"
#include "ef64.h"

#include "intlistpool.h"
#include "univcoord.h"
#include "uintlistpool.h"
#include "listpool.h"
#include "trpathpool.h"
#include "pathpool.h"
#include "vectorpool.h"
#include "transcriptpool.h"



#define T Trpath_T

extern Path_T
Trpath_solve_from_diagonals (int *found_score, bool *found_transcriptp,
			     Trcoord_T middle_trdiagonal,
			     int middle_trdiagonal_qstart, int middle_trdiagonal_qend,
			     int middle_nmismatches,
			     Trdiag_T qstart_trdiag, Trdiag_T qend_trdiag,
			     bool tplusp, int querylength,
			     Compress_T query_compress_tr,
			     Compress_T query_compress_fwd, Compress_T query_compress_rev,
			     int *mismatch_positions_alloc,
			     Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
			     Chrnum_T chrnum, bool geneplusp, bool want_lowest_coordinate_p,
			     Indelinfo_T indelinfo, int nmismatches_allowed,
			     int max_insertionlen, int max_deletionlen,
			     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			     Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
			     Trpathpool_T trpathpool, Pathpool_T pathpool,
			     Vectorpool_T vectorpool, Transcriptpool_T transcriptpool,
			     Method_T method);

extern Path_T
Trpath_solve_from_ends (int *found_score, bool *found_transcriptp,
			Univcoord_T trdiagonal_i, int pos5_0, int pos3_0,
			Univcoord_T trdiagonal_j, int pos5_1, int pos3_1,
			bool tplusp, int querylength, Compress_T query_compress_tr,
			Compress_T query_compress_fwd, Compress_T query_compress_rev,
			Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
			Chrnum_T chrnum, bool gplusp, bool want_lowest_coordinate_p,
			Indelinfo_T indelinfo, int nmismatches_allowed,
			int max_insertionlen, int max_deletionlen,
			Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
			Trpathpool_T trpathpool, Pathpool_T pathpool,
			Vectorpool_T vectorpool, Transcriptpool_T transcriptpool,
			Method_T method);


extern Path_T
Trpath_solve_exact (int *found_score, bool *found_transcriptp,
		    Univcoord_T trdiagonal, int pos5, int pos3,
		    bool tplusp, int querylength, Compress_T query_compress_tr,
		    Compress_T query_compress_fwd, Compress_T query_compress_rev,
		    Trnum_T trnum, Trcoord_T troffset, Trcoord_T trhigh,
		    Chrnum_T chrnum, bool geneplusp, int nmismatches_allowed,
		    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		    Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
		    Trpathpool_T trpathpool, Pathpool_T pathpool,
		    Vectorpool_T vectorpool, Transcriptpool_T transcriptpool,
		    Method_T method);


extern void
Trpath_solve_setup (Genomebits_T transcriptomebits_in,
		    Transcriptome_T transcriptome_in,
		    EF64_T chromosome_ef64_in);

#undef T
#endif


