/* $Id: 3ff696719ca016e363a46019da8f877bb7ce878b $ */
#ifndef TRANSCRIPTOME_SEARCH_INCLUDED
#define TRANSCRIPTOME_SEARCH_INCLUDED

#include "bool.h"
#include "list.h"
#include "indexdb.h"
#include "ef64.h"

#include "iit-read-univ.h"	/* For transcript_iit */
#include "transcriptome.h"
#include "compress.h"
#include "genomebits.h"

#include "method.h"
#include "stage1hr.h"
#include "indel.h"
#include "mergeinfo.h"

#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "trpathpool.h"
#include "pathpool.h"
#include "transcriptpool.h"
#include "hitlistpool.h"


extern void
Transcriptome_search_complete (int *found_score, bool *found_transcriptp,

			       List_T *unextended_sense_paths_gplus, List_T *unextended_sense_paths_gminus,
			       List_T *unextended_antisense_paths_gplus, List_T *unextended_antisense_paths_gminus,

			       List_T *sense_paths_gplus, List_T *sense_paths_gminus,
			       List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,
			       
#if 0
			       Trcoord_T *tplus_positions_5, int n_tplus_positions_5, int tplus_diagterm_5,
			       Trcoord_T *tminus_positions_5, int n_tminus_positions_5, int tminus_diagterm_5,
			       Trcoord_T *tplus_positions_3, int n_tplus_positions_3, int tplus_diagterm_3, 
			       Trcoord_T *tminus_positions_3, int n_tminus_positions_3, int tminus_diagterm_3,
#endif

			       Stage1_T stage1, char *queryuc_ptr, int querylength, Indelinfo_T indelinfo, Mergeinfo_uint4_T mergeinfo,
			       Trcoord_T **tplus_stream_array, int *tplus_streamsize_array, int *tplus_diagterm_array,
			       Trcoord_T **tminus_stream_array, int *tminus_streamsize_array, int *tminus_diagterm_array,
			       int *mismatch_positions_alloc, Compress_T query_compress_fwd, Compress_T query_compress_rev,
			       int nmismatches_allowed,
			       Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			       Listpool_T listpool, Trpathpool_T trpathpool, Pathpool_T pathpool,
			       Vectorpool_T vectorpool, Transcriptpool_T transcriptpool, Hitlistpool_T hitlistpool,
			       Method_T method);

extern void
Transcriptome_search_ends (int *found_score, bool *found_transcriptp,

			   List_T *sense_paths_gplus, List_T *sense_paths_gminus,
			   List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,

#if 0
			   Trcoord_T **tplus_positions_5, int *n_tplus_positions_5, int *tplus_diagterm_5,
			   Trcoord_T **tminus_positions_5, int *n_tminus_positions_5, int *tminus_diagterm_5,
			   Trcoord_T **tplus_positions_3, int *n_tplus_positions_3, int *tplus_diagterm_3,
			   Trcoord_T **tminus_positions_3, int *n_tminus_positions_3, int *tminus_diagterm_3,
#endif
			   
			   Stage1_T stage1, char *queryuc_ptr, int querylength, Indelinfo_T indelinfo,
			   Compress_T query_compress_fwd, Compress_T query_compress_rev,
			   int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			   Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
			   Trpathpool_T trpathpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			   Transcriptpool_T transcriptpool, Hitlistpool_T hitlistpool, Method_T method);

extern void
Transcriptome_search_setup (int index1part, int index1interval_in, int index1part_tr_in,
			    Indexdb_T tr_indexdb_in, Transcriptome_T transcriptome_in,
			    EF64_T transcript_ef64_in, Genomebits_T genomebits_in,
			    Genomebits_T genomebits_alt_in, Genomebits_T transcriptomebits_in);

#endif

