/* $Id: dc5a8838b135e401b5e2a80cde15df7fb3dbda6c $ */
#ifndef TRANSCRIPT_REMAP_INCLUDED
#define TRANSCRIPT_REMAP_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "bool.h"
#include "types.h"
#include "chrnum.h"
#include "intlist.h"
#include "univcoord.h"
#include "list.h"
#include "path.h"

#include "uintlistpool.h"
#include "transcriptpool.h"
#include "listpool.h"
#include "vectorpool.h"


extern List_T
Transcript_remap (bool *found_transcriptp,
		  List_T *transcripts, List_T *invalid_transcripts,
		  Intlist_T endpoints, Univcoordlist_T univdiagonals, List_T junctions,
		  int querylength, Chrnum_T chrnum, Univcoord_T chroffset,
		  Uintlistpool_T uintlistpool, Listpool_T listpool,
		  Transcriptpool_T transcriptpool, Vectorpool_T vectorpool,
		  int desired_genestrand, int effective_sensedir,
		  bool extend_qstart_p, bool extend_qend_p, bool repairp);

extern bool
Transcript_remap_matchp (Chrpos_T low_chrpos, Chrpos_T high_chrpos, Chrnum_T chrnum);

extern void
Transcript_remap_setup (Transcriptome_T transcriptome_in,
			IIT_T transcript_map_iit_in);

#endif


