/* $Id$ */
#ifndef REPAIR_INCLUDED
#define REPAIR_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

typedef struct Repair_T *Repair_T;

#include "bool.h"
#include "genomicpos.h"
#include "list.h"

#include "sense.h"
#include "compress.h"
#include "path.h"
#include "transcript.h"

#include "intlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "pathpool.h"
#include "vectorpool.h"
#include "transcriptpool.h"


#define T Repair_T
struct T {
  int transcript_genestrand;
  int tstart_overhang;
  int tend_overhang;
  Chrpos_T tstart_splice_distance;
  Chrpos_T tend_splice_distance;
  List_T transcripts;
};


extern void
Repair_free (T *old);
extern T
Repair_new (int transcript_genestrand,
	    int tstart_overhang, Chrpos_T tstart_splice_distance,
	    int tend_overhang, Chrpos_T tend_splice_distance,
	    Transcript_T transcript, Listpool_T listpool);
extern List_T
Repair_make_unique (List_T repairs, Listpool_T listpool);
extern Path_T
Repair_path (int *found_score, T this, Path_T oldpath, int sensedir,
	     Compress_T query_compress_fwd, Compress_T query_compress_rev,
	     int nmismatches_allowed,
	     Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
	     Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
	     Transcriptpool_T transcriptpool);

#undef T
#endif

