/* $Id: e8a5898af6a88660c1e0fb273821198103887941 $ */
#ifndef PATHPAIR_INCLUDED
#define PATHPAIR_INCLUDED

typedef struct Pathpair_T *Pathpair_T;

#include "path.h"

#include "intlistpool.h"
#include "listpool.h"
#include "pathpool.h"
#include "vectorpool.h"
#include "transcriptpool.h"

#include "bool.h"
#include "univcoord.h"
#include "compress.h"
#include "shortread.h"

#include "stage1hr.h"
#include "knownsplicing.h"
#include "knownindels.h"
#include "spliceendsgen.h"

#include "resulthr.h"
#include "outputtype.h"


#define T Pathpair_T

struct T {
  /* MAPQ scores */
  float mapq_loglik;
  int mapq_score;
  int absmq_score;

#if 0
  int nmismatches;		/* querylength - sum of nmatches */
  int score_eventrim;		/* for storage */
  int alts_status_inside;
#endif

  /* int genestrand; */
  /* int sensedir; */
  /* Chrpos_T insertlength; */
  /* Chrpos_T outerlength; */

  Pairtype_T pairtype;
  int insertlength;
  int pair_relationship;
  int outerlength;

  bool plusp;

  Path_T path5;			/* Always a copy from the original */
  Path_T path3;			/* Always a copy from the original */

  /* For concordant plus reads, L=5, H=3; for minus, L=3, H=5 */
  Path_T pathL;			/* Pointer to path5 or path3 */
  Path_T pathH;			/* Pointer to path5 or path3 */
};


extern bool
Pathpair_insertlength_knownp (T this);

extern bool
Pathpair_outerlength_knownp (T this);

extern void
Pathpair_free (T *old, Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
	       Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool);

extern void
Pathpair_gc (List_T *list, Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
	     Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
	     Hitlistpool_T hitlistpool);

extern bool
Pathpair_transcript_intersectp (Path_T pathL, Path_T pathH);

extern T
Pathpair_new_concordant (Path_T pathL, Path_T pathH, Shortread_T queryseqL, Shortread_T queryseqH, bool plusp,
			 Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
			 Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			 Transcriptpool_T transcriptpool, bool copyLp, bool copyHp);

extern T
Pathpair_new_inner_fusion (Path_T pathL, Path_T pathH, Shortread_T queryseqL, Shortread_T queryseqH, bool plusp,
			   Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
			   Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			   Transcriptpool_T transcriptpool, bool copyLp, bool copyHp);

extern void
Pathpair_resolve (int *found_score_5, int *found_score_3,
		  T this, bool plusp, int genestrand,
		  Compress_T query_compress_L, Compress_T queryL_compress_fwd, Compress_T queryL_compress_rev,
		  Compress_T query_compress_H, Compress_T queryH_compress_fwd, Compress_T queryH_compress_rev,
		  Shortread_T queryseqL, Shortread_T queryseqH, char *queryptrL, char *queryptrH,
		  Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		  Stage1_T stage1L, Stage1_T stage1H, Knownsplicing_T knownsplicing,
		  int nmismatches_allowed_L, int nmismatches_allowed_H,
		  int max_insertionlen_L, int max_insertionlen_H, int max_deletionlen_L, int max_deletionlen_H,
		  Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
		  Listpool_T listpool, Pathpool_T pathpool);

extern int
Pathpair_interval_cmp (const void *x, const void *y);

extern bool
Pathpair_overlap_p (T x, T y);

extern List_T
Pathpair_filter (List_T pathpairs, Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
		 Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		 Hitlistpool_T hitlistpool);

extern bool
Pathpair_print_end_alignment (Filestring_T fp, Result_T result, Resulttype_T resulttype,
			      char initchar, bool firstp, 
			      Shortread_T queryseq, Shortread_T headerseq1, Shortread_T headerseq2,
			      int maxpaths, bool quiet_if_excessive_p, bool invertp, int quality_shift,
			      Listpool_T listpool);

extern bool
Pathpair_print_end_m8 (Filestring_T fp, Result_T result, Resulttype_T resulttype,
		       bool firstp, char *accession,
		       int maxpaths, bool quiet_if_excessive_p, bool invertp,
		       Listpool_T listpool);

extern void
Pathpair_setup (Outputtype_T output_type_in, int expected_pairlength_in, int pairlength_deviation_in);

extern void
Pathpair_pass2_setup (int expected_pairlength_in, int pairlength_deviation_in);

#undef T
#endif

