/* $Id$ */
#ifndef PATH_FUSION_INCLUDED
#define PATH_FUSION_INCLUDED

#include "path.h"

#include "bool.h"
#include "univcoord.h"
#include "compress.h"
#include "genomebits.h"
#include "stage1.h"
#include "knownsplicing.h"

#include "ef64.h"
#include "transcriptome.h"

#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "pathpool.h"
#include "vectorpool.h"
#include "hitlistpool.h"
#include "univdiagpool.h"
#include "transcriptpool.h"


#define T Path_T

extern List_T
Path_fusion_outer_querystart_plus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
				   Knownsplicing_T knownsplicing,
				   Compress_T query_compress_fwd, Compress_T query_compress_rev,
				   int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
				   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
				   Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
				   Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);

extern List_T
Path_fusion_outer_queryend_plus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
				 Knownsplicing_T knownsplicing,
				 Compress_T query_compress_fwd, Compress_T query_compress_rev,
				 int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
				 Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
				 Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
				 Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);

extern List_T
Path_fusion_outer_querystart_minus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
				    Knownsplicing_T knownsplicing,
				    Compress_T query_compress_fwd, Compress_T query_compress_rev,
				    int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
				    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
				    Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
				    Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);


extern List_T
Path_fusion_outer_queryend_minus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
				  Knownsplicing_T knownsplicing,
				  Compress_T query_compress_fwd, Compress_T query_compress_rev,
				  int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
				  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
				  Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
				  Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);

extern T
Path_fusion_inner_qend (int *found_score, T fusion5, T anchor3,
			char *queryptr_main, bool main_plusp, int querylength,
			Chrnum_T main_chrnum, Univcoord_T main_chroffset, Univcoord_T main_chrhigh,
			Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
			Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
			Knownsplicing_T knownsplicing,
			Compress_T query_compress_main, Compress_T query_compress_fwd, Compress_T query_compress_rev,
			int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			Transcriptpool_T transcriptpool);

extern T
Path_fusion_inner_qstart (int *found_score, T fusion3, T anchor5,
			  char *queryptr_main, bool main_plusp, int querylength,
			  Chrnum_T main_chrnum, Univcoord_T main_chroffset, Univcoord_T main_chrhigh,
			  Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			  int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			  Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
			  Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
			  Knownsplicing_T knownsplicing,
			  Compress_T query_compress_main, Compress_T query_compress_fwd, Compress_T query_compress_rev,
			  int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			  Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			  Transcriptpool_T transcriptpool);


extern List_T
Path_fusion_querystart_plus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
			     Knownsplicing_T knownsplicing,
			     Compress_T query_compress_fwd, Compress_T query_compress_rev,
			     int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			     Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			     Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);
extern List_T
Path_fusion_querystart_minus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
			      Knownsplicing_T knownsplicing,
			      Compress_T query_compress_fwd, Compress_T query_compress_rev,
			      int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			      Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			      Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			      Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);

extern List_T
Path_fusion_queryend_plus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
			   Knownsplicing_T knownsplicing,
			   Compress_T query_compress_fwd, Compress_T query_compress_rev,
			   int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			   Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			   Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);

extern List_T
Path_fusion_queryend_minus (int *found_score, T mainpath, Stage1_T stage1, int querylength,
			    Knownsplicing_T knownsplicing,
			    Compress_T query_compress_fwd, Compress_T query_compress_rev,
			    int genestrand,  int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			    Listpool_T listpool, Univdiagpool_T univdiagpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			    Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, int endtrim_allowed);

extern void
Path_fusion_setup (bool *circularp_in, EF64_T chromosome_ef64_in, Univcoord_T genomelength_in,
		   Chrpos_T shortsplicedist_in, Transcriptome_T transcriptome_in);

#undef T
#endif
