/* $Id: method.h 226364 2023-03-07 02:58:57Z twu $ */
#ifndef METHOD_INCLUDED
#define METHOD_INCLUDED

#include "filestring.h"


/* Keep in order of calls to single_read in stage1hr-single.c and paired_read in stage1hr-paired.c */
typedef enum {METHOD_INIT,
	      KMER_EXACT, /* both ends, from Kmer_search_exact */
	      EXT, /* ext, from Extension_search */
	      TR_ENDS, /* from Transcriptome_search_ends */
	      TR_EXT, /* from Tr_extension_search */
	      KMER_APPROX, /* both ends, from Kmer_search_approx */
	      SEGMENT1, /* seg1, from Segment_search_genome */
	      TR_COMPLETE, /* from Transcriptome_search_complete */
	      SEGMENT2, /* seg2, from Segment_search_genome */
	      FUSION}    /* fusion, from path-fusion */ Method_T;

extern char *
Method_string (Method_T method);
extern void
Method_samprint (Filestring_T fp, Method_T method);
extern void
Method_print (Filestring_T fp, Method_T method);

#endif

