#ifndef LOCALDB_READ_INCLUDED
#define LOCALDB_READ_INCLUDED

#include "access.h"
#include "bool.h"
#include "types.h"
#include "univcoord.h"
#include "compress.h"
#include "genome.h"
#include "genomebits.h"
#include "mergeinfo.h"

typedef struct Localdb_T *Localdb_T;
#define T Localdb_T

extern void
Localdb_setup (Genome_T genomecomp_in, Univcoord_T genomelength_in,
	       int index1part_in, int index1interval_in);

extern void
Localdb_free (T *old);

extern T
Localdb_new (char *genomesubdir, char *fileroot,
	     Access_mode_T localdb_access, bool sharedp,
	     bool multiple_sequences_p, bool preload_shared_memory_p, bool unload_shared_memory_p);

extern int
Localdb_get (int *matchlength, int *nmismatches, Univcoord_T *diagonals_alloc,
	     T this, unsigned short *localdb_alloc,
	     int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
	     Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
	     char *queryptr, int pos5, int pos3, int querylength,
	     Univcoord_T low_univdiagonal, Univcoord_T high_univdiagonal,
	     Compress_T query_compress, bool plusp, int genestrand,
	     Genomebits_T genomebits, int nmismatches_allowed, bool salvagep);

#undef T
#endif


