/* $Id: d8d39fe7fb2786a748e91e693f6e91d8784df8ba $ */
#ifndef ALTSPLICE_INCLUDED
#define ALTSPLICE_INCLUDED

typedef struct Altsplice_T *Altsplice_T;

#include "bool.h"
#include "univcoord.h"
#include "pathpool.h"
#include "vectorpool.h"


#define T Altsplice_T
struct T {
  int distal_length;
  double medial_prob;
  double best_distal_prob;

  int best_nmatches;

  int alts_ncoords;
  Univcoord_T *alts_coords;
  int *alts_nmismatches;
  int *alts_ref_nmismatches;
  double *alts_probs;
};


extern void
Altsplice_free (T *old, Pathpool_T pathpool);

extern void
Altsplice_print (T this);

extern T
Altsplice_copy (T old, Pathpool_T pathpool, Vectorpool_T vectorpool);

extern T
Altsplice_new (int distal_length, double medial_prob,
	       Univcoord_T *distal_splice_positions, int *distal_nmismatches,
	       double *distal_probs, int npartners,
	       Pathpool_T pathpool, Vectorpool_T vectorpool);

extern bool
Altsplice_resolve_lower (Univcoord_T *univdiagonal_L, int *nmismatches_L, int *ref_nmismatches_L, double *prob_L,
			 T this, int querylengthL, int querylengthH,
			 Univcoord_T genomicstartH);
extern bool
Altsplice_resolve_higher (Univcoord_T *univdiagonal_H, int *nmismatches_H, int *ref_nmismatches_H, double *prob_H,
			  T this, int querylengthL, int querylengthH,
			  Univcoord_T genomicendL);
extern bool
Altsplice_resolve_both (Univcoord_T *univdiagonal_L, int *nmismatches_L, int *ref_nmismatches_L, double *prob_L,
			Univcoord_T *univdiagonal_H, int *nmismatches_H, int *ref_nmismatches_H, double *prob_H,
			T thisL, T thisH, int querylengthL, int querylengthH);


#undef T
#endif


