
import OpenGL.GL as gl

import numpy

import glitch, glitch.glut
from glitch.limbo.objects import Grid

class Tree(glitch.Node):
    def draw(self, ctx):
        gl.glBegin(gl.GL_LINES)
        gl.glVertex3f(0, 0, 0)
        gl.glVertex3f(0, 1, 0)
        gl.glEnd()

# XXX: Not a very pretty tree. Use an L-system?

def make_tree(depth):
    if depth > 0:
        children = [
            glitch.Translate(y=1, children=[
                glitch.Scale(scale, scale, scale,
                    children=[make_tree(depth - 1)])])
            for (i, scale) in
                zip(xrange(4), numpy.random.uniform(0.7, 0.8, 4))]
    else:
        children = []

    rotation = numpy.random.uniform(-35, 55) / (depth + 1)
    tree = glitch.Rotate(rotation, 0.5, 0, 0.5, children=[
        Tree(children=children)])
    return tree

if __name__ == '__main__':
    grid = glitch.Rotate(90, 1, children=[Grid()])
    tree = glitch.Scale(0.7, 0.3, 0.7, children=[make_tree(4)])
    camera = glitch.glut.GLUTCamera(eye=[2, 1, 2], ref=[0, 0.5, 0],
        children=[grid, tree])
    camera.run()

