# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: operations.proto for package 'gitaly'

require 'grpc'
require 'operations_pb'

module Gitaly
  module OperationService
    # OperationService provides an interface for performing mutating git
    # operations on a repository on behalf of a user. The user's operation is
    # treated as untrusted. Any reference update is thus checked against GitLab's
    # '/allowed' endpoint.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.OperationService'

      # This comment is left unintentionally blank.
      rpc :UserCreateBranch, ::Gitaly::UserCreateBranchRequest, ::Gitaly::UserCreateBranchResponse
      # This comment is left unintentionally blank.
      rpc :UserUpdateBranch, ::Gitaly::UserUpdateBranchRequest, ::Gitaly::UserUpdateBranchResponse
      # UserDeleteBranch force-deletes a single branch in the context of a specific user. It executes
      # hooks and contacts Rails to verify that the user is indeed allowed to delete that branch. The
      # following known error conditions may happen:
      #
      # - Returns `InvalidArgument` in case either the branch name or user are not set.
      # - Returns `FailedPrecondition` in case the branch does not exist.
      # - Returns `OK` with a `PreReceiveError` in case custom hooks refused the update. If the
      #   `gitaly_user_delete_branch_structured_errors` feature flag is enabled this error case will
      #   instead return `PermissionDenied` with either a `CustomHook` or AccessCheck` structured
      #   error.
      # - Returns `FailedPrecondition` in case updating the reference fails because
      #   of a concurrent write to the same reference. If the
      #   `gitaly_user_delete_branch_structured_errors` feature flag is set this error case will
      #   instead return `FailedPrecondition` with a `ReferenceUpdate` structured error.
      rpc :UserDeleteBranch, ::Gitaly::UserDeleteBranchRequest, ::Gitaly::UserDeleteBranchResponse
      # UserCreateTag creates a new tag. This RPC knows to create both lightweight and annotated tags
      # depending on whether a message is set.
      rpc :UserCreateTag, ::Gitaly::UserCreateTagRequest, ::Gitaly::UserCreateTagResponse
      # This comment is left unintentionally blank.
      rpc :UserDeleteTag, ::Gitaly::UserDeleteTagRequest, ::Gitaly::UserDeleteTagResponse
      # UserMergeRef creates a merge commit and updates target_ref to point to that
      # new commit. The first parent of the merge commit (the main line) is taken
      # from first_parent_ref. The second parent is specified by its commit ID in source_sha.
      # If target_ref already exists it will be overwritten.
      rpc :UserMergeToRef, ::Gitaly::UserMergeToRefRequest, ::Gitaly::UserMergeToRefResponse
      # UserMergeBranch tries to merge the given commit into the target branch.
      # The merge commit is created with the given user as author/committer and
      # the given message.
      #
      # This RPC requires confirmation to make any user-visible changes to the
      # repository. The first request sent shall contain details about the
      # requested merge, which will result in a response with the created merge
      # commit ID. Only if a second message with `apply = true` is sent will the
      # merge be applied.
      rpc :UserMergeBranch, stream(::Gitaly::UserMergeBranchRequest), stream(::Gitaly::UserMergeBranchResponse)
      # UserFFBranch tries to perform a fast-forward merge of the given branch to
      # the given commit. If the merge is not a fast-forward merge, the request
      # will fail. The RPC will return an empty response in case updating the
      # reference fails e.g. because of a race.
      rpc :UserFFBranch, ::Gitaly::UserFFBranchRequest, ::Gitaly::UserFFBranchResponse
      # UserCherryPick tries to perform a cherry-pick of a given commit onto a
      # branch.
      rpc :UserCherryPick, ::Gitaly::UserCherryPickRequest, ::Gitaly::UserCherryPickResponse
      # UserCommitFiles builds a commit from a stream of actions and updates the target branch to point to it.
      # UserCommitFilesRequest with a UserCommitFilesRequestHeader must be sent as the first message of the stream.
      # Following that, a variable number of actions can be sent to build a new commit. Each action consists of
      # a header followed by content if used by the action.
      rpc :UserCommitFiles, stream(::Gitaly::UserCommitFilesRequest), ::Gitaly::UserCommitFilesResponse
      # UserRebaseConfirmable rebases the given remote branch onto a target
      # branch. The remote branch may be part of another repository.
      #
      # This RPC requires confirmation to make any user-visible changes to the
      # repository. The first request sent shall contains details about the
      # requested rebase, which will result in a response with the created rebase
      # commit ID. Only if a second message with `apply = true` is sent will the
      # rebase be applied.
      rpc :UserRebaseConfirmable, stream(::Gitaly::UserRebaseConfirmableRequest), stream(::Gitaly::UserRebaseConfirmableResponse)
      # UserRevert tries to perform a revert of a given commit onto a branch.
      rpc :UserRevert, ::Gitaly::UserRevertRequest, ::Gitaly::UserRevertResponse
      # UserSquash squashes a range of commits into a single commit. If
      # successful, it returns the object ID of the newly created squash commit.
      # On error, it returns a gRPC error. Some specific errors will have an
      # embedded UserSquashError such that clients can deduce what exactly has
      # failed.
      rpc :UserSquash, ::Gitaly::UserSquashRequest, ::Gitaly::UserSquashResponse
      # UserApplyPatch applies patches to a given branch.
      rpc :UserApplyPatch, stream(::Gitaly::UserApplyPatchRequest), ::Gitaly::UserApplyPatchResponse
      # UserUpdateSubmodule updates a submodule to point to a new commit.
      rpc :UserUpdateSubmodule, ::Gitaly::UserUpdateSubmoduleRequest, ::Gitaly::UserUpdateSubmoduleResponse
    end

    Stub = Service.rpc_stub_class
  end
end
