// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: repository.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// RepositoryServiceClient is the client API for RepositoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RepositoryServiceClient interface {
	// This comment is left unintentionally blank.
	RepositoryExists(ctx context.Context, in *RepositoryExistsRequest, opts ...grpc.CallOption) (*RepositoryExistsResponse, error)
	// Deprecated: Do not use.
	// RepackIncremental is deprecated in favor of OptimizeRepository.
	RepackIncremental(ctx context.Context, in *RepackIncrementalRequest, opts ...grpc.CallOption) (*RepackIncrementalResponse, error)
	// Deprecated: Do not use.
	// RepackFull is deprecated in favor of OptimizeRepository.
	RepackFull(ctx context.Context, in *RepackFullRequest, opts ...grpc.CallOption) (*RepackFullResponse, error)
	// Deprecated: Do not use.
	// MidxRepack is deprecated in favor of OptimizeRepository.
	MidxRepack(ctx context.Context, in *MidxRepackRequest, opts ...grpc.CallOption) (*MidxRepackResponse, error)
	// Deprecated: Do not use.
	// GarbageCollect is deprecated in favor of OptimizeRepository.
	GarbageCollect(ctx context.Context, in *GarbageCollectRequest, opts ...grpc.CallOption) (*GarbageCollectResponse, error)
	// Deprecated: Do not use.
	// WriteCommitGraph is deprecated in favor of OptimizeRepository.
	WriteCommitGraph(ctx context.Context, in *WriteCommitGraphRequest, opts ...grpc.CallOption) (*WriteCommitGraphResponse, error)
	// This comment is left unintentionally blank.
	RepositorySize(ctx context.Context, in *RepositorySizeRequest, opts ...grpc.CallOption) (*RepositorySizeResponse, error)
	// This comment is left unintentionally blank.
	ApplyGitattributes(ctx context.Context, in *ApplyGitattributesRequest, opts ...grpc.CallOption) (*ApplyGitattributesResponse, error)
	// FetchRemote fetches references from a remote repository into the local
	// repository.
	FetchRemote(ctx context.Context, in *FetchRemoteRequest, opts ...grpc.CallOption) (*FetchRemoteResponse, error)
	// This comment is left unintentionally blank.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*CreateRepositoryResponse, error)
	// This comment is left unintentionally blank.
	GetArchive(ctx context.Context, in *GetArchiveRequest, opts ...grpc.CallOption) (RepositoryService_GetArchiveClient, error)
	// This comment is left unintentionally blank.
	HasLocalBranches(ctx context.Context, in *HasLocalBranchesRequest, opts ...grpc.CallOption) (*HasLocalBranchesResponse, error)
	// FetchSourceBranch fetches a branch from a second (potentially remote)
	// repository into the given repository.
	FetchSourceBranch(ctx context.Context, in *FetchSourceBranchRequest, opts ...grpc.CallOption) (*FetchSourceBranchResponse, error)
	// This comment is left unintentionally blank.
	Fsck(ctx context.Context, in *FsckRequest, opts ...grpc.CallOption) (*FsckResponse, error)
	// This comment is left unintentionally blank.
	WriteRef(ctx context.Context, in *WriteRefRequest, opts ...grpc.CallOption) (*WriteRefResponse, error)
	// This comment is left unintentionally blank.
	FindMergeBase(ctx context.Context, in *FindMergeBaseRequest, opts ...grpc.CallOption) (*FindMergeBaseResponse, error)
	// This comment is left unintentionally blank.
	CreateFork(ctx context.Context, in *CreateForkRequest, opts ...grpc.CallOption) (*CreateForkResponse, error)
	// This comment is left unintentionally blank.
	CreateRepositoryFromURL(ctx context.Context, in *CreateRepositoryFromURLRequest, opts ...grpc.CallOption) (*CreateRepositoryFromURLResponse, error)
	// CreateBundle creates a bundle from all refs
	CreateBundle(ctx context.Context, in *CreateBundleRequest, opts ...grpc.CallOption) (RepositoryService_CreateBundleClient, error)
	// CreateBundleFromRefList creates a bundle from a stream of ref patterns.
	// When the bundle would be empty the FailedPrecondition error code is returned.
	CreateBundleFromRefList(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateBundleFromRefListClient, error)
	// FetchBundle fetches references from a bundle into the local repository.
	// Refs will be mirrored to the target repository with the refspec
	// "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
	FetchBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_FetchBundleClient, error)
	// This comment is left unintentionally blank.
	CreateRepositoryFromBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateRepositoryFromBundleClient, error)
	// GetConfig reads the target repository's gitconfig and streams its contents
	// back. Returns a NotFound error in case no gitconfig was found.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (RepositoryService_GetConfigClient, error)
	// This comment is left unintentionally blank.
	FindLicense(ctx context.Context, in *FindLicenseRequest, opts ...grpc.CallOption) (*FindLicenseResponse, error)
	// This comment is left unintentionally blank.
	GetInfoAttributes(ctx context.Context, in *GetInfoAttributesRequest, opts ...grpc.CallOption) (RepositoryService_GetInfoAttributesClient, error)
	// This comment is left unintentionally blank.
	CalculateChecksum(ctx context.Context, in *CalculateChecksumRequest, opts ...grpc.CallOption) (*CalculateChecksumResponse, error)
	// Deprecated: Do not use.
	// Cleanup is deprecated in favor of OptimizeRepository.
	Cleanup(ctx context.Context, in *CleanupRequest, opts ...grpc.CallOption) (*CleanupResponse, error)
	// This comment is left unintentionally blank.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (RepositoryService_GetSnapshotClient, error)
	// This comment is left unintentionally blank.
	CreateRepositoryFromSnapshot(ctx context.Context, in *CreateRepositoryFromSnapshotRequest, opts ...grpc.CallOption) (*CreateRepositoryFromSnapshotResponse, error)
	// This comment is left unintentionally blank.
	GetRawChanges(ctx context.Context, in *GetRawChangesRequest, opts ...grpc.CallOption) (RepositoryService_GetRawChangesClient, error)
	// This comment is left unintentionally blank.
	SearchFilesByContent(ctx context.Context, in *SearchFilesByContentRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByContentClient, error)
	// This comment is left unintentionally blank.
	SearchFilesByName(ctx context.Context, in *SearchFilesByNameRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByNameClient, error)
	// This comment is left unintentionally blank.
	RestoreCustomHooks(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_RestoreCustomHooksClient, error)
	// This comment is left unintentionally blank.
	BackupCustomHooks(ctx context.Context, in *BackupCustomHooksRequest, opts ...grpc.CallOption) (RepositoryService_BackupCustomHooksClient, error)
	// This comment is left unintentionally blank.
	GetObjectDirectorySize(ctx context.Context, in *GetObjectDirectorySizeRequest, opts ...grpc.CallOption) (*GetObjectDirectorySizeResponse, error)
	// RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
	// eventually remove it. This ensures that even on networked filesystems the
	// data is actually removed even if there's someone still handling the data.
	RemoveRepository(ctx context.Context, in *RemoveRepositoryRequest, opts ...grpc.CallOption) (*RemoveRepositoryResponse, error)
	// This comment is left unintentionally blank.
	RenameRepository(ctx context.Context, in *RenameRepositoryRequest, opts ...grpc.CallOption) (*RenameRepositoryResponse, error)
	// This comment is left unintentionally blank.
	ReplicateRepository(ctx context.Context, in *ReplicateRepositoryRequest, opts ...grpc.CallOption) (*ReplicateRepositoryResponse, error)
	// OptimizeRepository performs all maintenance tasks in a repository to keep
	// it in an efficient state. It cleans up stale data, repacks objects,
	// updates auxiliary caches like commit-graphs and packs references. The
	// optimizations performed are based on heuristics and will adapt to the
	// repository's size. This RPC call is designed as a black-box such that
	// Gitaly has complete control of the on-disk state of repositories.
	OptimizeRepository(ctx context.Context, in *OptimizeRepositoryRequest, opts ...grpc.CallOption) (*OptimizeRepositoryResponse, error)
	// PruneUnreachableObjects will prune all objects which aren't reachable from
	// the repository's current set of references. Because pruning can only
	// happen for objects which aren't packed, you are required to first run
	// OptimizeRepository to explode any unreachable objects into loose objects.
	//
	// Furthermore, this RPC call has a grace period of 30 minutes: any
	// unreachable loose objects must not have been accessed or modified in the
	// last 30 minutes. This is a hard requirement to avoid repository corruption.
	//
	// To make proper use of this RPC you thus need to call OptimizeRepository,
	// wait 30 minutes, and then call PruneUnreachableObjects.
	PruneUnreachableObjects(ctx context.Context, in *PruneUnreachableObjectsRequest, opts ...grpc.CallOption) (*PruneUnreachableObjectsResponse, error)
	// SetFullPath writes the "gitlab.fullpath" configuration into the
	// repository's gitconfig. This is mainly to help debugging purposes in case
	// an admin inspects the repository's gitconfig such that he can easily see
	// what the repository name is.
	SetFullPath(ctx context.Context, in *SetFullPathRequest, opts ...grpc.CallOption) (*SetFullPathResponse, error)
	// FullPath reads the "gitlab.fullpath" configuration from the repository's
	// gitconfig. Returns an error in case the full path has not been configured.
	FullPath(ctx context.Context, in *FullPathRequest, opts ...grpc.CallOption) (*FullPathResponse, error)
}

type repositoryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRepositoryServiceClient(cc grpc.ClientConnInterface) RepositoryServiceClient {
	return &repositoryServiceClient{cc}
}

func (c *repositoryServiceClient) RepositoryExists(ctx context.Context, in *RepositoryExistsRequest, opts ...grpc.CallOption) (*RepositoryExistsResponse, error) {
	out := new(RepositoryExistsResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepositoryExists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) RepackIncremental(ctx context.Context, in *RepackIncrementalRequest, opts ...grpc.CallOption) (*RepackIncrementalResponse, error) {
	out := new(RepackIncrementalResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepackIncremental", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) RepackFull(ctx context.Context, in *RepackFullRequest, opts ...grpc.CallOption) (*RepackFullResponse, error) {
	out := new(RepackFullResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepackFull", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) MidxRepack(ctx context.Context, in *MidxRepackRequest, opts ...grpc.CallOption) (*MidxRepackResponse, error) {
	out := new(MidxRepackResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/MidxRepack", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) GarbageCollect(ctx context.Context, in *GarbageCollectRequest, opts ...grpc.CallOption) (*GarbageCollectResponse, error) {
	out := new(GarbageCollectResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/GarbageCollect", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) WriteCommitGraph(ctx context.Context, in *WriteCommitGraphRequest, opts ...grpc.CallOption) (*WriteCommitGraphResponse, error) {
	out := new(WriteCommitGraphResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/WriteCommitGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RepositorySize(ctx context.Context, in *RepositorySizeRequest, opts ...grpc.CallOption) (*RepositorySizeResponse, error) {
	out := new(RepositorySizeResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepositorySize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) ApplyGitattributes(ctx context.Context, in *ApplyGitattributesRequest, opts ...grpc.CallOption) (*ApplyGitattributesResponse, error) {
	out := new(ApplyGitattributesResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/ApplyGitattributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchRemote(ctx context.Context, in *FetchRemoteRequest, opts ...grpc.CallOption) (*FetchRemoteResponse, error) {
	out := new(FetchRemoteResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FetchRemote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*CreateRepositoryResponse, error) {
	out := new(CreateRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetArchive(ctx context.Context, in *GetArchiveRequest, opts ...grpc.CallOption) (RepositoryService_GetArchiveClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[0], "/gitaly.RepositoryService/GetArchive", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetArchiveClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetArchiveClient interface {
	Recv() (*GetArchiveResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetArchiveClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetArchiveClient) Recv() (*GetArchiveResponse, error) {
	m := new(GetArchiveResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) HasLocalBranches(ctx context.Context, in *HasLocalBranchesRequest, opts ...grpc.CallOption) (*HasLocalBranchesResponse, error) {
	out := new(HasLocalBranchesResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/HasLocalBranches", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchSourceBranch(ctx context.Context, in *FetchSourceBranchRequest, opts ...grpc.CallOption) (*FetchSourceBranchResponse, error) {
	out := new(FetchSourceBranchResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FetchSourceBranch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) Fsck(ctx context.Context, in *FsckRequest, opts ...grpc.CallOption) (*FsckResponse, error) {
	out := new(FsckResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/Fsck", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) WriteRef(ctx context.Context, in *WriteRefRequest, opts ...grpc.CallOption) (*WriteRefResponse, error) {
	out := new(WriteRefResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/WriteRef", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FindMergeBase(ctx context.Context, in *FindMergeBaseRequest, opts ...grpc.CallOption) (*FindMergeBaseResponse, error) {
	out := new(FindMergeBaseResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FindMergeBase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateFork(ctx context.Context, in *CreateForkRequest, opts ...grpc.CallOption) (*CreateForkResponse, error) {
	out := new(CreateForkResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateFork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromURL(ctx context.Context, in *CreateRepositoryFromURLRequest, opts ...grpc.CallOption) (*CreateRepositoryFromURLResponse, error) {
	out := new(CreateRepositoryFromURLResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateRepositoryFromURL", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateBundle(ctx context.Context, in *CreateBundleRequest, opts ...grpc.CallOption) (RepositoryService_CreateBundleClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[1], "/gitaly.RepositoryService/CreateBundle", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceCreateBundleClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_CreateBundleClient interface {
	Recv() (*CreateBundleResponse, error)
	grpc.ClientStream
}

type repositoryServiceCreateBundleClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceCreateBundleClient) Recv() (*CreateBundleResponse, error) {
	m := new(CreateBundleResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CreateBundleFromRefList(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateBundleFromRefListClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[2], "/gitaly.RepositoryService/CreateBundleFromRefList", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceCreateBundleFromRefListClient{stream}
	return x, nil
}

type RepositoryService_CreateBundleFromRefListClient interface {
	Send(*CreateBundleFromRefListRequest) error
	Recv() (*CreateBundleFromRefListResponse, error)
	grpc.ClientStream
}

type repositoryServiceCreateBundleFromRefListClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceCreateBundleFromRefListClient) Send(m *CreateBundleFromRefListRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceCreateBundleFromRefListClient) Recv() (*CreateBundleFromRefListResponse, error) {
	m := new(CreateBundleFromRefListResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) FetchBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_FetchBundleClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[3], "/gitaly.RepositoryService/FetchBundle", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceFetchBundleClient{stream}
	return x, nil
}

type RepositoryService_FetchBundleClient interface {
	Send(*FetchBundleRequest) error
	CloseAndRecv() (*FetchBundleResponse, error)
	grpc.ClientStream
}

type repositoryServiceFetchBundleClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceFetchBundleClient) Send(m *FetchBundleRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceFetchBundleClient) CloseAndRecv() (*FetchBundleResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(FetchBundleResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateRepositoryFromBundleClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[4], "/gitaly.RepositoryService/CreateRepositoryFromBundle", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceCreateRepositoryFromBundleClient{stream}
	return x, nil
}

type RepositoryService_CreateRepositoryFromBundleClient interface {
	Send(*CreateRepositoryFromBundleRequest) error
	CloseAndRecv() (*CreateRepositoryFromBundleResponse, error)
	grpc.ClientStream
}

type repositoryServiceCreateRepositoryFromBundleClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceCreateRepositoryFromBundleClient) Send(m *CreateRepositoryFromBundleRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceCreateRepositoryFromBundleClient) CloseAndRecv() (*CreateRepositoryFromBundleResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(CreateRepositoryFromBundleResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (RepositoryService_GetConfigClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[5], "/gitaly.RepositoryService/GetConfig", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetConfigClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetConfigClient interface {
	Recv() (*GetConfigResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetConfigClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetConfigClient) Recv() (*GetConfigResponse, error) {
	m := new(GetConfigResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) FindLicense(ctx context.Context, in *FindLicenseRequest, opts ...grpc.CallOption) (*FindLicenseResponse, error) {
	out := new(FindLicenseResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FindLicense", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetInfoAttributes(ctx context.Context, in *GetInfoAttributesRequest, opts ...grpc.CallOption) (RepositoryService_GetInfoAttributesClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[6], "/gitaly.RepositoryService/GetInfoAttributes", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetInfoAttributesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetInfoAttributesClient interface {
	Recv() (*GetInfoAttributesResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetInfoAttributesClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetInfoAttributesClient) Recv() (*GetInfoAttributesResponse, error) {
	m := new(GetInfoAttributesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CalculateChecksum(ctx context.Context, in *CalculateChecksumRequest, opts ...grpc.CallOption) (*CalculateChecksumResponse, error) {
	out := new(CalculateChecksumResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CalculateChecksum", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) Cleanup(ctx context.Context, in *CleanupRequest, opts ...grpc.CallOption) (*CleanupResponse, error) {
	out := new(CleanupResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/Cleanup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (RepositoryService_GetSnapshotClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[7], "/gitaly.RepositoryService/GetSnapshot", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetSnapshotClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetSnapshotClient interface {
	Recv() (*GetSnapshotResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetSnapshotClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetSnapshotClient) Recv() (*GetSnapshotResponse, error) {
	m := new(GetSnapshotResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromSnapshot(ctx context.Context, in *CreateRepositoryFromSnapshotRequest, opts ...grpc.CallOption) (*CreateRepositoryFromSnapshotResponse, error) {
	out := new(CreateRepositoryFromSnapshotResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateRepositoryFromSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetRawChanges(ctx context.Context, in *GetRawChangesRequest, opts ...grpc.CallOption) (RepositoryService_GetRawChangesClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[8], "/gitaly.RepositoryService/GetRawChanges", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetRawChangesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetRawChangesClient interface {
	Recv() (*GetRawChangesResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetRawChangesClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetRawChangesClient) Recv() (*GetRawChangesResponse, error) {
	m := new(GetRawChangesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) SearchFilesByContent(ctx context.Context, in *SearchFilesByContentRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[9], "/gitaly.RepositoryService/SearchFilesByContent", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceSearchFilesByContentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_SearchFilesByContentClient interface {
	Recv() (*SearchFilesByContentResponse, error)
	grpc.ClientStream
}

type repositoryServiceSearchFilesByContentClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceSearchFilesByContentClient) Recv() (*SearchFilesByContentResponse, error) {
	m := new(SearchFilesByContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) SearchFilesByName(ctx context.Context, in *SearchFilesByNameRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByNameClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[10], "/gitaly.RepositoryService/SearchFilesByName", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceSearchFilesByNameClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_SearchFilesByNameClient interface {
	Recv() (*SearchFilesByNameResponse, error)
	grpc.ClientStream
}

type repositoryServiceSearchFilesByNameClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceSearchFilesByNameClient) Recv() (*SearchFilesByNameResponse, error) {
	m := new(SearchFilesByNameResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) RestoreCustomHooks(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_RestoreCustomHooksClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[11], "/gitaly.RepositoryService/RestoreCustomHooks", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceRestoreCustomHooksClient{stream}
	return x, nil
}

type RepositoryService_RestoreCustomHooksClient interface {
	Send(*RestoreCustomHooksRequest) error
	CloseAndRecv() (*RestoreCustomHooksResponse, error)
	grpc.ClientStream
}

type repositoryServiceRestoreCustomHooksClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceRestoreCustomHooksClient) Send(m *RestoreCustomHooksRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceRestoreCustomHooksClient) CloseAndRecv() (*RestoreCustomHooksResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(RestoreCustomHooksResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) BackupCustomHooks(ctx context.Context, in *BackupCustomHooksRequest, opts ...grpc.CallOption) (RepositoryService_BackupCustomHooksClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[12], "/gitaly.RepositoryService/BackupCustomHooks", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceBackupCustomHooksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_BackupCustomHooksClient interface {
	Recv() (*BackupCustomHooksResponse, error)
	grpc.ClientStream
}

type repositoryServiceBackupCustomHooksClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceBackupCustomHooksClient) Recv() (*BackupCustomHooksResponse, error) {
	m := new(BackupCustomHooksResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) GetObjectDirectorySize(ctx context.Context, in *GetObjectDirectorySizeRequest, opts ...grpc.CallOption) (*GetObjectDirectorySizeResponse, error) {
	out := new(GetObjectDirectorySizeResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/GetObjectDirectorySize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RemoveRepository(ctx context.Context, in *RemoveRepositoryRequest, opts ...grpc.CallOption) (*RemoveRepositoryResponse, error) {
	out := new(RemoveRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RemoveRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RenameRepository(ctx context.Context, in *RenameRepositoryRequest, opts ...grpc.CallOption) (*RenameRepositoryResponse, error) {
	out := new(RenameRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RenameRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) ReplicateRepository(ctx context.Context, in *ReplicateRepositoryRequest, opts ...grpc.CallOption) (*ReplicateRepositoryResponse, error) {
	out := new(ReplicateRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/ReplicateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) OptimizeRepository(ctx context.Context, in *OptimizeRepositoryRequest, opts ...grpc.CallOption) (*OptimizeRepositoryResponse, error) {
	out := new(OptimizeRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/OptimizeRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) PruneUnreachableObjects(ctx context.Context, in *PruneUnreachableObjectsRequest, opts ...grpc.CallOption) (*PruneUnreachableObjectsResponse, error) {
	out := new(PruneUnreachableObjectsResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/PruneUnreachableObjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) SetFullPath(ctx context.Context, in *SetFullPathRequest, opts ...grpc.CallOption) (*SetFullPathResponse, error) {
	out := new(SetFullPathResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/SetFullPath", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FullPath(ctx context.Context, in *FullPathRequest, opts ...grpc.CallOption) (*FullPathResponse, error) {
	out := new(FullPathResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FullPath", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RepositoryServiceServer is the server API for RepositoryService service.
// All implementations must embed UnimplementedRepositoryServiceServer
// for forward compatibility
type RepositoryServiceServer interface {
	// This comment is left unintentionally blank.
	RepositoryExists(context.Context, *RepositoryExistsRequest) (*RepositoryExistsResponse, error)
	// Deprecated: Do not use.
	// RepackIncremental is deprecated in favor of OptimizeRepository.
	RepackIncremental(context.Context, *RepackIncrementalRequest) (*RepackIncrementalResponse, error)
	// Deprecated: Do not use.
	// RepackFull is deprecated in favor of OptimizeRepository.
	RepackFull(context.Context, *RepackFullRequest) (*RepackFullResponse, error)
	// Deprecated: Do not use.
	// MidxRepack is deprecated in favor of OptimizeRepository.
	MidxRepack(context.Context, *MidxRepackRequest) (*MidxRepackResponse, error)
	// Deprecated: Do not use.
	// GarbageCollect is deprecated in favor of OptimizeRepository.
	GarbageCollect(context.Context, *GarbageCollectRequest) (*GarbageCollectResponse, error)
	// Deprecated: Do not use.
	// WriteCommitGraph is deprecated in favor of OptimizeRepository.
	WriteCommitGraph(context.Context, *WriteCommitGraphRequest) (*WriteCommitGraphResponse, error)
	// This comment is left unintentionally blank.
	RepositorySize(context.Context, *RepositorySizeRequest) (*RepositorySizeResponse, error)
	// This comment is left unintentionally blank.
	ApplyGitattributes(context.Context, *ApplyGitattributesRequest) (*ApplyGitattributesResponse, error)
	// FetchRemote fetches references from a remote repository into the local
	// repository.
	FetchRemote(context.Context, *FetchRemoteRequest) (*FetchRemoteResponse, error)
	// This comment is left unintentionally blank.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*CreateRepositoryResponse, error)
	// This comment is left unintentionally blank.
	GetArchive(*GetArchiveRequest, RepositoryService_GetArchiveServer) error
	// This comment is left unintentionally blank.
	HasLocalBranches(context.Context, *HasLocalBranchesRequest) (*HasLocalBranchesResponse, error)
	// FetchSourceBranch fetches a branch from a second (potentially remote)
	// repository into the given repository.
	FetchSourceBranch(context.Context, *FetchSourceBranchRequest) (*FetchSourceBranchResponse, error)
	// This comment is left unintentionally blank.
	Fsck(context.Context, *FsckRequest) (*FsckResponse, error)
	// This comment is left unintentionally blank.
	WriteRef(context.Context, *WriteRefRequest) (*WriteRefResponse, error)
	// This comment is left unintentionally blank.
	FindMergeBase(context.Context, *FindMergeBaseRequest) (*FindMergeBaseResponse, error)
	// This comment is left unintentionally blank.
	CreateFork(context.Context, *CreateForkRequest) (*CreateForkResponse, error)
	// This comment is left unintentionally blank.
	CreateRepositoryFromURL(context.Context, *CreateRepositoryFromURLRequest) (*CreateRepositoryFromURLResponse, error)
	// CreateBundle creates a bundle from all refs
	CreateBundle(*CreateBundleRequest, RepositoryService_CreateBundleServer) error
	// CreateBundleFromRefList creates a bundle from a stream of ref patterns.
	// When the bundle would be empty the FailedPrecondition error code is returned.
	CreateBundleFromRefList(RepositoryService_CreateBundleFromRefListServer) error
	// FetchBundle fetches references from a bundle into the local repository.
	// Refs will be mirrored to the target repository with the refspec
	// "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
	FetchBundle(RepositoryService_FetchBundleServer) error
	// This comment is left unintentionally blank.
	CreateRepositoryFromBundle(RepositoryService_CreateRepositoryFromBundleServer) error
	// GetConfig reads the target repository's gitconfig and streams its contents
	// back. Returns a NotFound error in case no gitconfig was found.
	GetConfig(*GetConfigRequest, RepositoryService_GetConfigServer) error
	// This comment is left unintentionally blank.
	FindLicense(context.Context, *FindLicenseRequest) (*FindLicenseResponse, error)
	// This comment is left unintentionally blank.
	GetInfoAttributes(*GetInfoAttributesRequest, RepositoryService_GetInfoAttributesServer) error
	// This comment is left unintentionally blank.
	CalculateChecksum(context.Context, *CalculateChecksumRequest) (*CalculateChecksumResponse, error)
	// Deprecated: Do not use.
	// Cleanup is deprecated in favor of OptimizeRepository.
	Cleanup(context.Context, *CleanupRequest) (*CleanupResponse, error)
	// This comment is left unintentionally blank.
	GetSnapshot(*GetSnapshotRequest, RepositoryService_GetSnapshotServer) error
	// This comment is left unintentionally blank.
	CreateRepositoryFromSnapshot(context.Context, *CreateRepositoryFromSnapshotRequest) (*CreateRepositoryFromSnapshotResponse, error)
	// This comment is left unintentionally blank.
	GetRawChanges(*GetRawChangesRequest, RepositoryService_GetRawChangesServer) error
	// This comment is left unintentionally blank.
	SearchFilesByContent(*SearchFilesByContentRequest, RepositoryService_SearchFilesByContentServer) error
	// This comment is left unintentionally blank.
	SearchFilesByName(*SearchFilesByNameRequest, RepositoryService_SearchFilesByNameServer) error
	// This comment is left unintentionally blank.
	RestoreCustomHooks(RepositoryService_RestoreCustomHooksServer) error
	// This comment is left unintentionally blank.
	BackupCustomHooks(*BackupCustomHooksRequest, RepositoryService_BackupCustomHooksServer) error
	// This comment is left unintentionally blank.
	GetObjectDirectorySize(context.Context, *GetObjectDirectorySizeRequest) (*GetObjectDirectorySizeResponse, error)
	// RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
	// eventually remove it. This ensures that even on networked filesystems the
	// data is actually removed even if there's someone still handling the data.
	RemoveRepository(context.Context, *RemoveRepositoryRequest) (*RemoveRepositoryResponse, error)
	// This comment is left unintentionally blank.
	RenameRepository(context.Context, *RenameRepositoryRequest) (*RenameRepositoryResponse, error)
	// This comment is left unintentionally blank.
	ReplicateRepository(context.Context, *ReplicateRepositoryRequest) (*ReplicateRepositoryResponse, error)
	// OptimizeRepository performs all maintenance tasks in a repository to keep
	// it in an efficient state. It cleans up stale data, repacks objects,
	// updates auxiliary caches like commit-graphs and packs references. The
	// optimizations performed are based on heuristics and will adapt to the
	// repository's size. This RPC call is designed as a black-box such that
	// Gitaly has complete control of the on-disk state of repositories.
	OptimizeRepository(context.Context, *OptimizeRepositoryRequest) (*OptimizeRepositoryResponse, error)
	// PruneUnreachableObjects will prune all objects which aren't reachable from
	// the repository's current set of references. Because pruning can only
	// happen for objects which aren't packed, you are required to first run
	// OptimizeRepository to explode any unreachable objects into loose objects.
	//
	// Furthermore, this RPC call has a grace period of 30 minutes: any
	// unreachable loose objects must not have been accessed or modified in the
	// last 30 minutes. This is a hard requirement to avoid repository corruption.
	//
	// To make proper use of this RPC you thus need to call OptimizeRepository,
	// wait 30 minutes, and then call PruneUnreachableObjects.
	PruneUnreachableObjects(context.Context, *PruneUnreachableObjectsRequest) (*PruneUnreachableObjectsResponse, error)
	// SetFullPath writes the "gitlab.fullpath" configuration into the
	// repository's gitconfig. This is mainly to help debugging purposes in case
	// an admin inspects the repository's gitconfig such that he can easily see
	// what the repository name is.
	SetFullPath(context.Context, *SetFullPathRequest) (*SetFullPathResponse, error)
	// FullPath reads the "gitlab.fullpath" configuration from the repository's
	// gitconfig. Returns an error in case the full path has not been configured.
	FullPath(context.Context, *FullPathRequest) (*FullPathResponse, error)
	mustEmbedUnimplementedRepositoryServiceServer()
}

// UnimplementedRepositoryServiceServer must be embedded to have forward compatible implementations.
type UnimplementedRepositoryServiceServer struct {
}

func (UnimplementedRepositoryServiceServer) RepositoryExists(context.Context, *RepositoryExistsRequest) (*RepositoryExistsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositoryExists not implemented")
}
func (UnimplementedRepositoryServiceServer) RepackIncremental(context.Context, *RepackIncrementalRequest) (*RepackIncrementalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepackIncremental not implemented")
}
func (UnimplementedRepositoryServiceServer) RepackFull(context.Context, *RepackFullRequest) (*RepackFullResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepackFull not implemented")
}
func (UnimplementedRepositoryServiceServer) MidxRepack(context.Context, *MidxRepackRequest) (*MidxRepackResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MidxRepack not implemented")
}
func (UnimplementedRepositoryServiceServer) GarbageCollect(context.Context, *GarbageCollectRequest) (*GarbageCollectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GarbageCollect not implemented")
}
func (UnimplementedRepositoryServiceServer) WriteCommitGraph(context.Context, *WriteCommitGraphRequest) (*WriteCommitGraphResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteCommitGraph not implemented")
}
func (UnimplementedRepositoryServiceServer) RepositorySize(context.Context, *RepositorySizeRequest) (*RepositorySizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositorySize not implemented")
}
func (UnimplementedRepositoryServiceServer) ApplyGitattributes(context.Context, *ApplyGitattributesRequest) (*ApplyGitattributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyGitattributes not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchRemote(context.Context, *FetchRemoteRequest) (*FetchRemoteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchRemote not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*CreateRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) GetArchive(*GetArchiveRequest, RepositoryService_GetArchiveServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArchive not implemented")
}
func (UnimplementedRepositoryServiceServer) HasLocalBranches(context.Context, *HasLocalBranchesRequest) (*HasLocalBranchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HasLocalBranches not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchSourceBranch(context.Context, *FetchSourceBranchRequest) (*FetchSourceBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchSourceBranch not implemented")
}
func (UnimplementedRepositoryServiceServer) Fsck(context.Context, *FsckRequest) (*FsckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Fsck not implemented")
}
func (UnimplementedRepositoryServiceServer) WriteRef(context.Context, *WriteRefRequest) (*WriteRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteRef not implemented")
}
func (UnimplementedRepositoryServiceServer) FindMergeBase(context.Context, *FindMergeBaseRequest) (*FindMergeBaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindMergeBase not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateFork(context.Context, *CreateForkRequest) (*CreateForkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFork not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromURL(context.Context, *CreateRepositoryFromURLRequest) (*CreateRepositoryFromURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepositoryFromURL not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateBundle(*CreateBundleRequest, RepositoryService_CreateBundleServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateBundleFromRefList(RepositoryService_CreateBundleFromRefListServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateBundleFromRefList not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchBundle(RepositoryService_FetchBundleServer) error {
	return status.Errorf(codes.Unimplemented, "method FetchBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromBundle(RepositoryService_CreateRepositoryFromBundleServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateRepositoryFromBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) GetConfig(*GetConfigRequest, RepositoryService_GetConfigServer) error {
	return status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedRepositoryServiceServer) FindLicense(context.Context, *FindLicenseRequest) (*FindLicenseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindLicense not implemented")
}
func (UnimplementedRepositoryServiceServer) GetInfoAttributes(*GetInfoAttributesRequest, RepositoryService_GetInfoAttributesServer) error {
	return status.Errorf(codes.Unimplemented, "method GetInfoAttributes not implemented")
}
func (UnimplementedRepositoryServiceServer) CalculateChecksum(context.Context, *CalculateChecksumRequest) (*CalculateChecksumResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateChecksum not implemented")
}
func (UnimplementedRepositoryServiceServer) Cleanup(context.Context, *CleanupRequest) (*CleanupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Cleanup not implemented")
}
func (UnimplementedRepositoryServiceServer) GetSnapshot(*GetSnapshotRequest, RepositoryService_GetSnapshotServer) error {
	return status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromSnapshot(context.Context, *CreateRepositoryFromSnapshotRequest) (*CreateRepositoryFromSnapshotResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepositoryFromSnapshot not implemented")
}
func (UnimplementedRepositoryServiceServer) GetRawChanges(*GetRawChangesRequest, RepositoryService_GetRawChangesServer) error {
	return status.Errorf(codes.Unimplemented, "method GetRawChanges not implemented")
}
func (UnimplementedRepositoryServiceServer) SearchFilesByContent(*SearchFilesByContentRequest, RepositoryService_SearchFilesByContentServer) error {
	return status.Errorf(codes.Unimplemented, "method SearchFilesByContent not implemented")
}
func (UnimplementedRepositoryServiceServer) SearchFilesByName(*SearchFilesByNameRequest, RepositoryService_SearchFilesByNameServer) error {
	return status.Errorf(codes.Unimplemented, "method SearchFilesByName not implemented")
}
func (UnimplementedRepositoryServiceServer) RestoreCustomHooks(RepositoryService_RestoreCustomHooksServer) error {
	return status.Errorf(codes.Unimplemented, "method RestoreCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) BackupCustomHooks(*BackupCustomHooksRequest, RepositoryService_BackupCustomHooksServer) error {
	return status.Errorf(codes.Unimplemented, "method BackupCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) GetObjectDirectorySize(context.Context, *GetObjectDirectorySizeRequest) (*GetObjectDirectorySizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectDirectorySize not implemented")
}
func (UnimplementedRepositoryServiceServer) RemoveRepository(context.Context, *RemoveRepositoryRequest) (*RemoveRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) RenameRepository(context.Context, *RenameRepositoryRequest) (*RenameRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) ReplicateRepository(context.Context, *ReplicateRepositoryRequest) (*ReplicateRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) OptimizeRepository(context.Context, *OptimizeRepositoryRequest) (*OptimizeRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OptimizeRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) PruneUnreachableObjects(context.Context, *PruneUnreachableObjectsRequest) (*PruneUnreachableObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PruneUnreachableObjects not implemented")
}
func (UnimplementedRepositoryServiceServer) SetFullPath(context.Context, *SetFullPathRequest) (*SetFullPathResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFullPath not implemented")
}
func (UnimplementedRepositoryServiceServer) FullPath(context.Context, *FullPathRequest) (*FullPathResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FullPath not implemented")
}
func (UnimplementedRepositoryServiceServer) mustEmbedUnimplementedRepositoryServiceServer() {}

// UnsafeRepositoryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RepositoryServiceServer will
// result in compilation errors.
type UnsafeRepositoryServiceServer interface {
	mustEmbedUnimplementedRepositoryServiceServer()
}

func RegisterRepositoryServiceServer(s grpc.ServiceRegistrar, srv RepositoryServiceServer) {
	s.RegisterService(&RepositoryService_ServiceDesc, srv)
}

func _RepositoryService_RepositoryExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositoryExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositoryExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepositoryExists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositoryExists(ctx, req.(*RepositoryExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepackIncremental_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepackIncrementalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepackIncremental(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepackIncremental",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepackIncremental(ctx, req.(*RepackIncrementalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepackFull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepackFullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepackFull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepackFull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepackFull(ctx, req.(*RepackFullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_MidxRepack_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MidxRepackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).MidxRepack(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/MidxRepack",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).MidxRepack(ctx, req.(*MidxRepackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GarbageCollect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GarbageCollectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GarbageCollect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/GarbageCollect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GarbageCollect(ctx, req.(*GarbageCollectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_WriteCommitGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteCommitGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).WriteCommitGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/WriteCommitGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).WriteCommitGraph(ctx, req.(*WriteCommitGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepositorySize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositorySizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositorySize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepositorySize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositorySize(ctx, req.(*RepositorySizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ApplyGitattributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyGitattributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ApplyGitattributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/ApplyGitattributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ApplyGitattributes(ctx, req.(*ApplyGitattributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchRemote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRemoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FetchRemote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FetchRemote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FetchRemote(ctx, req.(*FetchRemoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetArchive_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArchiveRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetArchive(m, &repositoryServiceGetArchiveServer{stream})
}

type RepositoryService_GetArchiveServer interface {
	Send(*GetArchiveResponse) error
	grpc.ServerStream
}

type repositoryServiceGetArchiveServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetArchiveServer) Send(m *GetArchiveResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_HasLocalBranches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasLocalBranchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).HasLocalBranches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/HasLocalBranches",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).HasLocalBranches(ctx, req.(*HasLocalBranchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchSourceBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchSourceBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FetchSourceBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FetchSourceBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FetchSourceBranch(ctx, req.(*FetchSourceBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_Fsck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FsckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).Fsck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/Fsck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).Fsck(ctx, req.(*FsckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_WriteRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).WriteRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/WriteRef",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).WriteRef(ctx, req.(*WriteRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FindMergeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMergeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FindMergeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FindMergeBase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FindMergeBase(ctx, req.(*FindMergeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateFork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateForkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateFork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateFork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateFork(ctx, req.(*CreateForkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateRepositoryFromURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryFromURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepositoryFromURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateRepositoryFromURL",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepositoryFromURL(ctx, req.(*CreateRepositoryFromURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CreateBundleRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).CreateBundle(m, &repositoryServiceCreateBundleServer{stream})
}

type RepositoryService_CreateBundleServer interface {
	Send(*CreateBundleResponse) error
	grpc.ServerStream
}

type repositoryServiceCreateBundleServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceCreateBundleServer) Send(m *CreateBundleResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_CreateBundleFromRefList_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).CreateBundleFromRefList(&repositoryServiceCreateBundleFromRefListServer{stream})
}

type RepositoryService_CreateBundleFromRefListServer interface {
	Send(*CreateBundleFromRefListResponse) error
	Recv() (*CreateBundleFromRefListRequest, error)
	grpc.ServerStream
}

type repositoryServiceCreateBundleFromRefListServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceCreateBundleFromRefListServer) Send(m *CreateBundleFromRefListResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceCreateBundleFromRefListServer) Recv() (*CreateBundleFromRefListRequest, error) {
	m := new(CreateBundleFromRefListRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_FetchBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).FetchBundle(&repositoryServiceFetchBundleServer{stream})
}

type RepositoryService_FetchBundleServer interface {
	SendAndClose(*FetchBundleResponse) error
	Recv() (*FetchBundleRequest, error)
	grpc.ServerStream
}

type repositoryServiceFetchBundleServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceFetchBundleServer) SendAndClose(m *FetchBundleResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceFetchBundleServer) Recv() (*FetchBundleRequest, error) {
	m := new(FetchBundleRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_CreateRepositoryFromBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).CreateRepositoryFromBundle(&repositoryServiceCreateRepositoryFromBundleServer{stream})
}

type RepositoryService_CreateRepositoryFromBundleServer interface {
	SendAndClose(*CreateRepositoryFromBundleResponse) error
	Recv() (*CreateRepositoryFromBundleRequest, error)
	grpc.ServerStream
}

type repositoryServiceCreateRepositoryFromBundleServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceCreateRepositoryFromBundleServer) SendAndClose(m *CreateRepositoryFromBundleResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceCreateRepositoryFromBundleServer) Recv() (*CreateRepositoryFromBundleRequest, error) {
	m := new(CreateRepositoryFromBundleRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_GetConfig_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetConfigRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetConfig(m, &repositoryServiceGetConfigServer{stream})
}

type RepositoryService_GetConfigServer interface {
	Send(*GetConfigResponse) error
	grpc.ServerStream
}

type repositoryServiceGetConfigServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetConfigServer) Send(m *GetConfigResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_FindLicense_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FindLicense(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FindLicense",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FindLicense(ctx, req.(*FindLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetInfoAttributes_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetInfoAttributesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetInfoAttributes(m, &repositoryServiceGetInfoAttributesServer{stream})
}

type RepositoryService_GetInfoAttributesServer interface {
	Send(*GetInfoAttributesResponse) error
	grpc.ServerStream
}

type repositoryServiceGetInfoAttributesServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetInfoAttributesServer) Send(m *GetInfoAttributesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_CalculateChecksum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateChecksumRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CalculateChecksum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CalculateChecksum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CalculateChecksum(ctx, req.(*CalculateChecksumRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_Cleanup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CleanupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).Cleanup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/Cleanup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).Cleanup(ctx, req.(*CleanupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetSnapshotRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetSnapshot(m, &repositoryServiceGetSnapshotServer{stream})
}

type RepositoryService_GetSnapshotServer interface {
	Send(*GetSnapshotResponse) error
	grpc.ServerStream
}

type repositoryServiceGetSnapshotServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetSnapshotServer) Send(m *GetSnapshotResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_CreateRepositoryFromSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryFromSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepositoryFromSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateRepositoryFromSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepositoryFromSnapshot(ctx, req.(*CreateRepositoryFromSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetRawChanges_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetRawChangesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetRawChanges(m, &repositoryServiceGetRawChangesServer{stream})
}

type RepositoryService_GetRawChangesServer interface {
	Send(*GetRawChangesResponse) error
	grpc.ServerStream
}

type repositoryServiceGetRawChangesServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetRawChangesServer) Send(m *GetRawChangesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_SearchFilesByContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchFilesByContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).SearchFilesByContent(m, &repositoryServiceSearchFilesByContentServer{stream})
}

type RepositoryService_SearchFilesByContentServer interface {
	Send(*SearchFilesByContentResponse) error
	grpc.ServerStream
}

type repositoryServiceSearchFilesByContentServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceSearchFilesByContentServer) Send(m *SearchFilesByContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_SearchFilesByName_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchFilesByNameRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).SearchFilesByName(m, &repositoryServiceSearchFilesByNameServer{stream})
}

type RepositoryService_SearchFilesByNameServer interface {
	Send(*SearchFilesByNameResponse) error
	grpc.ServerStream
}

type repositoryServiceSearchFilesByNameServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceSearchFilesByNameServer) Send(m *SearchFilesByNameResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_RestoreCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).RestoreCustomHooks(&repositoryServiceRestoreCustomHooksServer{stream})
}

type RepositoryService_RestoreCustomHooksServer interface {
	SendAndClose(*RestoreCustomHooksResponse) error
	Recv() (*RestoreCustomHooksRequest, error)
	grpc.ServerStream
}

type repositoryServiceRestoreCustomHooksServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceRestoreCustomHooksServer) SendAndClose(m *RestoreCustomHooksResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceRestoreCustomHooksServer) Recv() (*RestoreCustomHooksRequest, error) {
	m := new(RestoreCustomHooksRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_BackupCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BackupCustomHooksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).BackupCustomHooks(m, &repositoryServiceBackupCustomHooksServer{stream})
}

type RepositoryService_BackupCustomHooksServer interface {
	Send(*BackupCustomHooksResponse) error
	grpc.ServerStream
}

type repositoryServiceBackupCustomHooksServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceBackupCustomHooksServer) Send(m *BackupCustomHooksResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_GetObjectDirectorySize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectDirectorySizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GetObjectDirectorySize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/GetObjectDirectorySize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GetObjectDirectorySize(ctx, req.(*GetObjectDirectorySizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RemoveRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RemoveRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RemoveRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RemoveRepository(ctx, req.(*RemoveRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RenameRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RenameRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RenameRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RenameRepository(ctx, req.(*RenameRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ReplicateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ReplicateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/ReplicateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ReplicateRepository(ctx, req.(*ReplicateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_OptimizeRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OptimizeRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).OptimizeRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/OptimizeRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).OptimizeRepository(ctx, req.(*OptimizeRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_PruneUnreachableObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PruneUnreachableObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).PruneUnreachableObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/PruneUnreachableObjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).PruneUnreachableObjects(ctx, req.(*PruneUnreachableObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_SetFullPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFullPathRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).SetFullPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/SetFullPath",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).SetFullPath(ctx, req.(*SetFullPathRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FullPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FullPathRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FullPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FullPath",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FullPath(ctx, req.(*FullPathRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RepositoryService_ServiceDesc is the grpc.ServiceDesc for RepositoryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RepositoryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RepositoryService",
	HandlerType: (*RepositoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RepositoryExists",
			Handler:    _RepositoryService_RepositoryExists_Handler,
		},
		{
			MethodName: "RepackIncremental",
			Handler:    _RepositoryService_RepackIncremental_Handler,
		},
		{
			MethodName: "RepackFull",
			Handler:    _RepositoryService_RepackFull_Handler,
		},
		{
			MethodName: "MidxRepack",
			Handler:    _RepositoryService_MidxRepack_Handler,
		},
		{
			MethodName: "GarbageCollect",
			Handler:    _RepositoryService_GarbageCollect_Handler,
		},
		{
			MethodName: "WriteCommitGraph",
			Handler:    _RepositoryService_WriteCommitGraph_Handler,
		},
		{
			MethodName: "RepositorySize",
			Handler:    _RepositoryService_RepositorySize_Handler,
		},
		{
			MethodName: "ApplyGitattributes",
			Handler:    _RepositoryService_ApplyGitattributes_Handler,
		},
		{
			MethodName: "FetchRemote",
			Handler:    _RepositoryService_FetchRemote_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _RepositoryService_CreateRepository_Handler,
		},
		{
			MethodName: "HasLocalBranches",
			Handler:    _RepositoryService_HasLocalBranches_Handler,
		},
		{
			MethodName: "FetchSourceBranch",
			Handler:    _RepositoryService_FetchSourceBranch_Handler,
		},
		{
			MethodName: "Fsck",
			Handler:    _RepositoryService_Fsck_Handler,
		},
		{
			MethodName: "WriteRef",
			Handler:    _RepositoryService_WriteRef_Handler,
		},
		{
			MethodName: "FindMergeBase",
			Handler:    _RepositoryService_FindMergeBase_Handler,
		},
		{
			MethodName: "CreateFork",
			Handler:    _RepositoryService_CreateFork_Handler,
		},
		{
			MethodName: "CreateRepositoryFromURL",
			Handler:    _RepositoryService_CreateRepositoryFromURL_Handler,
		},
		{
			MethodName: "FindLicense",
			Handler:    _RepositoryService_FindLicense_Handler,
		},
		{
			MethodName: "CalculateChecksum",
			Handler:    _RepositoryService_CalculateChecksum_Handler,
		},
		{
			MethodName: "Cleanup",
			Handler:    _RepositoryService_Cleanup_Handler,
		},
		{
			MethodName: "CreateRepositoryFromSnapshot",
			Handler:    _RepositoryService_CreateRepositoryFromSnapshot_Handler,
		},
		{
			MethodName: "GetObjectDirectorySize",
			Handler:    _RepositoryService_GetObjectDirectorySize_Handler,
		},
		{
			MethodName: "RemoveRepository",
			Handler:    _RepositoryService_RemoveRepository_Handler,
		},
		{
			MethodName: "RenameRepository",
			Handler:    _RepositoryService_RenameRepository_Handler,
		},
		{
			MethodName: "ReplicateRepository",
			Handler:    _RepositoryService_ReplicateRepository_Handler,
		},
		{
			MethodName: "OptimizeRepository",
			Handler:    _RepositoryService_OptimizeRepository_Handler,
		},
		{
			MethodName: "PruneUnreachableObjects",
			Handler:    _RepositoryService_PruneUnreachableObjects_Handler,
		},
		{
			MethodName: "SetFullPath",
			Handler:    _RepositoryService_SetFullPath_Handler,
		},
		{
			MethodName: "FullPath",
			Handler:    _RepositoryService_FullPath_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArchive",
			Handler:       _RepositoryService_GetArchive_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateBundle",
			Handler:       _RepositoryService_CreateBundle_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateBundleFromRefList",
			Handler:       _RepositoryService_CreateBundleFromRefList_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "FetchBundle",
			Handler:       _RepositoryService_FetchBundle_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "CreateRepositoryFromBundle",
			Handler:       _RepositoryService_CreateRepositoryFromBundle_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetConfig",
			Handler:       _RepositoryService_GetConfig_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetInfoAttributes",
			Handler:       _RepositoryService_GetInfoAttributes_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetSnapshot",
			Handler:       _RepositoryService_GetSnapshot_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetRawChanges",
			Handler:       _RepositoryService_GetRawChanges_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SearchFilesByContent",
			Handler:       _RepositoryService_SearchFilesByContent_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SearchFilesByName",
			Handler:       _RepositoryService_SearchFilesByName_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RestoreCustomHooks",
			Handler:       _RepositoryService_RestoreCustomHooks_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "BackupCustomHooks",
			Handler:       _RepositoryService_BackupCustomHooks_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "repository.proto",
}
