/*
** Copyright (c) 2018-2021 Valve Corporation
** Copyright (c) 2018-2021 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#ifndef  GFXRECON_GENERATED_VULKAN_STRUCT_TO_STRING_H
#define  GFXRECON_GENERATED_VULKAN_STRUCT_TO_STRING_H

#include "format/platform_types.h"
#include "util/to_string.h"
#include "vulkan/vulkan.h"
GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(util)
template <> std::string ToString<VkExtent2D>(const VkExtent2D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExtent3D>(const VkExtent3D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkOffset2D>(const VkOffset2D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkOffset3D>(const VkOffset3D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRect2D>(const VkRect2D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferMemoryBarrier>(const VkBufferMemoryBarrier& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDispatchIndirectCommand>(const VkDispatchIndirectCommand& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrawIndexedIndirectCommand>(const VkDrawIndexedIndirectCommand& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrawIndirectCommand>(const VkDrawIndirectCommand& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageSubresourceRange>(const VkImageSubresourceRange& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageMemoryBarrier>(const VkImageMemoryBarrier& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryBarrier>(const VkMemoryBarrier& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCacheHeaderVersionOne>(const VkPipelineCacheHeaderVersionOne& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAllocationCallbacks>(const VkAllocationCallbacks& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkApplicationInfo>(const VkApplicationInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFormatProperties>(const VkFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageFormatProperties>(const VkImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkInstanceCreateInfo>(const VkInstanceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryHeap>(const VkMemoryHeap& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryType>(const VkMemoryType& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFeatures>(const VkPhysicalDeviceFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceLimits>(const VkPhysicalDeviceLimits& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMemoryProperties>(const VkPhysicalDeviceMemoryProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSparseProperties>(const VkPhysicalDeviceSparseProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceProperties>(const VkPhysicalDeviceProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueueFamilyProperties>(const VkQueueFamilyProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceQueueCreateInfo>(const VkDeviceQueueCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceCreateInfo>(const VkDeviceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExtensionProperties>(const VkExtensionProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkLayerProperties>(const VkLayerProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubmitInfo>(const VkSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMappedMemoryRange>(const VkMappedMemoryRange& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryAllocateInfo>(const VkMemoryAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryRequirements>(const VkMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseMemoryBind>(const VkSparseMemoryBind& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseBufferMemoryBindInfo>(const VkSparseBufferMemoryBindInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageOpaqueMemoryBindInfo>(const VkSparseImageOpaqueMemoryBindInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageSubresource>(const VkImageSubresource& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageMemoryBind>(const VkSparseImageMemoryBind& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageMemoryBindInfo>(const VkSparseImageMemoryBindInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindSparseInfo>(const VkBindSparseInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageFormatProperties>(const VkSparseImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageMemoryRequirements>(const VkSparseImageMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFenceCreateInfo>(const VkFenceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreCreateInfo>(const VkSemaphoreCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkEventCreateInfo>(const VkEventCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueryPoolCreateInfo>(const VkQueryPoolCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferCreateInfo>(const VkBufferCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferViewCreateInfo>(const VkBufferViewCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageCreateInfo>(const VkImageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubresourceLayout>(const VkSubresourceLayout& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkComponentMapping>(const VkComponentMapping& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewCreateInfo>(const VkImageViewCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkShaderModuleCreateInfo>(const VkShaderModuleCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCacheCreateInfo>(const VkPipelineCacheCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSpecializationMapEntry>(const VkSpecializationMapEntry& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSpecializationInfo>(const VkSpecializationInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineShaderStageCreateInfo>(const VkPipelineShaderStageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkComputePipelineCreateInfo>(const VkComputePipelineCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkVertexInputBindingDescription>(const VkVertexInputBindingDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkVertexInputAttributeDescription>(const VkVertexInputAttributeDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineVertexInputStateCreateInfo>(const VkPipelineVertexInputStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineInputAssemblyStateCreateInfo>(const VkPipelineInputAssemblyStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineTessellationStateCreateInfo>(const VkPipelineTessellationStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkViewport>(const VkViewport& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportStateCreateInfo>(const VkPipelineViewportStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationStateCreateInfo>(const VkPipelineRasterizationStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineMultisampleStateCreateInfo>(const VkPipelineMultisampleStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkStencilOpState>(const VkStencilOpState& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineDepthStencilStateCreateInfo>(const VkPipelineDepthStencilStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineColorBlendAttachmentState>(const VkPipelineColorBlendAttachmentState& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineColorBlendStateCreateInfo>(const VkPipelineColorBlendStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineDynamicStateCreateInfo>(const VkPipelineDynamicStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGraphicsPipelineCreateInfo>(const VkGraphicsPipelineCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPushConstantRange>(const VkPushConstantRange& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineLayoutCreateInfo>(const VkPipelineLayoutCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerCreateInfo>(const VkSamplerCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyDescriptorSet>(const VkCopyDescriptorSet& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorBufferInfo>(const VkDescriptorBufferInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorPoolSize>(const VkDescriptorPoolSize& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorPoolCreateInfo>(const VkDescriptorPoolCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetAllocateInfo>(const VkDescriptorSetAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetLayoutBinding>(const VkDescriptorSetLayoutBinding& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetLayoutCreateInfo>(const VkDescriptorSetLayoutCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentDescription>(const VkAttachmentDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentReference>(const VkAttachmentReference& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFramebufferCreateInfo>(const VkFramebufferCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassDescription>(const VkSubpassDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassDependency>(const VkSubpassDependency& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassCreateInfo>(const VkRenderPassCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandPoolCreateInfo>(const VkCommandPoolCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferAllocateInfo>(const VkCommandBufferAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferInheritanceInfo>(const VkCommandBufferInheritanceInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferBeginInfo>(const VkCommandBufferBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferCopy>(const VkBufferCopy& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageSubresourceLayers>(const VkImageSubresourceLayers& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferImageCopy>(const VkBufferImageCopy& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkClearDepthStencilValue>(const VkClearDepthStencilValue& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkClearAttachment>(const VkClearAttachment& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkClearRect>(const VkClearRect& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageBlit>(const VkImageBlit& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageCopy>(const VkImageCopy& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageResolve>(const VkImageResolve& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassBeginInfo>(const VkRenderPassBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSubgroupProperties>(const VkPhysicalDeviceSubgroupProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindBufferMemoryInfo>(const VkBindBufferMemoryInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindImageMemoryInfo>(const VkBindImageMemoryInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevice16BitStorageFeatures>(const VkPhysicalDevice16BitStorageFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryDedicatedRequirements>(const VkMemoryDedicatedRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryDedicatedAllocateInfo>(const VkMemoryDedicatedAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryAllocateFlagsInfo>(const VkMemoryAllocateFlagsInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupRenderPassBeginInfo>(const VkDeviceGroupRenderPassBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupCommandBufferBeginInfo>(const VkDeviceGroupCommandBufferBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupSubmitInfo>(const VkDeviceGroupSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupBindSparseInfo>(const VkDeviceGroupBindSparseInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindBufferMemoryDeviceGroupInfo>(const VkBindBufferMemoryDeviceGroupInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindImageMemoryDeviceGroupInfo>(const VkBindImageMemoryDeviceGroupInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceGroupProperties>(const VkPhysicalDeviceGroupProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupDeviceCreateInfo>(const VkDeviceGroupDeviceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferMemoryRequirementsInfo2>(const VkBufferMemoryRequirementsInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageMemoryRequirementsInfo2>(const VkImageMemoryRequirementsInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageSparseMemoryRequirementsInfo2>(const VkImageSparseMemoryRequirementsInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryRequirements2>(const VkMemoryRequirements2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageMemoryRequirements2>(const VkSparseImageMemoryRequirements2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFeatures2>(const VkPhysicalDeviceFeatures2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceProperties2>(const VkPhysicalDeviceProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFormatProperties2>(const VkFormatProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageFormatProperties2>(const VkImageFormatProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageFormatInfo2>(const VkPhysicalDeviceImageFormatInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueueFamilyProperties2>(const VkQueueFamilyProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMemoryProperties2>(const VkPhysicalDeviceMemoryProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSparseImageFormatProperties2>(const VkSparseImageFormatProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSparseImageFormatInfo2>(const VkPhysicalDeviceSparseImageFormatInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePointClippingProperties>(const VkPhysicalDevicePointClippingProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkInputAttachmentAspectReference>(const VkInputAttachmentAspectReference& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassInputAttachmentAspectCreateInfo>(const VkRenderPassInputAttachmentAspectCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewUsageCreateInfo>(const VkImageViewUsageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineTessellationDomainOriginStateCreateInfo>(const VkPipelineTessellationDomainOriginStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassMultiviewCreateInfo>(const VkRenderPassMultiviewCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMultiviewFeatures>(const VkPhysicalDeviceMultiviewFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMultiviewProperties>(const VkPhysicalDeviceMultiviewProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVariablePointersFeatures>(const VkPhysicalDeviceVariablePointersFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceProtectedMemoryFeatures>(const VkPhysicalDeviceProtectedMemoryFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceProtectedMemoryProperties>(const VkPhysicalDeviceProtectedMemoryProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceQueueInfo2>(const VkDeviceQueueInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkProtectedSubmitInfo>(const VkProtectedSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerYcbcrConversionCreateInfo>(const VkSamplerYcbcrConversionCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerYcbcrConversionInfo>(const VkSamplerYcbcrConversionInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindImagePlaneMemoryInfo>(const VkBindImagePlaneMemoryInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImagePlaneMemoryRequirementsInfo>(const VkImagePlaneMemoryRequirementsInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSamplerYcbcrConversionFeatures>(const VkPhysicalDeviceSamplerYcbcrConversionFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerYcbcrConversionImageFormatProperties>(const VkSamplerYcbcrConversionImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorUpdateTemplateEntry>(const VkDescriptorUpdateTemplateEntry& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorUpdateTemplateCreateInfo>(const VkDescriptorUpdateTemplateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalMemoryProperties>(const VkExternalMemoryProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExternalImageFormatInfo>(const VkPhysicalDeviceExternalImageFormatInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalImageFormatProperties>(const VkExternalImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExternalBufferInfo>(const VkPhysicalDeviceExternalBufferInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalBufferProperties>(const VkExternalBufferProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceIDProperties>(const VkPhysicalDeviceIDProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalMemoryImageCreateInfo>(const VkExternalMemoryImageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalMemoryBufferCreateInfo>(const VkExternalMemoryBufferCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportMemoryAllocateInfo>(const VkExportMemoryAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExternalFenceInfo>(const VkPhysicalDeviceExternalFenceInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalFenceProperties>(const VkExternalFenceProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportFenceCreateInfo>(const VkExportFenceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportSemaphoreCreateInfo>(const VkExportSemaphoreCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExternalSemaphoreInfo>(const VkPhysicalDeviceExternalSemaphoreInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalSemaphoreProperties>(const VkExternalSemaphoreProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMaintenance3Properties>(const VkPhysicalDeviceMaintenance3Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetLayoutSupport>(const VkDescriptorSetLayoutSupport& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderDrawParametersFeatures>(const VkPhysicalDeviceShaderDrawParametersFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkan11Features>(const VkPhysicalDeviceVulkan11Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkan11Properties>(const VkPhysicalDeviceVulkan11Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkan12Features>(const VkPhysicalDeviceVulkan12Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkConformanceVersion>(const VkConformanceVersion& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkan12Properties>(const VkPhysicalDeviceVulkan12Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageFormatListCreateInfo>(const VkImageFormatListCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentDescription2>(const VkAttachmentDescription2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentReference2>(const VkAttachmentReference2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassDescription2>(const VkSubpassDescription2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassDependency2>(const VkSubpassDependency2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassCreateInfo2>(const VkRenderPassCreateInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassBeginInfo>(const VkSubpassBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassEndInfo>(const VkSubpassEndInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevice8BitStorageFeatures>(const VkPhysicalDevice8BitStorageFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDriverProperties>(const VkPhysicalDeviceDriverProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderAtomicInt64Features>(const VkPhysicalDeviceShaderAtomicInt64Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderFloat16Int8Features>(const VkPhysicalDeviceShaderFloat16Int8Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFloatControlsProperties>(const VkPhysicalDeviceFloatControlsProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetLayoutBindingFlagsCreateInfo>(const VkDescriptorSetLayoutBindingFlagsCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDescriptorIndexingFeatures>(const VkPhysicalDeviceDescriptorIndexingFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDescriptorIndexingProperties>(const VkPhysicalDeviceDescriptorIndexingProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetVariableDescriptorCountAllocateInfo>(const VkDescriptorSetVariableDescriptorCountAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetVariableDescriptorCountLayoutSupport>(const VkDescriptorSetVariableDescriptorCountLayoutSupport& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassDescriptionDepthStencilResolve>(const VkSubpassDescriptionDepthStencilResolve& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDepthStencilResolveProperties>(const VkPhysicalDeviceDepthStencilResolveProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceScalarBlockLayoutFeatures>(const VkPhysicalDeviceScalarBlockLayoutFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageStencilUsageCreateInfo>(const VkImageStencilUsageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerReductionModeCreateInfo>(const VkSamplerReductionModeCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSamplerFilterMinmaxProperties>(const VkPhysicalDeviceSamplerFilterMinmaxProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkanMemoryModelFeatures>(const VkPhysicalDeviceVulkanMemoryModelFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImagelessFramebufferFeatures>(const VkPhysicalDeviceImagelessFramebufferFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFramebufferAttachmentImageInfo>(const VkFramebufferAttachmentImageInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFramebufferAttachmentsCreateInfo>(const VkFramebufferAttachmentsCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassAttachmentBeginInfo>(const VkRenderPassAttachmentBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentReferenceStencilLayout>(const VkAttachmentReferenceStencilLayout& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentDescriptionStencilLayout>(const VkAttachmentDescriptionStencilLayout& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceHostQueryResetFeatures>(const VkPhysicalDeviceHostQueryResetFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTimelineSemaphoreFeatures>(const VkPhysicalDeviceTimelineSemaphoreFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTimelineSemaphoreProperties>(const VkPhysicalDeviceTimelineSemaphoreProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreTypeCreateInfo>(const VkSemaphoreTypeCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkTimelineSemaphoreSubmitInfo>(const VkTimelineSemaphoreSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreWaitInfo>(const VkSemaphoreWaitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreSignalInfo>(const VkSemaphoreSignalInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceBufferDeviceAddressFeatures>(const VkPhysicalDeviceBufferDeviceAddressFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferDeviceAddressInfo>(const VkBufferDeviceAddressInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferOpaqueCaptureAddressCreateInfo>(const VkBufferOpaqueCaptureAddressCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryOpaqueCaptureAddressAllocateInfo>(const VkMemoryOpaqueCaptureAddressAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceMemoryOpaqueCaptureAddressInfo>(const VkDeviceMemoryOpaqueCaptureAddressInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkan13Features>(const VkPhysicalDeviceVulkan13Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVulkan13Properties>(const VkPhysicalDeviceVulkan13Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCreationFeedback>(const VkPipelineCreationFeedback& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCreationFeedbackCreateInfo>(const VkPipelineCreationFeedbackCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderTerminateInvocationFeatures>(const VkPhysicalDeviceShaderTerminateInvocationFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceToolProperties>(const VkPhysicalDeviceToolProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures>(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePrivateDataFeatures>(const VkPhysicalDevicePrivateDataFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDevicePrivateDataCreateInfo>(const VkDevicePrivateDataCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPrivateDataSlotCreateInfo>(const VkPrivateDataSlotCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePipelineCreationCacheControlFeatures>(const VkPhysicalDevicePipelineCreationCacheControlFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryBarrier2>(const VkMemoryBarrier2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferMemoryBarrier2>(const VkBufferMemoryBarrier2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageMemoryBarrier2>(const VkImageMemoryBarrier2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDependencyInfo>(const VkDependencyInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreSubmitInfo>(const VkSemaphoreSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferSubmitInfo>(const VkCommandBufferSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubmitInfo2>(const VkSubmitInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSynchronization2Features>(const VkPhysicalDeviceSynchronization2Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures>(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageRobustnessFeatures>(const VkPhysicalDeviceImageRobustnessFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferCopy2>(const VkBufferCopy2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyBufferInfo2>(const VkCopyBufferInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageCopy2>(const VkImageCopy2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyImageInfo2>(const VkCopyImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferImageCopy2>(const VkBufferImageCopy2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyBufferToImageInfo2>(const VkCopyBufferToImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyImageToBufferInfo2>(const VkCopyImageToBufferInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageBlit2>(const VkImageBlit2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBlitImageInfo2>(const VkBlitImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageResolve2>(const VkImageResolve2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkResolveImageInfo2>(const VkResolveImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSubgroupSizeControlFeatures>(const VkPhysicalDeviceSubgroupSizeControlFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSubgroupSizeControlProperties>(const VkPhysicalDeviceSubgroupSizeControlProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo>(const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceInlineUniformBlockFeatures>(const VkPhysicalDeviceInlineUniformBlockFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceInlineUniformBlockProperties>(const VkPhysicalDeviceInlineUniformBlockProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWriteDescriptorSetInlineUniformBlock>(const VkWriteDescriptorSetInlineUniformBlock& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorPoolInlineUniformBlockCreateInfo>(const VkDescriptorPoolInlineUniformBlockCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTextureCompressionASTCHDRFeatures>(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderingAttachmentInfo>(const VkRenderingAttachmentInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderingInfo>(const VkRenderingInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRenderingCreateInfo>(const VkPipelineRenderingCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDynamicRenderingFeatures>(const VkPhysicalDeviceDynamicRenderingFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferInheritanceRenderingInfo>(const VkCommandBufferInheritanceRenderingInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderIntegerDotProductFeatures>(const VkPhysicalDeviceShaderIntegerDotProductFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderIntegerDotProductProperties>(const VkPhysicalDeviceShaderIntegerDotProductProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTexelBufferAlignmentProperties>(const VkPhysicalDeviceTexelBufferAlignmentProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFormatProperties3>(const VkFormatProperties3& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMaintenance4Features>(const VkPhysicalDeviceMaintenance4Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMaintenance4Properties>(const VkPhysicalDeviceMaintenance4Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceBufferMemoryRequirements>(const VkDeviceBufferMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceImageMemoryRequirements>(const VkDeviceImageMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceCapabilitiesKHR>(const VkSurfaceCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceFormatKHR>(const VkSurfaceFormatKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSwapchainCreateInfoKHR>(const VkSwapchainCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentInfoKHR>(const VkPresentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageSwapchainCreateInfoKHR>(const VkImageSwapchainCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindImageMemorySwapchainInfoKHR>(const VkBindImageMemorySwapchainInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAcquireNextImageInfoKHR>(const VkAcquireNextImageInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupPresentCapabilitiesKHR>(const VkDeviceGroupPresentCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupPresentInfoKHR>(const VkDeviceGroupPresentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceGroupSwapchainCreateInfoKHR>(const VkDeviceGroupSwapchainCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayModeParametersKHR>(const VkDisplayModeParametersKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayModeCreateInfoKHR>(const VkDisplayModeCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayModePropertiesKHR>(const VkDisplayModePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPlaneCapabilitiesKHR>(const VkDisplayPlaneCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPlanePropertiesKHR>(const VkDisplayPlanePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPropertiesKHR>(const VkDisplayPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplaySurfaceCreateInfoKHR>(const VkDisplaySurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPresentInfoKHR>(const VkDisplayPresentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkXlibSurfaceCreateInfoKHR>(const VkXlibSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkXcbSurfaceCreateInfoKHR>(const VkXcbSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWaylandSurfaceCreateInfoKHR>(const VkWaylandSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAndroidSurfaceCreateInfoKHR>(const VkAndroidSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWin32SurfaceCreateInfoKHR>(const VkWin32SurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderingFragmentShadingRateAttachmentInfoKHR>(const VkRenderingFragmentShadingRateAttachmentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderingFragmentDensityMapAttachmentInfoEXT>(const VkRenderingFragmentDensityMapAttachmentInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentSampleCountInfoAMD>(const VkAttachmentSampleCountInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMultiviewPerViewAttributesInfoNVX>(const VkMultiviewPerViewAttributesInfoNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportMemoryWin32HandleInfoKHR>(const VkImportMemoryWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportMemoryWin32HandleInfoKHR>(const VkExportMemoryWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryWin32HandlePropertiesKHR>(const VkMemoryWin32HandlePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryGetWin32HandleInfoKHR>(const VkMemoryGetWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportMemoryFdInfoKHR>(const VkImportMemoryFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryFdPropertiesKHR>(const VkMemoryFdPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryGetFdInfoKHR>(const VkMemoryGetFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWin32KeyedMutexAcquireReleaseInfoKHR>(const VkWin32KeyedMutexAcquireReleaseInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportSemaphoreWin32HandleInfoKHR>(const VkImportSemaphoreWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportSemaphoreWin32HandleInfoKHR>(const VkExportSemaphoreWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkD3D12FenceSubmitInfoKHR>(const VkD3D12FenceSubmitInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreGetWin32HandleInfoKHR>(const VkSemaphoreGetWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportSemaphoreFdInfoKHR>(const VkImportSemaphoreFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreGetFdInfoKHR>(const VkSemaphoreGetFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePushDescriptorPropertiesKHR>(const VkPhysicalDevicePushDescriptorPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRectLayerKHR>(const VkRectLayerKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentRegionKHR>(const VkPresentRegionKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentRegionsKHR>(const VkPresentRegionsKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSharedPresentSurfaceCapabilitiesKHR>(const VkSharedPresentSurfaceCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportFenceWin32HandleInfoKHR>(const VkImportFenceWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportFenceWin32HandleInfoKHR>(const VkExportFenceWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFenceGetWin32HandleInfoKHR>(const VkFenceGetWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportFenceFdInfoKHR>(const VkImportFenceFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFenceGetFdInfoKHR>(const VkFenceGetFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePerformanceQueryFeaturesKHR>(const VkPhysicalDevicePerformanceQueryFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePerformanceQueryPropertiesKHR>(const VkPhysicalDevicePerformanceQueryPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceCounterKHR>(const VkPerformanceCounterKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceCounterDescriptionKHR>(const VkPerformanceCounterDescriptionKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueryPoolPerformanceCreateInfoKHR>(const VkQueryPoolPerformanceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAcquireProfilingLockInfoKHR>(const VkAcquireProfilingLockInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceQuerySubmitInfoKHR>(const VkPerformanceQuerySubmitInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSurfaceInfo2KHR>(const VkPhysicalDeviceSurfaceInfo2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceCapabilities2KHR>(const VkSurfaceCapabilities2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceFormat2KHR>(const VkSurfaceFormat2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayProperties2KHR>(const VkDisplayProperties2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPlaneProperties2KHR>(const VkDisplayPlaneProperties2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayModeProperties2KHR>(const VkDisplayModeProperties2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPlaneInfo2KHR>(const VkDisplayPlaneInfo2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPlaneCapabilities2KHR>(const VkDisplayPlaneCapabilities2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePortabilitySubsetFeaturesKHR>(const VkPhysicalDevicePortabilitySubsetFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePortabilitySubsetPropertiesKHR>(const VkPhysicalDevicePortabilitySubsetPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderClockFeaturesKHR>(const VkPhysicalDeviceShaderClockFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceQueueGlobalPriorityCreateInfoKHR>(const VkDeviceQueueGlobalPriorityCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR>(const VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueueFamilyGlobalPriorityPropertiesKHR>(const VkQueueFamilyGlobalPriorityPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFragmentShadingRateAttachmentInfoKHR>(const VkFragmentShadingRateAttachmentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineFragmentShadingRateStateCreateInfoKHR>(const VkPipelineFragmentShadingRateStateCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShadingRateFeaturesKHR>(const VkPhysicalDeviceFragmentShadingRateFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShadingRatePropertiesKHR>(const VkPhysicalDeviceFragmentShadingRatePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShadingRateKHR>(const VkPhysicalDeviceFragmentShadingRateKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceProtectedCapabilitiesKHR>(const VkSurfaceProtectedCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePresentWaitFeaturesKHR>(const VkPhysicalDevicePresentWaitFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR>(const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineInfoKHR>(const VkPipelineInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineExecutablePropertiesKHR>(const VkPipelineExecutablePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineExecutableInfoKHR>(const VkPipelineExecutableInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineExecutableStatisticKHR>(const VkPipelineExecutableStatisticKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineExecutableInternalRepresentationKHR>(const VkPipelineExecutableInternalRepresentationKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineLibraryCreateInfoKHR>(const VkPipelineLibraryCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentIdKHR>(const VkPresentIdKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePresentIdFeaturesKHR>(const VkPhysicalDevicePresentIdFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueueFamilyCheckpointProperties2NV>(const VkQueueFamilyCheckpointProperties2NV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCheckpointData2NV>(const VkCheckpointData2NV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR>(const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR>(const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR>(const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR>(const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR>(const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkTraceRaysIndirectCommand2KHR>(const VkTraceRaysIndirectCommand2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugReportCallbackCreateInfoEXT>(const VkDebugReportCallbackCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationStateRasterizationOrderAMD>(const VkPipelineRasterizationStateRasterizationOrderAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugMarkerObjectNameInfoEXT>(const VkDebugMarkerObjectNameInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugMarkerObjectTagInfoEXT>(const VkDebugMarkerObjectTagInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugMarkerMarkerInfoEXT>(const VkDebugMarkerMarkerInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDedicatedAllocationImageCreateInfoNV>(const VkDedicatedAllocationImageCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDedicatedAllocationBufferCreateInfoNV>(const VkDedicatedAllocationBufferCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDedicatedAllocationMemoryAllocateInfoNV>(const VkDedicatedAllocationMemoryAllocateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTransformFeedbackFeaturesEXT>(const VkPhysicalDeviceTransformFeedbackFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTransformFeedbackPropertiesEXT>(const VkPhysicalDeviceTransformFeedbackPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationStateStreamCreateInfoEXT>(const VkPipelineRasterizationStateStreamCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewHandleInfoNVX>(const VkImageViewHandleInfoNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewAddressPropertiesNVX>(const VkImageViewAddressPropertiesNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkTextureLODGatherFormatPropertiesAMD>(const VkTextureLODGatherFormatPropertiesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkShaderResourceUsageAMD>(const VkShaderResourceUsageAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkShaderStatisticsInfoAMD>(const VkShaderStatisticsInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkStreamDescriptorSurfaceCreateInfoGGP>(const VkStreamDescriptorSurfaceCreateInfoGGP& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCornerSampledImageFeaturesNV>(const VkPhysicalDeviceCornerSampledImageFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalImageFormatPropertiesNV>(const VkExternalImageFormatPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalMemoryImageCreateInfoNV>(const VkExternalMemoryImageCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportMemoryAllocateInfoNV>(const VkExportMemoryAllocateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportMemoryWin32HandleInfoNV>(const VkImportMemoryWin32HandleInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExportMemoryWin32HandleInfoNV>(const VkExportMemoryWin32HandleInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWin32KeyedMutexAcquireReleaseInfoNV>(const VkWin32KeyedMutexAcquireReleaseInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkValidationFlagsEXT>(const VkValidationFlagsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkViSurfaceCreateInfoNN>(const VkViSurfaceCreateInfoNN& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewASTCDecodeModeEXT>(const VkImageViewASTCDecodeModeEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceASTCDecodeFeaturesEXT>(const VkPhysicalDeviceASTCDecodeFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePipelineRobustnessFeaturesEXT>(const VkPhysicalDevicePipelineRobustnessFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePipelineRobustnessPropertiesEXT>(const VkPhysicalDevicePipelineRobustnessPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRobustnessCreateInfoEXT>(const VkPipelineRobustnessCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkConditionalRenderingBeginInfoEXT>(const VkConditionalRenderingBeginInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceConditionalRenderingFeaturesEXT>(const VkPhysicalDeviceConditionalRenderingFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferInheritanceConditionalRenderingInfoEXT>(const VkCommandBufferInheritanceConditionalRenderingInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkViewportWScalingNV>(const VkViewportWScalingNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportWScalingStateCreateInfoNV>(const VkPipelineViewportWScalingStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceCapabilities2EXT>(const VkSurfaceCapabilities2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayPowerInfoEXT>(const VkDisplayPowerInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceEventInfoEXT>(const VkDeviceEventInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayEventInfoEXT>(const VkDisplayEventInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSwapchainCounterCreateInfoEXT>(const VkSwapchainCounterCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRefreshCycleDurationGOOGLE>(const VkRefreshCycleDurationGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPastPresentationTimingGOOGLE>(const VkPastPresentationTimingGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentTimeGOOGLE>(const VkPresentTimeGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentTimesInfoGOOGLE>(const VkPresentTimesInfoGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX>(const VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkViewportSwizzleNV>(const VkViewportSwizzleNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportSwizzleStateCreateInfoNV>(const VkPipelineViewportSwizzleStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDiscardRectanglePropertiesEXT>(const VkPhysicalDeviceDiscardRectanglePropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineDiscardRectangleStateCreateInfoEXT>(const VkPipelineDiscardRectangleStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceConservativeRasterizationPropertiesEXT>(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationConservativeStateCreateInfoEXT>(const VkPipelineRasterizationConservativeStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDepthClipEnableFeaturesEXT>(const VkPhysicalDeviceDepthClipEnableFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationDepthClipStateCreateInfoEXT>(const VkPipelineRasterizationDepthClipStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkXYColorEXT>(const VkXYColorEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkHdrMetadataEXT>(const VkHdrMetadataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkIOSSurfaceCreateInfoMVK>(const VkIOSSurfaceCreateInfoMVK& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMacOSSurfaceCreateInfoMVK>(const VkMacOSSurfaceCreateInfoMVK& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugUtilsLabelEXT>(const VkDebugUtilsLabelEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugUtilsObjectNameInfoEXT>(const VkDebugUtilsObjectNameInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugUtilsMessengerCallbackDataEXT>(const VkDebugUtilsMessengerCallbackDataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugUtilsMessengerCreateInfoEXT>(const VkDebugUtilsMessengerCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDebugUtilsObjectTagInfoEXT>(const VkDebugUtilsObjectTagInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAndroidHardwareBufferUsageANDROID>(const VkAndroidHardwareBufferUsageANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAndroidHardwareBufferPropertiesANDROID>(const VkAndroidHardwareBufferPropertiesANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAndroidHardwareBufferFormatPropertiesANDROID>(const VkAndroidHardwareBufferFormatPropertiesANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportAndroidHardwareBufferInfoANDROID>(const VkImportAndroidHardwareBufferInfoANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryGetAndroidHardwareBufferInfoANDROID>(const VkMemoryGetAndroidHardwareBufferInfoANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkExternalFormatANDROID>(const VkExternalFormatANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAndroidHardwareBufferFormatProperties2ANDROID>(const VkAndroidHardwareBufferFormatProperties2ANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSampleLocationEXT>(const VkSampleLocationEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSampleLocationsInfoEXT>(const VkSampleLocationsInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAttachmentSampleLocationsEXT>(const VkAttachmentSampleLocationsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassSampleLocationsEXT>(const VkSubpassSampleLocationsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassSampleLocationsBeginInfoEXT>(const VkRenderPassSampleLocationsBeginInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineSampleLocationsStateCreateInfoEXT>(const VkPipelineSampleLocationsStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSampleLocationsPropertiesEXT>(const VkPhysicalDeviceSampleLocationsPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMultisamplePropertiesEXT>(const VkMultisamplePropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT>(const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT>(const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineColorBlendAdvancedStateCreateInfoEXT>(const VkPipelineColorBlendAdvancedStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCoverageToColorStateCreateInfoNV>(const VkPipelineCoverageToColorStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCoverageModulationStateCreateInfoNV>(const VkPipelineCoverageModulationStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderSMBuiltinsPropertiesNV>(const VkPhysicalDeviceShaderSMBuiltinsPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderSMBuiltinsFeaturesNV>(const VkPhysicalDeviceShaderSMBuiltinsFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrmFormatModifierPropertiesEXT>(const VkDrmFormatModifierPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrmFormatModifierPropertiesListEXT>(const VkDrmFormatModifierPropertiesListEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageDrmFormatModifierInfoEXT>(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageDrmFormatModifierListCreateInfoEXT>(const VkImageDrmFormatModifierListCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageDrmFormatModifierExplicitCreateInfoEXT>(const VkImageDrmFormatModifierExplicitCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageDrmFormatModifierPropertiesEXT>(const VkImageDrmFormatModifierPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrmFormatModifierProperties2EXT>(const VkDrmFormatModifierProperties2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrmFormatModifierPropertiesList2EXT>(const VkDrmFormatModifierPropertiesList2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkValidationCacheCreateInfoEXT>(const VkValidationCacheCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkShaderModuleValidationCacheCreateInfoEXT>(const VkShaderModuleValidationCacheCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkShadingRatePaletteNV>(const VkShadingRatePaletteNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportShadingRateImageStateCreateInfoNV>(const VkPipelineViewportShadingRateImageStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShadingRateImageFeaturesNV>(const VkPhysicalDeviceShadingRateImageFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShadingRateImagePropertiesNV>(const VkPhysicalDeviceShadingRateImagePropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCoarseSampleLocationNV>(const VkCoarseSampleLocationNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCoarseSampleOrderCustomNV>(const VkCoarseSampleOrderCustomNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportCoarseSampleOrderStateCreateInfoNV>(const VkPipelineViewportCoarseSampleOrderStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRayTracingShaderGroupCreateInfoNV>(const VkRayTracingShaderGroupCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRayTracingPipelineCreateInfoNV>(const VkRayTracingPipelineCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGeometryTrianglesNV>(const VkGeometryTrianglesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGeometryAABBNV>(const VkGeometryAABBNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGeometryDataNV>(const VkGeometryDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGeometryNV>(const VkGeometryNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureInfoNV>(const VkAccelerationStructureInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureCreateInfoNV>(const VkAccelerationStructureCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindAccelerationStructureMemoryInfoNV>(const VkBindAccelerationStructureMemoryInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWriteDescriptorSetAccelerationStructureNV>(const VkWriteDescriptorSetAccelerationStructureNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureMemoryRequirementsInfoNV>(const VkAccelerationStructureMemoryRequirementsInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRayTracingPropertiesNV>(const VkPhysicalDeviceRayTracingPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkTransformMatrixKHR>(const VkTransformMatrixKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAabbPositionsKHR>(const VkAabbPositionsKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureInstanceKHR>(const VkAccelerationStructureInstanceKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV>(const VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRepresentativeFragmentTestStateCreateInfoNV>(const VkPipelineRepresentativeFragmentTestStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageViewImageFormatInfoEXT>(const VkPhysicalDeviceImageViewImageFormatInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFilterCubicImageViewImageFormatPropertiesEXT>(const VkFilterCubicImageViewImageFormatPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportMemoryHostPointerInfoEXT>(const VkImportMemoryHostPointerInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryHostPointerPropertiesEXT>(const VkMemoryHostPointerPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExternalMemoryHostPropertiesEXT>(const VkPhysicalDeviceExternalMemoryHostPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCompilerControlCreateInfoAMD>(const VkPipelineCompilerControlCreateInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCalibratedTimestampInfoEXT>(const VkCalibratedTimestampInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderCorePropertiesAMD>(const VkPhysicalDeviceShaderCorePropertiesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceMemoryOverallocationCreateInfoAMD>(const VkDeviceMemoryOverallocationCreateInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT>(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkVertexInputBindingDivisorDescriptionEXT>(const VkVertexInputBindingDivisorDescriptionEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineVertexInputDivisorStateCreateInfoEXT>(const VkPipelineVertexInputDivisorStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT>(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPresentFrameTokenGGP>(const VkPresentFrameTokenGGP& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceComputeShaderDerivativesFeaturesNV>(const VkPhysicalDeviceComputeShaderDerivativesFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMeshShaderFeaturesNV>(const VkPhysicalDeviceMeshShaderFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMeshShaderPropertiesNV>(const VkPhysicalDeviceMeshShaderPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDrawMeshTasksIndirectCommandNV>(const VkDrawMeshTasksIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderImageFootprintFeaturesNV>(const VkPhysicalDeviceShaderImageFootprintFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportExclusiveScissorStateCreateInfoNV>(const VkPipelineViewportExclusiveScissorStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExclusiveScissorFeaturesNV>(const VkPhysicalDeviceExclusiveScissorFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueueFamilyCheckpointPropertiesNV>(const VkQueueFamilyCheckpointPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCheckpointDataNV>(const VkCheckpointDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL>(const VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkInitializePerformanceApiInfoINTEL>(const VkInitializePerformanceApiInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkQueryPoolPerformanceQueryCreateInfoINTEL>(const VkQueryPoolPerformanceQueryCreateInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceMarkerInfoINTEL>(const VkPerformanceMarkerInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceStreamMarkerInfoINTEL>(const VkPerformanceStreamMarkerInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceOverrideInfoINTEL>(const VkPerformanceOverrideInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPerformanceConfigurationAcquireInfoINTEL>(const VkPerformanceConfigurationAcquireInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePCIBusInfoPropertiesEXT>(const VkPhysicalDevicePCIBusInfoPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDisplayNativeHdrSurfaceCapabilitiesAMD>(const VkDisplayNativeHdrSurfaceCapabilitiesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSwapchainDisplayNativeHdrCreateInfoAMD>(const VkSwapchainDisplayNativeHdrCreateInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImagePipeSurfaceCreateInfoFUCHSIA>(const VkImagePipeSurfaceCreateInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMetalSurfaceCreateInfoEXT>(const VkMetalSurfaceCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentDensityMapFeaturesEXT>(const VkPhysicalDeviceFragmentDensityMapFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentDensityMapPropertiesEXT>(const VkPhysicalDeviceFragmentDensityMapPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassFragmentDensityMapCreateInfoEXT>(const VkRenderPassFragmentDensityMapCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderCoreProperties2AMD>(const VkPhysicalDeviceShaderCoreProperties2AMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCoherentMemoryFeaturesAMD>(const VkPhysicalDeviceCoherentMemoryFeaturesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT>(const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMemoryBudgetPropertiesEXT>(const VkPhysicalDeviceMemoryBudgetPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMemoryPriorityFeaturesEXT>(const VkPhysicalDeviceMemoryPriorityFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryPriorityAllocateInfoEXT>(const VkMemoryPriorityAllocateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV>(const VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceBufferDeviceAddressFeaturesEXT>(const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBufferDeviceAddressCreateInfoEXT>(const VkBufferDeviceAddressCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkValidationFeaturesEXT>(const VkValidationFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCooperativeMatrixPropertiesNV>(const VkCooperativeMatrixPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCooperativeMatrixFeaturesNV>(const VkPhysicalDeviceCooperativeMatrixFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCooperativeMatrixPropertiesNV>(const VkPhysicalDeviceCooperativeMatrixPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCoverageReductionModeFeaturesNV>(const VkPhysicalDeviceCoverageReductionModeFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineCoverageReductionStateCreateInfoNV>(const VkPipelineCoverageReductionStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkFramebufferMixedSamplesCombinationNV>(const VkFramebufferMixedSamplesCombinationNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT>(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceYcbcrImageArraysFeaturesEXT>(const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceProvokingVertexFeaturesEXT>(const VkPhysicalDeviceProvokingVertexFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceProvokingVertexPropertiesEXT>(const VkPhysicalDeviceProvokingVertexPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT>(const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceFullScreenExclusiveInfoEXT>(const VkSurfaceFullScreenExclusiveInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceCapabilitiesFullScreenExclusiveEXT>(const VkSurfaceCapabilitiesFullScreenExclusiveEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSurfaceFullScreenExclusiveWin32InfoEXT>(const VkSurfaceFullScreenExclusiveWin32InfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkHeadlessSurfaceCreateInfoEXT>(const VkHeadlessSurfaceCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceLineRasterizationFeaturesEXT>(const VkPhysicalDeviceLineRasterizationFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceLineRasterizationPropertiesEXT>(const VkPhysicalDeviceLineRasterizationPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineRasterizationLineStateCreateInfoEXT>(const VkPipelineRasterizationLineStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderAtomicFloatFeaturesEXT>(const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceIndexTypeUint8FeaturesEXT>(const VkPhysicalDeviceIndexTypeUint8FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT>(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT>(const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV>(const VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV>(const VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGraphicsShaderGroupCreateInfoNV>(const VkGraphicsShaderGroupCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGraphicsPipelineShaderGroupsCreateInfoNV>(const VkGraphicsPipelineShaderGroupsCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindShaderGroupIndirectCommandNV>(const VkBindShaderGroupIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindIndexBufferIndirectCommandNV>(const VkBindIndexBufferIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkBindVertexBufferIndirectCommandNV>(const VkBindVertexBufferIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSetStateFlagsIndirectCommandNV>(const VkSetStateFlagsIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkIndirectCommandsStreamNV>(const VkIndirectCommandsStreamNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkIndirectCommandsLayoutTokenNV>(const VkIndirectCommandsLayoutTokenNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkIndirectCommandsLayoutCreateInfoNV>(const VkIndirectCommandsLayoutCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGeneratedCommandsInfoNV>(const VkGeneratedCommandsInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGeneratedCommandsMemoryRequirementsInfoNV>(const VkGeneratedCommandsMemoryRequirementsInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceInheritedViewportScissorFeaturesNV>(const VkPhysicalDeviceInheritedViewportScissorFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferInheritanceViewportScissorInfoNV>(const VkCommandBufferInheritanceViewportScissorInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT>(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassTransformBeginInfoQCOM>(const VkRenderPassTransformBeginInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCommandBufferInheritanceRenderPassTransformInfoQCOM>(const VkCommandBufferInheritanceRenderPassTransformInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT>(const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceMemoryReportCallbackDataEXT>(const VkDeviceMemoryReportCallbackDataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceDeviceMemoryReportCreateInfoEXT>(const VkDeviceDeviceMemoryReportCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRobustness2FeaturesEXT>(const VkPhysicalDeviceRobustness2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRobustness2PropertiesEXT>(const VkPhysicalDeviceRobustness2PropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerCustomBorderColorCreateInfoEXT>(const VkSamplerCustomBorderColorCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCustomBorderColorPropertiesEXT>(const VkPhysicalDeviceCustomBorderColorPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceCustomBorderColorFeaturesEXT>(const VkPhysicalDeviceCustomBorderColorFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDiagnosticsConfigFeaturesNV>(const VkPhysicalDeviceDiagnosticsConfigFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDeviceDiagnosticsConfigCreateInfoNV>(const VkDeviceDiagnosticsConfigCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT>(const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT>(const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkGraphicsPipelineLibraryCreateInfoEXT>(const VkGraphicsPipelineLibraryCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD>(const VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV>(const VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV>(const VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineFragmentShadingRateEnumStateCreateInfoNV>(const VkPipelineFragmentShadingRateEnumStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureGeometryMotionTrianglesDataNV>(const VkAccelerationStructureGeometryMotionTrianglesDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureMotionInfoNV>(const VkAccelerationStructureMotionInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureMatrixMotionInstanceNV>(const VkAccelerationStructureMatrixMotionInstanceNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSRTDataNV>(const VkSRTDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureSRTMotionInstanceNV>(const VkAccelerationStructureSRTMotionInstanceNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRayTracingMotionBlurFeaturesNV>(const VkPhysicalDeviceRayTracingMotionBlurFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT>(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentDensityMap2FeaturesEXT>(const VkPhysicalDeviceFragmentDensityMap2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentDensityMap2PropertiesEXT>(const VkPhysicalDeviceFragmentDensityMap2PropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyCommandTransformInfoQCOM>(const VkCopyCommandTransformInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageCompressionControlFeaturesEXT>(const VkPhysicalDeviceImageCompressionControlFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageCompressionControlEXT>(const VkImageCompressionControlEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubresourceLayout2EXT>(const VkSubresourceLayout2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageSubresource2EXT>(const VkImageSubresource2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageCompressionPropertiesEXT>(const VkImageCompressionPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT>(const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevice4444FormatsFeaturesEXT>(const VkPhysicalDevice4444FormatsFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesARM>(const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesARM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT>(const VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDirectFBSurfaceCreateInfoEXT>(const VkDirectFBSurfaceCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE>(const VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMutableDescriptorTypeListVALVE>(const VkMutableDescriptorTypeListVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMutableDescriptorTypeCreateInfoVALVE>(const VkMutableDescriptorTypeCreateInfoVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT>(const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkVertexInputBindingDescription2EXT>(const VkVertexInputBindingDescription2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkVertexInputAttributeDescription2EXT>(const VkVertexInputAttributeDescription2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDrmPropertiesEXT>(const VkPhysicalDeviceDrmPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDepthClipControlFeaturesEXT>(const VkPhysicalDeviceDepthClipControlFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineViewportDepthClipControlCreateInfoEXT>(const VkPipelineViewportDepthClipControlCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT>(const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportMemoryZirconHandleInfoFUCHSIA>(const VkImportMemoryZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryZirconHandlePropertiesFUCHSIA>(const VkMemoryZirconHandlePropertiesFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryGetZirconHandleInfoFUCHSIA>(const VkMemoryGetZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImportSemaphoreZirconHandleInfoFUCHSIA>(const VkImportSemaphoreZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSemaphoreGetZirconHandleInfoFUCHSIA>(const VkSemaphoreGetZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceInvocationMaskFeaturesHUAWEI>(const VkPhysicalDeviceInvocationMaskFeaturesHUAWEI& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMemoryGetRemoteAddressInfoNV>(const VkMemoryGetRemoteAddressInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExternalMemoryRDMAFeaturesNV>(const VkPhysicalDeviceExternalMemoryRDMAFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT>(const VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassResolvePerformanceQueryEXT>(const VkSubpassResolvePerformanceQueryEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMultisampledRenderToSingleSampledInfoEXT>(const VkMultisampledRenderToSingleSampledInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT>(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkScreenSurfaceCreateInfoQNX>(const VkScreenSurfaceCreateInfoQNX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceColorWriteEnableFeaturesEXT>(const VkPhysicalDeviceColorWriteEnableFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineColorWriteCreateInfoEXT>(const VkPipelineColorWriteCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT>(const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageViewMinLodFeaturesEXT>(const VkPhysicalDeviceImageViewMinLodFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewMinLodCreateInfoEXT>(const VkImageViewMinLodCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMultiDrawFeaturesEXT>(const VkPhysicalDeviceMultiDrawFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceMultiDrawPropertiesEXT>(const VkPhysicalDeviceMultiDrawPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMultiDrawInfoEXT>(const VkMultiDrawInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkMultiDrawIndexedInfoEXT>(const VkMultiDrawIndexedInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImage2DViewOf3DFeaturesEXT>(const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceBorderColorSwizzleFeaturesEXT>(const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSamplerBorderColorComponentMappingCreateInfoEXT>(const VkSamplerBorderColorComponentMappingCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT>(const VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE>(const VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetBindingReferenceVALVE>(const VkDescriptorSetBindingReferenceVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkDescriptorSetLayoutHostMappingInfoVALVE>(const VkDescriptorSetLayoutHostMappingInfoVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT>(const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM>(const VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM>(const VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkSubpassFragmentDensityMapOffsetEndInfoQCOM>(const VkSubpassFragmentDensityMapOffsetEndInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceLinearColorAttachmentFeaturesNV>(const VkPhysicalDeviceLinearColorAttachmentFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT>(const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkImageViewSampleWeightCreateInfoQCOM>(const VkImageViewSampleWeightCreateInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageProcessingFeaturesQCOM>(const VkPhysicalDeviceImageProcessingFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceImageProcessingPropertiesQCOM>(const VkPhysicalDeviceImageProcessingPropertiesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT>(const VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassCreationControlEXT>(const VkRenderPassCreationControlEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassCreationFeedbackInfoEXT>(const VkRenderPassCreationFeedbackInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassCreationFeedbackCreateInfoEXT>(const VkRenderPassCreationFeedbackCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassSubpassFeedbackInfoEXT>(const VkRenderPassSubpassFeedbackInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRenderPassSubpassFeedbackCreateInfoEXT>(const VkRenderPassSubpassFeedbackCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT>(const VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT>(const VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPipelineShaderStageModuleIdentifierCreateInfoEXT>(const VkPipelineShaderStageModuleIdentifierCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkShaderModuleIdentifierEXT>(const VkShaderModuleIdentifierEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceTilePropertiesFeaturesQCOM>(const VkPhysicalDeviceTilePropertiesFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkTilePropertiesQCOM>(const VkTilePropertiesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceAmigoProfilingFeaturesSEC>(const VkPhysicalDeviceAmigoProfilingFeaturesSEC& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAmigoProfilingSubmitInfoSEC>(const VkAmigoProfilingSubmitInfoSEC& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureBuildRangeInfoKHR>(const VkAccelerationStructureBuildRangeInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureGeometryTrianglesDataKHR>(const VkAccelerationStructureGeometryTrianglesDataKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureGeometryAabbsDataKHR>(const VkAccelerationStructureGeometryAabbsDataKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureGeometryInstancesDataKHR>(const VkAccelerationStructureGeometryInstancesDataKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureBuildGeometryInfoKHR>(const VkAccelerationStructureBuildGeometryInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureCreateInfoKHR>(const VkAccelerationStructureCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkWriteDescriptorSetAccelerationStructureKHR>(const VkWriteDescriptorSetAccelerationStructureKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceAccelerationStructureFeaturesKHR>(const VkPhysicalDeviceAccelerationStructureFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceAccelerationStructurePropertiesKHR>(const VkPhysicalDeviceAccelerationStructurePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureDeviceAddressInfoKHR>(const VkAccelerationStructureDeviceAddressInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureVersionInfoKHR>(const VkAccelerationStructureVersionInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyAccelerationStructureToMemoryInfoKHR>(const VkCopyAccelerationStructureToMemoryInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyMemoryToAccelerationStructureInfoKHR>(const VkCopyMemoryToAccelerationStructureInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkCopyAccelerationStructureInfoKHR>(const VkCopyAccelerationStructureInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkAccelerationStructureBuildSizesInfoKHR>(const VkAccelerationStructureBuildSizesInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRayTracingShaderGroupCreateInfoKHR>(const VkRayTracingShaderGroupCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRayTracingPipelineInterfaceCreateInfoKHR>(const VkRayTracingPipelineInterfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkRayTracingPipelineCreateInfoKHR>(const VkRayTracingPipelineCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRayTracingPipelineFeaturesKHR>(const VkPhysicalDeviceRayTracingPipelineFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRayTracingPipelinePropertiesKHR>(const VkPhysicalDeviceRayTracingPipelinePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkStridedDeviceAddressRegionKHR>(const VkStridedDeviceAddressRegionKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkTraceRaysIndirectCommandKHR>(const VkTraceRaysIndirectCommandKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<VkPhysicalDeviceRayQueryFeaturesKHR>(const VkPhysicalDeviceRayQueryFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
GFXRECON_END_NAMESPACE(util)
GFXRECON_END_NAMESPACE(gfxrecon)

#endif
