#include <uae/uae.h>
#include <fs/emu.h>
#include "fs-uae.h"

static fs_emu_key_translation g_default_keymap[] = {
    { FS_ML_KEY_ESCAPE, -1, INPUTEVENT_KEY_ESC },

    { FS_ML_KEY_F1, -1, INPUTEVENT_KEY_F1 },
    { FS_ML_KEY_F2, -1, INPUTEVENT_KEY_F2 },
    { FS_ML_KEY_F3, -1, INPUTEVENT_KEY_F3 },
    { FS_ML_KEY_F4, -1, INPUTEVENT_KEY_F4 },
    { FS_ML_KEY_F5, -1, INPUTEVENT_KEY_F5 },
    { FS_ML_KEY_F6, -1, INPUTEVENT_KEY_F6 },
    { FS_ML_KEY_F7, -1, INPUTEVENT_KEY_F7 },
    { FS_ML_KEY_F8, -1, INPUTEVENT_KEY_F8 },
    { FS_ML_KEY_F9, -1, INPUTEVENT_KEY_F9 },
    { FS_ML_KEY_F10, -1, INPUTEVENT_KEY_F10 },

    { FS_ML_KEY_1, -1, INPUTEVENT_KEY_1 },
    { FS_ML_KEY_2, -1, INPUTEVENT_KEY_2 },
    { FS_ML_KEY_3, -1, INPUTEVENT_KEY_3 },
    { FS_ML_KEY_4, -1, INPUTEVENT_KEY_4 },
    { FS_ML_KEY_5, -1, INPUTEVENT_KEY_5 },
    { FS_ML_KEY_6, -1, INPUTEVENT_KEY_6 },
    { FS_ML_KEY_7, -1, INPUTEVENT_KEY_7 },
    { FS_ML_KEY_8, -1, INPUTEVENT_KEY_8 },
    { FS_ML_KEY_9, -1, INPUTEVENT_KEY_9 },
    { FS_ML_KEY_0, -1, INPUTEVENT_KEY_0 },

    { FS_ML_KEY_TAB, -1, INPUTEVENT_KEY_TAB },

    { FS_ML_KEY_A, -1, INPUTEVENT_KEY_A },
    { FS_ML_KEY_B, -1, INPUTEVENT_KEY_B },
    { FS_ML_KEY_C, -1, INPUTEVENT_KEY_C },
    { FS_ML_KEY_D, -1, INPUTEVENT_KEY_D },
    { FS_ML_KEY_E, -1, INPUTEVENT_KEY_E },
    { FS_ML_KEY_F, -1, INPUTEVENT_KEY_F },
    { FS_ML_KEY_G, -1, INPUTEVENT_KEY_G },
    { FS_ML_KEY_H, -1, INPUTEVENT_KEY_H },
    { FS_ML_KEY_I, -1, INPUTEVENT_KEY_I },
    { FS_ML_KEY_J, -1, INPUTEVENT_KEY_J },
    { FS_ML_KEY_K, -1, INPUTEVENT_KEY_K },
    { FS_ML_KEY_L, -1, INPUTEVENT_KEY_L },
    { FS_ML_KEY_M, -1, INPUTEVENT_KEY_M },
    { FS_ML_KEY_N, -1, INPUTEVENT_KEY_N },
    { FS_ML_KEY_O, -1, INPUTEVENT_KEY_O },
    { FS_ML_KEY_P, -1, INPUTEVENT_KEY_P },
    { FS_ML_KEY_Q, -1, INPUTEVENT_KEY_Q },
    { FS_ML_KEY_R, -1, INPUTEVENT_KEY_R },
    { FS_ML_KEY_S, -1, INPUTEVENT_KEY_S },
    { FS_ML_KEY_T, -1, INPUTEVENT_KEY_T },
    { FS_ML_KEY_U, -1, INPUTEVENT_KEY_U },
    { FS_ML_KEY_W, -1, INPUTEVENT_KEY_W },
    { FS_ML_KEY_V, -1, INPUTEVENT_KEY_V },
    { FS_ML_KEY_X, -1, INPUTEVENT_KEY_X },
    { FS_ML_KEY_Y, -1, INPUTEVENT_KEY_Y },
    { FS_ML_KEY_Z, -1, INPUTEVENT_KEY_Z },

    // FIXME:  ID_FLAG_TOGGLE
    { FS_ML_KEY_CAPSLOCK, -1, INPUTEVENT_KEY_CAPS_LOCK},

    { FS_ML_KEY_KP1, -1, INPUTEVENT_KEY_NP_1 },
    { FS_ML_KEY_KP2, -1, INPUTEVENT_KEY_NP_2 },
    { FS_ML_KEY_KP3, -1, INPUTEVENT_KEY_NP_3 },
    { FS_ML_KEY_KP4, -1, INPUTEVENT_KEY_NP_4 },
    { FS_ML_KEY_KP5, -1, INPUTEVENT_KEY_NP_5 },
    { FS_ML_KEY_KP6, -1, INPUTEVENT_KEY_NP_6 },
    { FS_ML_KEY_KP7, -1, INPUTEVENT_KEY_NP_7 },
    { FS_ML_KEY_KP8, -1, INPUTEVENT_KEY_NP_8 },
    { FS_ML_KEY_KP9, -1, INPUTEVENT_KEY_NP_9 },
    { FS_ML_KEY_KP0, -1, INPUTEVENT_KEY_NP_0 },
    { FS_ML_KEY_KP_PERIOD, -1, INPUTEVENT_KEY_NP_PERIOD },
    { FS_ML_KEY_KP_PLUS, -1, INPUTEVENT_KEY_NP_ADD },
    { FS_ML_KEY_KP_MINUS, -1, INPUTEVENT_KEY_NP_SUB },
    { FS_ML_KEY_KP_MULTIPLY, -1, INPUTEVENT_KEY_NP_MUL },
    { FS_ML_KEY_KP_DIVIDE, -1, INPUTEVENT_KEY_NP_DIV },
    { FS_ML_KEY_KP_ENTER, -1, INPUTEVENT_KEY_ENTER },

    { FS_ML_KEY_MINUS, -1, INPUTEVENT_KEY_SUB },
    { FS_ML_KEY_EQUALS, -1, INPUTEVENT_KEY_EQUALS },
    { FS_ML_KEY_BACKSPACE, -1, INPUTEVENT_KEY_BACKSPACE },
    { FS_ML_KEY_RETURN, -1, INPUTEVENT_KEY_RETURN },
    { FS_ML_KEY_SPACE, -1, INPUTEVENT_KEY_SPACE },

    { FS_ML_KEY_LSHIFT, -1, INPUTEVENT_KEY_SHIFT_LEFT },
    { FS_ML_KEY_LCTRL, -1, INPUTEVENT_KEY_CTRL },
    // FIXME:
    { FS_ML_KEY_LSUPER, -1, INPUTEVENT_KEY_AMIGA_LEFT },
    { FS_ML_KEY_LMETA, -1, INPUTEVENT_KEY_AMIGA_LEFT },
    { FS_ML_KEY_LALT, -1, INPUTEVENT_KEY_ALT_LEFT },
    { FS_ML_KEY_RALT, -1, INPUTEVENT_KEY_ALT_RIGHT },
    // FIXME:
    { FS_ML_KEY_RSUPER, -1, INPUTEVENT_KEY_AMIGA_RIGHT },
    { FS_ML_KEY_RMETA, -1, INPUTEVENT_KEY_AMIGA_RIGHT },
    { FS_ML_KEY_MENU, -1, INPUTEVENT_KEY_AMIGA_RIGHT },
    //{ FS_ML_KEY_RCTRL, -1, INPUTEVENT_KEY_CTRL_RIGHT },
    { FS_ML_KEY_RSHIFT, -1, INPUTEVENT_KEY_SHIFT_RIGHT },

    { FS_ML_KEY_UP, -1, INPUTEVENT_KEY_CURSOR_UP },
    { FS_ML_KEY_DOWN, -1, INPUTEVENT_KEY_CURSOR_DOWN },
    { FS_ML_KEY_LEFT, -1, INPUTEVENT_KEY_CURSOR_LEFT },
    { FS_ML_KEY_RIGHT, -1, INPUTEVENT_KEY_CURSOR_RIGHT },

    // 0x2B is the number (hash) key on some international keyboards
    //{ FS_ML_KEY_INSERT, -1, INPUTEVENT_KEY_2B },
    { FS_ML_KEY_INSERT, -1, INPUTEVENT_KEY_BACKSLASH },
    { FS_ML_KEY_HOME, -1, INPUTEVENT_KEY_NP_LPAREN },
    { FS_ML_KEY_PAGEUP, -1, INPUTEVENT_KEY_NP_RPAREN },

    { FS_ML_KEY_DELETE, -1, INPUTEVENT_KEY_DEL },
    { FS_ML_KEY_END, -1, INPUTEVENT_KEY_HELP },
    { FS_ML_KEY_PAGEDOWN, -1, INPUTEVENT_KEY_AMIGA_RIGHT },

    { FS_ML_KEY_LEFTBRACKET, -1, INPUTEVENT_KEY_LEFTBRACKET },
    { FS_ML_KEY_RIGHTBRACKET, -1, INPUTEVENT_KEY_RIGHTBRACKET },
    { FS_ML_KEY_SEMICOLON, -1, INPUTEVENT_KEY_SEMICOLON },
    { FS_ML_KEY_QUOTE, -1, INPUTEVENT_KEY_SINGLEQUOTE },
    { FS_ML_KEY_BACKQUOTE, -1, INPUTEVENT_KEY_BACKQUOTE },

    //{ FS_ML_KEY_BACKSLASH, -1, INPUTEVENT_KEY_BACKSLASH },
    { FS_ML_KEY_BACKSLASH, -1, INPUTEVENT_KEY_2B },

    { FS_ML_KEY_COMMA, -1, INPUTEVENT_KEY_COMMA },
    { FS_ML_KEY_PERIOD, -1, INPUTEVENT_KEY_PERIOD },
    { FS_ML_KEY_SLASH, -1, INPUTEVENT_KEY_DIV },

    // 0x30 is to the left of Z
    { FS_ML_KEY_LESS, -1, INPUTEVENT_KEY_30 },

    // FIXME: international key??
    //{ DIK_OEM_102, -1, INPUTEVENT_KEY_30 },

    // FIXME:

    //{ INPUTEVENT_KEY_30, -1, INPUTEVENT_KEY_30 },
    //{ INPUTEVENT_SPC_MASTER_VOLUME_DOWN, -1, INPUTEVENT_SPC_MASTER_VOLUME_DOWN },
    //{ INPUTEVENT_SPC_MASTER_VOLUME_UP, -1, INPUTEVENT_SPC_MASTER_VOLUME_UP },
    //{ INPUTEVENT_SPC_MASTER_VOLUME_MUTE, -1, INPUTEVENT_SPC_MASTER_VOLUME_MUTE },
    //{ INPUTEVENT_KEY_70, -1, INPUTEVENT_KEY_70 },
    //{ INPUTEVENT_KEY_71, -1, INPUTEVENT_KEY_71 },
    //    { DIK_SYSRQ, -1, INPUTEVENT_KEY_6E },
    //    { DIK_F12, -1, INPUTEVENT_KEY_6F },
    //{ INPUTEVENT_KEY_47, -1, INPUTEVENT_KEY_47 },
    //    { DIK_PRIOR, -1, INPUTEVENT_KEY_48 },
    //{ INPUTEVENT_SPC_FREEZEBUTTON, -1, INPUTEVENT_SPC_FREEZEBUTTON },
    //{ INPUTEVENT_KEY_49, -1, INPUTEVENT_KEY_49 },
    //{ INPUTEVENT_KEY_4B, -1, INPUTEVENT_KEY_4B },

    //{ INPUTEVENT_KEY_CDTV_STOP, -1, INPUTEVENT_KEY_CDTV_STOP },
    //{ INPUTEVENT_KEY_CDTV_PLAYPAUSE, -1, INPUTEVENT_KEY_CDTV_PLAYPAUSE },
    //{ INPUTEVENT_KEY_CDTV_PREV, -1, INPUTEVENT_KEY_CDTV_PREV },
    //{ INPUTEVENT_KEY_CDTV_NEXT, -1, INPUTEVENT_KEY_CDTV_NEXT },

    // end of keyboard map sentinel
    { 0, 0, 0 },
};

void fs_uae_map_keyboard(void) {
    fs_emu_set_keyboard_translation(g_default_keymap);
}
