﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

#pragma warning disable CS0618 // Type or member is obsolete

namespace FlickrNet
{
    public partial class Flickr
    {
        /// <summary>
        /// Retrieve a temporary FROB from the Flickr service, to be used in redirecting the
        /// user to the Flickr web site for authentication. Only required for desktop authentication.
        /// </summary>
        /// <remarks>
        /// Pass the FROB to the <see cref="AuthCalcUrl"/> method to calculate the url.
        /// </remarks>
        /// <example>
        /// <code>
        /// string frob = flickr.AuthGetFrob();
        /// string url = flickr.AuthCalcUrl(frob, AuthLevel.Read);
        /// 
        /// // redirect the user to the url above and then wait till they have authenticated and return to the app.
        /// 
        /// Auth auth = flickr.AuthGetToken(frob);
        /// 
        /// // then store the auth.Token for later use.
        /// string token = auth.Token;
        /// </code>
        /// </example>
        /// <returns>The FROB.</returns>
        [Obsolete("Use OAuth now.")]
        public string AuthGetFrob()
        {
            CheckSigned();

            var parameters = new Dictionary<string, string>();
            parameters.Add("method", "flickr.auth.getFrob");

            UnknownResponse response = GetResponseNoCache<UnknownResponse>(parameters);

            return response.GetXmlDocument().SelectSingleNode("frob/text()").Value;
        }


        /// <summary>
        /// After the user has authenticated your application on the flickr web site call this 
        /// method with the FROB (either stored from <see cref="AuthGetFrob"/> or returned in the URL
        /// from the Flickr web site) to get the users token.
        /// </summary>
        /// <param name="frob">The string containing the FROB.</param>
        /// <returns>A <see cref="Auth"/> object containing user and token details.</returns>
        [Obsolete("Use OAuth now.")]
        public Auth AuthGetToken(string frob)
        {
            CheckSigned();

            var parameters = new Dictionary<string, string>();
            parameters.Add("method", "flickr.auth.getToken");
            parameters.Add("frob", frob);

            Auth auth = GetResponseNoCache<Auth>(parameters);
            AuthToken = auth.Token;
            return auth;
        }

        /// <summary>
        /// Gets the full token details for a given mini token, entered by the user following a 
        /// web based authentication.
        /// </summary>
        /// <param name="miniToken">The mini token.</param>
        /// <returns>An instance <see cref="Auth"/> class, detailing the user and their full token.</returns>
        [Obsolete("Use OAuth now.")]
        public Auth AuthGetFullToken(string miniToken)
        {
            CheckSigned();

            var parameters = new Dictionary<string, string>();
            parameters.Add("method", "flickr.auth.getFullToken");
            parameters.Add("mini_token", miniToken.Replace("-", string.Empty));

            Auth auth = GetResponseNoCache<Auth>(parameters);
            AuthToken = auth.Token;
            return auth;
        }

        /// <summary>
        /// Checks the currently set authentication token with the flickr service to make
        /// sure it is still valid.
        /// </summary>
        /// <returns>The <see cref="Auth"/> object detailing the user for the token.</returns>
        public Auth AuthCheckToken()
        {
            CheckRequiresAuthentication();

            return AuthCheckToken(AuthToken);
        }

        /// <summary>
        /// Checks a authentication token with the flickr service to make
        /// sure it is still valid.
        /// </summary>
        /// <param name="token">The authentication token to check.</param>
        /// <returns>The <see cref="Auth"/> object detailing the user for the token.</returns>
        public Auth AuthCheckToken(string token)
        {
            CheckSigned();

            var parameters = new Dictionary<string, string>();
            parameters.Add("method", "flickr.auth.checkToken");
            parameters.Add("auth_token", token);

            return GetResponseNoCache<Auth>(parameters);
        }

        /// <summary>
        /// Takes the currently (old) authentication Flickr instance and turns it OAuth authenticated instance.
        /// </summary>
        /// <remarks>
        /// Calling this method will also clear <see cref="Flickr.AuthToken"/> 
        /// and set <see cref="Flickr.OAuthAccessToken"/> and <see cref="Flickr.OAuthAccessTokenSecret"/>.
        /// </remarks>
        /// <returns>A new <see cref="OAuthAccessToken"/> instance.</returns>
        public OAuthAccessToken AuthOAuthGetAccessToken()
        {
            CheckRequiresAuthentication();

            var parameters = new Dictionary<string, string>();
            parameters.Add("method", "flickr.auth.oauth.getAccessToken");

            OAuthAccessToken token = GetResponseNoCache<OAuthAccessToken>(parameters);

            OAuthAccessToken = token.Token;
            OAuthAccessTokenSecret = token.TokenSecret;

            AuthToken = null;

            return token;

        }

        /// <summary>
        /// Checks the OAuth token, returns user information and permissions if valid.
        /// </summary>
        /// <returns></returns>
        public Auth AuthOAuthCheckToken()
        {
            CheckRequiresAuthentication();

            var parameters = new Dictionary<string, string>();
            parameters.Add("method", "flickr.auth.oauth.checkToken");

            var o = GetResponseNoCache<Auth>(parameters);

            return o;
        }


    }
}
