# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## The Enterprise Policies feature is aimed at system administrators
## who want to deploy these settings across several Firefox installations
## all at once. This is traditionally done through the Windows Group Policy
## feature, but the system also supports other forms of deployment.
## These are short descriptions for individual policies, to be displayed
## in the documentation section in about:policies.

policy-3rdparty = ਉਹ ਨੀਤੀਆਂ ਸੈਟ ਕਰੋ ਜੋ WebExtensions chrome.storage.managed ਰਾਹੀਂ ਪ੍ਰਾਪਤ ਕਰ ਸਕਦੀਆਂ ਹਨ।
policy-AllowedDomainsForApps = Google Workspace ਲਈ ਪਹੁੰਚ ਵਾਸਤੇ ਇਜਾਜ਼ਤ ਦਿੱਤੀਆਂ ਡੋਮੇਨਾਂ ਦੀ ਪਰਿਭਾਸ਼ਾ।
policy-AppAutoUpdate = ਆਪਣੇ-ਆਪ ਐਪਲੀਕੇਸ਼ਨ ਅੱਪਡੇਟ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
policy-AppUpdatePin = { -brand-short-name } ਨੂੰ ਖਾਸ ਵਰਜ਼ਨ ਤੋਂ ਅੱਗੇ ਅੱਪਡੇਟ ਹੋਣ ਤੋਂ ਰੋਕੋ।
policy-AppUpdateURL = ਕਸਟਮ ਐਪ ਅਪਡੇਟ URL ਸੈੱਟ ਕਰੋ।
policy-Authentication = ਵੈਬਸਾਈਟਾਂ ਲਈ ਇਕਸਾਰ ਪ੍ਰਮਾਣਿਕਤਾ ਨੂੰ ਕੌਂਫਿਗਰ ਕਰੋ ਜੋ ਇਸਦਾ ਸਮਰਥਨ ਕਰਦੀ ਹੈ।
policy-AutoLaunchProtocolsFromOrigins = ਬਾਹਰੀ ਪਰੋਟੋਕਾਲਾਂ ਦੀ ਸੂਚੀ ਦਿਓ, ਜੋ ਕਿ ਸੂਚੀਬੱਧ ਮੁੱਢ ਤੋਂ ਬਿਨਾਂ ਵਰਤੋਂਕਾਰ ਦੇ ਪੁੱਛੇ ਵਰਤੇ ਜਾ ਸਕਦੇ ਹਨ।
policy-BackgroundAppUpdate2 = ਬੈਕਗਰਾਊਂਡ ਅੱਪਡੇਟਰ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
policy-BlockAboutAddons = ਐਡ-ਆਨ ਮੈਨੇਜਰ (about:addons) ਤਕ ਪਹੁੰਚ ਉੱਤੇ ਪਾਬੰਦੀ ਲਾਓ।
policy-BlockAboutConfig = about:config ਸਫ਼ੇ ਲਈ ਪਹੁੰਚ ਤੇ ਪਾਬੰਦੀ ਲਗਾਓ।
policy-BlockAboutProfiles = about:profiles ਸਫ਼ੇ ਲਈ ਪਹੁੰਚ ਤੇ ਪਾਬੰਦੀ ਲਗਾਓ।
policy-BlockAboutSupport = about:support ਸਫ਼ੇ ਉੱਤੇ ਪਹੁੰਚ ਉੱਤੇ ਪਾਬੰਦੀ ਲਾਓ।
policy-Bookmarks = ਬੁੱਕਮਾਰਕ ਟੂਲਬਾਰ, ਬੁੱਕਮਾਰਕ ਮੇਨੂ ਜਾਂ ਨਿਯਤ ਕੀਤੇ ਫੋਲਡਰ ਵਿੱਚ ਬੁੱਕਮਾਰਕ ਬਣਾਓ।
policy-CaptivePortal = ਕੈਪੀਟਿਵ ਪੋਰਟਲ ਸਹਾਇਤਾ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
policy-CertificatesDescription = ਸਰਟੀਫਿਕੇਟ ਜੋੜੋ ਜਾਂ ਵਿਚੇ ਮੌਜੂਦ ਸਰਟੀਫਿਕੇਟ ਵਰਤੋਂ।
policy-Cookies = ਵੈੱਬਸਾਈਟਾਂ ਨੂੰ ਕੂਕੀਜ਼ ਸੈੱਟ ਕਰਨ ਦੀ ਇਜਾਜ਼ਤ ਦਿਓ ਜਾਂ ਪਾਬੰਦੀ ਲਗਾਓ।
# Containers in this context is referring to container tabs in Firefox.
policy-Containers = ਕਨਟੇਨਰ ਸੰਬੰਧੀ ਪਾਲਸੀਆਂ ਸੈਟ ਕਰੋ।
policy-DisabledCiphers = ਸੀਫ਼ਰ ਅਸਮਰੱਥ ਕਰੋ।
policy-DefaultDownloadDirectory = ਮੂਲ ਡਾਊਨਲੋਡ ਡਾਇਰੈਕਟਰੀ ਸੈੱਟ ਕਰੋ।
policy-DisableAppUpdate = ਬਰਾਊਜ਼ਰ ਨੂੰ ਅੱਪਡੇਟ ਹੋਣ ਤੋਂ ਰੋਕੋ।
policy-DisableBuiltinPDFViewer = PDF.js, { -brand-short-name } ਵਿੱਚ ਮੌਜੂਦ PDF ਦਰਸ਼ਕ, ਨੂੰ ਅਸਮਰੱਥ ਕਰੋ।
policy-DisableDefaultBrowserAgent = ਡਿਫਾਲਟ ਬਰਾਊਜ਼ਰ ਏਜੰਟ ਨੂੰ ਕੋਈ ਵੀ ਕਾਰਵਾਈ ਕਰਨ ਤੋਂ ਰੋਕੋ। ਸਿਰਫ਼ ਵਿੰਡੋਜ਼ ਲਈ ਲਾਗੂ ਹੈ; ਦੂਜੇ ਪਲੇਟਫਾਰਮਾਂ ਵਿੱਚ ਏਜੰਟ ਨਹੀਂ ਹੁੰਦਾ।
policy-DisableDeveloperTools = ਡਿਵੈਲਪਰ ਟੂਲਾਂ ਲਈ ਪਹੁੰਚ ਵਾਸਤੇ ਪਾਬੰਦੀ ਲਗਾਓ।
policy-DisableFeedbackCommands = ਮੱਦਦ ਮੇਨੂ ਤੋਂ ਫੀਡਬੈਕ ਭੇਜਣ ਲਈ ਕਮਾਂਡਾਂ ਨੂੰ ਅਯੋਗ ਕਰੋ (ਭੇਤ ਸੁਝਾਅ ਜਮ੍ਹਾਂ ਕਰੋ ਅਤੇ ਧੋਖੇਬਾਜ਼ਾਂ ਦੀ ਰਿਪੋਰਟ ਕਰੋ)।
policy-DisableFirefoxAccounts = { -fxaccount-brand-name } ਅਧਾਰਿਤ ਸੇਵਾਵਾਂ, ਸਿੰਕ ਸਮੇਤ, ਨੂੰ ਅਸਮਰੱਥ ਕਰੋ।
# Firefox Screenshots is the name of the feature, and should not be translated.
policy-DisableFirefoxScreenshots = ਫਾਇਰਫਾਕਸ ਸਕਰੀਨਸ਼ਾਟ ਫੀਚਰ ਨੂੰ ਅਸਮਰੱਥ ਕਰੋ।
policy-DisableFirefoxStudies = { -brand-short-name } ਤੋਂ ਚੱਲਦੇ ਅਧਿਐਨਾਂ ਨੂੰ ਰੋਕੋ।
policy-DisableForgetButton = ਭੁਲਾਓ ਬਟਨ ਲਈ ਪਹੁੰਚ ਤੋਂ ਰੋਕੋ।
policy-DisableFormHistory = ਖੋਜ ਅਤੇ ਫਾਰਮ ਅਤੀਤ ਨੂੰ ਯਾਦ ਨਾ ਰੱਖੋ।
policy-DisablePrimaryPasswordCreation = ਜੇ ਇਹ ਸਹੀ ਹੈ, ਤਾਂ ਮੁੱਢਲਾ ਪਾਸਵਰਡ ਨਹੀਂ ਬਣਾਇਆ ਜਾ ਸਕਦਾ।
policy-DisablePasswordReveal = ਸੰਭਾਲੇ ਲਾਗਇਨਾਂ ਵਿੱਚ ਪਾਸਵਰਡ ਵੇਖਣ ਦੀ ਇਜਾਜ਼ਤ ਨਾ ਦਿਓ।
policy-DisablePocket = Pocket ਨੂੰ ਵੈਬ ਪੇਜਿਆਂ ਨੂੰ ਸੁਰੱਖਿਅਤ ਕਰਨ ਲਈ ਵਿਸ਼ੇਸ਼ਤਾ ਨੂੰ ਅਯੋਗ ਕਰੋ।
policy-DisablePocket2 = { -pocket-brand-name } ਨੂੰ ਵੈਬ ਪੇਜਿਆਂ ਨੂੰ ਸੁਰੱਖਿਅਤ ਕਰਨ ਲਈ ਵਿਸ਼ੇਸ਼ਤਾ ਨੂੰ ਅਯੋਗ ਕਰੋ।
policy-DisablePrivateBrowsing = ਪ੍ਰਾਈਵੇਟ ਬਰਾਊਜ਼ਿੰਗ ਅਸਮਰੱਥ ਕਰੋ।
policy-DisableProfileImport = ਕਿਸੇ ਹੋਰ ਬਰਾਊਜ਼ਰ ਤੋਂ ਡਾਟਾ ਦਰਾਮਦ ਕਰਨ ਲਈ ਮੇਨੂ ਕਮਾਂਡ ਨੂੰ ਅਸਮਰੱਥ ਕਰੋ।
policy-DisableProfileRefresh = about:support ਸਫ਼ੇ ਵਿੱਚ { -brand-short-name } ਬਟਨ ਨੂੰ ਤਾਜ਼ਾ ਕਰਨ ਤੋਂ ਰੋਕੋ।
policy-DisableSafeMode = ਸੁਰੱਖਿਅਤ ਮੋਡ ਵਿੱਚ ਰੀਸਟਾਰਟ ਕਰਨ ਲਈ ਵਿਸ਼ੇਸ਼ਤਾ ਨੂੰ ਅਸਮਰੱਥ ਬਣਾਓ। ਨੋਟ: ਸੇਫ ਮੋਡ ਵਿੱਚ ਦਾਖਲ ਕਰਨ ਲਈ ਸ਼ਿਫਟ ਸਵਿੱਚ ਨੂੰ ਸਿਰਫ ਗਰੁੱਪ ਪਾਲਿਸੀ ਦੀ ਵਰਤੋਂ ਨਾਲ ਵਿੰਡੋਜ਼ ਉੱਤੇ ਅਸਮਰੱਥ ਕੀਤਾ ਜਾ ਸਕਦਾ ਹੈ।
policy-DisableSecurityBypass = ਯੂਜ਼ਰ ਨੂੰ ਕੁਝ ਸੁਰੱਖਿਆ ਚੇਤਾਵਨੀਆਂ ਨੂੰ ਅਣਡਿੱਠ ਕਰਨ ਤੋਂ ਰੋਕੋ।
policy-DisableSetAsDesktopBackground = ਮੇਨੂ ਕਮਾਂਡ ਨੂੰ ਅਯੋਗ ਕਰੋ ਚਿੱਤਰਾਂ ਲਈ ਡੈਸਕਟਾਪ ਬੈਕਗਰਾਊਂਡ ਵਾਂਗ ਸੈੱਟ ਕਰੋ।
policy-DisableSystemAddonUpdate = ਬ੍ਰਾਉਜ਼ਰ ਨੂੰ ਸਿਸਟਮ ਐਡ-ਆਨ ਇੰਸਟਾਲ ਕਰਨ ਅਤੇ ਅਪਡੇਟ ਕਰਨ ਤੋਂ ਰੋਕੋ।
policy-DisableTelemetry = ਟੈਲੀਮੈਂਟਰੀ ਬੰਦ ਕਰੋ।
policy-DisableThirdPartyModuleBlocking = ਵਰਤੋਂਕਾਰਾਂ ਨੂੰ ਤੀਜੀ-ਧਿਰ ਮੋਡੀਊਲ ਉੱਤੇ ਪਾਬੰਦੀ ਲਾਉਣ ਤੋਂ ਰੋਕਦੀ ਹੈ, ਜੋ ਕਿ { -brand-short-name } ਕਾਰਵਾਈ ਵਿੱਚ ਪਾਏ ਜਾਂਦੇ ਹਨ।
policy-DisplayBookmarksToolbar = ਬੁੱਕਮਾਰਕ ਟੂਲਬਾਰ ਨੂੰ ਡਿਫਾਲਟ ਰੂਪ ਵਿੱਚ ਦਿਖਾਓ।
policy-DisplayMenuBar = ਡਿਫਾਲਟ ਰੂਪ ਵਿੱਚ ਮੇਨੂ ਪੱਟੀ ਵੇਖੋ।
policy-DNSOverHTTPS = HTTPS ਉੱਤੇ DNS ਦੀ ਸੰਰਚਨਾ ਕਰੋ।
policy-DontCheckDefaultBrowser = ਸ਼ੁਰੂ ਵੇਲੇ ਮੂਲ ਬਰਾਊਜ਼ਰ ਲਈ ਜਾਂਚ ਨੂੰ ਅਸਮਰੱਥ ਕਰੋ।
policy-DownloadDirectory = ਡਾਊਨਲੋਡ ਡਾਇਰੈਕਟਰੀ ਨੂੰ ਸੈਟ ਅਤੇ ਲਾਕ ਕਰੋ।
# “lock” means that the user won’t be able to change this setting
policy-EnableTrackingProtection = ਸਮੱਗਰੀ ਉੱਤੇ ਪਾਬੰਦੀ ਲਗਾਉਣ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ ਅਤੇ ਚੋਣਵੇਂ ਰੂਪ ਵਿੱਚ ਲਾਕ ਕਰੋ।
# “lock” means that the user won’t be able to change this setting
policy-EncryptedMediaExtensions =
    ਇਨਕ੍ਰਿਪਟ ਕੀਤੀਆਂ ਮੀਡੀਆ ਇਕਸਟੈਨਸ਼ਨਾਂ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ 
    ਅਤੇ ਚੋਣਵੇਂ ਤੌਰ ਉਤੇ ਇਸਨੂੰ ਲੌਕ ਕਰੋ।
policy-ExemptDomainFileTypePairsFromFileTypeDownloadWarnings = ਡੋਮੇਨ ਉੱਤੇ ਖਾਸ ਫਾਇਲ ਕਿਸਮਾਂ ਲਈ ਫਾਇਲ ਇਕਸਟੈਨਸ਼ਨਾਂ ਉੱਤੇ ਆਧਾਰਿਤ ਚੇਤਾਵਨੀਆਂ ਅਸਮਰੱਥ ਕਰੋ।
# A “locked” extension can’t be disabled or removed by the user. This policy
# takes 3 keys (“Install”, ”Uninstall”, ”Locked”), you can either keep them in
# English or translate them as verbs.
policy-Extensions = ਇੰਸਟਾਲ ਕਰੋ, ਅਣ-ਇੰਸਟਾਲ ਕਰੋ ਜਾਂ ਇਕਸਟੈਨਸ਼ਨ ਲਾਕ ਕਰੋ। ਇੰਸਟਾਲ ਚੋਣ URL ਜਾਂ ਪਾਥ ਨੂੰ ਪੈਰਾਮੀਟਰ ਦੇ ਤੌਰ ਉੱਤੇ ਲੈਂਦੀ ਹੈ। ਅਣ-ਇੰਸਟਾਲ ਅਤੇ ਲਾਕ ਕੀਤੀ ਇਕਸਟੈਨਸ਼ਨ IDs ਲੈਂਦੇ ਹਨ।
policy-ExtensionSettings = ਇਕਸਟੈਨਸ਼ਨ ਇੰਸਟਾਲੇਸ਼ਨ ਦੇ ਸਾਰੇ ਪੱਖਾਂ ਦਾ ਬੰਦੋਬਸਤ ਕਰੋ।
policy-ExtensionUpdate = ਆਟੋਮੈਟਿਕ ਇਕਸਟੈਨਸ਼ਨ ਅੱਪਡੇਟ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
policy-FirefoxHome = ਫਾਇਰਫਾਕਸ ਮੁੱਖ-ਸੰਰਚਨਾ ਦੀ ਸੰਰਚਨਾ ਹੈ।
policy-FirefoxHome2 = { -firefox-home-brand-name } ਦੀ ਸੰਰਚਨਾ।
policy-FlashPlugin = ਫਲੈਸ਼ ਪਲੱਗਇਨ ਦੀ ਵਰਤੋਂ ਦੀ ਇਜਾਜ਼ਤ ਦਿਓ ਜਾਂ ਪਾਬੰਦੀ ਲਗਾਓ।
policy-GoToIntranetSiteForSingleWordEntryInAddressBar = ਜਦੋਂ ਸਿਰਨਾਵਾਂ ਪੱਟੀ ਵਿੱਚ ਇੱਕਲਾ ਸ਼ਬਦ ਲਿਖਿਆ ਜਾਵੇ ਤਾਂ ਖੋਜ ਕਰਨ ਦੀ ਬਜਾਏ ਸਿੱਧੇ ਇੰਟਰਾਨੈੱਟ ਸਾਈਟ ਉੱਤੇ ਜਾਣ ਲਈ ਮਜ਼ਬੂਰ ਕਰੋ।
policy-Handlers = ਡਿਫਾਲਟ ਐਪਲੀਕੇਸ਼ਨ ਹੈਂਡਲ ਸੰਰਚਨਾ ਕਰੋ।
policy-HardwareAcceleration = ਜੇ ਗਲਤ ਹੈ, ਤਾਂ ਹਾਰਡਵੇਅਰ ਐਕਸਰਲੇਸ਼ਨ ਬੰਦ ਹੁੰਦਾ ਹੈ।
# “lock” means that the user won’t be able to change this setting
policy-Homepage = ਮੁੱਖ ਸਫ਼ੇ ਨੂੰ ਨਿਯਤ ਕਰੋ ਅਤੇ ਚੋਣਵੇਂ ਰੂਪ ਵਿੱਚ ਲਾਕ ਕਰੋ।
policy-InstallAddonsPermission = ਕੁਝ ਵੈੱਬਸਾਈਟਾਂ ਨੂੰ ਐਡ-ਆਨ ਇੰਸਟਾਲ ਕਰਨ ਦੀ ਆਗਿਆ ਦਿਓ।
policy-LegacyProfiles = ਹਰੇਕ ਇੰਸਟਾਲੇਸ਼ਨ ਲਈ ਵੱਖਰੇ ਪਰੋਫਾਈਲ ਨੂੰ ਫੀਚਰ ਲਾਗੂ ਕਰਨ ਨੂੰ ਅਸਮਰੱਥ ਕਰੋ।

## Do not translate "SameSite", it's the name of a cookie attribute.

policy-LegacySameSiteCookieBehaviorEnabled = ਡਿਫਾਲਟ ਪੁਰਾਤਨ SameSite ਕੂਕੀ ਵਿਵਹਾਰ ਸੈਟਿੰਗ ਨੂੰ ਸਮਰੱਥ ਕਰੋ।
policy-LegacySameSiteCookieBehaviorEnabledForDomainList = ਨਿਰਧਾਰਤ ਸਾਈਟਾਂ ਉਤੇ ਕੂਕੀਜ਼ ਲਈ ਪੁਰਾਤਨ SameSite ਸਾਈਟ ਵਿਵਹਾਰ ਲਈ ਪਰਤਾਓ।

##

policy-LocalFileLinks = ਖਾਸ ਵੈੱਬਸਾਈਟਾਂ ਨੂੰ ਲੋਕਲ ਫ਼ਾਈਲਾਂ ਲਈ ਲਿੰਕ ਦੀ ਆਗਿਆ ਦਿਓ।
policy-ManagedBookmarks =
    ਪਰਸ਼ਾਸਕ ਵਲੋਂ ਇੰਤਜ਼ਾਮ ਕੀਤੇ ਬੁੱਕਮਾਰਕਾਂ ਦੀ ਸੂਚੀ ਸੰਰਚਿਤ ਕਰਦਾ ਹੈ, ਜਿਸ ਨੂੰ ਵਰਤੋਂਕਾਰ
    ਬਦਲ ਨਹੀਂ ਸਕਦਾ ਹੈ।
policy-ManualAppUpdateOnly = ਖੁਦ ਅੱਪਡੇਟ ਕਰਨਾ ਹੀ ਮਨਜ਼ੂਰ ਕਰੋ ਅਤੇ ਅੱਪਡੇਟਾਂ ਬਾਰੇ ਵਰਤੋਂਕਾਰ ਨੂੰ ਸੂਚਿਤ ਨਾ ਕਰੋ।
policy-PrimaryPassword = ਮੁੱਖ ਪਾਸਵਰਡ ਵਰਤਣਾ ਚਾਹੀਦਾ ਹੈ ਜਾਂ ਰੋਕਦਾ ਹੈ।
policy-NetworkPrediction = ਨੈੱਟਵਰਕ ਅੰਦਾਜ਼ਾ ਲਗਾਉਣ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਬਣਾਓ (DNS ਪਰੀ-ਫੀਚਿੰਗ)।
policy-NewTabPage = ਨਵੀਂਂ ਟੈਬ ਸਫ਼ਾ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
policy-NoDefaultBookmarks = { -brand-short-name }, ਅਤੇ ਸਮਾਰਟ ਬੁੱਕਮਾਰਕਸ (ਸਭ ਤੋਂ ਵੱਧ ਵੇਖਿਆ ਗਿਆ, ਤਾਜ਼ਾ ਟੈਗਸ) ਨਾਲ ਬੰਡਲ ਕੀਤੇ ਗਏ ਡਿਫੌਲਟ ਬੁੱਕਮਾਰਕ ਦੀ ਰਚਨਾ ਨੂੰ ਅਸਮਰੱਥ ਬਣਾਓ। ਨੋਟ: ਇਹ ਨੀਤੀ ਸਿਰਫ ਪ੍ਰਭਾਵੀ ਹੈ ਜੇਕਰ ਪ੍ਰੋਫਾਈਲ ਦੇ ਪਹਿਲੇ ਦੌਰੇ ਤੋਂ ਪਹਿਲਾਂ ਵਰਤੀ ਜਾਂਦੀ ਹੈ।
policy-OfferToSaveLogins = { -brand-short-name } ਨੂੰ ਸੰਭਾਲੇ ਲਾਗਇਨ ਅਤੇ ਪਾਸਵਰਡਾਂ ਨੂੰ ਯਾਦ ਰੱਖਣ ਦੀ ਪੇਸ਼ਕਸ਼ ਦੀ ਸਹਿਮਤੀ ਦੀ ਸੈਟਿੰਗ ਲਾਗੂ ਕਰੋ। ਦੋਵੇ ਸਹੀ ਅਤੇ ਗਲਤ ਮੁੱਲ ਮਨਜ਼ੂਰ ਕੀਤੇ ਹਨ।
policy-OfferToSaveLoginsDefault = { -brand-short-name } ਨੂੰ ਸੰਭਾਲੇ ਲਾਗਇਨ ਅਤੇ ਪਾਸਵਰਡਾਂ ਨੂੰ ਯਾਦ ਰੱਖਣ ਦੀ ਪੇਸ਼ਕਸ਼ ਦੀ ਸਹਿਮਤੀ ਲਈ ਮੂਲ ਮੁੱਲ ਨਿਯਤ ਕਰੋ। ਦੋਵੇ ਸਹੀ ਅਤੇ ਗਲਤ ਮੁੱਲ ਮਨਜ਼ੂਰ ਕੀਤੇ ਹਨ।
policy-OverrideFirstRunPage = ਪਹਿਲੇ ਰਨ ਪੇਜ਼ ਨੂੰ ਅਣਡਿੱਠਾ ਕਰੋ। ਜੇ ਤੁਸੀਂ ਪਹਿਲੇ ਰਨ ਪੇਜ ਨੂੰ ਅਸਮਰੱਥ ਬਣਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ ਤਾਂ ਇਸ ਨੀਤੀ ਨੂੰ ਖਾਲੀ ਕਰਨ ਲਈ ਸੈੱਟ ਕਰੋ।
policy-OverridePostUpdatePage = ਪੋਸਟ-ਅਪਡੇਟ "ਨਵਾਂ ਕੀ ਹੈ" ਪੰਨੇ ਤੇ ਓਵਰਰਾਈਡ ਕਰੋ ਜੇਕਰ ਤੁਸੀਂ ਪੋਸਟ-ਅਪਡੇਟ ਸਫ਼ਾ ਨੂੰ ਅਸਮਰੱਥ ਬਣਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ ਤਾਂ ਇਸ ਨੀਤੀ ਨੂੰ ਖਾਲੀ ਕਰਨ ਲਈ ਸੈੱਟ ਕਰੋ।
policy-PasswordManagerEnabled = ਪਾਸਵਰਡ ਮੈਨੇਜਰ ਵਿੱਚ ਪਾਸਵਰਡ ਸੰਭਾਲਣਾ ਸਮਰੱਥ ਕਰੋ।
policy-PasswordManagerExceptions = { -brand-short-name } ਨੂੰ ਖਾਸ ਸਾਈਟਾਂ ਲਈ ਪਾਸਵਰਡ ਸੰਭਾਲਣ ਤੋਂ ਰੋਕਦਾ ਹੈ
# PDF.js and PDF should not be translated
policy-PDFjs =
    { -brand-short-name } ਵਿੱਚ ਮੌਜੂਦ PDF ਦਰਸ਼ਕ PDF.js ਨੂੰ ਅਸਮਰੱਥ 
    ਜਾਂ ਸੰਰਚਿਤ ਕਰੋ।
policy-Permissions2 = ਕੈਮਰਾ, ਮਾਈਕਰੋਫੋਨ, ਟਿਕਾਣਾ, ਸੂਚਨਾਵਾਂ ਜਾਂ ਆਪੇ-ਚਲਾਓ ਲਈ ਇਜਾਜ਼ਤਾਂ ਦੀ ਸੰਰਚਨਾ ਕਰੋ।
policy-PictureInPicture = ਤਸਵੀਰ-ਚ-ਤਸਵੀਰ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
policy-PopupBlocking = ਕੁਝ ਵੈਬਸਾਈਟਾਂ ਨੂੰ ਡਿਫੌਲਟ ਦੁਆਰਾ ਪੌਪਅਪਸ ਪ੍ਰਦਰਸ਼ਿਤ ਕਰਨ ਦੀ ਆਗਿਆ ਦਿਓ।
policy-Preferences = ਤਰਜੀਹਾਂ ਦੇ ਸਬਸੈਟ ਲਈ ਮੁੱਲ ਨੂੰ ਸੈਟ ਕਰੋ ਅਤੇ ਲਾਕ ਕਰੋ।
policy-PromptForDownloadLocation = ਡਾਊਨਲੋਡ ਕਰਨ ਵੇਲੇ ਫਾਈਲਾਂ ਨੂੰ ਕਿੱਥੇ ਸੁਰੱਖਿਅਤ ਕਰਨ ਦੇ ਬਾਰੇ ਪੁੱਛੋ।
policy-Proxy = ਪਰਾਕਸੀ ਸੈਟਿੰਗਾਂ ਦੀ ਸੰਰਚਨਾ।
policy-RequestedLocales = ਤਰਜੀਹ ਦੇ ਅਨੁਸਾਰ ਅਰਜ਼ੀ ਲਈ ਲੋੜੀਦੇ ਲੋਕਲਾਂ ਦੀ ਸੂਚੀ ਸੈਟ ਕਰੋ।
policy-SanitizeOnShutdown2 = ਬੰਦ ਕਰਨ ਸਮੇਂ ਨੈਵੀਗੇਸ਼ਨ ਡਾਟਾ ਸਾਫ਼ ਕਰੋ।
policy-SearchBar = ਖੋਜ ਪੱਟੀ ਲਈ ਮੂਲ ਟਿਕਾਣਾ ਨਿਯਤ ਕਰੋ। ਵਰਤੋਂਕਾਰ ਹਾਲੇ ਵੀ ਇਸ ਨੂੰ ਆਪਣੀ ਪਸੰਦ ਮੁਤਾਬਕ ਬਦਲਣ ਲਈ ਆਗਿਆ ਹੁੰਦੀ ਹੈ।
policy-SearchEngines = ਖੋਜ ਇੰਜਣ ਸੈਟਿੰਗਾਂ ਦੀ ਸੰਰਚਨਾ ਕਰੋ। ਇਹ ਨੀਤੀ ਕੇਵਲ ਐਕਸਟੈਂਡਡ ਸਪੋਰਟ ਰੀਲਿਜ਼ (ESR) ਵਰਜ਼ਨ ਨਾਲ ਹੀ ਉਪਲਬਧ ਹੈ।
policy-SearchSuggestEnabled = ਖੋਜ ਸੁਝਾਅ ਨੂੰ ਸਮਰੱਥ ਜਾਂ ਅਸਮਰੱਥ ਕਰੋ।
# For more information, see https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/PKCS11/Module_Installation
policy-SecurityDevices = PKCS # 11 ਮੈਡਿਊਲ ਇੰਸਟਾਲ ਕਰੋ।
# For more information, see https://wikipedia.org/wiki/PKCS_11
policy-SecurityDevices2 = PKCS #11 ਮੋਡੀਊਲ ਜੋੜੋ ਜਾਂ ਹਟਾਓ।
policy-ShowHomeButton = ਟੂਲ-ਪੱਟੀ ਉੱਤੇ ਮੁੱਖ ਬਟਨ ਦਿਖਾਓ।
policy-SSLVersionMax = ਵੱਧ ਤੋਂ ਵੱਧ SSL ਵਰਜ਼ਨ ਨਿਯਤ ਕਰੋ।
policy-SSLVersionMin = ਘੱਟੋ ਘੱਟ SSL ਵਰਜ਼ਨ ਨਿਯਤ ਕਰੋ।
policy-StartDownloadsInTempDirectory = ਡਾਊਨਲੋਡਾਂ ਨੂੰ ਮੂਲ ਡਾਊਨਲੋਡ ਡਾਇਰੈਕਟੜੀ ਦੀ ਬਜਾਏ ਲੋਕਲ, ਆਰਜ਼ੀ ਟਿਕਾਣੇ ਉੱਤੇ ਸ਼ੁਰੂ ਕਰਨ ਲਈ ਮਜ਼ਬੂਰ ਕਰੋ।
policy-SupportMenu = ਸਹਾਇਤਾ ਮੇਨੂ ਵਿੱਚ ਇੱਕ ਕਸਟਮ ਸਹਿਯੋਗ ਮੀਨੂ ਆਈਟਮ ਜੋੜੋ।
policy-UserMessaging = ਵਰਤੋਂਕਾਰ ਨੂੰ ਕੁਝ ਸੁਨੇਹੇ ਨਾ ਵੇਖਾਓ।
policy-UseSystemPrintDialog = ਸਿਸਟਮ ਪਰਿੰਟ ਡਾਈਲਾਗ ਨਾਲ ਪਰਿੰਟ ਕਰੋ।
# “format” refers to the format used for the value of this policy.
policy-WebsiteFilter = ਵੈਬਸਾਈਟ ਨੂੰ ਬਲਾਕ ਕਰਨ ਤੋਂ ਬਲਾਕ ਕਰੋ। ਫੌਰਮੈਟ ਤੇ ਹੋਰ ਵੇਰਵਿਆਂ ਲਈ ਦਸਤਾਵੇਜ਼ ਵੇਖੋ।
policy-Windows10SSO = Microsoft, ਕੰਮ ਤੇ ਸਕੂਲ ਖਾਤਿਆਂ ਲਈ Windows ਇਕਹੇਰੇ ਸਾਈਨ-ਆਨ ਦੀ ਇਜਾਜ਼ਤ ਦਿਓ।
