#pragma once

/*
cddrv.hpp

про сидюк
*/
/*
Copyright (c) 1996 Eugene Roshal
Copyright (c) 2000 Far Group
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the authors may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <WinCompat.h>

enum CDROM_DeviceCapabilities
{
	CAPABILITIES_NONE			= 0x00000000,

	//CD
	CAPABILITIES_READ_CDROM		= 0x00000001,
	CAPABILITIES_READ_CDR		= 0x00000002,
	CAPABILITIES_READ_CDRW		= 0x00000004,

	CAPABILITIES_WRITE_CDR		= 0x00000008,
	CAPABILITIES_WRITE_CDRW		= 0x00000010,

	//DVD
	CAPABILITIES_READ_DVDROM	= 0x00000020,
	CAPABILITIES_READ_DVDR		= 0x00000040,
	CAPABILITIES_READ_DVDRW		= 0x00000080,
	CAPABILITIES_READ_DVDRAM	= 0x00000100,

	CAPABILITIES_WRITE_DVDR		= 0x00000200,
	CAPABILITIES_WRITE_DVDRW	= 0x00000400,
	CAPABILITIES_WRITE_DVDRAM	= 0x00000800,

	//BlueRay
	CAPABILITIES_READ_BDROM		= 0x00001000,
	CAPABILITIES_WRITE_BDROM	= 0x00002000,

	//HD-DVD
	CAPABILITIES_READ_HDDVD		= 0x00004000,
	CAPABILITIES_WRITE_HDDVD	= 0x00008000,

	//GENERIC

	CAPABILITIES_GENERIC_CDROM		= CAPABILITIES_READ_CDROM | CAPABILITIES_READ_CDR | CAPABILITIES_READ_CDRW,
	CAPABILITIES_GENERIC_CDRW		= CAPABILITIES_WRITE_CDR | CAPABILITIES_WRITE_CDRW,
	CAPABILITIES_GENERIC_DVDROM		= CAPABILITIES_READ_DVDROM | CAPABILITIES_READ_DVDR | CAPABILITIES_READ_DVDRW | CAPABILITIES_READ_DVDRAM,
	CAPABILITIES_GENERIC_DVDRW		= CAPABILITIES_WRITE_DVDR | CAPABILITIES_WRITE_DVDRW,
	CAPABILITIES_GENERIC_DVDRAM		= CAPABILITIES_WRITE_DVDRAM,
	
	CAPABILITIES_GENERIC_BDROM		= CAPABILITIES_READ_BDROM,
	CAPABILITIES_GENERIC_BDRW 		= CAPABILITIES_WRITE_BDROM,

	CAPABILITIES_GENERIC_HDDVD		= CAPABILITIES_READ_HDDVD,
	CAPABILITIES_GENERIC_HDDVDRW	= CAPABILITIES_WRITE_HDDVD
};

enum MMC_Features {
	MMC_FEATUREPROFILE_LIST				= 0x0000,
	MMC_FEATURECORE						= 0x0001,
	MMC_FEATURE_MORPHING				= 0x0002,
	MMC_FEATURE_REMOVABLE				= 0x0003,
	MMC_FEATURE_WRITE_PROTECT			= 0x0004,
	MMC_FEATURE_RANDOM_READ				= 0x0010,
	MMC_FEATURE_MULTIREAD				= 0x001D,
	MMC_FEATURE_CD_READ					= 0x001E,
	MMC_FEATURE_DVD_READ				= 0x001F,
	MMC_FEATURE_RANDOM_WRITE			= 0x0020,
	MMC_FEATURE_INC_STREAM_WRITE		= 0x0021,
	MMC_FEATURE_SECTOR_ERASE			= 0x0022,
	MMC_FEATURE_FORMAT					= 0x0023,
	MMC_FEATURE_HW_DEFECT_MANAGEMENT	= 0x0024,
	MMC_FEATURE_WRITE_ONCE				= 0x0025,
	MMC_FEATURE_RESTRICTED_OW			= 0x0026,
	MMC_FEATURE_CWRW_CAV_WRITE			= 0x0027,
	MMC_FEATURE_MRW						= 0x0028,
	MMC_FEATURE_ENH_DEFECT_REPORT		= 0x0029,
	MMC_FEATURE_DVDPLUSRW				= 0x002A,
	MMC_FEATURE_DVDPLUSR				= 0x002B,
	MMC_FEATURE_RIGID_RESTRICTED_OW		= 0x002C,
	MMC_FEATURE_CD_TAO					= 0x002D,
	MMC_FEATURE_CD_MASTERING			= 0x002E,
	MMC_FEATURE_DVDMINUSR_RW_WRITE		= 0x002F,
	MMC_FEATURE_DDCD_READ				= 0x0030,
	MMC_FEATURE_DDCDR_WRITE				= 0x0031,
	MMC_FEATURE_DDCDRW_WRITE			= 0x0032,
	MMC_FEATURE_CDRW_WRITE				= 0x0037,
	MMC_FEATURE_POWER_MANAGEMENT		= 0x0100,
	MMC_FEATURE_SMART					= 0x0101,
	MMC_FEATURE_EMBEDDED_CHARGER		= 0x0102,
	MMC_FEATURE_CD_AUDIO_ANALOG			= 0x0103,
	MMC_FEATURE_MICROCODE_UPGRADE		= 0x0104,
	MMC_FEATURE_TIMEOUT					= 0x0105,
	MMC_FEATURE_DVD_CSS					= 0x0106,
	MMC_FEATURE_REALTIME_STREAM			= 0x0107,
	MMC_FEATURE_DRIVE_SN				= 0x0108,
	MMC_FEATURE_DISC_CTRL_BLOCKS		= 0x010A,
	MMC_FEATURE_DVD_CPRM				= 0x010B,
	MMC_FEATURE_FIRMWARE_INFO			= 0x010C,
	// MMC-5/MMC-6.
	MMC_FEATURE_LAYER_JUMP_REC			= 0x0033,
	MMC_FEATURE_BDR_POW					= 0x0038,
	MMC_FEATURE_DVDPLUSRW_DL			= 0x003A,
	MMC_FEATURE_DVDPLUSR_DL				= 0x003B,
	MMC_FEATURE_BD_READ					= 0x0040,
	MMC_FEATURE_BD_WRITE				= 0x0041,
	MMC_FEATURE_TSR						= 0x0042,
	MMC_FEATURE_HDDVD_READ				= 0x0050,
	MMC_FEATURE_HDDVD_WRITE				= 0x0051,
	MMC_FEATURE_HYBRID_DISC				= 0x0080,
	MMC_FEATURE_AACS					= 0x010D,
	MMC_FEATURE_VCPS					= 0x0110
};


bool IsDriveTypeCDROM(UINT DriveType);
UINT FAR_GetDriveType(const wchar_t *RootDir, CDROM_DeviceCapabilities *caps=nullptr, DWORD Detect=0);
