#
# JsonCpp
#

# If we're building a bundled jsoncpp, JSONCPP_LIB_SRC will be set to
# the path to jsoncpp.cpp and JSONCPP_LIB will be unset.
# If we're using an external jsoncpp, JSONCPP_LIB will be set to the
# path to the jsoncpp library and JSONCPP_LIB_SRC will be unset.

option(USE_BUNDLED_JSONCPP "Enable building of the bundled jsoncpp" ${USE_BUNDLED_DEPS})

if(JSONCPP_INCLUDE AND JSONCPP_LIB)
	message(STATUS "Using jsoncpp: include: ${JSONCPP_INCLUDE}, lib: ${JSONCPP_LIB}")
elseif(NOT USE_BUNDLED_JSONCPP)
	find_path(JSONCPP_INCLUDE json/json.h PATH_SUFFIXES jsoncpp)
	find_library(JSONCPP_LIB NAMES jsoncpp)
	if(JSONCPP_INCLUDE AND JSONCPP_LIB)
		message(STATUS "Found jsoncpp: include: ${JSONCPP_INCLUDE}, lib: ${JSONCPP_LIB}")
	else()
		message(FATAL_ERROR "Couldn't find system jsoncpp")
	endif()
else()
	set(JSONCPP_SRC "${CMAKE_CURRENT_LIST_DIR}/../../userspace/libsinsp/third-party/jsoncpp")
	set(JSONCPP_INCLUDE "${JSONCPP_SRC}/")
	set(JSONCPP_LIB_SRC "${JSONCPP_SRC}/jsoncpp.cpp")
	message(STATUS "Using bundled jsoncpp in '${JSONCPP_SRC}'")
	install(DIRECTORY "${JSONCPP_INCLUDE}" DESTINATION "${CMAKE_INSTALL_INCLUDEDIR}/${LIBS_PACKAGE_NAME}"
			COMPONENT "libs-deps")
endif()

include_directories("${JSONCPP_INCLUDE}")
