/* Emacs style mode select   -*- C -*-
 *-----------------------------------------------------------------------------
 *
 *
 *  PrBoom: a Doom port merged with LxDoom and LSDLDoom
 *  based on BOOM, a modified and improved DOOM engine
 *  Copyright (C) 1999 by
 *  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
 *  Copyright (C) 1999-2000 by
 *  Jess Haas, Nicolas Kalkhof, Colin Phipps, Florian Schulze
 *  Copyright 2005, 2006 by
 *  Florian Schulze, Colin Phipps, Neil Stevens, Andrey Budko
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 *
 * DESCRIPTION:
 *      Thing frame/state LUT,
 *      generated by multigen utilitiy.
 *      This one is the original DOOM version, preserved.
 *
 *-----------------------------------------------------------------------------*/

#ifndef __INFO__
#define __INFO__

/* Needed for action function pointer handling. */
#include "d_think.h"
#include "doomtype.h"

#include "dsda/global.h"

#define MAXSTATEARGS 8

/********************************************************************
 * Sprite name enumeration - must match info.c                      *
 ********************************************************************/
typedef enum
{
  SPR_TROO,
  SPR_SHTG,
  SPR_PUNG,
  SPR_PISG,
  SPR_PISF,
  SPR_SHTF,
  SPR_SHT2,
  SPR_CHGG,
  SPR_CHGF,
  SPR_MISG,
  SPR_MISF,
  SPR_SAWG,
  SPR_PLSG,
  SPR_PLSF,
  SPR_BFGG,
  SPR_BFGF,
  SPR_BLUD,
  SPR_PUFF,
  SPR_BAL1,
  SPR_BAL2,
  SPR_PLSS,
  SPR_PLSE,
  SPR_MISL,
  SPR_BFS1,
  SPR_BFE1,
  SPR_BFE2,
  SPR_TFOG,
  SPR_IFOG,
  SPR_PLAY,
  SPR_POSS,
  SPR_SPOS,
  SPR_VILE,
  SPR_FIRE,
  SPR_FATB,
  SPR_FBXP,
  SPR_SKEL,
  SPR_MANF,
  SPR_FATT,
  SPR_CPOS,
  SPR_SARG,
  SPR_HEAD,
  SPR_BAL7,
  SPR_BOSS,
  SPR_BOS2,
  SPR_SKUL,
  SPR_SPID,
  SPR_BSPI,
  SPR_APLS,
  SPR_APBX,
  SPR_CYBR,
  SPR_PAIN,
  SPR_SSWV,
  SPR_KEEN,
  SPR_BBRN,
  SPR_BOSF,
  SPR_ARM1,
  SPR_ARM2,
  SPR_BAR1,
  SPR_BEXP,
  SPR_FCAN,
  SPR_BON1,
  SPR_BON2,
  SPR_BKEY,
  SPR_RKEY,
  SPR_YKEY,
  SPR_BSKU,
  SPR_RSKU,
  SPR_YSKU,
  SPR_STIM,
  SPR_MEDI,
  SPR_SOUL,
  SPR_PINV,
  SPR_PSTR,
  SPR_PINS,
  SPR_MEGA,
  SPR_SUIT,
  SPR_PMAP,
  SPR_PVIS,
  SPR_CLIP,
  SPR_AMMO,
  SPR_ROCK,
  SPR_BROK,
  SPR_CELL,
  SPR_CELP,
  SPR_SHEL,
  SPR_SBOX,
  SPR_BPAK,
  SPR_BFUG,
  SPR_MGUN,
  SPR_CSAW,
  SPR_LAUN,
  SPR_PLAS,
  SPR_SHOT,
  SPR_SGN2,
  SPR_COLU,
  SPR_SMT2,
  SPR_GOR1,
  SPR_POL2,
  SPR_POL5,
  SPR_POL4,
  SPR_POL3,
  SPR_POL1,
  SPR_POL6,
  SPR_GOR2,
  SPR_GOR3,
  SPR_GOR4,
  SPR_GOR5,
  SPR_SMIT,
  SPR_COL1,
  SPR_COL2,
  SPR_COL3,
  SPR_COL4,
  SPR_CAND,
  SPR_CBRA,
  SPR_COL6,
  SPR_TRE1,
  SPR_TRE2,
  SPR_ELEC,
  SPR_CEYE,
  SPR_FSKU,
  SPR_COL5,
  SPR_TBLU,
  SPR_TGRN,
  SPR_TRED,
  SPR_SMBT,
  SPR_SMGT,
  SPR_SMRT,
  SPR_HDB1,
  SPR_HDB2,
  SPR_HDB3,
  SPR_HDB4,
  SPR_HDB5,
  SPR_HDB6,
  SPR_POB1,
  SPR_POB2,
  SPR_BRS1,
  SPR_TLMP,
  SPR_TLP2,
  SPR_TNT1, /* add invisible sprite              phares 3/8/98 */
  SPR_DOGS, /* killough 7/19/98: Marine's best friend :) */
  SPR_PLS1, // killough 7/19/98: first  of two plasma fireballs in the beta
  SPR_PLS2, // killough 7/19/98: second of two plasma fireballs in the beta
  SPR_BON3, // killough 7/11/98: evil sceptre in beta version
  SPR_BON4, // killough 7/11/98: unholy bible in beta version
  SPR_BLD2, // blood splats from Doom Retro, unsused in PrBoom+
  DOOM_NUMSPRITES = SPR_BLD2 + 100,  /* counter of how many there are */

  // heretic
  HERETIC_SPR_IMPX = 0,
  HERETIC_SPR_ACLO,
  HERETIC_SPR_PTN1,
  HERETIC_SPR_SHLD,
  HERETIC_SPR_SHD2,
  HERETIC_SPR_BAGH,
  HERETIC_SPR_SPMP,
  HERETIC_SPR_INVS,
  HERETIC_SPR_PTN2,
  HERETIC_SPR_SOAR,
  HERETIC_SPR_INVU,
  HERETIC_SPR_PWBK,
  HERETIC_SPR_EGGC,
  HERETIC_SPR_EGGM,
  HERETIC_SPR_FX01,
  HERETIC_SPR_SPHL,
  HERETIC_SPR_TRCH,
  HERETIC_SPR_FBMB,
  HERETIC_SPR_XPL1,
  HERETIC_SPR_ATLP,
  HERETIC_SPR_PPOD,
  HERETIC_SPR_AMG1,
  HERETIC_SPR_SPSH,
  HERETIC_SPR_LVAS,
  HERETIC_SPR_SLDG,
  HERETIC_SPR_SKH1,
  HERETIC_SPR_SKH2,
  HERETIC_SPR_SKH3,
  HERETIC_SPR_SKH4,
  HERETIC_SPR_CHDL,
  HERETIC_SPR_SRTC,
  HERETIC_SPR_SMPL,
  HERETIC_SPR_STGS,
  HERETIC_SPR_STGL,
  HERETIC_SPR_STCS,
  HERETIC_SPR_STCL,
  HERETIC_SPR_KFR1,
  HERETIC_SPR_BARL,
  HERETIC_SPR_BRPL,
  HERETIC_SPR_MOS1,
  HERETIC_SPR_MOS2,
  HERETIC_SPR_WTRH,
  HERETIC_SPR_HCOR,
  HERETIC_SPR_KGZ1,
  HERETIC_SPR_KGZB,
  HERETIC_SPR_KGZG,
  HERETIC_SPR_KGZY,
  HERETIC_SPR_VLCO,
  HERETIC_SPR_VFBL,
  HERETIC_SPR_VTFB,
  HERETIC_SPR_SFFI,
  HERETIC_SPR_TGLT,
  HERETIC_SPR_TELE,
  HERETIC_SPR_STFF,
  HERETIC_SPR_PUF3,
  HERETIC_SPR_PUF4,
  HERETIC_SPR_BEAK,
  HERETIC_SPR_WGNT,
  HERETIC_SPR_GAUN,
  HERETIC_SPR_PUF1,
  HERETIC_SPR_WBLS,
  HERETIC_SPR_BLSR,
  HERETIC_SPR_FX18,
  HERETIC_SPR_FX17,
  HERETIC_SPR_WMCE,
  HERETIC_SPR_MACE,
  HERETIC_SPR_FX02,
  HERETIC_SPR_WSKL,
  HERETIC_SPR_HROD,
  HERETIC_SPR_FX00,
  HERETIC_SPR_FX20,
  HERETIC_SPR_FX21,
  HERETIC_SPR_FX22,
  HERETIC_SPR_FX23,
  HERETIC_SPR_GWND,
  HERETIC_SPR_PUF2,
  HERETIC_SPR_WPHX,
  HERETIC_SPR_PHNX,
  HERETIC_SPR_FX04,
  HERETIC_SPR_FX08,
  HERETIC_SPR_FX09,
  HERETIC_SPR_WBOW,
  HERETIC_SPR_CRBW,
  HERETIC_SPR_FX03,
  HERETIC_SPR_BLOD,
  HERETIC_SPR_PLAY,
  HERETIC_SPR_FDTH,
  HERETIC_SPR_BSKL,
  HERETIC_SPR_CHKN,
  HERETIC_SPR_MUMM,
  HERETIC_SPR_FX15,
  HERETIC_SPR_BEAS,
  HERETIC_SPR_FRB1,
  HERETIC_SPR_SNKE,
  HERETIC_SPR_SNFX,
  HERETIC_SPR_HEAD,
  HERETIC_SPR_FX05,
  HERETIC_SPR_FX06,
  HERETIC_SPR_FX07,
  HERETIC_SPR_CLNK,
  HERETIC_SPR_WZRD,
  HERETIC_SPR_FX11,
  HERETIC_SPR_FX10,
  HERETIC_SPR_KNIG,
  HERETIC_SPR_SPAX,
  HERETIC_SPR_RAXE,
  HERETIC_SPR_SRCR,
  HERETIC_SPR_FX14,
  HERETIC_SPR_SOR2,
  HERETIC_SPR_SDTH,
  HERETIC_SPR_FX16,
  HERETIC_SPR_MNTR,
  HERETIC_SPR_FX12,
  HERETIC_SPR_FX13,
  HERETIC_SPR_AKYY,
  HERETIC_SPR_BKYY,
  HERETIC_SPR_CKYY,
  HERETIC_SPR_AMG2,
  HERETIC_SPR_AMM1,
  HERETIC_SPR_AMM2,
  HERETIC_SPR_AMC1,
  HERETIC_SPR_AMC2,
  HERETIC_SPR_AMS1,
  HERETIC_SPR_AMS2,
  HERETIC_SPR_AMP1,
  HERETIC_SPR_AMP2,
  HERETIC_SPR_AMB1,
  HERETIC_SPR_AMB2,
  HERETIC_NUMSPRITES,

  // hexen
  HEXEN_SPR_MAN1 = 0,
  HEXEN_SPR_ACLO,
  HEXEN_SPR_TLGL,
  HEXEN_SPR_FBL1,
  HEXEN_SPR_XPL1,
  HEXEN_SPR_ARRW,
  HEXEN_SPR_DART,
  HEXEN_SPR_RIPP,
  HEXEN_SPR_CFCF,
  HEXEN_SPR_BLAD,
  HEXEN_SPR_SHRD,
  HEXEN_SPR_FFSM,
  HEXEN_SPR_FFLG,
  HEXEN_SPR_PTN1,
  HEXEN_SPR_PTN2,
  HEXEN_SPR_SOAR,
  HEXEN_SPR_INVU,
  HEXEN_SPR_SUMN,
  HEXEN_SPR_TSPK,
  HEXEN_SPR_TELO,
  HEXEN_SPR_TRNG,
  HEXEN_SPR_ROCK,
  HEXEN_SPR_FOGS,
  HEXEN_SPR_FOGM,
  HEXEN_SPR_FOGL,
  HEXEN_SPR_SGSA,
  HEXEN_SPR_SGSB,
  HEXEN_SPR_PORK,
  HEXEN_SPR_EGGM,
  HEXEN_SPR_FHFX,
  HEXEN_SPR_SPHL,
  HEXEN_SPR_STWN,
  HEXEN_SPR_GMPD,
  HEXEN_SPR_ASKU,
  HEXEN_SPR_ABGM,
  HEXEN_SPR_AGMR,
  HEXEN_SPR_AGMG,
  HEXEN_SPR_AGG2,
  HEXEN_SPR_AGMB,
  HEXEN_SPR_AGB2,
  HEXEN_SPR_ABK1,
  HEXEN_SPR_ABK2,
  HEXEN_SPR_ASK2,
  HEXEN_SPR_AFWP,
  HEXEN_SPR_ACWP,
  HEXEN_SPR_AMWP,
  HEXEN_SPR_AGER,
  HEXEN_SPR_AGR2,
  HEXEN_SPR_AGR3,
  HEXEN_SPR_AGR4,
  HEXEN_SPR_TRCH,
  HEXEN_SPR_PSBG,
  HEXEN_SPR_ATLP,
  HEXEN_SPR_THRW,
  HEXEN_SPR_SPED,
  HEXEN_SPR_BMAN,
  HEXEN_SPR_BRAC,
  HEXEN_SPR_BLST,
  HEXEN_SPR_HRAD,
  HEXEN_SPR_SPSH,
  HEXEN_SPR_LVAS,
  HEXEN_SPR_SLDG,
  HEXEN_SPR_STTW,
  HEXEN_SPR_RCK1,
  HEXEN_SPR_RCK2,
  HEXEN_SPR_RCK3,
  HEXEN_SPR_RCK4,
  HEXEN_SPR_CDLR,
  HEXEN_SPR_TRE1,
  HEXEN_SPR_TRDT,
  HEXEN_SPR_TRE2,
  HEXEN_SPR_TRE3,
  HEXEN_SPR_STM1,
  HEXEN_SPR_STM2,
  HEXEN_SPR_STM3,
  HEXEN_SPR_STM4,
  HEXEN_SPR_MSH1,
  HEXEN_SPR_MSH2,
  HEXEN_SPR_MSH3,
  HEXEN_SPR_MSH4,
  HEXEN_SPR_MSH5,
  HEXEN_SPR_MSH6,
  HEXEN_SPR_MSH7,
  HEXEN_SPR_MSH8,
  HEXEN_SPR_SGMP,
  HEXEN_SPR_SGM1,
  HEXEN_SPR_SGM2,
  HEXEN_SPR_SGM3,
  HEXEN_SPR_SLC1,
  HEXEN_SPR_SLC2,
  HEXEN_SPR_SLC3,
  HEXEN_SPR_MSS1,
  HEXEN_SPR_MSS2,
  HEXEN_SPR_SWMV,
  HEXEN_SPR_CPS1,
  HEXEN_SPR_CPS2,
  HEXEN_SPR_TMS1,
  HEXEN_SPR_TMS2,
  HEXEN_SPR_TMS3,
  HEXEN_SPR_TMS4,
  HEXEN_SPR_TMS5,
  HEXEN_SPR_TMS6,
  HEXEN_SPR_TMS7,
  HEXEN_SPR_CPS3,
  HEXEN_SPR_STT2,
  HEXEN_SPR_STT3,
  HEXEN_SPR_STT4,
  HEXEN_SPR_STT5,
  HEXEN_SPR_GAR1,
  HEXEN_SPR_GAR2,
  HEXEN_SPR_GAR3,
  HEXEN_SPR_GAR4,
  HEXEN_SPR_GAR5,
  HEXEN_SPR_GAR6,
  HEXEN_SPR_GAR7,
  HEXEN_SPR_GAR8,
  HEXEN_SPR_GAR9,
  HEXEN_SPR_BNR1,
  HEXEN_SPR_TRE4,
  HEXEN_SPR_TRE5,
  HEXEN_SPR_TRE6,
  HEXEN_SPR_TRE7,
  HEXEN_SPR_LOGG,
  HEXEN_SPR_ICT1,
  HEXEN_SPR_ICT2,
  HEXEN_SPR_ICT3,
  HEXEN_SPR_ICT4,
  HEXEN_SPR_ICM1,
  HEXEN_SPR_ICM2,
  HEXEN_SPR_ICM3,
  HEXEN_SPR_ICM4,
  HEXEN_SPR_RKBL,
  HEXEN_SPR_RKBS,
  HEXEN_SPR_RKBK,
  HEXEN_SPR_RBL1,
  HEXEN_SPR_RBL2,
  HEXEN_SPR_RBL3,
  HEXEN_SPR_VASE,
  HEXEN_SPR_POT1,
  HEXEN_SPR_POT2,
  HEXEN_SPR_POT3,
  HEXEN_SPR_PBIT,
  HEXEN_SPR_CPS4,
  HEXEN_SPR_CPS5,
  HEXEN_SPR_CPS6,
  HEXEN_SPR_CPB1,
  HEXEN_SPR_CPB2,
  HEXEN_SPR_CPB3,
  HEXEN_SPR_CPB4,
  HEXEN_SPR_BDRP,
  HEXEN_SPR_BDSH,
  HEXEN_SPR_BDPL,
  HEXEN_SPR_CNDL,
  HEXEN_SPR_LEF1,
  HEXEN_SPR_LEF3,
  HEXEN_SPR_LEF2,
  HEXEN_SPR_TWTR,
  HEXEN_SPR_WLTR,
  HEXEN_SPR_BARL,
  HEXEN_SPR_SHB1,
  HEXEN_SPR_SHB2,
  HEXEN_SPR_BCKT,
  HEXEN_SPR_SHRM,
  HEXEN_SPR_FBUL,
  HEXEN_SPR_FSKL,
  HEXEN_SPR_BRTR,
  HEXEN_SPR_SUIT,
  HEXEN_SPR_BBLL,
  HEXEN_SPR_CAND,
  HEXEN_SPR_IRON,
  HEXEN_SPR_XMAS,
  HEXEN_SPR_CDRN,
  HEXEN_SPR_CHNS,
  HEXEN_SPR_TST1,
  HEXEN_SPR_TST2,
  HEXEN_SPR_TST3,
  HEXEN_SPR_TST4,
  HEXEN_SPR_TST5,
  HEXEN_SPR_TST6,
  HEXEN_SPR_TST7,
  HEXEN_SPR_TST8,
  HEXEN_SPR_TST9,
  HEXEN_SPR_TST0,
  HEXEN_SPR_TELE,
  HEXEN_SPR_TSMK,
  HEXEN_SPR_FPCH,
  HEXEN_SPR_WFAX,
  HEXEN_SPR_FAXE,
  HEXEN_SPR_WFHM,
  HEXEN_SPR_FHMR,
  HEXEN_SPR_FSRD,
  HEXEN_SPR_FSFX,
  HEXEN_SPR_CMCE,
  HEXEN_SPR_WCSS,
  HEXEN_SPR_CSSF,
  HEXEN_SPR_WCFM,
  HEXEN_SPR_CFLM,
  HEXEN_SPR_CFFX,
  HEXEN_SPR_CHLY,
  HEXEN_SPR_SPIR,
  HEXEN_SPR_MWND,
  HEXEN_SPR_WMLG,
  HEXEN_SPR_MLNG,
  HEXEN_SPR_MLFX,
  HEXEN_SPR_MLF2,
  HEXEN_SPR_MSTF,
  HEXEN_SPR_MSP1,
  HEXEN_SPR_MSP2,
  HEXEN_SPR_WFR1,
  HEXEN_SPR_WFR2,
  HEXEN_SPR_WFR3,
  HEXEN_SPR_WCH1,
  HEXEN_SPR_WCH2,
  HEXEN_SPR_WCH3,
  HEXEN_SPR_WMS1,
  HEXEN_SPR_WMS2,
  HEXEN_SPR_WMS3,
  HEXEN_SPR_WPIG,
  HEXEN_SPR_WMCS,
  HEXEN_SPR_CONE,
  HEXEN_SPR_SHEX,
  HEXEN_SPR_BLOD,
  HEXEN_SPR_GIBS,
  HEXEN_SPR_PLAY,
  HEXEN_SPR_FDTH,
  HEXEN_SPR_BSKL,
  HEXEN_SPR_ICEC,
  HEXEN_SPR_CLER,
  HEXEN_SPR_MAGE,
  HEXEN_SPR_PIGY,
  HEXEN_SPR_CENT,
  HEXEN_SPR_CTXD,
  HEXEN_SPR_CTFX,
  HEXEN_SPR_CTDP,
  HEXEN_SPR_DEMN,
  HEXEN_SPR_DEMA,
  HEXEN_SPR_DEMB,
  HEXEN_SPR_DEMC,
  HEXEN_SPR_DEMD,
  HEXEN_SPR_DEME,
  HEXEN_SPR_DMFX,
  HEXEN_SPR_DEM2,
  HEXEN_SPR_DMBA,
  HEXEN_SPR_DMBB,
  HEXEN_SPR_DMBC,
  HEXEN_SPR_DMBD,
  HEXEN_SPR_DMBE,
  HEXEN_SPR_D2FX,
  HEXEN_SPR_WRTH,
  HEXEN_SPR_WRT2,
  HEXEN_SPR_WRBL,
  HEXEN_SPR_MNTR,
  HEXEN_SPR_FX12,
  HEXEN_SPR_FX13,
  HEXEN_SPR_MNSM,
  HEXEN_SPR_SSPT,
  HEXEN_SPR_SSDV,
  HEXEN_SPR_SSXD,
  HEXEN_SPR_SSFX,
  HEXEN_SPR_BISH,
  HEXEN_SPR_BPFX,
  HEXEN_SPR_DRAG,
  HEXEN_SPR_DRFX,
  HEXEN_SPR_ARM1,
  HEXEN_SPR_ARM2,
  HEXEN_SPR_ARM3,
  HEXEN_SPR_ARM4,
  HEXEN_SPR_MAN2,
  HEXEN_SPR_MAN3,
  HEXEN_SPR_KEY1,
  HEXEN_SPR_KEY2,
  HEXEN_SPR_KEY3,
  HEXEN_SPR_KEY4,
  HEXEN_SPR_KEY5,
  HEXEN_SPR_KEY6,
  HEXEN_SPR_KEY7,
  HEXEN_SPR_KEY8,
  HEXEN_SPR_KEY9,
  HEXEN_SPR_KEYA,
  HEXEN_SPR_KEYB,
  HEXEN_SPR_ETTN,
  HEXEN_SPR_ETTB,
  HEXEN_SPR_FDMN,
  HEXEN_SPR_FDMB,
  HEXEN_SPR_ICEY,
  HEXEN_SPR_ICPR,
  HEXEN_SPR_ICWS,
  HEXEN_SPR_SORC,
  HEXEN_SPR_SBMP,
  HEXEN_SPR_SBS4,
  HEXEN_SPR_SBMB,
  HEXEN_SPR_SBS3,
  HEXEN_SPR_SBMG,
  HEXEN_SPR_SBS1,
  HEXEN_SPR_SBS2,
  HEXEN_SPR_SBFX,
  HEXEN_SPR_RADE,
  HEXEN_SPR_WATR,
  HEXEN_SPR_KORX,
  HEXEN_SPR_ABAT,
  HEXEN_NUMSPRITES
} spritenum_t;

/********************************************************************
 * States (frames) enumeration -- must match info.c                 *
 ********************************************************************/

typedef enum
{
  S_NULL,
  S_LIGHTDONE,
  S_PUNCH,
  S_PUNCHDOWN,
  S_PUNCHUP,
  S_PUNCH1,
  S_PUNCH2,
  S_PUNCH3,
  S_PUNCH4,
  S_PUNCH5,
  S_PISTOL,
  S_PISTOLDOWN,
  S_PISTOLUP,
  S_PISTOL1,
  S_PISTOL2,
  S_PISTOL3,
  S_PISTOL4,
  S_PISTOLFLASH,
  S_SGUN,
  S_SGUNDOWN,
  S_SGUNUP,
  S_SGUN1,
  S_SGUN2,
  S_SGUN3,
  S_SGUN4,
  S_SGUN5,
  S_SGUN6,
  S_SGUN7,
  S_SGUN8,
  S_SGUN9,
  S_SGUNFLASH1,
  S_SGUNFLASH2,
  S_DSGUN,
  S_DSGUNDOWN,
  S_DSGUNUP,
  S_DSGUN1,
  S_DSGUN2,
  S_DSGUN3,
  S_DSGUN4,
  S_DSGUN5,
  S_DSGUN6,
  S_DSGUN7,
  S_DSGUN8,
  S_DSGUN9,
  S_DSGUN10,
  S_DSNR1,
  S_DSNR2,
  S_DSGUNFLASH1,
  S_DSGUNFLASH2,
  S_CHAIN,
  S_CHAINDOWN,
  S_CHAINUP,
  S_CHAIN1,
  S_CHAIN2,
  S_CHAIN3,
  S_CHAINFLASH1,
  S_CHAINFLASH2,
  S_MISSILE,
  S_MISSILEDOWN,
  S_MISSILEUP,
  S_MISSILE1,
  S_MISSILE2,
  S_MISSILE3,
  S_MISSILEFLASH1,
  S_MISSILEFLASH2,
  S_MISSILEFLASH3,
  S_MISSILEFLASH4,
  S_SAW,
  S_SAWB,
  S_SAWDOWN,
  S_SAWUP,
  S_SAW1,
  S_SAW2,
  S_SAW3,
  S_PLASMA,
  S_PLASMADOWN,
  S_PLASMAUP,
  S_PLASMA1,
  S_PLASMA2,
  S_PLASMAFLASH1,
  S_PLASMAFLASH2,
  S_BFG,
  S_BFGDOWN,
  S_BFGUP,
  S_BFG1,
  S_BFG2,
  S_BFG3,
  S_BFG4,
  S_BFGFLASH1,
  S_BFGFLASH2,
  S_BLOOD1,
  S_BLOOD2,
  S_BLOOD3,
  S_PUFF1,
  S_PUFF2,
  S_PUFF3,
  S_PUFF4,
  S_TBALL1,
  S_TBALL2,
  S_TBALLX1,
  S_TBALLX2,
  S_TBALLX3,
  S_RBALL1,
  S_RBALL2,
  S_RBALLX1,
  S_RBALLX2,
  S_RBALLX3,
  S_PLASBALL,
  S_PLASBALL2,
  S_PLASEXP,
  S_PLASEXP2,
  S_PLASEXP3,
  S_PLASEXP4,
  S_PLASEXP5,
  S_ROCKET,
  S_BFGSHOT,
  S_BFGSHOT2,
  S_BFGLAND,
  S_BFGLAND2,
  S_BFGLAND3,
  S_BFGLAND4,
  S_BFGLAND5,
  S_BFGLAND6,
  S_BFGEXP,
  S_BFGEXP2,
  S_BFGEXP3,
  S_BFGEXP4,
  S_EXPLODE1,
  S_EXPLODE2,
  S_EXPLODE3,
  S_TFOG,
  S_TFOG01,
  S_TFOG02,
  S_TFOG2,
  S_TFOG3,
  S_TFOG4,
  S_TFOG5,
  S_TFOG6,
  S_TFOG7,
  S_TFOG8,
  S_TFOG9,
  S_TFOG10,
  S_IFOG,
  S_IFOG01,
  S_IFOG02,
  S_IFOG2,
  S_IFOG3,
  S_IFOG4,
  S_IFOG5,
  S_PLAY,
  S_PLAY_RUN1,
  S_PLAY_RUN2,
  S_PLAY_RUN3,
  S_PLAY_RUN4,
  S_PLAY_ATK1,
  S_PLAY_ATK2,
  S_PLAY_PAIN,
  S_PLAY_PAIN2,
  S_PLAY_DIE1,
  S_PLAY_DIE2,
  S_PLAY_DIE3,
  S_PLAY_DIE4,
  S_PLAY_DIE5,
  S_PLAY_DIE6,
  S_PLAY_DIE7,
  S_PLAY_XDIE1,
  S_PLAY_XDIE2,
  S_PLAY_XDIE3,
  S_PLAY_XDIE4,
  S_PLAY_XDIE5,
  S_PLAY_XDIE6,
  S_PLAY_XDIE7,
  S_PLAY_XDIE8,
  S_PLAY_XDIE9,
  S_POSS_STND,
  S_POSS_STND2,
  S_POSS_RUN1,
  S_POSS_RUN2,
  S_POSS_RUN3,
  S_POSS_RUN4,
  S_POSS_RUN5,
  S_POSS_RUN6,
  S_POSS_RUN7,
  S_POSS_RUN8,
  S_POSS_ATK1,
  S_POSS_ATK2,
  S_POSS_ATK3,
  S_POSS_PAIN,
  S_POSS_PAIN2,
  S_POSS_DIE1,
  S_POSS_DIE2,
  S_POSS_DIE3,
  S_POSS_DIE4,
  S_POSS_DIE5,
  S_POSS_XDIE1,
  S_POSS_XDIE2,
  S_POSS_XDIE3,
  S_POSS_XDIE4,
  S_POSS_XDIE5,
  S_POSS_XDIE6,
  S_POSS_XDIE7,
  S_POSS_XDIE8,
  S_POSS_XDIE9,
  S_POSS_RAISE1,
  S_POSS_RAISE2,
  S_POSS_RAISE3,
  S_POSS_RAISE4,
  S_SPOS_STND,
  S_SPOS_STND2,
  S_SPOS_RUN1,
  S_SPOS_RUN2,
  S_SPOS_RUN3,
  S_SPOS_RUN4,
  S_SPOS_RUN5,
  S_SPOS_RUN6,
  S_SPOS_RUN7,
  S_SPOS_RUN8,
  S_SPOS_ATK1,
  S_SPOS_ATK2,
  S_SPOS_ATK3,
  S_SPOS_PAIN,
  S_SPOS_PAIN2,
  S_SPOS_DIE1,
  S_SPOS_DIE2,
  S_SPOS_DIE3,
  S_SPOS_DIE4,
  S_SPOS_DIE5,
  S_SPOS_XDIE1,
  S_SPOS_XDIE2,
  S_SPOS_XDIE3,
  S_SPOS_XDIE4,
  S_SPOS_XDIE5,
  S_SPOS_XDIE6,
  S_SPOS_XDIE7,
  S_SPOS_XDIE8,
  S_SPOS_XDIE9,
  S_SPOS_RAISE1,
  S_SPOS_RAISE2,
  S_SPOS_RAISE3,
  S_SPOS_RAISE4,
  S_SPOS_RAISE5,
  S_VILE_STND,
  S_VILE_STND2,
  S_VILE_RUN1,
  S_VILE_RUN2,
  S_VILE_RUN3,
  S_VILE_RUN4,
  S_VILE_RUN5,
  S_VILE_RUN6,
  S_VILE_RUN7,
  S_VILE_RUN8,
  S_VILE_RUN9,
  S_VILE_RUN10,
  S_VILE_RUN11,
  S_VILE_RUN12,
  S_VILE_ATK1,
  S_VILE_ATK2,
  S_VILE_ATK3,
  S_VILE_ATK4,
  S_VILE_ATK5,
  S_VILE_ATK6,
  S_VILE_ATK7,
  S_VILE_ATK8,
  S_VILE_ATK9,
  S_VILE_ATK10,
  S_VILE_ATK11,
  S_VILE_HEAL1,
  S_VILE_HEAL2,
  S_VILE_HEAL3,
  S_VILE_PAIN,
  S_VILE_PAIN2,
  S_VILE_DIE1,
  S_VILE_DIE2,
  S_VILE_DIE3,
  S_VILE_DIE4,
  S_VILE_DIE5,
  S_VILE_DIE6,
  S_VILE_DIE7,
  S_VILE_DIE8,
  S_VILE_DIE9,
  S_VILE_DIE10,
  S_FIRE1,
  S_FIRE2,
  S_FIRE3,
  S_FIRE4,
  S_FIRE5,
  S_FIRE6,
  S_FIRE7,
  S_FIRE8,
  S_FIRE9,
  S_FIRE10,
  S_FIRE11,
  S_FIRE12,
  S_FIRE13,
  S_FIRE14,
  S_FIRE15,
  S_FIRE16,
  S_FIRE17,
  S_FIRE18,
  S_FIRE19,
  S_FIRE20,
  S_FIRE21,
  S_FIRE22,
  S_FIRE23,
  S_FIRE24,
  S_FIRE25,
  S_FIRE26,
  S_FIRE27,
  S_FIRE28,
  S_FIRE29,
  S_FIRE30,
  S_SMOKE1,
  S_SMOKE2,
  S_SMOKE3,
  S_SMOKE4,
  S_SMOKE5,
  S_TRACER,
  S_TRACER2,
  S_TRACEEXP1,
  S_TRACEEXP2,
  S_TRACEEXP3,
  S_SKEL_STND,
  S_SKEL_STND2,
  S_SKEL_RUN1,
  S_SKEL_RUN2,
  S_SKEL_RUN3,
  S_SKEL_RUN4,
  S_SKEL_RUN5,
  S_SKEL_RUN6,
  S_SKEL_RUN7,
  S_SKEL_RUN8,
  S_SKEL_RUN9,
  S_SKEL_RUN10,
  S_SKEL_RUN11,
  S_SKEL_RUN12,
  S_SKEL_FIST1,
  S_SKEL_FIST2,
  S_SKEL_FIST3,
  S_SKEL_FIST4,
  S_SKEL_MISS1,
  S_SKEL_MISS2,
  S_SKEL_MISS3,
  S_SKEL_MISS4,
  S_SKEL_PAIN,
  S_SKEL_PAIN2,
  S_SKEL_DIE1,
  S_SKEL_DIE2,
  S_SKEL_DIE3,
  S_SKEL_DIE4,
  S_SKEL_DIE5,
  S_SKEL_DIE6,
  S_SKEL_RAISE1,
  S_SKEL_RAISE2,
  S_SKEL_RAISE3,
  S_SKEL_RAISE4,
  S_SKEL_RAISE5,
  S_SKEL_RAISE6,
  S_FATSHOT1,
  S_FATSHOT2,
  S_FATSHOTX1,
  S_FATSHOTX2,
  S_FATSHOTX3,
  S_FATT_STND,
  S_FATT_STND2,
  S_FATT_RUN1,
  S_FATT_RUN2,
  S_FATT_RUN3,
  S_FATT_RUN4,
  S_FATT_RUN5,
  S_FATT_RUN6,
  S_FATT_RUN7,
  S_FATT_RUN8,
  S_FATT_RUN9,
  S_FATT_RUN10,
  S_FATT_RUN11,
  S_FATT_RUN12,
  S_FATT_ATK1,
  S_FATT_ATK2,
  S_FATT_ATK3,
  S_FATT_ATK4,
  S_FATT_ATK5,
  S_FATT_ATK6,
  S_FATT_ATK7,
  S_FATT_ATK8,
  S_FATT_ATK9,
  S_FATT_ATK10,
  S_FATT_PAIN,
  S_FATT_PAIN2,
  S_FATT_DIE1,
  S_FATT_DIE2,
  S_FATT_DIE3,
  S_FATT_DIE4,
  S_FATT_DIE5,
  S_FATT_DIE6,
  S_FATT_DIE7,
  S_FATT_DIE8,
  S_FATT_DIE9,
  S_FATT_DIE10,
  S_FATT_RAISE1,
  S_FATT_RAISE2,
  S_FATT_RAISE3,
  S_FATT_RAISE4,
  S_FATT_RAISE5,
  S_FATT_RAISE6,
  S_FATT_RAISE7,
  S_FATT_RAISE8,
  S_CPOS_STND,
  S_CPOS_STND2,
  S_CPOS_RUN1,
  S_CPOS_RUN2,
  S_CPOS_RUN3,
  S_CPOS_RUN4,
  S_CPOS_RUN5,
  S_CPOS_RUN6,
  S_CPOS_RUN7,
  S_CPOS_RUN8,
  S_CPOS_ATK1,
  S_CPOS_ATK2,
  S_CPOS_ATK3,
  S_CPOS_ATK4,
  S_CPOS_PAIN,
  S_CPOS_PAIN2,
  S_CPOS_DIE1,
  S_CPOS_DIE2,
  S_CPOS_DIE3,
  S_CPOS_DIE4,
  S_CPOS_DIE5,
  S_CPOS_DIE6,
  S_CPOS_DIE7,
  S_CPOS_XDIE1,
  S_CPOS_XDIE2,
  S_CPOS_XDIE3,
  S_CPOS_XDIE4,
  S_CPOS_XDIE5,
  S_CPOS_XDIE6,
  S_CPOS_RAISE1,
  S_CPOS_RAISE2,
  S_CPOS_RAISE3,
  S_CPOS_RAISE4,
  S_CPOS_RAISE5,
  S_CPOS_RAISE6,
  S_CPOS_RAISE7,
  S_TROO_STND,
  S_TROO_STND2,
  S_TROO_RUN1,
  S_TROO_RUN2,
  S_TROO_RUN3,
  S_TROO_RUN4,
  S_TROO_RUN5,
  S_TROO_RUN6,
  S_TROO_RUN7,
  S_TROO_RUN8,
  S_TROO_ATK1,
  S_TROO_ATK2,
  S_TROO_ATK3,
  S_TROO_PAIN,
  S_TROO_PAIN2,
  S_TROO_DIE1,
  S_TROO_DIE2,
  S_TROO_DIE3,
  S_TROO_DIE4,
  S_TROO_DIE5,
  S_TROO_XDIE1,
  S_TROO_XDIE2,
  S_TROO_XDIE3,
  S_TROO_XDIE4,
  S_TROO_XDIE5,
  S_TROO_XDIE6,
  S_TROO_XDIE7,
  S_TROO_XDIE8,
  S_TROO_RAISE1,
  S_TROO_RAISE2,
  S_TROO_RAISE3,
  S_TROO_RAISE4,
  S_TROO_RAISE5,
  S_SARG_STND,
  S_SARG_STND2,
  S_SARG_RUN1,
  S_SARG_RUN2,
  S_SARG_RUN3,
  S_SARG_RUN4,
  S_SARG_RUN5,
  S_SARG_RUN6,
  S_SARG_RUN7,
  S_SARG_RUN8,
  S_SARG_ATK1,
  S_SARG_ATK2,
  S_SARG_ATK3,
  S_SARG_PAIN,
  S_SARG_PAIN2,
  S_SARG_DIE1,
  S_SARG_DIE2,
  S_SARG_DIE3,
  S_SARG_DIE4,
  S_SARG_DIE5,
  S_SARG_DIE6,
  S_SARG_RAISE1,
  S_SARG_RAISE2,
  S_SARG_RAISE3,
  S_SARG_RAISE4,
  S_SARG_RAISE5,
  S_SARG_RAISE6,
  S_HEAD_STND,
  S_HEAD_RUN1,
  S_HEAD_ATK1,
  S_HEAD_ATK2,
  S_HEAD_ATK3,
  S_HEAD_PAIN,
  S_HEAD_PAIN2,
  S_HEAD_PAIN3,
  S_HEAD_DIE1,
  S_HEAD_DIE2,
  S_HEAD_DIE3,
  S_HEAD_DIE4,
  S_HEAD_DIE5,
  S_HEAD_DIE6,
  S_HEAD_RAISE1,
  S_HEAD_RAISE2,
  S_HEAD_RAISE3,
  S_HEAD_RAISE4,
  S_HEAD_RAISE5,
  S_HEAD_RAISE6,
  S_BRBALL1,
  S_BRBALL2,
  S_BRBALLX1,
  S_BRBALLX2,
  S_BRBALLX3,
  S_BOSS_STND,
  S_BOSS_STND2,
  S_BOSS_RUN1,
  S_BOSS_RUN2,
  S_BOSS_RUN3,
  S_BOSS_RUN4,
  S_BOSS_RUN5,
  S_BOSS_RUN6,
  S_BOSS_RUN7,
  S_BOSS_RUN8,
  S_BOSS_ATK1,
  S_BOSS_ATK2,
  S_BOSS_ATK3,
  S_BOSS_PAIN,
  S_BOSS_PAIN2,
  S_BOSS_DIE1,
  S_BOSS_DIE2,
  S_BOSS_DIE3,
  S_BOSS_DIE4,
  S_BOSS_DIE5,
  S_BOSS_DIE6,
  S_BOSS_DIE7,
  S_BOSS_RAISE1,
  S_BOSS_RAISE2,
  S_BOSS_RAISE3,
  S_BOSS_RAISE4,
  S_BOSS_RAISE5,
  S_BOSS_RAISE6,
  S_BOSS_RAISE7,
  S_BOS2_STND,
  S_BOS2_STND2,
  S_BOS2_RUN1,
  S_BOS2_RUN2,
  S_BOS2_RUN3,
  S_BOS2_RUN4,
  S_BOS2_RUN5,
  S_BOS2_RUN6,
  S_BOS2_RUN7,
  S_BOS2_RUN8,
  S_BOS2_ATK1,
  S_BOS2_ATK2,
  S_BOS2_ATK3,
  S_BOS2_PAIN,
  S_BOS2_PAIN2,
  S_BOS2_DIE1,
  S_BOS2_DIE2,
  S_BOS2_DIE3,
  S_BOS2_DIE4,
  S_BOS2_DIE5,
  S_BOS2_DIE6,
  S_BOS2_DIE7,
  S_BOS2_RAISE1,
  S_BOS2_RAISE2,
  S_BOS2_RAISE3,
  S_BOS2_RAISE4,
  S_BOS2_RAISE5,
  S_BOS2_RAISE6,
  S_BOS2_RAISE7,
  S_SKULL_STND,
  S_SKULL_STND2,
  S_SKULL_RUN1,
  S_SKULL_RUN2,
  S_SKULL_ATK1,
  S_SKULL_ATK2,
  S_SKULL_ATK3,
  S_SKULL_ATK4,
  S_SKULL_PAIN,
  S_SKULL_PAIN2,
  S_SKULL_DIE1,
  S_SKULL_DIE2,
  S_SKULL_DIE3,
  S_SKULL_DIE4,
  S_SKULL_DIE5,
  S_SKULL_DIE6,
  S_SPID_STND,
  S_SPID_STND2,
  S_SPID_RUN1,
  S_SPID_RUN2,
  S_SPID_RUN3,
  S_SPID_RUN4,
  S_SPID_RUN5,
  S_SPID_RUN6,
  S_SPID_RUN7,
  S_SPID_RUN8,
  S_SPID_RUN9,
  S_SPID_RUN10,
  S_SPID_RUN11,
  S_SPID_RUN12,
  S_SPID_ATK1,
  S_SPID_ATK2,
  S_SPID_ATK3,
  S_SPID_ATK4,
  S_SPID_PAIN,
  S_SPID_PAIN2,
  S_SPID_DIE1,
  S_SPID_DIE2,
  S_SPID_DIE3,
  S_SPID_DIE4,
  S_SPID_DIE5,
  S_SPID_DIE6,
  S_SPID_DIE7,
  S_SPID_DIE8,
  S_SPID_DIE9,
  S_SPID_DIE10,
  S_SPID_DIE11,
  S_BSPI_STND,
  S_BSPI_STND2,
  S_BSPI_SIGHT,
  S_BSPI_RUN1,
  S_BSPI_RUN2,
  S_BSPI_RUN3,
  S_BSPI_RUN4,
  S_BSPI_RUN5,
  S_BSPI_RUN6,
  S_BSPI_RUN7,
  S_BSPI_RUN8,
  S_BSPI_RUN9,
  S_BSPI_RUN10,
  S_BSPI_RUN11,
  S_BSPI_RUN12,
  S_BSPI_ATK1,
  S_BSPI_ATK2,
  S_BSPI_ATK3,
  S_BSPI_ATK4,
  S_BSPI_PAIN,
  S_BSPI_PAIN2,
  S_BSPI_DIE1,
  S_BSPI_DIE2,
  S_BSPI_DIE3,
  S_BSPI_DIE4,
  S_BSPI_DIE5,
  S_BSPI_DIE6,
  S_BSPI_DIE7,
  S_BSPI_RAISE1,
  S_BSPI_RAISE2,
  S_BSPI_RAISE3,
  S_BSPI_RAISE4,
  S_BSPI_RAISE5,
  S_BSPI_RAISE6,
  S_BSPI_RAISE7,
  S_ARACH_PLAZ,
  S_ARACH_PLAZ2,
  S_ARACH_PLEX,
  S_ARACH_PLEX2,
  S_ARACH_PLEX3,
  S_ARACH_PLEX4,
  S_ARACH_PLEX5,
  S_CYBER_STND,
  S_CYBER_STND2,
  S_CYBER_RUN1,
  S_CYBER_RUN2,
  S_CYBER_RUN3,
  S_CYBER_RUN4,
  S_CYBER_RUN5,
  S_CYBER_RUN6,
  S_CYBER_RUN7,
  S_CYBER_RUN8,
  S_CYBER_ATK1,
  S_CYBER_ATK2,
  S_CYBER_ATK3,
  S_CYBER_ATK4,
  S_CYBER_ATK5,
  S_CYBER_ATK6,
  S_CYBER_PAIN,
  S_CYBER_DIE1,
  S_CYBER_DIE2,
  S_CYBER_DIE3,
  S_CYBER_DIE4,
  S_CYBER_DIE5,
  S_CYBER_DIE6,
  S_CYBER_DIE7,
  S_CYBER_DIE8,
  S_CYBER_DIE9,
  S_CYBER_DIE10,
  S_PAIN_STND,
  S_PAIN_RUN1,
  S_PAIN_RUN2,
  S_PAIN_RUN3,
  S_PAIN_RUN4,
  S_PAIN_RUN5,
  S_PAIN_RUN6,
  S_PAIN_ATK1,
  S_PAIN_ATK2,
  S_PAIN_ATK3,
  S_PAIN_ATK4,
  S_PAIN_PAIN,
  S_PAIN_PAIN2,
  S_PAIN_DIE1,
  S_PAIN_DIE2,
  S_PAIN_DIE3,
  S_PAIN_DIE4,
  S_PAIN_DIE5,
  S_PAIN_DIE6,
  S_PAIN_RAISE1,
  S_PAIN_RAISE2,
  S_PAIN_RAISE3,
  S_PAIN_RAISE4,
  S_PAIN_RAISE5,
  S_PAIN_RAISE6,
  S_SSWV_STND,
  S_SSWV_STND2,
  S_SSWV_RUN1,
  S_SSWV_RUN2,
  S_SSWV_RUN3,
  S_SSWV_RUN4,
  S_SSWV_RUN5,
  S_SSWV_RUN6,
  S_SSWV_RUN7,
  S_SSWV_RUN8,
  S_SSWV_ATK1,
  S_SSWV_ATK2,
  S_SSWV_ATK3,
  S_SSWV_ATK4,
  S_SSWV_ATK5,
  S_SSWV_ATK6,
  S_SSWV_PAIN,
  S_SSWV_PAIN2,
  S_SSWV_DIE1,
  S_SSWV_DIE2,
  S_SSWV_DIE3,
  S_SSWV_DIE4,
  S_SSWV_DIE5,
  S_SSWV_XDIE1,
  S_SSWV_XDIE2,
  S_SSWV_XDIE3,
  S_SSWV_XDIE4,
  S_SSWV_XDIE5,
  S_SSWV_XDIE6,
  S_SSWV_XDIE7,
  S_SSWV_XDIE8,
  S_SSWV_XDIE9,
  S_SSWV_RAISE1,
  S_SSWV_RAISE2,
  S_SSWV_RAISE3,
  S_SSWV_RAISE4,
  S_SSWV_RAISE5,
  S_KEENSTND,
  S_COMMKEEN,
  S_COMMKEEN2,
  S_COMMKEEN3,
  S_COMMKEEN4,
  S_COMMKEEN5,
  S_COMMKEEN6,
  S_COMMKEEN7,
  S_COMMKEEN8,
  S_COMMKEEN9,
  S_COMMKEEN10,
  S_COMMKEEN11,
  S_COMMKEEN12,
  S_KEENPAIN,
  S_KEENPAIN2,
  S_BRAIN,
  S_BRAIN_PAIN,
  S_BRAIN_DIE1,
  S_BRAIN_DIE2,
  S_BRAIN_DIE3,
  S_BRAIN_DIE4,
  S_BRAINEYE,
  S_BRAINEYESEE,
  S_BRAINEYE1,
  S_SPAWN1,
  S_SPAWN2,
  S_SPAWN3,
  S_SPAWN4,
  S_SPAWNFIRE1,
  S_SPAWNFIRE2,
  S_SPAWNFIRE3,
  S_SPAWNFIRE4,
  S_SPAWNFIRE5,
  S_SPAWNFIRE6,
  S_SPAWNFIRE7,
  S_SPAWNFIRE8,
  S_BRAINEXPLODE1,
  S_BRAINEXPLODE2,
  S_BRAINEXPLODE3,
  S_ARM1,
  S_ARM1A,
  S_ARM2,
  S_ARM2A,
  S_BAR1,
  S_BAR2,
  S_BEXP,
  S_BEXP2,
  S_BEXP3,
  S_BEXP4,
  S_BEXP5,
  S_BBAR1,
  S_BBAR2,
  S_BBAR3,
  S_BON1,
  S_BON1A,
  S_BON1B,
  S_BON1C,
  S_BON1D,
  S_BON1E,
  S_BON2,
  S_BON2A,
  S_BON2B,
  S_BON2C,
  S_BON2D,
  S_BON2E,
  S_BKEY,
  S_BKEY2,
  S_RKEY,
  S_RKEY2,
  S_YKEY,
  S_YKEY2,
  S_BSKULL,
  S_BSKULL2,
  S_RSKULL,
  S_RSKULL2,
  S_YSKULL,
  S_YSKULL2,
  S_STIM,
  S_MEDI,
  S_SOUL,
  S_SOUL2,
  S_SOUL3,
  S_SOUL4,
  S_SOUL5,
  S_SOUL6,
  S_PINV,
  S_PINV2,
  S_PINV3,
  S_PINV4,
  S_PSTR,
  S_PINS,
  S_PINS2,
  S_PINS3,
  S_PINS4,
  S_MEGA,
  S_MEGA2,
  S_MEGA3,
  S_MEGA4,
  S_SUIT,
  S_PMAP,
  S_PMAP2,
  S_PMAP3,
  S_PMAP4,
  S_PMAP5,
  S_PMAP6,
  S_PVIS,
  S_PVIS2,
  S_CLIP,
  S_AMMO,
  S_ROCK,
  S_BROK,
  S_CELL,
  S_CELP,
  S_SHEL,
  S_SBOX,
  S_BPAK,
  S_BFUG,
  S_MGUN,
  S_CSAW,
  S_LAUN,
  S_PLAS,
  S_SHOT,
  S_SHOT2,
  S_COLU,
  S_STALAG,
  S_BLOODYTWITCH,
  S_BLOODYTWITCH2,
  S_BLOODYTWITCH3,
  S_BLOODYTWITCH4,
  S_DEADTORSO,
  S_DEADBOTTOM,
  S_HEADSONSTICK,
  S_GIBS,
  S_HEADONASTICK,
  S_HEADCANDLES,
  S_HEADCANDLES2,
  S_DEADSTICK,
  S_LIVESTICK,
  S_LIVESTICK2,
  S_MEAT2,
  S_MEAT3,
  S_MEAT4,
  S_MEAT5,
  S_STALAGTITE,
  S_TALLGRNCOL,
  S_SHRTGRNCOL,
  S_TALLREDCOL,
  S_SHRTREDCOL,
  S_CANDLESTIK,
  S_CANDELABRA,
  S_SKULLCOL,
  S_TORCHTREE,
  S_BIGTREE,
  S_TECHPILLAR,
  S_EVILEYE,
  S_EVILEYE2,
  S_EVILEYE3,
  S_EVILEYE4,
  S_FLOATSKULL,
  S_FLOATSKULL2,
  S_FLOATSKULL3,
  S_HEARTCOL,
  S_HEARTCOL2,
  S_BLUETORCH,
  S_BLUETORCH2,
  S_BLUETORCH3,
  S_BLUETORCH4,
  S_GREENTORCH,
  S_GREENTORCH2,
  S_GREENTORCH3,
  S_GREENTORCH4,
  S_REDTORCH,
  S_REDTORCH2,
  S_REDTORCH3,
  S_REDTORCH4,
  S_BTORCHSHRT,
  S_BTORCHSHRT2,
  S_BTORCHSHRT3,
  S_BTORCHSHRT4,
  S_GTORCHSHRT,
  S_GTORCHSHRT2,
  S_GTORCHSHRT3,
  S_GTORCHSHRT4,
  S_RTORCHSHRT,
  S_RTORCHSHRT2,
  S_RTORCHSHRT3,
  S_RTORCHSHRT4,
  S_HANGNOGUTS,
  S_HANGBNOBRAIN,
  S_HANGTLOOKDN,
  S_HANGTSKULL,
  S_HANGTLOOKUP,
  S_HANGTNOBRAIN,
  S_COLONGIBS,
  S_SMALLPOOL,
  S_BRAINSTEM,
  S_TECHLAMP,
  S_TECHLAMP2,
  S_TECHLAMP3,
  S_TECHLAMP4,
  S_TECH2LAMP,
  S_TECH2LAMP2,
  S_TECH2LAMP3,
  S_TECH2LAMP4,
  S_TNT1, /* add state for invisible sprite          phares 3/8/98  */

  S_GRENADE,   /* killough 8/9/98: grenade launcher */
  S_DETONATE,  /* killough 8/9/98: detonation of objects */
  S_DETONATE2,
  S_DETONATE3,

  // always count dog states, even if dogs are disabled
  S_DOGS_STND,      /* killough 7/19/98: Marine's best friend :) */
  S_DOGS_STND2,
  S_DOGS_RUN1,
  S_DOGS_RUN2,
  S_DOGS_RUN3,
  S_DOGS_RUN4,
  S_DOGS_RUN5,
  S_DOGS_RUN6,
  S_DOGS_RUN7,
  S_DOGS_RUN8,
  S_DOGS_ATK1,
  S_DOGS_ATK2,
  S_DOGS_ATK3,
  S_DOGS_PAIN,
  S_DOGS_PAIN2,
  S_DOGS_DIE1,
  S_DOGS_DIE2,
  S_DOGS_DIE3,
  S_DOGS_DIE4,
  S_DOGS_DIE5,
  S_DOGS_DIE6,
  S_DOGS_RAISE1,
  S_DOGS_RAISE2,
  S_DOGS_RAISE3,
  S_DOGS_RAISE4,
  S_DOGS_RAISE5,
  S_DOGS_RAISE6,

  // add dummy beta bfg / lost soul frames for dehacked compatibility
  // fixes bug #1576151 (part 2)
  S_OLDBFG1,  // killough 7/11/98: the old BFG's 43 firing frames
  S_OLDBFG42 = S_OLDBFG1+41,
  S_OLDBFG43,

  S_PLS1BALL,      // killough 7/19/98: first plasma fireball in the beta
  S_PLS1BALL2,
  S_PLS1EXP,
  S_PLS1EXP2,
  S_PLS1EXP3,
  S_PLS1EXP4,
  S_PLS1EXP5,

  S_PLS2BALL,     // killough 7/19/98: second plasma fireball in the beta
  S_PLS2BALL2,
  S_PLS2BALLX1,
  S_PLS2BALLX2,
  S_PLS2BALLX3,
  S_BON3, // killough 7/11/98: evil sceptre in beta version
  S_BON4, // killough 7/11/98: unholy bible in beta version

  // killough 10/98: beta lost souls were different from their modern cousins
  S_BSKUL_STND,
  S_BSKUL_RUN1,
  S_BSKUL_RUN2,
  S_BSKUL_RUN3,
  S_BSKUL_RUN4,
  S_BSKUL_ATK1,
  S_BSKUL_ATK2,
  S_BSKUL_ATK3,
  S_BSKUL_PAIN1,
  S_BSKUL_PAIN2,
  S_BSKUL_PAIN3,
  S_BSKUL_DIE1,
  S_BSKUL_DIE2,
  S_BSKUL_DIE3,
  S_BSKUL_DIE4,
  S_BSKUL_DIE5,
  S_BSKUL_DIE6,
  S_BSKUL_DIE7,
  S_BSKUL_DIE8,

  S_MUSHROOM,  /* killough 10/98: mushroom explosion effect */

  S_PLAY_GDIE1,
  S_PLAY_GDIE2,
  S_PLAY_GDIE3,
  S_PLAY_GDIE4,
  S_PLAY_GDIE5,
  S_PLAY_GDIE6,
  S_PLAY_GDIE7,
  S_PLAY_GDIE8,
  S_PLAY_GDIE9,
  DOOM_NUMSTATES,

  // heretic
  HERETIC_S_NULL = 0,
  HERETIC_S_FREETARGMOBJ,
  HERETIC_S_ITEM_PTN1_1,
  HERETIC_S_ITEM_PTN1_2,
  HERETIC_S_ITEM_PTN1_3,
  HERETIC_S_ITEM_SHLD1,
  HERETIC_S_ITEM_SHD2_1,
  HERETIC_S_ITEM_BAGH1,
  HERETIC_S_ITEM_SPMP1,
  HERETIC_S_HIDESPECIAL1,
  HERETIC_S_HIDESPECIAL2,
  HERETIC_S_HIDESPECIAL3,
  HERETIC_S_HIDESPECIAL4,
  HERETIC_S_HIDESPECIAL5,
  HERETIC_S_HIDESPECIAL6,
  HERETIC_S_HIDESPECIAL7,
  HERETIC_S_HIDESPECIAL8,
  HERETIC_S_HIDESPECIAL9,
  HERETIC_S_HIDESPECIAL10,
  HERETIC_S_HIDESPECIAL11,
  HERETIC_S_DORMANTARTI1,
  HERETIC_S_DORMANTARTI2,
  HERETIC_S_DORMANTARTI3,
  HERETIC_S_DORMANTARTI4,
  HERETIC_S_DORMANTARTI5,
  HERETIC_S_DORMANTARTI6,
  HERETIC_S_DORMANTARTI7,
  HERETIC_S_DORMANTARTI8,
  HERETIC_S_DORMANTARTI9,
  HERETIC_S_DORMANTARTI10,
  HERETIC_S_DORMANTARTI11,
  HERETIC_S_DORMANTARTI12,
  HERETIC_S_DORMANTARTI13,
  HERETIC_S_DORMANTARTI14,
  HERETIC_S_DORMANTARTI15,
  HERETIC_S_DORMANTARTI16,
  HERETIC_S_DORMANTARTI17,
  HERETIC_S_DORMANTARTI18,
  HERETIC_S_DORMANTARTI19,
  HERETIC_S_DORMANTARTI20,
  HERETIC_S_DORMANTARTI21,
  HERETIC_S_DEADARTI1,
  HERETIC_S_DEADARTI2,
  HERETIC_S_DEADARTI3,
  HERETIC_S_DEADARTI4,
  HERETIC_S_DEADARTI5,
  HERETIC_S_DEADARTI6,
  HERETIC_S_DEADARTI7,
  HERETIC_S_DEADARTI8,
  HERETIC_S_DEADARTI9,
  HERETIC_S_DEADARTI10,
  HERETIC_S_ARTI_INVS1,
  HERETIC_S_ARTI_PTN2_1,
  HERETIC_S_ARTI_PTN2_2,
  HERETIC_S_ARTI_PTN2_3,
  HERETIC_S_ARTI_SOAR1,
  HERETIC_S_ARTI_SOAR2,
  HERETIC_S_ARTI_SOAR3,
  HERETIC_S_ARTI_SOAR4,
  HERETIC_S_ARTI_INVU1,
  HERETIC_S_ARTI_INVU2,
  HERETIC_S_ARTI_INVU3,
  HERETIC_S_ARTI_INVU4,
  HERETIC_S_ARTI_PWBK1,
  HERETIC_S_ARTI_EGGC1,
  HERETIC_S_ARTI_EGGC2,
  HERETIC_S_ARTI_EGGC3,
  HERETIC_S_ARTI_EGGC4,
  HERETIC_S_EGGFX1,
  HERETIC_S_EGGFX2,
  HERETIC_S_EGGFX3,
  HERETIC_S_EGGFX4,
  HERETIC_S_EGGFX5,
  HERETIC_S_EGGFXI1_1,
  HERETIC_S_EGGFXI1_2,
  HERETIC_S_EGGFXI1_3,
  HERETIC_S_EGGFXI1_4,
  HERETIC_S_ARTI_SPHL1,
  HERETIC_S_ARTI_TRCH1,
  HERETIC_S_ARTI_TRCH2,
  HERETIC_S_ARTI_TRCH3,
  HERETIC_S_ARTI_FBMB1,
  HERETIC_S_FIREBOMB1,
  HERETIC_S_FIREBOMB2,
  HERETIC_S_FIREBOMB3,
  HERETIC_S_FIREBOMB4,
  HERETIC_S_FIREBOMB5,
  HERETIC_S_FIREBOMB6,
  HERETIC_S_FIREBOMB7,
  HERETIC_S_FIREBOMB8,
  HERETIC_S_FIREBOMB9,
  HERETIC_S_FIREBOMB10,
  HERETIC_S_FIREBOMB11,
  HERETIC_S_ARTI_ATLP1,
  HERETIC_S_ARTI_ATLP2,
  HERETIC_S_ARTI_ATLP3,
  HERETIC_S_ARTI_ATLP4,
  HERETIC_S_POD_WAIT1,
  HERETIC_S_POD_PAIN1,
  HERETIC_S_POD_DIE1,
  HERETIC_S_POD_DIE2,
  HERETIC_S_POD_DIE3,
  HERETIC_S_POD_DIE4,
  HERETIC_S_POD_GROW1,
  HERETIC_S_POD_GROW2,
  HERETIC_S_POD_GROW3,
  HERETIC_S_POD_GROW4,
  HERETIC_S_POD_GROW5,
  HERETIC_S_POD_GROW6,
  HERETIC_S_POD_GROW7,
  HERETIC_S_POD_GROW8,
  HERETIC_S_PODGOO1,
  HERETIC_S_PODGOO2,
  HERETIC_S_PODGOOX,
  HERETIC_S_PODGENERATOR,
  HERETIC_S_SPLASH1,
  HERETIC_S_SPLASH2,
  HERETIC_S_SPLASH3,
  HERETIC_S_SPLASH4,
  HERETIC_S_SPLASHX,
  HERETIC_S_SPLASHBASE1,
  HERETIC_S_SPLASHBASE2,
  HERETIC_S_SPLASHBASE3,
  HERETIC_S_SPLASHBASE4,
  HERETIC_S_SPLASHBASE5,
  HERETIC_S_SPLASHBASE6,
  HERETIC_S_SPLASHBASE7,
  HERETIC_S_LAVASPLASH1,
  HERETIC_S_LAVASPLASH2,
  HERETIC_S_LAVASPLASH3,
  HERETIC_S_LAVASPLASH4,
  HERETIC_S_LAVASPLASH5,
  HERETIC_S_LAVASPLASH6,
  HERETIC_S_LAVASMOKE1,
  HERETIC_S_LAVASMOKE2,
  HERETIC_S_LAVASMOKE3,
  HERETIC_S_LAVASMOKE4,
  HERETIC_S_LAVASMOKE5,
  HERETIC_S_SLUDGECHUNK1,
  HERETIC_S_SLUDGECHUNK2,
  HERETIC_S_SLUDGECHUNK3,
  HERETIC_S_SLUDGECHUNK4,
  HERETIC_S_SLUDGECHUNKX,
  HERETIC_S_SLUDGESPLASH1,
  HERETIC_S_SLUDGESPLASH2,
  HERETIC_S_SLUDGESPLASH3,
  HERETIC_S_SLUDGESPLASH4,
  HERETIC_S_SKULLHANG70_1,
  HERETIC_S_SKULLHANG60_1,
  HERETIC_S_SKULLHANG45_1,
  HERETIC_S_SKULLHANG35_1,
  HERETIC_S_CHANDELIER1,
  HERETIC_S_CHANDELIER2,
  HERETIC_S_CHANDELIER3,
  HERETIC_S_SERPTORCH1,
  HERETIC_S_SERPTORCH2,
  HERETIC_S_SERPTORCH3,
  HERETIC_S_SMALLPILLAR,
  HERETIC_S_STALAGMITESMALL,
  HERETIC_S_STALAGMITELARGE,
  HERETIC_S_STALACTITESMALL,
  HERETIC_S_STALACTITELARGE,
  HERETIC_S_FIREBRAZIER1,
  HERETIC_S_FIREBRAZIER2,
  HERETIC_S_FIREBRAZIER3,
  HERETIC_S_FIREBRAZIER4,
  HERETIC_S_FIREBRAZIER5,
  HERETIC_S_FIREBRAZIER6,
  HERETIC_S_FIREBRAZIER7,
  HERETIC_S_FIREBRAZIER8,
  HERETIC_S_BARREL,
  HERETIC_S_BRPILLAR,
  HERETIC_S_MOSS1,
  HERETIC_S_MOSS2,
  HERETIC_S_WALLTORCH1,
  HERETIC_S_WALLTORCH2,
  HERETIC_S_WALLTORCH3,
  HERETIC_S_HANGINGCORPSE,
  HERETIC_S_KEYGIZMO1,
  HERETIC_S_KEYGIZMO2,
  HERETIC_S_KEYGIZMO3,
  HERETIC_S_KGZ_START,
  HERETIC_S_KGZ_BLUEFLOAT1,
  HERETIC_S_KGZ_GREENFLOAT1,
  HERETIC_S_KGZ_YELLOWFLOAT1,
  HERETIC_S_VOLCANO1,
  HERETIC_S_VOLCANO2,
  HERETIC_S_VOLCANO3,
  HERETIC_S_VOLCANO4,
  HERETIC_S_VOLCANO5,
  HERETIC_S_VOLCANO6,
  HERETIC_S_VOLCANO7,
  HERETIC_S_VOLCANO8,
  HERETIC_S_VOLCANO9,
  HERETIC_S_VOLCANOBALL1,
  HERETIC_S_VOLCANOBALL2,
  HERETIC_S_VOLCANOBALLX1,
  HERETIC_S_VOLCANOBALLX2,
  HERETIC_S_VOLCANOBALLX3,
  HERETIC_S_VOLCANOBALLX4,
  HERETIC_S_VOLCANOBALLX5,
  HERETIC_S_VOLCANOBALLX6,
  HERETIC_S_VOLCANOTBALL1,
  HERETIC_S_VOLCANOTBALL2,
  HERETIC_S_VOLCANOTBALLX1,
  HERETIC_S_VOLCANOTBALLX2,
  HERETIC_S_VOLCANOTBALLX3,
  HERETIC_S_VOLCANOTBALLX4,
  HERETIC_S_VOLCANOTBALLX5,
  HERETIC_S_VOLCANOTBALLX6,
  HERETIC_S_VOLCANOTBALLX7,
  HERETIC_S_TELEGLITGEN1,
  HERETIC_S_TELEGLITGEN2,
  HERETIC_S_TELEGLITTER1_1,
  HERETIC_S_TELEGLITTER1_2,
  HERETIC_S_TELEGLITTER1_3,
  HERETIC_S_TELEGLITTER1_4,
  HERETIC_S_TELEGLITTER1_5,
  HERETIC_S_TELEGLITTER2_1,
  HERETIC_S_TELEGLITTER2_2,
  HERETIC_S_TELEGLITTER2_3,
  HERETIC_S_TELEGLITTER2_4,
  HERETIC_S_TELEGLITTER2_5,
  HERETIC_S_TFOG1,
  HERETIC_S_TFOG2,
  HERETIC_S_TFOG3,
  HERETIC_S_TFOG4,
  HERETIC_S_TFOG5,
  HERETIC_S_TFOG6,
  HERETIC_S_TFOG7,
  HERETIC_S_TFOG8,
  HERETIC_S_TFOG9,
  HERETIC_S_TFOG10,
  HERETIC_S_TFOG11,
  HERETIC_S_TFOG12,
  HERETIC_S_TFOG13,
  HERETIC_S_LIGHTDONE,
  HERETIC_S_STAFFREADY,
  HERETIC_S_STAFFDOWN,
  HERETIC_S_STAFFUP,
  HERETIC_S_STAFFREADY2_1,
  HERETIC_S_STAFFREADY2_2,
  HERETIC_S_STAFFREADY2_3,
  HERETIC_S_STAFFDOWN2,
  HERETIC_S_STAFFUP2,
  HERETIC_S_STAFFATK1_1,
  HERETIC_S_STAFFATK1_2,
  HERETIC_S_STAFFATK1_3,
  HERETIC_S_STAFFATK2_1,
  HERETIC_S_STAFFATK2_2,
  HERETIC_S_STAFFATK2_3,
  HERETIC_S_STAFFPUFF1,
  HERETIC_S_STAFFPUFF2,
  HERETIC_S_STAFFPUFF3,
  HERETIC_S_STAFFPUFF4,
  HERETIC_S_STAFFPUFF2_1,
  HERETIC_S_STAFFPUFF2_2,
  HERETIC_S_STAFFPUFF2_3,
  HERETIC_S_STAFFPUFF2_4,
  HERETIC_S_STAFFPUFF2_5,
  HERETIC_S_STAFFPUFF2_6,
  HERETIC_S_BEAKREADY,
  HERETIC_S_BEAKDOWN,
  HERETIC_S_BEAKUP,
  HERETIC_S_BEAKATK1_1,
  HERETIC_S_BEAKATK2_1,
  HERETIC_S_WGNT,
  HERETIC_S_GAUNTLETREADY,
  HERETIC_S_GAUNTLETDOWN,
  HERETIC_S_GAUNTLETUP,
  HERETIC_S_GAUNTLETREADY2_1,
  HERETIC_S_GAUNTLETREADY2_2,
  HERETIC_S_GAUNTLETREADY2_3,
  HERETIC_S_GAUNTLETDOWN2,
  HERETIC_S_GAUNTLETUP2,
  HERETIC_S_GAUNTLETATK1_1,
  HERETIC_S_GAUNTLETATK1_2,
  HERETIC_S_GAUNTLETATK1_3,
  HERETIC_S_GAUNTLETATK1_4,
  HERETIC_S_GAUNTLETATK1_5,
  HERETIC_S_GAUNTLETATK1_6,
  HERETIC_S_GAUNTLETATK1_7,
  HERETIC_S_GAUNTLETATK2_1,
  HERETIC_S_GAUNTLETATK2_2,
  HERETIC_S_GAUNTLETATK2_3,
  HERETIC_S_GAUNTLETATK2_4,
  HERETIC_S_GAUNTLETATK2_5,
  HERETIC_S_GAUNTLETATK2_6,
  HERETIC_S_GAUNTLETATK2_7,
  HERETIC_S_GAUNTLETPUFF1_1,
  HERETIC_S_GAUNTLETPUFF1_2,
  HERETIC_S_GAUNTLETPUFF1_3,
  HERETIC_S_GAUNTLETPUFF1_4,
  HERETIC_S_GAUNTLETPUFF2_1,
  HERETIC_S_GAUNTLETPUFF2_2,
  HERETIC_S_GAUNTLETPUFF2_3,
  HERETIC_S_GAUNTLETPUFF2_4,
  HERETIC_S_BLSR,
  HERETIC_S_BLASTERREADY,
  HERETIC_S_BLASTERDOWN,
  HERETIC_S_BLASTERUP,
  HERETIC_S_BLASTERATK1_1,
  HERETIC_S_BLASTERATK1_2,
  HERETIC_S_BLASTERATK1_3,
  HERETIC_S_BLASTERATK1_4,
  HERETIC_S_BLASTERATK1_5,
  HERETIC_S_BLASTERATK1_6,
  HERETIC_S_BLASTERATK2_1,
  HERETIC_S_BLASTERATK2_2,
  HERETIC_S_BLASTERATK2_3,
  HERETIC_S_BLASTERATK2_4,
  HERETIC_S_BLASTERATK2_5,
  HERETIC_S_BLASTERATK2_6,
  HERETIC_S_BLASTERFX1_1,
  HERETIC_S_BLASTERFXI1_1,
  HERETIC_S_BLASTERFXI1_2,
  HERETIC_S_BLASTERFXI1_3,
  HERETIC_S_BLASTERFXI1_4,
  HERETIC_S_BLASTERFXI1_5,
  HERETIC_S_BLASTERFXI1_6,
  HERETIC_S_BLASTERFXI1_7,
  HERETIC_S_BLASTERSMOKE1,
  HERETIC_S_BLASTERSMOKE2,
  HERETIC_S_BLASTERSMOKE3,
  HERETIC_S_BLASTERSMOKE4,
  HERETIC_S_BLASTERSMOKE5,
  HERETIC_S_RIPPER1,
  HERETIC_S_RIPPER2,
  HERETIC_S_RIPPERX1,
  HERETIC_S_RIPPERX2,
  HERETIC_S_RIPPERX3,
  HERETIC_S_RIPPERX4,
  HERETIC_S_RIPPERX5,
  HERETIC_S_BLASTERPUFF1_1,
  HERETIC_S_BLASTERPUFF1_2,
  HERETIC_S_BLASTERPUFF1_3,
  HERETIC_S_BLASTERPUFF1_4,
  HERETIC_S_BLASTERPUFF1_5,
  HERETIC_S_BLASTERPUFF2_1,
  HERETIC_S_BLASTERPUFF2_2,
  HERETIC_S_BLASTERPUFF2_3,
  HERETIC_S_BLASTERPUFF2_4,
  HERETIC_S_BLASTERPUFF2_5,
  HERETIC_S_BLASTERPUFF2_6,
  HERETIC_S_BLASTERPUFF2_7,
  HERETIC_S_WMCE,
  HERETIC_S_MACEREADY,
  HERETIC_S_MACEDOWN,
  HERETIC_S_MACEUP,
  HERETIC_S_MACEATK1_1,
  HERETIC_S_MACEATK1_2,
  HERETIC_S_MACEATK1_3,
  HERETIC_S_MACEATK1_4,
  HERETIC_S_MACEATK1_5,
  HERETIC_S_MACEATK1_6,
  HERETIC_S_MACEATK1_7,
  HERETIC_S_MACEATK1_8,
  HERETIC_S_MACEATK1_9,
  HERETIC_S_MACEATK1_10,
  HERETIC_S_MACEATK2_1,
  HERETIC_S_MACEATK2_2,
  HERETIC_S_MACEATK2_3,
  HERETIC_S_MACEATK2_4,
  HERETIC_S_MACEFX1_1,
  HERETIC_S_MACEFX1_2,
  HERETIC_S_MACEFXI1_1,
  HERETIC_S_MACEFXI1_2,
  HERETIC_S_MACEFXI1_3,
  HERETIC_S_MACEFXI1_4,
  HERETIC_S_MACEFXI1_5,
  HERETIC_S_MACEFX2_1,
  HERETIC_S_MACEFX2_2,
  HERETIC_S_MACEFXI2_1,
  HERETIC_S_MACEFX3_1,
  HERETIC_S_MACEFX3_2,
  HERETIC_S_MACEFX4_1,
  HERETIC_S_MACEFXI4_1,
  HERETIC_S_WSKL,
  HERETIC_S_HORNRODREADY,
  HERETIC_S_HORNRODDOWN,
  HERETIC_S_HORNRODUP,
  HERETIC_S_HORNRODATK1_1,
  HERETIC_S_HORNRODATK1_2,
  HERETIC_S_HORNRODATK1_3,
  HERETIC_S_HORNRODATK2_1,
  HERETIC_S_HORNRODATK2_2,
  HERETIC_S_HORNRODATK2_3,
  HERETIC_S_HORNRODATK2_4,
  HERETIC_S_HORNRODATK2_5,
  HERETIC_S_HORNRODATK2_6,
  HERETIC_S_HORNRODATK2_7,
  HERETIC_S_HORNRODATK2_8,
  HERETIC_S_HORNRODATK2_9,
  HERETIC_S_HRODFX1_1,
  HERETIC_S_HRODFX1_2,
  HERETIC_S_HRODFXI1_1,
  HERETIC_S_HRODFXI1_2,
  HERETIC_S_HRODFXI1_3,
  HERETIC_S_HRODFXI1_4,
  HERETIC_S_HRODFXI1_5,
  HERETIC_S_HRODFXI1_6,
  HERETIC_S_HRODFX2_1,
  HERETIC_S_HRODFX2_2,
  HERETIC_S_HRODFX2_3,
  HERETIC_S_HRODFX2_4,
  HERETIC_S_HRODFXI2_1,
  HERETIC_S_HRODFXI2_2,
  HERETIC_S_HRODFXI2_3,
  HERETIC_S_HRODFXI2_4,
  HERETIC_S_HRODFXI2_5,
  HERETIC_S_HRODFXI2_6,
  HERETIC_S_HRODFXI2_7,
  HERETIC_S_HRODFXI2_8,
  HERETIC_S_RAINPLR1_1,
  HERETIC_S_RAINPLR2_1,
  HERETIC_S_RAINPLR3_1,
  HERETIC_S_RAINPLR4_1,
  HERETIC_S_RAINPLR1X_1,
  HERETIC_S_RAINPLR1X_2,
  HERETIC_S_RAINPLR1X_3,
  HERETIC_S_RAINPLR1X_4,
  HERETIC_S_RAINPLR1X_5,
  HERETIC_S_RAINPLR2X_1,
  HERETIC_S_RAINPLR2X_2,
  HERETIC_S_RAINPLR2X_3,
  HERETIC_S_RAINPLR2X_4,
  HERETIC_S_RAINPLR2X_5,
  HERETIC_S_RAINPLR3X_1,
  HERETIC_S_RAINPLR3X_2,
  HERETIC_S_RAINPLR3X_3,
  HERETIC_S_RAINPLR3X_4,
  HERETIC_S_RAINPLR3X_5,
  HERETIC_S_RAINPLR4X_1,
  HERETIC_S_RAINPLR4X_2,
  HERETIC_S_RAINPLR4X_3,
  HERETIC_S_RAINPLR4X_4,
  HERETIC_S_RAINPLR4X_5,
  HERETIC_S_RAINAIRXPLR1_1,
  HERETIC_S_RAINAIRXPLR2_1,
  HERETIC_S_RAINAIRXPLR3_1,
  HERETIC_S_RAINAIRXPLR4_1,
  HERETIC_S_RAINAIRXPLR1_2,
  HERETIC_S_RAINAIRXPLR2_2,
  HERETIC_S_RAINAIRXPLR3_2,
  HERETIC_S_RAINAIRXPLR4_2,
  HERETIC_S_RAINAIRXPLR1_3,
  HERETIC_S_RAINAIRXPLR2_3,
  HERETIC_S_RAINAIRXPLR3_3,
  HERETIC_S_RAINAIRXPLR4_3,
  HERETIC_S_GOLDWANDREADY,
  HERETIC_S_GOLDWANDDOWN,
  HERETIC_S_GOLDWANDUP,
  HERETIC_S_GOLDWANDATK1_1,
  HERETIC_S_GOLDWANDATK1_2,
  HERETIC_S_GOLDWANDATK1_3,
  HERETIC_S_GOLDWANDATK1_4,
  HERETIC_S_GOLDWANDATK2_1,
  HERETIC_S_GOLDWANDATK2_2,
  HERETIC_S_GOLDWANDATK2_3,
  HERETIC_S_GOLDWANDATK2_4,
  HERETIC_S_GWANDFX1_1,
  HERETIC_S_GWANDFX1_2,
  HERETIC_S_GWANDFXI1_1,
  HERETIC_S_GWANDFXI1_2,
  HERETIC_S_GWANDFXI1_3,
  HERETIC_S_GWANDFXI1_4,
  HERETIC_S_GWANDFX2_1,
  HERETIC_S_GWANDFX2_2,
  HERETIC_S_GWANDPUFF1_1,
  HERETIC_S_GWANDPUFF1_2,
  HERETIC_S_GWANDPUFF1_3,
  HERETIC_S_GWANDPUFF1_4,
  HERETIC_S_GWANDPUFF1_5,
  HERETIC_S_WPHX,
  HERETIC_S_PHOENIXREADY,
  HERETIC_S_PHOENIXDOWN,
  HERETIC_S_PHOENIXUP,
  HERETIC_S_PHOENIXATK1_1,
  HERETIC_S_PHOENIXATK1_2,
  HERETIC_S_PHOENIXATK1_3,
  HERETIC_S_PHOENIXATK1_4,
  HERETIC_S_PHOENIXATK1_5,
  HERETIC_S_PHOENIXATK2_1,
  HERETIC_S_PHOENIXATK2_2,
  HERETIC_S_PHOENIXATK2_3,
  HERETIC_S_PHOENIXATK2_4,
  HERETIC_S_PHOENIXFX1_1,
  HERETIC_S_PHOENIXFXI1_1,
  HERETIC_S_PHOENIXFXI1_2,
  HERETIC_S_PHOENIXFXI1_3,
  HERETIC_S_PHOENIXFXI1_4,
  HERETIC_S_PHOENIXFXI1_5,
  HERETIC_S_PHOENIXFXI1_6,
  HERETIC_S_PHOENIXFXI1_7,
  HERETIC_S_PHOENIXFXI1_8,
  HERETIC_S_PHOENIXFXIX_1,      // [ States in Heretic 1.0 that were removed
  HERETIC_S_PHOENIXFXIX_2,
  HERETIC_S_PHOENIXFXIX_3,      // ]
  HERETIC_S_PHOENIXPUFF1,
  HERETIC_S_PHOENIXPUFF2,
  HERETIC_S_PHOENIXPUFF3,
  HERETIC_S_PHOENIXPUFF4,
  HERETIC_S_PHOENIXPUFF5,
  HERETIC_S_PHOENIXFX2_1,
  HERETIC_S_PHOENIXFX2_2,
  HERETIC_S_PHOENIXFX2_3,
  HERETIC_S_PHOENIXFX2_4,
  HERETIC_S_PHOENIXFX2_5,
  HERETIC_S_PHOENIXFX2_6,
  HERETIC_S_PHOENIXFX2_7,
  HERETIC_S_PHOENIXFX2_8,
  HERETIC_S_PHOENIXFX2_9,
  HERETIC_S_PHOENIXFX2_10,
  HERETIC_S_PHOENIXFXI2_1,
  HERETIC_S_PHOENIXFXI2_2,
  HERETIC_S_PHOENIXFXI2_3,
  HERETIC_S_PHOENIXFXI2_4,
  HERETIC_S_PHOENIXFXI2_5,
  HERETIC_S_WBOW,
  HERETIC_S_CRBOW1,
  HERETIC_S_CRBOW2,
  HERETIC_S_CRBOW3,
  HERETIC_S_CRBOW4,
  HERETIC_S_CRBOW5,
  HERETIC_S_CRBOW6,
  HERETIC_S_CRBOW7,
  HERETIC_S_CRBOW8,
  HERETIC_S_CRBOW9,
  HERETIC_S_CRBOW10,
  HERETIC_S_CRBOW11,
  HERETIC_S_CRBOW12,
  HERETIC_S_CRBOW13,
  HERETIC_S_CRBOW14,
  HERETIC_S_CRBOW15,
  HERETIC_S_CRBOW16,
  HERETIC_S_CRBOW17,
  HERETIC_S_CRBOW18,
  HERETIC_S_CRBOWDOWN,
  HERETIC_S_CRBOWUP,
  HERETIC_S_CRBOWATK1_1,
  HERETIC_S_CRBOWATK1_2,
  HERETIC_S_CRBOWATK1_3,
  HERETIC_S_CRBOWATK1_4,
  HERETIC_S_CRBOWATK1_5,
  HERETIC_S_CRBOWATK1_6,
  HERETIC_S_CRBOWATK1_7,
  HERETIC_S_CRBOWATK1_8,
  HERETIC_S_CRBOWATK2_1,
  HERETIC_S_CRBOWATK2_2,
  HERETIC_S_CRBOWATK2_3,
  HERETIC_S_CRBOWATK2_4,
  HERETIC_S_CRBOWATK2_5,
  HERETIC_S_CRBOWATK2_6,
  HERETIC_S_CRBOWATK2_7,
  HERETIC_S_CRBOWATK2_8,
  HERETIC_S_CRBOWFX1,
  HERETIC_S_CRBOWFXI1_1,
  HERETIC_S_CRBOWFXI1_2,
  HERETIC_S_CRBOWFXI1_3,
  HERETIC_S_CRBOWFX2,
  HERETIC_S_CRBOWFX3,
  HERETIC_S_CRBOWFXI3_1,
  HERETIC_S_CRBOWFXI3_2,
  HERETIC_S_CRBOWFXI3_3,
  HERETIC_S_CRBOWFX4_1,
  HERETIC_S_CRBOWFX4_2,
  HERETIC_S_BLOOD1,
  HERETIC_S_BLOOD2,
  HERETIC_S_BLOOD3,
  HERETIC_S_BLOODSPLATTER1,
  HERETIC_S_BLOODSPLATTER2,
  HERETIC_S_BLOODSPLATTER3,
  HERETIC_S_BLOODSPLATTERX,
  HERETIC_S_PLAY,
  HERETIC_S_PLAY_RUN1,
  HERETIC_S_PLAY_RUN2,
  HERETIC_S_PLAY_RUN3,
  HERETIC_S_PLAY_RUN4,
  HERETIC_S_PLAY_ATK1,
  HERETIC_S_PLAY_ATK2,
  HERETIC_S_PLAY_PAIN,
  HERETIC_S_PLAY_PAIN2,
  HERETIC_S_PLAY_DIE1,
  HERETIC_S_PLAY_DIE2,
  HERETIC_S_PLAY_DIE3,
  HERETIC_S_PLAY_DIE4,
  HERETIC_S_PLAY_DIE5,
  HERETIC_S_PLAY_DIE6,
  HERETIC_S_PLAY_DIE7,
  HERETIC_S_PLAY_DIE8,
  HERETIC_S_PLAY_DIE9,
  HERETIC_S_PLAY_XDIE1,
  HERETIC_S_PLAY_XDIE2,
  HERETIC_S_PLAY_XDIE3,
  HERETIC_S_PLAY_XDIE4,
  HERETIC_S_PLAY_XDIE5,
  HERETIC_S_PLAY_XDIE6,
  HERETIC_S_PLAY_XDIE7,
  HERETIC_S_PLAY_XDIE8,
  HERETIC_S_PLAY_XDIE9,
  HERETIC_S_PLAY_FDTH1,
  HERETIC_S_PLAY_FDTH2,
  HERETIC_S_PLAY_FDTH3,
  HERETIC_S_PLAY_FDTH4,
  HERETIC_S_PLAY_FDTH5,
  HERETIC_S_PLAY_FDTH6,
  HERETIC_S_PLAY_FDTH7,
  HERETIC_S_PLAY_FDTH8,
  HERETIC_S_PLAY_FDTH9,
  HERETIC_S_PLAY_FDTH10,
  HERETIC_S_PLAY_FDTH11,
  HERETIC_S_PLAY_FDTH12,
  HERETIC_S_PLAY_FDTH13,
  HERETIC_S_PLAY_FDTH14,
  HERETIC_S_PLAY_FDTH15,
  HERETIC_S_PLAY_FDTH16,
  HERETIC_S_PLAY_FDTH17,
  HERETIC_S_PLAY_FDTH18,
  HERETIC_S_PLAY_FDTH19,    // < These two frames were not present in the Heretic
  HERETIC_S_PLAY_FDTH20,    // < 1.0 executable (fire death animation was extended)
  HERETIC_S_BLOODYSKULL1,
  HERETIC_S_BLOODYSKULL2,
  HERETIC_S_BLOODYSKULL3,
  HERETIC_S_BLOODYSKULL4,
  HERETIC_S_BLOODYSKULL5,
  HERETIC_S_BLOODYSKULLX1,
  HERETIC_S_BLOODYSKULLX2,
  HERETIC_S_CHICPLAY,
  HERETIC_S_CHICPLAY_RUN1,
  HERETIC_S_CHICPLAY_RUN2,
  HERETIC_S_CHICPLAY_RUN3,
  HERETIC_S_CHICPLAY_RUN4,
  HERETIC_S_CHICPLAY_ATK1,
  HERETIC_S_CHICPLAY_PAIN,
  HERETIC_S_CHICPLAY_PAIN2,
  HERETIC_S_CHICKEN_LOOK1,
  HERETIC_S_CHICKEN_LOOK2,
  HERETIC_S_CHICKEN_WALK1,
  HERETIC_S_CHICKEN_WALK2,
  HERETIC_S_CHICKEN_PAIN1,
  HERETIC_S_CHICKEN_PAIN2,
  HERETIC_S_CHICKEN_ATK1,
  HERETIC_S_CHICKEN_ATK2,
  HERETIC_S_CHICKEN_DIE1,
  HERETIC_S_CHICKEN_DIE2,
  HERETIC_S_CHICKEN_DIE3,
  HERETIC_S_CHICKEN_DIE4,
  HERETIC_S_CHICKEN_DIE5,
  HERETIC_S_CHICKEN_DIE6,
  HERETIC_S_CHICKEN_DIE7,
  HERETIC_S_CHICKEN_DIE8,
  HERETIC_S_FEATHER1,
  HERETIC_S_FEATHER2,
  HERETIC_S_FEATHER3,
  HERETIC_S_FEATHER4,
  HERETIC_S_FEATHER5,
  HERETIC_S_FEATHER6,
  HERETIC_S_FEATHER7,
  HERETIC_S_FEATHER8,
  HERETIC_S_FEATHERX,
  HERETIC_S_MUMMY_LOOK1,
  HERETIC_S_MUMMY_LOOK2,
  HERETIC_S_MUMMY_WALK1,
  HERETIC_S_MUMMY_WALK2,
  HERETIC_S_MUMMY_WALK3,
  HERETIC_S_MUMMY_WALK4,
  HERETIC_S_MUMMY_ATK1,
  HERETIC_S_MUMMY_ATK2,
  HERETIC_S_MUMMY_ATK3,
  HERETIC_S_MUMMYL_ATK1,
  HERETIC_S_MUMMYL_ATK2,
  HERETIC_S_MUMMYL_ATK3,
  HERETIC_S_MUMMYL_ATK4,
  HERETIC_S_MUMMYL_ATK5,
  HERETIC_S_MUMMYL_ATK6,
  HERETIC_S_MUMMY_PAIN1,
  HERETIC_S_MUMMY_PAIN2,
  HERETIC_S_MUMMY_DIE1,
  HERETIC_S_MUMMY_DIE2,
  HERETIC_S_MUMMY_DIE3,
  HERETIC_S_MUMMY_DIE4,
  HERETIC_S_MUMMY_DIE5,
  HERETIC_S_MUMMY_DIE6,
  HERETIC_S_MUMMY_DIE7,
  HERETIC_S_MUMMY_DIE8,
  HERETIC_S_MUMMY_SOUL1,
  HERETIC_S_MUMMY_SOUL2,
  HERETIC_S_MUMMY_SOUL3,
  HERETIC_S_MUMMY_SOUL4,
  HERETIC_S_MUMMY_SOUL5,
  HERETIC_S_MUMMY_SOUL6,
  HERETIC_S_MUMMY_SOUL7,
  HERETIC_S_MUMMYFX1_1,
  HERETIC_S_MUMMYFX1_2,
  HERETIC_S_MUMMYFX1_3,
  HERETIC_S_MUMMYFX1_4,
  HERETIC_S_MUMMYFXI1_1,
  HERETIC_S_MUMMYFXI1_2,
  HERETIC_S_MUMMYFXI1_3,
  HERETIC_S_MUMMYFXI1_4,
  HERETIC_S_BEAST_LOOK1,
  HERETIC_S_BEAST_LOOK2,
  HERETIC_S_BEAST_WALK1,
  HERETIC_S_BEAST_WALK2,
  HERETIC_S_BEAST_WALK3,
  HERETIC_S_BEAST_WALK4,
  HERETIC_S_BEAST_WALK5,
  HERETIC_S_BEAST_WALK6,
  HERETIC_S_BEAST_ATK1,
  HERETIC_S_BEAST_ATK2,
  HERETIC_S_BEAST_PAIN1,
  HERETIC_S_BEAST_PAIN2,
  HERETIC_S_BEAST_DIE1,
  HERETIC_S_BEAST_DIE2,
  HERETIC_S_BEAST_DIE3,
  HERETIC_S_BEAST_DIE4,
  HERETIC_S_BEAST_DIE5,
  HERETIC_S_BEAST_DIE6,
  HERETIC_S_BEAST_DIE7,
  HERETIC_S_BEAST_DIE8,
  HERETIC_S_BEAST_DIE9,
  HERETIC_S_BEAST_XDIE1,
  HERETIC_S_BEAST_XDIE2,
  HERETIC_S_BEAST_XDIE3,
  HERETIC_S_BEAST_XDIE4,
  HERETIC_S_BEAST_XDIE5,
  HERETIC_S_BEAST_XDIE6,
  HERETIC_S_BEAST_XDIE7,
  HERETIC_S_BEAST_XDIE8,
  HERETIC_S_BEASTBALL1,
  HERETIC_S_BEASTBALL2,
  HERETIC_S_BEASTBALL3,
  HERETIC_S_BEASTBALL4,
  HERETIC_S_BEASTBALL5,
  HERETIC_S_BEASTBALL6,
  HERETIC_S_BEASTBALLX1,
  HERETIC_S_BEASTBALLX2,
  HERETIC_S_BEASTBALLX3,
  HERETIC_S_BEASTBALLX4,
  HERETIC_S_BEASTBALLX5,
  HERETIC_S_BURNBALL1,
  HERETIC_S_BURNBALL2,
  HERETIC_S_BURNBALL3,
  HERETIC_S_BURNBALL4,
  HERETIC_S_BURNBALL5,
  HERETIC_S_BURNBALL6,
  HERETIC_S_BURNBALL7,
  HERETIC_S_BURNBALL8,
  HERETIC_S_BURNBALLFB1,
  HERETIC_S_BURNBALLFB2,
  HERETIC_S_BURNBALLFB3,
  HERETIC_S_BURNBALLFB4,
  HERETIC_S_BURNBALLFB5,
  HERETIC_S_BURNBALLFB6,
  HERETIC_S_BURNBALLFB7,
  HERETIC_S_BURNBALLFB8,
  HERETIC_S_PUFFY1,
  HERETIC_S_PUFFY2,
  HERETIC_S_PUFFY3,
  HERETIC_S_PUFFY4,
  HERETIC_S_PUFFY5,
  HERETIC_S_SNAKE_LOOK1,
  HERETIC_S_SNAKE_LOOK2,
  HERETIC_S_SNAKE_WALK1,
  HERETIC_S_SNAKE_WALK2,
  HERETIC_S_SNAKE_WALK3,
  HERETIC_S_SNAKE_WALK4,
  HERETIC_S_SNAKE_ATK1,
  HERETIC_S_SNAKE_ATK2,
  HERETIC_S_SNAKE_ATK3,
  HERETIC_S_SNAKE_ATK4,
  HERETIC_S_SNAKE_ATK5,
  HERETIC_S_SNAKE_ATK6,
  HERETIC_S_SNAKE_ATK7,
  HERETIC_S_SNAKE_ATK8,
  HERETIC_S_SNAKE_ATK9,
  HERETIC_S_SNAKE_PAIN1,
  HERETIC_S_SNAKE_PAIN2,
  HERETIC_S_SNAKE_DIE1,
  HERETIC_S_SNAKE_DIE2,
  HERETIC_S_SNAKE_DIE3,
  HERETIC_S_SNAKE_DIE4,
  HERETIC_S_SNAKE_DIE5,
  HERETIC_S_SNAKE_DIE6,
  HERETIC_S_SNAKE_DIE7,
  HERETIC_S_SNAKE_DIE8,
  HERETIC_S_SNAKE_DIE9,
  HERETIC_S_SNAKE_DIE10,
  HERETIC_S_SNAKEPRO_A1,
  HERETIC_S_SNAKEPRO_A2,
  HERETIC_S_SNAKEPRO_A3,
  HERETIC_S_SNAKEPRO_A4,
  HERETIC_S_SNAKEPRO_AX1,
  HERETIC_S_SNAKEPRO_AX2,
  HERETIC_S_SNAKEPRO_AX3,
  HERETIC_S_SNAKEPRO_AX4,
  HERETIC_S_SNAKEPRO_AX5,
  HERETIC_S_SNAKEPRO_B1,
  HERETIC_S_SNAKEPRO_B2,
  HERETIC_S_SNAKEPRO_BX1,
  HERETIC_S_SNAKEPRO_BX2,
  HERETIC_S_SNAKEPRO_BX3,
  HERETIC_S_SNAKEPRO_BX4,
  HERETIC_S_HEAD_LOOK,
  HERETIC_S_HEAD_FLOAT,
  HERETIC_S_HEAD_ATK1,
  HERETIC_S_HEAD_ATK2,
  HERETIC_S_HEAD_PAIN1,
  HERETIC_S_HEAD_PAIN2,
  HERETIC_S_HEAD_DIE1,
  HERETIC_S_HEAD_DIE2,
  HERETIC_S_HEAD_DIE3,
  HERETIC_S_HEAD_DIE4,
  HERETIC_S_HEAD_DIE5,
  HERETIC_S_HEAD_DIE6,
  HERETIC_S_HEAD_DIE7,
  HERETIC_S_HEADFX1_1,
  HERETIC_S_HEADFX1_2,
  HERETIC_S_HEADFX1_3,
  HERETIC_S_HEADFXI1_1,
  HERETIC_S_HEADFXI1_2,
  HERETIC_S_HEADFXI1_3,
  HERETIC_S_HEADFXI1_4,
  HERETIC_S_HEADFX2_1,
  HERETIC_S_HEADFX2_2,
  HERETIC_S_HEADFX2_3,
  HERETIC_S_HEADFXI2_1,
  HERETIC_S_HEADFXI2_2,
  HERETIC_S_HEADFXI2_3,
  HERETIC_S_HEADFXI2_4,
  HERETIC_S_HEADFX3_1,
  HERETIC_S_HEADFX3_2,
  HERETIC_S_HEADFX3_3,
  HERETIC_S_HEADFX3_4,
  HERETIC_S_HEADFX3_5,
  HERETIC_S_HEADFX3_6,
  HERETIC_S_HEADFXI3_1,
  HERETIC_S_HEADFXI3_2,
  HERETIC_S_HEADFXI3_3,
  HERETIC_S_HEADFXI3_4,
  HERETIC_S_HEADFX4_1,
  HERETIC_S_HEADFX4_2,
  HERETIC_S_HEADFX4_3,
  HERETIC_S_HEADFX4_4,
  HERETIC_S_HEADFX4_5,
  HERETIC_S_HEADFX4_6,
  HERETIC_S_HEADFX4_7,
  HERETIC_S_HEADFXI4_1,
  HERETIC_S_HEADFXI4_2,
  HERETIC_S_HEADFXI4_3,
  HERETIC_S_HEADFXI4_4,
  HERETIC_S_CLINK_LOOK1,
  HERETIC_S_CLINK_LOOK2,
  HERETIC_S_CLINK_WALK1,
  HERETIC_S_CLINK_WALK2,
  HERETIC_S_CLINK_WALK3,
  HERETIC_S_CLINK_WALK4,
  HERETIC_S_CLINK_ATK1,
  HERETIC_S_CLINK_ATK2,
  HERETIC_S_CLINK_ATK3,
  HERETIC_S_CLINK_PAIN1,
  HERETIC_S_CLINK_PAIN2,
  HERETIC_S_CLINK_DIE1,
  HERETIC_S_CLINK_DIE2,
  HERETIC_S_CLINK_DIE3,
  HERETIC_S_CLINK_DIE4,
  HERETIC_S_CLINK_DIE5,
  HERETIC_S_CLINK_DIE6,
  HERETIC_S_CLINK_DIE7,
  HERETIC_S_WIZARD_LOOK1,
  HERETIC_S_WIZARD_LOOK2,
  HERETIC_S_WIZARD_WALK1,
  HERETIC_S_WIZARD_WALK2,
  HERETIC_S_WIZARD_WALK3,
  HERETIC_S_WIZARD_WALK4,
  HERETIC_S_WIZARD_WALK5,
  HERETIC_S_WIZARD_WALK6,
  HERETIC_S_WIZARD_WALK7,
  HERETIC_S_WIZARD_WALK8,
  HERETIC_S_WIZARD_ATK1,
  HERETIC_S_WIZARD_ATK2,
  HERETIC_S_WIZARD_ATK3,
  HERETIC_S_WIZARD_ATK4,
  HERETIC_S_WIZARD_ATK5,
  HERETIC_S_WIZARD_ATK6,
  HERETIC_S_WIZARD_ATK7,
  HERETIC_S_WIZARD_ATK8,
  HERETIC_S_WIZARD_ATK9,
  HERETIC_S_WIZARD_PAIN1,
  HERETIC_S_WIZARD_PAIN2,
  HERETIC_S_WIZARD_DIE1,
  HERETIC_S_WIZARD_DIE2,
  HERETIC_S_WIZARD_DIE3,
  HERETIC_S_WIZARD_DIE4,
  HERETIC_S_WIZARD_DIE5,
  HERETIC_S_WIZARD_DIE6,
  HERETIC_S_WIZARD_DIE7,
  HERETIC_S_WIZARD_DIE8,
  HERETIC_S_WIZFX1_1,
  HERETIC_S_WIZFX1_2,
  HERETIC_S_WIZFXI1_1,
  HERETIC_S_WIZFXI1_2,
  HERETIC_S_WIZFXI1_3,
  HERETIC_S_WIZFXI1_4,
  HERETIC_S_WIZFXI1_5,
  HERETIC_S_IMP_LOOK1,
  HERETIC_S_IMP_LOOK2,
  HERETIC_S_IMP_LOOK3,
  HERETIC_S_IMP_LOOK4,
  HERETIC_S_IMP_FLY1,
  HERETIC_S_IMP_FLY2,
  HERETIC_S_IMP_FLY3,
  HERETIC_S_IMP_FLY4,
  HERETIC_S_IMP_FLY5,
  HERETIC_S_IMP_FLY6,
  HERETIC_S_IMP_FLY7,
  HERETIC_S_IMP_FLY8,
  HERETIC_S_IMP_MEATK1,
  HERETIC_S_IMP_MEATK2,
  HERETIC_S_IMP_MEATK3,
  HERETIC_S_IMP_MSATK1_1,
  HERETIC_S_IMP_MSATK1_2,
  HERETIC_S_IMP_MSATK1_3,
  HERETIC_S_IMP_MSATK1_4,
  HERETIC_S_IMP_MSATK1_5,
  HERETIC_S_IMP_MSATK1_6,
  HERETIC_S_IMP_MSATK2_1,
  HERETIC_S_IMP_MSATK2_2,
  HERETIC_S_IMP_MSATK2_3,
  HERETIC_S_IMP_PAIN1,
  HERETIC_S_IMP_PAIN2,
  HERETIC_S_IMP_DIE1,
  HERETIC_S_IMP_DIE2,
  HERETIC_S_IMP_XDIE1,
  HERETIC_S_IMP_XDIE2,
  HERETIC_S_IMP_XDIE3,
  HERETIC_S_IMP_XDIE4,
  HERETIC_S_IMP_XDIE5,
  HERETIC_S_IMP_CRASH1,
  HERETIC_S_IMP_CRASH2,
  HERETIC_S_IMP_CRASH3,
  HERETIC_S_IMP_CRASH4,
  HERETIC_S_IMP_XCRASH1,
  HERETIC_S_IMP_XCRASH2,
  HERETIC_S_IMP_XCRASH3,
  HERETIC_S_IMP_CHUNKA1,
  HERETIC_S_IMP_CHUNKA2,
  HERETIC_S_IMP_CHUNKA3,
  HERETIC_S_IMP_CHUNKB1,
  HERETIC_S_IMP_CHUNKB2,
  HERETIC_S_IMP_CHUNKB3,
  HERETIC_S_IMPFX1,
  HERETIC_S_IMPFX2,
  HERETIC_S_IMPFX3,
  HERETIC_S_IMPFXI1,
  HERETIC_S_IMPFXI2,
  HERETIC_S_IMPFXI3,
  HERETIC_S_IMPFXI4,
  HERETIC_S_KNIGHT_STND1,
  HERETIC_S_KNIGHT_STND2,
  HERETIC_S_KNIGHT_WALK1,
  HERETIC_S_KNIGHT_WALK2,
  HERETIC_S_KNIGHT_WALK3,
  HERETIC_S_KNIGHT_WALK4,
  HERETIC_S_KNIGHT_ATK1,
  HERETIC_S_KNIGHT_ATK2,
  HERETIC_S_KNIGHT_ATK3,
  HERETIC_S_KNIGHT_ATK4,
  HERETIC_S_KNIGHT_ATK5,
  HERETIC_S_KNIGHT_ATK6,
  HERETIC_S_KNIGHT_PAIN1,
  HERETIC_S_KNIGHT_PAIN2,
  HERETIC_S_KNIGHT_DIE1,
  HERETIC_S_KNIGHT_DIE2,
  HERETIC_S_KNIGHT_DIE3,
  HERETIC_S_KNIGHT_DIE4,
  HERETIC_S_KNIGHT_DIE5,
  HERETIC_S_KNIGHT_DIE6,
  HERETIC_S_KNIGHT_DIE7,
  HERETIC_S_SPINAXE1,
  HERETIC_S_SPINAXE2,
  HERETIC_S_SPINAXE3,
  HERETIC_S_SPINAXEX1,
  HERETIC_S_SPINAXEX2,
  HERETIC_S_SPINAXEX3,
  HERETIC_S_REDAXE1,
  HERETIC_S_REDAXE2,
  HERETIC_S_REDAXEX1,
  HERETIC_S_REDAXEX2,
  HERETIC_S_REDAXEX3,
  HERETIC_S_SRCR1_LOOK1,
  HERETIC_S_SRCR1_LOOK2,
  HERETIC_S_SRCR1_WALK1,
  HERETIC_S_SRCR1_WALK2,
  HERETIC_S_SRCR1_WALK3,
  HERETIC_S_SRCR1_WALK4,
  HERETIC_S_SRCR1_PAIN1,
  HERETIC_S_SRCR1_ATK1,
  HERETIC_S_SRCR1_ATK2,
  HERETIC_S_SRCR1_ATK3,
  HERETIC_S_SRCR1_ATK4,
  HERETIC_S_SRCR1_ATK5,
  HERETIC_S_SRCR1_ATK6,
  HERETIC_S_SRCR1_ATK7,
  HERETIC_S_SRCR1_DIE1,
  HERETIC_S_SRCR1_DIE2,
  HERETIC_S_SRCR1_DIE3,
  HERETIC_S_SRCR1_DIE4,
  HERETIC_S_SRCR1_DIE5,
  HERETIC_S_SRCR1_DIE6,
  HERETIC_S_SRCR1_DIE7,
  HERETIC_S_SRCR1_DIE8,
  HERETIC_S_SRCR1_DIE9,
  HERETIC_S_SRCR1_DIE10,
  HERETIC_S_SRCR1_DIE11,
  HERETIC_S_SRCR1_DIE12,
  HERETIC_S_SRCR1_DIE13,
  HERETIC_S_SRCR1_DIE14,
  HERETIC_S_SRCR1_DIE15,
  HERETIC_S_SRCR1_DIE16,
  HERETIC_S_SRCR1_DIE17,
  HERETIC_S_SRCRFX1_1,
  HERETIC_S_SRCRFX1_2,
  HERETIC_S_SRCRFX1_3,
  HERETIC_S_SRCRFXI1_1,
  HERETIC_S_SRCRFXI1_2,
  HERETIC_S_SRCRFXI1_3,
  HERETIC_S_SRCRFXI1_4,
  HERETIC_S_SRCRFXI1_5,
  HERETIC_S_SOR2_RISE1,
  HERETIC_S_SOR2_RISE2,
  HERETIC_S_SOR2_RISE3,
  HERETIC_S_SOR2_RISE4,
  HERETIC_S_SOR2_RISE5,
  HERETIC_S_SOR2_RISE6,
  HERETIC_S_SOR2_RISE7,
  HERETIC_S_SOR2_LOOK1,
  HERETIC_S_SOR2_LOOK2,
  HERETIC_S_SOR2_WALK1,
  HERETIC_S_SOR2_WALK2,
  HERETIC_S_SOR2_WALK3,
  HERETIC_S_SOR2_WALK4,
  HERETIC_S_SOR2_PAIN1,
  HERETIC_S_SOR2_PAIN2,
  HERETIC_S_SOR2_ATK1,
  HERETIC_S_SOR2_ATK2,
  HERETIC_S_SOR2_ATK3,
  HERETIC_S_SOR2_TELE1,
  HERETIC_S_SOR2_TELE2,
  HERETIC_S_SOR2_TELE3,
  HERETIC_S_SOR2_TELE4,
  HERETIC_S_SOR2_TELE5,
  HERETIC_S_SOR2_TELE6,
  HERETIC_S_SOR2_DIE1,
  HERETIC_S_SOR2_DIE2,
  HERETIC_S_SOR2_DIE3,
  HERETIC_S_SOR2_DIE4,
  HERETIC_S_SOR2_DIE5,
  HERETIC_S_SOR2_DIE6,
  HERETIC_S_SOR2_DIE7,
  HERETIC_S_SOR2_DIE8,
  HERETIC_S_SOR2_DIE9,
  HERETIC_S_SOR2_DIE10,
  HERETIC_S_SOR2_DIE11,
  HERETIC_S_SOR2_DIE12,
  HERETIC_S_SOR2_DIE13,
  HERETIC_S_SOR2_DIE14,
  HERETIC_S_SOR2_DIE15,
  HERETIC_S_SOR2FX1_1,
  HERETIC_S_SOR2FX1_2,
  HERETIC_S_SOR2FX1_3,
  HERETIC_S_SOR2FXI1_1,
  HERETIC_S_SOR2FXI1_2,
  HERETIC_S_SOR2FXI1_3,
  HERETIC_S_SOR2FXI1_4,
  HERETIC_S_SOR2FXI1_5,
  HERETIC_S_SOR2FXI1_6,
  HERETIC_S_SOR2FXSPARK1,
  HERETIC_S_SOR2FXSPARK2,
  HERETIC_S_SOR2FXSPARK3,
  HERETIC_S_SOR2FX2_1,
  HERETIC_S_SOR2FX2_2,
  HERETIC_S_SOR2FX2_3,
  HERETIC_S_SOR2FXI2_1,
  HERETIC_S_SOR2FXI2_2,
  HERETIC_S_SOR2FXI2_3,
  HERETIC_S_SOR2FXI2_4,
  HERETIC_S_SOR2FXI2_5,
  HERETIC_S_SOR2TELEFADE1,
  HERETIC_S_SOR2TELEFADE2,
  HERETIC_S_SOR2TELEFADE3,
  HERETIC_S_SOR2TELEFADE4,
  HERETIC_S_SOR2TELEFADE5,
  HERETIC_S_SOR2TELEFADE6,
  HERETIC_S_MNTR_LOOK1,
  HERETIC_S_MNTR_LOOK2,
  HERETIC_S_MNTR_WALK1,
  HERETIC_S_MNTR_WALK2,
  HERETIC_S_MNTR_WALK3,
  HERETIC_S_MNTR_WALK4,
  HERETIC_S_MNTR_ATK1_1,
  HERETIC_S_MNTR_ATK1_2,
  HERETIC_S_MNTR_ATK1_3,
  HERETIC_S_MNTR_ATK2_1,
  HERETIC_S_MNTR_ATK2_2,
  HERETIC_S_MNTR_ATK2_3,
  HERETIC_S_MNTR_ATK3_1,
  HERETIC_S_MNTR_ATK3_2,
  HERETIC_S_MNTR_ATK3_3,
  HERETIC_S_MNTR_ATK3_4,
  HERETIC_S_MNTR_ATK4_1,
  HERETIC_S_MNTR_PAIN1,
  HERETIC_S_MNTR_PAIN2,
  HERETIC_S_MNTR_DIE1,
  HERETIC_S_MNTR_DIE2,
  HERETIC_S_MNTR_DIE3,
  HERETIC_S_MNTR_DIE4,
  HERETIC_S_MNTR_DIE5,
  HERETIC_S_MNTR_DIE6,
  HERETIC_S_MNTR_DIE7,
  HERETIC_S_MNTR_DIE8,
  HERETIC_S_MNTR_DIE9,
  HERETIC_S_MNTR_DIE10,
  HERETIC_S_MNTR_DIE11,
  HERETIC_S_MNTR_DIE12,
  HERETIC_S_MNTR_DIE13,
  HERETIC_S_MNTR_DIE14,
  HERETIC_S_MNTR_DIE15,
  HERETIC_S_MNTRFX1_1,
  HERETIC_S_MNTRFX1_2,
  HERETIC_S_MNTRFXI1_1,
  HERETIC_S_MNTRFXI1_2,
  HERETIC_S_MNTRFXI1_3,
  HERETIC_S_MNTRFXI1_4,
  HERETIC_S_MNTRFXI1_5,
  HERETIC_S_MNTRFXI1_6,
  HERETIC_S_MNTRFX2_1,
  HERETIC_S_MNTRFXI2_1,
  HERETIC_S_MNTRFXI2_2,
  HERETIC_S_MNTRFXI2_3,
  HERETIC_S_MNTRFXI2_4,
  HERETIC_S_MNTRFXI2_5,
  HERETIC_S_MNTRFX3_1,
  HERETIC_S_MNTRFX3_2,
  HERETIC_S_MNTRFX3_3,
  HERETIC_S_MNTRFX3_4,
  HERETIC_S_MNTRFX3_5,
  HERETIC_S_MNTRFX3_6,
  HERETIC_S_MNTRFX3_7,
  HERETIC_S_MNTRFX3_8,
  HERETIC_S_MNTRFX3_9,
  HERETIC_S_AKYY1,
  HERETIC_S_AKYY2,
  HERETIC_S_AKYY3,
  HERETIC_S_AKYY4,
  HERETIC_S_AKYY5,
  HERETIC_S_AKYY6,
  HERETIC_S_AKYY7,
  HERETIC_S_AKYY8,
  HERETIC_S_AKYY9,
  HERETIC_S_AKYY10,
  HERETIC_S_BKYY1,
  HERETIC_S_BKYY2,
  HERETIC_S_BKYY3,
  HERETIC_S_BKYY4,
  HERETIC_S_BKYY5,
  HERETIC_S_BKYY6,
  HERETIC_S_BKYY7,
  HERETIC_S_BKYY8,
  HERETIC_S_BKYY9,
  HERETIC_S_BKYY10,
  HERETIC_S_CKYY1,
  HERETIC_S_CKYY2,
  HERETIC_S_CKYY3,
  HERETIC_S_CKYY4,
  HERETIC_S_CKYY5,
  HERETIC_S_CKYY6,
  HERETIC_S_CKYY7,
  HERETIC_S_CKYY8,
  HERETIC_S_CKYY9,
  HERETIC_S_AMG1,
  HERETIC_S_AMG2_1,
  HERETIC_S_AMG2_2,
  HERETIC_S_AMG2_3,
  HERETIC_S_AMM1,
  HERETIC_S_AMM2,
  HERETIC_S_AMC1,
  HERETIC_S_AMC2_1,
  HERETIC_S_AMC2_2,
  HERETIC_S_AMC2_3,
  HERETIC_S_AMS1_1,
  HERETIC_S_AMS1_2,
  HERETIC_S_AMS2_1,
  HERETIC_S_AMS2_2,
  HERETIC_S_AMP1_1,
  HERETIC_S_AMP1_2,
  HERETIC_S_AMP1_3,
  HERETIC_S_AMP2_1,
  HERETIC_S_AMP2_2,
  HERETIC_S_AMP2_3,
  HERETIC_S_AMB1_1,
  HERETIC_S_AMB1_2,
  HERETIC_S_AMB1_3,
  HERETIC_S_AMB2_1,
  HERETIC_S_AMB2_2,
  HERETIC_S_AMB2_3,
  HERETIC_S_SND_WIND,
  HERETIC_S_SND_WATERFALL,
  HERETIC_NUMSTATES,

  // hexen
  HEXEN_S_NULL = 0,
  HEXEN_S_FREETARGMOBJ,
  HEXEN_S_MAPSPOT,
  HEXEN_S_FIREBALL1_1,
  HEXEN_S_FIREBALL1_2,
  HEXEN_S_FIREBALL1_X1,
  HEXEN_S_FIREBALL1_X2,
  HEXEN_S_FIREBALL1_X3,
  HEXEN_S_FIREBALL1_X4,
  HEXEN_S_FIREBALL1_X5,
  HEXEN_S_FIREBALL1_X6,
  HEXEN_S_ARROW_1,
  HEXEN_S_ARROW_X1,
  HEXEN_S_DART_1,
  HEXEN_S_DART_X1,
  HEXEN_S_POISONDART_1,
  HEXEN_S_POISONDART_X1,
  HEXEN_S_RIPPERBALL_1,
  HEXEN_S_RIPPERBALL_2,
  HEXEN_S_RIPPERBALL_3,
  HEXEN_S_RIPPERBALL_X1,
  HEXEN_S_RIPPERBALL_X2,
  HEXEN_S_RIPPERBALL_X3,
  HEXEN_S_RIPPERBALL_X4,
  HEXEN_S_RIPPERBALL_X5,
  HEXEN_S_RIPPERBALL_X6,
  HEXEN_S_RIPPERBALL_X7,
  HEXEN_S_RIPPERBALL_X8,
  HEXEN_S_RIPPERBALL_X9,
  HEXEN_S_RIPPERBALL_X10,
  HEXEN_S_PRJ_BLADE1,
  HEXEN_S_PRJ_BLADE_X1,
  HEXEN_S_ICESHARD1,
  HEXEN_S_ICESHARD2,
  HEXEN_S_ICESHARD3,
  HEXEN_S_FLAME_TSMALL1,
  HEXEN_S_FLAME_TSMALL2,
  HEXEN_S_FLAME_TSMALL3,
  HEXEN_S_FLAME_TSMALL4,
  HEXEN_S_FLAME_TSMALL5,
  HEXEN_S_FLAME_TSMALL6,
  HEXEN_S_FLAME_TLARGE1,
  HEXEN_S_FLAME_TLARGE2,
  HEXEN_S_FLAME_TLARGE3,
  HEXEN_S_FLAME_TLARGE4,
  HEXEN_S_FLAME_TLARGE5,
  HEXEN_S_FLAME_TLARGE6,
  HEXEN_S_FLAME_TLARGE7,
  HEXEN_S_FLAME_TLARGE8,
  HEXEN_S_FLAME_TLARGE9,
  HEXEN_S_FLAME_TLARGE10,
  HEXEN_S_FLAME_TLARGE11,
  HEXEN_S_FLAME_TLARGE12,
  HEXEN_S_FLAME_TLARGE13,
  HEXEN_S_FLAME_TLARGE14,
  HEXEN_S_FLAME_TLARGE15,
  HEXEN_S_FLAME_TLARGE16,
  HEXEN_S_FLAME_SDORM1,
  HEXEN_S_FLAME_SDORM2,
  HEXEN_S_FLAME_SDORM3,
  HEXEN_S_FLAME_SMALL1,
  HEXEN_S_FLAME_SMALL2,
  HEXEN_S_FLAME_SMALL3,
  HEXEN_S_FLAME_SMALL4,
  HEXEN_S_FLAME_SMALL5,
  HEXEN_S_FLAME_SMALL6,
  HEXEN_S_FLAME_SMALL7,
  HEXEN_S_FLAME_LDORM1,
  HEXEN_S_FLAME_LDORM2,
  HEXEN_S_FLAME_LDORM3,
  HEXEN_S_FLAME_LDORM4,
  HEXEN_S_FLAME_LDORM5,
  HEXEN_S_FLAME_LARGE1,
  HEXEN_S_FLAME_LARGE2,
  HEXEN_S_FLAME_LARGE3,
  HEXEN_S_FLAME_LARGE4,
  HEXEN_S_FLAME_LARGE5,
  HEXEN_S_FLAME_LARGE6,
  HEXEN_S_FLAME_LARGE7,
  HEXEN_S_FLAME_LARGE8,
  HEXEN_S_FLAME_LARGE9,
  HEXEN_S_FLAME_LARGE10,
  HEXEN_S_FLAME_LARGE11,
  HEXEN_S_FLAME_LARGE12,
  HEXEN_S_FLAME_LARGE13,
  HEXEN_S_FLAME_LARGE14,
  HEXEN_S_FLAME_LARGE15,
  HEXEN_S_FLAME_LARGE16,
  HEXEN_S_FLAME_LARGE17,
  HEXEN_S_FLAME_LARGE18,
  HEXEN_S_ITEM_PTN1_1,
  HEXEN_S_ITEM_PTN1_2,
  HEXEN_S_ITEM_PTN1_3,
  HEXEN_S_HIDESPECIAL1,
  HEXEN_S_HIDESPECIAL2,
  HEXEN_S_HIDESPECIAL3,
  HEXEN_S_HIDESPECIAL4,
  HEXEN_S_HIDESPECIAL5,
  HEXEN_S_HIDESPECIAL6,
  HEXEN_S_HIDESPECIAL7,
  HEXEN_S_HIDESPECIAL8,
  HEXEN_S_HIDESPECIAL9,
  HEXEN_S_HIDESPECIAL10,
  HEXEN_S_HIDESPECIAL11,
  HEXEN_S_DORMANTARTI1_1,
  HEXEN_S_DORMANTARTI1_2,
  HEXEN_S_DORMANTARTI1_3,
  HEXEN_S_DORMANTARTI1_4,
  HEXEN_S_DORMANTARTI1_5,
  HEXEN_S_DORMANTARTI1_6,
  HEXEN_S_DORMANTARTI1_7,
  HEXEN_S_DORMANTARTI1_8,
  HEXEN_S_DORMANTARTI1_9,
  HEXEN_S_DORMANTARTI1_10,
  HEXEN_S_DORMANTARTI1_11,
  HEXEN_S_DORMANTARTI1_12,
  HEXEN_S_DORMANTARTI1_13,
  HEXEN_S_DORMANTARTI1_14,
  HEXEN_S_DORMANTARTI1_15,
  HEXEN_S_DORMANTARTI1_16,
  HEXEN_S_DORMANTARTI1_17,
  HEXEN_S_DORMANTARTI1_18,
  HEXEN_S_DORMANTARTI1_19,
  HEXEN_S_DORMANTARTI1_20,
  HEXEN_S_DORMANTARTI1_21,
  HEXEN_S_DORMANTARTI2_1,
  HEXEN_S_DORMANTARTI2_2,
  HEXEN_S_DORMANTARTI2_3,
  HEXEN_S_DORMANTARTI2_4,
  HEXEN_S_DORMANTARTI2_5,
  HEXEN_S_DORMANTARTI2_6,
  HEXEN_S_DORMANTARTI2_7,
  HEXEN_S_DORMANTARTI2_8,
  HEXEN_S_DORMANTARTI2_9,
  HEXEN_S_DORMANTARTI2_10,
  HEXEN_S_DORMANTARTI2_11,
  HEXEN_S_DORMANTARTI2_12,
  HEXEN_S_DORMANTARTI2_13,
  HEXEN_S_DORMANTARTI2_14,
  HEXEN_S_DORMANTARTI2_15,
  HEXEN_S_DORMANTARTI2_16,
  HEXEN_S_DORMANTARTI2_17,
  HEXEN_S_DORMANTARTI2_18,
  HEXEN_S_DORMANTARTI2_19,
  HEXEN_S_DORMANTARTI2_20,
  HEXEN_S_DORMANTARTI2_21,
  HEXEN_S_DORMANTARTI3_1,
  HEXEN_S_DORMANTARTI3_2,
  HEXEN_S_DORMANTARTI3_3,
  HEXEN_S_DORMANTARTI3_4,
  HEXEN_S_DORMANTARTI3_5,
  HEXEN_S_DORMANTARTI3_6,
  HEXEN_S_DORMANTARTI3_7,
  HEXEN_S_DORMANTARTI3_8,
  HEXEN_S_DORMANTARTI3_9,
  HEXEN_S_DORMANTARTI3_10,
  HEXEN_S_DORMANTARTI3_11,
  HEXEN_S_DORMANTARTI3_12,
  HEXEN_S_DORMANTARTI3_13,
  HEXEN_S_DORMANTARTI3_14,
  HEXEN_S_DORMANTARTI3_15,
  HEXEN_S_DORMANTARTI3_16,
  HEXEN_S_DORMANTARTI3_17,
  HEXEN_S_DORMANTARTI3_18,
  HEXEN_S_DORMANTARTI3_19,
  HEXEN_S_DORMANTARTI3_20,
  HEXEN_S_DORMANTARTI3_21,
  HEXEN_S_DEADARTI1,
  HEXEN_S_DEADARTI2,
  HEXEN_S_DEADARTI3,
  HEXEN_S_DEADARTI4,
  HEXEN_S_DEADARTI5,
  HEXEN_S_DEADARTI6,
  HEXEN_S_DEADARTI7,
  HEXEN_S_DEADARTI8,
  HEXEN_S_DEADARTI9,
  HEXEN_S_DEADARTI10,
  HEXEN_S_ARTI_PTN2_1,
  HEXEN_S_ARTI_PTN2_2,
  HEXEN_S_ARTI_PTN2_3,
  HEXEN_S_ARTI_SOAR1,
  HEXEN_S_ARTI_SOAR2,
  HEXEN_S_ARTI_SOAR3,
  HEXEN_S_ARTI_SOAR4,
  HEXEN_S_ARTI_INVU1,
  HEXEN_S_ARTI_INVU2,
  HEXEN_S_ARTI_INVU3,
  HEXEN_S_ARTI_INVU4,
  HEXEN_S_ARTI_SUMMON,
  HEXEN_S_SUMMON_FX1_1,
  HEXEN_S_SUMMON_FX2_1,
  HEXEN_S_SUMMON_FX2_2,
  HEXEN_S_SUMMON_FX2_3,
  HEXEN_S_THRUSTINIT2_1,
  HEXEN_S_THRUSTINIT2_2,
  HEXEN_S_BTHRUSTINIT2_1,
  HEXEN_S_BTHRUSTINIT2_2,
  HEXEN_S_THRUSTINIT1_1,
  HEXEN_S_THRUSTINIT1_2,
  HEXEN_S_BTHRUSTINIT1_1,
  HEXEN_S_BTHRUSTINIT1_2,
  HEXEN_S_THRUSTRAISE1,
  HEXEN_S_THRUSTRAISE2,
  HEXEN_S_THRUSTRAISE3,
  HEXEN_S_THRUSTRAISE4,
  HEXEN_S_BTHRUSTRAISE1,
  HEXEN_S_BTHRUSTRAISE2,
  HEXEN_S_BTHRUSTRAISE3,
  HEXEN_S_BTHRUSTRAISE4,
  HEXEN_S_THRUSTIMPALE,
  HEXEN_S_BTHRUSTIMPALE,
  HEXEN_S_THRUSTRAISE,
  HEXEN_S_BTHRUSTRAISE,
  HEXEN_S_THRUSTBLOCK,
  HEXEN_S_BTHRUSTBLOCK,
  HEXEN_S_THRUSTLOWER,
  HEXEN_S_BTHRUSTLOWER,
  HEXEN_S_THRUSTSTAY,
  HEXEN_S_BTHRUSTSTAY,
  HEXEN_S_ARTI_TELOTHER1,
  HEXEN_S_ARTI_TELOTHER2,
  HEXEN_S_ARTI_TELOTHER3,
  HEXEN_S_ARTI_TELOTHER4,
  HEXEN_S_TELO_FX1,
  HEXEN_S_TELO_FX2,
  HEXEN_S_TELO_FX3,
  HEXEN_S_TELO_FX4,
  HEXEN_S_TELO_FX5,
  HEXEN_S_TELO_FX6,
  HEXEN_S_TELO_FX7,
  HEXEN_S_TELO_FX8,
  HEXEN_S_TELO_FX9,
  HEXEN_S_TELO_FX2_1,
  HEXEN_S_TELO_FX2_2,
  HEXEN_S_TELO_FX2_3,
  HEXEN_S_TELO_FX2_4,
  HEXEN_S_TELO_FX2_5,
  HEXEN_S_TELO_FX2_6,
  HEXEN_S_TELO_FX3_1,
  HEXEN_S_TELO_FX3_2,
  HEXEN_S_TELO_FX3_3,
  HEXEN_S_TELO_FX3_4,
  HEXEN_S_TELO_FX3_5,
  HEXEN_S_TELO_FX3_6,
  HEXEN_S_TELO_FX4_1,
  HEXEN_S_TELO_FX4_2,
  HEXEN_S_TELO_FX4_3,
  HEXEN_S_TELO_FX4_4,
  HEXEN_S_TELO_FX4_5,
  HEXEN_S_TELO_FX4_6,
  HEXEN_S_TELO_FX5_1,
  HEXEN_S_TELO_FX5_2,
  HEXEN_S_TELO_FX5_3,
  HEXEN_S_TELO_FX5_4,
  HEXEN_S_TELO_FX5_5,
  HEXEN_S_TELO_FX5_6,
  HEXEN_S_DIRT1_1,
  HEXEN_S_DIRT1_D,
  HEXEN_S_DIRT2_1,
  HEXEN_S_DIRT2_D,
  HEXEN_S_DIRT3_1,
  HEXEN_S_DIRT3_D,
  HEXEN_S_DIRT4_1,
  HEXEN_S_DIRT4_D,
  HEXEN_S_DIRT5_1,
  HEXEN_S_DIRT5_D,
  HEXEN_S_DIRT6_1,
  HEXEN_S_DIRT6_D,
  HEXEN_S_DIRTCLUMP1,
  HEXEN_S_ROCK1_1,
  HEXEN_S_ROCK1_D,
  HEXEN_S_ROCK2_1,
  HEXEN_S_ROCK2_D,
  HEXEN_S_ROCK3_1,
  HEXEN_S_ROCK3_D,
  HEXEN_S_SPAWNFOG1,
  HEXEN_S_FOGPATCHS1,
  HEXEN_S_FOGPATCHS2,
  HEXEN_S_FOGPATCHS3,
  HEXEN_S_FOGPATCHS4,
  HEXEN_S_FOGPATCHS5,
  HEXEN_S_FOGPATCHS0,
  HEXEN_S_FOGPATCHM1,
  HEXEN_S_FOGPATCHM2,
  HEXEN_S_FOGPATCHM3,
  HEXEN_S_FOGPATCHM4,
  HEXEN_S_FOGPATCHM5,
  HEXEN_S_FOGPATCHM0,
  HEXEN_S_FOGPATCHMA,
  HEXEN_S_FOGPATCHMB,
  HEXEN_S_FOGPATCHMC,
  HEXEN_S_FOGPATCHMD,
  HEXEN_S_FOGPATCHL1,
  HEXEN_S_FOGPATCHL2,
  HEXEN_S_FOGPATCHL3,
  HEXEN_S_FOGPATCHL4,
  HEXEN_S_FOGPATCHL5,
  HEXEN_S_FOGPATCHL0,
  HEXEN_S_FOGPATCHLA,
  HEXEN_S_FOGPATCHLB,
  HEXEN_S_FOGPATCHLC,
  HEXEN_S_FOGPATCHLD,
  HEXEN_S_QUAKE_ACTIVE1,
  HEXEN_S_QUAKE_ACTIVE2,
  HEXEN_S_QUAKE_ACTIVE3,
  HEXEN_S_QUAKE_ACTIVE4,
  HEXEN_S_QUAKE_ACTIVE5,
  HEXEN_S_QUAKE_ACTIVE6,
  HEXEN_S_QUAKE_ACTIVE7,
  HEXEN_S_QUAKE_ACTIVE8,
  HEXEN_S_QUAKE_ACTIVE9,
  HEXEN_S_QUAKE_ACTIVE0,
  HEXEN_S_QUAKE_ACTIVEA,
  HEXEN_S_QUAKE_ACTIVEB,
  HEXEN_S_QUAKE_ACTIVEC,
  HEXEN_S_QUAKE_ACTIVED,
  HEXEN_S_QUAKE_ACTIVEE,
  HEXEN_S_QUAKE_ACTIVEF,
  HEXEN_S_QUAKE_ACTIVEG,
  HEXEN_S_QUAKE_ACTIVEH,
  HEXEN_S_QUAKE_ACTIVEI,
  HEXEN_S_QUAKE_ACTIVEJ,
  HEXEN_S_QUAKE_ACTIVEK,
  HEXEN_S_QUAKE_ACTIVEL,
  HEXEN_S_QUAKE_ACTIVEM,
  HEXEN_S_QUAKE_ACTIVEN,
  HEXEN_S_QUAKE_ACTIVEO,
  HEXEN_S_QUAKE_ACTIVEP,
  HEXEN_S_QUAKE_ACTIVEQ,
  HEXEN_S_QUAKE_ACTIVER,
  HEXEN_S_QUAKE_ACTIVES,
  HEXEN_S_QUAKE_ACTIVET,
  HEXEN_S_QUAKE_ACTIVEU,
  HEXEN_S_QUAKE_ACTIVEV,
  HEXEN_S_QUAKE_ACTIVEW,
  HEXEN_S_QUAKE_ACTIVEX,
  HEXEN_S_QUAKE_ACTIVEY,
  HEXEN_S_QUAKE_ACTIVEZ,
  HEXEN_S_QUAKE_ACT1,
  HEXEN_S_QUAKE_ACT2,
  HEXEN_S_QUAKE_ACT3,
  HEXEN_S_QUAKE_ACT4,
  HEXEN_S_QUAKE_ACT5,
  HEXEN_S_QUAKE_ACT6,
  HEXEN_S_QUAKE_ACT7,
  HEXEN_S_QUAKE_ACT8,
  HEXEN_S_QUAKE_ACT9,
  HEXEN_S_QUAKE_ACT0,
  HEXEN_S_SGSHARD1_1,
  HEXEN_S_SGSHARD1_2,
  HEXEN_S_SGSHARD1_3,
  HEXEN_S_SGSHARD1_4,
  HEXEN_S_SGSHARD1_5,
  HEXEN_S_SGSHARD1_D,
  HEXEN_S_SGSHARD2_1,
  HEXEN_S_SGSHARD2_2,
  HEXEN_S_SGSHARD2_3,
  HEXEN_S_SGSHARD2_4,
  HEXEN_S_SGSHARD2_5,
  HEXEN_S_SGSHARD2_D,
  HEXEN_S_SGSHARD3_1,
  HEXEN_S_SGSHARD3_2,
  HEXEN_S_SGSHARD3_3,
  HEXEN_S_SGSHARD3_4,
  HEXEN_S_SGSHARD3_5,
  HEXEN_S_SGSHARD3_D,
  HEXEN_S_SGSHARD4_1,
  HEXEN_S_SGSHARD4_2,
  HEXEN_S_SGSHARD4_3,
  HEXEN_S_SGSHARD4_4,
  HEXEN_S_SGSHARD4_5,
  HEXEN_S_SGSHARD4_D,
  HEXEN_S_SGSHARD5_1,
  HEXEN_S_SGSHARD5_2,
  HEXEN_S_SGSHARD5_3,
  HEXEN_S_SGSHARD5_4,
  HEXEN_S_SGSHARD5_5,
  HEXEN_S_SGSHARD5_D,
  HEXEN_S_SGSHARD6_1,
  HEXEN_S_SGSHARD6_D,
  HEXEN_S_SGSHARD7_1,
  HEXEN_S_SGSHARD7_D,
  HEXEN_S_SGSHARD8_1,
  HEXEN_S_SGSHARD8_D,
  HEXEN_S_SGSHARD9_1,
  HEXEN_S_SGSHARD9_D,
  HEXEN_S_SGSHARD0_1,
  HEXEN_S_SGSHARD0_D,
  HEXEN_S_ARTI_EGGC1,
  HEXEN_S_ARTI_EGGC2,
  HEXEN_S_ARTI_EGGC3,
  HEXEN_S_ARTI_EGGC4,
  HEXEN_S_ARTI_EGGC5,
  HEXEN_S_ARTI_EGGC6,
  HEXEN_S_ARTI_EGGC7,
  HEXEN_S_ARTI_EGGC8,
  HEXEN_S_EGGFX1,
  HEXEN_S_EGGFX2,
  HEXEN_S_EGGFX3,
  HEXEN_S_EGGFX4,
  HEXEN_S_EGGFX5,
  HEXEN_S_EGGFXI1_1,
  HEXEN_S_EGGFXI1_2,
  HEXEN_S_EGGFXI1_3,
  HEXEN_S_EGGFXI1_4,
  HEXEN_S_ARTI_SPHL1,
  HEXEN_S_ZWINGEDSTATUENOSKULL,
  HEXEN_S_ZWINGEDSTATUENOSKULL2,
  HEXEN_S_ZGEMPEDESTAL1,
  HEXEN_S_ZGEMPEDESTAL2,
  HEXEN_S_ARTIPUZZSKULL,
  HEXEN_S_ARTIPUZZGEMBIG,
  HEXEN_S_ARTIPUZZGEMRED,
  HEXEN_S_ARTIPUZZGEMGREEN1,
  HEXEN_S_ARTIPUZZGEMGREEN2,
  HEXEN_S_ARTIPUZZGEMBLUE1,
  HEXEN_S_ARTIPUZZGEMBLUE2,
  HEXEN_S_ARTIPUZZBOOK1,
  HEXEN_S_ARTIPUZZBOOK2,
  HEXEN_S_ARTIPUZZSKULL2,
  HEXEN_S_ARTIPUZZFWEAPON,
  HEXEN_S_ARTIPUZZCWEAPON,
  HEXEN_S_ARTIPUZZMWEAPON,
  HEXEN_S_ARTIPUZZGEAR_1,
  HEXEN_S_ARTIPUZZGEAR_2,
  HEXEN_S_ARTIPUZZGEAR_3,
  HEXEN_S_ARTIPUZZGEAR_4,
  HEXEN_S_ARTIPUZZGEAR_5,
  HEXEN_S_ARTIPUZZGEAR_6,
  HEXEN_S_ARTIPUZZGEAR_7,
  HEXEN_S_ARTIPUZZGEAR_8,
  HEXEN_S_ARTIPUZZGEAR2_1,
  HEXEN_S_ARTIPUZZGEAR2_2,
  HEXEN_S_ARTIPUZZGEAR2_3,
  HEXEN_S_ARTIPUZZGEAR2_4,
  HEXEN_S_ARTIPUZZGEAR2_5,
  HEXEN_S_ARTIPUZZGEAR2_6,
  HEXEN_S_ARTIPUZZGEAR2_7,
  HEXEN_S_ARTIPUZZGEAR2_8,
  HEXEN_S_ARTIPUZZGEAR3_1,
  HEXEN_S_ARTIPUZZGEAR3_2,
  HEXEN_S_ARTIPUZZGEAR3_3,
  HEXEN_S_ARTIPUZZGEAR3_4,
  HEXEN_S_ARTIPUZZGEAR3_5,
  HEXEN_S_ARTIPUZZGEAR3_6,
  HEXEN_S_ARTIPUZZGEAR3_7,
  HEXEN_S_ARTIPUZZGEAR3_8,
  HEXEN_S_ARTIPUZZGEAR4_1,
  HEXEN_S_ARTIPUZZGEAR4_2,
  HEXEN_S_ARTIPUZZGEAR4_3,
  HEXEN_S_ARTIPUZZGEAR4_4,
  HEXEN_S_ARTIPUZZGEAR4_5,
  HEXEN_S_ARTIPUZZGEAR4_6,
  HEXEN_S_ARTIPUZZGEAR4_7,
  HEXEN_S_ARTIPUZZGEAR4_8,
  HEXEN_S_ARTI_TRCH1,
  HEXEN_S_ARTI_TRCH2,
  HEXEN_S_ARTI_TRCH3,
  HEXEN_S_FIREBOMB1,
  HEXEN_S_FIREBOMB2,
  HEXEN_S_FIREBOMB3,
  HEXEN_S_FIREBOMB4,
  HEXEN_S_FIREBOMB5,
  HEXEN_S_FIREBOMB6,
  HEXEN_S_FIREBOMB7,
  HEXEN_S_FIREBOMB8,
  HEXEN_S_FIREBOMB9,
  HEXEN_S_FIREBOMB10,
  HEXEN_S_FIREBOMB11,
  HEXEN_S_ARTI_ATLP1,
  HEXEN_S_ARTI_ATLP2,
  HEXEN_S_ARTI_ATLP3,
  HEXEN_S_ARTI_ATLP4,
  HEXEN_S_ARTI_PSBG1,
  HEXEN_S_POISONBAG1,
  HEXEN_S_POISONBAG2,
  HEXEN_S_POISONBAG3,
  HEXEN_S_POISONBAG4,
  HEXEN_S_POISONCLOUD1,
  HEXEN_S_POISONCLOUD2,
  HEXEN_S_POISONCLOUD3,
  HEXEN_S_POISONCLOUD4,
  HEXEN_S_POISONCLOUD5,
  HEXEN_S_POISONCLOUD6,
  HEXEN_S_POISONCLOUD7,
  HEXEN_S_POISONCLOUD8,
  HEXEN_S_POISONCLOUD9,
  HEXEN_S_POISONCLOUD10,
  HEXEN_S_POISONCLOUD11,
  HEXEN_S_POISONCLOUD12,
  HEXEN_S_POISONCLOUD13,
  HEXEN_S_POISONCLOUD14,
  HEXEN_S_POISONCLOUD15,
  HEXEN_S_POISONCLOUD16,
  HEXEN_S_POISONCLOUD17,
  HEXEN_S_POISONCLOUD18,
  HEXEN_S_POISONCLOUD_X1,
  HEXEN_S_POISONCLOUD_X2,
  HEXEN_S_POISONCLOUD_X3,
  HEXEN_S_POISONCLOUD_X4,
  HEXEN_S_THROWINGBOMB1,
  HEXEN_S_THROWINGBOMB2,
  HEXEN_S_THROWINGBOMB3,
  HEXEN_S_THROWINGBOMB4,
  HEXEN_S_THROWINGBOMB5,
  HEXEN_S_THROWINGBOMB6,
  HEXEN_S_THROWINGBOMB7,
  HEXEN_S_THROWINGBOMB8,
  HEXEN_S_THROWINGBOMB9,
  HEXEN_S_THROWINGBOMB10,
  HEXEN_S_THROWINGBOMB11,
  HEXEN_S_THROWINGBOMB12,
  HEXEN_S_THROWINGBOMB_X1,
  HEXEN_S_THROWINGBOMB_X2,
  HEXEN_S_THROWINGBOMB_X3,
  HEXEN_S_THROWINGBOMB_X4,
  HEXEN_S_THROWINGBOMB_X5,
  HEXEN_S_THROWINGBOMB_X6,
  HEXEN_S_THROWINGBOMB_X7,
  HEXEN_S_THROWINGBOMB_X8,
  HEXEN_S_ARTI_BOOTS1,
  HEXEN_S_ARTI_BOOTS2,
  HEXEN_S_ARTI_BOOTS3,
  HEXEN_S_ARTI_BOOTS4,
  HEXEN_S_ARTI_BOOTS5,
  HEXEN_S_ARTI_BOOTS6,
  HEXEN_S_ARTI_BOOTS7,
  HEXEN_S_ARTI_BOOTS8,
  HEXEN_S_ARTI_MANA,
  HEXEN_S_ARTI_ARMOR1,
  HEXEN_S_ARTI_ARMOR2,
  HEXEN_S_ARTI_ARMOR3,
  HEXEN_S_ARTI_ARMOR4,
  HEXEN_S_ARTI_ARMOR5,
  HEXEN_S_ARTI_ARMOR6,
  HEXEN_S_ARTI_ARMOR7,
  HEXEN_S_ARTI_ARMOR8,
  HEXEN_S_ARTI_BLAST1,
  HEXEN_S_ARTI_BLAST2,
  HEXEN_S_ARTI_BLAST3,
  HEXEN_S_ARTI_BLAST4,
  HEXEN_S_ARTI_BLAST5,
  HEXEN_S_ARTI_BLAST6,
  HEXEN_S_ARTI_BLAST7,
  HEXEN_S_ARTI_BLAST8,
  HEXEN_S_ARTI_HEALRAD1,
  HEXEN_S_ARTI_HEALRAD2,
  HEXEN_S_ARTI_HEALRAD3,
  HEXEN_S_ARTI_HEALRAD4,
  HEXEN_S_ARTI_HEALRAD5,
  HEXEN_S_ARTI_HEALRAD6,
  HEXEN_S_ARTI_HEALRAD7,
  HEXEN_S_ARTI_HEALRAD8,
  HEXEN_S_ARTI_HEALRAD9,
  HEXEN_S_ARTI_HEALRAD0,
  HEXEN_S_ARTI_HEALRADA,
  HEXEN_S_ARTI_HEALRADB,
  HEXEN_S_ARTI_HEALRADC,
  HEXEN_S_ARTI_HEALRADD,
  HEXEN_S_ARTI_HEALRADE,
  HEXEN_S_ARTI_HEALRADF,
  HEXEN_S_SPLASH1,
  HEXEN_S_SPLASH2,
  HEXEN_S_SPLASH3,
  HEXEN_S_SPLASH4,
  HEXEN_S_SPLASHX,
  HEXEN_S_SPLASHBASE1,
  HEXEN_S_SPLASHBASE2,
  HEXEN_S_SPLASHBASE3,
  HEXEN_S_SPLASHBASE4,
  HEXEN_S_SPLASHBASE5,
  HEXEN_S_SPLASHBASE6,
  HEXEN_S_SPLASHBASE7,
  HEXEN_S_LAVASPLASH1,
  HEXEN_S_LAVASPLASH2,
  HEXEN_S_LAVASPLASH3,
  HEXEN_S_LAVASPLASH4,
  HEXEN_S_LAVASPLASH5,
  HEXEN_S_LAVASPLASH6,
  HEXEN_S_LAVASMOKE1,
  HEXEN_S_LAVASMOKE2,
  HEXEN_S_LAVASMOKE3,
  HEXEN_S_LAVASMOKE4,
  HEXEN_S_LAVASMOKE5,
  HEXEN_S_SLUDGECHUNK1,
  HEXEN_S_SLUDGECHUNK2,
  HEXEN_S_SLUDGECHUNK3,
  HEXEN_S_SLUDGECHUNK4,
  HEXEN_S_SLUDGECHUNKX,
  HEXEN_S_SLUDGESPLASH1,
  HEXEN_S_SLUDGESPLASH2,
  HEXEN_S_SLUDGESPLASH3,
  HEXEN_S_SLUDGESPLASH4,
  HEXEN_S_ZWINGEDSTATUE1,
  HEXEN_S_ZROCK1_1,
  HEXEN_S_ZROCK2_1,
  HEXEN_S_ZROCK3_1,
  HEXEN_S_ZROCK4_1,
  HEXEN_S_ZCHANDELIER1,
  HEXEN_S_ZCHANDELIER2,
  HEXEN_S_ZCHANDELIER3,
  HEXEN_S_ZCHANDELIER_U,
  HEXEN_S_ZTREEDEAD1,
  HEXEN_S_ZTREE,
  HEXEN_S_ZTREEDESTRUCTIBLE1,
  HEXEN_S_ZTREEDES_D1,
  HEXEN_S_ZTREEDES_D2,
  HEXEN_S_ZTREEDES_D3,
  HEXEN_S_ZTREEDES_D4,
  HEXEN_S_ZTREEDES_D5,
  HEXEN_S_ZTREEDES_D6,
  HEXEN_S_ZTREEDES_X1,
  HEXEN_S_ZTREEDES_X2,
  HEXEN_S_ZTREEDES_X3,
  HEXEN_S_ZTREEDES_X4,
  HEXEN_S_ZTREEDES_X5,
  HEXEN_S_ZTREEDES_X6,
  HEXEN_S_ZTREEDES_X7,
  HEXEN_S_ZTREEDES_X8,
  HEXEN_S_ZTREEDES_X9,
  HEXEN_S_ZTREEDES_X10,
  HEXEN_S_ZTREESWAMP182_1,
  HEXEN_S_ZTREESWAMP172_1,
  HEXEN_S_ZSTUMPBURNED1,
  HEXEN_S_ZSTUMPBARE1,
  HEXEN_S_ZSTUMPSWAMP1_1,
  HEXEN_S_ZSTUMPSWAMP2_1,
  HEXEN_S_ZSHROOMLARGE1_1,
  HEXEN_S_ZSHROOMLARGE2_1,
  HEXEN_S_ZSHROOMLARGE3_1,
  HEXEN_S_ZSHROOMSMALL1_1,
  HEXEN_S_ZSHROOMSMALL2_1,
  HEXEN_S_ZSHROOMSMALL3_1,
  HEXEN_S_ZSHROOMSMALL4_1,
  HEXEN_S_ZSHROOMSMALL5_1,
  HEXEN_S_ZSTALAGMITEPILLAR1,
  HEXEN_S_ZSTALAGMITELARGE1,
  HEXEN_S_ZSTALAGMITEMEDIUM1,
  HEXEN_S_ZSTALAGMITESMALL1,
  HEXEN_S_ZSTALACTITELARGE1,
  HEXEN_S_ZSTALACTITEMEDIUM1,
  HEXEN_S_ZSTALACTITESMALL1,
  HEXEN_S_ZMOSSCEILING1_1,
  HEXEN_S_ZMOSSCEILING2_1,
  HEXEN_S_ZSWAMPVINE1,
  HEXEN_S_ZCORPSEKABOB1,
  HEXEN_S_ZCORPSESLEEPING1,
  HEXEN_S_ZTOMBSTONERIP1,
  HEXEN_S_ZTOMBSTONESHANE1,
  HEXEN_S_ZTOMBSTONEBIGCROSS1,
  HEXEN_S_ZTOMBSTONEBRIANR1,
  HEXEN_S_ZTOMBSTONECROSSCIRCLE1,
  HEXEN_S_ZTOMBSTONESMALLCROSS1,
  HEXEN_S_ZTOMBSTONEBRIANP1,
  HEXEN_S_CORPSEHANGING_1,
  HEXEN_S_ZSTATUEGARGOYLEGREENTALL_1,
  HEXEN_S_ZSTATUEGARGOYLEBLUETALL_1,
  HEXEN_S_ZSTATUEGARGOYLEGREENSHORT_1,
  HEXEN_S_ZSTATUEGARGOYLEBLUESHORT_1,
  HEXEN_S_ZSTATUEGARGOYLESTRIPETALL_1,
  HEXEN_S_ZSTATUEGARGOYLEDARKREDTALL_1,
  HEXEN_S_ZSTATUEGARGOYLEREDTALL_1,
  HEXEN_S_ZSTATUEGARGOYLETANTALL_1,
  HEXEN_S_ZSTATUEGARGOYLERUSTTALL_1,
  HEXEN_S_ZSTATUEGARGOYLEDARKREDSHORT_1,
  HEXEN_S_ZSTATUEGARGOYLEREDSHORT_1,
  HEXEN_S_ZSTATUEGARGOYLETANSHORT_1,
  HEXEN_S_ZSTATUEGARGOYLERUSTSHORT_1,
  HEXEN_S_ZBANNERTATTERED_1,
  HEXEN_S_ZTREELARGE1,
  HEXEN_S_ZTREELARGE2,
  HEXEN_S_ZTREEGNARLED1,
  HEXEN_S_ZTREEGNARLED2,
  HEXEN_S_ZLOG,
  HEXEN_S_ZSTALACTITEICELARGE,
  HEXEN_S_ZSTALACTITEICEMEDIUM,
  HEXEN_S_ZSTALACTITEICESMALL,
  HEXEN_S_ZSTALACTITEICETINY,
  HEXEN_S_ZSTALAGMITEICELARGE,
  HEXEN_S_ZSTALAGMITEICEMEDIUM,
  HEXEN_S_ZSTALAGMITEICESMALL,
  HEXEN_S_ZSTALAGMITEICETINY,
  HEXEN_S_ZROCKBROWN1,
  HEXEN_S_ZROCKBROWN2,
  HEXEN_S_ZROCKBLACK,
  HEXEN_S_ZRUBBLE1,
  HEXEN_S_ZRUBBLE2,
  HEXEN_S_ZRUBBLE3,
  HEXEN_S_ZVASEPILLAR,
  HEXEN_S_ZPOTTERY1,
  HEXEN_S_ZPOTTERY2,
  HEXEN_S_ZPOTTERY3,
  HEXEN_S_ZPOTTERY_EXPLODE,
  HEXEN_S_POTTERYBIT_1,
  HEXEN_S_POTTERYBIT_2,
  HEXEN_S_POTTERYBIT_3,
  HEXEN_S_POTTERYBIT_4,
  HEXEN_S_POTTERYBIT_5,
  HEXEN_S_POTTERYBIT_EX0,
  HEXEN_S_POTTERYBIT_EX1,
  HEXEN_S_POTTERYBIT_EX1_2,
  HEXEN_S_POTTERYBIT_EX2,
  HEXEN_S_POTTERYBIT_EX2_2,
  HEXEN_S_POTTERYBIT_EX3,
  HEXEN_S_POTTERYBIT_EX3_2,
  HEXEN_S_POTTERYBIT_EX4,
  HEXEN_S_POTTERYBIT_EX4_2,
  HEXEN_S_POTTERYBIT_EX5,
  HEXEN_S_POTTERYBIT_EX5_2,
  HEXEN_S_ZCORPSELYNCHED1,
  HEXEN_S_ZCORPSELYNCHED2,
  HEXEN_S_ZCORPSESITTING,
  HEXEN_S_ZCORPSESITTING_X,
  HEXEN_S_CORPSEBIT_1,
  HEXEN_S_CORPSEBIT_2,
  HEXEN_S_CORPSEBIT_3,
  HEXEN_S_CORPSEBIT_4,
  HEXEN_S_CORPSEBLOODDRIP,
  HEXEN_S_CORPSEBLOODDRIP_X1,
  HEXEN_S_CORPSEBLOODDRIP_X2,
  HEXEN_S_CORPSEBLOODDRIP_X3,
  HEXEN_S_CORPSEBLOODDRIP_X4,
  HEXEN_S_BLOODPOOL,
  HEXEN_S_ZCANDLE1,
  HEXEN_S_ZCANDLE2,
  HEXEN_S_ZCANDLE3,
  HEXEN_S_ZLEAFSPAWNER,
  HEXEN_S_LEAF1_1,
  HEXEN_S_LEAF1_2,
  HEXEN_S_LEAF1_3,
  HEXEN_S_LEAF1_4,
  HEXEN_S_LEAF1_5,
  HEXEN_S_LEAF1_6,
  HEXEN_S_LEAF1_7,
  HEXEN_S_LEAF1_8,
  HEXEN_S_LEAF1_9,
  HEXEN_S_LEAF1_10,
  HEXEN_S_LEAF1_11,
  HEXEN_S_LEAF1_12,
  HEXEN_S_LEAF1_13,
  HEXEN_S_LEAF1_14,
  HEXEN_S_LEAF1_15,
  HEXEN_S_LEAF1_16,
  HEXEN_S_LEAF1_17,
  HEXEN_S_LEAF1_18,
  HEXEN_S_LEAF_X1,
  HEXEN_S_LEAF2_1,
  HEXEN_S_LEAF2_2,
  HEXEN_S_LEAF2_3,
  HEXEN_S_LEAF2_4,
  HEXEN_S_LEAF2_5,
  HEXEN_S_LEAF2_6,
  HEXEN_S_LEAF2_7,
  HEXEN_S_LEAF2_8,
  HEXEN_S_LEAF2_9,
  HEXEN_S_LEAF2_10,
  HEXEN_S_LEAF2_11,
  HEXEN_S_LEAF2_12,
  HEXEN_S_LEAF2_13,
  HEXEN_S_LEAF2_14,
  HEXEN_S_LEAF2_15,
  HEXEN_S_LEAF2_16,
  HEXEN_S_LEAF2_17,
  HEXEN_S_LEAF2_18,
  HEXEN_S_ZTWINEDTORCH_1,
  HEXEN_S_ZTWINEDTORCH_2,
  HEXEN_S_ZTWINEDTORCH_3,
  HEXEN_S_ZTWINEDTORCH_4,
  HEXEN_S_ZTWINEDTORCH_5,
  HEXEN_S_ZTWINEDTORCH_6,
  HEXEN_S_ZTWINEDTORCH_7,
  HEXEN_S_ZTWINEDTORCH_8,
  HEXEN_S_ZTWINEDTORCH_UNLIT,
  HEXEN_S_BRIDGE1,
  HEXEN_S_BRIDGE2,
  HEXEN_S_BRIDGE3,
  HEXEN_S_FREE_BRIDGE1,
  HEXEN_S_FREE_BRIDGE2,
  HEXEN_S_BBALL1,
  HEXEN_S_BBALL2,
  HEXEN_S_ZWALLTORCH1,
  HEXEN_S_ZWALLTORCH2,
  HEXEN_S_ZWALLTORCH3,
  HEXEN_S_ZWALLTORCH4,
  HEXEN_S_ZWALLTORCH5,
  HEXEN_S_ZWALLTORCH6,
  HEXEN_S_ZWALLTORCH7,
  HEXEN_S_ZWALLTORCH8,
  HEXEN_S_ZWALLTORCH_U,
  HEXEN_S_ZBARREL1,
  HEXEN_S_ZSHRUB1,
  HEXEN_S_ZSHRUB1_DIE,
  HEXEN_S_ZSHRUB1_X1,
  HEXEN_S_ZSHRUB1_X2,
  HEXEN_S_ZSHRUB1_X3,
  HEXEN_S_ZSHRUB2,
  HEXEN_S_ZSHRUB2_DIE,
  HEXEN_S_ZSHRUB2_X1,
  HEXEN_S_ZSHRUB2_X2,
  HEXEN_S_ZSHRUB2_X3,
  HEXEN_S_ZSHRUB2_X4,
  HEXEN_S_ZBUCKET1,
  HEXEN_S_ZPOISONSHROOM1,
  HEXEN_S_ZPOISONSHROOM_P1,
  HEXEN_S_ZPOISONSHROOM_P2,
  HEXEN_S_ZPOISONSHROOM_X1,
  HEXEN_S_ZPOISONSHROOM_X2,
  HEXEN_S_ZPOISONSHROOM_X3,
  HEXEN_S_ZPOISONSHROOM_X4,
  HEXEN_S_ZFIREBULL1,
  HEXEN_S_ZFIREBULL2,
  HEXEN_S_ZFIREBULL3,
  HEXEN_S_ZFIREBULL4,
  HEXEN_S_ZFIREBULL5,
  HEXEN_S_ZFIREBULL6,
  HEXEN_S_ZFIREBULL7,
  HEXEN_S_ZFIREBULL_DEATH,
  HEXEN_S_ZFIREBULL_DEATH2,
  HEXEN_S_ZFIREBULL_U,
  HEXEN_S_ZFIREBULL_BIRTH,
  HEXEN_S_ZFIREBULL_BIRTH2,
  HEXEN_S_ZFIRETHING1,
  HEXEN_S_ZFIRETHING2,
  HEXEN_S_ZFIRETHING3,
  HEXEN_S_ZFIRETHING4,
  HEXEN_S_ZFIRETHING5,
  HEXEN_S_ZFIRETHING6,
  HEXEN_S_ZFIRETHING7,
  HEXEN_S_ZFIRETHING8,
  HEXEN_S_ZFIRETHING9,
  HEXEN_S_ZBRASSTORCH1,
  HEXEN_S_ZBRASSTORCH2,
  HEXEN_S_ZBRASSTORCH3,
  HEXEN_S_ZBRASSTORCH4,
  HEXEN_S_ZBRASSTORCH5,
  HEXEN_S_ZBRASSTORCH6,
  HEXEN_S_ZBRASSTORCH7,
  HEXEN_S_ZBRASSTORCH8,
  HEXEN_S_ZBRASSTORCH9,
  HEXEN_S_ZBRASSTORCH10,
  HEXEN_S_ZBRASSTORCH11,
  HEXEN_S_ZBRASSTORCH12,
  HEXEN_S_ZBRASSTORCH13,
  HEXEN_S_ZSUITOFARMOR,
  HEXEN_S_ZSUITOFARMOR_X1,
  HEXEN_S_ZARMORCHUNK1,
  HEXEN_S_ZARMORCHUNK2,
  HEXEN_S_ZARMORCHUNK3,
  HEXEN_S_ZARMORCHUNK4,
  HEXEN_S_ZARMORCHUNK5,
  HEXEN_S_ZARMORCHUNK6,
  HEXEN_S_ZARMORCHUNK7,
  HEXEN_S_ZARMORCHUNK8,
  HEXEN_S_ZARMORCHUNK9,
  HEXEN_S_ZARMORCHUNK10,
  HEXEN_S_ZBELL,
  HEXEN_S_ZBELL_X1,
  HEXEN_S_ZBELL_X2,
  HEXEN_S_ZBELL_X3,
  HEXEN_S_ZBELL_X4,
  HEXEN_S_ZBELL_X5,
  HEXEN_S_ZBELL_X6,
  HEXEN_S_ZBELL_X7,
  HEXEN_S_ZBELL_X8,
  HEXEN_S_ZBELL_X9,
  HEXEN_S_ZBELL_X10,
  HEXEN_S_ZBELL_X11,
  HEXEN_S_ZBELL_X12,
  HEXEN_S_ZBELL_X13,
  HEXEN_S_ZBELL_X14,
  HEXEN_S_ZBELL_X15,
  HEXEN_S_ZBELL_X16,
  HEXEN_S_ZBELL_X17,
  HEXEN_S_ZBELL_X18,
  HEXEN_S_ZBELL_X19,
  HEXEN_S_ZBELL_X20,
  HEXEN_S_ZBELL_X21,
  HEXEN_S_ZBELL_X22,
  HEXEN_S_ZBELL_X23,
  HEXEN_S_ZBELL_X24,
  HEXEN_S_ZBELL_X25,
  HEXEN_S_ZBELL_X26,
  HEXEN_S_ZBELL_X27,
  HEXEN_S_ZBELL_X28,
  HEXEN_S_ZBELL_X29,
  HEXEN_S_ZBELL_X30,
  HEXEN_S_ZBELL_X31,
  HEXEN_S_ZBELL_X32,
  HEXEN_S_ZBELL_X33,
  HEXEN_S_ZBELL_X34,
  HEXEN_S_ZBELL_X35,
  HEXEN_S_ZBELL_X36,
  HEXEN_S_ZBELL_X37,
  HEXEN_S_ZBELL_X38,
  HEXEN_S_ZBELL_X39,
  HEXEN_S_ZBELL_X40,
  HEXEN_S_ZBELL_X41,
  HEXEN_S_ZBELL_X42,
  HEXEN_S_ZBELL_X43,
  HEXEN_S_ZBELL_X44,
  HEXEN_S_ZBELL_X45,
  HEXEN_S_ZBELL_X46,
  HEXEN_S_ZBELL_X47,
  HEXEN_S_ZBLUE_CANDLE1,
  HEXEN_S_ZBLUE_CANDLE2,
  HEXEN_S_ZBLUE_CANDLE3,
  HEXEN_S_ZBLUE_CANDLE4,
  HEXEN_S_ZBLUE_CANDLE5,
  HEXEN_S_ZIRON_MAIDEN,
  HEXEN_S_ZXMAS_TREE,
  HEXEN_S_ZXMAS_TREE_DIE,
  HEXEN_S_ZXMAS_TREE_X1,
  HEXEN_S_ZXMAS_TREE_X2,
  HEXEN_S_ZXMAS_TREE_X3,
  HEXEN_S_ZXMAS_TREE_X4,
  HEXEN_S_ZXMAS_TREE_X5,
  HEXEN_S_ZXMAS_TREE_X6,
  HEXEN_S_ZXMAS_TREE_X7,
  HEXEN_S_ZXMAS_TREE_X8,
  HEXEN_S_ZXMAS_TREE_X9,
  HEXEN_S_ZXMAS_TREE_X10,
  HEXEN_S_ZCAULDRON1,
  HEXEN_S_ZCAULDRON2,
  HEXEN_S_ZCAULDRON3,
  HEXEN_S_ZCAULDRON4,
  HEXEN_S_ZCAULDRON5,
  HEXEN_S_ZCAULDRON6,
  HEXEN_S_ZCAULDRON7,
  HEXEN_S_ZCAULDRON_U,
  HEXEN_S_ZCHAINBIT32,
  HEXEN_S_ZCHAINBIT64,
  HEXEN_S_ZCHAINEND_HEART,
  HEXEN_S_ZCHAINEND_HOOK1,
  HEXEN_S_ZCHAINEND_HOOK2,
  HEXEN_S_ZCHAINEND_SPIKE,
  HEXEN_S_ZCHAINEND_SKULL,
  HEXEN_S_TABLE_SHIT1,
  HEXEN_S_TABLE_SHIT2,
  HEXEN_S_TABLE_SHIT3,
  HEXEN_S_TABLE_SHIT4,
  HEXEN_S_TABLE_SHIT5,
  HEXEN_S_TABLE_SHIT6,
  HEXEN_S_TABLE_SHIT7,
  HEXEN_S_TABLE_SHIT8,
  HEXEN_S_TABLE_SHIT9,
  HEXEN_S_TABLE_SHIT10,
  HEXEN_S_TFOG1,
  HEXEN_S_TFOG2,
  HEXEN_S_TFOG3,
  HEXEN_S_TFOG4,
  HEXEN_S_TFOG5,
  HEXEN_S_TFOG6,
  HEXEN_S_TFOG7,
  HEXEN_S_TFOG8,
  HEXEN_S_TFOG9,
  HEXEN_S_TFOG10,
  HEXEN_S_TFOG11,
  HEXEN_S_TFOG12,
  HEXEN_S_TFOG13,
  HEXEN_S_TELESMOKE1,
  HEXEN_S_TELESMOKE2,
  HEXEN_S_TELESMOKE3,
  HEXEN_S_TELESMOKE4,
  HEXEN_S_TELESMOKE5,
  HEXEN_S_TELESMOKE6,
  HEXEN_S_TELESMOKE7,
  HEXEN_S_TELESMOKE8,
  HEXEN_S_TELESMOKE9,
  HEXEN_S_TELESMOKE10,
  HEXEN_S_TELESMOKE11,
  HEXEN_S_TELESMOKE12,
  HEXEN_S_TELESMOKE13,
  HEXEN_S_TELESMOKE14,
  HEXEN_S_TELESMOKE15,
  HEXEN_S_TELESMOKE16,
  HEXEN_S_TELESMOKE17,
  HEXEN_S_TELESMOKE18,
  HEXEN_S_TELESMOKE19,
  HEXEN_S_TELESMOKE20,
  HEXEN_S_TELESMOKE21,
  HEXEN_S_TELESMOKE22,
  HEXEN_S_TELESMOKE23,
  HEXEN_S_TELESMOKE24,
  HEXEN_S_TELESMOKE25,
  HEXEN_S_TELESMOKE26,
  HEXEN_S_LIGHTDONE,
  HEXEN_S_PUNCHREADY,
  HEXEN_S_PUNCHDOWN,
  HEXEN_S_PUNCHUP,
  HEXEN_S_PUNCHATK1_1,
  HEXEN_S_PUNCHATK1_2,
  HEXEN_S_PUNCHATK1_3,
  HEXEN_S_PUNCHATK1_4,
  HEXEN_S_PUNCHATK1_5,
  HEXEN_S_PUNCHATK2_1,
  HEXEN_S_PUNCHATK2_2,
  HEXEN_S_PUNCHATK2_3,
  HEXEN_S_PUNCHATK2_4,
  HEXEN_S_PUNCHATK2_5,
  HEXEN_S_PUNCHATK2_6,
  HEXEN_S_PUNCHATK2_7,
  HEXEN_S_PUNCHATK2_8,
  HEXEN_S_PUNCHATK2_9,
  HEXEN_S_PUNCHPUFF1,
  HEXEN_S_PUNCHPUFF2,
  HEXEN_S_PUNCHPUFF3,
  HEXEN_S_PUNCHPUFF4,
  HEXEN_S_PUNCHPUFF5,
  HEXEN_S_AXE,
  HEXEN_S_FAXEREADY,
  HEXEN_S_FAXEDOWN,
  HEXEN_S_FAXEUP,
  HEXEN_S_FAXEATK_1,
  HEXEN_S_FAXEATK_2,
  HEXEN_S_FAXEATK_3,
  HEXEN_S_FAXEATK_4,
  HEXEN_S_FAXEATK_5,
  HEXEN_S_FAXEATK_6,
  HEXEN_S_FAXEATK_7,
  HEXEN_S_FAXEATK_8,
  HEXEN_S_FAXEATK_9,
  HEXEN_S_FAXEATK_10,
  HEXEN_S_FAXEATK_11,
  HEXEN_S_FAXEATK_12,
  HEXEN_S_FAXEATK_13,
  HEXEN_S_FAXEREADY_G,
  HEXEN_S_FAXEREADY_G1,
  HEXEN_S_FAXEREADY_G2,
  HEXEN_S_FAXEREADY_G3,
  HEXEN_S_FAXEREADY_G4,
  HEXEN_S_FAXEREADY_G5,
  HEXEN_S_FAXEDOWN_G,
  HEXEN_S_FAXEUP_G,
  HEXEN_S_FAXEATK_G1,
  HEXEN_S_FAXEATK_G2,
  HEXEN_S_FAXEATK_G3,
  HEXEN_S_FAXEATK_G4,
  HEXEN_S_FAXEATK_G5,
  HEXEN_S_FAXEATK_G6,
  HEXEN_S_FAXEATK_G7,
  HEXEN_S_FAXEATK_G8,
  HEXEN_S_FAXEATK_G9,
  HEXEN_S_FAXEATK_G10,
  HEXEN_S_FAXEATK_G11,
  HEXEN_S_FAXEATK_G12,
  HEXEN_S_FAXEATK_G13,
  HEXEN_S_AXEPUFF_GLOW1,
  HEXEN_S_AXEPUFF_GLOW2,
  HEXEN_S_AXEPUFF_GLOW3,
  HEXEN_S_AXEPUFF_GLOW4,
  HEXEN_S_AXEPUFF_GLOW5,
  HEXEN_S_AXEPUFF_GLOW6,
  HEXEN_S_AXEPUFF_GLOW7,
  HEXEN_S_AXEBLOOD1,
  HEXEN_S_AXEBLOOD2,
  HEXEN_S_AXEBLOOD3,
  HEXEN_S_AXEBLOOD4,
  HEXEN_S_AXEBLOOD5,
  HEXEN_S_AXEBLOOD6,
  HEXEN_S_HAMM,
  HEXEN_S_FHAMMERREADY,
  HEXEN_S_FHAMMERDOWN,
  HEXEN_S_FHAMMERUP,
  HEXEN_S_FHAMMERATK_1,
  HEXEN_S_FHAMMERATK_2,
  HEXEN_S_FHAMMERATK_3,
  HEXEN_S_FHAMMERATK_4,
  HEXEN_S_FHAMMERATK_5,
  HEXEN_S_FHAMMERATK_6,
  HEXEN_S_FHAMMERATK_7,
  HEXEN_S_FHAMMERATK_8,
  HEXEN_S_FHAMMERATK_9,
  HEXEN_S_FHAMMERATK_10,
  HEXEN_S_FHAMMERATK_11,
  HEXEN_S_FHAMMERATK_12,
  HEXEN_S_HAMMER_MISSILE_1,
  HEXEN_S_HAMMER_MISSILE_2,
  HEXEN_S_HAMMER_MISSILE_3,
  HEXEN_S_HAMMER_MISSILE_4,
  HEXEN_S_HAMMER_MISSILE_5,
  HEXEN_S_HAMMER_MISSILE_6,
  HEXEN_S_HAMMER_MISSILE_7,
  HEXEN_S_HAMMER_MISSILE_8,
  HEXEN_S_HAMMER_MISSILE_X1,
  HEXEN_S_HAMMER_MISSILE_X2,
  HEXEN_S_HAMMER_MISSILE_X3,
  HEXEN_S_HAMMER_MISSILE_X4,
  HEXEN_S_HAMMER_MISSILE_X5,
  HEXEN_S_HAMMER_MISSILE_X6,
  HEXEN_S_HAMMER_MISSILE_X7,
  HEXEN_S_HAMMER_MISSILE_X8,
  HEXEN_S_HAMMER_MISSILE_X9,
  HEXEN_S_HAMMER_MISSILE_X10,
  HEXEN_S_HAMMERPUFF1,
  HEXEN_S_HAMMERPUFF2,
  HEXEN_S_HAMMERPUFF3,
  HEXEN_S_HAMMERPUFF4,
  HEXEN_S_HAMMERPUFF5,
  HEXEN_S_FSWORDREADY,
  HEXEN_S_FSWORDREADY1,
  HEXEN_S_FSWORDREADY2,
  HEXEN_S_FSWORDREADY3,
  HEXEN_S_FSWORDREADY4,
  HEXEN_S_FSWORDREADY5,
  HEXEN_S_FSWORDREADY6,
  HEXEN_S_FSWORDREADY7,
  HEXEN_S_FSWORDREADY8,
  HEXEN_S_FSWORDREADY9,
  HEXEN_S_FSWORDREADY10,
  HEXEN_S_FSWORDREADY11,
  HEXEN_S_FSWORDDOWN,
  HEXEN_S_FSWORDUP,
  HEXEN_S_FSWORDATK_1,
  HEXEN_S_FSWORDATK_2,
  HEXEN_S_FSWORDATK_3,
  HEXEN_S_FSWORDATK_4,
  HEXEN_S_FSWORDATK_5,
  HEXEN_S_FSWORDATK_6,
  HEXEN_S_FSWORDATK_7,
  HEXEN_S_FSWORDATK_8,
  HEXEN_S_FSWORDATK_9,
  HEXEN_S_FSWORDATK_10,
  HEXEN_S_FSWORDATK_11,
  HEXEN_S_FSWORDATK_12,
  HEXEN_S_FSWORD_MISSILE1,
  HEXEN_S_FSWORD_MISSILE2,
  HEXEN_S_FSWORD_MISSILE3,
  HEXEN_S_FSWORD_MISSILE_X1,
  HEXEN_S_FSWORD_MISSILE_X2,
  HEXEN_S_FSWORD_MISSILE_X3,
  HEXEN_S_FSWORD_MISSILE_X4,
  HEXEN_S_FSWORD_MISSILE_X5,
  HEXEN_S_FSWORD_MISSILE_X6,
  HEXEN_S_FSWORD_MISSILE_X7,
  HEXEN_S_FSWORD_MISSILE_X8,
  HEXEN_S_FSWORD_MISSILE_X9,
  HEXEN_S_FSWORD_MISSILE_X10,
  HEXEN_S_FSWORD_FLAME1,
  HEXEN_S_FSWORD_FLAME2,
  HEXEN_S_FSWORD_FLAME3,
  HEXEN_S_FSWORD_FLAME4,
  HEXEN_S_FSWORD_FLAME5,
  HEXEN_S_FSWORD_FLAME6,
  HEXEN_S_FSWORD_FLAME7,
  HEXEN_S_FSWORD_FLAME8,
  HEXEN_S_FSWORD_FLAME9,
  HEXEN_S_FSWORD_FLAME10,
  HEXEN_S_CMACEREADY,
  HEXEN_S_CMACEDOWN,
  HEXEN_S_CMACEUP,
  HEXEN_S_CMACEATK_1,
  HEXEN_S_CMACEATK_2,
  HEXEN_S_CMACEATK_3,
  HEXEN_S_CMACEATK_4,
  HEXEN_S_CMACEATK_5,
  HEXEN_S_CMACEATK_6,
  HEXEN_S_CMACEATK_7,
  HEXEN_S_CMACEATK_8,
  HEXEN_S_CMACEATK_9,
  HEXEN_S_CMACEATK_10,
  HEXEN_S_CMACEATK_11,
  HEXEN_S_CMACEATK_12,
  HEXEN_S_CMACEATK_13,
  HEXEN_S_CMACEATK_14,
  HEXEN_S_CMACEATK_15,
  HEXEN_S_CMACEATK_16,
  HEXEN_S_CMACEATK_17,
  HEXEN_S_CSTAFF,
  HEXEN_S_CSTAFFREADY,
  HEXEN_S_CSTAFFREADY1,
  HEXEN_S_CSTAFFREADY2,
  HEXEN_S_CSTAFFREADY3,
  HEXEN_S_CSTAFFREADY4,
  HEXEN_S_CSTAFFREADY5,
  HEXEN_S_CSTAFFREADY6,
  HEXEN_S_CSTAFFREADY7,
  HEXEN_S_CSTAFFREADY8,
  HEXEN_S_CSTAFFREADY9,
  HEXEN_S_CSTAFFBLINK1,
  HEXEN_S_CSTAFFBLINK2,
  HEXEN_S_CSTAFFBLINK3,
  HEXEN_S_CSTAFFBLINK4,
  HEXEN_S_CSTAFFBLINK5,
  HEXEN_S_CSTAFFBLINK6,
  HEXEN_S_CSTAFFBLINK7,
  HEXEN_S_CSTAFFBLINK8,
  HEXEN_S_CSTAFFBLINK9,
  HEXEN_S_CSTAFFBLINK10,
  HEXEN_S_CSTAFFBLINK11,
  HEXEN_S_CSTAFFDOWN,
  HEXEN_S_CSTAFFDOWN2,
  HEXEN_S_CSTAFFDOWN3,
  HEXEN_S_CSTAFFUP,
  HEXEN_S_CSTAFFATK_1,
  HEXEN_S_CSTAFFATK_2,
  HEXEN_S_CSTAFFATK_3,
  HEXEN_S_CSTAFFATK_4,
  HEXEN_S_CSTAFFATK_5,
  HEXEN_S_CSTAFFATK_6,
  HEXEN_S_CSTAFFATK2_1,
  HEXEN_S_CSTAFF_MISSILE1,
  HEXEN_S_CSTAFF_MISSILE2,
  HEXEN_S_CSTAFF_MISSILE3,
  HEXEN_S_CSTAFF_MISSILE4,
  HEXEN_S_CSTAFF_MISSILE_X1,
  HEXEN_S_CSTAFF_MISSILE_X2,
  HEXEN_S_CSTAFF_MISSILE_X3,
  HEXEN_S_CSTAFF_MISSILE_X4,
  HEXEN_S_CSTAFFPUFF1,
  HEXEN_S_CSTAFFPUFF2,
  HEXEN_S_CSTAFFPUFF3,
  HEXEN_S_CSTAFFPUFF4,
  HEXEN_S_CSTAFFPUFF5,
  HEXEN_S_CFLAME1,
  HEXEN_S_CFLAME2,
  HEXEN_S_CFLAME3,
  HEXEN_S_CFLAME4,
  HEXEN_S_CFLAME5,
  HEXEN_S_CFLAME6,
  HEXEN_S_CFLAME7,
  HEXEN_S_CFLAME8,
  HEXEN_S_CFLAMEREADY1,
  HEXEN_S_CFLAMEREADY2,
  HEXEN_S_CFLAMEREADY3,
  HEXEN_S_CFLAMEREADY4,
  HEXEN_S_CFLAMEREADY5,
  HEXEN_S_CFLAMEREADY6,
  HEXEN_S_CFLAMEREADY7,
  HEXEN_S_CFLAMEREADY8,
  HEXEN_S_CFLAMEREADY9,
  HEXEN_S_CFLAMEREADY10,
  HEXEN_S_CFLAMEREADY11,
  HEXEN_S_CFLAMEREADY12,
  HEXEN_S_CFLAMEDOWN,
  HEXEN_S_CFLAMEUP,
  HEXEN_S_CFLAMEATK_1,
  HEXEN_S_CFLAMEATK_2,
  HEXEN_S_CFLAMEATK_3,
  HEXEN_S_CFLAMEATK_4,
  HEXEN_S_CFLAMEATK_5,
  HEXEN_S_CFLAMEATK_6,
  HEXEN_S_CFLAMEATK_7,
  HEXEN_S_CFLAMEATK_8,
  HEXEN_S_CFLAMEFLOOR1,
  HEXEN_S_CFLAMEFLOOR2,
  HEXEN_S_CFLAMEFLOOR3,
  HEXEN_S_FLAMEPUFF1,
  HEXEN_S_FLAMEPUFF2,
  HEXEN_S_FLAMEPUFF3,
  HEXEN_S_FLAMEPUFF4,
  HEXEN_S_FLAMEPUFF5,
  HEXEN_S_FLAMEPUFF6,
  HEXEN_S_FLAMEPUFF7,
  HEXEN_S_FLAMEPUFF8,
  HEXEN_S_FLAMEPUFF9,
  HEXEN_S_FLAMEPUFF10,
  HEXEN_S_FLAMEPUFF11,
  HEXEN_S_FLAMEPUFF12,
  HEXEN_S_FLAMEPUFF13,
  HEXEN_S_FLAMEPUFF2_1,
  HEXEN_S_FLAMEPUFF2_2,
  HEXEN_S_FLAMEPUFF2_3,
  HEXEN_S_FLAMEPUFF2_4,
  HEXEN_S_FLAMEPUFF2_5,
  HEXEN_S_FLAMEPUFF2_6,
  HEXEN_S_FLAMEPUFF2_7,
  HEXEN_S_FLAMEPUFF2_8,
  HEXEN_S_FLAMEPUFF2_9,
  HEXEN_S_FLAMEPUFF2_10,
  HEXEN_S_FLAMEPUFF2_11,
  HEXEN_S_FLAMEPUFF2_12,
  HEXEN_S_FLAMEPUFF2_13,
  HEXEN_S_FLAMEPUFF2_14,
  HEXEN_S_FLAMEPUFF2_15,
  HEXEN_S_FLAMEPUFF2_16,
  HEXEN_S_FLAMEPUFF2_17,
  HEXEN_S_FLAMEPUFF2_18,
  HEXEN_S_FLAMEPUFF2_19,
  HEXEN_S_FLAMEPUFF2_20,
  HEXEN_S_CIRCLE_FLAME1,
  HEXEN_S_CIRCLE_FLAME2,
  HEXEN_S_CIRCLE_FLAME3,
  HEXEN_S_CIRCLE_FLAME4,
  HEXEN_S_CIRCLE_FLAME5,
  HEXEN_S_CIRCLE_FLAME6,
  HEXEN_S_CIRCLE_FLAME7,
  HEXEN_S_CIRCLE_FLAME8,
  HEXEN_S_CIRCLE_FLAME9,
  HEXEN_S_CIRCLE_FLAME10,
  HEXEN_S_CIRCLE_FLAME11,
  HEXEN_S_CIRCLE_FLAME12,
  HEXEN_S_CIRCLE_FLAME13,
  HEXEN_S_CIRCLE_FLAME14,
  HEXEN_S_CIRCLE_FLAME15,
  HEXEN_S_CIRCLE_FLAME16,
  HEXEN_S_CIRCLE_FLAME_X1,
  HEXEN_S_CIRCLE_FLAME_X2,
  HEXEN_S_CIRCLE_FLAME_X3,
  HEXEN_S_CIRCLE_FLAME_X4,
  HEXEN_S_CIRCLE_FLAME_X5,
  HEXEN_S_CIRCLE_FLAME_X6,
  HEXEN_S_CIRCLE_FLAME_X7,
  HEXEN_S_CIRCLE_FLAME_X8,
  HEXEN_S_CIRCLE_FLAME_X9,
  HEXEN_S_CIRCLE_FLAME_X10,
  HEXEN_S_CFLAME_MISSILE1,
  HEXEN_S_CFLAME_MISSILE2,
  HEXEN_S_CFLAME_MISSILE_X,
  HEXEN_S_CHOLYREADY,
  HEXEN_S_CHOLYDOWN,
  HEXEN_S_CHOLYUP,
  HEXEN_S_CHOLYATK_1,
  HEXEN_S_CHOLYATK_2,
  HEXEN_S_CHOLYATK_3,
  HEXEN_S_CHOLYATK_4,
  HEXEN_S_CHOLYATK_5,
  HEXEN_S_CHOLYATK_6,
  HEXEN_S_CHOLYATK_7,
  HEXEN_S_CHOLYATK_8,
  HEXEN_S_CHOLYATK_9,
  HEXEN_S_HOLY_FX1,
  HEXEN_S_HOLY_FX2,
  HEXEN_S_HOLY_FX3,
  HEXEN_S_HOLY_FX4,
  HEXEN_S_HOLY_FX_X1,
  HEXEN_S_HOLY_FX_X2,
  HEXEN_S_HOLY_FX_X3,
  HEXEN_S_HOLY_FX_X4,
  HEXEN_S_HOLY_FX_X5,
  HEXEN_S_HOLY_FX_X6,
  HEXEN_S_HOLY_TAIL1,
  HEXEN_S_HOLY_TAIL2,
  HEXEN_S_HOLY_PUFF1,
  HEXEN_S_HOLY_PUFF2,
  HEXEN_S_HOLY_PUFF3,
  HEXEN_S_HOLY_PUFF4,
  HEXEN_S_HOLY_PUFF5,
  HEXEN_S_HOLY_MISSILE1,
  HEXEN_S_HOLY_MISSILE2,
  HEXEN_S_HOLY_MISSILE3,
  HEXEN_S_HOLY_MISSILE4,
  HEXEN_S_HOLY_MISSILE_X,
  HEXEN_S_HOLY_MISSILE_P1,
  HEXEN_S_HOLY_MISSILE_P2,
  HEXEN_S_HOLY_MISSILE_P3,
  HEXEN_S_HOLY_MISSILE_P4,
  HEXEN_S_HOLY_MISSILE_P5,
  HEXEN_S_MWANDREADY,
  HEXEN_S_MWANDDOWN,
  HEXEN_S_MWANDUP,
  HEXEN_S_MWANDATK_1,
  HEXEN_S_MWANDATK_2,
  HEXEN_S_MWANDATK_3,
  HEXEN_S_MWANDATK_4,
  HEXEN_S_MWANDPUFF1,
  HEXEN_S_MWANDPUFF2,
  HEXEN_S_MWANDPUFF3,
  HEXEN_S_MWANDPUFF4,
  HEXEN_S_MWANDPUFF5,
  HEXEN_S_MWANDSMOKE1,
  HEXEN_S_MWANDSMOKE2,
  HEXEN_S_MWANDSMOKE3,
  HEXEN_S_MWANDSMOKE4,
  HEXEN_S_MWAND_MISSILE1,
  HEXEN_S_MWAND_MISSILE2,
  HEXEN_S_MW_LIGHTNING1,
  HEXEN_S_MW_LIGHTNING2,
  HEXEN_S_MW_LIGHTNING3,
  HEXEN_S_MW_LIGHTNING4,
  HEXEN_S_MW_LIGHTNING5,
  HEXEN_S_MW_LIGHTNING6,
  HEXEN_S_MW_LIGHTNING7,
  HEXEN_S_MW_LIGHTNING8,
  HEXEN_S_MLIGHTNINGREADY,
  HEXEN_S_MLIGHTNINGREADY2,
  HEXEN_S_MLIGHTNINGREADY3,
  HEXEN_S_MLIGHTNINGREADY4,
  HEXEN_S_MLIGHTNINGREADY5,
  HEXEN_S_MLIGHTNINGREADY6,
  HEXEN_S_MLIGHTNINGREADY7,
  HEXEN_S_MLIGHTNINGREADY8,
  HEXEN_S_MLIGHTNINGREADY9,
  HEXEN_S_MLIGHTNINGREADY10,
  HEXEN_S_MLIGHTNINGREADY11,
  HEXEN_S_MLIGHTNINGREADY12,
  HEXEN_S_MLIGHTNINGREADY13,
  HEXEN_S_MLIGHTNINGREADY14,
  HEXEN_S_MLIGHTNINGREADY15,
  HEXEN_S_MLIGHTNINGREADY16,
  HEXEN_S_MLIGHTNINGREADY17,
  HEXEN_S_MLIGHTNINGREADY18,
  HEXEN_S_MLIGHTNINGREADY19,
  HEXEN_S_MLIGHTNINGREADY20,
  HEXEN_S_MLIGHTNINGREADY21,
  HEXEN_S_MLIGHTNINGREADY22,
  HEXEN_S_MLIGHTNINGREADY23,
  HEXEN_S_MLIGHTNINGREADY24,
  HEXEN_S_MLIGHTNINGDOWN,
  HEXEN_S_MLIGHTNINGUP,
  HEXEN_S_MLIGHTNINGATK_1,
  HEXEN_S_MLIGHTNINGATK_2,
  HEXEN_S_MLIGHTNINGATK_3,
  HEXEN_S_MLIGHTNINGATK_4,
  HEXEN_S_MLIGHTNINGATK_5,
  HEXEN_S_MLIGHTNINGATK_6,
  HEXEN_S_MLIGHTNINGATK_7,
  HEXEN_S_MLIGHTNINGATK_8,
  HEXEN_S_MLIGHTNINGATK_9,
  HEXEN_S_MLIGHTNINGATK_10,
  HEXEN_S_MLIGHTNINGATK_11,
  HEXEN_S_LIGHTNING_CEILING1,
  HEXEN_S_LIGHTNING_CEILING2,
  HEXEN_S_LIGHTNING_CEILING3,
  HEXEN_S_LIGHTNING_CEILING4,
  HEXEN_S_LIGHTNING_C_X1,
  HEXEN_S_LIGHTNING_C_X2,
  HEXEN_S_LIGHTNING_C_X3,
  HEXEN_S_LIGHTNING_C_X4,
  HEXEN_S_LIGHTNING_C_X5,
  HEXEN_S_LIGHTNING_C_X6,
  HEXEN_S_LIGHTNING_C_X7,
  HEXEN_S_LIGHTNING_C_X8,
  HEXEN_S_LIGHTNING_C_X9,
  HEXEN_S_LIGHTNING_C_X10,
  HEXEN_S_LIGHTNING_C_X11,
  HEXEN_S_LIGHTNING_C_X12,
  HEXEN_S_LIGHTNING_C_X13,
  HEXEN_S_LIGHTNING_C_X14,
  HEXEN_S_LIGHTNING_C_X15,
  HEXEN_S_LIGHTNING_C_X16,
  HEXEN_S_LIGHTNING_C_X17,
  HEXEN_S_LIGHTNING_C_X18,
  HEXEN_S_LIGHTNING_C_X19,
  HEXEN_S_LIGHTNING_FLOOR1,
  HEXEN_S_LIGHTNING_FLOOR2,
  HEXEN_S_LIGHTNING_FLOOR3,
  HEXEN_S_LIGHTNING_FLOOR4,
  HEXEN_S_LIGHTNING_F_X1,
  HEXEN_S_LIGHTNING_F_X2,
  HEXEN_S_LIGHTNING_F_X3,
  HEXEN_S_LIGHTNING_F_X4,
  HEXEN_S_LIGHTNING_F_X5,
  HEXEN_S_LIGHTNING_F_X6,
  HEXEN_S_LIGHTNING_F_X7,
  HEXEN_S_LIGHTNING_F_X8,
  HEXEN_S_LIGHTNING_F_X9,
  HEXEN_S_LIGHTNING_F_X10,
  HEXEN_S_LIGHTNING_F_X11,
  HEXEN_S_LIGHTNING_F_X12,
  HEXEN_S_LIGHTNING_F_X13,
  HEXEN_S_LIGHTNING_F_X14,
  HEXEN_S_LIGHTNING_F_X15,
  HEXEN_S_LIGHTNING_F_X16,
  HEXEN_S_LIGHTNING_F_X17,
  HEXEN_S_LIGHTNING_F_X18,
  HEXEN_S_LIGHTNING_F_X19,
  HEXEN_S_LIGHTNING_ZAP1,
  HEXEN_S_LIGHTNING_ZAP2,
  HEXEN_S_LIGHTNING_ZAP3,
  HEXEN_S_LIGHTNING_ZAP4,
  HEXEN_S_LIGHTNING_ZAP5,
  HEXEN_S_LIGHTNING_ZAP_X1,
  HEXEN_S_LIGHTNING_ZAP_X2,
  HEXEN_S_LIGHTNING_ZAP_X3,
  HEXEN_S_LIGHTNING_ZAP_X4,
  HEXEN_S_LIGHTNING_ZAP_X5,
  HEXEN_S_LIGHTNING_ZAP_X6,
  HEXEN_S_LIGHTNING_ZAP_X7,
  HEXEN_S_LIGHTNING_ZAP_X8,
  HEXEN_S_MSTAFFREADY,
  HEXEN_S_MSTAFFREADY2,
  HEXEN_S_MSTAFFREADY3,
  HEXEN_S_MSTAFFREADY4,
  HEXEN_S_MSTAFFREADY5,
  HEXEN_S_MSTAFFREADY6,
  HEXEN_S_MSTAFFREADY7,
  HEXEN_S_MSTAFFREADY8,
  HEXEN_S_MSTAFFREADY9,
  HEXEN_S_MSTAFFREADY10,
  HEXEN_S_MSTAFFREADY11,
  HEXEN_S_MSTAFFREADY12,
  HEXEN_S_MSTAFFREADY13,
  HEXEN_S_MSTAFFREADY14,
  HEXEN_S_MSTAFFREADY15,
  HEXEN_S_MSTAFFREADY16,
  HEXEN_S_MSTAFFREADY17,
  HEXEN_S_MSTAFFREADY18,
  HEXEN_S_MSTAFFREADY19,
  HEXEN_S_MSTAFFREADY20,
  HEXEN_S_MSTAFFREADY21,
  HEXEN_S_MSTAFFREADY22,
  HEXEN_S_MSTAFFREADY23,
  HEXEN_S_MSTAFFREADY24,
  HEXEN_S_MSTAFFREADY25,
  HEXEN_S_MSTAFFREADY26,
  HEXEN_S_MSTAFFREADY27,
  HEXEN_S_MSTAFFREADY28,
  HEXEN_S_MSTAFFREADY29,
  HEXEN_S_MSTAFFREADY30,
  HEXEN_S_MSTAFFREADY31,
  HEXEN_S_MSTAFFREADY32,
  HEXEN_S_MSTAFFREADY33,
  HEXEN_S_MSTAFFREADY34,
  HEXEN_S_MSTAFFREADY35,
  HEXEN_S_MSTAFFDOWN,
  HEXEN_S_MSTAFFUP,
  HEXEN_S_MSTAFFATK_1,
  HEXEN_S_MSTAFFATK_2,
  HEXEN_S_MSTAFFATK_3,
  HEXEN_S_MSTAFFATK_4,
  HEXEN_S_MSTAFFATK_5,
  HEXEN_S_MSTAFFATK_6,
  HEXEN_S_MSTAFFATK_7,
  HEXEN_S_MSTAFF_FX1_1,
  HEXEN_S_MSTAFF_FX1_2,
  HEXEN_S_MSTAFF_FX1_3,
  HEXEN_S_MSTAFF_FX1_4,
  HEXEN_S_MSTAFF_FX1_5,
  HEXEN_S_MSTAFF_FX1_6,
  HEXEN_S_MSTAFF_FX_X1,
  HEXEN_S_MSTAFF_FX_X2,
  HEXEN_S_MSTAFF_FX_X3,
  HEXEN_S_MSTAFF_FX_X4,
  HEXEN_S_MSTAFF_FX_X5,
  HEXEN_S_MSTAFF_FX_X6,
  HEXEN_S_MSTAFF_FX_X7,
  HEXEN_S_MSTAFF_FX_X8,
  HEXEN_S_MSTAFF_FX_X9,
  HEXEN_S_MSTAFF_FX_X10,
  HEXEN_S_MSTAFF_FX2_1,
  HEXEN_S_MSTAFF_FX2_2,
  HEXEN_S_MSTAFF_FX2_3,
  HEXEN_S_MSTAFF_FX2_4,
  HEXEN_S_MSTAFF_FX2_X1,
  HEXEN_S_MSTAFF_FX2_X2,
  HEXEN_S_MSTAFF_FX2_X3,
  HEXEN_S_MSTAFF_FX2_X4,
  HEXEN_S_MSTAFF_FX2_X5,
  HEXEN_S_FSWORD1,
  HEXEN_S_FSWORD2,
  HEXEN_S_FSWORD3,
  HEXEN_S_CHOLY1,
  HEXEN_S_CHOLY2,
  HEXEN_S_CHOLY3,
  HEXEN_S_MSTAFF1,
  HEXEN_S_MSTAFF2,
  HEXEN_S_MSTAFF3,
  HEXEN_S_SNOUTREADY,
  HEXEN_S_SNOUTDOWN,
  HEXEN_S_SNOUTUP,
  HEXEN_S_SNOUTATK1,
  HEXEN_S_SNOUTATK2,
  HEXEN_S_COS1,
  HEXEN_S_COS2,
  HEXEN_S_COS3,
  HEXEN_S_CONEREADY,
  HEXEN_S_CONEDOWN,
  HEXEN_S_CONEUP,
  HEXEN_S_CONEATK1_1,
  HEXEN_S_CONEATK1_2,
  HEXEN_S_CONEATK1_3,
  HEXEN_S_CONEATK1_4,
  HEXEN_S_CONEATK1_5,
  HEXEN_S_CONEATK1_6,
  HEXEN_S_CONEATK1_7,
  HEXEN_S_CONEATK1_8,
  HEXEN_S_SHARDFX1_1,
  HEXEN_S_SHARDFX1_2,
  HEXEN_S_SHARDFX1_3,
  HEXEN_S_SHARDFX1_4,
  HEXEN_S_SHARDFXE1_1,
  HEXEN_S_SHARDFXE1_2,
  HEXEN_S_SHARDFXE1_3,
  HEXEN_S_SHARDFXE1_4,
  HEXEN_S_SHARDFXE1_5,
  HEXEN_S_BLOOD1,
  HEXEN_S_BLOOD2,
  HEXEN_S_BLOOD3,
  HEXEN_S_BLOODSPLATTER1,
  HEXEN_S_BLOODSPLATTER2,
  HEXEN_S_BLOODSPLATTER3,
  HEXEN_S_BLOODSPLATTERX,
  HEXEN_S_GIBS1,
  HEXEN_S_FPLAY,
  HEXEN_S_FPLAY_RUN1,
  HEXEN_S_FPLAY_RUN2,
  HEXEN_S_FPLAY_RUN3,
  HEXEN_S_FPLAY_RUN4,
  HEXEN_S_FPLAY_ATK1,
  HEXEN_S_FPLAY_ATK2,
  HEXEN_S_FPLAY_PAIN,
  HEXEN_S_FPLAY_PAIN2,
  HEXEN_S_FPLAY_DIE1,
  HEXEN_S_FPLAY_DIE2,
  HEXEN_S_FPLAY_DIE3,
  HEXEN_S_FPLAY_DIE4,
  HEXEN_S_FPLAY_DIE5,
  HEXEN_S_FPLAY_DIE6,
  HEXEN_S_FPLAY_DIE7,
  HEXEN_S_FPLAY_XDIE1,
  HEXEN_S_FPLAY_XDIE2,
  HEXEN_S_FPLAY_XDIE3,
  HEXEN_S_FPLAY_XDIE4,
  HEXEN_S_FPLAY_XDIE5,
  HEXEN_S_FPLAY_XDIE6,
  HEXEN_S_FPLAY_XDIE7,
  HEXEN_S_FPLAY_XDIE8,
  HEXEN_S_FPLAY_ICE,
  HEXEN_S_FPLAY_ICE2,
  HEXEN_S_PLAY_F_FDTH1,
  HEXEN_S_PLAY_F_FDTH2,
  HEXEN_S_PLAY_C_FDTH1,
  HEXEN_S_PLAY_C_FDTH2,
  HEXEN_S_PLAY_M_FDTH1,
  HEXEN_S_PLAY_M_FDTH2,
  HEXEN_S_PLAY_FDTH3,
  HEXEN_S_PLAY_FDTH4,
  HEXEN_S_PLAY_FDTH5,
  HEXEN_S_PLAY_FDTH6,
  HEXEN_S_PLAY_FDTH7,
  HEXEN_S_PLAY_FDTH8,
  HEXEN_S_PLAY_FDTH9,
  HEXEN_S_PLAY_FDTH10,
  HEXEN_S_PLAY_FDTH11,
  HEXEN_S_PLAY_FDTH12,
  HEXEN_S_PLAY_FDTH13,
  HEXEN_S_PLAY_FDTH14,
  HEXEN_S_PLAY_FDTH15,
  HEXEN_S_PLAY_FDTH16,
  HEXEN_S_PLAY_FDTH17,
  HEXEN_S_PLAY_FDTH18,
  HEXEN_S_PLAY_FDTH19,
  HEXEN_S_PLAY_FDTH20,
  HEXEN_S_BLOODYSKULL1,
  HEXEN_S_BLOODYSKULL2,
  HEXEN_S_BLOODYSKULL3,
  HEXEN_S_BLOODYSKULL4,
  HEXEN_S_BLOODYSKULL5,
  HEXEN_S_BLOODYSKULL6,
  HEXEN_S_BLOODYSKULL7,
  HEXEN_S_BLOODYSKULLX1,
  HEXEN_S_BLOODYSKULLX2,
  HEXEN_S_PLAYER_SPEED1,
  HEXEN_S_PLAYER_SPEED2,
  HEXEN_S_ICECHUNK1,
  HEXEN_S_ICECHUNK2,
  HEXEN_S_ICECHUNK3,
  HEXEN_S_ICECHUNK4,
  HEXEN_S_ICECHUNK_HEAD,
  HEXEN_S_ICECHUNK_HEAD2,
  HEXEN_S_CPLAY,
  HEXEN_S_CPLAY_RUN1,
  HEXEN_S_CPLAY_RUN2,
  HEXEN_S_CPLAY_RUN3,
  HEXEN_S_CPLAY_RUN4,
  HEXEN_S_CPLAY_ATK1,
  HEXEN_S_CPLAY_ATK2,
  HEXEN_S_CPLAY_ATK3,
  HEXEN_S_CPLAY_PAIN,
  HEXEN_S_CPLAY_PAIN2,
  HEXEN_S_CPLAY_DIE1,
  HEXEN_S_CPLAY_DIE2,
  HEXEN_S_CPLAY_DIE3,
  HEXEN_S_CPLAY_DIE4,
  HEXEN_S_CPLAY_DIE5,
  HEXEN_S_CPLAY_DIE6,
  HEXEN_S_CPLAY_DIE7,
  HEXEN_S_CPLAY_DIE8,
  HEXEN_S_CPLAY_DIE9,
  HEXEN_S_CPLAY_XDIE1,
  HEXEN_S_CPLAY_XDIE2,
  HEXEN_S_CPLAY_XDIE3,
  HEXEN_S_CPLAY_XDIE4,
  HEXEN_S_CPLAY_XDIE5,
  HEXEN_S_CPLAY_XDIE6,
  HEXEN_S_CPLAY_XDIE7,
  HEXEN_S_CPLAY_XDIE8,
  HEXEN_S_CPLAY_XDIE9,
  HEXEN_S_CPLAY_XDIE10,
  HEXEN_S_CPLAY_ICE,
  HEXEN_S_CPLAY_ICE2,
  HEXEN_S_MPLAY,
  HEXEN_S_MPLAY_RUN1,
  HEXEN_S_MPLAY_RUN2,
  HEXEN_S_MPLAY_RUN3,
  HEXEN_S_MPLAY_RUN4,
  HEXEN_S_MPLAY_ATK1,
  HEXEN_S_MPLAY_ATK2,
  HEXEN_S_MPLAY_PAIN,
  HEXEN_S_MPLAY_PAIN2,
  HEXEN_S_MPLAY_DIE1,
  HEXEN_S_MPLAY_DIE2,
  HEXEN_S_MPLAY_DIE3,
  HEXEN_S_MPLAY_DIE4,
  HEXEN_S_MPLAY_DIE5,
  HEXEN_S_MPLAY_DIE6,
  HEXEN_S_MPLAY_DIE7,
  HEXEN_S_MPLAY_XDIE1,
  HEXEN_S_MPLAY_XDIE2,
  HEXEN_S_MPLAY_XDIE3,
  HEXEN_S_MPLAY_XDIE4,
  HEXEN_S_MPLAY_XDIE5,
  HEXEN_S_MPLAY_XDIE6,
  HEXEN_S_MPLAY_XDIE7,
  HEXEN_S_MPLAY_XDIE8,
  HEXEN_S_MPLAY_XDIE9,
  HEXEN_S_MPLAY_ICE,
  HEXEN_S_MPLAY_ICE2,
  HEXEN_S_PIGPLAY,
  HEXEN_S_PIGPLAY_RUN1,
  HEXEN_S_PIGPLAY_RUN2,
  HEXEN_S_PIGPLAY_RUN3,
  HEXEN_S_PIGPLAY_RUN4,
  HEXEN_S_PIGPLAY_ATK1,
  HEXEN_S_PIGPLAY_PAIN,
  HEXEN_S_PIG_LOOK1,
  HEXEN_S_PIG_WALK1,
  HEXEN_S_PIG_WALK2,
  HEXEN_S_PIG_WALK3,
  HEXEN_S_PIG_WALK4,
  HEXEN_S_PIG_PAIN,
  HEXEN_S_PIG_ATK1,
  HEXEN_S_PIG_ATK2,
  HEXEN_S_PIG_DIE1,
  HEXEN_S_PIG_DIE2,
  HEXEN_S_PIG_DIE3,
  HEXEN_S_PIG_DIE4,
  HEXEN_S_PIG_DIE5,
  HEXEN_S_PIG_DIE6,
  HEXEN_S_PIG_DIE7,
  HEXEN_S_PIG_DIE8,
  HEXEN_S_PIG_ICE,
  HEXEN_S_PIG_ICE2,
  HEXEN_S_CENTAUR_LOOK1,
  HEXEN_S_CENTAUR_LOOK2,
  HEXEN_S_CENTAUR_WALK1,
  HEXEN_S_CENTAUR_WALK2,
  HEXEN_S_CENTAUR_WALK3,
  HEXEN_S_CENTAUR_WALK4,
  HEXEN_S_CENTAUR_ATK1,
  HEXEN_S_CENTAUR_ATK2,
  HEXEN_S_CENTAUR_ATK3,
  HEXEN_S_CENTAUR_MISSILE1,
  HEXEN_S_CENTAUR_MISSILE2,
  HEXEN_S_CENTAUR_MISSILE3,
  HEXEN_S_CENTAUR_MISSILE4,
  HEXEN_S_CENTAUR_PAIN1,
  HEXEN_S_CENTAUR_PAIN2,
  HEXEN_S_CENTAUR_PAIN3,
  HEXEN_S_CENTAUR_PAIN4,
  HEXEN_S_CENTAUR_PAIN5,
  HEXEN_S_CENTAUR_PAIN6,
  HEXEN_S_CENTAUR_DEATH1,
  HEXEN_S_CENTAUR_DEATH2,
  HEXEN_S_CENTAUR_DEATH3,
  HEXEN_S_CENTAUR_DEATH4,
  HEXEN_S_CENTAUR_DEATH5,
  HEXEN_S_CENTAUR_DEATH6,
  HEXEN_S_CENTAUR_DEATH7,
  HEXEN_S_CENTAUR_DEATH8,
  HEXEN_S_CENTAUR_DEATH9,
  HEXEN_S_CENTAUR_DEATH0,
  HEXEN_S_CENTAUR_DEATH_X1,
  HEXEN_S_CENTAUR_DEATH_X2,
  HEXEN_S_CENTAUR_DEATH_X3,
  HEXEN_S_CENTAUR_DEATH_X4,
  HEXEN_S_CENTAUR_DEATH_X5,
  HEXEN_S_CENTAUR_DEATH_X6,
  HEXEN_S_CENTAUR_DEATH_X7,
  HEXEN_S_CENTAUR_DEATH_X8,
  HEXEN_S_CENTAUR_DEATH_X9,
  HEXEN_S_CENTAUR_DEATH_X10,
  HEXEN_S_CENTAUR_DEATH_X11,
  HEXEN_S_CENTAUR_ICE,
  HEXEN_S_CENTAUR_ICE2,
  HEXEN_S_CENTAUR_FX1,
  HEXEN_S_CENTAUR_FX_X1,
  HEXEN_S_CENTAUR_FX_X2,
  HEXEN_S_CENTAUR_FX_X3,
  HEXEN_S_CENTAUR_FX_X4,
  HEXEN_S_CENTAUR_FX_X5,
  HEXEN_S_CENTAUR_SHIELD1,
  HEXEN_S_CENTAUR_SHIELD2,
  HEXEN_S_CENTAUR_SHIELD3,
  HEXEN_S_CENTAUR_SHIELD4,
  HEXEN_S_CENTAUR_SHIELD5,
  HEXEN_S_CENTAUR_SHIELD6,
  HEXEN_S_CENTAUR_SHIELD_X1,
  HEXEN_S_CENTAUR_SHIELD_X2,
  HEXEN_S_CENTAUR_SHIELD_X3,
  HEXEN_S_CENTAUR_SHIELD_X4,
  HEXEN_S_CENTAUR_SWORD1,
  HEXEN_S_CENTAUR_SWORD2,
  HEXEN_S_CENTAUR_SWORD3,
  HEXEN_S_CENTAUR_SWORD4,
  HEXEN_S_CENTAUR_SWORD5,
  HEXEN_S_CENTAUR_SWORD6,
  HEXEN_S_CENTAUR_SWORD7,
  HEXEN_S_CENTAUR_SWORD_X1,
  HEXEN_S_CENTAUR_SWORD_X2,
  HEXEN_S_CENTAUR_SWORD_X3,
  HEXEN_S_DEMN_LOOK1,
  HEXEN_S_DEMN_LOOK2,
  HEXEN_S_DEMN_CHASE1,
  HEXEN_S_DEMN_CHASE2,
  HEXEN_S_DEMN_CHASE3,
  HEXEN_S_DEMN_CHASE4,
  HEXEN_S_DEMN_ATK1_1,
  HEXEN_S_DEMN_ATK1_2,
  HEXEN_S_DEMN_ATK1_3,
  HEXEN_S_DEMN_ATK2_1,
  HEXEN_S_DEMN_ATK2_2,
  HEXEN_S_DEMN_ATK2_3,
  HEXEN_S_DEMN_PAIN1,
  HEXEN_S_DEMN_PAIN2,
  HEXEN_S_DEMN_DEATH1,
  HEXEN_S_DEMN_DEATH2,
  HEXEN_S_DEMN_DEATH3,
  HEXEN_S_DEMN_DEATH4,
  HEXEN_S_DEMN_DEATH5,
  HEXEN_S_DEMN_DEATH6,
  HEXEN_S_DEMN_DEATH7,
  HEXEN_S_DEMN_DEATH8,
  HEXEN_S_DEMN_DEATH9,
  HEXEN_S_DEMN_XDEATH1,
  HEXEN_S_DEMN_XDEATH2,
  HEXEN_S_DEMN_XDEATH3,
  HEXEN_S_DEMN_XDEATH4,
  HEXEN_S_DEMN_XDEATH5,
  HEXEN_S_DEMN_XDEATH6,
  HEXEN_S_DEMN_XDEATH7,
  HEXEN_S_DEMN_XDEATH8,
  HEXEN_S_DEMN_XDEATH9,
  HEXEN_S_DEMON_ICE,
  HEXEN_S_DEMON_ICE2,
  HEXEN_S_DEMONCHUNK1_1,
  HEXEN_S_DEMONCHUNK1_2,
  HEXEN_S_DEMONCHUNK1_3,
  HEXEN_S_DEMONCHUNK1_4,
  HEXEN_S_DEMONCHUNK2_1,
  HEXEN_S_DEMONCHUNK2_2,
  HEXEN_S_DEMONCHUNK2_3,
  HEXEN_S_DEMONCHUNK2_4,
  HEXEN_S_DEMONCHUNK3_1,
  HEXEN_S_DEMONCHUNK3_2,
  HEXEN_S_DEMONCHUNK3_3,
  HEXEN_S_DEMONCHUNK3_4,
  HEXEN_S_DEMONCHUNK4_1,
  HEXEN_S_DEMONCHUNK4_2,
  HEXEN_S_DEMONCHUNK4_3,
  HEXEN_S_DEMONCHUNK4_4,
  HEXEN_S_DEMONCHUNK5_1,
  HEXEN_S_DEMONCHUNK5_2,
  HEXEN_S_DEMONCHUNK5_3,
  HEXEN_S_DEMONCHUNK5_4,
  HEXEN_S_DEMONFX_MOVE1,
  HEXEN_S_DEMONFX_MOVE2,
  HEXEN_S_DEMONFX_MOVE3,
  HEXEN_S_DEMONFX_BOOM1,
  HEXEN_S_DEMONFX_BOOM2,
  HEXEN_S_DEMONFX_BOOM3,
  HEXEN_S_DEMONFX_BOOM4,
  HEXEN_S_DEMONFX_BOOM5,
  HEXEN_S_DEMN2_LOOK1,
  HEXEN_S_DEMN2_LOOK2,
  HEXEN_S_DEMN2_CHASE1,
  HEXEN_S_DEMN2_CHASE2,
  HEXEN_S_DEMN2_CHASE3,
  HEXEN_S_DEMN2_CHASE4,
  HEXEN_S_DEMN2_ATK1_1,
  HEXEN_S_DEMN2_ATK1_2,
  HEXEN_S_DEMN2_ATK1_3,
  HEXEN_S_DEMN2_ATK2_1,
  HEXEN_S_DEMN2_ATK2_2,
  HEXEN_S_DEMN2_ATK2_3,
  HEXEN_S_DEMN2_PAIN1,
  HEXEN_S_DEMN2_PAIN2,
  HEXEN_S_DEMN2_DEATH1,
  HEXEN_S_DEMN2_DEATH2,
  HEXEN_S_DEMN2_DEATH3,
  HEXEN_S_DEMN2_DEATH4,
  HEXEN_S_DEMN2_DEATH5,
  HEXEN_S_DEMN2_DEATH6,
  HEXEN_S_DEMN2_DEATH7,
  HEXEN_S_DEMN2_DEATH8,
  HEXEN_S_DEMN2_DEATH9,
  HEXEN_S_DEMN2_XDEATH1,
  HEXEN_S_DEMN2_XDEATH2,
  HEXEN_S_DEMN2_XDEATH3,
  HEXEN_S_DEMN2_XDEATH4,
  HEXEN_S_DEMN2_XDEATH5,
  HEXEN_S_DEMN2_XDEATH6,
  HEXEN_S_DEMN2_XDEATH7,
  HEXEN_S_DEMN2_XDEATH8,
  HEXEN_S_DEMN2_XDEATH9,
  HEXEN_S_DEMON2CHUNK1_1,
  HEXEN_S_DEMON2CHUNK1_2,
  HEXEN_S_DEMON2CHUNK1_3,
  HEXEN_S_DEMON2CHUNK1_4,
  HEXEN_S_DEMON2CHUNK2_1,
  HEXEN_S_DEMON2CHUNK2_2,
  HEXEN_S_DEMON2CHUNK2_3,
  HEXEN_S_DEMON2CHUNK2_4,
  HEXEN_S_DEMON2CHUNK3_1,
  HEXEN_S_DEMON2CHUNK3_2,
  HEXEN_S_DEMON2CHUNK3_3,
  HEXEN_S_DEMON2CHUNK3_4,
  HEXEN_S_DEMON2CHUNK4_1,
  HEXEN_S_DEMON2CHUNK4_2,
  HEXEN_S_DEMON2CHUNK4_3,
  HEXEN_S_DEMON2CHUNK4_4,
  HEXEN_S_DEMON2CHUNK5_1,
  HEXEN_S_DEMON2CHUNK5_2,
  HEXEN_S_DEMON2CHUNK5_3,
  HEXEN_S_DEMON2CHUNK5_4,
  HEXEN_S_DEMON2FX_MOVE1,
  HEXEN_S_DEMON2FX_MOVE2,
  HEXEN_S_DEMON2FX_MOVE3,
  HEXEN_S_DEMON2FX_MOVE4,
  HEXEN_S_DEMON2FX_MOVE5,
  HEXEN_S_DEMON2FX_MOVE6,
  HEXEN_S_DEMON2FX_BOOM1,
  HEXEN_S_DEMON2FX_BOOM2,
  HEXEN_S_DEMON2FX_BOOM3,
  HEXEN_S_DEMON2FX_BOOM4,
  HEXEN_S_DEMON2FX_BOOM5,
  HEXEN_S_DEMON2FX_BOOM6,
  HEXEN_S_WRAITH_RAISE1,
  HEXEN_S_WRAITH_RAISE2,
  HEXEN_S_WRAITH_RAISE3,
  HEXEN_S_WRAITH_RAISE4,
  HEXEN_S_WRAITH_RAISE5,
  HEXEN_S_WRAITH_INIT1,
  HEXEN_S_WRAITH_INIT2,
  HEXEN_S_WRAITH_LOOK1,
  HEXEN_S_WRAITH_LOOK2,
  HEXEN_S_WRAITH_CHASE1,
  HEXEN_S_WRAITH_CHASE2,
  HEXEN_S_WRAITH_CHASE3,
  HEXEN_S_WRAITH_CHASE4,
  HEXEN_S_WRAITH_ATK1_1,
  HEXEN_S_WRAITH_ATK1_2,
  HEXEN_S_WRAITH_ATK1_3,
  HEXEN_S_WRAITH_ATK2_1,
  HEXEN_S_WRAITH_ATK2_2,
  HEXEN_S_WRAITH_ATK2_3,
  HEXEN_S_WRAITH_PAIN1,
  HEXEN_S_WRAITH_PAIN2,
  HEXEN_S_WRAITH_DEATH1_1,
  HEXEN_S_WRAITH_DEATH1_2,
  HEXEN_S_WRAITH_DEATH1_3,
  HEXEN_S_WRAITH_DEATH1_4,
  HEXEN_S_WRAITH_DEATH1_5,
  HEXEN_S_WRAITH_DEATH1_6,
  HEXEN_S_WRAITH_DEATH1_7,
  HEXEN_S_WRAITH_DEATH1_8,
  HEXEN_S_WRAITH_DEATH1_9,
  HEXEN_S_WRAITH_DEATH1_0,
  HEXEN_S_WRAITH_DEATH2_1,
  HEXEN_S_WRAITH_DEATH2_2,
  HEXEN_S_WRAITH_DEATH2_3,
  HEXEN_S_WRAITH_DEATH2_4,
  HEXEN_S_WRAITH_DEATH2_5,
  HEXEN_S_WRAITH_DEATH2_6,
  HEXEN_S_WRAITH_DEATH2_7,
  HEXEN_S_WRAITH_DEATH2_8,
  HEXEN_S_WRAITH_ICE,
  HEXEN_S_WRAITH_ICE2,
  HEXEN_S_WRTHFX_MOVE1,
  HEXEN_S_WRTHFX_MOVE2,
  HEXEN_S_WRTHFX_MOVE3,
  HEXEN_S_WRTHFX_BOOM1,
  HEXEN_S_WRTHFX_BOOM2,
  HEXEN_S_WRTHFX_BOOM3,
  HEXEN_S_WRTHFX_BOOM4,
  HEXEN_S_WRTHFX_BOOM5,
  HEXEN_S_WRTHFX_BOOM6,
  HEXEN_S_WRTHFX_SIZZLE1,
  HEXEN_S_WRTHFX_SIZZLE2,
  HEXEN_S_WRTHFX_SIZZLE3,
  HEXEN_S_WRTHFX_SIZZLE4,
  HEXEN_S_WRTHFX_SIZZLE5,
  HEXEN_S_WRTHFX_SIZZLE6,
  HEXEN_S_WRTHFX_SIZZLE7,
  HEXEN_S_WRTHFX_DROP1,
  HEXEN_S_WRTHFX_DROP2,
  HEXEN_S_WRTHFX_DROP3,
  HEXEN_S_WRTHFX_DEAD1,
  HEXEN_S_WRTHFX_ADROP1,
  HEXEN_S_WRTHFX_ADROP2,
  HEXEN_S_WRTHFX_ADROP3,
  HEXEN_S_WRTHFX_ADROP4,
  HEXEN_S_WRTHFX_ADEAD1,
  HEXEN_S_WRTHFX_BDROP1,
  HEXEN_S_WRTHFX_BDROP2,
  HEXEN_S_WRTHFX_BDROP3,
  HEXEN_S_WRTHFX_BDEAD1,
  HEXEN_S_MNTR_SPAWN1,
  HEXEN_S_MNTR_SPAWN2,
  HEXEN_S_MNTR_SPAWN3,
  HEXEN_S_MNTR_LOOK1,
  HEXEN_S_MNTR_LOOK2,
  HEXEN_S_MNTR_WALK1,
  HEXEN_S_MNTR_WALK2,
  HEXEN_S_MNTR_WALK3,
  HEXEN_S_MNTR_WALK4,
  HEXEN_S_MNTR_ROAM1,
  HEXEN_S_MNTR_ROAM2,
  HEXEN_S_MNTR_ROAM3,
  HEXEN_S_MNTR_ROAM4,
  HEXEN_S_MNTR_ATK1_1,
  HEXEN_S_MNTR_ATK1_2,
  HEXEN_S_MNTR_ATK1_3,
  HEXEN_S_MNTR_ATK2_1,
  HEXEN_S_MNTR_ATK2_2,
  HEXEN_S_MNTR_ATK2_3,
  HEXEN_S_MNTR_ATK3_1,
  HEXEN_S_MNTR_ATK3_2,
  HEXEN_S_MNTR_ATK3_3,
  HEXEN_S_MNTR_ATK3_4,
  HEXEN_S_MNTR_ATK4_1,
  HEXEN_S_MNTR_PAIN1,
  HEXEN_S_MNTR_PAIN2,
  HEXEN_S_MNTR_DIE1,
  HEXEN_S_MNTR_DIE2,
  HEXEN_S_MNTR_DIE3,
  HEXEN_S_MNTR_DIE4,
  HEXEN_S_MNTR_DIE5,
  HEXEN_S_MNTR_DIE6,
  HEXEN_S_MNTR_DIE7,
  HEXEN_S_MNTR_DIE8,
  HEXEN_S_MNTR_DIE9,
  HEXEN_S_MNTRFX1_1,
  HEXEN_S_MNTRFX1_2,
  HEXEN_S_MNTRFXI1_1,
  HEXEN_S_MNTRFXI1_2,
  HEXEN_S_MNTRFXI1_3,
  HEXEN_S_MNTRFXI1_4,
  HEXEN_S_MNTRFXI1_5,
  HEXEN_S_MNTRFXI1_6,
  HEXEN_S_MNTRFX2_1,
  HEXEN_S_MNTRFXI2_1,
  HEXEN_S_MNTRFXI2_2,
  HEXEN_S_MNTRFXI2_3,
  HEXEN_S_MNTRFXI2_4,
  HEXEN_S_MNTRFXI2_5,
  HEXEN_S_MNTRFX3_1,
  HEXEN_S_MNTRFX3_2,
  HEXEN_S_MNTRFX3_3,
  HEXEN_S_MNTRFX3_4,
  HEXEN_S_MNTRFX3_5,
  HEXEN_S_MNTRFX3_6,
  HEXEN_S_MNTRFX3_7,
  HEXEN_S_MNTRFX3_8,
  HEXEN_S_MNTRFX3_9,
  HEXEN_S_MINOSMOKE1,
  HEXEN_S_MINOSMOKE2,
  HEXEN_S_MINOSMOKE3,
  HEXEN_S_MINOSMOKE4,
  HEXEN_S_MINOSMOKE5,
  HEXEN_S_MINOSMOKE6,
  HEXEN_S_MINOSMOKE7,
  HEXEN_S_MINOSMOKE8,
  HEXEN_S_MINOSMOKE9,
  HEXEN_S_MINOSMOKE0,
  HEXEN_S_MINOSMOKEA,
  HEXEN_S_MINOSMOKEB,
  HEXEN_S_MINOSMOKEC,
  HEXEN_S_MINOSMOKED,
  HEXEN_S_MINOSMOKEE,
  HEXEN_S_MINOSMOKEF,
  HEXEN_S_MINOSMOKEG,
  HEXEN_S_MINOSMOKEX1,
  HEXEN_S_MINOSMOKEX2,
  HEXEN_S_MINOSMOKEX3,
  HEXEN_S_MINOSMOKEX4,
  HEXEN_S_MINOSMOKEX5,
  HEXEN_S_MINOSMOKEX6,
  HEXEN_S_MINOSMOKEX7,
  HEXEN_S_MINOSMOKEX8,
  HEXEN_S_MINOSMOKEX9,
  HEXEN_S_MINOSMOKEX0,
  HEXEN_S_MINOSMOKEXA,
  HEXEN_S_MINOSMOKEXB,
  HEXEN_S_MINOSMOKEXC,
  HEXEN_S_MINOSMOKEXD,
  HEXEN_S_MINOSMOKEXE,
  HEXEN_S_MINOSMOKEXF,
  HEXEN_S_MINOSMOKEXG,
  HEXEN_S_MINOSMOKEXH,
  HEXEN_S_MINOSMOKEXI,
  HEXEN_S_SERPENT_LOOK1,
  HEXEN_S_SERPENT_SWIM1,
  HEXEN_S_SERPENT_SWIM2,
  HEXEN_S_SERPENT_SWIM3,
  HEXEN_S_SERPENT_HUMP1,
  HEXEN_S_SERPENT_HUMP2,
  HEXEN_S_SERPENT_HUMP3,
  HEXEN_S_SERPENT_HUMP4,
  HEXEN_S_SERPENT_HUMP5,
  HEXEN_S_SERPENT_HUMP6,
  HEXEN_S_SERPENT_HUMP7,
  HEXEN_S_SERPENT_HUMP8,
  HEXEN_S_SERPENT_HUMP9,
  HEXEN_S_SERPENT_HUMP10,
  HEXEN_S_SERPENT_HUMP11,
  HEXEN_S_SERPENT_HUMP12,
  HEXEN_S_SERPENT_HUMP13,
  HEXEN_S_SERPENT_HUMP14,
  HEXEN_S_SERPENT_HUMP15,
  HEXEN_S_SERPENT_SURFACE1,
  HEXEN_S_SERPENT_SURFACE2,
  HEXEN_S_SERPENT_SURFACE3,
  HEXEN_S_SERPENT_SURFACE4,
  HEXEN_S_SERPENT_SURFACE5,
  HEXEN_S_SERPENT_DIVE1,
  HEXEN_S_SERPENT_DIVE2,
  HEXEN_S_SERPENT_DIVE3,
  HEXEN_S_SERPENT_DIVE4,
  HEXEN_S_SERPENT_DIVE5,
  HEXEN_S_SERPENT_DIVE6,
  HEXEN_S_SERPENT_DIVE7,
  HEXEN_S_SERPENT_DIVE8,
  HEXEN_S_SERPENT_DIVE9,
  HEXEN_S_SERPENT_DIVE10,
  HEXEN_S_SERPENT_WALK1,
  HEXEN_S_SERPENT_WALK2,
  HEXEN_S_SERPENT_WALK3,
  HEXEN_S_SERPENT_WALK4,
  HEXEN_S_SERPENT_PAIN1,
  HEXEN_S_SERPENT_PAIN2,
  HEXEN_S_SERPENT_ATK1,
  HEXEN_S_SERPENT_ATK2,
  HEXEN_S_SERPENT_MELEE1,
  HEXEN_S_SERPENT_MISSILE1,
  HEXEN_S_SERPENT_DIE1,
  HEXEN_S_SERPENT_DIE2,
  HEXEN_S_SERPENT_DIE3,
  HEXEN_S_SERPENT_DIE4,
  HEXEN_S_SERPENT_DIE5,
  HEXEN_S_SERPENT_DIE6,
  HEXEN_S_SERPENT_DIE7,
  HEXEN_S_SERPENT_DIE8,
  HEXEN_S_SERPENT_DIE9,
  HEXEN_S_SERPENT_DIE10,
  HEXEN_S_SERPENT_DIE11,
  HEXEN_S_SERPENT_DIE12,
  HEXEN_S_SERPENT_XDIE1,
  HEXEN_S_SERPENT_XDIE2,
  HEXEN_S_SERPENT_XDIE3,
  HEXEN_S_SERPENT_XDIE4,
  HEXEN_S_SERPENT_XDIE5,
  HEXEN_S_SERPENT_XDIE6,
  HEXEN_S_SERPENT_XDIE7,
  HEXEN_S_SERPENT_XDIE8,
  HEXEN_S_SERPENT_ICE,
  HEXEN_S_SERPENT_ICE2,
  HEXEN_S_SERPENT_FX1,
  HEXEN_S_SERPENT_FX2,
  HEXEN_S_SERPENT_FX3,
  HEXEN_S_SERPENT_FX4,
  HEXEN_S_SERPENT_FX_X1,
  HEXEN_S_SERPENT_FX_X2,
  HEXEN_S_SERPENT_FX_X3,
  HEXEN_S_SERPENT_FX_X4,
  HEXEN_S_SERPENT_FX_X5,
  HEXEN_S_SERPENT_FX_X6,
  HEXEN_S_SERPENT_HEAD1,
  HEXEN_S_SERPENT_HEAD2,
  HEXEN_S_SERPENT_HEAD3,
  HEXEN_S_SERPENT_HEAD4,
  HEXEN_S_SERPENT_HEAD5,
  HEXEN_S_SERPENT_HEAD6,
  HEXEN_S_SERPENT_HEAD7,
  HEXEN_S_SERPENT_HEAD8,
  HEXEN_S_SERPENT_HEAD_X1,
  HEXEN_S_SERPENT_GIB1_1,
  HEXEN_S_SERPENT_GIB1_2,
  HEXEN_S_SERPENT_GIB1_3,
  HEXEN_S_SERPENT_GIB1_4,
  HEXEN_S_SERPENT_GIB1_5,
  HEXEN_S_SERPENT_GIB1_6,
  HEXEN_S_SERPENT_GIB1_7,
  HEXEN_S_SERPENT_GIB1_8,
  HEXEN_S_SERPENT_GIB1_9,
  HEXEN_S_SERPENT_GIB1_10,
  HEXEN_S_SERPENT_GIB1_11,
  HEXEN_S_SERPENT_GIB1_12,
  HEXEN_S_SERPENT_GIB2_1,
  HEXEN_S_SERPENT_GIB2_2,
  HEXEN_S_SERPENT_GIB2_3,
  HEXEN_S_SERPENT_GIB2_4,
  HEXEN_S_SERPENT_GIB2_5,
  HEXEN_S_SERPENT_GIB2_6,
  HEXEN_S_SERPENT_GIB2_7,
  HEXEN_S_SERPENT_GIB2_8,
  HEXEN_S_SERPENT_GIB2_9,
  HEXEN_S_SERPENT_GIB2_10,
  HEXEN_S_SERPENT_GIB2_11,
  HEXEN_S_SERPENT_GIB2_12,
  HEXEN_S_SERPENT_GIB3_1,
  HEXEN_S_SERPENT_GIB3_2,
  HEXEN_S_SERPENT_GIB3_3,
  HEXEN_S_SERPENT_GIB3_4,
  HEXEN_S_SERPENT_GIB3_5,
  HEXEN_S_SERPENT_GIB3_6,
  HEXEN_S_SERPENT_GIB3_7,
  HEXEN_S_SERPENT_GIB3_8,
  HEXEN_S_SERPENT_GIB3_9,
  HEXEN_S_SERPENT_GIB3_10,
  HEXEN_S_SERPENT_GIB3_11,
  HEXEN_S_SERPENT_GIB3_12,
  HEXEN_S_BISHOP_LOOK1,
  HEXEN_S_BISHOP_DECIDE,
  HEXEN_S_BISHOP_BLUR1,
  HEXEN_S_BISHOP_BLUR2,
  HEXEN_S_BISHOP_WALK1,
  HEXEN_S_BISHOP_WALK2,
  HEXEN_S_BISHOP_WALK3,
  HEXEN_S_BISHOP_WALK4,
  HEXEN_S_BISHOP_WALK5,
  HEXEN_S_BISHOP_WALK6,
  HEXEN_S_BISHOP_ATK1,
  HEXEN_S_BISHOP_ATK2,
  HEXEN_S_BISHOP_ATK3,
  HEXEN_S_BISHOP_ATK4,
  HEXEN_S_BISHOP_ATK5,
  HEXEN_S_BISHOP_PAIN1,
  HEXEN_S_BISHOP_PAIN2,
  HEXEN_S_BISHOP_PAIN3,
  HEXEN_S_BISHOP_PAIN4,
  HEXEN_S_BISHOP_PAIN5,
  HEXEN_S_BISHOP_DEATH1,
  HEXEN_S_BISHOP_DEATH2,
  HEXEN_S_BISHOP_DEATH3,
  HEXEN_S_BISHOP_DEATH4,
  HEXEN_S_BISHOP_DEATH5,
  HEXEN_S_BISHOP_DEATH6,
  HEXEN_S_BISHOP_DEATH7,
  HEXEN_S_BISHOP_DEATH8,
  HEXEN_S_BISHOP_DEATH9,
  HEXEN_S_BISHOP_DEATH10,
  HEXEN_S_BISHOP_ICE,
  HEXEN_S_BISHOP_ICE2,
  HEXEN_S_BISHOP_PUFF1,
  HEXEN_S_BISHOP_PUFF2,
  HEXEN_S_BISHOP_PUFF3,
  HEXEN_S_BISHOP_PUFF4,
  HEXEN_S_BISHOP_PUFF5,
  HEXEN_S_BISHOP_PUFF6,
  HEXEN_S_BISHOP_PUFF7,
  HEXEN_S_BISHOPBLUR1,
  HEXEN_S_BISHOPBLUR2,
  HEXEN_S_BISHOPPAINBLUR1,
  HEXEN_S_BISHFX1_1,
  HEXEN_S_BISHFX1_2,
  HEXEN_S_BISHFX1_3,
  HEXEN_S_BISHFX1_4,
  HEXEN_S_BISHFX1_5,
  HEXEN_S_BISHFXI1_1,
  HEXEN_S_BISHFXI1_2,
  HEXEN_S_BISHFXI1_3,
  HEXEN_S_BISHFXI1_4,
  HEXEN_S_BISHFXI1_5,
  HEXEN_S_BISHFXI1_6,
  HEXEN_S_DRAGON_LOOK1,
  HEXEN_S_DRAGON_INIT,
  HEXEN_S_DRAGON_INIT2,
  HEXEN_S_DRAGON_INIT3,
  HEXEN_S_DRAGON_WALK1,
  HEXEN_S_DRAGON_WALK2,
  HEXEN_S_DRAGON_WALK3,
  HEXEN_S_DRAGON_WALK4,
  HEXEN_S_DRAGON_WALK5,
  HEXEN_S_DRAGON_WALK6,
  HEXEN_S_DRAGON_WALK7,
  HEXEN_S_DRAGON_WALK8,
  HEXEN_S_DRAGON_WALK9,
  HEXEN_S_DRAGON_WALK10,
  HEXEN_S_DRAGON_WALK11,
  HEXEN_S_DRAGON_WALK12,
  HEXEN_S_DRAGON_ATK1,
  HEXEN_S_DRAGON_PAIN1,
  HEXEN_S_DRAGON_DEATH1,
  HEXEN_S_DRAGON_DEATH2,
  HEXEN_S_DRAGON_DEATH3,
  HEXEN_S_DRAGON_DEATH4,
  HEXEN_S_DRAGON_CRASH1,
  HEXEN_S_DRAGON_CRASH2,
  HEXEN_S_DRAGON_CRASH3,
  HEXEN_S_DRAGON_FX1_1,
  HEXEN_S_DRAGON_FX1_2,
  HEXEN_S_DRAGON_FX1_3,
  HEXEN_S_DRAGON_FX1_4,
  HEXEN_S_DRAGON_FX1_5,
  HEXEN_S_DRAGON_FX1_6,
  HEXEN_S_DRAGON_FX1_X1,
  HEXEN_S_DRAGON_FX1_X2,
  HEXEN_S_DRAGON_FX1_X3,
  HEXEN_S_DRAGON_FX1_X4,
  HEXEN_S_DRAGON_FX1_X5,
  HEXEN_S_DRAGON_FX1_X6,
  HEXEN_S_DRAGON_FX2_1,
  HEXEN_S_DRAGON_FX2_2,
  HEXEN_S_DRAGON_FX2_3,
  HEXEN_S_DRAGON_FX2_4,
  HEXEN_S_DRAGON_FX2_5,
  HEXEN_S_DRAGON_FX2_6,
  HEXEN_S_DRAGON_FX2_7,
  HEXEN_S_DRAGON_FX2_8,
  HEXEN_S_DRAGON_FX2_9,
  HEXEN_S_DRAGON_FX2_10,
  HEXEN_S_DRAGON_FX2_11,
  HEXEN_S_ARMOR_1,
  HEXEN_S_ARMOR_2,
  HEXEN_S_ARMOR_3,
  HEXEN_S_ARMOR_4,
  HEXEN_S_MANA1_1,
  HEXEN_S_MANA1_2,
  HEXEN_S_MANA1_3,
  HEXEN_S_MANA1_4,
  HEXEN_S_MANA1_5,
  HEXEN_S_MANA1_6,
  HEXEN_S_MANA1_7,
  HEXEN_S_MANA1_8,
  HEXEN_S_MANA1_9,
  HEXEN_S_MANA2_1,
  HEXEN_S_MANA2_2,
  HEXEN_S_MANA2_3,
  HEXEN_S_MANA2_4,
  HEXEN_S_MANA2_5,
  HEXEN_S_MANA2_6,
  HEXEN_S_MANA2_7,
  HEXEN_S_MANA2_8,
  HEXEN_S_MANA2_9,
  HEXEN_S_MANA2_10,
  HEXEN_S_MANA2_11,
  HEXEN_S_MANA2_12,
  HEXEN_S_MANA2_13,
  HEXEN_S_MANA2_14,
  HEXEN_S_MANA2_15,
  HEXEN_S_MANA2_16,
  HEXEN_S_MANA3_1,
  HEXEN_S_MANA3_2,
  HEXEN_S_MANA3_3,
  HEXEN_S_MANA3_4,
  HEXEN_S_MANA3_5,
  HEXEN_S_MANA3_6,
  HEXEN_S_MANA3_7,
  HEXEN_S_MANA3_8,
  HEXEN_S_MANA3_9,
  HEXEN_S_MANA3_10,
  HEXEN_S_MANA3_11,
  HEXEN_S_MANA3_12,
  HEXEN_S_MANA3_13,
  HEXEN_S_MANA3_14,
  HEXEN_S_MANA3_15,
  HEXEN_S_MANA3_16,
  HEXEN_S_KEY1,
  HEXEN_S_KEY2,
  HEXEN_S_KEY3,
  HEXEN_S_KEY4,
  HEXEN_S_KEY5,
  HEXEN_S_KEY6,
  HEXEN_S_KEY7,
  HEXEN_S_KEY8,
  HEXEN_S_KEY9,
  HEXEN_S_KEYA,
  HEXEN_S_KEYB,
  HEXEN_S_SND_WIND1,
  HEXEN_S_SND_WIND2,
  HEXEN_S_SND_WATERFALL,
  HEXEN_S_ETTIN_LOOK1,
  HEXEN_S_ETTIN_LOOK2,
  HEXEN_S_ETTIN_CHASE1,
  HEXEN_S_ETTIN_CHASE2,
  HEXEN_S_ETTIN_CHASE3,
  HEXEN_S_ETTIN_CHASE4,
  HEXEN_S_ETTIN_PAIN1,
  HEXEN_S_ETTIN_ATK1_1,
  HEXEN_S_ETTIN_ATK1_2,
  HEXEN_S_ETTIN_ATK1_3,
  HEXEN_S_ETTIN_DEATH1_1,
  HEXEN_S_ETTIN_DEATH1_2,
  HEXEN_S_ETTIN_DEATH1_3,
  HEXEN_S_ETTIN_DEATH1_4,
  HEXEN_S_ETTIN_DEATH1_5,
  HEXEN_S_ETTIN_DEATH1_6,
  HEXEN_S_ETTIN_DEATH1_7,
  HEXEN_S_ETTIN_DEATH1_8,
  HEXEN_S_ETTIN_DEATH1_9,
  HEXEN_S_ETTIN_DEATH2_1,
  HEXEN_S_ETTIN_DEATH2_2,
  HEXEN_S_ETTIN_DEATH2_3,
  HEXEN_S_ETTIN_DEATH2_4,
  HEXEN_S_ETTIN_DEATH2_5,
  HEXEN_S_ETTIN_DEATH2_6,
  HEXEN_S_ETTIN_DEATH2_7,
  HEXEN_S_ETTIN_DEATH2_8,
  HEXEN_S_ETTIN_DEATH2_9,
  HEXEN_S_ETTIN_DEATH2_0,
  HEXEN_S_ETTIN_DEATH2_A,
  HEXEN_S_ETTIN_DEATH2_B,
  HEXEN_S_ETTIN_ICE1,
  HEXEN_S_ETTIN_ICE2,
  HEXEN_S_ETTIN_MACE1,
  HEXEN_S_ETTIN_MACE2,
  HEXEN_S_ETTIN_MACE3,
  HEXEN_S_ETTIN_MACE4,
  HEXEN_S_ETTIN_MACE5,
  HEXEN_S_ETTIN_MACE6,
  HEXEN_S_ETTIN_MACE7,
  HEXEN_S_FIRED_SPAWN1,
  HEXEN_S_FIRED_LOOK1,
  HEXEN_S_FIRED_LOOK2,
  HEXEN_S_FIRED_LOOK3,
  HEXEN_S_FIRED_LOOK4,
  HEXEN_S_FIRED_LOOK5,
  HEXEN_S_FIRED_LOOK6,
  HEXEN_S_FIRED_LOOK7,
  HEXEN_S_FIRED_LOOK8,
  HEXEN_S_FIRED_LOOK9,
  HEXEN_S_FIRED_LOOK0,
  HEXEN_S_FIRED_LOOKA,
  HEXEN_S_FIRED_LOOKB,
  HEXEN_S_FIRED_WALK1,
  HEXEN_S_FIRED_WALK2,
  HEXEN_S_FIRED_WALK3,
  HEXEN_S_FIRED_PAIN1,
  HEXEN_S_FIRED_ATTACK1,
  HEXEN_S_FIRED_ATTACK2,
  HEXEN_S_FIRED_ATTACK3,
  HEXEN_S_FIRED_ATTACK4,
  HEXEN_S_FIRED_DEATH1,
  HEXEN_S_FIRED_DEATH2,
  HEXEN_S_FIRED_DEATH3,
  HEXEN_S_FIRED_DEATH4,
  HEXEN_S_FIRED_XDEATH1,
  HEXEN_S_FIRED_XDEATH2,
  HEXEN_S_FIRED_XDEATH3,
  HEXEN_S_FIRED_ICE1,
  HEXEN_S_FIRED_ICE2,
  HEXEN_S_FIRED_CORPSE1,
  HEXEN_S_FIRED_CORPSE2,
  HEXEN_S_FIRED_CORPSE3,
  HEXEN_S_FIRED_CORPSE4,
  HEXEN_S_FIRED_CORPSE5,
  HEXEN_S_FIRED_CORPSE6,
  HEXEN_S_FIRED_RDROP1,
  HEXEN_S_FIRED_RDEAD1_1,
  HEXEN_S_FIRED_RDEAD1_2,
  HEXEN_S_FIRED_RDROP2,
  HEXEN_S_FIRED_RDEAD2_1,
  HEXEN_S_FIRED_RDEAD2_2,
  HEXEN_S_FIRED_RDROP3,
  HEXEN_S_FIRED_RDEAD3_1,
  HEXEN_S_FIRED_RDEAD3_2,
  HEXEN_S_FIRED_RDROP4,
  HEXEN_S_FIRED_RDEAD4_1,
  HEXEN_S_FIRED_RDEAD4_2,
  HEXEN_S_FIRED_RDROP5,
  HEXEN_S_FIRED_RDEAD5_1,
  HEXEN_S_FIRED_RDEAD5_2,
  HEXEN_S_FIRED_FX6_1,
  HEXEN_S_FIRED_FX6_2,
  HEXEN_S_FIRED_FX6_3,
  HEXEN_S_FIRED_FX6_4,
  HEXEN_S_FIRED_FX6_5,
  HEXEN_S_ICEGUY_LOOK,
  HEXEN_S_ICEGUY_DORMANT,
  HEXEN_S_ICEGUY_WALK1,
  HEXEN_S_ICEGUY_WALK2,
  HEXEN_S_ICEGUY_WALK3,
  HEXEN_S_ICEGUY_WALK4,
  HEXEN_S_ICEGUY_ATK1,
  HEXEN_S_ICEGUY_ATK2,
  HEXEN_S_ICEGUY_ATK3,
  HEXEN_S_ICEGUY_ATK4,
  HEXEN_S_ICEGUY_PAIN1,
  HEXEN_S_ICEGUY_DEATH,
  HEXEN_S_ICEGUY_FX1,
  HEXEN_S_ICEGUY_FX2,
  HEXEN_S_ICEGUY_FX3,
  HEXEN_S_ICEGUY_FX_X1,
  HEXEN_S_ICEGUY_FX_X2,
  HEXEN_S_ICEGUY_FX_X3,
  HEXEN_S_ICEGUY_FX_X4,
  HEXEN_S_ICEGUY_FX_X5,
  HEXEN_S_ICEFX_PUFF1,
  HEXEN_S_ICEFX_PUFF2,
  HEXEN_S_ICEFX_PUFF3,
  HEXEN_S_ICEFX_PUFF4,
  HEXEN_S_ICEFX_PUFF5,
  HEXEN_S_ICEGUY_FX2_1,
  HEXEN_S_ICEGUY_FX2_2,
  HEXEN_S_ICEGUY_FX2_3,
  HEXEN_S_ICEGUY_BIT1,
  HEXEN_S_ICEGUY_BIT2,
  HEXEN_S_ICEGUY_WISP1_1,
  HEXEN_S_ICEGUY_WISP1_2,
  HEXEN_S_ICEGUY_WISP1_3,
  HEXEN_S_ICEGUY_WISP1_4,
  HEXEN_S_ICEGUY_WISP1_5,
  HEXEN_S_ICEGUY_WISP1_6,
  HEXEN_S_ICEGUY_WISP1_7,
  HEXEN_S_ICEGUY_WISP1_8,
  HEXEN_S_ICEGUY_WISP1_9,
  HEXEN_S_ICEGUY_WISP2_1,
  HEXEN_S_ICEGUY_WISP2_2,
  HEXEN_S_ICEGUY_WISP2_3,
  HEXEN_S_ICEGUY_WISP2_4,
  HEXEN_S_ICEGUY_WISP2_5,
  HEXEN_S_ICEGUY_WISP2_6,
  HEXEN_S_ICEGUY_WISP2_7,
  HEXEN_S_ICEGUY_WISP2_8,
  HEXEN_S_ICEGUY_WISP2_9,
  HEXEN_S_FIGHTER,
  HEXEN_S_FIGHTER2,
  HEXEN_S_FIGHTERLOOK,
  HEXEN_S_FIGHTER_RUN1,
  HEXEN_S_FIGHTER_RUN2,
  HEXEN_S_FIGHTER_RUN3,
  HEXEN_S_FIGHTER_RUN4,
  HEXEN_S_FIGHTER_ATK1,
  HEXEN_S_FIGHTER_ATK2,
  HEXEN_S_FIGHTER_PAIN,
  HEXEN_S_FIGHTER_PAIN2,
  HEXEN_S_FIGHTER_DIE1,
  HEXEN_S_FIGHTER_DIE2,
  HEXEN_S_FIGHTER_DIE3,
  HEXEN_S_FIGHTER_DIE4,
  HEXEN_S_FIGHTER_DIE5,
  HEXEN_S_FIGHTER_DIE6,
  HEXEN_S_FIGHTER_DIE7,
  HEXEN_S_FIGHTER_XDIE1,
  HEXEN_S_FIGHTER_XDIE2,
  HEXEN_S_FIGHTER_XDIE3,
  HEXEN_S_FIGHTER_XDIE4,
  HEXEN_S_FIGHTER_XDIE5,
  HEXEN_S_FIGHTER_XDIE6,
  HEXEN_S_FIGHTER_XDIE7,
  HEXEN_S_FIGHTER_XDIE8,
  HEXEN_S_FIGHTER_ICE,
  HEXEN_S_FIGHTER_ICE2,
  HEXEN_S_CLERIC,
  HEXEN_S_CLERIC2,
  HEXEN_S_CLERICLOOK,
  HEXEN_S_CLERIC_RUN1,
  HEXEN_S_CLERIC_RUN2,
  HEXEN_S_CLERIC_RUN3,
  HEXEN_S_CLERIC_RUN4,
  HEXEN_S_CLERIC_ATK1,
  HEXEN_S_CLERIC_ATK2,
  HEXEN_S_CLERIC_ATK3,
  HEXEN_S_CLERIC_PAIN,
  HEXEN_S_CLERIC_PAIN2,
  HEXEN_S_CLERIC_DIE1,
  HEXEN_S_CLERIC_DIE2,
  HEXEN_S_CLERIC_DIE3,
  HEXEN_S_CLERIC_DIE4,
  HEXEN_S_CLERIC_DIE5,
  HEXEN_S_CLERIC_DIE6,
  HEXEN_S_CLERIC_DIE7,
  HEXEN_S_CLERIC_DIE8,
  HEXEN_S_CLERIC_DIE9,
  HEXEN_S_CLERIC_XDIE1,
  HEXEN_S_CLERIC_XDIE2,
  HEXEN_S_CLERIC_XDIE3,
  HEXEN_S_CLERIC_XDIE4,
  HEXEN_S_CLERIC_XDIE5,
  HEXEN_S_CLERIC_XDIE6,
  HEXEN_S_CLERIC_XDIE7,
  HEXEN_S_CLERIC_XDIE8,
  HEXEN_S_CLERIC_XDIE9,
  HEXEN_S_CLERIC_XDIE10,
  HEXEN_S_CLERIC_ICE,
  HEXEN_S_CLERIC_ICE2,
  HEXEN_S_MAGE,
  HEXEN_S_MAGE2,
  HEXEN_S_MAGELOOK,
  HEXEN_S_MAGE_RUN1,
  HEXEN_S_MAGE_RUN2,
  HEXEN_S_MAGE_RUN3,
  HEXEN_S_MAGE_RUN4,
  HEXEN_S_MAGE_ATK1,
  HEXEN_S_MAGE_ATK2,
  HEXEN_S_MAGE_PAIN,
  HEXEN_S_MAGE_PAIN2,
  HEXEN_S_MAGE_DIE1,
  HEXEN_S_MAGE_DIE2,
  HEXEN_S_MAGE_DIE3,
  HEXEN_S_MAGE_DIE4,
  HEXEN_S_MAGE_DIE5,
  HEXEN_S_MAGE_DIE6,
  HEXEN_S_MAGE_DIE7,
  HEXEN_S_MAGE_XDIE1,
  HEXEN_S_MAGE_XDIE2,
  HEXEN_S_MAGE_XDIE3,
  HEXEN_S_MAGE_XDIE4,
  HEXEN_S_MAGE_XDIE5,
  HEXEN_S_MAGE_XDIE6,
  HEXEN_S_MAGE_XDIE7,
  HEXEN_S_MAGE_XDIE8,
  HEXEN_S_MAGE_XDIE9,
  HEXEN_S_MAGE_ICE,
  HEXEN_S_MAGE_ICE2,
  HEXEN_S_SORC_SPAWN1,
  HEXEN_S_SORC_SPAWN2,
  HEXEN_S_SORC_LOOK1,
  HEXEN_S_SORC_WALK1,
  HEXEN_S_SORC_WALK2,
  HEXEN_S_SORC_WALK3,
  HEXEN_S_SORC_WALK4,
  HEXEN_S_SORC_PAIN1,
  HEXEN_S_SORC_PAIN2,
  HEXEN_S_SORC_ATK2_1,
  HEXEN_S_SORC_ATK2_2,
  HEXEN_S_SORC_ATK2_3,
  HEXEN_S_SORC_ATTACK1,
  HEXEN_S_SORC_ATTACK2,
  HEXEN_S_SORC_ATTACK3,
  HEXEN_S_SORC_ATTACK4,
  HEXEN_S_SORC_ATTACK5,
  HEXEN_S_SORC_DIE1,
  HEXEN_S_SORC_DIE2,
  HEXEN_S_SORC_DIE3,
  HEXEN_S_SORC_DIE4,
  HEXEN_S_SORC_DIE5,
  HEXEN_S_SORC_DIE6,
  HEXEN_S_SORC_DIE7,
  HEXEN_S_SORC_DIE8,
  HEXEN_S_SORC_DIE9,
  HEXEN_S_SORC_DIE0,
  HEXEN_S_SORC_DIEA,
  HEXEN_S_SORC_DIEB,
  HEXEN_S_SORC_DIEC,
  HEXEN_S_SORC_DIED,
  HEXEN_S_SORC_DIEE,
  HEXEN_S_SORC_DIEF,
  HEXEN_S_SORC_DIEG,
  HEXEN_S_SORC_DIEH,
  HEXEN_S_SORC_DIEI,
  HEXEN_S_SORCBALL1_1,
  HEXEN_S_SORCBALL1_2,
  HEXEN_S_SORCBALL1_3,
  HEXEN_S_SORCBALL1_4,
  HEXEN_S_SORCBALL1_5,
  HEXEN_S_SORCBALL1_6,
  HEXEN_S_SORCBALL1_7,
  HEXEN_S_SORCBALL1_8,
  HEXEN_S_SORCBALL1_9,
  HEXEN_S_SORCBALL1_0,
  HEXEN_S_SORCBALL1_A,
  HEXEN_S_SORCBALL1_B,
  HEXEN_S_SORCBALL1_C,
  HEXEN_S_SORCBALL1_D,
  HEXEN_S_SORCBALL1_E,
  HEXEN_S_SORCBALL1_F,
  HEXEN_S_SORCBALL1_D1,
  HEXEN_S_SORCBALL1_D2,
  HEXEN_S_SORCBALL1_D5,
  HEXEN_S_SORCBALL1_D6,
  HEXEN_S_SORCBALL1_D7,
  HEXEN_S_SORCBALL1_D8,
  HEXEN_S_SORCBALL1_D9,
  HEXEN_S_SORCBALL2_1,
  HEXEN_S_SORCBALL2_2,
  HEXEN_S_SORCBALL2_3,
  HEXEN_S_SORCBALL2_4,
  HEXEN_S_SORCBALL2_5,
  HEXEN_S_SORCBALL2_6,
  HEXEN_S_SORCBALL2_7,
  HEXEN_S_SORCBALL2_8,
  HEXEN_S_SORCBALL2_9,
  HEXEN_S_SORCBALL2_0,
  HEXEN_S_SORCBALL2_A,
  HEXEN_S_SORCBALL2_B,
  HEXEN_S_SORCBALL2_C,
  HEXEN_S_SORCBALL2_D,
  HEXEN_S_SORCBALL2_E,
  HEXEN_S_SORCBALL2_F,
  HEXEN_S_SORCBALL2_D1,
  HEXEN_S_SORCBALL2_D2,
  HEXEN_S_SORCBALL2_D5,
  HEXEN_S_SORCBALL2_D6,
  HEXEN_S_SORCBALL2_D7,
  HEXEN_S_SORCBALL2_D8,
  HEXEN_S_SORCBALL2_D9,
  HEXEN_S_SORCBALL3_1,
  HEXEN_S_SORCBALL3_2,
  HEXEN_S_SORCBALL3_3,
  HEXEN_S_SORCBALL3_4,
  HEXEN_S_SORCBALL3_5,
  HEXEN_S_SORCBALL3_6,
  HEXEN_S_SORCBALL3_7,
  HEXEN_S_SORCBALL3_8,
  HEXEN_S_SORCBALL3_9,
  HEXEN_S_SORCBALL3_0,
  HEXEN_S_SORCBALL3_A,
  HEXEN_S_SORCBALL3_B,
  HEXEN_S_SORCBALL3_C,
  HEXEN_S_SORCBALL3_D,
  HEXEN_S_SORCBALL3_E,
  HEXEN_S_SORCBALL3_F,
  HEXEN_S_SORCBALL3_D1,
  HEXEN_S_SORCBALL3_D2,
  HEXEN_S_SORCBALL3_D5,
  HEXEN_S_SORCBALL3_D6,
  HEXEN_S_SORCBALL3_D7,
  HEXEN_S_SORCBALL3_D8,
  HEXEN_S_SORCBALL3_D9,
  HEXEN_S_SORCFX1_1,
  HEXEN_S_SORCFX1_2,
  HEXEN_S_SORCFX1_3,
  HEXEN_S_SORCFX1_4,
  HEXEN_S_SORCFX1_D1,
  HEXEN_S_SORCFX1_D2,
  HEXEN_S_SORCFX1_D3,
  HEXEN_S_SORCFX2_SPLIT1,
  HEXEN_S_SORCFX2_ORBIT1,
  HEXEN_S_SORCFX2_ORBIT2,
  HEXEN_S_SORCFX2_ORBIT3,
  HEXEN_S_SORCFX2_ORBIT4,
  HEXEN_S_SORCFX2_ORBIT5,
  HEXEN_S_SORCFX2_ORBIT6,
  HEXEN_S_SORCFX2_ORBIT7,
  HEXEN_S_SORCFX2_ORBIT8,
  HEXEN_S_SORCFX2_ORBIT9,
  HEXEN_S_SORCFX2_ORBIT0,
  HEXEN_S_SORCFX2_ORBITA,
  HEXEN_S_SORCFX2_ORBITB,
  HEXEN_S_SORCFX2_ORBITC,
  HEXEN_S_SORCFX2_ORBITD,
  HEXEN_S_SORCFX2_ORBITE,
  HEXEN_S_SORCFX2_ORBITF,
  HEXEN_S_SORCFX2T1,
  HEXEN_S_SORCFX3_1,
  HEXEN_S_SORCFX3_2,
  HEXEN_S_SORCFX3_3,
  HEXEN_S_BISHMORPH1,
  HEXEN_S_BISHMORPHA,
  HEXEN_S_BISHMORPHB,
  HEXEN_S_BISHMORPHC,
  HEXEN_S_BISHMORPHD,
  HEXEN_S_BISHMORPHE,
  HEXEN_S_BISHMORPHF,
  HEXEN_S_BISHMORPHG,
  HEXEN_S_BISHMORPHH,
  HEXEN_S_BISHMORPHI,
  HEXEN_S_BISHMORPHJ,
  HEXEN_S_SORCFX3_EXP1,
  HEXEN_S_SORCFX3_EXP2,
  HEXEN_S_SORCFX3_EXP3,
  HEXEN_S_SORCFX3_EXP4,
  HEXEN_S_SORCFX3_EXP5,
  HEXEN_S_SORCFX4_1,
  HEXEN_S_SORCFX4_2,
  HEXEN_S_SORCFX4_3,
  HEXEN_S_SORCFX4_D1,
  HEXEN_S_SORCFX4_D2,
  HEXEN_S_SORCFX4_D3,
  HEXEN_S_SORCFX4_D4,
  HEXEN_S_SORCFX4_D5,
  HEXEN_S_SORCSPARK1,
  HEXEN_S_SORCSPARK2,
  HEXEN_S_SORCSPARK3,
  HEXEN_S_SORCSPARK4,
  HEXEN_S_SORCSPARK5,
  HEXEN_S_SORCSPARK6,
  HEXEN_S_SORCSPARK7,
  HEXEN_S_BLASTEFFECT1,
  HEXEN_S_BLASTEFFECT2,
  HEXEN_S_BLASTEFFECT3,
  HEXEN_S_BLASTEFFECT4,
  HEXEN_S_BLASTEFFECT5,
  HEXEN_S_BLASTEFFECT6,
  HEXEN_S_BLASTEFFECT7,
  HEXEN_S_BLASTEFFECT8,
  HEXEN_S_BLASTEFFECT9,
  HEXEN_S_WATERDRIP1,
  HEXEN_S_KORAX_LOOK1,
  HEXEN_S_KORAX_CHASE1,
  HEXEN_S_KORAX_CHASE2,
  HEXEN_S_KORAX_CHASE3,
  HEXEN_S_KORAX_CHASE4,
  HEXEN_S_KORAX_CHASE5,
  HEXEN_S_KORAX_CHASE6,
  HEXEN_S_KORAX_CHASE7,
  HEXEN_S_KORAX_CHASE8,
  HEXEN_S_KORAX_CHASE9,
  HEXEN_S_KORAX_CHASE0,
  HEXEN_S_KORAX_CHASEA,
  HEXEN_S_KORAX_CHASEB,
  HEXEN_S_KORAX_CHASEC,
  HEXEN_S_KORAX_CHASED,
  HEXEN_S_KORAX_CHASEE,
  HEXEN_S_KORAX_CHASEF,
  HEXEN_S_KORAX_PAIN1,
  HEXEN_S_KORAX_PAIN2,
  HEXEN_S_KORAX_ATTACK1,
  HEXEN_S_KORAX_ATTACK2,
  HEXEN_S_KORAX_MISSILE1,
  HEXEN_S_KORAX_MISSILE2,
  HEXEN_S_KORAX_MISSILE3,
  HEXEN_S_KORAX_COMMAND1,
  HEXEN_S_KORAX_COMMAND2,
  HEXEN_S_KORAX_COMMAND3,
  HEXEN_S_KORAX_COMMAND4,
  HEXEN_S_KORAX_COMMAND5,
  HEXEN_S_KORAX_DEATH1,
  HEXEN_S_KORAX_DEATH2,
  HEXEN_S_KORAX_DEATH3,
  HEXEN_S_KORAX_DEATH4,
  HEXEN_S_KORAX_DEATH5,
  HEXEN_S_KORAX_DEATH6,
  HEXEN_S_KORAX_DEATH7,
  HEXEN_S_KORAX_DEATH8,
  HEXEN_S_KORAX_DEATH9,
  HEXEN_S_KORAX_DEATH0,
  HEXEN_S_KORAX_DEATHA,
  HEXEN_S_KORAX_DEATHB,
  HEXEN_S_KORAX_DEATHC,
  HEXEN_S_KORAX_DEATHD,
  HEXEN_S_KSPIRIT_ROAM1,
  HEXEN_S_KSPIRIT_ROAM2,
  HEXEN_S_KSPIRIT_DEATH1,
  HEXEN_S_KSPIRIT_DEATH2,
  HEXEN_S_KSPIRIT_DEATH3,
  HEXEN_S_KSPIRIT_DEATH4,
  HEXEN_S_KSPIRIT_DEATH5,
  HEXEN_S_KSPIRIT_DEATH6,
  HEXEN_S_KBOLT1,
  HEXEN_S_KBOLT2,
  HEXEN_S_KBOLT3,
  HEXEN_S_KBOLT4,
  HEXEN_S_KBOLT5,
  HEXEN_S_KBOLT6,
  HEXEN_S_KBOLT7,
  HEXEN_S_SPAWNBATS1,
  HEXEN_S_SPAWNBATS2,
  HEXEN_S_SPAWNBATS3,
  HEXEN_S_SPAWNBATS_OFF,
  HEXEN_S_BAT1,
  HEXEN_S_BAT2,
  HEXEN_S_BAT3,
  HEXEN_S_BAT_DEATH,
  HEXEN_NUMSTATES
} statenum_t;

/********************************************************************
 * Definition of the state (frames) structure                       *
 ********************************************************************/

typedef long long statearg_t;

typedef struct
{
  spritenum_t sprite;       /* sprite number to show                       */
  long        frame;        /* which frame/subframe of the sprite is shown */
  long        tics;         /* number of gametics this frame should last   */
  actionf_t   action;       /* code pointer to function for action if any  */
  statenum_t  nextstate;    /* linked list pointer to next state or zero   */
  long        misc1, misc2; /* apparently never used in DOOM               */
  statearg_t  args[MAXSTATEARGS]; // [XA] mbf21 args
  int         flags;
} state_t;

// state flags
#define STATEF_SKILL5FAST 0x00000001 // tics halve on nightmare skill

/********************************************************************
 * Thing enumeration -- must match info.c                           *
 ********************************************************************
 * Note that many of these are generically named for the ornamentals
 */

typedef enum {
  MT_NULL = -1, // ferk: null/invalid mobj (zero is reserved for MT_PLAYER)
  DOOM_MT_ZERO,
  MT_PLAYER = DOOM_MT_ZERO,
  MT_POSSESSED,
  MT_SHOTGUY,
  MT_VILE,
  MT_FIRE,
  MT_UNDEAD,
  MT_TRACER,
  MT_SMOKE,
  MT_FATSO,
  MT_FATSHOT,
  MT_CHAINGUY,
  MT_TROOP,
  MT_SERGEANT,
  MT_SHADOWS,
  MT_HEAD,
  MT_BRUISER,
  MT_BRUISERSHOT,
  MT_KNIGHT,
  MT_SKULL,
  MT_SPIDER,
  MT_BABY,
  MT_CYBORG,
  MT_PAIN,
  MT_WOLFSS,
  MT_KEEN,
  MT_BOSSBRAIN,
  MT_BOSSSPIT,
  MT_BOSSTARGET,
  MT_SPAWNSHOT,
  MT_SPAWNFIRE,
  MT_BARREL,
  MT_TROOPSHOT,
  MT_HEADSHOT,
  MT_ROCKET,
  MT_PLASMA,
  MT_BFG,
  MT_ARACHPLAZ,
  MT_PUFF,
  MT_BLOOD,
  MT_TFOG,
  MT_IFOG,
  MT_TELEPORTMAN,
  MT_EXTRABFG,
  MT_MISC0,
  MT_MISC1,
  MT_MISC2,
  MT_MISC3,
  MT_MISC4,
  MT_MISC5,
  MT_MISC6,
  MT_MISC7,
  MT_MISC8,
  MT_MISC9,
  MT_MISC10,
  MT_MISC11,
  MT_MISC12,
  MT_INV,
  MT_MISC13,
  MT_INS,
  MT_MISC14,
  MT_MISC15,
  MT_MISC16,
  MT_MEGA,
  MT_CLIP,
  MT_MISC17,
  MT_MISC18,
  MT_MISC19,
  MT_MISC20,
  MT_MISC21,
  MT_MISC22,
  MT_MISC23,
  MT_MISC24,
  MT_MISC25,
  MT_CHAINGUN,
  MT_MISC26,
  MT_MISC27,
  MT_MISC28,
  MT_SHOTGUN,
  MT_SUPERSHOTGUN,
  MT_MISC29,
  MT_MISC30,
  MT_MISC31,
  MT_MISC32,
  MT_MISC33,
  MT_MISC34,
  MT_MISC35,
  MT_MISC36,
  MT_MISC37,
  MT_MISC38,
  MT_MISC39,
  MT_MISC40,
  MT_MISC41,
  MT_MISC42,
  MT_MISC43,
  MT_MISC44,
  MT_MISC45,
  MT_MISC46,
  MT_MISC47,
  MT_MISC48,
  MT_MISC49,
  MT_MISC50,
  MT_MISC51,
  MT_MISC52,
  MT_MISC53,
  MT_MISC54,
  MT_MISC55,
  MT_MISC56,
  MT_MISC57,
  MT_MISC58,
  MT_MISC59,
  MT_MISC60,
  MT_MISC61,
  MT_MISC62,
  MT_MISC63,
  MT_MISC64,
  MT_MISC65,
  MT_MISC66,
  MT_MISC67,
  MT_MISC68,
  MT_MISC69,
  MT_MISC70,
  MT_MISC71,
  MT_MISC72,
  MT_MISC73,
  MT_MISC74,
  MT_MISC75,
  MT_MISC76,
  MT_MISC77,
  MT_MISC78,
  MT_MISC79,
  MT_MISC80,
  MT_MISC81,
  MT_MISC82,
  MT_MISC83,
  MT_MISC84,
  MT_MISC85,
  MT_MISC86,
  MT_PUSH,    /* controls push source - phares */
  MT_PULL,    /* controls pull source - phares 3/20/98 */
  MT_DOGS,    /* killough 7/19/98: Marine's best friend */
  MT_PLASMA1, // killough 7/11/98: first  of alternating beta plasma fireballs
  MT_PLASMA2, // killough 7/11/98: second of alternating beta plasma fireballs
  MT_SCEPTRE, // killough 7/11/98: evil sceptre in beta version
  MT_BIBLE,   // killough 7/11/98: unholy bible in beta version

  MT_MUSICSOURCE, /* MUSINFO lump */
  MT_GIBDTH,

  DOOM_NUMMOBJTYPES,

  // heretic
  HERETIC_MT_ZERO,
  HERETIC_MT_MISC0 = HERETIC_MT_ZERO,
  HERETIC_MT_ITEMSHIELD1,
  HERETIC_MT_ITEMSHIELD2,
  HERETIC_MT_MISC1,
  HERETIC_MT_MISC2,
  HERETIC_MT_ARTIINVISIBILITY,
  HERETIC_MT_MISC3,
  HERETIC_MT_ARTIFLY,
  HERETIC_MT_ARTIINVULNERABILITY,
  HERETIC_MT_ARTITOMEOFPOWER,
  HERETIC_MT_ARTIEGG,
  HERETIC_MT_EGGFX,
  HERETIC_MT_ARTISUPERHEAL,
  HERETIC_MT_MISC4,
  HERETIC_MT_MISC5,
  HERETIC_MT_FIREBOMB,
  HERETIC_MT_ARTITELEPORT,
  HERETIC_MT_POD,
  HERETIC_MT_PODGOO,
  HERETIC_MT_PODGENERATOR,
  HERETIC_MT_SPLASH,
  HERETIC_MT_SPLASHBASE,
  HERETIC_MT_LAVASPLASH,
  HERETIC_MT_LAVASMOKE,
  HERETIC_MT_SLUDGECHUNK,
  HERETIC_MT_SLUDGESPLASH,
  HERETIC_MT_SKULLHANG70,
  HERETIC_MT_SKULLHANG60,
  HERETIC_MT_SKULLHANG45,
  HERETIC_MT_SKULLHANG35,
  HERETIC_MT_CHANDELIER,
  HERETIC_MT_SERPTORCH,
  HERETIC_MT_SMALLPILLAR,
  HERETIC_MT_STALAGMITESMALL,
  HERETIC_MT_STALAGMITELARGE,
  HERETIC_MT_STALACTITESMALL,
  HERETIC_MT_STALACTITELARGE,
  HERETIC_MT_MISC6,
  HERETIC_MT_BARREL,
  HERETIC_MT_MISC7,
  HERETIC_MT_MISC8,
  HERETIC_MT_MISC9,
  HERETIC_MT_MISC10,
  HERETIC_MT_MISC11,
  HERETIC_MT_KEYGIZMOBLUE,
  HERETIC_MT_KEYGIZMOGREEN,
  HERETIC_MT_KEYGIZMOYELLOW,
  HERETIC_MT_KEYGIZMOFLOAT,
  HERETIC_MT_MISC12,
  HERETIC_MT_VOLCANOBLAST,
  HERETIC_MT_VOLCANOTBLAST,
  HERETIC_MT_TELEGLITGEN,
  HERETIC_MT_TELEGLITGEN2,
  HERETIC_MT_TELEGLITTER,
  HERETIC_MT_TELEGLITTER2,
  HERETIC_MT_TFOG,
  HERETIC_MT_TELEPORTMAN,
  HERETIC_MT_STAFFPUFF,
  HERETIC_MT_STAFFPUFF2,
  HERETIC_MT_BEAKPUFF,
  HERETIC_MT_MISC13,
  HERETIC_MT_GAUNTLETPUFF1,
  HERETIC_MT_GAUNTLETPUFF2,
  HERETIC_MT_MISC14,
  HERETIC_MT_BLASTERFX1,
  HERETIC_MT_BLASTERSMOKE,
  HERETIC_MT_RIPPER,
  HERETIC_MT_BLASTERPUFF1,
  HERETIC_MT_BLASTERPUFF2,
  HERETIC_MT_WMACE,
  HERETIC_MT_MACEFX1,
  HERETIC_MT_MACEFX2,
  HERETIC_MT_MACEFX3,
  HERETIC_MT_MACEFX4,
  HERETIC_MT_WSKULLROD,
  HERETIC_MT_HORNRODFX1,
  HERETIC_MT_HORNRODFX2,
  HERETIC_MT_RAINPLR1,
  HERETIC_MT_RAINPLR2,
  HERETIC_MT_RAINPLR3,
  HERETIC_MT_RAINPLR4,
  HERETIC_MT_GOLDWANDFX1,
  HERETIC_MT_GOLDWANDFX2,
  HERETIC_MT_GOLDWANDPUFF1,
  HERETIC_MT_GOLDWANDPUFF2,
  HERETIC_MT_WPHOENIXROD,
  HERETIC_MT_PHOENIXFX1,
  HERETIC_MT_PHOENIXFX_REMOVED,  // In Heretic 1.0, but removed.
  HERETIC_MT_PHOENIXPUFF,
  HERETIC_MT_PHOENIXFX2,
  HERETIC_MT_MISC15,
  HERETIC_MT_CRBOWFX1,
  HERETIC_MT_CRBOWFX2,
  HERETIC_MT_CRBOWFX3,
  HERETIC_MT_CRBOWFX4,
  HERETIC_MT_BLOOD,
  HERETIC_MT_BLOODSPLATTER,
  HERETIC_MT_PLAYER,
  HERETIC_MT_BLOODYSKULL,
  HERETIC_MT_CHICPLAYER,
  HERETIC_MT_CHICKEN,
  HERETIC_MT_FEATHER,
  HERETIC_MT_MUMMY,
  HERETIC_MT_MUMMYLEADER,
  HERETIC_MT_MUMMYGHOST,
  HERETIC_MT_MUMMYLEADERGHOST,
  HERETIC_MT_MUMMYSOUL,
  HERETIC_MT_MUMMYFX1,
  HERETIC_MT_BEAST,
  HERETIC_MT_BEASTBALL,
  HERETIC_MT_BURNBALL,
  HERETIC_MT_BURNBALLFB,
  HERETIC_MT_PUFFY,
  HERETIC_MT_SNAKE,
  HERETIC_MT_SNAKEPRO_A,
  HERETIC_MT_SNAKEPRO_B,
  HERETIC_MT_HEAD,
  HERETIC_MT_HEADFX1,
  HERETIC_MT_HEADFX2,
  HERETIC_MT_HEADFX3,
  HERETIC_MT_WHIRLWIND,
  HERETIC_MT_CLINK,
  HERETIC_MT_WIZARD,
  HERETIC_MT_WIZFX1,
  HERETIC_MT_IMP,
  HERETIC_MT_IMPLEADER,
  HERETIC_MT_IMPCHUNK1,
  HERETIC_MT_IMPCHUNK2,
  HERETIC_MT_IMPBALL,
  HERETIC_MT_KNIGHT,
  HERETIC_MT_KNIGHTGHOST,
  HERETIC_MT_KNIGHTAXE,
  HERETIC_MT_REDAXE,
  HERETIC_MT_SORCERER1,
  HERETIC_MT_SRCRFX1,
  HERETIC_MT_SORCERER2,
  HERETIC_MT_SOR2FX1,
  HERETIC_MT_SOR2FXSPARK,
  HERETIC_MT_SOR2FX2,
  HERETIC_MT_SOR2TELEFADE,
  HERETIC_MT_MINOTAUR,
  HERETIC_MT_MNTRFX1,
  HERETIC_MT_MNTRFX2,
  HERETIC_MT_MNTRFX3,
  HERETIC_MT_AKYY,
  HERETIC_MT_BKYY,
  HERETIC_MT_CKEY,
  HERETIC_MT_AMGWNDWIMPY,
  HERETIC_MT_AMGWNDHEFTY,
  HERETIC_MT_AMMACEWIMPY,
  HERETIC_MT_AMMACEHEFTY,
  HERETIC_MT_AMCBOWWIMPY,
  HERETIC_MT_AMCBOWHEFTY,
  HERETIC_MT_AMSKRDWIMPY,
  HERETIC_MT_AMSKRDHEFTY,
  HERETIC_MT_AMPHRDWIMPY,
  HERETIC_MT_AMPHRDHEFTY,
  HERETIC_MT_AMBLSRWIMPY,
  HERETIC_MT_AMBLSRHEFTY,
  HERETIC_MT_SOUNDWIND,
  HERETIC_MT_SOUNDWATERFALL,
  HERETIC_NUMMOBJTYPES,

  // hexen
  HEXEN_MT_ZERO,
  HEXEN_MT_MAPSPOT = HEXEN_MT_ZERO,
  HEXEN_MT_MAPSPOTGRAVITY,
  HEXEN_MT_FIREBALL1,
  HEXEN_MT_ARROW,
  HEXEN_MT_DART,
  HEXEN_MT_POISONDART,
  HEXEN_MT_RIPPERBALL,
  HEXEN_MT_PROJECTILE_BLADE,
  HEXEN_MT_ICESHARD,
  HEXEN_MT_FLAME_SMALL_TEMP,
  HEXEN_MT_FLAME_LARGE_TEMP,
  HEXEN_MT_FLAME_SMALL,
  HEXEN_MT_FLAME_LARGE,
  HEXEN_MT_HEALINGBOTTLE,
  HEXEN_MT_HEALTHFLASK,
  HEXEN_MT_ARTIFLY,
  HEXEN_MT_ARTIINVULNERABILITY,
  HEXEN_MT_SUMMONMAULATOR,
  HEXEN_MT_SUMMON_FX,
  HEXEN_MT_THRUSTFLOOR_UP,
  HEXEN_MT_THRUSTFLOOR_DOWN,
  HEXEN_MT_TELEPORTOTHER,
  HEXEN_MT_TELOTHER_FX1,
  HEXEN_MT_TELOTHER_FX2,
  HEXEN_MT_TELOTHER_FX3,
  HEXEN_MT_TELOTHER_FX4,
  HEXEN_MT_TELOTHER_FX5,
  HEXEN_MT_DIRT1,
  HEXEN_MT_DIRT2,
  HEXEN_MT_DIRT3,
  HEXEN_MT_DIRT4,
  HEXEN_MT_DIRT5,
  HEXEN_MT_DIRT6,
  HEXEN_MT_DIRTCLUMP,
  HEXEN_MT_ROCK1,
  HEXEN_MT_ROCK2,
  HEXEN_MT_ROCK3,
  HEXEN_MT_FOGSPAWNER,
  HEXEN_MT_FOGPATCHS,
  HEXEN_MT_FOGPATCHM,
  HEXEN_MT_FOGPATCHL,
  HEXEN_MT_QUAKE_FOCUS,
  HEXEN_MT_SGSHARD1,
  HEXEN_MT_SGSHARD2,
  HEXEN_MT_SGSHARD3,
  HEXEN_MT_SGSHARD4,
  HEXEN_MT_SGSHARD5,
  HEXEN_MT_SGSHARD6,
  HEXEN_MT_SGSHARD7,
  HEXEN_MT_SGSHARD8,
  HEXEN_MT_SGSHARD9,
  HEXEN_MT_SGSHARD0,
  HEXEN_MT_ARTIEGG,
  HEXEN_MT_EGGFX,
  HEXEN_MT_ARTISUPERHEAL,
  HEXEN_MT_ZWINGEDSTATUENOSKULL,
  HEXEN_MT_ZGEMPEDESTAL,
  HEXEN_MT_ARTIPUZZSKULL,
  HEXEN_MT_ARTIPUZZGEMBIG,
  HEXEN_MT_ARTIPUZZGEMRED,
  HEXEN_MT_ARTIPUZZGEMGREEN1,
  HEXEN_MT_ARTIPUZZGEMGREEN2,
  HEXEN_MT_ARTIPUZZGEMBLUE1,
  HEXEN_MT_ARTIPUZZGEMBLUE2,
  HEXEN_MT_ARTIPUZZBOOK1,
  HEXEN_MT_ARTIPUZZBOOK2,
  HEXEN_MT_ARTIPUZZSKULL2,
  HEXEN_MT_ARTIPUZZFWEAPON,
  HEXEN_MT_ARTIPUZZCWEAPON,
  HEXEN_MT_ARTIPUZZMWEAPON,
  HEXEN_MT_ARTIPUZZGEAR,
  HEXEN_MT_ARTIPUZZGEAR2,
  HEXEN_MT_ARTIPUZZGEAR3,
  HEXEN_MT_ARTIPUZZGEAR4,
  HEXEN_MT_ARTITORCH,
  HEXEN_MT_FIREBOMB,
  HEXEN_MT_ARTITELEPORT,
  HEXEN_MT_ARTIPOISONBAG,
  HEXEN_MT_POISONBAG,
  HEXEN_MT_POISONCLOUD,
  HEXEN_MT_THROWINGBOMB,
  HEXEN_MT_SPEEDBOOTS,
  HEXEN_MT_BOOSTMANA,
  HEXEN_MT_BOOSTARMOR,
  HEXEN_MT_BLASTRADIUS,
  HEXEN_MT_HEALRADIUS,
  HEXEN_MT_SPLASH,
  HEXEN_MT_SPLASHBASE,
  HEXEN_MT_LAVASPLASH,
  HEXEN_MT_LAVASMOKE,
  HEXEN_MT_SLUDGECHUNK,
  HEXEN_MT_SLUDGESPLASH,
  HEXEN_MT_MISC0,
  HEXEN_MT_MISC1,
  HEXEN_MT_MISC2,
  HEXEN_MT_MISC3,
  HEXEN_MT_MISC4,
  HEXEN_MT_MISC5,
  HEXEN_MT_MISC6,
  HEXEN_MT_MISC7,
  HEXEN_MT_MISC8,
  HEXEN_MT_TREEDESTRUCTIBLE,
  HEXEN_MT_MISC9,
  HEXEN_MT_MISC10,
  HEXEN_MT_MISC11,
  HEXEN_MT_MISC12,
  HEXEN_MT_MISC13,
  HEXEN_MT_MISC14,
  HEXEN_MT_MISC15,
  HEXEN_MT_MISC16,
  HEXEN_MT_MISC17,
  HEXEN_MT_MISC18,
  HEXEN_MT_MISC19,
  HEXEN_MT_MISC20,
  HEXEN_MT_MISC21,
  HEXEN_MT_MISC22,
  HEXEN_MT_MISC23,
  HEXEN_MT_MISC24,
  HEXEN_MT_MISC25,
  HEXEN_MT_MISC26,
  HEXEN_MT_MISC27,
  HEXEN_MT_MISC28,
  HEXEN_MT_MISC29,
  HEXEN_MT_MISC30,
  HEXEN_MT_MISC31,
  HEXEN_MT_MISC32,
  HEXEN_MT_MISC33,
  HEXEN_MT_MISC34,
  HEXEN_MT_MISC35,
  HEXEN_MT_MISC36,
  HEXEN_MT_MISC37,
  HEXEN_MT_MISC38,
  HEXEN_MT_MISC39,
  HEXEN_MT_MISC40,
  HEXEN_MT_MISC41,
  HEXEN_MT_MISC42,
  HEXEN_MT_MISC43,
  HEXEN_MT_MISC44,
  HEXEN_MT_MISC45,
  HEXEN_MT_MISC46,
  HEXEN_MT_MISC47,
  HEXEN_MT_MISC48,
  HEXEN_MT_MISC49,
  HEXEN_MT_MISC50,
  HEXEN_MT_MISC51,
  HEXEN_MT_MISC52,
  HEXEN_MT_MISC53,
  HEXEN_MT_MISC54,
  HEXEN_MT_MISC55,
  HEXEN_MT_MISC56,
  HEXEN_MT_MISC57,
  HEXEN_MT_MISC58,
  HEXEN_MT_MISC59,
  HEXEN_MT_MISC60,
  HEXEN_MT_MISC61,
  HEXEN_MT_MISC62,
  HEXEN_MT_MISC63,
  HEXEN_MT_MISC64,
  HEXEN_MT_MISC65,
  HEXEN_MT_MISC66,
  HEXEN_MT_MISC67,
  HEXEN_MT_MISC68,
  HEXEN_MT_MISC69,
  HEXEN_MT_MISC70,
  HEXEN_MT_MISC71,
  HEXEN_MT_MISC72,
  HEXEN_MT_MISC73,
  HEXEN_MT_MISC74,
  HEXEN_MT_MISC75,
  HEXEN_MT_MISC76,
  HEXEN_MT_POTTERY1,
  HEXEN_MT_POTTERY2,
  HEXEN_MT_POTTERY3,
  HEXEN_MT_POTTERYBIT1,
  HEXEN_MT_MISC77,
  HEXEN_MT_ZLYNCHED_NOHEART,
  HEXEN_MT_MISC78,
  HEXEN_MT_CORPSEBIT,
  HEXEN_MT_CORPSEBLOODDRIP,
  HEXEN_MT_BLOODPOOL,
  HEXEN_MT_MISC79,
  HEXEN_MT_MISC80,
  HEXEN_MT_LEAF1,
  HEXEN_MT_LEAF2,
  HEXEN_MT_ZTWINEDTORCH,
  HEXEN_MT_ZTWINEDTORCH_UNLIT,
  HEXEN_MT_BRIDGE,
  HEXEN_MT_BRIDGEBALL,
  HEXEN_MT_ZWALLTORCH,
  HEXEN_MT_ZWALLTORCH_UNLIT,
  HEXEN_MT_ZBARREL,
  HEXEN_MT_ZSHRUB1,
  HEXEN_MT_ZSHRUB2,
  HEXEN_MT_ZBUCKET,
  HEXEN_MT_ZPOISONSHROOM,
  HEXEN_MT_ZFIREBULL,
  HEXEN_MT_ZFIREBULL_UNLIT,
  HEXEN_MT_FIRETHING,
  HEXEN_MT_BRASSTORCH,
  HEXEN_MT_ZSUITOFARMOR,
  HEXEN_MT_ZARMORCHUNK,
  HEXEN_MT_ZBELL,
  HEXEN_MT_ZBLUE_CANDLE,
  HEXEN_MT_ZIRON_MAIDEN,
  HEXEN_MT_ZXMAS_TREE,
  HEXEN_MT_ZCAULDRON,
  HEXEN_MT_ZCAULDRON_UNLIT,
  HEXEN_MT_ZCHAINBIT32,
  HEXEN_MT_ZCHAINBIT64,
  HEXEN_MT_ZCHAINEND_HEART,
  HEXEN_MT_ZCHAINEND_HOOK1,
  HEXEN_MT_ZCHAINEND_HOOK2,
  HEXEN_MT_ZCHAINEND_SPIKE,
  HEXEN_MT_ZCHAINEND_SKULL,
  HEXEN_MT_TABLE_SHIT1,
  HEXEN_MT_TABLE_SHIT2,
  HEXEN_MT_TABLE_SHIT3,
  HEXEN_MT_TABLE_SHIT4,
  HEXEN_MT_TABLE_SHIT5,
  HEXEN_MT_TABLE_SHIT6,
  HEXEN_MT_TABLE_SHIT7,
  HEXEN_MT_TABLE_SHIT8,
  HEXEN_MT_TABLE_SHIT9,
  HEXEN_MT_TABLE_SHIT10,
  HEXEN_MT_TFOG,
  HEXEN_MT_MISC81,
  HEXEN_MT_TELEPORTMAN,
  HEXEN_MT_PUNCHPUFF,
  HEXEN_MT_FW_AXE,
  HEXEN_MT_AXEPUFF,
  HEXEN_MT_AXEPUFF_GLOW,
  HEXEN_MT_AXEBLOOD,
  HEXEN_MT_FW_HAMMER,
  HEXEN_MT_HAMMER_MISSILE,
  HEXEN_MT_HAMMERPUFF,
  HEXEN_MT_FSWORD_MISSILE,
  HEXEN_MT_FSWORD_FLAME,
  HEXEN_MT_CW_SERPSTAFF,
  HEXEN_MT_CSTAFF_MISSILE,
  HEXEN_MT_CSTAFFPUFF,
  HEXEN_MT_CW_FLAME,
  HEXEN_MT_CFLAMEFLOOR,
  HEXEN_MT_FLAMEPUFF,
  HEXEN_MT_FLAMEPUFF2,
  HEXEN_MT_CIRCLEFLAME,
  HEXEN_MT_CFLAME_MISSILE,
  HEXEN_MT_HOLY_FX,
  HEXEN_MT_HOLY_TAIL,
  HEXEN_MT_HOLY_PUFF,
  HEXEN_MT_HOLY_MISSILE,
  HEXEN_MT_HOLY_MISSILE_PUFF,
  HEXEN_MT_MWANDPUFF,
  HEXEN_MT_MWANDSMOKE,
  HEXEN_MT_MWAND_MISSILE,
  HEXEN_MT_MW_LIGHTNING,
  HEXEN_MT_LIGHTNING_CEILING,
  HEXEN_MT_LIGHTNING_FLOOR,
  HEXEN_MT_LIGHTNING_ZAP,
  HEXEN_MT_MSTAFF_FX,
  HEXEN_MT_MSTAFF_FX2,
  HEXEN_MT_FW_SWORD1,
  HEXEN_MT_FW_SWORD2,
  HEXEN_MT_FW_SWORD3,
  HEXEN_MT_CW_HOLY1,
  HEXEN_MT_CW_HOLY2,
  HEXEN_MT_CW_HOLY3,
  HEXEN_MT_MW_STAFF1,
  HEXEN_MT_MW_STAFF2,
  HEXEN_MT_MW_STAFF3,
  HEXEN_MT_SNOUTPUFF,
  HEXEN_MT_MW_CONE,
  HEXEN_MT_SHARDFX1,
  HEXEN_MT_BLOOD,
  HEXEN_MT_BLOODSPLATTER,
  HEXEN_MT_GIBS,
  HEXEN_MT_PLAYER_FIGHTER,
  HEXEN_MT_BLOODYSKULL,
  HEXEN_MT_PLAYER_SPEED,
  HEXEN_MT_ICECHUNK,
  HEXEN_MT_PLAYER_CLERIC,
  HEXEN_MT_PLAYER_MAGE,
  HEXEN_MT_PIGPLAYER,
  HEXEN_MT_PIG,
  HEXEN_MT_CENTAUR,
  HEXEN_MT_CENTAURLEADER,
  HEXEN_MT_CENTAUR_FX,
  HEXEN_MT_CENTAUR_SHIELD,
  HEXEN_MT_CENTAUR_SWORD,
  HEXEN_MT_DEMON,
  HEXEN_MT_DEMONCHUNK1,
  HEXEN_MT_DEMONCHUNK2,
  HEXEN_MT_DEMONCHUNK3,
  HEXEN_MT_DEMONCHUNK4,
  HEXEN_MT_DEMONCHUNK5,
  HEXEN_MT_DEMONFX1,
  HEXEN_MT_DEMON2,
  HEXEN_MT_DEMON2CHUNK1,
  HEXEN_MT_DEMON2CHUNK2,
  HEXEN_MT_DEMON2CHUNK3,
  HEXEN_MT_DEMON2CHUNK4,
  HEXEN_MT_DEMON2CHUNK5,
  HEXEN_MT_DEMON2FX1,
  HEXEN_MT_WRAITHB,
  HEXEN_MT_WRAITH,
  HEXEN_MT_WRAITHFX1,
  HEXEN_MT_WRAITHFX2,
  HEXEN_MT_WRAITHFX3,
  HEXEN_MT_WRAITHFX4,
  HEXEN_MT_WRAITHFX5,
  HEXEN_MT_MINOTAUR,
  HEXEN_MT_MNTRFX1,
  HEXEN_MT_MNTRFX2,
  HEXEN_MT_MNTRFX3,
  HEXEN_MT_MNTRSMOKE,
  HEXEN_MT_MNTRSMOKEEXIT,
  HEXEN_MT_SERPENT,
  HEXEN_MT_SERPENTLEADER,
  HEXEN_MT_SERPENTFX,
  HEXEN_MT_SERPENT_HEAD,
  HEXEN_MT_SERPENT_GIB1,
  HEXEN_MT_SERPENT_GIB2,
  HEXEN_MT_SERPENT_GIB3,
  HEXEN_MT_BISHOP,
  HEXEN_MT_BISHOP_PUFF,
  HEXEN_MT_BISHOPBLUR,
  HEXEN_MT_BISHOPPAINBLUR,
  HEXEN_MT_BISH_FX,
  HEXEN_MT_DRAGON,
  HEXEN_MT_DRAGON_FX,
  HEXEN_MT_DRAGON_FX2,
  HEXEN_MT_ARMOR_1,
  HEXEN_MT_ARMOR_2,
  HEXEN_MT_ARMOR_3,
  HEXEN_MT_ARMOR_4,
  HEXEN_MT_MANA1,
  HEXEN_MT_MANA2,
  HEXEN_MT_MANA3,
  HEXEN_MT_KEY1,
  HEXEN_MT_KEY2,
  HEXEN_MT_KEY3,
  HEXEN_MT_KEY4,
  HEXEN_MT_KEY5,
  HEXEN_MT_KEY6,
  HEXEN_MT_KEY7,
  HEXEN_MT_KEY8,
  HEXEN_MT_KEY9,
  HEXEN_MT_KEYA,
  HEXEN_MT_KEYB,
  HEXEN_MT_SOUNDWIND,
  HEXEN_MT_SOUNDWATERFALL,
  HEXEN_MT_ETTIN,
  HEXEN_MT_ETTIN_MACE,
  HEXEN_MT_FIREDEMON,
  HEXEN_MT_FIREDEMON_SPLOTCH1,
  HEXEN_MT_FIREDEMON_SPLOTCH2,
  HEXEN_MT_FIREDEMON_FX1,
  HEXEN_MT_FIREDEMON_FX2,
  HEXEN_MT_FIREDEMON_FX3,
  HEXEN_MT_FIREDEMON_FX4,
  HEXEN_MT_FIREDEMON_FX5,
  HEXEN_MT_FIREDEMON_FX6,
  HEXEN_MT_ICEGUY,
  HEXEN_MT_ICEGUY_FX,
  HEXEN_MT_ICEFX_PUFF,
  HEXEN_MT_ICEGUY_FX2,
  HEXEN_MT_ICEGUY_BIT,
  HEXEN_MT_ICEGUY_WISP1,
  HEXEN_MT_ICEGUY_WISP2,
  HEXEN_MT_FIGHTER_BOSS,
  HEXEN_MT_CLERIC_BOSS,
  HEXEN_MT_MAGE_BOSS,
  HEXEN_MT_SORCBOSS,
  HEXEN_MT_SORCBALL1,
  HEXEN_MT_SORCBALL2,
  HEXEN_MT_SORCBALL3,
  HEXEN_MT_SORCFX1,
  HEXEN_MT_SORCFX2,
  HEXEN_MT_SORCFX2_T1,
  HEXEN_MT_SORCFX3,
  HEXEN_MT_SORCFX3_EXPLOSION,
  HEXEN_MT_SORCFX4,
  HEXEN_MT_SORCSPARK1,
  HEXEN_MT_BLASTEFFECT,
  HEXEN_MT_WATER_DRIP,
  HEXEN_MT_KORAX,
  HEXEN_MT_KORAX_SPIRIT1,
  HEXEN_MT_KORAX_SPIRIT2,
  HEXEN_MT_KORAX_SPIRIT3,
  HEXEN_MT_KORAX_SPIRIT4,
  HEXEN_MT_KORAX_SPIRIT5,
  HEXEN_MT_KORAX_SPIRIT6,
  HEXEN_MT_DEMON_MASH,
  HEXEN_MT_DEMON2_MASH,
  HEXEN_MT_ETTIN_MASH,
  HEXEN_MT_CENTAUR_MASH,
  HEXEN_MT_KORAX_BOLT,
  HEXEN_MT_BAT_SPAWNER,
  HEXEN_MT_BAT,
  HEXEN_NUMMOBJTYPES,

  TOTAL_NUMMOBJTYPES = HEXEN_NUMMOBJTYPES
} mobjtype_t;

typedef enum {
  IG_DEFAULT,
  IG_END
} infighting_group_t;

typedef enum {
  PG_GROUPLESS = -1,
  PG_DEFAULT,
  PG_BARON,
  PG_END
} projectile_group_t;

typedef enum {
  SG_DEFAULT,
  SG_END
} splash_group_t;

/********************************************************************
 * Definition of the Thing structure
 ********************************************************************/
/* Note that these are only indices to the state, sound, etc. arrays
 * and not actual pointers.  Most can be set to zero if the action or
 * sound doesn't apply (like lamps generally don't attack or whistle).
 */

typedef struct
{
  int doomednum;    /* Thing number used in id's editor, and now
       probably by every other editor too */
  int spawnstate;   /* The state (frame) index when this Thing is
           first created */
  int spawnhealth;  /* The initial hit points for this Thing */
  int seestate;     /* The state when it sees you or wakes up */
  int seesound;     /* The sound it makes when waking */
  int reactiontime; /* How many tics it waits after it wakes up
           before it will start to attack, in normal
           skills (halved for nightmare) */
  int attacksound;  /* The sound it makes when it attacks */
  int painstate;    /* The state to indicate pain */
  int painchance;   /* A number that is checked against a random
           number 0-255 to see if the Thing is supposed
           to go to its painstate or not.  Note this
           has absolutely nothing to do with the chance
           it will get hurt, just the chance of it
           reacting visibly. */
  int painsound;    /* The sound it emits when it feels pain */
  int meleestate;   /* Melee==close attack */
  int missilestate; /* What states to use when it's in the air, if
           in fact it is ever used as a missile */
  int deathstate;   /* What state begins the death sequence */
  int xdeathstate;  /* What state begins the horrible death sequence
           like when a rocket takes out a trooper */
  int deathsound;   /* The death sound.  See also A_Scream() in
           p_enemy.c for some tweaking that goes on
           for certain monsters */
  int speed;        /* How fast it moves.  Too fast and it can miss
           collision logic. */
  int radius;       /* An often incorrect radius */
  int height;       /* An often incorrect height, used only to see
           if a monster can enter a sector */
  int mass;         /* How much an impact will move it.  Cacodemons
           seem to retreat when shot because they have
           very little mass and are moved by impact */
  int damage;       /* If this is a missile, how much does it hurt? */
  int activesound;  /* What sound it makes wandering around, once
           in a while.  Chance is 3/256 it will. */
  uint64_t flags;  /* Bit masks for lots of things.  See p_mobj.h */

  // not in heretic
  int raisestate;   /* The first state for an Archvile or respawn
           resurrection.  Zero means it won't come
           back to life. */
  mobjtype_t droppeditem; /* ferk: Mobj to drop after death */

  // heretic
  int crashstate;
  uint64_t flags2;

  // mbf21
  int infighting_group;
  int projectile_group;
  int splash_group;
  int ripsound;
  int altspeed;
  int meleerange;

  // misc
  int bloodcolor;
  int visibility;
} mobjinfo_t;

#define NO_ALTSPEED -1

typedef struct
{
    int doomednum;
    int spawnstate;
    int spawnhealth;
    int seestate;
    int seesound;
    int reactiontime;
    int attacksound;
    int painstate;
    int painchance;
    int painsound;
    int meleestate;
    int missilestate;
    int deathstate;
    int xdeathstate;
    int deathsound;
    int speed;
    int radius;
    int height;
    int mass;
    int damage;
    int activesound;
    uint64_t flags;
    int raisestate;
    mobjtype_t droppeditem;
} doom_mobjinfo_t;

typedef struct
{
    int doomednum;
    int spawnstate;
    int spawnhealth;
    int seestate;
    int seesound;
    int reactiontime;
    int attacksound;
    int painstate;
    int painchance;
    int painsound;
    int meleestate;
    int missilestate;
    int crashstate;
    int deathstate;
    int xdeathstate;
    int deathsound;
    int speed;
    int radius;
    int height;
    int mass;
    int damage;
    int activesound;
    uint64_t flags;
    uint64_t flags2;
} raven_mobjinfo_t;

// all the stuff - dynamically selected in global.c

extern state_t heretic_states[HERETIC_NUMSTATES];
extern const char *heretic_sprnames[];
extern raven_mobjinfo_t heretic_mobjinfo[HERETIC_NUMMOBJTYPES];

extern state_t hexen_states[HEXEN_NUMSTATES];
extern const char *hexen_sprnames[];
extern raven_mobjinfo_t hexen_mobjinfo[HEXEN_NUMMOBJTYPES];

extern state_t doom_states[DOOM_NUMSTATES];
extern const char *doom_sprnames[];
extern doom_mobjinfo_t doom_mobjinfo[DOOM_NUMMOBJTYPES];

extern state_t* states;
extern int num_states;
extern const char** sprnames;
extern int num_sprites;
extern mobjinfo_t* mobjinfo;
extern int num_mobj_types;
extern int mobj_types_zero;
extern int mobj_types_max;

// zdoom

#define ZMT_UNDEFINED -2

extern int ZMT_MAPSPOT;
extern int ZMT_MAPSPOT_GRAVITY;
extern int ZMT_TELEPORTDEST2;
extern int ZMT_TELEPORTDEST3;

#endif
