<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.4

The 3.4 release is the first in a planned series that will be addressing schema
generation, hypermedia support, API clients, and finally realtime support.

---

## Funding

The 3.4 release has been made possible a recent [Mozilla grant][moss], and by our
[collaborative funding model][funding]. If you use REST framework commercially, and would
like to see this work continue, we strongly encourage you to invest in its
continued development by **[signing up for a paid plan][funding]**.

The initial aim is to provide a single full-time position on REST framework.
Right now we're over 60% of the way towards achieving that.
*Every single sign-up makes a significant impact.*

<ul class="premium-promo promo">
    <li><a href="http://jobs.rover.com/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rover_130x130.png)">Rover.com</a></li>
    <li><a href="https://getsentry.com/welcome/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/sentry130.png)">Sentry</a></li>
    <li><a href="https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/stream-130.png)">Stream</a></li>
</ul>
<div style="clear: both; padding-bottom: 20px;"></div>

*Many thanks to all our [awesome sponsors][sponsors], and in particular to our premium backers, [Rover](http://jobs.rover.com/), [Sentry](https://getsentry.com/welcome/), and [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf).*

---

## Schemas & client libraries

REST framework 3.4 brings built-in support for generating API schemas.

We provide this support by using [Core API][core-api], a Document Object Model
for describing APIs.

Because Core API represents the API schema in an format-independent
manner, we're able to render the Core API `Document` object into many different
schema formats, by allowing the renderer class to determine how the internal
representation maps onto the external schema format.

This approach should also open the door to a range of auto-generated API
documentation options in the future, by rendering the `Document` object into
HTML documentation pages.

Alongside the built-in schema support, we're also now providing the following:

* A [command line tool][command-line-client] for interacting with APIs.
* A [Python client library][client-library] for interacting with APIs.

These API clients are dynamically driven, and able to interact with any API
that exposes a supported schema format.

Dynamically driven clients allow you to interact with an API at an application
layer interface, rather than a network layer interface, while still providing
the benefits of RESTful Web API design.

We're expecting to expand the range of languages that we provide client libraries
for over the coming months.

Further work on maturing the API schema support is also planned, including
documentation on supporting file upload and download, and improved support for
documentation generation and parameter annotation.

---

Current support for schema formats is as follows:

Name                             | Support                             | PyPI package
---------------------------------|-------------------------------------|--------------------------------
[Core JSON][core-json]           | Schema generation & client support. | Built-in support in `coreapi`.
[Swagger / OpenAPI][swagger]     | Schema generation & client support. | The `openapi-codec` package.
[JSON Hyper-Schema][hyperschema] | Currrently client support only.     | The `hyperschema-codec` package.
[API Blueprint][api-blueprint]   | Not yet available.                  | Not yet available.

---

You can read more about any of this new functionality in the following:

* New tutorial section on [schemas & client libraries][tut-7].
* Documentation page on [schema generation][schema-generation].
* Topic page on [API clients][api-clients].

It is also worth noting that Marc Gibbons is currently working towards a 2.0 release of
the popular Django REST Swagger package, which will tie in with our new built-in support.

---

## Supported versions

The 3.4.0 release adds support for Django 1.10.

The following versions of Python and Django are now supported:

* Django versions 1.8, 1.9, and 1.10.
* Python versions 2.7, 3.2(\*), 3.3(\*), 3.4, 3.5.

(\*) Note that Python 3.2 and 3.3 are not supported from Django 1.9 onwards.

---

## Deprecations and changes

The 3.4 release includes very limited deprecation or behavioral changes, and
should present a straightforward upgrade.

### Use fields or exclude on serializer classes.

The following change in 3.3.0 is now escalated from "pending deprecation" to
"deprecated". Its usage will continue to function but will raise warnings:

`ModelSerializer` and `HyperlinkedModelSerializer` should include either a `fields`
option, or an `exclude` option. The `fields = '__all__'` shortcut may be used
to explicitly include all fields.

### Microsecond precision when returning time or datetime.

Using the default JSON renderer and directly returning a `datetime` or `time`
instance will now render with microsecond precision (6 digits), rather than
millisecond precision (3 digits). This makes the output format consistent with the
default string output of `serializers.DateTimeField` and `serializers.TimeField`.

This change *does not affect the default behavior when using serializers*,
which is to serialize `datetime` and `time` instances into strings with
microsecond precision.

The serializer behavior can be modified if needed, using the `DATETIME_FORMAT`
and `TIME_FORMAT` settings.

The renderer behavior can be modified by setting a custom `encoder_class`
attribute on a `JSONRenderer` subclass.

### Relational choices no longer displayed in OPTIONS requests.

Making an `OPTIONS` request to views that have a serializer choice field
will result in a list of the available choices being returned in the response.

In cases where there is a relational field, the previous behavior would be
to return a list of available instances to choose from for that relational field.

In order to minimise exposed information the behavior now is to *not* return
choices information for relational fields.

If you want to override this new behavior you'll need to [implement a custom
metadata class][metadata].

See [issue #3751][gh3751] for more information on this behavioral change.

---

## Other improvements

This release includes further work from a huge number of [pull requests and issues][milestone].

Many thanks to all our contributors who've been involved in the release, either through raising issues, giving feedback, improving the documentation, or suggesting and implementing code changes.

The full set of itemized release notes [are available here][release-notes].

[sponsors]: https://fund.django-rest-framework.org/topics/funding/#our-sponsors
[moss]: mozilla-grant.md
[funding]: funding.md
[core-api]: http://www.coreapi.org/
[command-line-client]: api-clients#command-line-client
[client-library]: api-clients#python-client-library
[core-json]: http://www.coreapi.org/specification/encoding/#core-json-encoding
[swagger]: https://openapis.org/specification
[hyperschema]: http://json-schema.org/latest/json-schema-hypermedia.html
[api-blueprint]: https://apiblueprint.org/
[tut-7]: ../../tutorial/7-schemas-and-client-libraries/
[schema-generation]: ../../api-guide/schemas/
[api-clients]: api-clients.md
[milestone]: https://github.com/tomchristie/django-rest-framework/milestone/35
[release-notes]: release-notes#34
[metadata]: ../../api-guide/metadata/#custom-metadata-classes
[gh3751]: https://github.com/tomchristie/django-rest-framework/issues/3751
