# DH Sequence for pd-lib-builder.

## no critic (Modules::RequireExplicitPackage)

use warnings;
use strict;
use autodie;

use Debian::Debhelper::Dh_Lib;

# Build with pd-lib-builder buildsystem by default
add_command_options("dh_auto_clean", "--buildsystem=pd_lib_builder");
add_command_options("dh_auto_build", "--buildsystem=pd_lib_builder");
add_command_options("dh_auto_test", "--buildsystem=pd_lib_builder");
add_command_options("dh_auto_install", "--buildsystem=pd_lib_builder");

# Exclude pd documentation from dh_compress by default
add_command_options("dh_compress",
    qw(-X.pd -XLICENSE.txt));

# generate ${puredata:Depends} and friends
insert_before ("dh_installdeb", "dh_puredata_substvar");

1;
