# Copyright 2021-2022 The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Notifications (using channels) used in the application."""

from asgiref.sync import async_to_sync

from channels.layers import get_channel_layer


def notify_work_request_assigned(work_request):
    """Send a channel message of type 'work_request_assigned'."""
    if work_request.worker is None:
        return

    async_to_sync(get_channel_layer().group_send)(
        work_request.worker.token.key,
        {"type": "work_request.assigned"},
    )


def notify_worker_token_disabled(token):
    """Notify to the WorkerConsumer that a worker has been disabled."""
    if not hasattr(token, "worker"):
        return

    async_to_sync(get_channel_layer().group_send)(
        token.key, {"type": "worker.disabled"}
    )
