# Copyright 2021 The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""debusine-admin command to list tokens. Allows filtering."""

from debusine.db.models import Token
from debusine.server.management.debusine_base_command import DebusineBaseCommand
from debusine.server.management.utils import print_tokens


class Command(DebusineBaseCommand):
    """Command to list tokens."""

    help = "List tokens. See the options to filter which tokens will be listed"

    def add_arguments(self, parser):
        """Add CLI arguments for the list_tokens command."""
        parser.add_argument('--token', help='List only this token')
        parser.add_argument('--owner', help='List tokens owner by {owner}')

    def handle(self, *args, **options):
        """List the tokens."""
        tokens = Token.objects.get_tokens(
            owner=options['owner'], key=options['token']
        )
        print_tokens(self.stdout, tokens=tokens)
