# Copyright 2021 The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""debusine-admin command to create tokens."""

from debusine.db.models import Token
from debusine.server.management.debusine_base_command import DebusineBaseCommand


class Command(DebusineBaseCommand):
    """Command to aggregate other sub-commands from different applications."""

    help = "Create a new, enabled token to be used by a Debusine client"

    def add_arguments(self, parser):
        """Add CLI arguments for the create-token command."""
        parser.add_argument('owner', help='Owner (free text)')
        parser.add_argument(
            '--comment',
            default='',
            help='Reason for the creation of this token',
        )

    def handle(self, *args, **options):
        """Create the token."""
        token = Token.objects.create(
            owner=options['owner'], comment=options['comment']
        )
        token.enable()
        self.stdout.write(token.key)
